/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.ISplitData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class BgNDataInfo
implements IBgNData,
ISplitData,
Serializable {
    private static final long serialVersionUID = 7695123375751690634L;
    public static final int DEFAULT_DATA_STATE = 0;
    private String sheetName = null;
    private int row = 0;
    private int col = 0;
    private int state = 0;
    private int formType;
    private String bgDataId = null;
    private String formula = null;
    private BigDecimal budgetValue = null;
    private BigDecimal actualValue = null;
    private BigDecimal addActualValue = null;
    private BigDecimal bizActual = null;
    private BigDecimal balance = null;
    private BigDecimal adjustValue = null;
    private Timestamp updateTime;
    private int dataSource = 0;
    private String bgAdjustDataID;
    private String bgItemId = null;
    private String bgItemNumber = null;
    private String bgPeriodId = null;
    private String bgPeriodNumber = null;
    private String bgElementId = null;
    private String bgElementNumber = null;
    private String currencyId = null;
    private String currencyNumber = null;
    private String adjustReason = null;
    private String adjustor = null;
    private Date adjustDate = null;
    private String orgUnitId = null;
    private Object userObject = null;
    private boolean isSplit = false;
    private transient String bgIndexNum = null;
    private BigDecimal tmpValue = null;
    private String bgFormId = null;
    private BigDecimal oldValue = null;
    private String bgScenario = null;
    private String bgVersion = null;
    private boolean isCanSave = true;
    private BigDecimal transitBudget = BigDecimal.ZERO;

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRow() {
        return this.row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    @Override
    public void setBgDataId(String bgDataId) {
        this.bgDataId = bgDataId;
    }

    @Override
    public String getBgDataId() {
        return this.bgDataId;
    }

    @Override
    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public void setBudgetValue(BigDecimal budgetValue) {
        this.budgetValue = budgetValue;
    }

    @Override
    public BigDecimal getBudgetValue() {
        if (this.budgetValue == null) {
            return BgNConstants.ZERO;
        }
        return this.budgetValue;
    }

    @Override
    public BigDecimal getValue() {
        return this.getBudgetValueNoDef();
    }

    @Override
    public BigDecimal getBudgetValueNoDef() {
        return this.budgetValue;
    }

    @Override
    public void setActualValue(BigDecimal actualValue) {
        this.actualValue = actualValue;
    }

    @Override
    public BigDecimal getActualValue() {
        if (this.actualValue == null) {
            return BgNConstants.ZERO;
        }
        return this.actualValue;
    }

    @Override
    public BigDecimal getActualValueNoDef() {
        return this.actualValue;
    }

    @Override
    public void setAddActualValue(BigDecimal addActualValue) {
        this.addActualValue = addActualValue;
    }

    @Override
    public BigDecimal getAddActualValue() {
        if (this.addActualValue == null) {
            return BgNConstants.ZERO;
        }
        return this.addActualValue;
    }

    @Override
    public BigDecimal getAddActualNoDef() {
        return this.addActualValue;
    }

    @Override
    public void setBizActual(BigDecimal bizActual) {
        this.bizActual = bizActual;
    }

    @Override
    public BigDecimal getBizActual() {
        if (this.bizActual == null) {
            return BgNConstants.ZERO;
        }
        return this.bizActual;
    }

    @Override
    public BigDecimal getBizActualNoDef() {
        return this.bizActual;
    }

    @Override
    public void setBalance(BigDecimal value) {
        this.balance = value;
    }

    @Override
    public BigDecimal getBalance() {
        if (this.balance == null) {
            this.balance = BgNConstants.ZERO;
        }
        return this.balance;
    }

    @Override
    public void setAdjustValue(BigDecimal adjustValue) {
        this.adjustValue = adjustValue;
    }

    @Override
    public BigDecimal getAdjustValue() {
        return this.adjustValue;
    }

    public void setBgItemId(String bgItemId) {
        this.bgItemId = bgItemId;
    }

    public String getBgItemId() {
        return this.bgItemId;
    }

    @Override
    public void setBgItemNumber(String bgItemNumber) {
        this.bgItemNumber = bgItemNumber;
    }

    @Override
    public String getBgItemNumber() {
        return this.bgItemNumber;
    }

    @Override
    public String getDimItemNumber() {
        return this.bgItemNumber;
    }

    public void setBgPeriodId(String bgPeriodId) {
        this.bgPeriodId = bgPeriodId;
    }

    public String getBgPeriodId() {
        return this.bgPeriodId;
    }

    @Override
    public void setBgPeriodNumber(String bgPeriodNumber) {
        this.bgPeriodNumber = bgPeriodNumber;
    }

    @Override
    public String getBgPeriodNumber() {
        return this.bgPeriodNumber;
    }

    public void setBgElementId(String bgElementId) {
        this.bgElementId = bgElementId;
    }

    public String getBgElementId() {
        return this.bgElementId;
    }

    @Override
    public void setBgElementNumber(String bgElementNumber) {
        this.bgElementNumber = bgElementNumber;
    }

    @Override
    public String getBgElementNumber() {
        return this.bgElementNumber;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    @Override
    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    @Override
    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    public int getFormType() {
        return this.formType;
    }

    public void setFormType(int formType) {
        this.formType = formType;
    }

    public String getAdjustReason() {
        return this.adjustReason;
    }

    public void setAdjustReason(String adjustReason) {
        this.adjustReason = adjustReason;
    }

    public String getAdjustor() {
        return this.adjustor;
    }

    public void setAdjustor(String adjustor) {
        this.adjustor = adjustor;
    }

    public Date getAdjustDate() {
        return this.adjustDate;
    }

    public void setAdjustDate(Date adjustDate) {
        this.adjustDate = adjustDate;
    }

    @Override
    public void splitFormula() {
        if (!this.isSplit && !StringUtils.isEmpty((String)this.formula)) {
            String[] formulas = BgNFSHelper.parseFormulaPara(this.formula);
            this.bgItemNumber = formulas[0];
            this.bgElementNumber = formulas[2];
            this.bgPeriodNumber = formulas[1];
            this.currencyNumber = formulas[5];
            this.bgScenario = formulas[3];
            this.isSplit = true;
        }
    }

    @Override
    public void copyValue(IBgNData newValue) {
        if (newValue instanceof BgNDataInfo) {
            BgNDataInfo nValue = (BgNDataInfo)newValue;
            if (nValue.budgetValue != null) {
                this.setBudgetValue(nValue.budgetValue);
            }
            if (nValue.actualValue != null) {
                this.setActualValue(nValue.actualValue);
            }
            if (nValue.addActualValue != null) {
                this.setAddActualValue(nValue.addActualValue);
            }
            if (nValue.bizActual != null) {
                this.setBizActual(nValue.bizActual);
            }
            if (nValue.balance != null) {
                this.setBalance(nValue.balance);
            }
            if (nValue.adjustValue != null) {
                this.setAdjustValue(nValue.adjustValue);
            }
        }
    }

    public boolean compareValue(BigDecimal newValue, BigDecimal oldValue) {
        if (newValue == oldValue || newValue == null && oldValue == null) {
            return true;
        }
        return newValue != null && oldValue != null && newValue.compareTo(oldValue) == 0;
    }

    public void setBgIndexNum(String bgIndexNum) {
        this.bgIndexNum = bgIndexNum;
    }

    public String getBgIndexNum() {
        return this.bgIndexNum;
    }

    public BigDecimal getTmpValue() {
        return this.tmpValue;
    }

    public void setTmpValue(BigDecimal tmpValue) {
        this.tmpValue = tmpValue;
    }

    public void setBgFormId(String bgFormId) {
        this.bgFormId = bgFormId;
    }

    public String getBgFormId() {
        return this.bgFormId;
    }

    public BigDecimal getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(BigDecimal oldValue) {
        this.oldValue = oldValue;
    }

    public String getBgAdjustDataID() {
        return this.bgAdjustDataID;
    }

    public void setBgAdjustDataID(String bgAdjustDataID) {
        this.bgAdjustDataID = bgAdjustDataID;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    @Override
    public void setBgScenario(String bgScenario) {
        this.bgScenario = bgScenario;
    }

    @Override
    public String getBgScenario() {
        return this.bgScenario;
    }

    @Override
    public void setBgVersion(String bgVersion) {
        this.bgVersion = bgVersion;
    }

    @Override
    public String getBgVersion() {
        return this.bgVersion;
    }

    @Override
    public void setCanSave(boolean isCanSave) {
        this.isCanSave = isCanSave;
    }

    @Override
    public boolean isCanSave() {
        return this.isCanSave;
    }

    @Override
    public ICalcData toCalcData(Map<String, IObjectValue> scenarioMap, Map<String, IObjectValue> versionMap, int valueType) {
        BgScenarioInfo scenario;
        if (scenarioMap == null || versionMap == null) {
            return null;
        }
        this.splitFormula();
        BizCalcData calcData = new BizCalcData();
        calcData.setOrgUnitId(this.getOrgUnitId());
        calcData.setFormula(this.getFormula());
        calcData.setBgScenarioNumber(this.getBgScenario());
        calcData.setBgIndexNumber(this.getBgIndexNum());
        calcData.setDimNumber(this.getBgItemNumber());
        calcData.setBgPeriodNumber(this.getBgPeriodNumber());
        calcData.setBgElementNumber(this.getBgElementNumber());
        calcData.setCurrencyNumber(this.getCurrencyNumber());
        calcData.setBgVersionNumber(this.getBgVersion());
        calcData.setBgDataSource(this.getBgDataSource());
        if (scenarioMap.containsKey(calcData.getBgScenarioNumber()) && (scenario = (BgScenarioInfo)scenarioMap.get(calcData.getBgScenarioNumber())) != null) {
            calcData.setBgScenario(scenario.getScenarioId());
            int type = scenario.getType().getValue();
            if (0 == type) {
                calcData.setValue(this.getBudgetValueNoDef());
            } else if (1 == type) {
                if (valueType == 16 || valueType == 32 || valueType == 2048) {
                    calcData.setValue(this.getAddActualNoDef());
                } else {
                    calcData.setValue(this.getBizActualNoDef());
                }
            }
        }
        if (versionMap.containsKey(calcData.getBgVersionNumber())) {
            BgVersionInfo version = (BgVersionInfo)versionMap.get(calcData.getBgVersionNumber());
            calcData.setBgVersion(version.getVersionId());
        }
        return calcData;
    }

    public String toString() {
        if (this.getState() == 5) {
            return String.valueOf(this.getAdjustValue());
        }
        if (this.getAddActualValue() != BgNConstants.ZERO) {
            return String.valueOf(this.getAddActualValue());
        }
        if (this.getBizActual() != BgNConstants.ZERO) {
            return String.valueOf(this.getBizActual());
        }
        return String.valueOf(this.getBudgetValue());
    }

    @Override
    public int getBgDataSource() {
        return this.dataSource;
    }

    @Override
    public void setBgDataSource(int bgDataSource) {
        this.dataSource = bgDataSource;
    }

    @Override
    public BigDecimal getTransitBudget() {
        return this.transitBudget;
    }

    @Override
    public void setTransitBudget(BigDecimal transitBudget) {
        this.transitBudget = transitBudget;
    }
}

