/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgPeriodDecomposeUI;
import com.kingdee.eas.ma.mbg.common.IDimensionColumn;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgPeriodDecomposeUtils {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource";

    public static List<BgPeriodTypeInfo> queryBgPeriodTypes(Set<String> typeSet, SortType sortType) throws BOSException {
        if (typeSet == null || typeSet.isEmpty()) {
            return null;
        }
        ArrayList<BgPeriodTypeInfo> typeLst = new ArrayList<BgPeriodTypeInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", typeSet, CompareType.INCLUDE));
        view.setSorter(new SorterItemCollection());
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(sortType);
        view.getSorter().add(sort);
        BgPeriodTypeCollection typeColls = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(view);
        if (typeColls != null && !typeColls.isEmpty()) {
            for (int i = 0; i < typeColls.size(); ++i) {
                typeLst.add(typeColls.get(i));
            }
        }
        return typeLst;
    }

    public static Set<String> getBgPeriodTypeNumsByNumbers(Set<String> bgPeriodNumbers) {
        String number2 = null;
        String typeNum = null;
        HashSet<String> typeSet = new HashSet<String>();
        for (String number2 : bgPeriodNumbers) {
            typeNum = number2.substring(0, 4);
            typeSet.add(typeNum);
        }
        return typeSet;
    }

    public static Set<String> getBgPeriodTypeNumsByFormulas(Set<String> formulas) {
        String formulaStr2 = null;
        String number = null;
        String typeNum = null;
        HashSet<String> typeSet = new HashSet<String>();
        for (String formulaStr2 : formulas) {
            number = BgNFSHelper.parseFormulaPara(formulaStr2)[1];
            typeNum = number.substring(0, 4);
            typeSet.add(typeNum);
        }
        return typeSet;
    }

    public static Set<String> getBgScenarioNumsByFormulas(Set<String> formulas) {
        String formulaStr2 = null;
        String number = null;
        HashSet<String> numbers = new HashSet<String>();
        for (String formulaStr2 : formulas) {
            number = BgNFSHelper.parseFormulaPara(formulaStr2)[3];
            numbers.add(number);
        }
        return numbers;
    }

    public static Set<String> getBgElementNumsByFormulas(Set<String> formulas) {
        String formulaStr2 = null;
        String number = null;
        HashSet<String> numbers = new HashSet<String>();
        for (String formulaStr2 : formulas) {
            number = BgNFSHelper.parseFormulaPara(formulaStr2)[2];
            numbers.add(number);
        }
        return numbers;
    }

    public static Set<String> getBgPeriodNumsByFormulas(Set<String> formulas) {
        String formulaStr2 = null;
        String number = null;
        HashSet<String> bgPeriodNums = new HashSet<String>();
        for (String formulaStr2 : formulas) {
            number = BgNFSHelper.parseFormulaPara(formulaStr2)[1];
            bgPeriodNums.add(number);
        }
        return bgPeriodNums;
    }

    public static Set<String> getFormulaSetOfBook(Book book) {
        HashSet<String> formulas = new HashSet<String>();
        if (book == null) {
            return formulas;
        }
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            formulas.addAll(BgPeriodDecomposeUtils.getFormulasBySheet(book.getSheet(sheetIndex)));
        }
        return formulas;
    }

    public static Set<String> getFormulasBySheet(Sheet sheet) {
        HashSet<String> formulas = new HashSet<String>();
        String formulaStr = null;
        Cell cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int r = 0; r <= rowCount; ++r) {
            for (int c = 0; c <= colCount; ++c) {
                cell = sheet.getCell(r, c, false);
                if (!BgNFSHelper.checkHasItemFormula(cell)) continue;
                formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                formulas.add(formulaStr);
            }
        }
        return formulas;
    }

    public static Set<String> getPageMemberNums(IMbgViewBase viewManager, String dimNumber) {
        HashSet<String> numbers = null;
        List<? extends IMbgSheetBase> sheetManagers = viewManager.getSheetManagers();
        for (int index = 0; index < sheetManagers.size(); ++index) {
            List pageDims = sheetManagers.get(index).getDimensionManager().getPageDisplayDimension();
            if (pageDims.isEmpty()) continue;
            for (int i = 0; i < pageDims.size(); ++i) {
                BgDimensionBaseInfo dimInfo = (BgDimensionBaseInfo)pageDims.get(i);
                List members = dimInfo.getMember();
                if (members == null || members.isEmpty() || !dimInfo.getNumber().equals(dimNumber)) continue;
                if (numbers == null) {
                    numbers = new HashSet<String>();
                }
                for (int j = 0; j < members.size(); ++j) {
                    if (numbers.contains(((BgDimensionMember)members.get(j)).getNumber())) continue;
                    numbers.add(((BgDimensionMember)members.get(j)).getNumber());
                }
            }
        }
        return numbers;
    }

    public static Set<String> getPageMemberNums(List pageDims, String dimNumber) {
        HashSet<String> numbers = null;
        if (!pageDims.isEmpty()) {
            for (int i = 0; i < pageDims.size(); ++i) {
                BgDimensionBaseInfo dimInfo = (BgDimensionBaseInfo)pageDims.get(i);
                List members = dimInfo.getMember();
                if (members == null || members.isEmpty() || !dimInfo.getNumber().equals(dimNumber)) continue;
                numbers = new HashSet<String>();
                for (int j = 0; j < members.size(); ++j) {
                    numbers.add(((BgDimensionMember)members.get(j)).getNumber());
                }
            }
        }
        return numbers;
    }

    public static void movePageDimensionsToRow(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return;
        }
        MbgViewListDimensionInfo dim = null;
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        List pageDimensions = dimensionManager.getPageDimension();
        List rowDimensions = dimensionManager.getRowDimension();
        HashMap nodimensionMap = new HashMap();
        for (int i = 0; i < rowDimensions.size(); ++i) {
            if (rowDimensions.get(i) instanceof MbgViewListDimensionInfo) {
                dim = (MbgViewListDimensionInfo)rowDimensions.get(i);
                continue;
            }
            String dimNumber = "000000000000000000000000000=";
            if (dim != null) {
                dimNumber = dim.getNumber();
            }
            if (!nodimensionMap.containsKey(dimNumber)) {
                nodimensionMap.put(dimNumber, new ArrayList());
            }
            ((List)nodimensionMap.get(dimNumber)).add(rowDimensions.get(i));
        }
        if (!pageDimensions.isEmpty()) {
            ArrayList<MbgViewListDimensionInfo> newDims = null;
            MbgViewListDimensionInfo cloneDim = null;
            for (int i = 0; i < rows.size(); ++i) {
                if (rows.get(i) instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(i);
                    newDims = new ArrayList<MbgViewListDimensionInfo>();
                    for (int j = 0; j < pageDimensions.size(); ++j) {
                        dim = (MbgViewListDimensionInfo)pageDimensions.get(j);
                        if (dim != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                        cloneDim = dim.clone();
                        cloneDim.getMember().clear();
                        cloneDim.getMember().addAll(dim.getMember());
                        newDims.add(cloneDim);
                    }
                    newDims.addAll(rowObj.getDimensions());
                    rowObj.getDimensions().clear();
                    rowObj.getDimensions().addAll(newDims);
                }
                if (newDims == null) continue;
                rowDimensions.clear();
                if (nodimensionMap.containsKey("000000000000000000000000000=")) {
                    rowDimensions.addAll((Collection)nodimensionMap.get("000000000000000000000000000="));
                }
                for (int d = 0; d < newDims.size(); ++d) {
                    dim = (MbgViewListDimensionInfo)newDims.get(d);
                    rowDimensions.add(dim);
                    if (!nodimensionMap.containsKey(dim.getNumber())) continue;
                    rowDimensions.addAll((Collection)nodimensionMap.get(dim.getNumber()));
                }
            }
            for (int k = pageDimensions.size() - 1; k >= 0; --k) {
                dim = (MbgViewListDimensionInfo)pageDimensions.get(k);
                if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                pageDimensions.remove(dim);
            }
        }
    }

    public static void movePageDimensionsToRow(IBgDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return;
        }
        int pvCount = -1;
        int orgIndex = -1;
        ArrayList<IDimensionColumn> otherColumns = new ArrayList<IDimensionColumn>();
        IDimensionColumn otherColumn = null;
        pvCount = dimensionManager.getViewDisplayDimension().size() + dimensionManager.getPageDisplayDimension().size();
        orgIndex = -1;
        ArrayList viewDisplayDimension = new ArrayList(dimensionManager.getViewDisplayDimension());
        ArrayList pageDisplayDimension = new ArrayList(dimensionManager.getPageDisplayDimension());
        ArrayList rowDisplayDimension = new ArrayList(dimensionManager.getRowDisplayDimension());
        dimensionManager.getPageDisplayDimension().clear();
        dimensionManager.getRowDisplayDimension().clear();
        dimensionManager.getRowDisplayDimension().addAll(viewDisplayDimension);
        dimensionManager.getRowDisplayDimension().addAll(pageDisplayDimension);
        dimensionManager.getRowDisplayDimension().addAll(rowDisplayDimension);
        List newRows = dimensionManager.getRowDisplayDimension();
        BgDimensionInfo info = null;
        for (int i = newRows.size() - 1; i >= 0; --i) {
            info = (BgDimensionInfo)newRows.get(i);
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(info.getNumber())) continue;
            newRows.remove(info);
            orgIndex = i;
            dimensionManager.getViewDisplayDimension().add(info);
        }
        otherColumns.clear();
        otherColumns.addAll(dimensionManager.getAttributeCol());
        otherColumns.addAll(dimensionManager.getCalcuteCol());
        otherColumns.addAll(dimensionManager.getDescriptionCol());
        for (int o = 0; o < otherColumns.size(); ++o) {
            if (!(otherColumns.get(o) instanceof IDimensionColumn)) continue;
            otherColumn = (IDimensionColumn)otherColumns.get(o);
            otherColumn.setIndex(otherColumn.getIndex() + pvCount);
            if (orgIndex < 0 || otherColumn.getIndex() <= orgIndex) continue;
            otherColumn.setIndex(otherColumn.getIndex() - 1);
        }
    }

    public static Map<String, Map<String, BgDimensionMember>> getViewMembers(Context ctx, BgFormInfo bgForm) throws EASBizException, BOSException {
        IMbgViewBase view = BgPeriodDecomposeUtils.getView(ctx, bgForm);
        return BgPeriodDecomposeUtils.getViewMembers(view, bgForm);
    }

    public static Map<String, Map<String, BgDimensionMember>> getViewMembers(IBgDimensionManagerBase manager, BgFormInfo bgForm) throws EASBizException, BOSException {
        HashMap<String, Map<String, BgDimensionMember>> membersMap;
        block19: {
            List colDims;
            BgDimensionBaseInfo dimInfo;
            block18: {
                List pageDims;
                membersMap = new HashMap<String, Map<String, BgDimensionMember>>();
                dimInfo = null;
                List viewDims = manager.getViewDimension();
                if (viewDims != null && !viewDims.isEmpty()) {
                    for (int m = 0; m < viewDims.size(); ++m) {
                        dimInfo = (BgDimensionBaseInfo)viewDims.get(m);
                        if (dimInfo.getMember().isEmpty()) continue;
                        if (!membersMap.containsKey(dimInfo.getNumber())) {
                            membersMap.put(dimInfo.getNumber(), new HashMap());
                        }
                        ((Map)membersMap.get(dimInfo.getNumber())).putAll(BgPeriodDecomposeUtils.getDimMembers(dimInfo));
                    }
                }
                if ((pageDims = manager.getPageDimension()) != null && !pageDims.isEmpty()) {
                    for (int m = 0; m < pageDims.size(); ++m) {
                        Map<String, BgDimensionMember> mp;
                        dimInfo = (BgDimensionBaseInfo)pageDims.get(m);
                        if (dimInfo.getMember().isEmpty()) continue;
                        if (!membersMap.containsKey(dimInfo.getNumber())) {
                            membersMap.put(dimInfo.getNumber(), new HashMap());
                        }
                        if ((mp = BgPeriodDecomposeUtils.getDimMembers(dimInfo)).isEmpty()) continue;
                        for (String str : mp.keySet()) {
                            ((Map)membersMap.get(dimInfo.getNumber())).put(str, mp.get(str));
                        }
                    }
                }
                if (!bgForm.getFormType().equals((Object)BgTemFormTypeEnum.VIEWLIST)) break block18;
                List<IMbgViewListObject> rowCols = ((MbgViewListDimensionManager)manager).getRowCols();
                IMbgViewListObject rowCol = null;
                MbgViewListRowCol rowColObj = null;
                for (int m = 0; m < rowCols.size(); ++m) {
                    rowCol = rowCols.get(m);
                    if (!(rowCol instanceof MbgViewListRowCol)) continue;
                    rowColObj = (MbgViewListRowCol)rowCol;
                    List<MbgViewListDimensionInfo> rowColDims = rowColObj.getDimensions();
                    for (int n = 0; n < rowColDims.size(); ++n) {
                        Map<String, BgDimensionMember> mp;
                        dimInfo = rowColDims.get(n);
                        if (!membersMap.containsKey(dimInfo.getNumber())) {
                            membersMap.put(dimInfo.getNumber(), new HashMap());
                        }
                        if ((mp = BgPeriodDecomposeUtils.getDimMembers(dimInfo)).isEmpty()) continue;
                        for (String str : mp.keySet()) {
                            ((Map)membersMap.get(dimInfo.getNumber())).put(str, mp.get(str));
                        }
                    }
                }
                break block19;
            }
            List rowDims = manager.getRowDimension();
            if (rowDims != null && !rowDims.isEmpty()) {
                for (int m = 0; m < rowDims.size(); ++m) {
                    Map<String, BgDimensionMember> mp;
                    dimInfo = (BgDimensionBaseInfo)rowDims.get(m);
                    if (!membersMap.containsKey(dimInfo.getNumber())) {
                        membersMap.put(dimInfo.getNumber(), new HashMap());
                    }
                    if ((mp = BgPeriodDecomposeUtils.getDimMembers(dimInfo)).isEmpty()) continue;
                    for (String str : mp.keySet()) {
                        ((Map)membersMap.get(dimInfo.getNumber())).put(str, mp.get(str));
                    }
                }
            }
            if ((colDims = manager.getColDimension()) == null || colDims.isEmpty()) break block19;
            for (int m = 0; m < colDims.size(); ++m) {
                Map<String, BgDimensionMember> mp;
                dimInfo = (BgDimensionBaseInfo)colDims.get(m);
                if (!membersMap.containsKey(dimInfo.getNumber())) {
                    membersMap.put(dimInfo.getNumber(), new HashMap());
                }
                if ((mp = BgPeriodDecomposeUtils.getDimMembers(dimInfo)).isEmpty()) continue;
                for (String str : mp.keySet()) {
                    ((Map)membersMap.get(dimInfo.getNumber())).put(str, mp.get(str));
                }
            }
        }
        return membersMap;
    }

    public static Map<String, Map<String, BgDimensionMember>> getViewMembers(IMbgViewBase view, BgFormInfo bgForm) throws EASBizException, BOSException {
        HashMap<String, Map<String, BgDimensionMember>> membersMap = new HashMap<String, Map<String, BgDimensionMember>>();
        IBgDimensionManagerBase manager = null;
        if (view != null && view.getSheetManagers() != null) {
            int in = view.getSheetManagers().size();
            for (int i = 0; i < in; ++i) {
                manager = view.getSheetManagers().get(i).getDimensionManager();
                Map<String, Map<String, BgDimensionMember>> tmpMap = BgPeriodDecomposeUtils.getViewMembers(manager, bgForm);
                if (tmpMap.isEmpty()) continue;
                for (String dimNum : tmpMap.keySet()) {
                    Map<String, BgDimensionMember> memMap = tmpMap.get(dimNum);
                    if (!membersMap.containsKey(dimNum)) {
                        membersMap.put(dimNum, new HashMap());
                    }
                    for (String key : memMap.keySet()) {
                        BgDimensionMember value = memMap.get(key);
                        ((Map)membersMap.get(dimNum)).put(key, value);
                    }
                }
            }
        }
        return membersMap;
    }

    protected static Map<String, BgDimensionMember> getDimMembers(BgDimensionBaseInfo dimInfo) {
        BgDimensionMember member;
        int n;
        List members = dimInfo.getMember();
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        if (!members.isEmpty()) {
            for (n = 0; n < members.size(); ++n) {
                member = (BgDimensionMember)members.get(n);
                memberMap.put(member.getNumber(), member);
            }
        }
        if (!dimInfo.getSelectMembers().isEmpty()) {
            for (n = 0; n < dimInfo.getSelectMembers().size(); ++n) {
                if (!(dimInfo.getSelectMembers().get(n) instanceof BgDimensionMember) || memberMap.containsKey((member = (BgDimensionMember)dimInfo.getSelectMembers().get(n)).getNumber())) continue;
                memberMap.put(member.getNumber(), member);
            }
        }
        return memberMap;
    }

    public static IMbgViewBase getView(Context ctx, BgFormInfo bgForm) throws BOSException, EASBizException {
        if (ctx == null || bgForm == null) {
            return null;
        }
        BgSchemeInfo bgScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgForm.getBgScheme().getId()), BgCubeUtils.getRefDimSelector());
        IMbgViewBase view = DimensionCommonHelper.getBgFormView(ctx, bgForm);
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            Map result = MBGViewListFormFacadeFactory.getLocalInstance(ctx).initViewListData(bgForm, null, bgScheme.getEditOrgViewId().toString(), (MbgViewListManager)view, null);
            view = (IMbgViewBase)result.get("dimensino.member");
        } else {
            view = MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(bgForm, null, (IMbgViewManager)view, null, bgForm.getOrgUnit().getId().toString(), true, false);
        }
        return view;
    }

    public static Set<String> getMemberNums(Map<String, Map<String, BgDimensionMember>> memberMap, String dimNumber) {
        Map<String, BgDimensionMember> tmpMap;
        HashSet<String> numbers = null;
        if (!memberMap.isEmpty() && memberMap.containsKey(dimNumber) && !(tmpMap = memberMap.get(dimNumber)).isEmpty()) {
            numbers = new HashSet<String>();
            Iterator<BgDimensionMember> ite = tmpMap.values().iterator();
            while (ite.hasNext()) {
                String num = ite.next().getNumber();
                numbers.add(num);
            }
        }
        return numbers;
    }

    public static void mergeBgDecomposeData(CoreUIObject ownerUI, Map<String, Map<String, BgNViewDataInfo>> bgDataMap) {
        Map bgDecMap = null;
        if (ownerUI instanceof IBgPeriodDecomposeUI) {
            bgDecMap = ((IBgPeriodDecomposeUI)ownerUI).getBgDecomposeDataMap();
        }
        if (bgDecMap != null && !bgDecMap.isEmpty()) {
            if (bgDataMap == null) {
                bgDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
            }
            String org2 = null;
            String key2 = null;
            Map tmpMap = null;
            for (String org2 : bgDecMap.keySet()) {
                tmpMap = (Map)bgDecMap.get(org2);
                if (!bgDataMap.containsKey(org2)) {
                    bgDataMap.put(org2, new HashMap());
                }
                for (String key2 : tmpMap.keySet()) {
                    if (!bgDataMap.get(org2).containsKey(key2)) {
                        bgDataMap.get(org2).put(key2, (BgNViewDataInfo)tmpMap.get(key2));
                        continue;
                    }
                    if (((BgNViewDataInfo)tmpMap.get(key2)).getUpdateTime() == null || bgDataMap.get(org2).get(key2) == null || bgDataMap.get(org2).get(key2).getUpdateTime() == null || !((BgNViewDataInfo)tmpMap.get(key2)).getUpdateTime().after(bgDataMap.get(org2).get(key2).getUpdateTime())) continue;
                    bgDataMap.get(org2).put(key2, (BgNViewDataInfo)tmpMap.get(key2));
                }
            }
        }
    }

    public static void clearBgDecomposeDataMap(CoreUIObject ownerUI) {
        if (ownerUI instanceof IBgPeriodDecomposeUI) {
            ((IBgPeriodDecomposeUI)ownerUI).setBgDecomposeDataMap(null);
        }
    }

    public static boolean checkHasBgDecomposeData(CoreUIObject ownerUI) {
        return ownerUI instanceof IBgPeriodDecomposeUI && ((IBgPeriodDecomposeUI)ownerUI).getBgDecomposeDataMap() != null && !((IBgPeriodDecomposeUI)ownerUI).getBgDecomposeDataMap().isEmpty();
    }
}

