/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BgProcessHelper {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgProcessResource";
    public static final String DEF_PROCESS_NAME = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgProcessResource", (String)"bgProcess");
    public static final String DEF_PROCESS_NUMBER = DimensionConstants.DEF_PROCESSTYPE_NUMBER;
    public static final String DEF_PROCESS_SRC = DimensionConstants.DEF_PROCESS_SRCNUMBER;
    public static String DEF_PROCESS_FIELD = DimensionBaseConstants.DEF_PROCESS_FIELD;
    public static Set<String> PROCESS_NUMBERS = new HashSet<String>();

    public static Map<String, Set<BgDimensionMember>> getExistProcessMembers() {
        HashMap<String, Set<BgDimensionMember>> map = new HashMap<String, Set<BgDimensionMember>>();
        HashSet<BgDimensionMember> members = new HashSet<BgDimensionMember>();
        BgDimensionMember c01 = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C01.getAlias(), BgProcessEnum.C01.getName());
        BgDimensionMember c02 = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C02.getAlias(), BgProcessEnum.C02.getName());
        BgDimensionMember c03 = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C03.getAlias(), BgProcessEnum.C03.getName());
        BgDimensionMember c04 = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C04.getAlias(), BgProcessEnum.C04.getName());
        members.add(c01);
        members.add(c02);
        members.add(c03);
        members.add(c04);
        map.put(DEF_PROCESS_NUMBER, members);
        return map;
    }

    public static BgDimensionInfo getDimension() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DEF_PROCESS_NUMBER);
        dimension.setType(DEF_PROCESS_NUMBER);
        dimension.setName(DEF_PROCESS_NAME);
        dimension.setAlias(DEF_PROCESS_NAME);
        dimension.setAttribute(DEF_PROCESS_FIELD);
        return dimension;
    }

    public static BgDimensionMember getMember(String number) {
        BgDimensionMember m = null;
        if (BgProcessEnum.C01.getName().equals(number)) {
            m = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C01.getAlias(), BgProcessEnum.C01.getName());
        } else if (BgProcessEnum.C02.getName().equals(number)) {
            m = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C02.getAlias(), BgProcessEnum.C02.getName());
        } else if (BgProcessEnum.C03.getName().equals(number)) {
            m = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C03.getAlias(), BgProcessEnum.C03.getName());
        } else if (BgProcessEnum.C04.getName().equals(number)) {
            m = new BgDimensionMember(DEF_PROCESS_NUMBER, null, BgProcessEnum.C04.getAlias(), BgProcessEnum.C04.getName());
        }
        if (m != null) {
            m.setSrcNumber(DEF_PROCESS_SRC);
            m.setAttribute(DEF_PROCESS_FIELD);
        }
        return m;
    }

    public static BgProcessEnum memberToEnum(BgDimensionMember member) {
        BgProcessEnum n = null;
        if (member == null || StringUtils.isEmpty((String)member.getNumber())) {
            return n;
        }
        if (BgProcessEnum.C01.getName().equals(member.getNumber())) {
            n = BgProcessEnum.C01;
        } else if (BgProcessEnum.C02.getName().equals(member.getNumber())) {
            n = BgProcessEnum.C02;
        } else if (BgProcessEnum.C03.getName().equals(member.getNumber())) {
            n = BgProcessEnum.C03;
        } else if (BgProcessEnum.C04.getName().equals(member.getNumber())) {
            n = BgProcessEnum.C04;
        }
        return n;
    }

    public static Object membersToEnums(Set<BgDimensionMember> members) {
        BgProcessEnum[] arr = null;
        if (members != null && !members.isEmpty()) {
            arr = new BgProcessEnum[members.size()];
            ArrayList<BgDimensionMember> lst = new ArrayList<BgDimensionMember>(members);
            if (lst.size() == 1) {
                return BgProcessHelper.memberToEnum((BgDimensionMember)lst.get(0));
            }
            for (int i = 0; i < lst.size(); ++i) {
                arr[i] = BgProcessHelper.memberToEnum((BgDimensionMember)lst.get(i));
            }
        }
        return arr;
    }

    static {
        Collections.addAll(PROCESS_NUMBERS, BgProcessEnum.C01.getName(), BgProcessEnum.C02.getName(), BgProcessEnum.C03.getName(), BgProcessEnum.C04.getName());
    }
}

