/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationGroupShowEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IDimensionRelationship;
import com.kingdee.eas.ma.mbg.IDimensionRelationshipGroup;
import com.kingdee.eas.ma.mbg.common.AbstractBgSchemeCopy;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeParam;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.common.BgSchemeCopyUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BgRelationCopy
extends AbstractBgSchemeCopy {
    public BgRelationCopy(BgCopySchemeParam param, BgSchemeInfo scheme, boolean isAddScheme, Context ctx, BgSchemeInfo target) {
        super(param, scheme, isAddScheme, ctx, target);
    }

    @Override
    public boolean isCopy(BgCopySchemeParam param) {
        return param.isCopyRelation() && this.getScheme() != null && this.getTarget() != null;
    }

    @Override
    protected List<BgCopySchemeResult> dealCopyByParam() throws Exception {
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo target = this.getTarget();
        BgSchemeInfo source = this.getScheme();
        try {
            DimRelashipGroupEntryInfo entryInfo;
            int in;
            DimRelashipGroupEntryCollection entries;
            DimensionRelationshipGroupInfo info;
            CoreBaseCollection data = new CoreBaseCollection();
            BgSchemeDimensionHelper targetHelper = new BgSchemeDimensionHelper(this.ctx, target.getId().toString());
            Set<String> targetExistsOrgIds = this.getExistsOrgIds(targetHelper);
            BgSchemeDimensionHelper sourceHelper = new BgSchemeDimensionHelper(this.ctx, source.getId().toString());
            Set<String> sourceExistsOrgIds = this.getExistsOrgIds(sourceHelper);
            DimensionRelationshipGroupCollection targetGroupCols = this.getRelationShipGroupInstance().getDimensionRelationshipGroupCollection(this.getGroupEntityViewInfo(target.getId().toString()));
            HashMap tDimNumbers = new HashMap();
            HashMap groupMap = new HashMap();
            int in2 = targetGroupCols.size();
            for (int i = 0; i < in2; ++i) {
                info = targetGroupCols.get(i);
                TreeSet<String> dimGroups = new TreeSet<String>();
                int jn = info.getEntries().size();
                for (int j = 0; j < jn; ++j) {
                    dimGroups.add(info.getEntries().get(j).getDimNumber());
                }
                if (!tDimNumbers.containsKey(info.getNumber())) {
                    tDimNumbers.put(info.getNumber(), dimGroups);
                }
                groupMap.put(dimGroups, info);
            }
            DimensionRelationshipGroupCollection sourceGroupCols = this.getRelationShipGroupInstance().getDimensionRelationshipGroupCollection(this.getGroupEntityViewInfo(source.getId().toString()));
            Iterator iterator = sourceGroupCols.iterator();
            HashMap sourceIdRefTargetGroups = new HashMap();
            TreeSet<String> srcList = new TreeSet<String>();
            while (iterator.hasNext()) {
                Set targetDimGroups;
                srcList.clear();
                info = (DimensionRelationshipGroupInfo)iterator.next();
                entries = info.getEntries();
                in = entries.size();
                for (int i = 0; i < in; ++i) {
                    entryInfo = entries.get(i);
                    srcList.add(entryInfo.getDimNumber());
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    entryInfo.setDimRelashipGroup(info);
                }
                String id = info.getId().toString();
                if (tDimNumbers.values().contains(srcList)) {
                    sourceIdRefTargetGroups.put(id, groupMap.get(srcList));
                    continue;
                }
                if (tDimNumbers.keySet().contains(info.getNumber()) && !(targetDimGroups = (Set)tDimNumbers.get(info.getNumber())).equals(srcList)) {
                    this.appendErrorMsg(result, EASResource.getString((String)this.RES, (String)"equalsNumberButDiffRefDim"), info.getName(), "");
                    continue;
                }
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setBgScheme(target);
                this.resetTime((ObjectBaseInfo)info);
                sourceIdRefTargetGroups.put(id, info);
                data.add((CoreBaseInfo)info);
            }
            this.getRelationShipGroupInstance().saveBatchData(data);
            targetGroupCols = this.getRelationShipGroupInstance().getDimensionRelationshipGroupCollection(this.getGroupEntityViewInfo(target.getId().toString()));
            groupMap.clear();
            in = targetGroupCols.size();
            for (int i = 0; i < in; ++i) {
                info = targetGroupCols.get(i);
                TreeSet<String> dimGroups = new TreeSet<String>();
                int jn = info.getEntries().size();
                for (int j = 0; j < jn; ++j) {
                    dimGroups.add(info.getEntries().get(j).getDimNumber());
                }
                groupMap.put(dimGroups, info);
            }
            data.clear();
            if (sourceIdRefTargetGroups.isEmpty()) {
                return result;
            }
            HashSet<String> copySet = new HashSet<String>(targetExistsOrgIds);
            copySet.retainAll(sourceExistsOrgIds);
            Map<String, Map<String, Set<String>>> memberMap = BgSchemeCopyUtils.getMemberMap(this.ctx, targetHelper, copySet, null);
            EntityViewInfo shipEntityViewInfo = this.getShipEntityViewInfo(sourceIdRefTargetGroups.keySet());
            shipEntityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1, CompareType.EQUALS));
            DimensionRelationshipCollection sourceShipColls = this.getRelationShipInstance().getDimensionRelationshipCollection(shipEntityViewInfo);
            Iterator iterator1 = sourceShipColls.iterator();
            HashSet<String> allNumber = new HashSet<String>();
            block8: while (iterator1.hasNext()) {
                srcList.clear();
                DimensionRelationshipInfo shipInfo = (DimensionRelationshipInfo)iterator1.next();
                if (!targetExistsOrgIds.contains(shipInfo.getCostUnit().getId().toString())) {
                    this.appendErrorMsg(result, EASResource.getString((String)this.RES, (String)"notExistsOrgInRelation"), shipInfo.getDimensionName(), shipInfo.getFilterUnit().getNumber() + "(" + shipInfo.getFilterUnit().getName() + ")");
                    continue;
                }
                String orgUnitId = shipInfo.getCostUnit().getId().toString();
                DimensionRelationshipGroupInfo dimensionRelationshipGroupInfo = (DimensionRelationshipGroupInfo)sourceIdRefTargetGroups.get(shipInfo.getDimensionGroup().getId().toString());
                entries = dimensionRelationshipGroupInfo.getEntries();
                int in3 = entries.size();
                for (int i = 0; i < in3; ++i) {
                    entryInfo = entries.get(i);
                    srcList.add(entryInfo.getDimNumber());
                }
                if (groupMap.containsKey(srcList)) {
                    DimensionRelationshipCollection dimRelaShips;
                    DimensionRelationshipGroupInfo targetShipGroupInfo = (DimensionRelationshipGroupInfo)groupMap.get(srcList);
                    DimensionRelationGroupShowEnum isLowerShow = targetShipGroupInfo.getIsLowerShow();
                    EntityViewInfo evi = this.getShipEntityViewInfo(new HashSet<String>(Collections.nCopies(1, targetShipGroupInfo.getId().toString())));
                    if (DimensionRelationGroupShowEnum.allQuarantine.equals((Object)isLowerShow)) {
                        dimRelaShips = this.getRelationShipInstance().getDimensionRelationshipCollection(evi);
                        if (allNumber.contains(shipInfo.getDimensionNumber())) continue;
                        allNumber.add(shipInfo.getDimensionNumber());
                    } else if (DimensionRelationGroupShowEnum.orgQuarantine.equals((Object)isLowerShow)) {
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)orgUnitId));
                        dimRelaShips = this.getRelationShipInstance().getDimensionRelationshipCollection(evi);
                    } else if (DimensionRelationGroupShowEnum.childQuarantine.equals((Object)isLowerShow)) {
                        evi.getFilter().getFilterItems().add(DimensionMemberRelationShipHelper.getLowerShowFilter(this.ctx, target.getId().toString(), orgUnitId));
                        dimRelaShips = this.getRelationShipInstance().getDimensionRelationshipCollection(evi);
                    } else {
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("filterUnit.id", (Object)BgOrgUnitFactory.getLocalInstance(this.ctx).getParentAndChildrenOrgUnitIds(orgUnitId, targetHelper.getBgOrgViewId()), CompareType.INCLUDE));
                        dimRelaShips = this.getRelationShipInstance().getDimensionRelationshipCollection(evi);
                    }
                    int in4 = dimRelaShips.size();
                    for (int i = 0; i < in4; ++i) {
                        DimensionRelationshipInfo dimensionRelationshipInfo = dimRelaShips.get(i);
                        if (shipInfo.getDimensionNumber().equals(dimensionRelationshipInfo.getDimensionNumber())) continue block8;
                    }
                    String dimensionNumber = shipInfo.getDimensionNumber();
                    String[] dimNumbers = dimensionNumber.split(",");
                    String[] dimensionNames = shipInfo.getDimensionName().split(DimensionConstants.TICK_SEPARATOR);
                    int in5 = dimNumbers.length;
                    for (int i = 0; i < in5; ++i) {
                        String srcNumber = dimNumbers[i].split(":")[0];
                        String number = dimNumbers[i].split(":")[1];
                        String refField = targetHelper.getRefFieldBySrcNumber(srcNumber);
                        boolean isPeriodN = false;
                        if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber) && BgPeriodNVariableHelper.checkCanConvert((String)number)) {
                            isPeriodN = true;
                        }
                        if (null != memberMap.get(refField).get(orgUnitId) && memberMap.get(refField).get(orgUnitId).contains(number) || isPeriodN) continue;
                        this.appendErrorMsg(result, EASResource.getString((String)this.RES, (String)"notExistsMemberInRelation", (Object[])new Object[]{dimensionNames[i].concat("(").concat(number).concat(")")}), shipInfo.getDimensionName(), shipInfo.getFilterUnit().getNumber() + "(" + shipInfo.getFilterUnit().getName() + ")");
                        continue block8;
                    }
                    shipInfo.setDimensionGroup((DimensionRelationshipGroupInfo)groupMap.get(srcList));
                } else {
                    shipInfo.setDimensionGroup((DimensionRelationshipGroupInfo)sourceIdRefTargetGroups.get(shipInfo.getDimensionGroup().getId().toString()));
                }
                shipInfo.setId(BOSUuid.create((BOSObjectType)shipInfo.getBOSType()));
                this.resetTime(shipInfo);
                data.add((CoreBaseInfo)shipInfo);
            }
            this.getRelationShipInstance().saveBatchData(data);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return result;
    }

    private void resetTime(ObjectBaseInfo info) {
        if (this.isAddScheme()) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        } else {
            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    private Set<String> getExistsOrgIds(BgSchemeDimensionHelper schemeHelper) throws BOSException {
        HashSet<String> existsOrgIds = new HashSet<String>();
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(this.ctx).getBgOrgUnitCollection("where viewID ='" + schemeHelper.getBgOrgViewId() + "'");
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            existsOrgIds.add(bgOrgUnitCollection.get(i).getOrgUnitID());
        }
        return existsOrgIds;
    }

    private IDimensionRelationshipGroup getRelationShipGroupInstance() throws BOSException {
        return DimensionRelationshipGroupFactory.getLocalInstance(this.ctx);
    }

    private IDimensionRelationship getRelationShipInstance() throws BOSException {
        return DimensionRelationshipFactory.getLocalInstance(this.ctx);
    }

    private void appendErrorMsg(List<BgCopySchemeResult> result, String copyResult, String name, String orgName) {
        String baseMsg = EASResource.getString((String)this.RES, (String)"BgRelation");
        BgCopySchemeResult item = new BgCopySchemeResult();
        item.setBaseMsg(baseMsg);
        item.setOrgName(orgName);
        item.setName(name);
        item.setCopyResult(copyResult);
        result.add(item);
    }

    private EntityViewInfo getShipEntityViewInfo(Set<String> groupIds) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("filterUnit.id");
        sic.add("filterUnit.number");
        sic.add("filterUnit.name");
        sic.add("dimensionGroup.entries.id");
        sic.add("dimensionGroup.entries.dimName");
        sic.add("dimensionGroup.entries.dimNumber");
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dimensionGroup.id", groupIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getGroupEntityViewInfo(String schemeId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCsl", (Object)false, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

