/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgElementDataTypeEnum;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.ITemplateFacade;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBgTemplateHelper {
    private static Logger logger = Logger.getLogger((String)MBgTemplateHelper.class.getName());
    private static long startTime = 0L;
    private static long totalTime = 0L;
    private static long st = 0L;

    public static List<BgAttributeColumn> getPropertiesForDim(IBgDimensionManagerBase bgDimensionManage, BgDimensionInfo curDimension) {
        if (!(bgDimensionManage instanceof IBgDimensionManager) || curDimension == null) {
            return null;
        }
        ArrayList<BgAttributeColumn> res = new ArrayList<BgAttributeColumn>();
        List<BgAttributeColumn> allProperties = ((IBgDimensionManager)bgDimensionManage).getAttributeCol();
        for (int i = 0; i < allProperties.size(); ++i) {
            if (allProperties.get(i).getDimensionInfo() == null || !curDimension.getNumber().equals(allProperties.get(i).getDimensionInfo().getNumber())) continue;
            res.add(allProperties.get(i));
        }
        return res;
    }

    public static void verifyMbgViewManagerForTemplate(Context ctx, IMbgViewManager imbgViewManager) throws BOSException, EASBizException {
        if (imbgViewManager == null) {
            throw new TemplateException(TemplateException.DIMENSIONISNULL);
        }
        MBgTemplateHelper.verifyMbgViewManager(imbgViewManager);
        MBgTemplateHelper.getTemplateFacade(ctx).verifyMbgViewManagerForTemplate(imbgViewManager);
    }

    public static void verifyMbgViewManagerForOpenForm(Context ctx, IMbgViewBase imbgViewManager) throws BOSException, EASBizException {
        if (imbgViewManager == null) {
            throw new TemplateException(TemplateException.DIMENSIONISNULL);
        }
        MBgTemplateHelper.verifyMbgViewManager(imbgViewManager);
        if (imbgViewManager instanceof IMbgViewManager) {
            MBgTemplateHelper.getTemplateFacade(ctx).verifyMbgViewManagerForOpenForm((IMbgViewManager)imbgViewManager);
        }
    }

    private static ITemplateFacade getTemplateFacade(Context ctx) throws BOSException {
        ITemplateFacade iTemplateFacade = null;
        iTemplateFacade = ctx == null ? TemplateFacadeFactory.getRemoteInstance() : TemplateFacadeFactory.getLocalInstance(ctx);
        return iTemplateFacade;
    }

    private static void verifyMbgViewManager(IMbgViewBase imbgViewManager) throws BOSException, EASBizException {
        IBgDimensionManagerBase bgDimensionManager = null;
        for (int sheetIndex = 0; sheetIndex < imbgViewManager.getSheetManagers().size(); ++sheetIndex) {
            bgDimensionManager = imbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager();
            try {
                MBgTemplateHelper.verifyDimensionManager(bgDimensionManager);
                continue;
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException(imbgViewManager.getSheetManagers().get(sheetIndex).getSheetName() + ":" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void verifyDimensionManager(IBgDimensionManagerBase bgDimensionManager) throws Exception {
        if (bgDimensionManager == null) {
            throw new TemplateException(TemplateException.DIMENSIONISNULL);
        }
        boolean[] v = new boolean[5];
        BgDimensionBaseInfo scenarioDimensionInfo = null;
        BgDimensionBaseInfo indexDimensionInfo = null;
        BgDimensionBaseInfo dimensionInfo = null;
        BgDimensionBaseInfo periodDimensionInfo = null;
        for (int demensionIndex = 0; demensionIndex < bgDimensionManager.getDimension().size(); ++demensionIndex) {
            dimensionInfo = (BgDimensionBaseInfo)bgDimensionManager.getDimension().get(demensionIndex);
            if (MBGLayoutConstants.BG_ORGANIZATION.equals(dimensionInfo.getNumber())) {
                v[0] = true;
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equals(dimensionInfo.getNumber())) {
                v[1] = true;
                continue;
            }
            if (MBGLayoutConstants.BG_INDEX.equals(dimensionInfo.getNumber())) {
                v[2] = true;
                indexDimensionInfo = dimensionInfo;
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionInfo.getNumber())) {
                v[3] = true;
                scenarioDimensionInfo = dimensionInfo;
                continue;
            }
            if (!MBGLayoutConstants.BG_PERIOD.equals(dimensionInfo.getNumber())) continue;
            v[4] = true;
            periodDimensionInfo = dimensionInfo;
        }
        for (int i = 0; i < v.length; ++i) {
            if (v[i]) continue;
            throw new TemplateException(TemplateException.LACKBASEDIMENSION);
        }
        if (bgDimensionManager.getRowDimension().size() <= 0 || bgDimensionManager.getColDimension().size() <= 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
        if (indexDimensionInfo != null && indexDimensionInfo.getMemberValueType().getValue() == 1 && !indexDimensionInfo.isDinamicAdd()) {
            throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{indexDimensionInfo.getName()});
        }
        if (indexDimensionInfo != null && indexDimensionInfo.getMemberValueType().getValue() == 3 && (indexDimensionInfo.getMember() == null || indexDimensionInfo.getMember().size() <= 0)) {
            throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{indexDimensionInfo.getName()});
        }
        if (scenarioDimensionInfo != null && scenarioDimensionInfo.getMemberValueType().getValue() == 1 && indexDimensionInfo != null && !indexDimensionInfo.isDinamicAdd()) {
            throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{scenarioDimensionInfo.getName()});
        }
        if (scenarioDimensionInfo != null && scenarioDimensionInfo.getMemberValueType().getValue() == 3 && (scenarioDimensionInfo.getMember() == null || scenarioDimensionInfo.getMember().size() <= 0)) {
            throw new TemplateException(TemplateException.DIMENSIONLACKMEMBER, new Object[]{scenarioDimensionInfo.getName()});
        }
        if (periodDimensionInfo != null && periodDimensionInfo.getMember().isEmpty() && periodDimensionInfo.getMemberValueType().getValue() == 1 && periodDimensionInfo.getBgPeriodType() == null) {
            throw new TemplateException(TemplateException.BGPERIODNULL);
        }
    }

    public static List<BgDimensionMember> getOneDimensionMembersForAllOrg(Map<String, IBgDimensionManager> bgDimensionManagerForMulOrg, BgDimensionInfo dimensionInfo, String sheetName, DimensionMemberFilterInfo memberFilter, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        DimensionMemberFilterMember filter;
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(dimensionInfo.getNumber());
        Set<String> keySet = bgDimensionManagerForMulOrg.keySet();
        String orgNum2 = null;
        List dimensions = null;
        HashSet<String> exitMember = new HashSet<String>();
        HashSet<String> srcNumbers = new HashSet<String>();
        for (String orgNum2 : keySet) {
            dimensions = MBgTemplateHelper.getDimensions(bgDimensionManagerForMulOrg.get(orgNum2), list);
            if (dimensions == null || dimensions.size() <= 0) continue;
            for (int i = 0; i < dimensions.size(); ++i) {
                MBgTemplateHelper.collectDimensionSrcNums(((BgDimensionInfo)dimensions.get(i)).getMember(), srcNumbers);
            }
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber()) && srcNumbers.isEmpty()) {
            srcNumbers.add(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        }
        boolean isSelectAll = true;
        if (memberFilter != null && memberFilter.getMemberFilter(sheetName, dimensionInfo.getNumber()) != null) {
            filter = memberFilter.getMemberFilter(sheetName, dimensionInfo.getNumber());
            isSelectAll = !memberFilter.isEnableFilter() || filter.isSelectAll();
        } else {
            filter = new DimensionMemberFilterMember();
            filter.setDimensionNumber(dimensionInfo.getNumber());
            filter.setSelectAll(true);
            memberFilter.addMemberFilter(sheetName, filter);
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) {
            for (BgDimensionMember member : dimensionInfo.getMember()) {
                if (member == null || !isSelectAll && !filter.getMembers().contains(member.getNumber())) continue;
                members.add(member);
            }
            return members;
        }
        int count = 0;
        Iterator<String> orgNumIterator = keySet.iterator();
        while (orgNumIterator.hasNext()) {
            ++count;
            orgNum2 = orgNumIterator.next();
            dimensions = MBgTemplateHelper.getDimensions(bgDimensionManagerForMulOrg.get(orgNum2), list);
            if (dimensions == null || dimensions.size() <= 0) continue;
            for (int i = 0; i < dimensions.size(); ++i) {
                BgDimensionInfo dimen = (BgDimensionInfo)dimensions.get(i);
                List sMember = null;
                sMember = DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimen.getMemberValueType()) ? dimen.getMember() : dimen.getMember();
                if (sMember == null || sMember.isEmpty()) continue;
                for (int j = 0; j < sMember.size(); ++j) {
                    BgDimensionMember member = (BgDimensionMember)sMember.get(j);
                    if (exitMember.contains(MBgTemplateHelper.getDimensionMemeberSign(member)) || !member.isLegal() || !isSelectAll && !filter.getMembers().contains(member.getNumber())) continue;
                    if (count == 1) {
                        members.add(member);
                    } else {
                        MBgTemplateHelper.insertNewMemberByOrder(members, member);
                    }
                    exitMember.add(MBgTemplateHelper.getDimensionMemeberSign(member));
                }
            }
        }
        return members;
    }

    public static void processMemberFilter(BgDimensionBaseInfo dimensionInfo, String sheetName, DimensionMemberFilterInfo memberFilter, boolean isDesc) {
        boolean isSelectAll = true;
        if (memberFilter != null && memberFilter.getMemberFilter(sheetName, dimensionInfo.getNumber()) != null) {
            DimensionMemberFilterMember filter = memberFilter.getMemberFilter(sheetName, dimensionInfo.getNumber());
            isSelectAll = !memberFilter.isEnableFilter() || filter.isSelectAll();
        } else {
            DimensionMemberFilterMember filter = new DimensionMemberFilterMember();
            filter.setDimensionNumber(dimensionInfo.getNumber());
            filter.setSelectAll(true);
            filter.setDesc(isDesc);
            memberFilter.addMemberFilter(sheetName, filter);
        }
    }

    public static boolean isOrgOnPageOrView(IBgDimensionManagerBase dimensionManager) {
        List viewDimension = dimensionManager.getViewDisplayDimension();
        String dimNumber = null;
        for (int i = 0; i < viewDimension.size(); ++i) {
            dimNumber = viewDimension.get(i) instanceof MbgViewListAtribute ? ((MbgViewListAtribute)viewDimension.get(i)).getDimNumber() : ((BgDimensionBaseInfo)viewDimension.get(i)).getNumber();
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimNumber)) continue;
            return Boolean.TRUE;
        }
        List pageDimension = dimensionManager.getPageDisplayDimension();
        for (int i = 0; i < pageDimension.size(); ++i) {
            dimNumber = pageDimension.get(i) instanceof MbgViewListAtribute ? ((MbgViewListAtribute)pageDimension.get(i)).getDimNumber() : ((BgDimensionBaseInfo)pageDimension.get(i)).getNumber();
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimNumber)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isOrgOnView(IBgDimensionManagerBase dimensionManager) {
        List viewDimension = dimensionManager.getViewDisplayDimension();
        for (int i = 0; i < viewDimension.size(); ++i) {
            if (!(viewDimension.get(i) instanceof BgDimensionBaseInfo) || !MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)viewDimension.get(i)).getNumber())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isOrgOnCol(IBgDimensionManagerBase dimensionManager) {
        List viewDimension = dimensionManager.getColDisplayDimension();
        for (int i = 0; i < viewDimension.size(); ++i) {
            String dimNumber = null;
            dimNumber = viewDimension.get(i) instanceof MbgViewListAtribute ? ((MbgViewListAtribute)viewDimension.get(i)).getDimNumber() : ((BgDimensionBaseInfo)viewDimension.get(i)).getNumber();
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimNumber)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static List getDimensions(IBgDimensionManagerBase iBgDimensionManager, List<String> dimensionNum) {
        int i;
        if (iBgDimensionManager == null || dimensionNum == null) {
            return null;
        }
        ArrayList dimensions = new ArrayList();
        HashMap<String, BgDimensionBaseInfo> map = new HashMap<String, BgDimensionBaseInfo>();
        for (i = 0; i < iBgDimensionManager.getDimension().size(); ++i) {
            if (!(iBgDimensionManager.getDimension().get(i) instanceof BgDimensionBaseInfo)) continue;
            map.put(((BgDimensionBaseInfo)iBgDimensionManager.getDimension().get(i)).getNumber(), (BgDimensionBaseInfo)iBgDimensionManager.getDimension().get(i));
        }
        for (i = 0; i < dimensionNum.size(); ++i) {
            if (!map.containsKey(dimensionNum.get(i))) continue;
            dimensions.add(map.get(dimensionNum.get(i)));
        }
        if (dimensionNum.size() == dimensions.size()) {
            return dimensions;
        }
        return null;
    }

    public static List<String> getDimensionsNum(List<? extends BgDimensionBaseInfo> dimensions) {
        if (dimensions == null) {
            return null;
        }
        ArrayList<String> dimensionNum = new ArrayList<String>();
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensionNum.add(dimensions.get(i).getNumber());
        }
        return dimensionNum;
    }

    public static boolean isExtendOrIndexDimension(String dimensionNum) {
        if (MBGLayoutConstants.BG_ORGANIZATION.equals(dimensionNum)) {
            return false;
        }
        if (MBGLayoutConstants.BG_CURRENCY.equals(dimensionNum)) {
            return false;
        }
        if (MBGLayoutConstants.BG_ELEMENT.equals(dimensionNum)) {
            return false;
        }
        if (MBGLayoutConstants.BG_PERIOD.equals(dimensionNum)) {
            return false;
        }
        if (MBGLayoutConstants.BG_VERSION.equals(dimensionNum)) {
            return false;
        }
        return !MBGLayoutConstants.BG_SCENARIO.equals(dimensionNum);
    }

    public static boolean isAttrColumn(Column column) {
        if (column == null) {
            return false;
        }
        Object o = column.getUserObjectValue("attr_col");
        return o instanceof BgAttributeColumn;
    }

    public static BgAttributeColumn getBgAttributeColumn(Column column) {
        if (column == null) {
            return null;
        }
        Object o = column.getUserObjectValue("attr_col");
        if (o instanceof BgAttributeColumn) {
            return (BgAttributeColumn)o;
        }
        return null;
    }

    public static boolean isDesColumn(Column column) {
        if (column == null) {
            return false;
        }
        Object o = column.getUserObjectValue("des_col");
        return o instanceof BgDescriptionColumn;
    }

    public static BgDescriptionColumn getDesColumn(Column column) {
        if (column == null) {
            return null;
        }
        Object o = column.getUserObjectValue("des_col");
        if (o instanceof BgDescriptionColumn) {
            return (BgDescriptionColumn)o;
        }
        return null;
    }

    public static boolean isCalColumn(Column column) {
        if (column == null) {
            return false;
        }
        Object o = column.getUserObjectValue("cal_col");
        return o instanceof BgCalcuteColumn;
    }

    public static BgCalcuteColumn getCalColumn(Column column) {
        if (column == null) {
            return null;
        }
        Object o = column.getUserObjectValue("cal_col");
        if (o instanceof BgCalcuteColumn) {
            return (BgCalcuteColumn)o;
        }
        return null;
    }

    public static boolean isDimTotalRow(Row row) {
        if (row == null) {
            return false;
        }
        Object o = row.getUserObjectValue("dimTotal_row");
        return o instanceof String && !StringUtils.isEmpty((String)((String)o));
    }

    public static void createDimTotalExpression(Sheet sheet, Cell cell, List<BgDimensionMember> members, IProvider provider, HashMap<String, BgElementDataTypeEnum> scenarios) {
        if (members == null || members.isEmpty() || cell == null) {
            return;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        String _element = null;
        String _period = null;
        String _currency = null;
        String _scenNubmer = null;
        String _versionNumber = null;
        String _org = null;
        BgDimensionMember member = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType())) {
                _scenNubmer = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType())) {
                _versionNumber = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) {
                _org = member.getNumber();
                continue;
            }
            if (member == null || member.getNumber() == null) continue;
            _item.put(DimensionCommonHelper.getField(member.getAttribute().toUpperCase()), member.getSrcNumber() + ":" + member.getNumber());
        }
        if (!_item.isEmpty()) {
            if (_element == null || scenarios.get(_element).equals((Object)BgElementDataTypeEnum.PRICE) || scenarios.get(_element).equals((Object)BgElementDataTypeEnum.RATE)) {
                BgNFSHelper.setExpression(cell, "\u2014");
                Range range = sheet.getRange(cell);
                StyleAttributes sa = Styles.getEmptySA();
                sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                range.setStyle(sa, Styles.getEmptySA());
            } else {
                String dimExpression = MBgTemplateHelper.getDimExpression(_org, _element, _currency, _period, _scenNubmer, _versionNumber, _item, provider);
                BgNFSHelper.setExpression(cell, dimExpression);
            }
        }
    }

    public static void createDimSumExpression(Sheet sheet, Cell cell, List<BgDimensionMember> members, IProvider provider, HashMap<String, BgElementDataTypeEnum> scenarios, List<BgDimensionMember> rowMembers, List<BgDimensionMember> colMembers, List<BgDimensionMember> pageMembers) {
        if (members == null || members.isEmpty() || cell == null) {
            return;
        }
        ArrayList<Map> _rowDimItems = new ArrayList<Map>();
        String _element = null;
        String _period = null;
        String _currency = null;
        String _scenNubmer = null;
        String _versionNumber = null;
        String _org = null;
        BgDimensionMember member = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType())) {
                _scenNubmer = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType())) {
                _versionNumber = member.getNumber();
                continue;
            }
            if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) continue;
            _org = member.getNumber();
        }
        for (BgDimensionMember rowMember : rowMembers) {
            HashMap<Integer, String> _item = new HashMap<Integer, String>();
            if (rowMember != null && rowMember.getNumber() != null && MBgTemplateHelper.isExtendOrIndexDimension(rowMember.getType())) {
                _item.put(DimensionCommonHelper.getField(rowMember.getAttribute().toUpperCase()), rowMember.getSrcNumber() + ":" + rowMember.getNumber());
                for (BgDimensionMember colMember : colMembers) {
                    if (colMember == null || colMember.getNumber() == null || !MBgTemplateHelper.isExtendOrIndexDimension(colMember.getType())) continue;
                    _item.put(DimensionCommonHelper.getField(colMember.getAttribute().toUpperCase()), colMember.getSrcNumber() + ":" + colMember.getNumber());
                }
                for (BgDimensionMember pageMember : pageMembers) {
                    if (pageMember == null || pageMember.getNumber() == null || !MBgTemplateHelper.isExtendOrIndexDimension(pageMember.getType())) continue;
                    _item.put(DimensionCommonHelper.getField(pageMember.getAttribute().toUpperCase()), pageMember.getSrcNumber() + ":" + pageMember.getNumber());
                }
            }
            _rowDimItems.add(_item);
        }
        if (!_rowDimItems.isEmpty()) {
            if (_element == null || scenarios.get(_element).equals((Object)BgElementDataTypeEnum.PRICE) || scenarios.get(_element).equals((Object)BgElementDataTypeEnum.RATE)) {
                BgNFSHelper.setExpression(cell, "\u2014");
                Range range = sheet.getRange(cell);
                StyleAttributes sa = Styles.getEmptySA();
                sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                range.setStyle(sa, Styles.getEmptySA());
            } else {
                String dimExpression = MBgTemplateHelper.getDimSumExpression(_org, _element, _currency, _period, _scenNubmer, _versionNumber, _rowDimItems, provider);
                BgNFSHelper.setExpression(cell, dimExpression);
            }
        }
    }

    private static String getDimSumExpression(String bgOrg, String bgElement, String currency, String bgPeriod, String scenNumber, String versionNumber, List<Map> rowDimItems, IProvider provider) {
        Map bgItems = new HashMap();
        String dimExpression = null;
        String expression = "=";
        for (int j = 0; j < rowDimItems.size(); ++j) {
            bgItems = rowDimItems.get(j);
            StringBuffer f = new StringBuffer();
            if (bgItems != null && !bgItems.isEmpty()) {
                Object[] reffields = bgItems.keySet().toArray();
                Arrays.sort(reffields);
                for (int i = 0; i < reffields.length; ++i) {
                    if (i != 0) {
                        f.append(",");
                    }
                    f.append(bgItems.get(reffields[i]));
                }
            }
            dimExpression = MBgTemplateHelper.getDimExpressionParam(bgOrg, f.toString(), bgPeriod, bgElement, currency, scenNumber, versionNumber, provider);
            expression = expression + dimExpression;
            if (j == rowDimItems.size() - 1) continue;
            expression = expression + "+";
        }
        return expression;
    }

    private static String getDimExpression(String bgOrg, String bgElement, String currency, String bgPeriod, String scenNumber, String versionNumber, Map bgItems, IProvider provider) {
        String expressiom = "=";
        StringBuffer f = new StringBuffer();
        if (bgItems != null && !bgItems.isEmpty()) {
            Object[] reffields = bgItems.keySet().toArray();
            Arrays.sort(reffields);
            for (int i = 0; i < reffields.length; ++i) {
                if (i != 0) {
                    f.append(",");
                }
                f.append(bgItems.get(reffields[i]));
            }
        }
        return expressiom + MBgTemplateHelper.getDimExpressionParam(bgOrg, f.toString(), bgPeriod, bgElement, currency, scenNumber, versionNumber, provider);
    }

    private static String getDimExpressionParam(String orgNumber, String bgItemNum, String periodNum, String elementNum, String currencyNum, String scenNumber, String versionNumber, IProvider provider) {
        if (bgItemNum == null || elementNum == null) {
            return null;
        }
        String schemeNumber = null;
        String beginPeriodNum = periodNum;
        String endPeriodNum = periodNum;
        IObjectValue actualObj = provider.getEditValue();
        String datatype = null;
        datatype = actualObj instanceof BgActualRecordInfo ? AggregateDataTypeEnum.addActual.getName() : AggregateDataTypeEnum.budget.getName();
        String dimStr = null;
        dimStr = new StringBuffer("MbgAggregate(\"" + MBgTemplateHelper.cnulls(orgNumber) + "\",\"" + MBgTemplateHelper.cnulls(schemeNumber) + "\",\"" + MBgTemplateHelper.cnulls(scenNumber) + "\",\"" + MBgTemplateHelper.cnulls(bgItemNum) + "\",\"" + MBgTemplateHelper.cnulls(beginPeriodNum) + "\",\"" + MBgTemplateHelper.cnulls(endPeriodNum) + "\",\"" + MBgTemplateHelper.cnulls(versionNumber) + "\",\"" + MBgTemplateHelper.cnulls(currencyNum) + "\",\"" + MBgTemplateHelper.cnulls(elementNum) + "\",\"" + MBgTemplateHelper.cnulls(datatype) + "\")").toString();
        return dimStr;
    }

    private static String cnulls(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static boolean isSubTotalRow(Row row) {
        if (row == null) {
            return false;
        }
        Object o = row.getUserObjectValue("subTotal_row");
        return o instanceof String && !StringUtils.isEmpty((String)((String)o));
    }

    public static void createSubTotalExpression(Sheet sheet, Row row, int headerRowCount) {
        List<Rect> pos = MBgTemplateHelper.collectSubTotalRect(sheet, row, headerRowCount);
        if (pos.size() > 0) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                if (sheet.getColumn(colIndex, false) == null || !(sheet.getColumn(colIndex, false).getUserObjectValue("DIMENSION") instanceof List) || ((List)sheet.getColumn(colIndex, false).getUserObjectValue("DIMENSION")).size() <= 0) continue;
                BgNFSHelper.setExpression(sheet.getCell(row.getRow(), colIndex, true), MBgTemplateHelper.getSubTotalExpression(pos, colIndex));
            }
        }
    }

    private static String getSubTotalExpression(List<Rect> pos, int colIndex) {
        if (pos == null || pos.size() == 0 || colIndex < 0) {
            return null;
        }
        String expression = "=";
        for (int i = 0; i < pos.size(); ++i) {
            Rect rect = new Rect(colIndex, pos.get((int)i).y1, colIndex, pos.get((int)i).y2);
            expression = expression + "SUM(" + TableToolkit.xy2range((Rect)rect) + ")";
            if (i == pos.size() - 1) continue;
            expression = expression + "+";
        }
        return expression;
    }

    private static List<Rect> collectSubTotalRect(Sheet sheet, Row row, int headerRowCount) {
        ArrayList<Rect> pos = new ArrayList<Rect>();
        if (MBgTemplateHelper.isSubTotalRow(row)) {
            String o = (String)row.getUserObjectValue("subTotal_row");
            String[] oArr = o.split(",");
            int startRowIndex = -1;
            int endRowIndex = -1;
            if (oArr != null && oArr.length == 2) {
                try {
                    startRowIndex = Integer.parseInt(oArr[0]);
                    endRowIndex = Integer.parseInt(oArr[1]);
                }
                catch (Exception e) {
                    return pos;
                }
                if (startRowIndex > -1 && endRowIndex > -1) {
                    endRowIndex += headerRowCount;
                    int previousPos = -1;
                    for (int index = startRowIndex += headerRowCount; index <= endRowIndex; ++index) {
                        if (MBgTemplateHelper.isSubTotalRow(sheet.getRow(index, false))) continue;
                        if (previousPos == -1) {
                            previousPos = index;
                        }
                        if ((MBgTemplateHelper.isSubTotalRow(sheet.getRow(index + 1, false)) || index == endRowIndex) && !MBgTemplateHelper.isDimTotalRow(sheet.getRow(index, false))) {
                            pos.add(new Rect(-1, previousPos, -1, index));
                            previousPos = -1;
                        }
                        if (!MBgTemplateHelper.isDimTotalRow(sheet.getRow(index + 1, false))) continue;
                        pos.add(new Rect(-1, previousPos, -1, index));
                        previousPos = -1;
                        ++index;
                    }
                }
            }
        }
        return pos;
    }

    public static Cell getCell(Sheet sheet, int rowIndex, int colIndex, boolean isCreat) {
        Cell tmpCell = sheet.getCell(rowIndex, colIndex, isCreat);
        if (sheet.getMergeBlock(rowIndex, colIndex) != null) {
            CellBlock blockMerge = sheet.getMergeBlock(rowIndex, colIndex);
            tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), true);
        }
        return tmpCell;
    }

    public static void setCellStyle(Sheet sheet, int rowIndex, int colIndex, boolean isCreat, StyleAttributes colHeaderStyle, StyleAttributes saInnerBorder) {
        Range r = MBgTemplateHelper.getRange(sheet, rowIndex, colIndex, isCreat);
        if (r != null) {
            MBgTemplateHelper.setRangeStyle(r, colHeaderStyle, saInnerBorder);
        }
    }

    public static void setRangeStyle(Sheet sheet, int rowIndex, int colIndex, int row2Inddex, int col2Index, StyleAttributes colHeaderStyle, StyleAttributes saInnerBorder) {
        Range r = sheet.getRange(rowIndex, colIndex, row2Inddex, col2Index);
        if (r != null) {
            MBgTemplateHelper.setRangeStyle(r, colHeaderStyle, saInnerBorder);
        }
    }

    public static void setSheetLocked(Sheet sheet) {
        StyleAttributes s1 = Styles.getEmptySA();
        StyleAttributes sa = Styles.getEmptySA();
        s1.setLocked(true);
        MBgTemplateHelper.setRangeStyle(sheet.getSheetRange(), s1, sa);
    }

    public static void setRangeStyle(Range range, StyleAttributes colHeaderStyle, StyleAttributes saInnerBorder) {
        if (range != null) {
            long st = System.currentTimeMillis();
            MBgTemplateHelper.logTime("Start MbgTemplate.setRangeStyle");
            StyleAttributes s1 = Styles.getEmptySA();
            StyleAttributes s2 = Styles.getEmptySA();
            range.getStyle(s1, s2);
            if (colHeaderStyle != null) {
                s1.replace((ShareStyleAttributes)colHeaderStyle);
            }
            if (saInnerBorder != null) {
                s2.replace((ShareStyleAttributes)saInnerBorder);
            }
            range.setIgnoreProtected(true);
            range.setStyle(s1, s2);
            if (System.currentTimeMillis() - st > 100L) {
                MBgTemplateHelper.logTime("End MbgTemplate.setRangeStyle");
            }
        }
    }

    public static Range getRange(Sheet sheet, int rowIndex, int colIndex, boolean isCreat) {
        Cell tmpCell = MBgTemplateHelper.getCell(sheet, rowIndex, colIndex, isCreat);
        return sheet.getRange(tmpCell);
    }

    public static String getDimensionMemeberSign(BgDimensionMember member) {
        if (member == null) {
            return null;
        }
        if (member.getNumber() == null) {
            return null;
        }
        String srcNumber = member.getSrcNumberHasDefault();
        if (srcNumber != null) {
            return DimensionFormulaHelper.getCombination(srcNumber, member.getNumber());
        }
        return DimensionFormulaHelper.getCombination("", member.getNumber());
    }

    public static String getShortCombin(List<BgDimensionMember> members) {
        if (members == null) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder();
        for (int j = 0; j < members.size(); ++j) {
            strBuilder.append(members.get(j).getNumber() == null ? "" : MBgTemplateHelper.getDimensionMemeberSign(members.get(j)));
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    public static String getDimensionMemeberSignForOrgDimension(String orgNum) {
        if (orgNum == null) {
            return null;
        }
        return DimensionConstants.DEF_ORGUNIT_SRCNUMBER + ":" + orgNum;
    }

    public static void signRootItem(ICell cell, Boolean isRootItem) {
        if (cell == null) {
            return;
        }
        cell.setUserObject((Object)isRootItem);
    }

    public static boolean isRootItem(ICell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObject();
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void insertNewMemberByOrder(List<BgDimensionMember> members, BgDimensionMember newMember) {
        if (members == null || newMember == null) {
            return;
        }
        boolean isInsert = false;
        for (int i = 0; i < members.size(); ++i) {
            if (BgViewHelper.getNumber(members.get(i)).compareTo(newMember.getNumber()) <= 0) continue;
            members.add(i, newMember);
            isInsert = true;
            break;
        }
        if (!isInsert) {
            members.add(newMember);
        }
    }

    public static void collectDimensionSrcNums(List<BgDimensionMember> newMembers, Set<String> outParam) {
        if (newMembers == null || outParam == null) {
            return;
        }
        for (int i = 0; i < newMembers.size(); ++i) {
            if (newMembers.get(i).getSrcNumber() == null) continue;
            outParam.add(newMembers.get(i).getSrcNumber());
        }
    }

    public static void startLog(String msg) {
        startTime = System.currentTimeMillis();
        logger.info((Object)("*******************" + msg + ":" + startTime + "ms"));
    }

    public static void logTime(String msg) {
        logger.info((Object)("*******************" + msg + ":" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public static void initTotal() {
        totalTime = 0L;
        MBgTemplateHelper.oneStart();
    }

    public static void oneStart() {
        st = System.currentTimeMillis();
    }

    public static void oneEnd() {
        totalTime += System.currentTimeMillis() - st;
    }

    public static void logTotalTime(String msg) {
        logger.info((Object)("*******************" + msg + ":" + totalTime + "ms"));
    }
}

