/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgViewListDimensionMember
extends BgDimensionMember
implements Cloneable {
    private static final long serialVersionUID = 7985711705855371219L;
    private String source = null;

    public MbgViewListDimensionMember(String type, String attribute, String name, String number) {
        super(type, attribute, name, number);
    }

    public void setSource(BgVariateInfo source) {
        this.setSource(source.getNumber());
    }

    public void setSource(BgPeriodInfo source) {
        this.setSource(source.getNumber());
    }

    public void setSource(BgPropertyInfo source) {
        this.setSource(source.getNumber());
    }

    public void setSource(BgDimensionMember source) {
        this.setSource(source.getNumber());
    }

    private void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public MbgViewListDimensionMember clone() throws CloneNotSupportedException {
        MbgViewListDimensionMember member = (MbgViewListDimensionMember)super.clone();
        member.setSource(this.getSource());
        return member;
    }

    public static MbgViewListDimensionMember getInstance(BgDimensionMember member) {
        if (member == null) {
            return null;
        }
        MbgViewListDimensionMember vMember = new MbgViewListDimensionMember(member.getType(), member.getAttribute(), member.getName(), member.getNumber());
        vMember.setAlias(member.getAlias());
        vMember.setLeaf(member.isLeaf());
        vMember.setLevel(member.getLevel());
        vMember.setSortValue(member.getSortValue());
        vMember.setSrcNumber(member.getSrcNumber());
        vMember.setVersion(member.getVersion());
        vMember.setSimpleName(member.getSimpleName());
        vMember.setLongName(member.getLongName());
        if (member instanceof MbgViewListDimensionMember) {
            vMember.setSource(((MbgViewListDimensionMember)member).getSource());
        }
        return vMember;
    }

    public static void addMember(BgDimensionMember member, List<BgDimensionMember> targetMembers, Object source, boolean isOnlyLeaf) {
        HashSet<String> numbers = new HashSet<String>();
        if (targetMembers != null && !targetMembers.isEmpty()) {
            for (BgDimensionMember m : targetMembers) {
                numbers.add(m.getNumber());
            }
        }
        if (member != null && targetMembers != null && source != null) {
            if (isOnlyLeaf && !member.isLeaf()) {
                return;
            }
            if (!numbers.isEmpty() && numbers.contains(member.getNumber())) {
                return;
            }
            MbgViewListDimensionMember vMember = MbgViewListDimensionMember.getInstance(member);
            if (source instanceof BgVariateInfo) {
                vMember.setSource((BgVariateInfo)source);
            } else if (source instanceof BgPeriodInfo) {
                vMember.setSource((BgPeriodInfo)source);
            } else if (source instanceof BgPropertyInfo) {
                vMember.setSource((BgPropertyInfo)source);
            } else if (source instanceof BgDimensionMember) {
                vMember.setSource((BgDimensionMember)source);
            } else if (source instanceof BgDimensionBaseInfo) {
                vMember.setSource(((BgDimensionBaseInfo)source).getNumber());
            }
            targetMembers.add(vMember);
        }
    }

    public static void addMembers(List<BgDimensionMember> sourceMembers, List<BgDimensionMember> targetMembers, Object source, boolean isShowLevel, boolean isOnlyLeaf) {
        if (sourceMembers == null || targetMembers == null) {
            return;
        }
        Collections.sort(sourceMembers);
        BgDimensionMember member = null;
        if (!isOnlyLeaf) {
            HashMap<Object, List<BgDimensionMember>> memberMap = new HashMap<Object, List<BgDimensionMember>>();
            for (int i = 0; i < sourceMembers.size(); ++i) {
                if (!memberMap.containsKey(sourceMembers.get(i).getSortValue())) {
                    memberMap.put(sourceMembers.get(i).getSortValue(), new ArrayList());
                }
                ((List)memberMap.get(sourceMembers.get(i).getSortValue())).add(sourceMembers.get(i));
            }
            HashSet<String> hasLevelSet = new HashSet<String>();
            for (int i = 0; i < sourceMembers.size(); ++i) {
                member = sourceMembers.get(i);
                if (isShowLevel) {
                    MbgViewListDimensionMember.setLevel(member, memberMap, hasLevelSet);
                    MbgViewListDimensionMember.setLeaf(member, sourceMembers, i);
                    continue;
                }
                member.setLevel(0);
                member.setLeaf(true);
            }
        }
        Iterator<BgDimensionMember> it = sourceMembers.iterator();
        while (it.hasNext()) {
            MbgViewListDimensionMember.addMember(it.next(), targetMembers, source, isOnlyLeaf);
        }
    }

    private static void setLeaf(BgDimensionMember member, List memberList, int index) {
        if (index + 1 >= memberList.size()) {
            return;
        }
        BgDimensionMember child = (BgDimensionMember)memberList.get(index + 1);
        if (((String)((Object)child.getSortValue())).startsWith(member.getSortValue() + "!")) {
            member.setLeaf(false);
        }
    }

    private static void setLevel(BgDimensionMember member, Map<Object, List<BgDimensionMember>> memberMap, Set<String> hasLevelSet) {
        member.setLevel(0);
        String thisLongNumber = (String)((Object)member.getSortValue());
        if (thisLongNumber.indexOf("!") < 0) {
            hasLevelSet.add(thisLongNumber);
            return;
        }
        String pLongNumber = thisLongNumber.substring(0, thisLongNumber.lastIndexOf("!"));
        if (hasLevelSet.contains(pLongNumber)) {
            member.setLevel(memberMap.get(pLongNumber).get(0).getLevel() + 1);
        } else if (!memberMap.containsKey(pLongNumber)) {
            member.setLevel(0);
        } else {
            BgDimensionMember pMember = memberMap.get(pLongNumber).get(0);
            MbgViewListDimensionMember.setLevel(pMember, memberMap, hasLevelSet);
            for (int i = 1; i < memberMap.get(pLongNumber).size(); ++i) {
                memberMap.get(pLongNumber).get(i).setLevel(pMember.getLevel());
            }
            member.setLevel(pMember.getLevel() + 1);
        }
        hasLevelSet.add(thisLongNumber);
    }

    private static void setLevel(BgDimensionMember member, List memberList, int index) {
        member.setLevel(0);
        String thisLongNumber = (String)((Object)member.getSortValue());
        if (thisLongNumber.indexOf("!") < 0 || index == 0) {
            return;
        }
        String pLongNumber = thisLongNumber.substring(0, thisLongNumber.lastIndexOf("!"));
        for (int i = index - 1; i >= 0; --i) {
            BgDimensionMember pMember = (BgDimensionMember)memberList.get(i);
            String longNumber = (String)((Object)pMember.getSortValue());
            if (longNumber.equals(pLongNumber)) {
                member.setLevel(pMember.getLevel() + 1);
                break;
            }
            if (!longNumber.startsWith(pLongNumber + "!")) break;
        }
    }
}

