/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewBase;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MbgViewListManager
extends AbstractMbgViewBase<MbgViewListSheetManager>
implements Cloneable {
    private static final long serialVersionUID = 5780986498094687331L;
    public static final String CURR_VERSION = "2.0";
    private BgHideItemEnum rowHide = BgHideItemEnum.UNHIDE;
    private BgHideItemEnum colHide = BgHideItemEnum.UNHIDE;
    private transient ViewListMemberCacheHelper memberCacheHelper = null;
    private transient Map orgUnitMap = null;
    private transient Map<String, BgPeriodDispCollection> periodCache = null;
    private boolean isParseProperty = true;
    private boolean isNeedReadRelation = true;

    public static MbgViewListManager getDefaultViewManagerImpl(List<BgDimensionInfo> dimensions) {
        MbgViewListManager view = new MbgViewListManager();
        MbgViewListSheetManager sheet = MbgViewListManager.getDefaultSheetManagerImpl(view, dimensions);
        view.getSheetManagers().add(sheet);
        return view;
    }

    public static MbgViewListSheetManager getDefaultSheetManagerImpl(MbgViewListManager view, List<BgDimensionInfo> dimensions) {
        MbgViewListSheetManager sheet = new MbgViewListSheetManager(view, view.getSheetManagers().size(), "Sheet" + (view.getSheetSequence() + 1));
        if (dimensions != null) {
            MbgViewListDimensionInfo viewListDim = null;
            MbgViewListDimensionInfo bgAccountDim = null;
            MbgViewListDimensionInfo bgPeriodDim = null;
            for (int i = 0; i < dimensions.size(); ++i) {
                viewListDim = new MbgViewListDimensionInfo(sheet.getDimensionManager());
                dimensions.get(i).cloneValue(viewListDim);
                viewListDim.setLayout("page");
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(viewListDim.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(viewListDim.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setMemberValueType(DimensionMemberValueModeEnum.Null);
                } else if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setLayout("row");
                    bgAccountDim = viewListDim;
                    bgAccountDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setLayout("col");
                    bgPeriodDim = viewListDim;
                    bgPeriodDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                } else {
                    viewListDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                }
                sheet.getDimensionManager().addDimensionInfo(viewListDim);
            }
            MbgViewListRowCol rowObject = new MbgViewListRowCol();
            rowObject.getDimensions().add(bgAccountDim);
            sheet.getDimensionManager().getRows().add(rowObject);
            MbgViewListRowCol colObject = new MbgViewListRowCol();
            colObject.getDimensions().add(bgPeriodDim);
            sheet.getDimensionManager().getColumns().add(colObject);
        }
        return sheet;
    }

    public MbgViewListManager() {
        super(CURR_VERSION);
    }

    public BgHideItemEnum getRowHide() {
        return this.rowHide;
    }

    public void setRowHide(BgHideItemEnum rowHide) {
        this.rowHide = rowHide;
    }

    public BgHideItemEnum getColHide() {
        return this.colHide;
    }

    public void setColHide(BgHideItemEnum colHide) {
        this.colHide = colHide;
    }

    public static boolean checkHasRow(List<IMbgViewListObject> rows, int row) {
        return rows != null && --row >= 0 && row < rows.size() && (rows.get(row) instanceof MbgViewListRowCol || rows.get(row) instanceof MbgViewListCalcutor || rows.get(row) instanceof MbgViewListDescription);
    }

    public List<IMbgViewListObject> getRowCols() {
        ArrayList<IMbgViewListObject> objects = new ArrayList<IMbgViewListObject>();
        for (int s = 0; s < this.getSheetManagers().size(); ++s) {
            objects.addAll(((MbgViewListSheetManager)this.getSheetManagers().get(s)).getDimensionManager().getRowCols());
        }
        return objects;
    }

    public void synLevelConfig(MbgViewListManager curMbgViewManager) {
        for (int s = 0; s < this.getSheetManagers().size(); ++s) {
            ((MbgViewListSheetManager)this.getSheetManagers().get(s)).getDimensionManager().synLevelConfig(((MbgViewListSheetManager)curMbgViewManager.getSheetManagers().get(s)).getDimensionManager());
        }
    }

    public void synRowColInitIndex() {
        for (int s = 0; s < this.getSheetManagers().size(); ++s) {
            ((MbgViewListSheetManager)this.getSheetManagers().get(s)).getDimensionManager().synRowColInitIndex();
        }
    }

    public boolean isEquals(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return false;
        }
        if (viewManager.getSheetManagers().size() != this.getSheetManagers().size()) {
            return false;
        }
        if (!viewManager.getColHide().equals((Object)this.getColHide()) || !viewManager.getRowHide().equals((Object)this.getRowHide())) {
            return false;
        }
        if (!Arrays.equals(viewManager.getValueVariates().toArray(), this.getValueVariates().toArray())) {
            return false;
        }
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            if (((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).isEqulas((MbgViewListSheetManager)this.getSheetManagers().get(s))) continue;
            return false;
        }
        return true;
    }

    public MbgViewListManager clone() {
        try {
            MbgViewListManager clone = (MbgViewListManager)super.clone();
            clone.setSheetManagers(new ArrayList());
            MbgViewListSheetManager sheet = null;
            for (int i = 0; i < this.getSheetManagers().size(); ++i) {
                sheet = ((MbgViewListSheetManager)this.getSheetManagers().get(i)).clone();
                sheet.setView(clone);
                clone.getSheetManagers().add(sheet);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setMemberCacheHelper(ViewListMemberCacheHelper memberCacheHelper) {
        this.memberCacheHelper = memberCacheHelper;
    }

    public ViewListMemberCacheHelper getMemberCacheHelper() {
        return this.memberCacheHelper;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public void setOrgUnitMap(Map orgUnitMap) {
        this.orgUnitMap = orgUnitMap;
    }

    public void setPeriodCache(Map<String, BgPeriodDispCollection> periodCache) {
        this.periodCache = periodCache;
    }

    public Map<String, BgPeriodDispCollection> getPeriodCache() {
        return this.periodCache;
    }

    public void setParseProperty(boolean isParseProperty) {
        this.isParseProperty = isParseProperty;
    }

    public boolean isParseProperty() {
        return this.isParseProperty;
    }

    public void setNeedReadRelation(boolean isNeedReadRelation) {
        this.isNeedReadRelation = isNeedReadRelation;
    }

    public boolean isNeedReadRelation() {
        return this.isNeedReadRelation;
    }
}

