/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormTitleEnum;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionLoader;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.FormStyleInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgSheetManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.util.StringUtils;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MbgXMLParser {
    private Context ctx;
    private static final Logger logger = Logger.getLogger((String)MbgXMLParser.class.getName());
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_ISUPDATED = "isUpdated";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_EDIT_SCEN_NUMBER = "editScenNumber";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_FONT_SIZE = "font_size";
    public static final String ATTR_FONT_STYLE = "font_style";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_HORIZONTAL_ALIGN = "horizontalAlign";
    public static final String ATTR_APPOINT_POSITION = "appointPosition";
    public static final String ATTR_POSITION = "position";
    public static final String ATTR_PRECISION = "precision";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_DISPLAY = "display";
    public static final String ATTR_SHEET_SEQUENCE = "sheetSequence";
    public static final String ATTR_DISPLAY_FORMAT = "display-format";
    public static final String ATTR_CURRENCYDECNUMS = "currencyDecNums";
    public static final String ATTR_NOCURRENCYDECNUMS = "noCurrencyDecNums";
    public static final String ATTR_RATEDECNUMS = "rateDecNums";
    public static final String ATTR_CURRENCYHASGROUPSEP = "currencyHasGroupSep";
    public static final String ATTR_NOCURRENCYGROUPSEP = "noCurrencyGroupSep";
    public static final String ATTR_RATEHASGROUPSEP = "rateHasGroupSep";
    public static final String ATTR_CURRENCYNEGATIVEINDEX = "currencyNegativeIndex";
    public static final String ATTR_NOCURRENCYNEGATIVEINDEX = "noCurrencyNegativeIndex";
    public static final String ATTR_RATENEGATIVEINDEX = "rateNegativeIndex";
    public static final String ATTR_CURRENCYMEASUREUNIT = "currencyMeasureUnit";
    public static final String ATTR_NOCURRENCYMEASUREUNIT = "noCurrencyMeasureUnit";
    public static final String ATTR_RATEMEASUREUNIT = "rateMeasureUnit";
    public static final String ATTR_SPLIT_FIRSTROW = "firstRow";
    public static final String ATTR_SPLIT_FIRSTCOL = "firstCol";
    public static final String ATTR_SPLIT_FIRSTROW2 = "firstRow2";
    public static final String ATTR_SPLIT_FIRSTCOL2 = "firstCol2";
    public static final String ATTR_SPLIT_COLSPLIT = "colSplit";
    public static final String ATTR_SPLIT_ROWSPLIT = "rowSplit";
    public static final String ATTR_SPLIT_ACTIVEPANE = "activePane";
    public static final String ATTR_SPLIT_ISFREEZED = "isFreezed";
    public static final String ATTR_SPLIT_COLFIXLINE = "colFixLine";
    public static final String ATTR_SPLIT_ROWFIXLINE = "rowFixLine";
    public static final String DOCUMENT_SHEET = "sheet";
    public static final String DOCUMENT_ALIAS = "alias";
    public static final String DOCUMENT_COL_NAME = "columnName";
    public static final String DOCUMENT_INDEX = "index";
    public static final String DOCUMENT_SUB_TOTAL = "subTotal";
    public static final String DOCUMENT_DIM_TOTAL = "dimTotal";
    public static final String DOCUMENT_HAS_SHOW = "hasShow";
    public static final String DOCUMENT_PERIOD_SHOW_STYLE = "periodShowStyle";
    public static final String DOCUMENT_NUMBER = "number";
    public static final String DOCUMENT_MEMBER_VALUE_TYPE = "memberValueType";
    public static final String DOCUMNET_DINAMIC_ADD_MEMBER = "dinamicAddMember";
    public static final String DOCUMNET_DINAMIC_SELECT_RELATIONSHIP = "selectRelationship";
    public static final String DOCUMNET_DINAMIC_ADD_MEMBER_Range = "dinamicAddMemberRange";
    public static final String DOCUMENT_MEMBER_MAPPING = "mapping";
    public static final String DOCUMENT_EXT_PROPERTY = "extProperty";
    public static final String DOCUMENT_PROPERTIES = "properties";
    public static final String DOCUMENT_CALCULATE = "calculate";
    public static final String DOCUMENT_FORMULA = "formula";
    public static final String DOCUMENT_DESCRIPTION = "description";
    public static final String DOCUMENT_PROPERTY = "property";
    public static final String DOCUMENT_REFCOLUMN = "refColumn";
    public static final String DOCUMENT_MEMBER = "member";
    public static final String DOCUMENT_STYLE = "style";
    public static final String DOCUMENT_HEAD_STYLE = "headStyle";
    public static final String DOCUMENT_UNIT = "unit";
    public static final String DOCUMENT_DATE = "date";
    public static final String DOCUMENT_MEASURE_UNIT = "measureUnit";
    public static final String DOCUMENT_FORMNUMBER = "formNumber";
    public static final String DOCUMENT_COLUMN = "column";
    public static final String DOCUMENT_CELL = "cell";
    public static final String DOCUMENT_CURRENCYUNIT = "currencyUnit";
    public static final String DOCUMENT_CURRENCY = "currency";
    public static final String DOCUMENT_NOCURRENCYUNIT = "noCurrency";
    public static final String DOCUMENT_RATE = "rate";
    public static final String DOCUMENT_RELATION_MAP = "relationMap";
    public static final String DOCUMENT_RELATION_GROUP = "group";
    public static final String DOCUMENT_RELATIONSHIP = "relationShip";
    public static final String DOCUMENT_ID = "id";
    public static final String DOCUMENT_SRC_ID = "srcId";
    public static final String DOCUMENT_SRC_NUMBER = "srcNumber";
    public static final String DOCUMENT_NAME = "name";
    public static final String DOCUMENT_FROM_DIMENSION = "dimensionSrc";
    public static final String DOCUMENT_DIMENSION_NUMBER = "dimensionNumber";
    public static final String DOCUMENT_DIMENSION_NAME = "dimensionName";
    public static final String DOCUMENT_STYLE_WIDTH = "width";
    public static final String DOCUMENT_BGPERIODTYPE = "bgPeriodType";
    public static final String DOCUMENT_SPLIT_INFO = "splitInfo";
    public static final String DOCUMENT_SHEET_ID = "sheetID";

    public MbgXMLParser() {
    }

    public MbgXMLParser(Context ctx) {
        this.ctx = ctx;
    }

    public IMbgViewManager parse(byte[] dataBytes, byte[] styleBytes) throws Exception {
        IMbgViewManager iMbgViewManager = this.parse(dataBytes);
        this.parseStyle(iMbgViewManager, styleBytes);
        return iMbgViewManager;
    }

    public void parseStyle(IMbgViewManager iMbgViewManager, byte[] styleBytes) throws Exception {
        if (iMbgViewManager == null) {
            return;
        }
        if (styleBytes == null) {
            IBgDimensionManager iBgDimensionManager = null;
            for (int sheetIndex = 0; sheetIndex < iMbgViewManager.getSheetManagers().size(); ++sheetIndex) {
                iBgDimensionManager = iMbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager();
                if (iBgDimensionManager == null) continue;
                iBgDimensionManager.reloadDefaultDisplayDimension();
                iBgDimensionManager.copyStyleToOld();
            }
        } else {
            Element view;
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(styleBytes));
            if (document != null && document.getRootElement() != null && (view = document.getRootElement()) != null && "view".equalsIgnoreCase(view.getName())) {
                this.parseStyleView(iMbgViewManager, view);
            }
        }
    }

    private void parseStyleView(IMbgViewManager iMbgViewManager, Element styleView) {
        Element sheetEle = null;
        int sheetIndex = -1;
        IBgDimensionManager iBgDimensionManager = null;
        Iterator iterator = styleView.elementIterator(DOCUMENT_SHEET);
        while (iterator.hasNext()) {
            sheetEle = (Element)iterator.next();
            sheetIndex = Integer.parseInt(BgViewHelper.getElementAttr(sheetEle, "index"));
            iBgDimensionManager = iMbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager();
            Element elementEle = null;
            Iterator itLayout = sheetEle.elementIterator();
            block1: while (itLayout.hasNext()) {
                Element layoutEle = (Element)itLayout.next();
                Iterator itStyle = layoutEle.elementIterator();
                while (itStyle.hasNext()) {
                    Element e = (Element)itStyle.next();
                    if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(BgViewHelper.getElementValue(e, DOCUMENT_NUMBER))) {
                        elementEle = e.element(DOCUMENT_NUMBER);
                        continue;
                    }
                    if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(BgViewHelper.getElementValue(e, DOCUMENT_NUMBER))) continue;
                    elementEle = null;
                    break block1;
                }
            }
            if (elementEle != null) {
                elementEle.setText(DimensionConstants.DEF_ELEMENT_NUMBER);
            }
            this.loadStyle(iBgDimensionManager.getViewDisplayDimension(), iBgDimensionManager.getDimension(), "view", sheetEle);
            this.loadStyle(iBgDimensionManager.getPageDisplayDimension(), iBgDimensionManager.getDimension(), "page", sheetEle);
            this.loadStyle(iBgDimensionManager.getRowDisplayDimension(), iBgDimensionManager.getDimension(), "row", sheetEle);
            this.loadStyle(iBgDimensionManager.getColDisplayDimension(), iBgDimensionManager.getDimension(), "col", sheetEle);
            this.loadStyle(iBgDimensionManager.getHideDisplayDimension(), iBgDimensionManager.getDimension(), "hide", sheetEle);
            ArrayList dimensions = new ArrayList(iBgDimensionManager.getDimension());
            dimensions.removeAll(iBgDimensionManager.getViewDisplayDimension());
            dimensions.removeAll(iBgDimensionManager.getPageDisplayDimension());
            dimensions.removeAll(iBgDimensionManager.getRowDisplayDimension());
            dimensions.removeAll(iBgDimensionManager.getColDisplayDimension());
            dimensions.removeAll(iBgDimensionManager.getHideDisplayDimension());
            for (int d = 0; d < dimensions.size(); ++d) {
                BgDimensionInfo dim = (BgDimensionInfo)dimensions.get(d);
                String layout = dim.getLayout();
                if ("view".equals(layout)) {
                    iBgDimensionManager.getViewDisplayDimension().add(dim);
                    continue;
                }
                if ("page".equals(layout)) {
                    iBgDimensionManager.getPageDisplayDimension().add(dim);
                    continue;
                }
                if ("row".equals(layout)) {
                    iBgDimensionManager.getRowDisplayDimension().add(dim);
                    continue;
                }
                if (!"col".equals(layout)) continue;
                iBgDimensionManager.getColDisplayDimension().add(dim);
            }
            iBgDimensionManager.copyStyleToOld();
        }
    }

    private void loadStyle(List<BgDimensionInfo> targetDimens, List<BgDimensionInfo> dimensionList, String layoutType, Element sheet) {
        Element element = sheet.element(layoutType);
        if (element != null) {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element member = (Element)iterator.next();
                String number = BgViewHelper.getElementValue(member, DOCUMENT_NUMBER);
                for (BgDimensionInfo dimensionInfo : dimensionList) {
                    if (!number.equals(dimensionInfo.getNumber())) continue;
                    targetDimens.add(dimensionInfo);
                }
            }
        }
    }

    public IMbgViewManager parse(byte[] bytes) throws Exception {
        Element view;
        if (bytes == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        MbgViewManagerImpl mbgViewManager = new MbgViewManagerImpl();
        if (document != null && document.getRootElement() != null && (view = document.getRootElement()) != null && "view".equalsIgnoreCase(view.getName())) {
            String version = BgViewHelper.getElementAttr(view, ATTR_VERSION);
            mbgViewManager.setUpdated(Boolean.TRUE.toString().equalsIgnoreCase(BgViewHelper.getElementAttr(view, ATTR_ISUPDATED)));
            String sheetSequence = BgViewHelper.getElementAttr(view, ATTR_SHEET_SEQUENCE);
            if (StringUtils.isEmpty((String)version)) {
                MbgSheetManagerImpl sheet = new MbgSheetManagerImpl(mbgViewManager);
                mbgViewManager.getSheetManagers().add(sheet);
                mbgViewManager.getSheetManagers().get(0).setDimensionManager(new BgDimensionManagerImpl(this.ctx, sheet));
                new BgDimensionLoader().loadDimension(mbgViewManager.getSheetManagers().get(0).getDimensionManager(), view);
                throw new TemplateException(TemplateException.UPGRADE);
            }
            mbgViewManager.setVersion(version);
            MbgViewListXMLParser.parseValueVariate(mbgViewManager, view);
            this.parseView(mbgViewManager, view);
            try {
                mbgViewManager.setSheetSequence(Integer.parseInt(sheetSequence));
            }
            catch (Exception e) {
                mbgViewManager.setSheetSequence(mbgViewManager.getSheetManagers().size());
            }
            this.parseRelationMap(mbgViewManager, view);
        }
        for (IMbgSheetManager sheet : mbgViewManager.getSheetManagers()) {
            BgDimensionInfo dimension = sheet.getDimensionManager().searchDimension("BG_Scen");
            if (dimension == null || (dimension = sheet.getDimensionManager().searchDimension("BG_Scenario")) == null) continue;
            dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
            dimension.parse();
            dimension = sheet.getDimensionManager().searchDimension("BG_Scen");
            dimension.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
            dimension.parse();
        }
        return mbgViewManager;
    }

    private void parseRelationMap(IMbgViewManager viewManager, Element viewElement) {
        if (viewManager == null || viewElement == null) {
            return;
        }
        ArrayList<MbgRelationMap> maps = new ArrayList<MbgRelationMap>();
        viewManager.setRelationMaps(maps);
        Iterator it = viewElement.elementIterator(DOCUMENT_RELATION_MAP);
        while (it.hasNext()) {
            Element relationElement = (Element)it.next();
            if (relationElement.element(DOCUMENT_RELATION_GROUP) == null) continue;
            MbgRelationMap relationMap = new MbgRelationMap(viewManager);
            maps.add(relationMap);
            this.parseRelationGroup(relationMap, relationElement.element(DOCUMENT_RELATION_GROUP));
            Iterator itShip = relationElement.elementIterator(DOCUMENT_RELATIONSHIP);
            while (itShip.hasNext()) {
                relationMap.getRelationShips().add(this.parseRelationShip((Element)itShip.next()));
            }
        }
    }

    private DimensionRelationshipInfo parseRelationShip(Element shipElement) {
        DimensionRelationshipInfo ship = new DimensionRelationshipInfo();
        ship.setDimensionNumber(BgViewHelper.getElementValue(shipElement, DOCUMENT_DIMENSION_NUMBER));
        ship.setDimensionName(BgViewHelper.getElementValue(shipElement, DOCUMENT_DIMENSION_NAME));
        return ship;
    }

    private void parseRelationGroup(MbgRelationMap relationMap, Element groupElement) {
        DimensionRelationshipGroupInfo group = new DimensionRelationshipGroupInfo();
        relationMap.setGroup(group);
        group.setId(BOSUuid.read((String)BgViewHelper.getElementValue(groupElement, DOCUMENT_ID)));
        group.setNumber(BgViewHelper.getElementValue(groupElement, DOCUMENT_NUMBER));
        group.setName(BgViewHelper.getElementValue(groupElement, "name"));
        Iterator it = groupElement.elementIterator(DOCUMENT_FROM_DIMENSION);
        while (it.hasNext()) {
            Element element = (Element)it.next();
            DimRelashipGroupEntryInfo entry = new DimRelashipGroupEntryInfo();
            entry.setDimRelashipGroup(group);
            this.parseRelationDimension(entry, element);
            group.getEntries().add(entry);
        }
    }

    private void parseRelationDimension(DimRelashipGroupEntryInfo entry, Element relationDimension) {
        entry.setDimNumber(BgViewHelper.getElementValue(relationDimension, DOCUMENT_DIMENSION_NUMBER));
        entry.setDimName(BgViewHelper.getElementValue(relationDimension, DOCUMENT_DIMENSION_NAME));
    }

    private void parseView(IMbgViewManager mbgViewManager, Element view) throws Exception {
        if (mbgViewManager == null || view == null) {
            return;
        }
        Element sheetEle = null;
        MbgSheetManagerImpl mbgSheetManager = null;
        Iterator iterator = view.elementIterator(DOCUMENT_SHEET);
        while (iterator.hasNext()) {
            sheetEle = (Element)iterator.next();
            mbgSheetManager = new MbgSheetManagerImpl(mbgViewManager);
            mbgSheetManager.setSheetID(BgViewHelper.getElementAttr(sheetEle, DOCUMENT_SHEET_ID));
            mbgSheetManager.setSheetIndex(Integer.parseInt(BgViewHelper.getElementAttr(sheetEle, "index")));
            mbgSheetManager.setSheetName(BgViewHelper.getElementAttr(sheetEle, "name"));
            mbgSheetManager.setEditScenNumber(BgViewHelper.getElementAttr(sheetEle, ATTR_EDIT_SCEN_NUMBER));
            mbgViewManager.getSheetManagers().add(mbgSheetManager);
            this.parseSheet(mbgSheetManager, sheetEle);
            this.parseWidthStyle(mbgSheetManager, sheetEle);
            this.parseSpliteInfo(mbgSheetManager, sheetEle);
        }
    }

    private void parseWidthStyle(IMbgSheetManager mbgSheetManager, Element sheetEle) {
        if (sheetEle == null || mbgSheetManager == null) {
            return;
        }
        mbgSheetManager.getWidthMap().clear();
        Element styleWidth = sheetEle.element(DOCUMENT_STYLE_WIDTH);
        if (styleWidth == null) {
            return;
        }
        Iterator it = styleWidth.elementIterator(DOCUMENT_MEMBER);
        while (it.hasNext()) {
            Element member = (Element)it.next();
            mbgSheetManager.getWidthMap().put(BgViewHelper.getElementValue(member, "name"), new Integer(BgViewHelper.getElementValue(member, ATTR_VALUE)));
        }
    }

    private void parseSheet(IMbgSheetManager mbgSheetManager, Element sheetEle) throws Exception {
        Element styleEle;
        Element extendEle;
        if (mbgSheetManager == null || sheetEle == null) {
            return;
        }
        mbgSheetManager.setDimensionManager(new BgDimensionManagerImpl(this.ctx, mbgSheetManager));
        Element dimensionEle = sheetEle.element("dimension");
        if (dimensionEle != null) {
            this.parseDimensionInfo(mbgSheetManager.getDimensionManager(), dimensionEle);
        }
        if ((extendEle = sheetEle.element(DOCUMENT_EXT_PROPERTY)) != null) {
            this.parseExtendProperty(mbgSheetManager.getDimensionManager(), extendEle);
        }
        if ((styleEle = sheetEle.element("style")) != null) {
            this.parseStyleProperty(mbgSheetManager.getDimensionManager(), styleEle);
        }
        mbgSheetManager.getDimensionManager().verifyData();
        mbgSheetManager.getDimensionManager().copyAllowEditDimension();
    }

    private void parseDimensionInfo(IBgDimensionManager bgDimensionManager, Element dimension) {
        if (bgDimensionManager == null || dimension == null) {
            return;
        }
        BgPeriodTypeInfo bgTypeInfo = null;
        Iterator it = dimension.elementIterator(DOCUMENT_MEMBER);
        while (it.hasNext()) {
            Element memberEle = (Element)it.next();
            String number = BgViewHelper.getElementValue(memberEle, DOCUMENT_NUMBER);
            String alias = BgViewHelper.getElementValue(memberEle, DOCUMENT_ALIAS);
            int memberValueType = Integer.parseInt(BgViewHelper.getElementValue(memberEle, DOCUMENT_MEMBER_VALUE_TYPE));
            String value = BgViewHelper.getElementValue(memberEle, ATTR_VALUE);
            String mappingValue = BgViewHelper.getElementValue(memberEle, DOCUMENT_MEMBER_MAPPING);
            boolean isDinamicAddMember = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMNET_DINAMIC_ADD_MEMBER));
            boolean isSelectRelationship = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMNET_DINAMIC_SELECT_RELATIONSHIP));
            String canAddMemberRange = BgViewHelper.getElementValue(memberEle, DOCUMNET_DINAMIC_ADD_MEMBER_Range);
            String attribute = BgViewHelper.getElementValue(memberEle, "attribute");
            String layout = BgViewHelper.getElementValue(memberEle, "layout");
            String showType = BgViewHelper.getElementValue(memberEle, "showType");
            int index = Integer.parseInt(BgViewHelper.getElementValue(memberEle, "index"));
            Boolean subTotal = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMENT_SUB_TOTAL));
            Boolean dimTotal = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMENT_DIM_TOTAL));
            Boolean isShow = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMENT_HAS_SHOW));
            int periodStyle = 1;
            try {
                periodStyle = Integer.parseInt(BgViewHelper.getElementValue(memberEle, DOCUMENT_PERIOD_SHOW_STYLE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            bgTypeInfo = null;
            Element bgPeriodTypeEle = memberEle.element(DOCUMENT_BGPERIODTYPE);
            if (bgPeriodTypeEle != null) {
                bgTypeInfo = new BgPeriodTypeInfo();
                bgTypeInfo.setId(BOSUuid.read((String)BgViewHelper.getElementValue(bgPeriodTypeEle, DOCUMENT_ID)));
                bgTypeInfo.setNumber(BgViewHelper.getElementValue(bgPeriodTypeEle, DOCUMENT_NUMBER));
                bgTypeInfo.setName(BgViewHelper.getElementValue(bgPeriodTypeEle, "name"));
            }
            this.addDimension(bgDimensionManager, number, alias, memberValueType, value, mappingValue, isDinamicAddMember, canAddMemberRange, attribute, layout, showType, index, subTotal, dimTotal, isShow, periodStyle, isSelectRelationship, bgTypeInfo);
        }
    }

    private void parseExtendProperty(IBgDimensionManager dimensionManager, Element extendEle) {
        Element descripEle;
        Element calculateEle;
        Element properyEle = extendEle.element(DOCUMENT_PROPERTIES);
        if (properyEle != null) {
            this.parseAttributeCol(dimensionManager, properyEle);
        }
        if ((calculateEle = extendEle.element(DOCUMENT_CALCULATE)) != null) {
            this.parseCalcuteCol(dimensionManager, calculateEle);
        }
        if ((descripEle = extendEle.element(DOCUMENT_DESCRIPTION)) != null) {
            this.parseDescriptionCol(dimensionManager, descripEle);
        }
    }

    private void parseAttributeCol(IBgDimensionManager dimensionManager, Element attrEle) {
        if (dimensionManager == null || attrEle == null) {
            return;
        }
        BgAttributeColumn col = null;
        Element attr = null;
        Iterator it = attrEle.elementIterator(DOCUMENT_PROPERTY);
        while (it.hasNext()) {
            attr = (Element)it.next();
            col = new BgAttributeColumn();
            String alias = BgViewHelper.getElementValue(attr, DOCUMENT_ALIAS);
            String dimensionNum = BgViewHelper.getElementValue(attr, DOCUMENT_MEMBER);
            String refColumn = BgViewHelper.getElementValue(attr, DOCUMENT_REFCOLUMN);
            String colName = BgViewHelper.getElementValue(attr, DOCUMENT_COL_NAME);
            String propertyId = BgViewHelper.getElementValue(attr, DOCUMENT_PROPERTY);
            int index = Integer.parseInt(BgViewHelper.getElementValue(attr, "index"));
            if (colName == null) {
                colName = alias;
            }
            col.setAlias(alias);
            col.setColumnName(colName);
            col.setRefColumn(refColumn);
            col.setPropertyId(propertyId);
            col.setAlias(alias);
            col.setDimensionInfo(dimensionManager.getDimension(), dimensionNum);
            col.setIndex(index);
            dimensionManager.getAttributeCol().add(col);
        }
    }

    private void parseCalcuteCol(IBgDimensionManager dimensionManager, Element calculateEle) {
        if (dimensionManager == null || calculateEle == null) {
            return;
        }
        BgCalcuteColumn col = null;
        Element cal = null;
        Iterator it = calculateEle.elementIterator(DOCUMENT_PROPERTY);
        while (it.hasNext()) {
            cal = (Element)it.next();
            col = new BgCalcuteColumn();
            String alias = BgViewHelper.getElementValue(cal, DOCUMENT_ALIAS);
            String formula = BgViewHelper.getElementValue(cal, DOCUMENT_FORMULA);
            int index = Integer.parseInt(BgViewHelper.getElementValue(cal, "index"));
            col.setFormula(formula);
            col.setAlias(alias);
            col.setIndex(index);
            dimensionManager.getCalcuteCol().add(col);
        }
    }

    private void parseDescriptionCol(IBgDimensionManager dimensionManager, Element member) {
        if (dimensionManager == null || member == null) {
            return;
        }
        BgDescriptionColumn col = null;
        Element desc = null;
        ArrayList<String> numbers = new ArrayList<String>();
        Iterator it = member.elementIterator(DOCUMENT_PROPERTY);
        while (it.hasNext()) {
            desc = (Element)it.next();
            col = new BgDescriptionColumn();
            String alias = BgViewHelper.getElementValue(desc, DOCUMENT_ALIAS);
            int index = Integer.parseInt(BgViewHelper.getElementValue(desc, "index"));
            Iterator itMember = desc.elementIterator(DOCUMENT_MEMBER);
            while (itMember.hasNext()) {
                numbers.add(((Element)itMember.next()).getText());
            }
            col.setAlias(alias);
            col.setIndex(index);
            col.setDimensionInfo(dimensionManager.getDimension(), numbers);
            dimensionManager.getDescriptionCol().add(col);
        }
    }

    private void parseStyleProperty(IBgDimensionManager dimensionManager, Element styleEle) {
        if (dimensionManager == null || styleEle == null) {
            return;
        }
        FormStyleInfo formStyleInfo = dimensionManager.getFormStyleInfo();
        Element headStyleEle = styleEle.element(DOCUMENT_HEAD_STYLE);
        formStyleInfo.setFormName(BgViewHelper.getElementAttr(headStyleEle, ATTR_VALUE));
        formStyleInfo.getFormStyleAttributes().setFont((Font)new KDFont(BgViewHelper.getElementAttr(headStyleEle, ATTR_FONT), 0, Integer.parseInt(BgViewHelper.getElementAttr(headStyleEle, ATTR_SIZE))));
        formStyleInfo.parseStyleAttributes(BgViewHelper.getElementAttr(headStyleEle, "style"), dimensionManager.getFormStyleInfo().getFormStyleAttributes());
        Element unitEle = styleEle.element(DOCUMENT_UNIT);
        formStyleInfo.setUnitName(BgViewHelper.getElementAttr(unitEle, ATTR_VALUE));
        formStyleInfo.setUnitHorizontalAlign(Integer.parseInt(BgViewHelper.getElementAttr(unitEle, ATTR_HORIZONTAL_ALIGN)));
        formStyleInfo.setUnitAppointPosition(Boolean.parseBoolean(BgViewHelper.getElementAttr(unitEle, ATTR_APPOINT_POSITION)));
        formStyleInfo.setUnitPosition(BgViewHelper.getElementAttr(unitEle, ATTR_POSITION));
        Element dateEle = styleEle.element(DOCUMENT_DATE);
        formStyleInfo.setDateName(BgViewHelper.getElementAttr(dateEle, ATTR_VALUE));
        formStyleInfo.setDateHorizontalAlign(Integer.parseInt(BgViewHelper.getElementAttr(dateEle, ATTR_HORIZONTAL_ALIGN)));
        formStyleInfo.setDateAppointPosition(Boolean.parseBoolean(BgViewHelper.getElementAttr(dateEle, ATTR_APPOINT_POSITION)));
        formStyleInfo.setDatePosition(BgViewHelper.getElementAttr(dateEle, ATTR_POSITION));
        Element formNumber = styleEle.element(DOCUMENT_FORMNUMBER);
        if (formNumber != null) {
            formStyleInfo.setFormNumberName(BgViewHelper.getElementAttr(formNumber, ATTR_VALUE));
            formStyleInfo.setFormNumberHorizontalAlign(Integer.parseInt(BgViewHelper.getElementAttr(formNumber, ATTR_HORIZONTAL_ALIGN)));
            formStyleInfo.setFormNumberAppointPosition(Boolean.parseBoolean(BgViewHelper.getElementAttr(formNumber, ATTR_APPOINT_POSITION)));
            formStyleInfo.setFormNumberPosition(BgViewHelper.getElementAttr(formNumber, ATTR_POSITION));
        }
        Element measureUnitEle = styleEle.element(DOCUMENT_MEASURE_UNIT);
        formStyleInfo.setMeasureUnitIsShow(Boolean.parseBoolean(BgViewHelper.getElementAttr(measureUnitEle, ATTR_DISPLAY)));
        formStyleInfo.setMeasureUnitHorizontalAlign(Integer.parseInt(BgViewHelper.getElementAttr(measureUnitEle, ATTR_HORIZONTAL_ALIGN)));
        formStyleInfo.setMeasureUnitAppointPosition(Boolean.parseBoolean(BgViewHelper.getElementAttr(measureUnitEle, ATTR_APPOINT_POSITION)));
        formStyleInfo.setMeasureUnitPosition(BgViewHelper.getElementAttr(measureUnitEle, ATTR_POSITION));
        Element columnEle = styleEle.element(DOCUMENT_COLUMN);
        formStyleInfo.getColumnHeaderStyleAttributes().setFont((Font)new KDFont(BgViewHelper.getElementAttr(columnEle, ATTR_FONT), 0, Integer.parseInt(BgViewHelper.getElementAttr(columnEle, ATTR_SIZE))));
        formStyleInfo.parseStyleAttributes(BgViewHelper.getElementAttr(columnEle, "style"), formStyleInfo.getColumnHeaderStyleAttributes());
        Element cellEle = styleEle.element(DOCUMENT_CELL);
        formStyleInfo.getDataStyleAttributes().setFont((Font)new KDFont(BgViewHelper.getElementAttr(cellEle, ATTR_FONT), 0, Integer.parseInt(BgViewHelper.getElementAttr(cellEle, ATTR_SIZE))));
        formStyleInfo.parseStyleAttributes(BgViewHelper.getElementAttr(cellEle, "style"), formStyleInfo.getDataStyleAttributes());
        formStyleInfo.setDataDecNums(Integer.parseInt(BgViewHelper.getElementAttr(cellEle, ATTR_PRECISION)));
        formStyleInfo.setDataHasGroupSep(Boolean.parseBoolean(BgViewHelper.getElementAttr(cellEle, ATTR_SEPARATOR)));
        formStyleInfo.setDataNegativeIndex(Integer.parseInt(BgViewHelper.getElementAttr(cellEle, ATTR_DISPLAY_FORMAT)));
    }

    private BgDimensionInfo addDimension(IBgDimensionManager bgDimensionManager, String number, String alias, int memberValueType, String value, String mappingValue, boolean isDinamicAddMember, String canAddMemberRange, String attribute, String layout, String showType, int index, boolean subTotal, boolean dimTotal, boolean isShow, int periodStyle, boolean isSelectRelationship, BgPeriodTypeInfo bgPeriodType) {
        BgDimensionInfo dimensionInfo = new BgDimensionInfo(bgDimensionManager);
        dimensionInfo.setNumber(number);
        dimensionInfo.setAlias(alias);
        dimensionInfo.setName(alias);
        dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum(memberValueType));
        dimensionInfo.setValue(value);
        dimensionInfo.parseMappingList(mappingValue);
        dimensionInfo.setDinamicAdd(isDinamicAddMember);
        dimensionInfo.setSelectRelationship(isSelectRelationship);
        dimensionInfo.setCanAddValue(canAddMemberRange);
        dimensionInfo.setAttribute(attribute);
        dimensionInfo.setLayout(layout);
        dimensionInfo.setShowType(showType);
        dimensionInfo.setIndex(index);
        dimensionInfo.setSubTotal(subTotal);
        dimensionInfo.setDimTotal(dimTotal);
        dimensionInfo.setShow(isShow);
        dimensionInfo.setPeriodDisplayStyle(periodStyle);
        dimensionInfo.setBgPeriodType(bgPeriodType);
        bgDimensionManager.addDimensionInfo(dimensionInfo);
        return dimensionInfo;
    }

    public static byte[] unParseStyle(IMbgViewManager mbgViewManager) {
        if (mbgViewManager == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MbgXMLParser.buildStyleDocument(bos, mbgViewManager);
        return bos.toByteArray();
    }

    private static void buildStyleDocument(ByteArrayOutputStream bos, IMbgViewManager mbgViewManager) {
        if (bos == null || mbgViewManager == null) {
            return;
        }
        Document doc = MbgXMLParser.buildStyleDocument(mbgViewManager);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)bos, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private static Document buildStyleDocument(IMbgViewManager mbgViewManager) {
        if (mbgViewManager == null) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement("view");
        view.addAttribute(ATTR_VERSION, mbgViewManager.getVersion() == null ? "1.0" : mbgViewManager.getVersion());
        MbgXMLParser.buildStyleDocument(view, mbgViewManager.getSheetManagers());
        return doc;
    }

    private static void buildStyleDocument(Element parentEle, List<IMbgSheetManager> sheetManagers) {
        if (parentEle == null || sheetManagers == null) {
            return;
        }
        IMbgSheetManager curMbgSheetManager2 = null;
        Element sheet = null;
        for (IMbgSheetManager curMbgSheetManager2 : sheetManagers) {
            sheet = parentEle.addElement(DOCUMENT_SHEET);
            sheet.addAttribute("index", Integer.toString(curMbgSheetManager2.getSheetIndex()));
            sheet.addAttribute("name", curMbgSheetManager2.getSheetName());
            MbgXMLParser.buildStyleDocument(sheet, "view", curMbgSheetManager2.getDimensionManager().getViewDisplayDimension());
            MbgXMLParser.buildStyleDocument(sheet, "page", curMbgSheetManager2.getDimensionManager().getPageDisplayDimension());
            MbgXMLParser.buildStyleDocument(sheet, "col", curMbgSheetManager2.getDimensionManager().getColDisplayDimension());
            MbgXMLParser.buildStyleDocument(sheet, "row", curMbgSheetManager2.getDimensionManager().getRowDisplayDimension());
            MbgXMLParser.buildStyleDocument(sheet, "hide", curMbgSheetManager2.getDimensionManager().getHideDisplayDimension());
        }
    }

    private static void buildStyleDocument(Element parent, String type, List dimens) {
        if (parent == null || StringUtils.isEmpty((String)type) || dimens == null || dimens.isEmpty()) {
            return;
        }
        Element sub = parent.addElement(type);
        for (int i = 0; i < dimens.size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)dimens.get(i);
            Element dimElement = sub.addElement("dimension");
            dimElement.addElement(DOCUMENT_NUMBER).setText(dimen.getNumber());
        }
    }

    public static byte[] unParse(IMbgViewManager mbgViewManager) throws DimensionException {
        if (mbgViewManager == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MbgXMLParser.writeXMLStream(bos, mbgViewManager);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String fileName, IMbgViewManager mbgViewManager) throws DimensionException, IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(new File(fileName));
            MbgXMLParser.writeXMLStream(fos, mbgViewManager);
            fos.close();
        }
    }

    private static void writeXMLStream(OutputStream bos, IMbgViewManager mbgViewManager) throws DimensionException {
        if (bos == null || mbgViewManager == null) {
            return;
        }
        Document doc = MbgXMLParser.buildDocument(mbgViewManager);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(bos, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private static Document buildDocument(IMbgViewManager mbgViewManager) throws DimensionException {
        if (mbgViewManager == null) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement("view");
        view.addAttribute(ATTR_VERSION, mbgViewManager.getVersion() == null ? "1.0" : mbgViewManager.getVersion());
        view.addAttribute(ATTR_ISUPDATED, Boolean.toString(mbgViewManager.isUpdated()));
        view.addAttribute(ATTR_SHEET_SEQUENCE, Integer.toString(mbgViewManager.getSheetSequence()));
        MbgViewListXMLParser.buildDcoumentValueVariate(mbgViewManager, view);
        MbgXMLParser.buildDocument(view, mbgViewManager.getSheetManagers());
        MbgXMLParser.buildRelationMap(view, mbgViewManager.getRelationMaps());
        return doc;
    }

    private static void buildRelationMap(Element view, List<MbgRelationMap> relationMaps) {
        if (view == null || relationMaps == null || relationMaps.isEmpty()) {
            return;
        }
        for (int i = 0; i < relationMaps.size(); ++i) {
            MbgRelationMap relationMap = relationMaps.get(i);
            Element relationElement = view.addElement(DOCUMENT_RELATION_MAP);
            MbgXMLParser.buildGroup(relationElement, relationMap.getGroup());
            for (int s = 0; s < relationMap.getRelationShips().size(); ++s) {
                MbgXMLParser.buildRelationShip(relationElement, relationMap.getRelationShips().get(s));
            }
        }
    }

    private static void buildRelationShip(Element relationElement, DimensionRelationshipInfo relationShip) {
        if (relationElement == null || relationShip == null) {
            return;
        }
        Element element = relationElement.addElement(DOCUMENT_RELATIONSHIP);
        element.addElement(DOCUMENT_DIMENSION_NUMBER).setText(relationShip.getDimensionNumber());
        element.addElement(DOCUMENT_DIMENSION_NAME).setText(relationShip.getDimensionName());
    }

    private static void buildGroup(Element relationElement, DimensionRelationshipGroupInfo group) {
        if (relationElement == null || group == null) {
            return;
        }
        Element groupElement = relationElement.addElement(DOCUMENT_RELATION_GROUP);
        groupElement.addElement(DOCUMENT_ID).setText(group.getId().toString());
        groupElement.addElement(DOCUMENT_NUMBER).setText(group.getNumber());
        groupElement.addElement("name").setText(group.getName());
        for (int i = 0; i < group.getEntries().size(); ++i) {
            MbgXMLParser.buildRelationDimension(group.getEntries().get(i), groupElement.addElement(DOCUMENT_FROM_DIMENSION));
        }
    }

    private static void buildRelationDimension(DimRelashipGroupEntryInfo entry, Element dimension) {
        dimension.addElement(DOCUMENT_DIMENSION_NAME).setText(StringUtils.cnulls((String)entry.getDimName()));
        dimension.addElement(DOCUMENT_DIMENSION_NUMBER).setText(StringUtils.cnulls((String)entry.getDimNumber()));
    }

    private static void buildDocument(Element parentEle, List<IMbgSheetManager> sheetManagers) throws DimensionException {
        if (parentEle == null || sheetManagers == null) {
            return;
        }
        IMbgSheetManager curMbgSheetManager2 = null;
        Element sheet = null;
        for (IMbgSheetManager curMbgSheetManager2 : sheetManagers) {
            sheet = parentEle.addElement(DOCUMENT_SHEET);
            sheet.addAttribute(DOCUMENT_SHEET_ID, curMbgSheetManager2.getSheetID());
            sheet.addAttribute("index", Integer.toString(curMbgSheetManager2.getSheetIndex()));
            sheet.addAttribute("name", curMbgSheetManager2.getSheetName());
            sheet.addAttribute(ATTR_EDIT_SCEN_NUMBER, curMbgSheetManager2.getEditScenNumber());
            MbgXMLParser.buildDocument(sheet, curMbgSheetManager2.getDimensionManager());
            MbgXMLParser.buildWidthDocument(sheet, curMbgSheetManager2);
            MbgXMLParser.buildSpliteDocument(sheet, curMbgSheetManager2);
        }
    }

    private static void buildWidthDocument(Element sheet, IMbgSheetManager curMbgSheetManager) {
        if (sheet == null || curMbgSheetManager == null || curMbgSheetManager.getWidthMap().isEmpty()) {
            return;
        }
        Element styleWidth = sheet.addElement(DOCUMENT_STYLE_WIDTH);
        int defRow = curMbgSheetManager.getWidth(true, -1);
        int defCol = curMbgSheetManager.getWidth(false, -1);
        if (defRow == -1) {
            defRow = 19;
        }
        if (defCol == -1) {
            defCol = 72;
        }
        for (String key : curMbgSheetManager.getWidthMap().keySet()) {
            int value = curMbgSheetManager.getWidthMap().get(key);
            if (!key.endsWith("-1")) {
                int defValue;
                int n = defValue = key.startsWith("row") ? defRow : defCol;
                if (value == defValue) continue;
            }
            Element member = styleWidth.addElement(DOCUMENT_MEMBER);
            member.addElement("name").setText(key);
            member.addElement(ATTR_VALUE).setText(String.valueOf(value));
        }
    }

    private static void buildDocument(Element parentEle, IBgDimensionManager bgDimensionManager) throws DimensionException {
        if (parentEle == null || bgDimensionManager == null) {
            return;
        }
        Element dimensionEle = parentEle.addElement("dimension");
        List dimensions = bgDimensionManager.getDimension();
        BgDimensionInfo bgDimensionInfo2 = null;
        for (BgDimensionInfo bgDimensionInfo2 : dimensions) {
            MbgXMLParser.buildDocument(dimensionEle, bgDimensionInfo2);
        }
        Element extendPropertyEle = parentEle.addElement(DOCUMENT_EXT_PROPERTY);
        if (bgDimensionManager.getAttributeCol() != null && !bgDimensionManager.getAttributeCol().isEmpty()) {
            Element propertiesEle = extendPropertyEle.addElement(DOCUMENT_PROPERTIES);
            BgAttributeColumn attributeColumn2 = null;
            for (BgAttributeColumn attributeColumn2 : bgDimensionManager.getAttributeCol()) {
                MbgXMLParser.buildDocument(propertiesEle, attributeColumn2);
            }
        }
        if (bgDimensionManager.getCalcuteCol() != null && !bgDimensionManager.getCalcuteCol().isEmpty()) {
            Element calculateEle = extendPropertyEle.addElement(DOCUMENT_CALCULATE);
            BgCalcuteColumn calcuteColumn2 = null;
            for (BgCalcuteColumn calcuteColumn2 : bgDimensionManager.getCalcuteCol()) {
                MbgXMLParser.buildDocument(calculateEle, calcuteColumn2);
            }
        }
        if (bgDimensionManager.getDescriptionCol() != null && !bgDimensionManager.getDescriptionCol().isEmpty()) {
            Element descriptionEle = extendPropertyEle.addElement(DOCUMENT_DESCRIPTION);
            BgDescriptionColumn descriptionColumn2 = null;
            for (BgDescriptionColumn descriptionColumn2 : bgDimensionManager.getDescriptionCol()) {
                MbgXMLParser.buildDocument(descriptionEle, descriptionColumn2);
            }
        }
        Element styleEle = parentEle.addElement("style");
        MbgXMLParser.buildDocument(styleEle, bgDimensionManager.getFormStyleInfo());
    }

    private static void buildDocument(Element parentEle, BgDimensionInfo bgDimensionInfo) throws DimensionException {
        if (parentEle == null || bgDimensionInfo == null) {
            return;
        }
        Element member = parentEle.addElement(DOCUMENT_MEMBER);
        member.addElement(DOCUMENT_NUMBER).setText(bgDimensionInfo.getNumber());
        member.addElement(DOCUMENT_ALIAS).setText(bgDimensionInfo.getAlias() == null ? "" : bgDimensionInfo.getAlias());
        member.addElement(DOCUMENT_MEMBER_VALUE_TYPE).setText(Integer.toString(bgDimensionInfo.getMemberValueType().getValue()));
        String value = bgDimensionInfo.unParseMember();
        member.addElement(ATTR_VALUE).setText(value == null ? "" : value);
        String mappingValue = bgDimensionInfo.unParseMappingList();
        member.addElement(DOCUMENT_MEMBER_MAPPING).setText(mappingValue == null ? "" : mappingValue);
        member.addElement("attribute").setText(bgDimensionInfo.getAttribute() == null ? "" : bgDimensionInfo.getAttribute());
        member.addElement("layout").setText(bgDimensionInfo.getLayout() == null ? "" : bgDimensionInfo.getLayout());
        member.addElement("showType").setText(bgDimensionInfo.getShowType() == null ? "NAME" : bgDimensionInfo.getShowType());
        member.addElement(DOCUMNET_DINAMIC_ADD_MEMBER).setText(Boolean.toString(bgDimensionInfo.isDinamicAdd()));
        member.addElement(DOCUMNET_DINAMIC_SELECT_RELATIONSHIP).setText(Boolean.toString(bgDimensionInfo.isSelectRelationship()));
        value = bgDimensionInfo.upParseCanAddMember();
        member.addElement(DOCUMNET_DINAMIC_ADD_MEMBER_Range).setText(value == null ? "" : value);
        member.addElement("index").setText(Integer.toString(bgDimensionInfo.getIndex()));
        member.addElement(DOCUMENT_SUB_TOTAL).setText(Boolean.toString(bgDimensionInfo.isSubTotal()));
        member.addElement(DOCUMENT_DIM_TOTAL).setText(Boolean.toString(bgDimensionInfo.isDimTotal()));
        member.addElement(DOCUMENT_HAS_SHOW).setText(Boolean.toString(bgDimensionInfo.isShow()));
        member.addElement(DOCUMENT_PERIOD_SHOW_STYLE).setText(Integer.toString(bgDimensionInfo.getPeriodDisplayStyle()));
        if (bgDimensionInfo.getBgPeriodType() != null) {
            Element bgPerildTypeEle = member.addElement(DOCUMENT_BGPERIODTYPE);
            bgPerildTypeEle.addElement(DOCUMENT_ID).setText(bgDimensionInfo.getBgPeriodType().getId().toString());
            bgPerildTypeEle.addElement(DOCUMENT_NUMBER).setText(bgDimensionInfo.getBgPeriodType().getNumber());
            bgPerildTypeEle.addElement("name").setText(bgDimensionInfo.getBgPeriodType().getName());
        }
    }

    private static void buildDocument(Element propertiesEle, BgAttributeColumn attributeColumn) {
        if (propertiesEle == null || attributeColumn == null) {
            return;
        }
        Element property = propertiesEle.addElement(DOCUMENT_PROPERTY);
        property.addElement(DOCUMENT_ALIAS).setText(attributeColumn.getAlias());
        property.addElement(DOCUMENT_MEMBER).setText(attributeColumn.getDimensionInfo().getNumber());
        property.addElement(DOCUMENT_COL_NAME).setText(StringUtils.cnulls((String)attributeColumn.getColumnName()));
        property.addElement(DOCUMENT_REFCOLUMN).setText(StringUtils.cnulls((String)attributeColumn.getRefColumn()));
        property.addElement("index").setText(Integer.toString(attributeColumn.getIndex()));
    }

    private static void buildDocument(Element calculateEle, BgCalcuteColumn calcuteColumn) {
        if (calculateEle == null || calcuteColumn == null) {
            return;
        }
        Element property = calculateEle.addElement(DOCUMENT_PROPERTY);
        property.addElement(DOCUMENT_ALIAS).setText(calcuteColumn.getAlias());
        property.addElement(DOCUMENT_FORMULA).setText(StringUtils.cnulls((String)calcuteColumn.getFormula()));
        property.addElement("index").setText(Integer.toString(calcuteColumn.getIndex()));
    }

    private static void buildDocument(Element descriptionEle, BgDescriptionColumn descriptionColumn) {
        if (descriptionEle == null || descriptionColumn == null) {
            return;
        }
        Element property = descriptionEle.addElement(DOCUMENT_PROPERTY);
        property.addElement(DOCUMENT_ALIAS).setText(descriptionColumn.getAlias());
        for (int i = 0; i < descriptionColumn.getDimensions().size(); ++i) {
            property.addElement(DOCUMENT_MEMBER).setText(descriptionColumn.getDimensions().get(i).getNumber());
        }
        property.addElement("index").setText(Integer.toString(descriptionColumn.getIndex()));
    }

    private static void buildDocument(Element styleEle, FormStyleInfo formStyleInfo) {
        if (styleEle == null || formStyleInfo == null) {
            return;
        }
        Element headStyleEle = styleEle.addElement(DOCUMENT_HEAD_STYLE);
        headStyleEle.addAttribute(ATTR_VALUE, formStyleInfo.getFormName() == null ? "" : formStyleInfo.getFormName());
        headStyleEle.addAttribute(ATTR_FONT, formStyleInfo.getFormStyleAttributes().getFontName());
        headStyleEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(formStyleInfo.getFormStyleAttributes().getFontSize()));
        headStyleEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(formStyleInfo.getFormStyleAttributes().getFontSize()));
        headStyleEle.addAttribute(ATTR_SIZE, Integer.toString(formStyleInfo.getFormStyleAttributes().getFontSize()));
        headStyleEle.addAttribute("style", formStyleInfo.unParseStyleAttributes(formStyleInfo.getFormStyleAttributes()));
        Element unitEle = styleEle.addElement(DOCUMENT_UNIT);
        unitEle.addAttribute(ATTR_VALUE, formStyleInfo.getUnitName() == null ? "" : formStyleInfo.getUnitName());
        unitEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(formStyleInfo.getUnitHorizontalAlign()));
        unitEle.addAttribute(ATTR_APPOINT_POSITION, Boolean.toString(formStyleInfo.isUnitAppointPosition()));
        unitEle.addAttribute(ATTR_POSITION, formStyleInfo.getUnitPosition());
        Element formNumber = styleEle.addElement(DOCUMENT_FORMNUMBER);
        formNumber.addAttribute(ATTR_VALUE, formStyleInfo.getFormNumberName() == null ? "" : formStyleInfo.getFormNumberName());
        formNumber.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(formStyleInfo.getFormNumberHorizontalAlign()));
        formNumber.addAttribute(ATTR_APPOINT_POSITION, Boolean.toString(formStyleInfo.isFormNumberAppointPosition()));
        formNumber.addAttribute(ATTR_POSITION, formStyleInfo.getFormNumberPosition());
        Element dateEle = styleEle.addElement(DOCUMENT_DATE);
        dateEle.addAttribute(ATTR_VALUE, formStyleInfo.getDateName() == null ? "" : formStyleInfo.getDateName());
        dateEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(formStyleInfo.getDateHorizontalAlign()));
        dateEle.addAttribute(ATTR_APPOINT_POSITION, Boolean.toString(formStyleInfo.isDateAppointPosition()));
        dateEle.addAttribute(ATTR_POSITION, formStyleInfo.getDatePosition());
        Element measureUnitEle = styleEle.addElement(DOCUMENT_MEASURE_UNIT);
        measureUnitEle.addAttribute(ATTR_DISPLAY, Boolean.toString(formStyleInfo.isMeasureUnitIsShow()));
        measureUnitEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(formStyleInfo.getMeasureUnitHorizontalAlign()));
        measureUnitEle.addAttribute(ATTR_APPOINT_POSITION, Boolean.toString(formStyleInfo.isMeasureUnitAppointPosition()));
        measureUnitEle.addAttribute(ATTR_POSITION, formStyleInfo.getMeasureUnitPosition());
        Element columnEle = styleEle.addElement(DOCUMENT_COLUMN);
        columnEle.addAttribute(ATTR_FONT, formStyleInfo.getColumnHeaderStyleAttributes().getFontName());
        columnEle.addAttribute(ATTR_SIZE, Integer.toString(formStyleInfo.getColumnHeaderStyleAttributes().getFontSize()));
        columnEle.addAttribute("style", formStyleInfo.unParseStyleAttributes(formStyleInfo.getColumnHeaderStyleAttributes()));
        Element cellEle = styleEle.addElement(DOCUMENT_CELL);
        cellEle.addAttribute(ATTR_FONT, formStyleInfo.getDataStyleAttributes().getFontName());
        cellEle.addAttribute(ATTR_SIZE, Integer.toString(formStyleInfo.getDataStyleAttributes().getFontSize()));
        cellEle.addAttribute("style", formStyleInfo.unParseStyleAttributes(formStyleInfo.getDataStyleAttributes()));
        cellEle.addAttribute(ATTR_PRECISION, Integer.toString(formStyleInfo.getDataDecNums()));
        cellEle.addAttribute(ATTR_SEPARATOR, Boolean.toString(formStyleInfo.isDataHasGroupSep()));
        cellEle.addAttribute(ATTR_DISPLAY_FORMAT, Integer.toString(formStyleInfo.getDataNegativeIndex()));
    }

    private static void buildDocument(Element styleEle, TemplateStyleInfo templateStyleInfo) {
        if (styleEle == null || templateStyleInfo == null) {
            return;
        }
        Element headStyleEle = styleEle.addElement(DOCUMENT_HEAD_STYLE);
        headStyleEle.addAttribute(ATTR_VALUE, templateStyleInfo.getBgFormTitle().getName() == null ? "" : templateStyleInfo.getBgFormTitle().getName());
        headStyleEle.addAttribute(ATTR_FONT, templateStyleInfo.getFormStyleAttributes().getFontName());
        headStyleEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFont().getSize()));
        headStyleEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFont().getStyle()));
        headStyleEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFontSize()));
        headStyleEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getFormStyleAttributes()));
        headStyleEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getBgFormTitleHorizontalAlign()));
        Element unitEle = styleEle.addElement(DOCUMENT_UNIT);
        unitEle.addAttribute(ATTR_VALUE, templateStyleInfo.getUnitName() == null ? "" : templateStyleInfo.getUnitName());
        unitEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getUnitHorizontalAlign()));
        unitEle.addAttribute(ATTR_POSITION, Integer.toString(templateStyleInfo.getUnitPosition()));
        Element dateEle = styleEle.addElement(DOCUMENT_DATE);
        dateEle.addAttribute(ATTR_VALUE, templateStyleInfo.getDateName() == null ? "" : templateStyleInfo.getDateName());
        dateEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getDateHorizontalAlign()));
        dateEle.addAttribute(ATTR_APPOINT_POSITION, Integer.toString(templateStyleInfo.getDatePosition()));
        Element currencyEle = styleEle.addElement(DOCUMENT_CURRENCYUNIT);
        currencyEle.addAttribute(ATTR_VALUE, templateStyleInfo.getCurrencyUnitName() == null ? "" : templateStyleInfo.getCurrencyUnitName());
        currencyEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getCurrencyUnitHorizontalAlign()));
        currencyEle.addAttribute(ATTR_APPOINT_POSITION, Integer.toString(templateStyleInfo.getCurrencyUnitPosition()));
        Element columnEle = styleEle.addElement(DOCUMENT_COLUMN);
        columnEle.addAttribute(ATTR_FONT, templateStyleInfo.getColumnHeaderStyleAttributes().getFontName());
        columnEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFontSize()));
        columnEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getColumnHeaderStyleAttributes()));
        columnEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFont().getSize()));
        columnEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFont().getStyle()));
        Element cellEle = styleEle.addElement(DOCUMENT_CELL);
        cellEle.addAttribute(ATTR_FONT, templateStyleInfo.getDataStyleAttributes().getFontName());
        cellEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFontSize()));
        cellEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getDataStyleAttributes()));
        cellEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFont().getSize()));
        cellEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFont().getStyle()));
        Element columnCurrency = styleEle.addElement(DOCUMENT_CURRENCY);
        columnCurrency.addAttribute(ATTR_CURRENCYDECNUMS, Integer.toString(templateStyleInfo.getCurrencyDecNums()));
        columnCurrency.addAttribute(ATTR_CURRENCYHASGROUPSEP, Boolean.toString(templateStyleInfo.isCurrencyHasGroupSep()));
        columnCurrency.addAttribute(ATTR_CURRENCYNEGATIVEINDEX, Integer.toString(templateStyleInfo.getCurrencyNegativeIndex()));
        columnCurrency.addAttribute(ATTR_CURRENCYMEASUREUNIT, Integer.toString(templateStyleInfo.getCurrencyMeasureUnit()));
        Element columnNoCurrency = styleEle.addElement(DOCUMENT_NOCURRENCYUNIT);
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYDECNUMS, Integer.toString(templateStyleInfo.getNoCurrencyDecNums()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYGROUPSEP, Boolean.toString(templateStyleInfo.isNoCurrencyGroupSep()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYNEGATIVEINDEX, Integer.toString(templateStyleInfo.getNoCurrencyNegativeIndex()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYMEASUREUNIT, Integer.toString(templateStyleInfo.getNoCurrencyMeasureUnit()));
        Element columnRate = styleEle.addElement(DOCUMENT_RATE);
        columnRate.addAttribute(ATTR_RATEDECNUMS, Integer.toString(templateStyleInfo.getRateDecNums()));
        columnRate.addAttribute(ATTR_RATEHASGROUPSEP, Boolean.toString(templateStyleInfo.isRateHasGroupSep()));
        columnRate.addAttribute(ATTR_RATENEGATIVEINDEX, Integer.toString(templateStyleInfo.getRateNegativeIndex()));
        columnRate.addAttribute(ATTR_RATEMEASUREUNIT, Integer.toString(templateStyleInfo.getRateMeasureUnit()));
    }

    public static byte[] unParseStyle(TemplateStyleInfo templateStyleInfo) {
        if (templateStyleInfo == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document doc = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element ele = doc.addElement("view");
        MbgXMLParser.buildDocument(ele, templateStyleInfo);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)bos, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return bos.toByteArray();
    }

    public static TemplateStyleInfo parseStyle(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        TemplateStyleInfo templateStyleInfo = new TemplateStyleInfo();
        if (document != null && document.getRootElement() != null) {
            Element view = document.getRootElement();
            Iterator iterator = view.elementIterator();
            while (iterator.hasNext()) {
                Element member = (Element)iterator.next();
                if (DOCUMENT_HEAD_STYLE.equals(member.getName())) {
                    templateStyleInfo.setBgFormTitle((BgFormTitleEnum)((Object)BgFormTitleEnum.getEnumMap().get(member.attributeValue(ATTR_VALUE))));
                    templateStyleInfo.getFormStyleAttributes().setFont(new Font(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.setBgFormTitleHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getFormStyleAttributes());
                    continue;
                }
                if (DOCUMENT_UNIT.equals(member.getName())) {
                    templateStyleInfo.setUnitName(member.attributeValue(ATTR_VALUE));
                    templateStyleInfo.setUnitHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setUnitPosition(Integer.parseInt(member.attributeValue(ATTR_POSITION)));
                    continue;
                }
                if (DOCUMENT_DATE.equals(member.getName())) {
                    templateStyleInfo.setDateName(member.attributeValue(ATTR_VALUE));
                    templateStyleInfo.setDateHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setDatePosition(Integer.parseInt(member.attributeValue(ATTR_APPOINT_POSITION)));
                    continue;
                }
                if (DOCUMENT_CURRENCYUNIT.equals(member.getName())) {
                    templateStyleInfo.setCurrencyUnitName(member.attributeValue(ATTR_VALUE));
                    templateStyleInfo.setCurrencyUnitHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setCurrencyUnitPosition(Integer.parseInt(member.attributeValue(ATTR_APPOINT_POSITION)));
                    continue;
                }
                if (DOCUMENT_COLUMN.equals(member.getName())) {
                    templateStyleInfo.getColumnHeaderStyleAttributes().setFont(new Font(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getColumnHeaderStyleAttributes());
                    if (member.attributeValue(ATTR_HORIZONTAL_ALIGN) == null) continue;
                    templateStyleInfo.setColHeaderHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    continue;
                }
                if (DOCUMENT_CELL.equals(member.getName())) {
                    templateStyleInfo.getDataStyleAttributes().setFont(new Font(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getDataStyleAttributes());
                    continue;
                }
                if (DOCUMENT_CURRENCY.equals(member.getName())) {
                    templateStyleInfo.setCurrencyDecNums(Integer.parseInt(member.attributeValue(ATTR_CURRENCYDECNUMS)));
                    templateStyleInfo.setCurrencyHasGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_CURRENCYHASGROUPSEP)));
                    templateStyleInfo.setCurrencyNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_CURRENCYNEGATIVEINDEX)));
                    templateStyleInfo.setCurrencyMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_CURRENCYMEASUREUNIT)));
                    continue;
                }
                if (DOCUMENT_NOCURRENCYUNIT.equals(member.getName())) {
                    templateStyleInfo.setNoCurrencyDecNums(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYDECNUMS)));
                    templateStyleInfo.setNoCurrencyGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_NOCURRENCYGROUPSEP)));
                    templateStyleInfo.setNoCurrencyNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYNEGATIVEINDEX)));
                    templateStyleInfo.setNoCurrencyMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYMEASUREUNIT)));
                    continue;
                }
                if (!DOCUMENT_RATE.equals(member.getName())) continue;
                templateStyleInfo.setRateDecNums(Integer.parseInt(member.attributeValue(ATTR_RATEDECNUMS)));
                templateStyleInfo.setRateHasGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_RATEHASGROUPSEP)));
                templateStyleInfo.setRateNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_RATENEGATIVEINDEX)));
                templateStyleInfo.setRateMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_RATEMEASUREUNIT)));
            }
        }
        return templateStyleInfo;
    }

    private static void buildSpliteDocument(Element sheet, IMbgSheetManager curMbgSheetManager) {
        if (sheet == null || curMbgSheetManager == null || curMbgSheetManager.getSplitInfo() == null) {
            return;
        }
        String strSplit = curMbgSheetManager.getSplitInfo();
        String[] arr = strSplit.split(BgBaseConstants.SEP_THR_STR);
        if (arr.length != 10) {
            return;
        }
        Element splite = sheet.addElement(DOCUMENT_SPLIT_INFO);
        splite.addElement(ATTR_SPLIT_FIRSTROW).setText(String.valueOf(arr[0]));
        splite.addElement(ATTR_SPLIT_FIRSTCOL).setText(String.valueOf(arr[1]));
        splite.addElement(ATTR_SPLIT_FIRSTROW2).setText(String.valueOf(arr[2]));
        splite.addElement(ATTR_SPLIT_FIRSTCOL2).setText(String.valueOf(arr[3]));
        splite.addElement(ATTR_SPLIT_COLSPLIT).setText(String.valueOf(arr[4]));
        splite.addElement(ATTR_SPLIT_ROWSPLIT).setText(String.valueOf(arr[5]));
        splite.addElement(ATTR_SPLIT_ACTIVEPANE).setText(String.valueOf(arr[6]));
        splite.addElement(ATTR_SPLIT_ISFREEZED).setText(String.valueOf(arr[7]));
        splite.addElement(ATTR_SPLIT_COLFIXLINE).setText(String.valueOf(arr[8]));
        splite.addElement(ATTR_SPLIT_ROWFIXLINE).setText(String.valueOf(arr[9]));
    }

    private void parseSpliteInfo(IMbgSheetManager mbgSheetManager, Element sheetEle) {
        if (sheetEle == null || mbgSheetManager == null) {
            return;
        }
        Element member = sheetEle.element(DOCUMENT_SPLIT_INFO);
        if (member == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTROW)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTCOL)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTROW2)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTCOL2)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_COLSPLIT)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ROWSPLIT)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ACTIVEPANE)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ISFREEZED)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_COLFIXLINE)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ROWFIXLINE));
        mbgSheetManager.setSplitInfo(sb.toString());
    }
}

