/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.excel.io.clipboard.KDSTransferable;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.IMeasureProcesser;
import com.kingdee.eas.ma.mbg.common.IViewListNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.util.StringUtils;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public abstract class MeasureUnitCellActionAfterListener
implements CellActionAfterListener {
    private static final Logger logger = Logger.getLogger((String)MeasureUnitCellActionAfterListener.class.getName());
    private static final String PASTE = "Paste";
    private static final String COPY = "Copy";
    private IBgNumberCellDisplayHelper ui = null;
    private boolean isExport = false;

    protected IBgNumberCellDisplayHelper getHelper() {
        return this.ui;
    }

    public MeasureUnitCellActionAfterListener(IBgNumberCellDisplayHelper ui) {
        this.ui = ui;
    }

    public static void setExport(Book book, boolean isExport) {
        if (book != null && book.getCellActionAfterListener() instanceof MeasureUnitCellActionAfterListener) {
            ((MeasureUnitCellActionAfterListener)book.getCellActionAfterListener()).isExport = isExport;
        }
    }

    public void doAfter(Cell paramCell1, Cell paramCell2, String paramString) {
        BigDecimal coefficient = BgNConstants.ONE;
        boolean isProcess = this.isProcess();
        boolean isLog = false;
        if (isProcess) {
            String valueStr = null;
            IMeasureProcesser processor = this.getProcessor();
            coefficient = processor.getCoefficient(valueStr = paramCell1.getValue().getValue() != null ? paramCell1.getValue().getValue().toString() : paramCell1.getText(), paramCell2);
            if (coefficient == null) {
                if (isLog) {
                    logger.info((Object)"MeasureUnitCellActionAfterListener coefficient IS NULL");
                }
                coefficient = BgNConstants.ONE;
            } else if (isLog) {
                logger.info((Object)("MeasureUnitCellActionAfterListener coefficient:" + coefficient));
            }
            if (paramString.equals(PASTE)) {
                if (paramCell2.getValue().getValue() instanceof BigDecimal && paramCell1.getValue() != null && paramCell1.getValue().getValue() == paramCell2.getValue().getValue()) {
                    paramCell2.setValue(new Variant((Object)((BigDecimal)paramCell1.getValue().getValue()).multiply(coefficient), 10));
                }
                if (this.getHelper() instanceof IViewListNumberCellDisplayHelper && !paramCell2.hasFormula()) {
                    if (paramCell2.getComment() != null) {
                        paramCell2.setComment(null);
                    }
                    if ((MbgViewListDescriptionHelper.checkHashDescriptionFormula(paramCell2) || ViewListHelper.getDimension(paramCell2.getRowObject()) instanceof MbgViewListDescription || ViewListHelper.getDimension(paramCell2.getSheet().getColumn(paramCell2.getCol(), false)) instanceof MbgViewListDescription) && paramCell1.getValue().getValue() instanceof GregorianCalendar && paramCell1.getValue() != null && paramCell1.getValue().getValue() == paramCell2.getValue().getValue()) {
                        String _kdscellFormat = paramCell1.getSSA().getNumberFormat();
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)paramCell1.getValue().getValue();
                        Date date = gregorianCalendar.getTime();
                        SimpleDateFormat formater = null;
                        String lFormat = _kdscellFormat.toLowerCase();
                        if (lFormat.indexOf("y") >= 0 && lFormat.indexOf("m") >= 0 && lFormat.indexOf("d") >= 0) {
                            formater = new SimpleDateFormat("yyyy-MM-dd");
                        } else if (lFormat.indexOf("y") >= 0 && lFormat.indexOf("m") >= 0) {
                            formater = new SimpleDateFormat("yyyy-MM");
                        } else if (lFormat.indexOf("y") >= 0) {
                            formater = new SimpleDateFormat("yyyy");
                        }
                        if (formater != null) {
                            String simpleDateStr = formater.format(date);
                            Variant var = Cell.parseValue((String)simpleDateStr, (String)_kdscellFormat, (boolean)false);
                            BgNFSHelper.setValue(paramCell2, var);
                        } else {
                            BgNFSHelper.setValue(paramCell2, paramCell1.getValue());
                        }
                    }
                }
            } else if (paramString.equals(COPY)) {
                Expression tf;
                if (paramCell1.getValue().getValue() instanceof BigDecimal) {
                    paramCell2.setValue(new Variant((Object)((BigDecimal)paramCell1.getValue().getValue()).divide(coefficient), 10));
                    paramCell2.getText();
                    if (!this.isExport) {
                        Clipboard clipboard = null;
                        try {
                            Class<?> clazz = Class.forName("com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler");
                            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            ClipboardTransferHandler instance = (ClipboardTransferHandler)constructor.newInstance(new Object[0]);
                            Method method = clazz.getDeclaredMethod("getClipboard", new Class[0]);
                            method.setAccessible(true);
                            clipboard = (Clipboard)method.invoke((Object)instance, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.info((Object)"", (Throwable)e);
                        }
                        tf = new KDSTransferable(paramCell2.getSheet());
                        try {
                            if (clipboard != null) {
                                clipboard.setContents((Transferable)tf, null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (isLog) {
                            logger.info((Object)("MeasureUnitCellActionAfterListener BigDecimal:" + paramCell2.getValue()));
                            logger.info((Object)("MeasureUnitCellActionAfterListener BigDecimal:" + paramCell2.getText()));
                        }
                    }
                }
                if (paramCell2.hasFormula()) {
                    try {
                        String formula = paramCell2.getFormula();
                        if (!StringUtils.isEmpty((String)formula)) {
                            formula = formula.replaceAll("R\\d*C\\d*\\[-{0,1}\\d*\\]", "A1");
                            formula = formula.replaceAll("R\\d*C\\d*", "A1");
                            formula = formula.replaceAll("R\\[-{0,1}\\d*\\]C\\[-{0,1}\\d*\\]", "A1");
                            formula = formula.replaceAll("R\\[-{0,1}\\d*\\]C", "A1");
                            formula = formula.replaceAll("R\\[\\d*\\]C\\[\\d*\\]", "A1");
                            formula = formula.replaceAll("#REF!", "A1");
                        }
                        tf = ExcelFormulaPaserHelper.parse((String)formula);
                    }
                    catch (ParseException e) {
                        Variant value = paramCell2.getValue();
                        paramCell2.setFormula(null);
                        paramCell2.setValue(value);
                        if (isLog) {
                            logger.info((Object)("MeasureUnitCellActionAfterListener ParseException:" + paramCell2.getValue()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected abstract boolean isProcess();

    protected abstract IMeasureProcesser getProcessor();
}

