/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Node {
    private String number = null;
    private int level = 0;
    private Node parent = null;
    private Map<String, Node> childNode = new HashMap<String, Node>();
    private BgDimensionMember member = null;

    public Node(String number) {
        this.number = number;
    }

    public Node searchNode(String longNumber) {
        String[] lns = longNumber.split("!");
        Node node = this;
        for (int i = 0; i < lns.length; ++i) {
            node = node.childNode.get(lns[i]);
            if (i == lns.length - 1) {
                return node;
            }
            if (node != null) continue;
            return null;
        }
        return null;
    }

    public void addChild(BgDimensionMember m) {
        if (this.number != null) {
            return;
        }
        String[] lns = ((String)((Object)m.getSortValue())).split("!");
        Node thisNode = this;
        for (int i = 0; i < lns.length; ++i) {
            Node childNode = thisNode.createChildNode(lns[i]);
            if (i == lns.length - 1) {
                childNode.member = m;
            }
            thisNode = childNode;
        }
    }

    private Node createChildNode(String number) {
        if (!this.childNode.containsKey(number)) {
            Node node = new Node(number);
            node.level = this.level + 1;
            node.parent = this;
            this.childNode.put(number, node);
            return node;
        }
        return this.childNode.get(number);
    }

    public String getNumber() {
        return this.number;
    }

    public int getLevel() {
        return this.level;
    }

    public Node getParent() {
        return this.parent;
    }

    public Map<String, Node> getChildNode() {
        return this.childNode;
    }

    public BgDimensionMember getMember() {
        return this.member;
    }

    public static Node buildNode(Collection<BgDimensionMember> members) {
        Node rootNode = new Node(null);
        for (BgDimensionMember member : members) {
            rootNode.addChild(member);
        }
        return rootNode;
    }
}

