/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.utils.BgPropertyHelper;
import com.kingdee.eas.ma.mbg.BgFormTitleEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListOther;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterMember;
import com.kingdee.eas.ma.mbg.common.ExpandMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.StyleAttributes;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListMemberRender;
import com.kingdee.eas.ma.mbg.common.ViewListTitleRenderBase;
import com.kingdee.eas.ma.mbg.common.calcRow.ColExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.FormulaExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.LeftBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.OperatorExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RightBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.RowExpr;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListSheetParseHelper {
    private static Logger logger = Logger.getLogger((String)ViewListSheetParseHelper.class.getName());
    public static final String INIT_EXPRESSION = "initExpression";
    private Set<Integer> itemFields = null;
    private Context ctx = null;
    private Map<String, String> multiOrgCreatorMap = new HashMap<String, String>();
    private Map<String, MbgViewListSheetManager> bgDimensionManagerForMulOrg = new HashMap<String, MbgViewListSheetManager>();
    protected MbgViewListSheetManager sheetManager = null;
    protected String curOrgNum = null;
    private List<BgDimensionMember> viewMembers = null;
    private List<BgDimensionMember> pageMembers = null;
    protected DimensionMemberFilterInfo memberFilter = null;
    private boolean isCheckFull = true;
    private boolean isShowOrgEmptyRowCol = true;
    protected boolean isShowDefaultMember = false;
    private BgSchemeDimensionHelper schemeHelper = null;
    private String versionNumber = null;
    private Map<String, BgElementInfo> elementMap = new HashMap<String, BgElementInfo>();
    protected TemplateStyleInfo templateStyle = null;
    private String sheetTitle = null;
    private Map<String, Map<String, String>> propMaps = null;
    private String editOrgUnit = null;
    private String editPeriod = null;
    private boolean isParseForm = false;
    private Map<String, Integer> accountMap = null;
    private String orgUnitId = null;
    private boolean isShowAlias = false;
    private boolean isCsl = false;
    private boolean isExport = false;
    private CoreUIObject ownerUI = null;
    private Map<String, MBGRowData> mbgRowDatas = new HashMap<String, MBGRowData>();

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public Map<String, String> getMultiOrgCreatorMap() {
        return this.multiOrgCreatorMap;
    }

    public Map<String, MbgViewListSheetManager> getBgDimensionManagerForMulOrg() {
        return this.bgDimensionManagerForMulOrg;
    }

    public Map<String, BgElementInfo> getElementObjMap() {
        return this.elementMap;
    }

    public TemplateStyleInfo getTemplateStyle() {
        return this.templateStyle;
    }

    public void setTemplateStyle(TemplateStyleInfo templateStyle) {
        this.templateStyle = templateStyle;
    }

    public boolean isShowAlias() {
        return this.isShowAlias;
    }

    public void setShowAlias(boolean isShowAlias) {
        this.isShowAlias = isShowAlias;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public void setExport(boolean isExport) {
        this.isExport = isExport;
    }

    public void setSchemeHelper(BgSchemeDimensionHelper schemeHelper) {
        this.schemeHelper = schemeHelper;
    }

    public CoreUIObject getOwnerUI() {
        return this.ownerUI;
    }

    public void setOwnerUI(CoreUIObject ownerUI) {
        this.ownerUI = ownerUI;
    }

    public ViewListSheetParseHelper(String orgUnitNum, String versionNumber, MbgViewListSheetManager sheetManager, Map<String, MbgViewListSheetManager> bgDimensionManagerForMulOrg, DimensionMemberFilterInfo memberFilter, boolean isCheckFull, String sheetTitle) {
        if (bgDimensionManagerForMulOrg != null) {
            this.bgDimensionManagerForMulOrg.putAll(bgDimensionManagerForMulOrg);
        }
        this.sheetManager = sheetManager;
        this.versionNumber = versionNumber;
        this.curOrgNum = orgUnitNum;
        this.memberFilter = memberFilter;
        this.isCheckFull = isCheckFull;
        this.sheetTitle = sheetTitle;
        this.itemFields = DimensionCommonHelper.getItemFields(sheetManager);
    }

    private List<IMbgViewListObject> getCols() {
        ArrayList<IMbgViewListObject> cols = new ArrayList<IMbgViewListObject>();
        if (this.sheetManager != null) {
            cols.addAll(this.sheetManager.getDimensionManager().getColumns());
            if (!this.isCsl) {
                this.getCurrentOrgOnRowCol(false, cols);
            }
        }
        return cols;
    }

    private List<IMbgViewListObject> getRows() {
        ArrayList<IMbgViewListObject> rows = new ArrayList<IMbgViewListObject>();
        if (this.sheetManager != null) {
            rows.addAll(this.sheetManager.getDimensionManager().getRows());
            if (!this.isCsl) {
                this.getCurrentOrgOnRowCol(true, rows);
            }
        }
        return rows;
    }

    public void setPropMaps(Map<String, Map<String, String>> propMaps) {
        this.propMaps = propMaps;
    }

    public void setEditOrgUnit(String editOrgUnit) {
        this.editOrgUnit = editOrgUnit;
    }

    public void setEditPeriod(String editPeriod) {
        this.editPeriod = editPeriod;
    }

    public void setViewMembers(List<BgDimensionMember> viewMembers) {
        this.viewMembers = viewMembers;
    }

    public void setPageMembers(List<BgDimensionMember> pageMembers) {
        this.pageMembers = pageMembers;
    }

    public void setParseForm(boolean isParseForm) {
        this.isParseForm = isParseForm;
    }

    public void setAccountMap(Map<String, Integer> accountMap) {
        this.accountMap = accountMap;
    }

    public void setShowDefaultMember(boolean isShowDefaultMember) {
        this.isShowDefaultMember = isShowDefaultMember;
    }

    public void setShowOrgEmptyRowCol(boolean isShowOrgEmptyRowCol) {
        this.isShowOrgEmptyRowCol = isShowOrgEmptyRowCol;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    protected void checkIsCsl(BgSchemeDimensionHelper schemeHelper) {
        if (schemeHelper != null && schemeHelper.getClass().getName().startsWith("com.kingdee.eas.ma.bgcsl")) {
            this.isCsl = this.getOwnerUI() == null || this.getOwnerUI().getClass().getName().indexOf("BgCslViewListFormProcessUI") <= 0;
        }
    }

    public void parseRowAndColDimension(Sheet sheet, TemplateStyleInfo templateStyle, BgSchemeDimensionHelper schemeHelper) throws Exception {
        this.templateStyle = templateStyle;
        this.checkIsCsl(schemeHelper);
        this.loadEffectiveItemCombin(schemeHelper);
        this.dealBgOrgPerm();
        int rowIndex = this.calculateHeaderRowCount();
        MBgTemplateHelper.logTime("Start parseRowAndColDimension");
        int colIndex = this.parseColDimension(sheet, rowIndex);
        MBgTemplateHelper.logTime("End parseColDimension");
        int endRowIndex = this.parseRowDimension(rowIndex + this.sheetManager.getDimensionManager().getColDimension().size(), sheet);
        MBgTemplateHelper.logTime("End parseRowDimension");
        ViewListHelper.checkMaxCells(sheet);
        this.parseCell(sheet, rowIndex + 1, this.calculateRowHeadColCount(), endRowIndex, colIndex);
        MBgTemplateHelper.logTime("End parseCell");
        this.parseHeader(sheet, colIndex);
        this.parseEditNote(sheet);
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes borderStyle = Styles.getEmptySA();
        borderStyle.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        Color borderColor = new Color(150, 150, 150);
        borderStyle.setBorderColor(Styles.Position.LEFT, borderColor);
        borderStyle.setBorderColor(Styles.Position.RIGHT, borderColor);
        borderStyle.setBorderColor(Styles.Position.TOP, borderColor);
        borderStyle.setBorderColor(Styles.Position.BOTTOM, borderColor);
        MBgTemplateHelper.setRangeStyle(sheet.getRange(rowIndex + 1, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex()), borderStyle, borderStyle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealBgOrgPerm() {
        BgDimensionMember member;
        int n;
        List members;
        DimensionMemberFilterMember filter;
        int j;
        List<MbgViewListDimensionInfo> rowDimensions;
        int i;
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.sheetManager.getDimensionManager());
        Set<String> bgOrgUnitPer = new HashSet();
        if (isorgOnPageOrView) return;
        UserInfo userInfo = null;
        try {
            if (this.getCtx() != null) {
                userInfo = ContextUtil.getCurrentUserInfo((Context)this.getCtx());
                bgOrgUnitPer = MbgPermissionFactory.getLocalInstance(this.getCtx()).getBgOrgUnitPermission(null, userInfo.getId().toString(), this.schemeHelper.getBgSchemeId());
            } else {
                userInfo = SysContext.getSysContext().getCurrentUserInfo();
                bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, userInfo.getId().toString(), this.schemeHelper.getBgSchemeId());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (bgOrgUnitPer.isEmpty()) return;
        if (!this.getMultiOrgCreatorMap().isEmpty()) {
            for (String key : this.getMultiOrgCreatorMap().keySet()) {
                if (!this.getMultiOrgCreatorMap().get(key).equals(userInfo.getId().toString())) continue;
                bgOrgUnitPer.add(key);
            }
        }
        List<IMbgViewListObject> rows = this.sheetManager.getDimensionManager().getRows();
        List<IMbgViewListObject> columns = this.sheetManager.getDimensionManager().getColumns();
        boolean isExist = false;
        block4: for (i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol)) continue;
            rowDimensions = ((MbgViewListRowCol)rows.get(i)).getDimensions();
            for (j = 0; j < rowDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(rowDimensions.get(j).getNumber())) continue;
                if (this.memberFilter != null && this.memberFilter.getMemberFilter(this.sheetManager.getSheetName(), rowDimensions.get(j).getNumber()) != null) {
                    filter = this.memberFilter.getMemberFilter(this.sheetManager.getSheetName(), rowDimensions.get(j).getNumber());
                } else {
                    filter = new DimensionMemberFilterMember();
                    filter.setDimensionNumber(rowDimensions.get(j).getNumber());
                    filter.setSelectAll(true);
                    filter.setDesc(false);
                    this.memberFilter.addMemberFilter(this.sheetManager.getSheetName(), filter);
                }
                members = rowDimensions.get(j).getMember();
                if (members != null && !members.isEmpty()) {
                    for (n = 0; n < members.size(); ++n) {
                        member = (BgDimensionMember)members.get(n);
                        if (!bgOrgUnitPer.contains(member.getAttribute())) continue;
                        filter.setSelectAll(false);
                        filter.getMembers().add(member.getNumber());
                    }
                }
                isExist = true;
                continue block4;
            }
        }
        if (isExist) return;
        block7: for (i = 0; i < columns.size(); ++i) {
            if (!(columns.get(i) instanceof MbgViewListRowCol)) continue;
            rowDimensions = ((MbgViewListRowCol)columns.get(i)).getDimensions();
            for (j = 0; j < rowDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(rowDimensions.get(j).getNumber())) continue;
                if (this.memberFilter != null && this.memberFilter.getMemberFilter(this.sheetManager.getSheetName(), rowDimensions.get(j).getNumber()) != null) {
                    filter = this.memberFilter.getMemberFilter(this.sheetManager.getSheetName(), rowDimensions.get(j).getNumber());
                } else {
                    filter = new DimensionMemberFilterMember();
                    filter.setDimensionNumber(rowDimensions.get(j).getNumber());
                    filter.setSelectAll(true);
                    filter.setDesc(false);
                    this.memberFilter.addMemberFilter(this.sheetManager.getSheetName(), filter);
                }
                members = rowDimensions.get(j).getMember();
                if (members == null || members.isEmpty()) continue block7;
                for (n = 0; n < members.size(); ++n) {
                    member = (BgDimensionMember)members.get(n);
                    if (!bgOrgUnitPer.contains(member.getAttribute())) continue;
                    filter.setSelectAll(false);
                    filter.getMembers().add(member.getNumber());
                }
                continue block7;
            }
        }
    }

    protected void loadEffectiveItemCombin(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        long time = System.currentTimeMillis();
        this.mbgRowDatas.clear();
        ArrayList<BgDimensionMember> newPageMembers = new ArrayList<BgDimensionMember>();
        if (this.pageMembers != null) {
            newPageMembers.addAll(this.pageMembers);
        }
        if (this.viewMembers != null) {
            newPageMembers.addAll(this.viewMembers);
        }
        boolean isOrgInView = MBgTemplateHelper.isOrgOnPageOrView(this.sheetManager.getDimensionManager());
        String viewOrgNumber = null;
        for (int i = 0; i < newPageMembers.size(); ++i) {
            if (!DimensionConstants.ORGUNIT_NUMBER.equalsIgnoreCase(((BgDimensionMember)newPageMembers.get(i)).getType())) continue;
            viewOrgNumber = ((BgDimensionMember)newPageMembers.get(i)).getNumber();
            break;
        }
        if (isOrgInView) {
            if (viewOrgNumber == null) {
                viewOrgNumber = this.curOrgNum;
            }
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(this.curOrgNum, this.sheetManager, schemeHelper, this.mbgRowDatas, false, true, this.isShowDefaultMember);
        } else {
            Set<String> keySet = MBGViewListFormCommonHelper.getOrgNumsifOrgonRowCol(this.curOrgNum, this.sheetManager);
            String orgNum2 = null;
            for (String orgNum2 : keySet) {
                if (this.isCsl) {
                    DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNum2, this.sheetManager, schemeHelper, this.mbgRowDatas, false, true, this.isShowDefaultMember);
                    continue;
                }
                this.loadMultiOrgEffectiveItemCombin(orgNum2, this.sheetManager, schemeHelper, this.mbgRowDatas, false, true, this.isShowDefaultMember, this.curOrgNum);
            }
        }
        System.out.println("Use Time:" + (System.currentTimeMillis() - time));
    }

    protected void loadMultiOrgEffectiveItemCombin(String orgNumber, MbgViewListSheetManager sheetManager, BgSchemeDimensionHelper schemeHelper, Map<String, MBGRowData> mbgRowDatas, boolean isLoadPage, boolean isMergeDim, boolean isShowDefaultMember, String currentOrgNumber) {
        if (sheetManager == null) {
            return;
        }
        if (isLoadPage && sheetManager.getDimensionManager().getPageRelationMaps() != null && !sheetManager.getDimensionManager().getPageRelationMaps().isEmpty()) {
            MBGRowData mbgRowData = new MBGRowData(sheetManager.getDimensionManager().getPageDimension(), isShowDefaultMember, schemeHelper);
            mbgRowData.setHasRelation(true);
            mbgRowDatas.put(DimensionMemberRelationShipHelper.getKey(orgNumber, "page", -1), mbgRowData);
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, mbgRowData, sheetManager.getDimensionManager().getPageRelationMaps(), sheetManager.getDimensionManager().getPageDimension(), schemeHelper, isMergeDim, "page", isShowDefaultMember);
        }
        boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(sheetManager.getDimensionManager());
        boolean isRowColShowbyTemp = sheetManager.isRowColShowbyTemp();
        Map<String, List<IMbgViewListObject>> orgAndRowCols = null;
        orgAndRowCols = isRowColShowbyTemp ? MBGViewListFormCommonHelper.getViewListObjectsByTemp(sheetManager.getDimensionManager(), isOrgOnRow, currentOrgNumber) : MBGViewListFormCommonHelper.getViewListObjectsByOrg(sheetManager.getDimensionManager(), isOrgOnRow);
        if (orgAndRowCols != null && orgAndRowCols.containsKey(orgNumber) && !orgAndRowCols.get(orgNumber).isEmpty()) {
            if (isOrgOnRow) {
                DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, orgAndRowCols.get(orgNumber), "row", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
                DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getColumns(), "col", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
            } else {
                DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getRows(), "row", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
                DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, orgAndRowCols.get(orgNumber), "col", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
            }
        } else {
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getRows(), "row", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
            DimensionMemberRelationShipHelper.loadEffectiveItemCombin(orgNumber, sheetManager.getDimensionManager().getColumns(), "col", schemeHelper, mbgRowDatas, isMergeDim, isShowDefaultMember);
        }
    }

    private void parseFormCondFormat(Sheet sheet) {
        ConditionalFormat condFormat = null;
        SortedCellBlockArray newBlock = null;
        for (int i = 0; i < this.sheetManager.getDimensionManager().getFormConditionalFormats().size(); ++i) {
            condFormat = this.sheetManager.getDimensionManager().getFormConditionalFormats().get(i);
            newBlock = new SortedCellBlockArray();
            newBlock.addAll(condFormat.getBlocks());
            sheet.getConditionalFormats().addConditionalFormat(new ConditionalFormat(condFormat.getConditions(), condFormat.getSSAs(), newBlock));
        }
    }

    protected void parseEditNote(Sheet sheet) {
        if (!this.sheetManager.isNeedDescription()) {
            return;
        }
        int maxRowIndex = sheet.getMaxRowIndex();
        int maxColIndex = sheet.getMaxColIndex();
        BgNFSHelper.setValue(sheet.getCell(maxRowIndex + 2, 0, true), EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"editNote"));
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes style = ViewListStyleHelper.convertStyle(this.templateStyle.getColumnHeaderStyleAttributes());
        style.setNumberFormat("@");
        style.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(1));
        style.setVerticalAlign(Styles.VerticalAlignment.TOP);
        style.setWrapText(true);
        Range r = sheet.getRange(maxRowIndex + 3, 0, maxRowIndex + 12, maxColIndex);
        r.addAll((SortedCellBlockArray)sheet.getRange(maxRowIndex + 2, 0));
        sheet.getCell(maxRowIndex + 3, 0, true).setUserObject("editNote", (Object)Boolean.TRUE);
        r.setIgnoreProtected(true);
        r.merge();
        MBgTemplateHelper.setRangeStyle(r, style, null);
    }

    public void parseCell(Sheet sheet, int startRowIndex, int startColIndex, int endRowIndex, int endColIndex) {
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes newStyle;
        BgSheetRange range;
        BgSheetRange calCellRange;
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes calStyle;
        MBgTemplateHelper.initTotal();
        HashMap<ConditionalFormat, ConditionalFormat> condFormats = new HashMap<ConditionalFormat, ConditionalFormat>();
        HashMap<ConditionalFormat, BgSheetRange> condFormatRanges = new HashMap<ConditionalFormat, BgSheetRange>();
        ConditionalFormat condFormat2 = null;
        BgSheetRange condRange = null;
        IMbgViewListStyle condObject = null;
        for (int i = 0; i < sheet.getConditionalFormats().size(); ++i) {
            sheet.getConditionalFormats().getConditionalFormat(i).getBlocks().clear();
        }
        sheet.getConditionalFormats().reduce();
        this.parseFormCondFormat(sheet);
        HashMap styleRange = new HashMap();
        HashMap styleMap = new HashMap();
        HashMap<String, BgSheetRange> calStyleRange = new HashMap<String, BgSheetRange>();
        HashMap<String, com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes> calStyleMap = new HashMap<String, com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes>();
        String tempStyleKey = null;
        BgSheetRange desCellRange = null;
        BgSheetRange dataCellRange = new BgSheetRange(sheet);
        BgSheetRange lockRange = new BgSheetRange(sheet);
        MbgViewListCell varCell = new MbgViewListCell();
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        HashMap<String, MBGRowData> rowDatas = new HashMap<String, MBGRowData>();
        Map<String, MbgViewListCell> cellStyles = this.sheetManager.getDimensionManager().getCellStyles();
        MbgViewListCalcutor calculator = null;
        Object[] calcMembers = null;
        long itemFormula = 0L;
        long st = 0L;
        Set<String> eleSet = null;
        boolean eleIsPage = false;
        if (this.isParseForm) {
            List pageDimension = this.sheetManager.getDimensionManager().getPageDisplayDimension();
            for (int i = 0; i < pageDimension.size(); ++i) {
                if (!MBGLayoutConstants.BG_ELEMENT.equals(((BgDimensionBaseInfo)pageDimension.get(i)).getNumber())) continue;
                eleIsPage = true;
                break;
            }
            eleSet = this.createElementSet();
        }
        for (int r = startRowIndex; r <= endRowIndex; ++r) {
            Row row = sheet.getRow(r, false);
            if (row == null) continue;
            Object[] rowMembers = ViewListHelper.getDimensionMember(row);
            IMbgViewListObject rowObject = ViewListHelper.getDimension(row);
            if (rowObject == null) continue;
            for (int c = startColIndex; c <= endColIndex; ++c) {
                String styleKey;
                StyleAttributes style;
                Cell cell;
                Column col = sheet.getColumn(c, false);
                if (col == null) continue;
                Object[] colMembers = ViewListHelper.getDimensionMember(col);
                IMbgViewListObject colObject = ViewListHelper.getDimension(col);
                if (colObject == null) continue;
                varCell.setRow(rowObject);
                varCell.setCol(colObject);
                MbgViewListCell realCell = cellStyles.containsKey(varCell.getCellName()) ? cellStyles.get(varCell.getCellName()) : varCell;
                Integer accountType = -1;
                if (rowObject instanceof MbgViewListRowCol && colObject instanceof MbgViewListRowCol) {
                    cell = sheet.getCell(r, c, true);
                    members.clear();
                    ViewListHelper.add(members, rowMembers);
                    ViewListHelper.add(members, colMembers);
                    members.addAll(this.pageMembers);
                    members.addAll(this.viewMembers);
                    BgDimensionParseCommonHelper.builderBgFormula(cell, members, this.isCheckFull, null, rowDatas, null, this.itemFields);
                    accountType = this.getAccountType(members, cell);
                    if (this.isParseForm && BgNFSHelper.getFormulaOfCell(cell) == null) {
                        lockRange.addCell(r, c);
                    } else {
                        dataCellRange.addCell(r, c);
                    }
                } else if (rowObject instanceof MbgViewListCalcutor || colObject instanceof MbgViewListCalcutor) {
                    dataCellRange.addCell(r, c);
                    calculator = null;
                    int curIndex = -1;
                    if (rowObject instanceof MbgViewListCalcutor && colObject instanceof MbgViewListCalcutor) {
                        calcMembers = null;
                        if (realCell.isCalculateFirstByRow()) {
                            calculator = (MbgViewListCalcutor)rowObject;
                            curIndex = c;
                        } else {
                            calculator = (MbgViewListCalcutor)colObject;
                            curIndex = r;
                        }
                    } else if (rowObject instanceof MbgViewListCalcutor && !(colObject instanceof MbgViewListDescription)) {
                        calculator = (MbgViewListCalcutor)rowObject;
                        curIndex = c;
                        calcMembers = colMembers;
                    } else if (colObject instanceof MbgViewListCalcutor && !(rowObject instanceof MbgViewListDescription)) {
                        calculator = (MbgViewListCalcutor)colObject;
                        curIndex = r;
                        calcMembers = rowMembers;
                    }
                    if (calculator != null) {
                        if (!this.isParseForm) {
                            BgNFSHelper.setValue(sheet.getCell(r, c, true), "'=" + calculator.getFormula());
                        } else {
                            boolean isShowAlldata = true;
                            if (eleSet != null) {
                                if (eleIsPage) {
                                    for (int i = 0; i < this.pageMembers.size(); ++i) {
                                        if (this.pageMembers.get(i).getType() == null || !this.pageMembers.get(i).getType().equals(DimensionConstants.DEF_ELEMENT_NUMBER) || !eleSet.contains(this.pageMembers.get(i).getNumber()) || rowObject instanceof MbgViewListCalcutor && colObject instanceof MbgViewListCalcutor) continue;
                                        isShowAlldata = false;
                                        break;
                                    }
                                } else if (!(rowObject instanceof MbgViewListCalcutor) || !(colObject instanceof MbgViewListCalcutor)) {
                                    if (rowObject instanceof MbgViewListCalcutor) {
                                        for (int i = 0; i < colMembers.length; ++i) {
                                            if (!((BgDimensionMember)colMembers[i]).getType().equals(DimensionConstants.DEF_ELEMENT_NUMBER) || !eleSet.contains(((BgDimensionMember)colMembers[i]).getNumber())) continue;
                                            isShowAlldata = false;
                                            break;
                                        }
                                    } else if (colObject instanceof MbgViewListCalcutor) {
                                        for (int i = 0; i < rowMembers.length; ++i) {
                                            if (!((BgDimensionMember)rowMembers[i]).getType().equals(DimensionConstants.DEF_ELEMENT_NUMBER) || !eleSet.contains(((BgDimensionMember)rowMembers[i]).getNumber())) continue;
                                            isShowAlldata = false;
                                            break;
                                        }
                                    }
                                }
                            }
                            cell = sheet.getCell(r, c, true);
                            String expression = this.convertFormula(calculator.getFormula(), curIndex, cell, isShowAlldata);
                            if (!expression.isEmpty()) {
                                expression = "=" + expression;
                            }
                            BgNFSHelper.setExpression(cell, expression);
                            BgNFSHelper.setCellData(cell, INIT_EXPRESSION, expression);
                            if (rowObject != null && rowObject instanceof MbgViewListCalcutor && colObject instanceof MbgViewListCalcutor && realCell != null) {
                                BgNFSHelper.setCellExtData(cell, "isCalculateFirstByRow", realCell.isCalculateFirstByRow());
                            }
                        }
                        cell = sheet.getCell(r, c, true);
                        ViewListCalculatorDataStyleInfo calDataStyle = calculator.getDataStyleInfo() != null ? calculator.getDataStyleInfo() : new ViewListCalculatorDataStyleInfo();
                        String calDataStyleKey = calDataStyle.getDataStyleKey();
                        calStyle = Styles.getEmptySA();
                        this.templateStyle.setDataNegativeIndex(calDataStyle.getNegativeIndex());
                        calStyle.setNumberFormat(this.templateStyle.toNumberPattern(calDataStyle.getDecNums(), calDataStyle.isHasGroupSep(), calDataStyle.isShowPercent()));
                        if (calStyleRange.containsKey(calDataStyleKey)) {
                            calCellRange = (BgSheetRange)calStyleRange.get(calDataStyleKey);
                        } else {
                            calCellRange = new BgSheetRange(sheet);
                            calStyleRange.put(calDataStyleKey, calCellRange);
                            calStyleMap.put(calDataStyleKey, calStyle);
                        }
                        ViewListHelper.setCalculatorDataStyle(cell, calDataStyle);
                        calCellRange.addCell(r, c);
                    }
                }
                if (rowObject instanceof MbgViewListDescription || colObject instanceof MbgViewListDescription) {
                    cell = sheet.getCell(r, c, true);
                    members.clear();
                    ViewListHelper.add(members, rowMembers);
                    ViewListHelper.add(members, colMembers);
                    if (this.isParseForm) {
                        members.addAll(this.pageMembers);
                        members.addAll(this.viewMembers);
                    }
                    MbgViewListDescriptionHelper.buildDescriptionFormula(this.orgUnitId, cell, null, members, this.sheetManager, row, col, this.isCheckFull);
                    if (desCellRange == null) {
                        desCellRange = new BgSheetRange(sheet);
                    }
                    desCellRange.addCell(r, c);
                }
                if ((style = realCell.getShowStyle()) == null) {
                    style = this.templateStyle.getDataStyleAttributes();
                    if (tempStyleKey == null) {
                        tempStyleKey = style.getStyleKey();
                    }
                    styleKey = tempStyleKey;
                } else {
                    styleKey = style.getStyleKey();
                }
                if (styleRange.containsKey(styleKey)) {
                    if (((Map)styleRange.get(styleKey)).containsKey(accountType)) {
                        range = (BgSheetRange)((Map)styleRange.get(styleKey)).get(accountType);
                    } else {
                        range = new BgSheetRange(sheet);
                        ((Map)styleRange.get(styleKey)).put(accountType, range);
                    }
                } else {
                    range = new BgSheetRange(sheet);
                    styleRange.put(styleKey, new HashMap());
                    ((Map)styleRange.get(styleKey)).put(accountType, range);
                }
                if (!styleMap.containsKey(styleKey)) {
                    styleMap.put(styleKey, new HashMap());
                }
                if (!((Map)styleMap.get(styleKey)).containsKey(accountType)) {
                    newStyle = ViewListStyleHelper.convertStyle(style);
                    newStyle.setNumberFormat(this.getDataNumberFormate(accountType));
                    newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    ((Map)styleMap.get(styleKey)).put(accountType, newStyle);
                }
                range.addCell(r, c);
                condObject = realCell.getCondiionaFormatObject();
                if (condObject.getConditionaFormat() == null) continue;
                if (!condFormats.containsKey(condObject.getConditionaFormat())) {
                    condFormat2 = new ConditionalFormat(condObject.getConditionaFormat().getConditions(), condObject.getConditionaFormat().getSSAs(), (SortedCellBlockArray)sheet.getRange(r, c));
                    condFormats.put(condObject.getConditionaFormat(), condFormat2);
                    condRange = new BgSheetRange(sheet);
                    condFormatRanges.put(condFormat2, condRange);
                    sheet.getConditionalFormats().addConditionalFormat(condFormat2);
                } else {
                    condFormat2 = (ConditionalFormat)condFormats.get(condObject.getConditionaFormat());
                    condRange = (BgSheetRange)condFormatRanges.get(condFormat2);
                }
                condRange.addCell(r, c);
            }
        }
        logger.error((Object)("Build Formula:" + itemFormula));
        for (String styleKey : styleRange.keySet()) {
            Map rangeMap = (Map)styleRange.get(styleKey);
            Iterator ite = rangeMap.keySet().iterator();
            while (ite.hasNext()) {
                int accountType = (Integer)ite.next();
                range = (BgSheetRange)rangeMap.get(accountType);
                newStyle = (com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes)((Map)styleMap.get(styleKey)).get(accountType);
                MBgTemplateHelper.setRangeStyle(range.getRange(), newStyle, null);
            }
        }
        Range lRange = lockRange.getRange();
        if (lRange != null && !lRange.isEmpty()) {
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes lockStyle = Styles.getEmptySA();
            lockStyle.setLocked(true);
            lockStyle.setBackground(BgNConstants.LOCK_COLOR);
            lRange.setStyle(lockStyle, Styles.getEmptySA());
        }
        if (desCellRange != null) {
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes desStyle = Styles.getEmptySA();
            desStyle.setNumberFormat("@");
            desStyle.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(1));
            MBgTemplateHelper.setRangeStyle(desCellRange.getRange(), desStyle, null);
        }
        for (String calDataStyleKey : calStyleRange.keySet()) {
            calCellRange = (BgSheetRange)calStyleRange.get(calDataStyleKey);
            calStyle = (com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes)calStyleMap.get(calDataStyleKey);
            calStyle.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(3));
            calStyle.setLocked(true);
            MBgTemplateHelper.setRangeStyle(calCellRange.getRange(), calStyle, null);
        }
        for (ConditionalFormat condFormat2 : condFormatRanges.keySet()) {
            condRange = (BgSheetRange)condFormatRanges.get(condFormat2);
            condFormat2.setBlocks((SortedCellBlockArray)condRange.getRange());
        }
        Range dataRange = dataCellRange.getRange();
        if (dataRange != null && !dataRange.isEmpty()) {
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes noWarpStyle = Styles.getEmptySA();
            noWarpStyle.setWrapText(false);
            dataRange.setStyle(noWarpStyle, Styles.getEmptySA());
        }
        MBgTemplateHelper.logTotalTime("Build Formula");
    }

    private Set<String> createElementSet() {
        HashSet<String> eleSet = new HashSet<String>();
        Map<String, BgElementInfo> eleMap = this.getElementObjMap();
        if (eleMap != null && !eleMap.isEmpty()) {
            for (String key : eleMap.keySet()) {
                if (eleMap.get(key).isShowData()) continue;
                eleSet.add(key);
            }
        }
        return eleSet;
    }

    public String convertFormula(String formula, int curIndex, Cell cell, boolean isShowAlldata) {
        if (StringUtils.isEmpty((String)formula)) {
            return "";
        }
        StringBuffer formulaStr = new StringBuffer();
        List<IExpr> exprs = ExprParseHelper.parse(formula);
        List<IMbgViewListObject> rows = null;
        IMbgViewListObject mbgViewListObject = null;
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) instanceof RowExpr) {
                if (!isShowAlldata) {
                    return "";
                }
                rows = this.getRows();
                mbgViewListObject = null;
                for (int r = 0; r < rows.size(); ++r) {
                    if (!(rows.get(r) instanceof AbstractMbgViewListObject) || ((AbstractMbgViewListObject)rows.get(r)).getInitIndex() != ((RowExpr)exprs.get(i)).getRow() - 1) continue;
                    mbgViewListObject = rows.get(r);
                    break;
                }
                if (mbgViewListObject instanceof MbgViewListRowCol) {
                    formulaStr.append(this.convertRowColExpr(((RowExpr)exprs.get(i)).getRow() - 1, curIndex, true, cell));
                    continue;
                }
                if (mbgViewListObject instanceof MbgViewListCalcutor) {
                    MbgViewListCalcutor object = (MbgViewListCalcutor)mbgViewListObject;
                    formulaStr.append("(").append(this.convertFormula(object.getFormula(), curIndex, cell, isShowAlldata)).append(")");
                    continue;
                }
                if (!(mbgViewListObject instanceof MbgViewListDescription)) continue;
                formulaStr.append(this.convertRowColExpr(((RowExpr)exprs.get(i)).getRow() - 1, curIndex, true, cell));
                continue;
            }
            if (exprs.get(i) instanceof ColExpr) {
                if (!isShowAlldata) {
                    return "";
                }
                rows = this.getCols();
                mbgViewListObject = null;
                for (int r = 0; r < rows.size(); ++r) {
                    if (!(rows.get(r) instanceof AbstractMbgViewListObject) || ((AbstractMbgViewListObject)rows.get(r)).getInitIndex() != ((ColExpr)exprs.get(i)).getCol() - 1) continue;
                    mbgViewListObject = rows.get(r);
                    break;
                }
                if (mbgViewListObject instanceof MbgViewListRowCol) {
                    formulaStr.append(this.convertRowColExpr(((ColExpr)exprs.get(i)).getCol() - 1, curIndex, false, cell));
                    continue;
                }
                if (mbgViewListObject instanceof MbgViewListCalcutor) {
                    MbgViewListCalcutor object = (MbgViewListCalcutor)mbgViewListObject;
                    formulaStr.append("(").append(this.convertFormula(object.getFormula(), curIndex, cell, isShowAlldata)).append(")");
                    continue;
                }
                if (!(mbgViewListObject instanceof MbgViewListDescription)) continue;
                formulaStr.append(this.convertRowColExpr(((ColExpr)exprs.get(i)).getCol() - 1, curIndex, false, cell));
                continue;
            }
            if (exprs.get(i) instanceof FormulaExpr) {
                List<Object> tokens = ((FormulaExpr)exprs.get(i)).getTokens();
                for (int t = 0; t < tokens.size(); ++t) {
                    if (tokens.get(t) instanceof RowExpr) {
                        formulaStr.append(this.convertRowColExpr(((RowExpr)tokens.get(t)).getRow() - 1, curIndex, true, cell));
                        continue;
                    }
                    if (tokens.get(t) instanceof ColExpr) {
                        formulaStr.append(this.convertRowColExpr(((ColExpr)tokens.get(t)).getCol() - 1, curIndex, false, cell));
                        continue;
                    }
                    formulaStr.append(tokens.get(t));
                }
                continue;
            }
            formulaStr.append(exprs.get(i).getFormula());
        }
        return formulaStr.toString();
    }

    private void dealWithFormula(List<IExpr> exprs) {
        int i;
        ArrayList<Integer> index1 = new ArrayList<Integer>();
        ArrayList<Integer> index2 = new ArrayList<Integer>();
        for (i = 1; i < exprs.size(); ++i) {
            if (!(exprs.get(i) instanceof OperatorExpr) || !exprs.get(i).getSource().equals("/") && !exprs.get(i).getSource().equals("*") || !(exprs.get(i - 1) instanceof RowExpr) && !(exprs.get(i - 1) instanceof ColExpr)) continue;
            index1.add(i);
        }
        if (index1.size() > 0) {
            for (i = 0; i < index1.size(); ++i) {
                exprs.add((Integer)index1.get(i) - 1 + 2 * i, new LeftBracket("("));
                exprs.add((Integer)index1.get(i) + 1 + 2 * i, new RightBracket(")"));
            }
        }
        for (i = 0; i < exprs.size() - 1; ++i) {
            if (!(exprs.get(i) instanceof OperatorExpr) || !exprs.get(i).getSource().equals("/") && !exprs.get(i).getSource().equals("*") || !(exprs.get(i + 1) instanceof RowExpr) && !(exprs.get(i + 1) instanceof ColExpr)) continue;
            index2.add(i);
        }
        if (index2.size() > 0) {
            for (i = 0; i < index2.size(); ++i) {
                exprs.add((Integer)index2.get(i) + 1 + 2 * i, new LeftBracket("("));
                exprs.add((Integer)index2.get(i) + 3 + 2 * i, new RightBracket(")"));
            }
        }
    }

    private String convertRowColExpr(int rowColIndex, int curIndex, boolean isRow, Cell cell) {
        ArrayList<IMbgViewListObject> rowCols = new ArrayList<IMbgViewListObject>();
        if (isRow) {
            rowCols.addAll(this.sheetManager.getDimensionManager().getRows());
        } else {
            rowCols.addAll(this.sheetManager.getDimensionManager().getColumns());
        }
        if (!this.isCsl) {
            this.checkMultiOrgOnRowCol(isRow, cell, rowCols);
        }
        AbstractMbgViewListObject _rowObject = null;
        for (int r = 0; r < rowCols.size(); ++r) {
            if (!(rowCols.get(r) instanceof AbstractMbgViewListObject) || ((AbstractMbgViewListObject)rowCols.get(r)).getInitIndex() != rowColIndex) continue;
            _rowObject = (AbstractMbgViewListObject)rowCols.get(r);
            break;
        }
        if (_rowObject instanceof MbgViewListRowCol) {
            MbgViewListRowCol rowObject = (MbgViewListRowCol)_rowObject;
            if (isRow) {
                return this.convertSumExpr(rowObject.getStartIndex(), curIndex, rowObject.getEndIndex(), curIndex);
            }
            return this.convertSumExpr(curIndex, rowObject.getStartIndex(), curIndex, rowObject.getEndIndex());
        }
        if (_rowObject instanceof MbgViewListCalcutor) {
            MbgViewListCalcutor rowObject = (MbgViewListCalcutor)_rowObject;
            return new StringBuffer().append("(").append(this.convertFormula(rowObject.getFormula(), rowObject.getInitIndex(), cell, true)).append(")").toString();
        }
        if (_rowObject instanceof MbgViewListDescription) {
            MbgViewListDescription rowObject = (MbgViewListDescription)_rowObject;
            int desIndex = 0;
            for (int s = 0; s < rowCols.size() && rowCols.get(s) != rowObject; ++s) {
                if (rowCols.get(s) instanceof MbgViewListRowCol) {
                    desIndex = ((MbgViewListRowCol)rowCols.get(s)).getEndIndex();
                    continue;
                }
                if (rowCols.get(s) instanceof MbgViewListCalcutor) {
                    ++desIndex;
                    continue;
                }
                if (!(rowCols.get(s) instanceof MbgViewListDescription)) continue;
                ++desIndex;
            }
            if (isRow) {
                return SheetBaseMath.getBlockA1Name((int)(desIndex + 1), (int)cell.getCol(), (boolean)false, (boolean)false);
            }
            return SheetBaseMath.getBlockA1Name((int)cell.getRow(), (int)(desIndex + 1), (boolean)false, (boolean)false);
        }
        return "0";
    }

    private String convertSumExpr(int startRowIndex, int startColIndex, int endRowIndex, int endColIndex) {
        if (startColIndex < 0 || endRowIndex < 0 || startRowIndex > endRowIndex || startColIndex > endColIndex) {
            return "0";
        }
        if (startRowIndex == endRowIndex && startColIndex == endColIndex) {
            return SheetBaseMath.getBlockA1Name((int)startRowIndex, (int)startColIndex, (boolean)false, (boolean)false);
        }
        return "SUM(" + SheetBaseMath.getBlockA1Name((int)startRowIndex, (int)startColIndex, (int)endRowIndex, (int)endColIndex, (boolean)false) + ")";
    }

    private void checkMultiOrgOnRowCol(boolean isRow, Cell cell, List<IMbgViewListObject> rowCols) {
        if (cell == null) {
            return;
        }
        boolean isOrgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.sheetManager.getDimensionManager());
        if (!isOrgOnPageOrView) {
            Set<String> orgNums = MBGViewListFormCommonHelper.getOrgNumsifOrgonRowCol(this.curOrgNum, this.sheetManager);
            boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(this.sheetManager.getDimensionManager());
            if (!orgNums.isEmpty() && orgNums.size() > 1 && (isOrgOnRow && isRow || !isOrgOnRow && !isRow)) {
                Sheet sheet = cell.getSheet();
                Row row = cell.getRowObject();
                Column col = sheet.getColumn(cell.getCol(), false);
                if (!this.sheetManager.isRowColShowbyTemp()) {
                    Map<String, List<IMbgViewListObject>> tMap = MBGViewListFormCommonHelper.getViewListObjectsByOrg(this.sheetManager.getDimensionManager(), isOrgOnRow);
                    BgDimensionMember orgMember = MBGViewListFormCommonHelper.getOrgMember(this.sheetManager, row, col);
                    if (tMap != null && orgMember != null && tMap.containsKey(orgMember.getNumber())) {
                        rowCols.clear();
                        rowCols.addAll((Collection<IMbgViewListObject>)tMap.get(orgMember.getNumber()));
                    }
                } else {
                    if (this.curOrgNum == null) {
                        return;
                    }
                    Map<String, Map<Integer, IMbgViewListObject>> tMap = MBGViewListFormCommonHelper.getViewListIndexObjectsByTemp(this.sheetManager.getDimensionManager().clone(), isOrgOnRow, this.curOrgNum);
                    for (String orgNumber : tMap.keySet()) {
                        if (orgNumber.equals(this.curOrgNum)) continue;
                        Map<Integer, IMbgViewListObject> objMap = tMap.get(orgNumber);
                        for (Integer objIndex : objMap.keySet()) {
                            IMbgViewListObject obj = objMap.get(objIndex);
                            if (!(obj instanceof MbgViewListRowCol) || !(tMap.get(this.curOrgNum).get(objIndex) instanceof MbgViewListRowCol)) continue;
                            if (((MbgViewListRowCol)obj).getStartIndex() < ((MbgViewListRowCol)tMap.get(this.curOrgNum).get(objIndex)).getStartIndex()) {
                                ((MbgViewListRowCol)tMap.get(this.curOrgNum).get(objIndex)).setStartIndex(((MbgViewListRowCol)obj).getStartIndex());
                            }
                            if (((MbgViewListRowCol)obj).getEndIndex() <= ((MbgViewListRowCol)tMap.get(this.curOrgNum).get(objIndex)).getEndIndex()) continue;
                            ((MbgViewListRowCol)tMap.get(this.curOrgNum).get(objIndex)).setEndIndex(((MbgViewListRowCol)obj).getEndIndex());
                        }
                    }
                    rowCols.clear();
                    if (tMap.containsKey(this.curOrgNum)) {
                        rowCols.addAll(tMap.get(this.curOrgNum).values());
                    }
                }
            }
        }
    }

    private void getCurrentOrgOnRowCol(boolean isRow, List<IMbgViewListObject> rowCols) {
        if (this.curOrgNum == null) {
            return;
        }
        boolean isOrgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.sheetManager.getDimensionManager());
        if (!isOrgOnPageOrView) {
            Set<String> orgNums = MBGViewListFormCommonHelper.getOrgNumsifOrgonRowCol(this.curOrgNum, this.sheetManager);
            boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(this.sheetManager.getDimensionManager());
            if (!orgNums.isEmpty() && orgNums.size() > 1 && (isOrgOnRow && isRow || !isOrgOnRow && !isRow)) {
                if (!this.sheetManager.isRowColShowbyTemp()) {
                    Map<String, List<IMbgViewListObject>> tMap = MBGViewListFormCommonHelper.getViewListObjectsByOrg(this.sheetManager.getDimensionManager(), isOrgOnRow);
                    if (tMap.containsKey(this.curOrgNum) && tMap.get(this.curOrgNum) != null && !tMap.get(this.curOrgNum).isEmpty()) {
                        rowCols.clear();
                        rowCols.addAll((Collection<IMbgViewListObject>)tMap.get(this.curOrgNum));
                    }
                } else {
                    Map<String, Map<Integer, IMbgViewListObject>> tMap = MBGViewListFormCommonHelper.getViewListIndexObjectsByTemp(this.sheetManager.getDimensionManager().clone(), isOrgOnRow, this.curOrgNum);
                    if (tMap.containsKey(this.curOrgNum) && tMap.get(this.curOrgNum) != null && !tMap.get(this.curOrgNum).isEmpty()) {
                        rowCols.clear();
                        rowCols.addAll(tMap.get(this.curOrgNum).values());
                    }
                }
            }
        }
    }

    private String getDataNumberFormate(Integer accountType) {
        String numberFormat = ViewListStyleHelper.convertStyle(this.templateStyle.getDataStyleAttributes()).getNumberFormat();
        if (accountType == 10) {
            this.templateStyle.setDataNegativeIndex(this.templateStyle.getCurrencyNegativeIndex());
            numberFormat = this.templateStyle.toNumberPattern(this.templateStyle.getCurrencyDecNums(), this.templateStyle.isCurrencyHasGroupSep(), false);
        } else if (accountType == 20) {
            this.templateStyle.setDataNegativeIndex(this.templateStyle.getNoCurrencyNegativeIndex());
            numberFormat = this.templateStyle.toNumberPattern(this.templateStyle.getNoCurrencyDecNums(), this.templateStyle.isNoCurrencyGroupSep(), false);
        } else if (accountType == 30) {
            this.templateStyle.setDataNegativeIndex(this.templateStyle.getRateNegativeIndex());
            numberFormat = this.templateStyle.toNumberPattern(this.templateStyle.getRateDecNums(), this.templateStyle.isRateHasGroupSep(), false);
        }
        return numberFormat;
    }

    private Integer getAccountType(List<BgDimensionMember> members, Cell cell) {
        if (members != null && !members.isEmpty()) {
            int size = members.size();
            for (int m = 0; m < size; ++m) {
                BgDimensionMember mem = members.get(m);
                if (this.accountMap == null || !DimensionConstants.DEF_ACCOUNT_NUMBER.equals(mem.getType()) || StringUtils.isEmpty((String)mem.getNumber())) continue;
                BgNFSHelper.setUserObject(cell, "BGACCOUNT_NUMBER", mem.getNumber());
                if (this.accountMap.get(mem.getNumber()).equals(10)) {
                    return 10;
                }
                if (this.accountMap.get(mem.getNumber()).equals(20)) {
                    return 20;
                }
                if (!this.accountMap.get(mem.getNumber()).equals(30)) continue;
                return 30;
            }
        }
        return 10;
    }

    private int parseColDimension(Sheet sheet, int rowIndex) {
        ++rowIndex;
        int headRow = this.calculateColHeadRowCount();
        int headCol = this.calculateRowHeadColCount();
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes style = ViewListStyleHelper.convertStyle(this.templateStyle.getFormStyleAttributes());
        style.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(this.templateStyle.getColHeaderHorizontalAlign()));
        style.setNumberFormat("@");
        style.setLocked(true);
        for (int c = 0; c < this.sheetManager.getDimensionManager().getRowDimension().size(); ++c) {
            IMbgViewListObject object = (IMbgViewListObject)this.sheetManager.getDimensionManager().getRowDimension().get(c);
            ViewListHelper.setDimension(sheet.getColumn(c, true), object);
            if (headRow > 1) {
                Range r = sheet.getRange(rowIndex, c, rowIndex + headRow - 1, c);
                MBgTemplateHelper.setRangeStyle(r, style, null);
                r.setUserObject("row_member_merge", (Object)Boolean.TRUE);
                r.setIgnoreProtected(true);
                r.merge();
            }
            BgNFSHelper.setValue(sheet.getCell(rowIndex, c, true), this.getDisplayName(object));
            MBgTemplateHelper.setCellStyle(sheet, rowIndex, c, false, style, null);
            if (!(object instanceof MbgViewListDimensionInfo)) continue;
            MBgTemplateHelper.processMemberFilter((MbgViewListDimensionInfo)object, this.sheetManager.getSheetName(), this.memberFilter, false);
            BgDimensionBaseInfo curDimension = DimensionCommonHelper.searchDimension(((MbgViewListDimensionInfo)object).getNumber(), this.sheetManager.getDimensionManager());
            BgDimensionParseCommonHelper.setFilterDimension(sheet.getCell(rowIndex, c, true), curDimension);
        }
        MBgTemplateHelper.setRangeStyle(sheet.getRange(rowIndex, 0, rowIndex + headRow - 1, headCol), ViewListStyleHelper.getHeaderStyle(this.templateStyle), null);
        ColObjectProcessor processor = new ColObjectProcessor(headRow, rowIndex, headCol);
        this.fillRowCol(sheet, this.sheetManager.getDimensionManager().getColDimension(), this.sheetManager.getDimensionManager().getColumns(), processor, true);
        return processor.colIndex - 1;
    }

    protected void fillRowCol(Sheet sheet, List dimensions, List<IMbgViewListObject> objects, RowColObejctProcessor processor, boolean isColumn) {
        if (sheet == null || objects == null || objects.isEmpty()) {
            return;
        }
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimIndexMap.put(((MbgViewListDimensionInfo)dimensions.get(i)).getNumber(), i);
        }
        processor.processAttribMap(dimensions);
        IMbgViewListObject object = null;
        ArrayList<Object[]> members = new ArrayList<Object[]>();
        ArrayList<CellBlock> mergeBlockList = new ArrayList<CellBlock>();
        CellBlock[] mergeBlocks = null;
        for (int i = 0; i < objects.size(); ++i) {
            int m;
            object = objects.get(i);
            if (processor.isShowRowCol()) {
                ViewListHelper.setRowColStart(sheet.getCell(processor.startRowIndex, processor.startColIndex, true));
            }
            members.clear();
            this.calcMembers(sheet, dimIndexMap, object, members, processor.dimensionCount, processor.getLayout());
            for (m = 0; m < members.size(); ++m) {
                Object[] oneCombin = (Object[])members.get(m);
                CellBlock block = processor.getCombinBlock();
                this.fillProperty(oneCombin, dimensions);
                this.fillOneCombin(sheet, processor, object, oneCombin, block, isColumn, i);
                processor.setFlag(sheet, object, oneCombin);
                processor.nextCombin();
            }
            if (object instanceof MbgViewListRowCol) {
                mergeBlocks = processor.getMergeBlock();
                processor.setRowColIndex((MbgViewListRowCol)object);
            } else {
                mergeBlocks = new CellBlock[]{processor.getObjectBlock()};
            }
            for (m = 0; m < mergeBlocks.length; ++m) {
                if (object instanceof MbgViewListRowCol) {
                    if (!isColumn && !this.getTemplateStyle().isRowMemberMerge()) continue;
                    mergeBlockList.add(mergeBlocks[m]);
                    continue;
                }
                this.mergeBlock(sheet, mergeBlocks[m], processor, false);
            }
            StyleAttributes style = ((IMbgViewListStyle)((Object)object)).getStyle();
            if (style == null) {
                style = processor.getMemberStyle(this.templateStyle);
            }
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes styleAttrib = ViewListStyleHelper.convertStyle(style);
            styleAttrib.setNumberFormat("@");
            styleAttrib.setLocked(true);
            if (isColumn) {
                styleAttrib.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(this.templateStyle.getColHeaderHorizontalAlign()));
            } else {
                styleAttrib.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            }
            MBgTemplateHelper.setRangeStyle(sheet.getRange(processor.getObjectBlock()), styleAttrib, null);
            processor.nextObject();
        }
        mergeBlocks = processor.processMergeBlocks(mergeBlockList);
        if (mergeBlocks != null) {
            for (int m = 0; m < mergeBlocks.length; ++m) {
                if (processor instanceof RowObjectProcessor) {
                    MBgTemplateHelper.logTime("Start " + m);
                    this.mergeBlock(sheet, mergeBlocks[m], processor, true);
                    MBgTemplateHelper.logTime("end " + m);
                    continue;
                }
                this.mergeColBlock(sheet, mergeBlocks[m], processor);
            }
        }
    }

    protected void fillProperty(Object[] oneCombin, List dimensions) {
        if (oneCombin == null || dimensions == null) {
            return;
        }
        String key = null;
        BgDimensionMember member = null;
        for (int d = 0; d < dimensions.size(); ++d) {
            if (!(dimensions.get(d) instanceof MbgViewListAtribute)) continue;
            MbgViewListAtribute attribObject = (MbgViewListAtribute)dimensions.get(d);
            String number = null;
            for (int m = 0; m < oneCombin.length; ++m) {
                if (!(oneCombin[m] instanceof BgDimensionMember)) continue;
                member = (BgDimensionMember)oneCombin[m];
                if (!attribObject.getDimNumber().equals(member.getType())) continue;
                number = member.getNumber();
                break;
            }
            if (attribObject.getPropertySort().getId() != null) {
                key = attribObject.getDimNumber() + "_" + attribObject.getPropertySort().getId();
                if (this.propMaps == null || !this.propMaps.containsKey(key) || number == null) continue;
                oneCombin[d] = this.propMaps.get(key).get(number);
                continue;
            }
            String dimNumber = attribObject.getDimNumber();
            key = attribObject.getPropertySort().getNumber().equals(BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber)) ? attribObject.getDimNumber() + "_" + BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber) : attribObject.getDimNumber() + "_" + BgPropertyHelper.genDimDescPropertySortNumber((String)dimNumber);
            if (this.propMaps == null || !this.propMaps.containsKey(key) || number == null) continue;
            oneCombin[d] = this.propMaps.get(key).get(number);
        }
    }

    protected void mergeColBlock(Sheet sheet, CellBlock cellBlock, RowColObejctProcessor processor) {
        int startColIndex = -1;
        int lastColIndex = -1;
        if (cellBlock.getCol() == cellBlock.getCol2()) {
            return;
        }
        Object lastObject = null;
        Object curObject = null;
        int c = cellBlock.getCol();
        while (c <= cellBlock.getCol2()) {
            curObject = ViewListHelper.getHeadCellValue(sheet.getCell(cellBlock.getRow(), c, false));
            if (!(curObject != null && (curObject.equals(lastObject) || curObject instanceof ExpandMember && ((ExpandMember)curObject).equlasNumber(lastObject)))) {
                lastObject = curObject;
                if (startColIndex != lastColIndex) {
                    processor.mergeBlock(sheet, cellBlock.getRow(), startColIndex, cellBlock.getRow(), lastColIndex);
                    if (cellBlock.getRow2() > cellBlock.getRow()) {
                        this.mergeColBlock(sheet, CellBlock.getNewCellBlock((int)(cellBlock.getRow() + 1), (int)startColIndex, (int)cellBlock.getRow2(), (int)lastColIndex), processor);
                    }
                }
                startColIndex = c;
            } else if (c == cellBlock.getCol2() && startColIndex != c) {
                lastColIndex = c;
                processor.mergeBlock(sheet, cellBlock.getRow(), startColIndex, cellBlock.getRow(), lastColIndex);
                if (cellBlock.getRow2() > cellBlock.getRow()) {
                    this.mergeColBlock(sheet, CellBlock.getNewCellBlock((int)(cellBlock.getRow() + 1), (int)startColIndex, (int)cellBlock.getRow2(), (int)lastColIndex), processor);
                }
            }
            lastColIndex = c++;
        }
    }

    protected void mergeBlock(Sheet sheet, CellBlock cellBlock, RowColObejctProcessor processor, boolean isRowColObj) {
        int startRowIndex = -1;
        int startColIndex = -1;
        int lastRowIndex = -1;
        int lastColIndex = -1;
        Object lastObject = null;
        Object curObject = null;
        Object tmpColCurObj1 = null;
        Object tmpColCurObj2 = null;
        boolean isBeforeColEqual = true;
        for (int r = cellBlock.getRow(); r <= cellBlock.getRow2(); ++r) {
            int c = cellBlock.getCol();
            while (c <= cellBlock.getCol2()) {
                curObject = ViewListHelper.getHeadCellValue(sheet.getCell(r, c, false));
                if (c > 0 && r > cellBlock.getRow()) {
                    tmpColCurObj1 = ViewListHelper.getHeadCellValue(ViewListHelper.getCell(sheet, r - 1, c - 1));
                    tmpColCurObj2 = ViewListHelper.getHeadCellValue(ViewListHelper.getCell(sheet, r, c - 1));
                    if (tmpColCurObj1 instanceof ExpandMember && tmpColCurObj2 instanceof ExpandMember && !((ExpandMember)tmpColCurObj1).equlasNumber((ExpandMember)tmpColCurObj2) && isRowColObj) {
                        isBeforeColEqual = false;
                    }
                    if (isRowColObj) {
                        if (sheet.getMergeBlock(r, c - 1) == null) {
                            isBeforeColEqual = false;
                        } else {
                            int row = sheet.getMergeBlock(r, c - 1).getRow();
                            int row2 = sheet.getMergeBlock(r, c - 1).getRow2();
                            if (row > startRowIndex || r > row2) {
                                isBeforeColEqual = false;
                            }
                        }
                    }
                }
                if (!(curObject != null && (curObject.equals(lastObject) || curObject instanceof ExpandMember && ((ExpandMember)curObject).equlasNumber(lastObject)) && isBeforeColEqual)) {
                    lastObject = curObject;
                    processor.mergeBlock(sheet, startRowIndex, startColIndex, lastRowIndex, lastColIndex);
                    startRowIndex = r;
                    startColIndex = c;
                    isBeforeColEqual = true;
                }
                lastRowIndex = r;
                lastColIndex = c++;
            }
        }
        MBgTemplateHelper.logTime("start mergeBlock2");
        processor.mergeBlock(sheet, startRowIndex, startColIndex, lastRowIndex, lastColIndex);
        MBgTemplateHelper.logTime("end mergeBlock2");
    }

    protected void fillOneCombin(Sheet sheet, RowColObejctProcessor processor, IMbgViewListObject object, Object[] oneCombin, CellBlock block, boolean isColumn, int groupIndex) {
        int index = 0;
        int dimIndex = 0;
        for (int r = block.getRow(); r <= block.getRow2(); ++r) {
            for (int c = block.getCol(); c <= block.getCol2(); ++c) {
                Cell cell = sheet.getCell(r, c, true);
                Object oneMember = oneCombin[index];
                String showType = null;
                if (oneMember instanceof BgDimensionMember) {
                    showType = DimensionCommonHelper.searchDimension(((BgDimensionMember)oneMember).getType(), this.sheetManager.getDimensionManager().getDimension()).getShowType();
                }
                oneMember = ViewListMemberRender.createExpaneMember(oneMember, isColumn);
                if (this.isParseForm && object instanceof MbgViewListRowCol && ((MbgViewListRowCol)object).isCombin() && !processor.isProperty(r, c)) {
                    if (((MbgViewListRowCol)object).getDimensions().size() <= dimIndex) continue;
                    ViewListHelper.setCombinDimension(cell, ((MbgViewListRowCol)object).getDimensions().get(dimIndex));
                    ++dimIndex;
                }
                if (isColumn && oneMember instanceof MbgViewListDescription) {
                    MbgViewListDescription desc = (MbgViewListDescription)oneMember;
                    int initIndex = desc.getInitIndex() >= 0 ? desc.getInitIndex() : desc.getIndex();
                    String number = desc.getAlias() + "_" + initIndex + "_" + groupIndex;
                    MbgViewListDimensionInfo dim = new MbgViewListDimensionInfo(null);
                    dim.setName(desc.getAlias());
                    dim.setNumber(number);
                    BgDimensionParseCommonHelper.setFilterDimension(cell, dim);
                    MBgTemplateHelper.processMemberFilter(dim, this.sheetManager.getSheetName(), this.memberFilter, true);
                }
                ViewListHelper.setHeadCell(cell, oneMember, showType, this.isShowAlias);
                ++index;
            }
        }
    }

    protected void calcMembers(Sheet sheet, Map<String, Integer> dimIndexMap, IMbgViewListObject object, List<Object[]> members, int dimCount, String layout) {
        if (object instanceof MbgViewListRowCol) {
            this.calcMembers(sheet, dimIndexMap, (MbgViewListRowCol)object, members, dimCount, layout);
        } else if (object instanceof AbstractMbgViewListOther) {
            this.calcMembers((AbstractMbgViewListOther)object, members, dimCount);
        }
    }

    private void calcMembers(Sheet sheet, Map<String, Integer> dimIndexMap, MbgViewListRowCol object, List<Object[]> members, int dimCount, String layout) {
        Object[] objects = null;
        List<MbgViewListDimensionInfo> dimensions = object.getDimensions();
        if (object.isCombin()) {
            MbgViewListDimensionInfo dim;
            List<MbgViewListDimensionInfo> dims;
            HashMap existMembes = new HashMap();
            if (!object.getDimensions().isEmpty()) {
                dims = object.getDimensions();
                dim = null;
                for (int i = 0; i < dims.size(); ++i) {
                    dim = dims.get(i);
                    if (dim.getMember().isEmpty()) continue;
                    for (int x = 0; x < dim.getMember().size(); ++x) {
                        if (!existMembes.containsKey(dim.getNumber())) {
                            existMembes.put(dim.getNumber(), new HashMap());
                        }
                        ((Map)existMembes.get(dim.getNumber())).put(((BgDimensionMember)dim.getMember().get(x)).getNumber(), (BgDimensionMember)dim.getMember().get(x));
                    }
                }
            }
            if (!object.getCombinMembers().isEmpty()) {
                for (int i = 0; i < object.getCombinMembers().size(); ++i) {
                    BgDimensionMember comMember = object.getCombinMembers().get(i);
                    String[] numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
                    String[] srcNumbers = DimensionFormulaHelper.splitCombinations(comMember.getSrcNumber());
                    String[] types = DimensionFormulaHelper.splitCombinations(comMember.getType());
                    String[] attributes = DimensionFormulaHelper.splitCombinations(comMember.getAttribute());
                    String[] names = comMember.getName().split(DimensionConstants.TICK_SEPARATOR, -1);
                    objects = new Object[dimCount];
                    boolean exist = true;
                    for (int m = 0; m < numbers.length; ++m) {
                        if (!StringUtils.isEmpty((String)numbers[m])) {
                            MbgViewListDimensionMember newMember = new MbgViewListDimensionMember(types[m], attributes[m], names[m], numbers[m]);
                            newMember.setLevel(0);
                            newMember.setSrcNumber(srcNumbers == null ? "" : srcNumbers[m]);
                            if (existMembes.containsKey(newMember.getType()) && ((Map)existMembes.get(newMember.getType())).containsKey(newMember.getNumber())) {
                                newMember.setSortValue(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).getSortValue());
                                newMember.setLongName(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).getLongName());
                                newMember.setLeaf(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).isLeaf());
                                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(newMember.getType())) {
                                    newMember.setLevel(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).getLevel());
                                }
                            } else if (!StringUtils.isEmpty((String)newMember.getNumber())) {
                                if (this.isParseForm) {
                                    newMember = null;
                                }
                                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(types[m])) {
                                    exist = false;
                                    break;
                                }
                            }
                            if (!dimIndexMap.containsKey(types[m])) continue;
                            objects[dimIndexMap.get((Object)types[m]).intValue()] = newMember;
                            continue;
                        }
                        if (StringUtils.isEmpty((String)types[m])) continue;
                        objects[dimIndexMap.get((Object)types[m]).intValue()] = null;
                    }
                    if (!exist) continue;
                    members.add(objects);
                }
            } else if (!object.getDimensions().isEmpty()) {
                dims = object.getDimensions();
                dim = null;
                boolean isHasOrgDim = false;
                List orgMember = null;
                for (int i = 0; i < dims.size(); ++i) {
                    dim = dims.get(i);
                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                    isHasOrgDim = true;
                    orgMember = dim.getMember();
                    if (orgMember == null || orgMember.isEmpty()) break;
                    for (int x = 0; x < orgMember.size(); ++x) {
                        if (!(orgMember.get(x) instanceof MbgViewListDimensionMember)) continue;
                        ((MbgViewListDimensionMember)orgMember.get(x)).setLevel(0);
                    }
                    break;
                }
                if (!object.getCombinSelectMembers().isEmpty()) {
                    for (int i = 0; i < object.getCombinSelectMembers().size(); ++i) {
                        BgDimensionMember comMember = object.getCombinSelectMembers().get(i);
                        String[] numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
                        String[] srcNumbers = DimensionFormulaHelper.splitCombinations(comMember.getSrcNumber());
                        String[] types = DimensionFormulaHelper.splitCombinations(comMember.getType());
                        String[] attributes = DimensionFormulaHelper.splitCombinations(comMember.getAttribute());
                        String[] names = comMember.getName().split(DimensionConstants.TICK_SEPARATOR, -1);
                        objects = new Object[dimCount];
                        for (int m = 0; m < numbers.length; ++m) {
                            MbgViewListDimensionMember newMember = new MbgViewListDimensionMember(types[m], attributes[m], names[m], numbers[m]);
                            newMember.setLevel(0);
                            newMember.setSrcNumber(srcNumbers == null ? "" : srcNumbers[m]);
                            if (existMembes.containsKey(newMember.getType()) && ((Map)existMembes.get(newMember.getType())).containsKey(newMember.getNumber())) {
                                newMember.setSortValue(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).getSortValue());
                                newMember.setLeaf(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).isLeaf());
                                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(newMember.getType())) {
                                    newMember.setLevel(((BgDimensionMember)((Map)existMembes.get(newMember.getType())).get(newMember.getNumber())).getLevel());
                                }
                            }
                            if (!dimIndexMap.containsKey(types[m])) continue;
                            objects[dimIndexMap.get((Object)types[m]).intValue()] = newMember;
                        }
                        if (isHasOrgDim && dimIndexMap.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                            if (orgMember != null && !orgMember.isEmpty()) {
                                objects[dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER).intValue()] = orgMember.get(0);
                            } else if (this.isShowDefaultMember && dim != null && dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) && dim.getMember().isEmpty()) {
                                MbgViewListDimensionMember member = new MbgViewListDimensionMember(dim.getNumber(), dim.getRefField(), dim.getName(), null);
                                MbgViewListDimensionMember newMember = new MbgViewListDimensionMember(dim.getNumber(), dim.getRefField(), dim.getOrgDimType() != null ? dim.getOrgDimType().getAlias() : dim.getName(), null);
                                newMember.setAlias(newMember.getName());
                                objects[dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER).intValue()] = newMember;
                            }
                        }
                        members.add(objects);
                    }
                } else if (isHasOrgDim && orgMember != null) {
                    BgDimensionMember[] oneMember = new BgDimensionMember[dimCount];
                    this.buildMember(dimIndexMap, object.getDimensions(), members, oneMember, 0, true);
                } else {
                    objects = new Object[dimCount];
                    members.add(objects);
                }
            } else {
                objects = new Object[dimCount];
                members.add(objects);
            }
        } else if (object.getRelationMaps() != null && !object.getRelationMaps().isEmpty()) {
            this.buildRelationMember(dimIndexMap, object, members, dimCount, layout);
        } else {
            BgDimensionMember[] oneMember = new BgDimensionMember[dimCount];
            this.buildMember(dimIndexMap, object.getDimensions(), members, oneMember, 0, false);
        }
        this.filterMembers(object, sheet, members, dimIndexMap);
    }

    protected String getMemberRelationShipKey(String orgNumber, MbgViewListRowCol object, String layout) {
        return DimensionMemberRelationShipHelper.getKey(orgNumber, layout, object.getIndex());
    }

    private void buildRelationMember(Map<String, Integer> dimIndexMap, MbgViewListRowCol object, List<Object[]> members, int dimCount, String layout) {
        HashMap memberMap = new HashMap();
        final HashMap memberIndexMap = new HashMap();
        MbgViewListDimensionInfo dimension = null;
        BgDimensionMember member = null;
        final HashSet<String> relationSrc = new HashSet<String>();
        String srcNumber = null;
        HashMap<String, MbgViewListDimensionInfo> dimMap = new HashMap<String, MbgViewListDimensionInfo>();
        for (int i = 0; i < object.getDimensions().size(); ++i) {
            dimension = object.getDimensions().get(i);
            srcNumber = this.schemeHelper.getSrcNumber(dimension.getNumber());
            dimMap.put(srcNumber, dimension);
            for (int j = 0; j < dimension.getMember().size(); ++j) {
                member = (BgDimensionMember)dimension.getMember().get(j);
                srcNumber = member.getSrcNumberHasDefault();
                if (!memberMap.containsKey(srcNumber)) {
                    memberMap.put(srcNumber, new HashMap());
                }
                ((Map)memberMap.get(srcNumber)).put(member.getNumber(), member);
                if (!memberIndexMap.containsKey(srcNumber)) {
                    memberIndexMap.put(srcNumber, new HashMap());
                }
                if (((Map)memberIndexMap.get(srcNumber)).containsKey(member.getNumber())) continue;
                ((Map)memberIndexMap.get(srcNumber)).put(member.getNumber(), j);
            }
            if (srcNumber == null || !DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
            relationSrc.add(srcNumber);
        }
        Set<Object> orgSet = null;
        if (memberMap.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)) {
            orgSet = ((Map)memberMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)).keySet();
        } else {
            orgSet = new HashSet<String>();
            orgSet.add(this.curOrgNum);
        }
        Object var14_16 = null;
        MBGRowData rowData = null;
        String[] combins = null;
        String number = null;
        Object[] oneMembers = null;
        for (String string : orgSet) {
            rowData = this.mbgRowDatas.get(this.getMemberRelationShipKey(string, object, layout));
            if (rowData == null) continue;
            Iterator<String> itComb = rowData.getEffectiveItemCombinSet().iterator();
            block3: while (itComb.hasNext()) {
                combins = DimensionFormulaHelper.splitCombinations(itComb.next());
                oneMembers = new Object[dimCount];
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    if (this.isShowDefaultMember && (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)number.trim()))) {
                        oneMembers[dimIndexMap.get((Object)((MbgViewListDimensionInfo)dimMap.get((Object)srcNumber)).getNumber()).intValue()] = this.createDefaultNullMember((MbgViewListDimensionInfo)dimMap.get(srcNumber));
                        continue;
                    }
                    if (!memberMap.containsKey(srcNumber) || !((Map)memberMap.get(srcNumber)).containsKey(number)) continue block3;
                    member = (BgDimensionMember)((Map)memberMap.get(srcNumber)).get(number);
                    if (!dimIndexMap.containsKey(member.getType())) continue;
                    oneMembers[dimIndexMap.get((Object)member.getType()).intValue()] = member;
                }
                members.add(oneMembers);
            }
        }
        Collections.sort(members, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ViewListSheetParseHelper.this.compare(o1, o2, relationSrc, memberIndexMap);
            }
        });
    }

    public int compare(Object[] o1, Object[] o2, Set<String> relationSrc, Map<String, Map<String, Integer>> memberIndexMap) {
        if (relationSrc == null || relationSrc.isEmpty() || o1 == null || o1.length == 0) {
            return 0;
        }
        Object obj1 = null;
        Object obj2 = null;
        int compValue = -1;
        boolean isInRelation = false;
        for (int i = 0; i < o1.length; ++i) {
            BgDimensionMember m1;
            obj1 = o1[i];
            obj2 = o2[i];
            isInRelation = false;
            if (obj1 instanceof BgDimensionMember) {
                m1 = (BgDimensionMember)obj1;
                isInRelation = relationSrc.contains(m1.getSrcNumberHasDefault());
            }
            compValue = obj1 instanceof Comparable ? ((Comparable)obj1).compareTo(obj2) : 0;
            if (isInRelation) {
                if (compValue == 0) continue;
                return compValue;
            }
            if (compValue == 0 || !(obj1 instanceof BgDimensionMember) || !(obj2 instanceof BgDimensionMember)) continue;
            m1 = (BgDimensionMember)obj1;
            BgDimensionMember m2 = (BgDimensionMember)obj2;
            String src = m1.getSrcNumberHasDefault();
            compValue = memberIndexMap.get(src).get(m1.getNumber()).compareTo(memberIndexMap.get(src).get(m2.getNumber()));
            return compValue;
        }
        return 0;
    }

    private void filterMembers(MbgViewListRowCol object, Sheet sheet, List<Object[]> members, Map<String, Integer> dimIndexMap) {
        if (sheet == null || members == null) {
            return;
        }
        Object[] objects = null;
        MbgViewListDimensionMember oMember = null;
        String dimNumber = null;
        String sheetName = sheet.getSheetName();
        int size = members.size();
        block0: for (int i = size - 1; i >= 0; --i) {
            objects = members.get(i);
            for (Map.Entry<String, Integer> entry : dimIndexMap.entrySet()) {
                int index = entry.getValue();
                oMember = objects[index] instanceof MbgViewListDimensionMember ? (MbgViewListDimensionMember)objects[index] : null;
                dimNumber = entry.getKey();
                if (this.memberFilter == null || this.memberFilter.getMemberFilter(sheetName, dimNumber) == null) continue;
                DimensionMemberFilterMember filter = this.memberFilter.getMemberFilter(sheetName, dimNumber);
                String number = null;
                number = oMember != null ? oMember.getNumber() : null;
                if (filter.getMembers() == null || filter.getMembers().contains(number)) continue;
                members.remove(objects);
                continue block0;
            }
        }
        if (object.isCombin() && !object.getCombinMembers().isEmpty() && this.isParseForm) {
            String[] numbers = null;
            String[] types = null;
            String number = null;
            block2: for (int i = 0; i < object.getCombinMembers().size(); ++i) {
                BgDimensionMember comMember = object.getCombinMembers().get(i);
                numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
                types = DimensionFormulaHelper.splitCombinations(comMember.getType());
                for (int j = 0; j < numbers.length; ++j) {
                    number = numbers[j];
                    dimNumber = types[j];
                    if (StringUtils.isEmpty((String)number) || this.memberFilter == null || this.memberFilter.getMemberFilter(sheetName, dimNumber) == null) continue;
                    DimensionMemberFilterMember filter = this.memberFilter.getMemberFilter(sheetName, dimNumber);
                    if (filter.getMembers() != null && !filter.getMembers().contains(number)) {
                        comMember.setHide(true);
                        continue block2;
                    }
                    comMember.setHide(false);
                }
            }
        }
    }

    private void buildMember(Map<String, Integer> dimIndexMap, List<MbgViewListDimensionInfo> dimensions, List<Object[]> members, BgDimensionMember[] oneMember, int dimIndex, boolean isCombin) {
        MbgViewListDimensionInfo dimension = dimensions.get(dimIndex);
        ArrayList<MbgViewListDimensionMember> thisMembers = null;
        if (this.isShowDefaultMember && dimension.getMember().isEmpty() && !isCombin) {
            thisMembers = new ArrayList<MbgViewListDimensionMember>();
            MbgViewListDimensionMember member = this.createDefaultNullMember(dimension);
            thisMembers.add(member);
        } else {
            thisMembers = dimension.getMember();
        }
        if (!thisMembers.isEmpty()) {
            for (int m = 0; m < thisMembers.size(); ++m) {
                oneMember[dimIndexMap.get((Object)dimension.getNumber()).intValue()] = (BgDimensionMember)thisMembers.get(m);
                if (dimIndex == dimensions.size() - 1) {
                    this.addMembers(members, oneMember);
                    continue;
                }
                this.buildMember(dimIndexMap, dimensions, members, oneMember, dimIndex + 1, isCombin);
            }
        } else if (isCombin) {
            oneMember[dimIndexMap.get((Object)dimension.getNumber()).intValue()] = null;
            if (dimIndex == dimensions.size() - 1) {
                this.addMembers(members, oneMember);
            } else {
                this.buildMember(dimIndexMap, dimensions, members, oneMember, dimIndex + 1, isCombin);
            }
        }
    }

    protected MbgViewListDimensionMember createDefaultNullMember(MbgViewListDimensionInfo dimension) {
        MbgViewListDimensionMember member = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) ? new MbgViewListDimensionMember(dimension.getNumber(), dimension.getRefField(), dimension.getOrgDimType() != null ? dimension.getOrgDimType().getAlias() : dimension.getName(), null) : new MbgViewListDimensionMember(dimension.getNumber(), dimension.getRefField(), dimension.getName(), null);
        member.setAlias(member.getName());
        return member;
    }

    private void addMembers(List<Object[]> members, BgDimensionMember[] oneMember) {
        if (!this.isShowOrgEmptyRowCol && oneMember != null) {
            for (int i = 0; i < oneMember.length; ++i) {
                if (oneMember[i] == null || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(oneMember[i].getType()) || oneMember[i].getNumber() != null) continue;
                return;
            }
        }
        Object[] ms = new Object[oneMember.length];
        System.arraycopy(oneMember, 0, ms, 0, oneMember.length);
        members.add(ms);
    }

    private void calcMembers(AbstractMbgViewListOther object, List<Object[]> members, int dimCount) {
        Object[] objects = new Object[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            objects[i] = object;
        }
        members.add(objects);
    }

    protected String getDisplayName(IMbgViewListObject object) {
        if (object instanceof MbgViewListDimensionInfo) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)object;
            if (!StringUtils.isEmpty((String)dim.getAlias())) {
                return dim.getAlias();
            }
            return dim.getName();
        }
        if (object instanceof MbgViewListAtribute) {
            return ((MbgViewListAtribute)object).getPropertySort().getName();
        }
        return null;
    }

    private int parseRowDimension(int rowIndex, Sheet sheet) {
        boolean colCount = false;
        int headRow = this.calculateColHeadRowCount();
        int headCol = this.calculateRowHeadColCount();
        RowObjectProcessor processor = new RowObjectProcessor(headCol, ++rowIndex, 0);
        this.fillRowCol(sheet, this.sheetManager.getDimensionManager().getRowDimension(), this.sheetManager.getDimensionManager().getRows(), processor, false);
        return processor.rowIndex - 1;
    }

    private int calculateRowHeadColCount() {
        return this.sheetManager.getDimensionManager().getRowDimension().size();
    }

    protected int calculateColHeadRowCount() {
        return this.sheetManager.getDimensionManager().getColDimension().size();
    }

    protected int calculateHeaderRowCount() {
        if (this.templateStyle == null) {
            return -1;
        }
        int rowIndex = -1;
        if (!BgFormTitleEnum.DontDisplay.equals((Object)this.templateStyle.getBgFormTitle())) {
            rowIndex = 0;
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getUnitName()) && rowIndex < this.templateStyle.getUnitPosition()) {
            rowIndex = this.templateStyle.getUnitPosition();
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getDateName()) && rowIndex < this.templateStyle.getDatePosition()) {
            rowIndex = this.templateStyle.getDatePosition();
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getCurrencyUnitName()) && rowIndex < this.templateStyle.getCurrencyUnitPosition()) {
            rowIndex = this.templateStyle.getCurrencyUnitPosition();
        }
        return rowIndex;
    }

    protected int parseHeader(Sheet sheet, int maxCol) {
        int rowIndex = -1;
        if (this.templateStyle == null) {
            return rowIndex;
        }
        if (!BgFormTitleEnum.DontDisplay.equals((Object)this.templateStyle.getBgFormTitle())) {
            ++rowIndex;
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes style = ViewListStyleHelper.convertStyle(this.templateStyle.getFormStyleAttributes());
            style.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(this.templateStyle.getBgFormTitleHorizontalAlign()));
            style.setNumberFormat("@");
            style.setLocked(true);
            MBgTemplateHelper.setRangeStyle(sheet.getRange(0, 0, 0, maxCol), style, null);
            Range r = sheet.getRange(0, 0, 0, maxCol);
            r.setIgnoreProtected(true);
            r.merge();
            if (BgFormTitleEnum.sheetName.equals((Object)this.templateStyle.getBgFormTitle())) {
                BgNFSHelper.setValue(sheet.getCell(0, 0, true), this.sheetManager.getSheetName());
            } else {
                BgNFSHelper.setValue(sheet.getCell(0, 0, true), this.sheetTitle);
            }
            sheet.getCell(0, 0, true).setUserObject("isHeaderCell", (Object)true);
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getUnitName())) {
            this.parseOtherHeader(sheet, this.editOrgUnit, this.templateStyle.getUnitHorizontalAlign(), "edit.orgunit", this.templateStyle.getUnitPosition(), maxCol);
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getDateName())) {
            this.parseOtherHeader(sheet, this.editPeriod, this.templateStyle.getDateHorizontalAlign(), "edit.period", this.templateStyle.getDatePosition(), maxCol);
        }
        if (!StringUtils.isEmpty((String)this.templateStyle.getCurrencyUnitName())) {
            this.parseOtherHeader(sheet, this.templateStyle.getCurrencyUnitName(), this.templateStyle.getCurrencyUnitHorizontalAlign(), "amout.unit", this.templateStyle.getCurrencyUnitPosition(), maxCol);
        }
        return rowIndex;
    }

    private void parseOtherHeader(Sheet sheet, String value, int horiAlign, String headKey, int position, int maxCol) {
        value = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)headKey), value);
        BgNFSHelper.setValue(sheet.getCell(position, 0, true), " ");
        sheet.getCell(position, 0, true).setUserObject(headKey, (Object)new ViewListTitleRenderBase.ViewListRenderObject(value, horiAlign));
        sheet.getCell(position, 0, true).setUserObject("isHeaderCell", (Object)true);
        if (sheet.getMergeBlock(sheet.getCell(position, 0, true)) == null) {
            Range r = sheet.getRange(position, 0, position, maxCol);
            r.setIgnoreProtected(true);
            r.merge();
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes style = ViewListStyleHelper.convertStyle(this.templateStyle.getColumnHeaderStyleAttributes());
            style.setLocked(true);
            MBgTemplateHelper.setRangeStyle(r, style, null);
        }
    }

    public void clear() {
        this.bgDimensionManagerForMulOrg.clear();
    }

    class RowObjectProcessor
    extends RowColObejctProcessor {
        RowObjectProcessor(int dimensionCount, int rowIndex, int colIndex) {
            super(dimensionCount, rowIndex, colIndex);
        }

        @Override
        void nextObject() {
            this.startRowIndex = this.rowIndex;
        }

        @Override
        void nextCombin() {
            ++this.rowIndex;
        }

        @Override
        CellBlock getCombinBlock() {
            return CellBlock.getNewCellBlock((int)this.rowIndex, (int)this.colIndex, (int)this.rowIndex, (int)(this.colIndex + this.dimensionCount - 1));
        }

        @Override
        CellBlock getObjectBlock() {
            return CellBlock.getNewCellBlock((int)this.startRowIndex, (int)this.startColIndex, (int)(this.rowIndex - 1), (int)(this.colIndex + this.dimensionCount - 1));
        }

        @Override
        public void setRowColIndex(MbgViewListRowCol object) {
            object.setStartIndex(this.startRowIndex);
            object.setEndIndex(this.rowIndex - 1);
        }

        @Override
        CellBlock getMergeBlock(int index) {
            return CellBlock.getNewCellBlock((int)this.startRowIndex, (int)(this.startColIndex + index), (int)(this.rowIndex - 1), (int)(this.startColIndex + index));
        }

        @Override
        public CellBlock[] processMergeBlocks(List<CellBlock> mergeBlockList) {
            return mergeBlockList.toArray(new CellBlock[mergeBlockList.size()]);
        }

        @Override
        void setFlag(Sheet sheet, IMbgViewListObject object, Object[] oneCombin) {
            ViewListHelper.setDimension(sheet.getRow(this.rowIndex, true), object);
            ViewListHelper.setDimensionMember(sheet.getRow(this.rowIndex, true), oneCombin);
            boolean isCombin = false;
            if (object instanceof MbgViewListRowCol && ((MbgViewListRowCol)object).isCombin()) {
                isCombin = true;
            }
            if (isCombin) {
                BgDimensionMember combinMember = ViewlistCombinHelper.getCombinMemberByDimMember(sheet.getRow(this.rowIndex, true));
                ViewlistCombinHelper.setCombinOldMember(sheet.getRow(this.rowIndex, true), combinMember);
            }
        }

        @Override
        void mergeAttrib(Sheet sheet, int startRowIndex, int startColIndex, int lastRowIndex, int lastColIndex) {
            if (startColIndex == lastColIndex && this.attribMap.containsKey(new Integer(startColIndex))) {
                List list = (List)this.attribMap.get(new Integer(startColIndex));
                for (int i = 0; i < list.size(); ++i) {
                    this.mergeBlock(sheet, startRowIndex, (Integer)list.get(i), lastRowIndex, (Integer)list.get(i));
                }
            }
        }

        @Override
        Integer getIndex(int row, int col) {
            return col;
        }

        @Override
        boolean isShowRowCol() {
            return true;
        }

        @Override
        StyleAttributes getMemberStyle(TemplateStyleInfo tempStyleInfo) {
            if (tempStyleInfo == null) {
                return null;
            }
            return tempStyleInfo.getDataStyleAttributes();
        }

        @Override
        String getLayout() {
            return "row";
        }
    }

    class ColObjectProcessor
    extends RowColObejctProcessor {
        ColObjectProcessor(int dimensionCount, int rowIndex, int colIndex) {
            super(dimensionCount, rowIndex, colIndex);
        }

        @Override
        void nextObject() {
            this.startColIndex = this.colIndex;
        }

        @Override
        void nextCombin() {
            ++this.colIndex;
        }

        @Override
        CellBlock getCombinBlock() {
            return CellBlock.getNewCellBlock((int)this.rowIndex, (int)this.colIndex, (int)(this.rowIndex + this.dimensionCount - 1), (int)this.colIndex);
        }

        @Override
        CellBlock getObjectBlock() {
            return CellBlock.getNewCellBlock((int)this.startRowIndex, (int)this.startColIndex, (int)(this.rowIndex + this.dimensionCount - 1), (int)(this.colIndex - 1));
        }

        @Override
        public void setRowColIndex(MbgViewListRowCol object) {
            object.setStartIndex(this.startColIndex);
            object.setEndIndex(this.colIndex - 1);
        }

        @Override
        CellBlock getMergeBlock(int index) {
            return CellBlock.getNewCellBlock((int)(this.startRowIndex + index), (int)this.startColIndex, (int)(this.startRowIndex + index), (int)(this.colIndex - 1));
        }

        @Override
        void setFlag(Sheet sheet, IMbgViewListObject object, Object[] oneCombin) {
            ViewListHelper.setDimension(sheet.getColumn(this.colIndex, true), object);
            ViewListHelper.setDimensionMember(sheet.getColumn(this.colIndex, true), oneCombin);
        }

        @Override
        void mergeAttrib(Sheet sheet, int startRowIndex, int startColIndex, int lastRowIndex, int lastColIndex) {
            if (startRowIndex == lastRowIndex && this.attribMap.containsKey(new Integer(startRowIndex))) {
                List list = (List)this.attribMap.get(new Integer(startRowIndex));
                for (int i = 0; i < list.size(); ++i) {
                    this.mergeBlock(sheet, (Integer)list.get(i), startColIndex, (Integer)list.get(i), lastColIndex);
                }
            }
        }

        @Override
        public CellBlock[] processMergeBlocks(List<CellBlock> mergeBlockList) {
            if (mergeBlockList == null || mergeBlockList.isEmpty()) {
                return null;
            }
            CellBlock result = CellBlock.getNewCellBlock((int)-1, (int)-1, (int)-1, (int)-1);
            result.setRow(Integer.MAX_VALUE);
            result.setCol(Integer.MAX_VALUE);
            CellBlock block = null;
            for (int i = 0; i < mergeBlockList.size(); ++i) {
                block = mergeBlockList.get(i);
                result.setRow(Math.min(block.getRow(), result.getRow()));
                result.setRow2(Math.max(block.getRow2(), result.getRow2()));
                result.setCol(Math.min(block.getCol(), result.getCol()));
                result.setCol2(Math.max(block.getCol2(), result.getCol2()));
            }
            return new CellBlock[]{result};
        }

        @Override
        Integer getIndex(int row, int col) {
            return row;
        }

        @Override
        boolean isShowRowCol() {
            return false;
        }

        @Override
        StyleAttributes getMemberStyle(TemplateStyleInfo tempStyleInfo) {
            if (tempStyleInfo == null) {
                return null;
            }
            return tempStyleInfo.getColumnHeaderStyleAttributes();
        }

        @Override
        String getLayout() {
            return "col";
        }
    }

    abstract class RowColObejctProcessor {
        int dimensionCount = 0;
        int rowIndex = -1;
        int colIndex = -1;
        int startRowIndex = -1;
        int startColIndex = -1;
        Map<Integer, List<Integer>> attribMap = new HashMap<Integer, List<Integer>>();

        RowColObejctProcessor(int dimensionCount, int rowIndex, int colIndex) {
            this.dimensionCount = dimensionCount;
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
            this.startRowIndex = rowIndex;
            this.startColIndex = colIndex;
        }

        public abstract CellBlock[] processMergeBlocks(List<CellBlock> var1);

        public abstract void setRowColIndex(MbgViewListRowCol var1);

        public boolean isProperty(int row, int col) {
            Integer attribIndex = this.getIndex(row, col);
            Iterator<List<Integer>> it = this.attribMap.values().iterator();
            while (it.hasNext()) {
                if (!it.next().contains(attribIndex)) continue;
                return true;
            }
            return false;
        }

        abstract Integer getIndex(int var1, int var2);

        public void processAttribMap(List dimensions) {
            HashMap<String, Integer> dimMap = new HashMap<String, Integer>();
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
                dimMap.put(((MbgViewListDimensionInfo)dimensions.get(i)).getNumber(), i);
            }
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!(dimensions.get(i) instanceof MbgViewListAtribute)) continue;
                MbgViewListAtribute attrib = (MbgViewListAtribute)dimensions.get(i);
                Integer dimIndex = (Integer)dimMap.get(attrib.getDimNumber());
                if (!this.attribMap.containsKey(dimIndex)) {
                    this.attribMap.put(dimIndex, new ArrayList());
                }
                this.attribMap.get(dimIndex).add(i);
            }
        }

        abstract void setFlag(Sheet var1, IMbgViewListObject var2, Object[] var3);

        abstract boolean isShowRowCol();

        abstract void nextObject();

        abstract void nextCombin();

        abstract CellBlock getCombinBlock();

        abstract CellBlock getObjectBlock();

        CellBlock[] getMergeBlock() {
            CellBlock[] blocks = new CellBlock[this.dimensionCount];
            for (int i = 0; i < this.dimensionCount; ++i) {
                blocks[i] = this.getMergeBlock(i);
            }
            return blocks;
        }

        abstract CellBlock getMergeBlock(int var1);

        void mergeBlock(Sheet sheet, int startRowIndex, int startColIndex, int lastRowIndex, int lastColIndex) {
            if (sheet == null) {
                return;
            }
            if (startRowIndex < 0 || lastRowIndex < 0 || startColIndex < 0 || lastColIndex < 0) {
                return;
            }
            if (startRowIndex == lastRowIndex && startColIndex == lastColIndex) {
                return;
            }
            if (ViewlistCombinHelper.checkRowIsCombin(sheet.getRow(startRowIndex, false)).booleanValue()) {
                return;
            }
            Range r = sheet.getRange(startRowIndex, startColIndex, lastRowIndex, lastColIndex);
            r.setIgnoreProtected(true);
            r.merge();
        }

        abstract void mergeAttrib(Sheet var1, int var2, int var3, int var4, int var5);

        abstract StyleAttributes getMemberStyle(TemplateStyleInfo var1);

        abstract String getLayout();
    }
}

