/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.util.backport.Collections;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFConvertHelper {
    XSSFWorkbook hssfBook = null;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle emptyStyle;
    private DataFormat format;
    private HashMap<Integer, Object> stylesMap;
    private HashMap<Integer, Object> fontsMap;
    private AbstractDataWrapper _dataSource;
    private XSSFSheet _currentSheet;

    public XSSFWorkbook getXSSFBook(Book book) throws IOException {
        this.hssfBook = new XSSFWorkbook();
        this.emptyStyle = this.hssfBook.createCellStyle();
        this.format = this.hssfBook.createDataFormat();
        this.stylesMap = new HashMap();
        this.fontsMap = new HashMap();
        this._dataSource = new BookDataWrapper(book);
        int sheetCount = this._dataSource.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            String sheetName = this._dataSource.sheetName(i);
            if (StringUtil.isEmptyString((String)sheetName)) continue;
            this._dataSource.setCurrentSheetIndex(i);
            this._currentSheet = this.hssfBook.createSheet(sheetName);
            this.fillSheet();
            String passWd = this._dataSource.getPassWd();
            if (passWd != null) {
                this._currentSheet.protectSheet(passWd);
            }
            this.addFreezeLine();
            this.printSetup();
            this._dataSource.setGroupCol((org.apache.poi.ss.usermodel.Sheet)this._currentSheet, 0);
        }
        this._dataSource.configSourceRepaint(true);
        return this.hssfBook;
    }

    private void fillSheet() throws IOException {
        int rowNum = 0;
        int excelRowNum = 0;
        int rowIndex = 0;
        while (!this._dataSource.isRowEnd(rowNum)) {
            if (this._dataSource.isHideRow(rowNum)) {
                ++rowNum;
                continue;
            }
            if (excelRowNum > 1048575) {
                throw new IllegalArgumentException("too much rows!");
            }
            XSSFRow row = this._currentSheet.createRow(rowIndex++);
            row.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this._dataSource.rowHeightAt(rowNum)) * 10.0f)) * 20.0));
            this.fillRow((Row)row, rowNum, excelRowNum);
            ++excelRowNum;
            ++rowNum;
        }
    }

    private void fillRow(Row row, int rowNum, int excelRowNum) throws IOException {
        int colNum = 0;
        int excelColNum = 0;
        int cellIndex = 0;
        int valueType = 1;
        while (!this._dataSource.isColEnd(colNum)) {
            if (this._dataSource.isHideCol(colNum)) {
                ++colNum;
                continue;
            }
            Cell cell = row.createCell(cellIndex++);
            if (row.getRowNum() == 0) {
                this._currentSheet.setColumnWidth(colNum, this._dataSource.colWidthAt(colNum) / 8 * 256);
            }
            Object value = this._dataSource.valueAt(rowNum, colNum);
            String formula = this._dataSource.formulaAt(rowNum, colNum);
            if (excelColNum > 16383) {
                throw new IOException("too much columns!");
            }
            valueType = this._dataSource.valueTypeAt(rowNum, colNum);
            switch (valueType) {
                case 3: {
                    break;
                }
                case 4: {
                    value = this._dataSource.booleanValue((Boolean)value);
                    break;
                }
                case 2: {
                    if (!StringUtil.isEmptyString((String)formula) && formula.charAt(0) == '=') {
                        formula = formula.substring(1, formula.length());
                    }
                    try {
                        boolean emptyFormula = StringUtil.isEmptyString((String)formula);
                        if (!emptyFormula) {
                            cell.setCellFormula(formula);
                        }
                        if (value == null) {
                            value = new BigDecimal(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            if (!emptyFormula) break;
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            try {
                                cell.setCellValue(Double.parseDouble((String)value));
                                if (!emptyFormula) break;
                                cell.setCellType(CellType.NUMERIC);
                            }
                            catch (NumberFormatException nfe) {
                                if (StringUtil.isEmptyString((String)((String)value))) {
                                    cell.setCellValue((String)null);
                                    if (!emptyFormula) break;
                                    cell.setCellType(CellType.BLANK);
                                    break;
                                }
                                if (emptyFormula) {
                                    cell.setCellValue((String)value);
                                }
                                cell.setCellType(CellType.STRING);
                            }
                            break;
                        }
                        if (emptyFormula) {
                            cell.setCellValue(value == null ? "" : value.toString());
                        }
                        cell.setCellType(CellType.STRING);
                    }
                    catch (RuntimeException ex) {
                        if (value == null) {
                            value = new BigDecimal(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            cell.setCellValue((String)value);
                        } else {
                            cell.setCellValue(value.toString());
                        }
                        cell.setCellType(CellType.STRING);
                    }
                    break;
                }
                case 0: {
                    if (value == null) {
                        value = new Double(0.0);
                    }
                    if (value instanceof Number) {
                        cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                        break;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                        valueType = 6;
                        break;
                    }
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        GregorianCalendar newCalendar = new GregorianCalendar(1900, 0, 1);
                        if (calendar.before(newCalendar)) {
                            cell.setCellValue(calendar.getTime().toLocaleString());
                            cell.setCellType(CellType.STRING);
                            break;
                        }
                        cell.setCellValue((Calendar)value);
                        valueType = 6;
                        break;
                    }
                    if (!(value instanceof String)) break;
                    cell.setCellValue(value.toString());
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 1: {
                    String str;
                    if (value == null) {
                        value = "";
                    }
                    if (StringUtil.isEmptyString((String)(str = value.toString()))) {
                        cell.setCellValue("");
                        cell.setCellType(CellType.STRING);
                        break;
                    }
                    cell.setCellValue(str);
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 5: {
                    if (value == null) {
                        value = "error";
                    }
                    cell.setCellValue(value.toString());
                    break;
                }
                default: {
                    cell.setCellValue("");
                    cell.setCellType(CellType.STRING);
                }
            }
            this.addStyle(rowNum, colNum, (short)valueType, cell, value);
            this.addMerge(rowNum, colNum, excelRowNum, excelColNum);
            this.addAnnotate(rowNum, colNum, cell);
            value = null;
            ++excelColNum;
            ++colNum;
        }
    }

    private void addFreezeLine() {
        if (this._dataSource.getSheet() == null) {
            return;
        }
        ViewSplitInfo splitInfo = this._dataSource.getSheet().getSheetOption().getViewSplitInfo();
        if (!splitInfo.isFreezed()) {
            return;
        }
        int xSplit = splitInfo.getColSplit();
        int ySplit = splitInfo.getRowSplit();
        int topLeft_col = splitInfo.getFirstCol2();
        int topLeft_row = splitInfo.getFirstRow2();
        this._currentSheet.createFreezePane(xSplit, ySplit, topLeft_col, topLeft_row);
    }

    private void addMerge(int rowNum, int colNum, int excelRowNum, int excelColNum) {
        AbstractDataWrapper.MergeBlock merge = this._dataSource.getMergeBlock(rowNum, colNum);
        if (merge == null) {
            return;
        }
        CellRangeAddress cra = new CellRangeAddress(excelRowNum, excelRowNum + (merge.getRow2() - merge.getRow()), excelColNum, excelColNum + (merge.getCol2() - merge.getCol()));
        this._currentSheet.addMergedRegion(cra);
    }

    private void addAnnotate(int rowNum, int colNum, Cell cell) {
        if (cell == null) {
            return;
        }
        if (this._dataSource.getSheet() == null) {
            return;
        }
        com.kingdee.bos.ctrl.excel.model.struct.Cell theCell = this._dataSource.getSheet().getCell(rowNum, colNum, false);
        if (theCell == null) {
            return;
        }
        Comment theComment = theCell.getComment();
        if (theComment == null) {
            return;
        }
        XSSFDrawing drawing = this._currentSheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.getDefaultRectFromString(rowNum, colNum, theComment.getText());
        org.apache.poi.ss.usermodel.Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        comment.setString((RichTextString)new XSSFRichTextString(theComment.getText()));
        comment.setAuthor(theComment.getAuthor());
        cell.setCellComment(comment);
    }

    private XSSFClientAnchor getDefaultRectFromString(int row, int col, String str) {
        str = "\n".equals(str) ? "" : str;
        String[] strs = str.split("\n");
        String maxLengthString = (String)Collections.max(Arrays.asList(strs), (Comparator)new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                int length2;
                int length1 = XSSFConvertHelper.this.getDefaultRealLength(str1);
                if (length1 == (length2 = XSSFConvertHelper.this.getDefaultRealLength(str2))) {
                    return 0;
                }
                if (length1 > length2) {
                    return 1;
                }
                return -1;
            }
        });
        int maxLength = this.getDefaultRealLength(maxLengthString);
        int count = strs.length;
        if (maxLength > 156) {
            maxLength = 156;
            count = 0;
            for (String theStr : strs) {
                count += this.getLineNumber(theStr, 151);
            }
        } else {
            maxLength = maxLength * 14 * 74 / 730;
        }
        int maxHeight = this.getDefaultRealHeigh() * (count + 1) + this.getDefaultLeading() * count;
        maxHeight = maxHeight * 9 * 21 / 108;
        Rectangle leftUp = SheetBaseMath.getCellRect((Sheet)this._dataSource.getSheet(), (int)(row + 1), (int)(col + 1), (boolean)true);
        int rightDownRow = SheetBaseMath.rowAtPoint((Sheet)this._dataSource.getSheet(), (Point2D)new Point(leftUp.x + maxLength, leftUp.y + maxHeight));
        int rightDownCol = SheetBaseMath.colAtPoint((Sheet)this._dataSource.getSheet(), (Point2D)new Point(leftUp.x + maxLength, leftUp.y + maxHeight));
        return new XSSFClientAnchor(0, 0, 0, 0, (int)((short)col), row, (int)((short)rightDownCol), rightDownRow);
    }

    private int getDefaultRealLength(String str) {
        java.awt.Font font = new java.awt.Font("\u5b8b\u4f53", 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        Rectangle2D bounds = metrics.getStringBounds(str, null);
        return (int)bounds.getWidth();
    }

    private int getDefaultRealHeigh() {
        java.awt.Font font = new java.awt.Font("\u5b8b\u4f53", 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        return metrics.getHeight();
    }

    private int getDefaultLeading() {
        java.awt.Font font = new java.awt.Font("\u5b8b\u4f53", 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        return metrics.getLeading();
    }

    private int getLineNumber(String str, int length) {
        int index;
        int count = 1;
        String subString = str;
        while ((index = this.getSubStringLengthLargeThanGive(subString, length)) != -1 && index != subString.length()) {
            ++count;
            subString = subString.substring(index);
        }
        return count;
    }

    private int getSubStringLengthLargeThanGive(String str, int length) {
        if ("".equals(str)) {
            return -1;
        }
        int start = 0;
        int end = str.length() - 1;
        int flag = end / 2;
        String subString = str.substring(0, end);
        if (this.getDefaultRealLength(subString) == length) {
            return end;
        }
        if (this.getDefaultRealLength(subString) < length) {
            return -1;
        }
        while (this.getDefaultRealLength(subString = str.substring(0, flag)) != length) {
            if (this.getDefaultRealLength(subString) > length) {
                end = flag;
            } else {
                start = flag;
            }
            if (end - start == 1) {
                return start;
            }
            flag = (start + end) / 2;
        }
        return flag;
    }

    private void addStyle(int rowNum, int colNum, short valueType, Cell cell, Object value) {
        boolean isDateValue;
        ShareStyleAttributes ssa = this._dataSource.SSAAt(rowNum, colNum);
        boolean bl = isDateValue = valueType == 6;
        if (ssa.isEmpty() && !isDateValue) {
            cell.setCellStyle(this.emptyStyle);
            return;
        }
        if (isDateValue && StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
            Calendar cal;
            if (this.dateTimeStyle == null) {
                this.dateTimeStyle = this.hssfBook.createCellStyle();
                this.dateStyle = this.hssfBook.createCellStyle();
                XSSFFont dateFont = this.hssfBook.createFont();
                dateFont.setFontName(ssa.getFontName());
                dateFont.setFontHeight((short)ssa.getFontSize());
                this.dateTimeStyle.setDataFormat(this.format.getFormat("yyyy-m-d hh:mm"));
                this.dateTimeStyle.setFont((Font)dateFont);
                this.dateStyle.setDataFormat(this.format.getFormat("yyyy-m-d"));
                this.dateStyle.setFont((Font)dateFont);
            }
            if (value instanceof Date) {
                cal = Calendar.getInstance();
                cal.setTime((Date)value);
            } else {
                cal = (Calendar)value;
            }
            if (ssa.isEmpty()) {
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    cell.setCellStyle(this.dateTimeStyle);
                } else {
                    cell.setCellStyle(this.dateStyle);
                }
            } else {
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    sa.setNumberFormat("yyyy-m-d hh:mm");
                } else {
                    sa.setNumberFormat("yyyy-m-d");
                }
                ssa = Styles.getSSA((StyleAttributes)sa);
                Integer hash = new Integer(ssa.hashCode());
                XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
                if (style == null) {
                    XSSFCellStyle fullStyle = this.hssfBook.createCellStyle();
                    this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
                    cell.setCellStyle((CellStyle)fullStyle);
                    fullStyle = null;
                } else {
                    cell.setCellStyle((CellStyle)style);
                }
            }
            return;
        }
        Integer hash = new Integer(ssa.hashCode());
        XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
        if (style == null || DigitFormatPane.DataModel.isSpecialFormat((String)ssa.getNumberFormat())) {
            XSSFCellStyle fullStyle = this.hssfBook.createCellStyle();
            this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
            cell.setCellStyle((CellStyle)fullStyle);
            fullStyle = null;
        } else {
            cell.setCellStyle((CellStyle)style);
        }
    }

    private void parseStyle(ShareStyleAttributes ssa, XSSFCellStyle fullStyle, Integer id, int rowNum, int colNum) {
        Style stl = Styles.getStyle((ShareStyleAttributes)ssa);
        XSSFFont f = this.parseFont((ShareStyleAttributes)stl, id);
        fullStyle.setFont((Font)f);
        fullStyle.setLocked(stl.isLocked());
        FillPatternType pattern = this.parsePattern((ShareStyleAttributes)stl);
        if (pattern.equals((Object)FillPatternType.NO_FILL)) {
            fullStyle.setFillPattern(pattern);
        } else if (pattern.equals((Object)FillPatternType.SOLID_FOREGROUND)) {
            Color clr = stl.getBackground();
            if (Color.WHITE.equals(clr)) {
                fullStyle.setFillPattern(FillPatternType.NO_FILL);
            } else {
                fullStyle.setFillForegroundColor(this.parseColor(stl.getBackground()));
                fullStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getFontColor()));
        } else {
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getBackground()));
            fullStyle.setFillForegroundColor(this.parseColor(stl.getFontColor()));
            fullStyle.setFillPattern(pattern);
        }
        Styles.Position p = Styles.Position.LEFT;
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
            fullStyle.setBorderLeft(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setLeftBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
            fullStyle.setBorderRight(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setRightBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
            fullStyle.setBorderTop(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setTopBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
            fullStyle.setBorderBottom(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setBottomBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        fullStyle.setAlignment(this.parseHAlignment((ShareStyleAttributes)stl));
        fullStyle.setVerticalAlignment(this.parseVAlignment((ShareStyleAttributes)stl));
        fullStyle.setWrapText(stl.isWrapText());
        fullStyle.setShrinkToFit(stl.isShrinkText());
        if (stl.isShrinkText() && fullStyle.getAlignment().equals((Object)HorizontalAlignment.JUSTIFY)) {
            fullStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        fullStyle.setRotation((short)(0 - (short)stl.getRotation()));
        fullStyle.setIndention((short)stl.getIndentation());
        if (this._dataSource.isBookProtected()) {
            fullStyle.setLocked(true);
        } else {
            fullStyle.setLocked(stl.isLocked());
        }
        fullStyle.setHidden(stl.isHided());
        String numberFormat = stl.getNumberFormat();
        if (numberFormat.length() != 0) {
            if (!"000000".equals(numberFormat) && DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
                String cellText = this._dataSource.textAt(rowNum, colNum);
                if (StringUtil.isEmptyString((String)cellText)) {
                    numberFormat = "";
                } else {
                    numberFormat = cellText.replaceAll("\\.", "\\\\.");
                    numberFormat = numberFormat + ";" + numberFormat;
                    numberFormat = numberFormat.replaceAll("^-", "");
                }
            }
            if ("G/\u901a\u7528\u683c\u5f0f".equalsIgnoreCase(numberFormat)) {
                numberFormat = "General";
            }
            short builtInFormat = this.format.getFormat(numberFormat);
            fullStyle.setDataFormat(builtInFormat);
        }
        this.stylesMap.put(id, fullStyle);
    }

    private XSSFFont parseFont(ShareStyleAttributes ssa, Integer id) {
        XSSFFont cellFont = (XSSFFont)this.fontsMap.get(id);
        if (cellFont == null) {
            cellFont = this.hssfBook.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(this.parseColor(ssa.getFontColor()));
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.fontsMap.put(id, cellFont);
        }
        return cellFont;
    }

    private XSSFColor parseColor(Color awtColor) {
        return new XSSFColor(awtColor);
    }

    private BorderStyle parseBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    private HorizontalAlignment parseHAlignment(ShareStyleAttributes ssa) {
        Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
        HorizontalAlignment horizontalAlignment = align == Styles.HorizontalAlignment.LEFT ? HorizontalAlignment.LEFT : (align == Styles.HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : (align == Styles.HorizontalAlignment.RIGHT ? HorizontalAlignment.RIGHT : HorizontalAlignment.JUSTIFY));
        return horizontalAlignment;
    }

    private VerticalAlignment parseVAlignment(ShareStyleAttributes ssa) {
        Styles.VerticalAlignment align = ssa.getVerticalAlign();
        VerticalAlignment verticalAlignment = align == Styles.VerticalAlignment.TOP ? VerticalAlignment.TOP : (align == Styles.VerticalAlignment.MIDDLE ? VerticalAlignment.CENTER : (align == Styles.VerticalAlignment.BOTTOM ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    private FillPatternType parsePattern(ShareStyleAttributes ssa) {
        FillPatternType sret = FillPatternType.NO_FILL;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            case 35: {
                sret = FillPatternType.LESS_DOTS;
                break;
            }
            case 43: {
                sret = FillPatternType.LEAST_DOTS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    private void printSetup() {
        Object printInfo = null;
        if (printInfo != null) {
            try {
                int i;
                Header header = this._currentSheet.getHeader();
                if (printInfo.getHeaderLeft() != null) {
                    header.setLeft(printInfo.getHeaderLeft());
                }
                if (printInfo.getHeaderCenter() != null) {
                    header.setCenter(printInfo.getHeaderCenter());
                }
                if (printInfo.getHeaderRight() != null) {
                    header.setRight(printInfo.getHeaderRight());
                }
                Footer footer = this._currentSheet.getFooter();
                if (printInfo.getFooterLeft() != null) {
                    footer.setLeft(printInfo.getFooterLeft());
                }
                if (printInfo.getFooterCenter() != null) {
                    footer.setCenter(printInfo.getFooterCenter());
                }
                if (printInfo.getFooterRight() != null) {
                    footer.setRight(printInfo.getFooterRight());
                }
                XSSFPrintSetup printSetup = this._currentSheet.getPrintSetup();
                if (printInfo.isUsePage()) {
                    printSetup.setUsePage(true);
                    printSetup.setPageStart(printInfo.getStartPage());
                }
                printSetup.setScale(printInfo.getScale());
                printSetup.setCopies(printInfo.getCopies());
                printSetup.setLandscape(printInfo.isLandScape());
                printSetup.setDraft(printInfo.isDraft());
                printSetup.setLeftToRight(printInfo.isRowToCol());
                printSetup.setNoColor(printInfo.isNoColor());
                printSetup.setNotes(printInfo.isHasNotes());
                printSetup.setPaperSize(printInfo.getPageSize());
                printSetup.setFitWidth(printInfo.getWidthFit());
                printSetup.setFitHeight(printInfo.getHeightFit());
                printSetup.setFooterMargin((double)printInfo.getFootDis());
                printSetup.setHeaderMargin((double)printInfo.getHeadDis());
                this._currentSheet.setMargin((short)3, (double)printInfo.getBottom());
                this._currentSheet.setMargin((short)0, (double)printInfo.getLeft());
                this._currentSheet.setMargin((short)1, (double)printInfo.getRight());
                this._currentSheet.setMargin((short)2, (double)printInfo.getTop());
                this._currentSheet.setHorizontallyCenter(printInfo.isHorizontalAlign());
                this._currentSheet.setVerticallyCenter(printInfo.isVerticalAlign());
                this._currentSheet.setPrintGridlines(printInfo.isPrintGridLine());
                List l = printInfo.getPrintArea();
                if (l != null) {
                    int length = l.size();
                    for (int k = 0; k < length; ++k) {
                        ITableForPrint.IBlock block = (ITableForPrint.IBlock)l.get(k);
                        this.hssfBook.setPrintArea(this.hssfBook.getSheetIndex((org.apache.poi.ss.usermodel.Sheet)this._currentSheet), block.getCol(), block.getCol2(), block.getRow(), block.getRow2());
                    }
                }
                List l1 = printInfo.getPrintLeftTitleArea();
                List l2 = printInfo.getPrintTopTitleArea();
                if (l1 != null || l2 != null) {
                    ITableForPrint.IBlock block;
                    int k;
                    if (l1 != null) {
                        int size = l1.size();
                        for (k = 0; k < size; ++k) {
                            ITableForPrint.IBlock iBlock = block = k >= size ? null : (ITableForPrint.IBlock)l1.get(k);
                            if (block == null) continue;
                            CellRangeAddress cols = new CellRangeAddress(-1, -1, block.getCol(), block.getCol2());
                            this._currentSheet.setRepeatingColumns(cols);
                        }
                    }
                    if (l2 != null) {
                        int size = l2.size();
                        for (k = 0; k < size; ++k) {
                            ITableForPrint.IBlock iBlock = block = k >= size ? null : (ITableForPrint.IBlock)l2.get(k);
                            if (block == null) continue;
                            CellRangeAddress rows = new CellRangeAddress(block.getRow(), block.getRow2(), -1, -1);
                            this._currentSheet.setRepeatingRows(rows);
                        }
                    }
                }
                short[] colBreaks = printInfo.getColBreaks();
                short[] rowBreaks = printInfo.getRowBreaks();
                if (printInfo.isAutoFit()) {
                    this._currentSheet.setAutobreaks(true);
                    if (colBreaks != null && colBreaks.length > 0) {
                        printSetup.setFitWidth((short)colBreaks.length);
                    }
                    if (rowBreaks != null && rowBreaks.length > 0) {
                        printSetup.setFitHeight((short)rowBreaks.length);
                    }
                }
                int iLength = rowBreaks.length;
                for (i = 0; i < iLength; ++i) {
                    this._currentSheet.setRowBreak((int)rowBreaks[i]);
                }
                iLength = colBreaks.length;
                for (i = 0; i < iLength; ++i) {
                    this._currentSheet.setColumnBreak((int)colBreaks[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

