/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common.calcRow;

import com.kingdee.eas.ma.mbg.common.calcRow.AbstractExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ColExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.FormulaExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RowExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.UnkownExpr;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public abstract class AbstractCalcExpr
extends AbstractExpr {
    private static final Logger logger = Logger.getLogger((String)AbstractCalcExpr.class.getName());
    public static final Color ROW_COL = Color.MAGENTA;
    public static final Color FORMULA = new Color(0, 153, 255);
    public static final Pattern pattern = Pattern.compile("([RC]:\\[\\d+\\])");
    public static final String FLAG_SPLIT = ":";
    public static final String LEFT_VALUE_FLAG = "[";
    public static final String RIGHT_VALUE_FLAG = "]";
    private static Map<String, Class<? extends AbstractCalcExpr>> calcExprs = new HashMap<String, Class<? extends AbstractCalcExpr>>();

    protected AbstractCalcExpr(String source) {
        super(source);
    }

    protected abstract void init();

    public abstract String getFlag();

    protected abstract AttributeSet getFlagStyle();

    @Override
    public void buildDocument(StyledDocument doc) {
        String flagTxt = this.getSource().substring(0, this.getSource().indexOf(FLAG_SPLIT) + 1);
        AbstractCalcExpr.addToEnd(doc, flagTxt, this.getFlagStyle());
        AbstractCalcExpr.addToEnd(doc, this.getSource().substring(flagTxt.length()), null);
    }

    public static Map<String, Class<? extends AbstractCalcExpr>> getCalcExprs() {
        if (calcExprs.isEmpty()) {
            AbstractCalcExpr.addCalcExprs(new FormulaExpr(null));
            AbstractCalcExpr.addCalcExprs(new RowExpr(null));
            AbstractCalcExpr.addCalcExprs(new ColExpr(null));
        }
        return Collections.unmodifiableMap(calcExprs);
    }

    public static void addCalcExprs(AbstractCalcExpr expr) {
        calcExprs.put(expr.getFlag(), expr.getClass());
    }

    public static String getFlag(String source) {
        int flagIndex = AbstractCalcExpr.getFlagIndex(source);
        if (flagIndex < 0) {
            return null;
        }
        return source.substring(0, flagIndex);
    }

    public static String getValue(String source) {
        int flagIndex = AbstractCalcExpr.getFlagIndex(source);
        if (flagIndex < 0 || flagIndex == source.length() - 1) {
            return null;
        }
        if (!(source = source.substring(flagIndex + 1).trim()).startsWith(LEFT_VALUE_FLAG) || !source.endsWith(RIGHT_VALUE_FLAG)) {
            return null;
        }
        return source.substring(1, source.length() - 1).trim();
    }

    public static int getFlagIndex(String source) {
        if (source != null) {
            return source.indexOf(FLAG_SPLIT);
        }
        return -1;
    }

    public static String getCombin(String flag, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        return flag + FLAG_SPLIT + LEFT_VALUE_FLAG + value + RIGHT_VALUE_FLAG;
    }

    public static boolean isCalExpr(String exprStr) {
        return exprStr != null && exprStr.indexOf(":[") > 0 && exprStr.endsWith(RIGHT_VALUE_FLAG);
    }

    public static IExpr createExpr(String exprStr) {
        if (StringUtils.isEmpty((String)exprStr)) {
            return null;
        }
        String flag = AbstractCalcExpr.getFlag(exprStr);
        Class<? extends AbstractCalcExpr> cls = AbstractCalcExpr.getCalcExprs().get(flag);
        if (cls != null) {
            try {
                Constructor<? extends AbstractCalcExpr> con = cls.getConstructor(String.class);
                return con.newInstance(exprStr);
            }
            catch (SecurityException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"", (Throwable)e);
            }
            return new UnkownExpr(exprStr);
        }
        return new UnkownExpr(exprStr);
    }
}

