/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common.calcRow;

import com.kingdee.eas.ma.mbg.common.calcRow.AbstractCalcExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FormulaExpr
extends AbstractCalcExpr {
    private static SimpleAttributeSet flagStyle = null;
    private List<Object> tokens = new ArrayList<Object>();
    public static final String FLAG = "GVF";
    private String formula = null;

    public FormulaExpr(String source) {
        super(source);
        this.init();
    }

    @Override
    protected void init() {
        this.formula = FormulaExpr.getValue(this.getSource());
        if (StringUtils.isEmpty((String)this.formula)) {
            return;
        }
        Matcher matcher = AbstractCalcExpr.pattern.matcher(this.formula);
        int start = 0;
        while (matcher.find()) {
            if (matcher.start() != start) {
                this.tokens.add(this.formula.substring(start, matcher.start()));
            }
            this.tokens.add(AbstractCalcExpr.createExpr(matcher.group()));
            start = matcher.end();
        }
        if (start <= this.formula.length() - 1) {
            this.tokens.add(this.formula.substring(start));
        }
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    public String getPickFormula() {
        StringBuffer checkFormula = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.tokens.get(i) instanceof String) {
                checkFormula.append(this.tokens.get(i));
                continue;
            }
            if (!(this.tokens.get(i) instanceof IExpr)) continue;
            checkFormula.append("\"").append(((IExpr)this.tokens.get(i)).getSource()).append("\"");
        }
        return checkFormula.toString();
    }

    @Override
    public String getCheckFormula() {
        StringBuffer checkFormula = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.tokens.get(i) instanceof String) {
                checkFormula.append(this.tokens.get(i));
                continue;
            }
            if (!(this.tokens.get(i) instanceof IExpr)) continue;
            checkFormula.append(((IExpr)this.tokens.get(i)).getCheckFormula());
        }
        return checkFormula.toString();
    }

    @Override
    public String getFlag() {
        return FLAG;
    }

    @Override
    protected AttributeSet getFlagStyle() {
        if (flagStyle == null) {
            flagStyle = new SimpleAttributeSet();
            StyleConstants.setForeground(flagStyle, AbstractCalcExpr.FORMULA);
        }
        return flagStyle;
    }

    @Override
    public void buildDocument(StyledDocument doc) {
        if (this.tokens.isEmpty()) {
            return;
        }
        FormulaExpr.addToEnd(doc, this.getFlag() + ":", this.getFlagStyle());
        FormulaExpr.addToEnd(doc, "[", null);
        String str = null;
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.tokens.get(i) instanceof IExpr) {
                ((IExpr)this.tokens.get(i)).buildDocument(doc);
                continue;
            }
            str = String.valueOf(this.tokens.get(i));
            FormulaExpr.addToEnd(doc, str, null);
        }
        FormulaExpr.addToEnd(doc, "]", null);
    }

    public List<Object> getTokens() {
        return new ArrayList<Object>(this.tokens);
    }
}

