/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.convertexcel.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormProvider;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.convertexcel.IConvertExcelProvider;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormExportBaseUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslViewListFormConvertExcelProvider
extends BgCslViewListFormProvider
implements IConvertExcelProvider {
    private static final Logger logger = CoreUIObject.getLogger(BgCslViewListFormConvertExcelProvider.class);

    @Override
    public Book convert(Context ctx, IDimDataQuery info) throws Exception {
        this.setCtx(ctx);
        this.setEditValue(this.queryEditValue((IObjectPK)new ObjectUuidPK(info.getId())));
        this.setOrgUnitInfo(info.getBizOrgUnit());
        long ct = System.currentTimeMillis();
        logger.info((Object)("******************* start initViewListBook (" + info.getId() + ") : " + ct));
        Book book = this.initViewListBook();
        logger.info((Object)("******************* end initViewListBook  (" + info.getId() + ") : " + (System.currentTimeMillis() - ct) + "ms"));
        MbgViewlistMeasureUnitHelper viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(this.getAccountDataTypeMap(), this.getTemplateStyle(), this.getElementoObjMap());
        Map parameter = BgFormExportBaseUtils.getViewListExcelExportParams(book, viewlistMeasureHelper);
        book = BgNFSHelper.exportExcel2007(ctx, parameter);
        BgNFSHelper.stopBookProtection(book);
        List sheetName = (List)parameter.get("EXPORT_SHEETNAME");
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(book.getSheet(sheetIndex).getSheetOption());
            book.getSheet(sheetIndex).setName((String)sheetName.get(sheetSize - sheetIndex - 1));
        }
        return book;
    }

    private Book initViewListBook() throws Exception {
        this.defaultDesMap = null;
        this.bookParseHelper = null;
        this.getBgViewManagerForMulOrg().clear();
        Book _book = (Book)this.load();
        MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgCslForm().getId().toString(), null);
        this.fillData(_book);
        this.calcBook(_book, this.getReportAdapter());
        this.processMeasureUnit(_book);
        return _book;
    }

    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgCslForm().getId().toString(), null);
    }

    public ViewListBookParseHelper getBookParseHelper() {
        ViewListBookParseHelper bookParseHelper = super.getBookParseHelper();
        return bookParseHelper;
    }
}

