/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.convertexcel.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.convertexcel.IConvertExcelProvider;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgFormExportBaseUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgFormConvertExcelProvider
extends MBGFormProvider
implements IConvertExcelProvider {
    private static final Logger logger = CoreUIObject.getLogger(MbgFormConvertExcelProvider.class);

    @Override
    public Book convert(Context ctx, IDimDataQuery info) throws Exception {
        this.setCtx(ctx);
        this.setEditValue(this.queryEditValue((IObjectPK)new ObjectUuidPK(info.getId())));
        this.setOrgUnitInfo(info.getBizOrgUnit());
        long ct = System.currentTimeMillis();
        logger.info((Object)("******************* start initViewListBook (" + info.getId() + ") : " + ct));
        Book book = this.initBook();
        logger.info((Object)("******************* end initViewListBook  (" + info.getId() + ") : " + (System.currentTimeMillis() - ct) + "ms"));
        Map parameter = BgFormExportBaseUtils.getMbgFromExportParams(this.getBgFormInfo(), this, book);
        book = BgNFSHelper.exportExcel2007(ctx, parameter);
        BgNFSHelper.stopBookProtection(book);
        List sheetName = (List)parameter.get("EXPORT_SHEETNAME");
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(book.getSheet(sheetIndex).getSheetOption());
            book.getSheet(sheetIndex).setName((String)sheetName.get(sheetSize - sheetIndex - 1));
        }
        return book;
    }

    private Book initBook() throws Exception {
        Book _book = (Book)this.load();
        this.fillData(_book);
        this.calcBook(_book, this.getReportAdapter());
        return _book;
    }

    protected IReportPropertyAdapter getReportAdapter() {
        BgRptReportPropertyAdapter adapter = new BgRptReportPropertyAdapter(this.getBgFormInfo());
        adapter.setOrgUnit(this.getOrgUnitInfo());
        return adapter;
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgFormInfo().getId().toString(), null);
    }

    @Override
    protected int getDataType() {
        if (this.getBgFormInfo() != null && DimensionCommonHelper.isDecompose(this.getBgFormInfo().getProcessType())) {
            return this.getBgFormInfo().getDataType();
        }
        return super.getDataType();
    }
}

