/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.RefDimInfo;
import com.kingdee.eas.ma.mbg.cube.face.ICubeSqlStrategy;
import com.kingdee.eas.ma.mbg.cube.impl.AbstractCubeFacade;
import com.kingdee.eas.ma.mbg.cube.impl.CubeSqlStrategy;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CubeFacadeImpl
extends AbstractCubeFacade {
    @Override
    public ICubeSqlStrategy createSqlStrategy() {
        return new CubeSqlStrategy();
    }

    @Override
    public String addnewCube(Context ctx, List<String> refDims) throws Exception {
        if (ctx == null || refDims == null || refDims.isEmpty()) {
            return null;
        }
        String tableName = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            tableName = this.createCubeTable(conn, refDims);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return tableName;
    }

    @Override
    public void updateCube(Context ctx, String cubeName, List<String> newDims, List<String> oldDims) throws Exception {
        if (ctx == null || cubeName == null || newDims == null || oldDims == null) {
            return;
        }
        if (newDims.containsAll(oldDims) && oldDims.containsAll(newDims)) {
            return;
        }
        ArrayList<String> addColumns = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgCubeUtils.checkTable(conn);
            for (String newField : newDims) {
                addColumns.add(newField);
            }
            List existsColumns = BgDBUtils.getColumns((Connection)conn, (String)cubeName);
            addColumns.removeAll(existsColumns);
            addColumns.remove(DimensionBaseConstants.DEF_CSL_FIELD);
            String columnName = null;
            for (int i = 0; i < addColumns.size(); ++i) {
                columnName = (String)addColumns.get(i);
                if (!DimensionBaseConstants.DEF_CSL_FIELD.equals(columnName)) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(cubeName, columnName));
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getDailyActualCubeName(cubeName), columnName));
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getDecomposeCubeName(cubeName), columnName));
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getDecomposeSendDownCubeName(cubeName), columnName));
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getDecomposeGatherCubeName(cubeName), columnName));
                }
                if (BgDBUtils.existTable((Connection)conn, (String)BgCubeUtils.getCFSCubeName(cubeName)) != BgDBUtils.YES) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getCFSCubeName(cubeName), columnName));
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void removeColumn(Connection conn, String cubeName, String columnName) throws BOSException, SQLException, DimensionException {
        IRowSet rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select Top 1 FID From " + cubeName + " Where " + columnName + " IS NOT NULL"));
        if (rst.next()) {
            throw new DimensionException(DimensionException.CUBEHASDATA, new String[]{columnName});
        }
        SQLUtils.cleanup((ResultSet)rst);
        BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getDropColumnCubeSql(cubeName, columnName));
        BgDBUtils.regorgTable((Connection)conn, (String)cubeName);
    }

    @Override
    public void dropCube(Context ctx, String cubeName) throws Exception {
        if (ctx == null || cubeName == null) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            this.dropCube(conn, cubeName);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    public void checkCube(Context ctx, String cubeName, List<String> refDims) throws Exception {
        if (ctx == null || StringUtils.isEmpty((String)cubeName) || refDims == null || refDims.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            refDims.remove(DimensionBaseConstants.DEF_CSL_FIELD);
            this.checkBudgetCube(conn, cubeName, refDims);
            this.checkDailyActualCube(conn, cubeName, refDims);
            this.checkControlCube(conn, cubeName, refDims);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    public void updateCFSCube(Context ctx, String cubeName, BgSchemeInfo schemeInfo) throws Exception {
        if (ctx == null || StringUtils.isEmpty((String)cubeName)) {
            return;
        }
        List<String> refDims = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            refDims = BgCubeUtils.getRefDims(ctx, schemeInfo, true);
            if (refDims != null && !refDims.isEmpty()) {
                MbgVirtualView view = MbgVirtualView.getInstance((Context)ctx);
                BOSUuid cslViewId = BOSUuid.read((String)"M0NlAtvwTc+hRz1Td/e60V2BTmI=");
                String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)cslViewId);
                if (StringUtils.isEmpty((String)factTable)) {
                    view.checkVirtualView(cslViewId);
                }
                this.checkCFSCUbe(conn, cubeName, refDims);
                view.checkUnionDebt(ctx, schemeInfo.getUnionDebt());
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected String createCubeTable(Connection conn, List<String> refDims) throws SQLException {
        if (conn == null || refDims == null) {
            return null;
        }
        String cubeName = this.getSqlStrategy().getCubeName(conn);
        if (StringUtils.isEmpty((String)cubeName)) {
            return null;
        }
        this.checkBudgetCube(conn, cubeName, refDims);
        this.checkDailyActualCube(conn, cubeName, refDims);
        this.checkControlCube(conn, cubeName, refDims);
        this.checkDecomposeCube(conn, cubeName, refDims);
        return cubeName;
    }

    protected boolean updateCheckData(Context ctx, TempTablePool pool, Connection conn, String tableName, RefDimInfo refDim, Map<String, Set<String>> removes) throws BOSException, EASBizException {
        if (ctx == null || conn == null || StringUtils.isEmpty((String)tableName) || refDim == null) {
            return false;
        }
        String dimStr = null;
        String tempTableName = null;
        StringBuffer dimKey = new StringBuffer();
        for (int i = 0; i < refDim.getRefFields().size(); ++i) {
            if (i > 0) {
                dimKey.append("_");
            }
            dimKey.append(refDim.getRefFields().get(i));
        }
        StringBuffer sql = new StringBuffer("select TOP 1 i.FDimkey from ").append(tableName).append(" t ").append("join T_MBG_BgItemCombination i on i.FID = t.FBgItemCombinId ").append("join T_MBG_BgElement e on e.FID = t.FBgElementID ").append("where i.FDimKey <> ? ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(dimKey.toString());
        IRowSet rst = null;
        try {
            sql.append("and e.FNumber = ? ");
            params.add(refDim.getBgElementNumber());
            if (refDim.isLeaf()) {
                sql.append("and i.F2 = ? ");
                params.add(refDim.getIndexCombin());
            } else {
                sql.append("and i.F2 Like ? ");
                params.add(refDim.getIndexSrcNumber() + ":%");
                Set<String> removeNumbers = removes.get(refDim.getCombin());
                if (removeNumbers != null && !removeNumbers.isEmpty()) {
                    tempTableName = this.createTempTable(ctx, pool, conn, removeNumbers);
                    sql.append("and i.F2 not in (Select FNumber From ").append(tempTableName).append(") ");
                }
            }
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])params.toArray());
            if (rst.next()) {
                dimStr = rst.getString("FDimkey");
                throw new DimensionException(DimensionException.CUBEHASDATA, new String[]{dimStr});
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempTableName);
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, tempTableName);
        SQLUtils.cleanup((ResultSet)rst);
        return true;
    }

    protected String createTempTable(Context ctx, TempTablePool pool, Connection conn, Set<String> numbers) throws EASBizException, BOSException {
        String tempName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"Create TABLE TEML_KSQL_REFDIM(FNumber NVarchar(80))");
        try {
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert into " + tempName + " (FNumber) Values(?)"), new ArrayList<String>(numbers));
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return tempName;
    }

    protected boolean checkDimColumn(String columnName) {
        if (StringUtils.isEmpty((String)columnName)) {
            return false;
        }
        int in = columnName.length();
        for (int i = 1; i < in; ++i) {
            if (Character.isDigit(columnName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void dropCube(Connection conn, String cubeName) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName)) {
            return;
        }
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(this.getSqlStrategy().getDropCubeSql(cubeName));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getBudgetEntryCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getActualCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getActualEntryCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getDailyActualCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getDailyActualEntryCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getControlCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getCFSCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getCFSEntryCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getDecomposeCubeName(cubeName)));
        sqls.add(this.getSqlStrategy().getDropCubeSql(BgCubeUtils.getDecomposeEntryCubeName(cubeName)));
        int in = sqls.size();
        for (int i = 0; i < in; ++i) {
            BgDBUtils.executeUpdate((Connection)conn, (String)((String)sqls.get(i)));
        }
    }

    protected void checkBudgetCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 1);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkActualCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 4);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkActualCube1(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, Integer.MAX_VALUE);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkDailyActualCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 16);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkControlCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkDecomposeCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        for (int type : DimensionConstants.ALL_DECOMPOSE) {
            sqlMap.put(CubeConstants.CUBE_TYPE, type);
            this.executeCubeSql(conn, sqlMap, refDims);
        }
    }

    protected void checkDecomposeSendDownCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 512);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkDecomposeGatherCube(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return;
        }
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 1024);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void checkCFSCUbe(Connection conn, String cubeName, List<String> refDims) throws SQLException {
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        sqlMap.put(CubeConstants.CUBE_NAME, cubeName);
        sqlMap.put(CubeConstants.CUBE_TYPE, 64);
        this.executeCubeSql(conn, sqlMap, refDims);
    }

    protected void executeCubeSql(Connection conn, Map<String, Object> sqlMap, List<String> refDims) throws SQLException {
        String[] indexs;
        if (conn == null || sqlMap == null || refDims == null) {
            return;
        }
        String[] sqls = this.getSqlStrategy().getCubeSql(conn, sqlMap, refDims);
        if (sqls != null) {
            int in = sqls.length;
            for (int i = 0; i < in; ++i) {
                if (StringUtils.isEmpty((String)sqls[i])) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)sqls[i]);
            }
        }
        if ((indexs = this.getSqlStrategy().getCubeIndex(conn, sqlMap, refDims)) != null) {
            int in = indexs.length;
            for (int i = 0; i < in; ++i) {
                if (StringUtils.isEmpty((String)indexs[i])) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)indexs[i]);
            }
        }
    }

    @Override
    public void checkCubeHasActual(Context ctx, String cubeName, List<String> refDims) throws Exception {
        if (ctx == null || StringUtils.isEmpty((String)cubeName) || refDims == null || refDims.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            refDims.remove(DimensionBaseConstants.DEF_CSL_FIELD);
            this.checkBudgetCube(conn, cubeName, refDims);
            this.checkActualCube1(conn, cubeName, refDims);
            this.checkDailyActualCube(conn, cubeName, refDims);
            this.checkControlCube(conn, cubeName, refDims);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    public void updateCubeHasActual(Context ctx, String cubeName, List<String> newDims, List<String> oldDims) throws Exception {
        if (ctx == null || cubeName == null || newDims == null || oldDims == null) {
            return;
        }
        if (newDims.containsAll(oldDims) && oldDims.containsAll(newDims)) {
            return;
        }
        ArrayList<String> addColumns = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            for (String newField : newDims) {
                addColumns.add(newField);
            }
            List existsColumns = BgDBUtils.getColumns((Connection)conn, (String)cubeName);
            addColumns.removeAll(existsColumns);
            addColumns.remove(DimensionBaseConstants.DEF_CSL_FIELD);
            String columnName = null;
            for (int i = 0; i < addColumns.size(); ++i) {
                columnName = (String)addColumns.get(i);
                if (!DimensionBaseConstants.DEF_CSL_FIELD.equals(columnName)) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(cubeName, columnName));
                    BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getDailyActualCubeName(cubeName), columnName));
                }
                if (BgDBUtils.existTable((Connection)conn, (String)BgCubeUtils.getCFSCubeName(cubeName)) != BgDBUtils.YES) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getSqlStrategy().getModifyCubeSql(BgCubeUtils.getCFSCubeName(cubeName), columnName));
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

