/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.query.kd;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.query.IControlManager;
import com.kingdee.eas.ma.mbg.cube.query.IDataManager;
import com.kingdee.eas.ma.mbg.cube.query.IQuery;
import com.kingdee.eas.ma.mbg.cube.query.IQueryParameter;
import com.kingdee.eas.ma.mbg.cube.query.ISchemeCube;
import com.kingdee.eas.ma.mbg.cube.query.OlapService;
import com.kingdee.eas.ma.mbg.cube.query.kd.KDControlManager;
import com.kingdee.eas.ma.mbg.cube.query.kd.KDDataManager;
import com.kingdee.eas.ma.mbg.cube.query.kd.KDQueryStrategy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBADriver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Connection;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class KDOlapService
extends OlapService {
    @Override
    protected IControlManager createControlManager() {
        return new KDControlManager();
    }

    @Override
    protected IDataManager createDataManager() {
        return new KDDataManager();
    }

    @Override
    protected IQuery createQueryStrategy(IDataManager dataManager, IControlManager controlManager) {
        return new KDQueryStrategy(dataManager, controlManager);
    }

    @Override
    protected ISchemeCube createSchemeCube(IDataManager dataManager, IControlManager controlManager) {
        return null;
    }

    @Override
    public Map<String, IMbgData> olapQuery(Context ctx, IQueryParameter queryParameter) throws Exception {
        return super.olapQuery(ctx, queryParameter);
    }

    @Override
    protected Map<String, Object> beforeQuery(Context ctx, IQueryParameter parameter) throws Exception {
        Map<String, Object> olapParams = this.beforeQuery(ctx, parameter);
        KDDataManager dataManager = (KDDataManager)this.getDataManager();
        String cubeScheme = this.getSchemeCube().getSchemeCube(olapParams);
        if (StringUtils.isEmpty((String)cubeScheme)) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(cubeScheme.getBytes());
        olapParams.put(CubeConstants.OLAP_BYTES, input);
        CUBAConfig config = new CUBAConfig();
        config.supportSelfData = false;
        java.sql.Connection conn = null;
        Connection olapConn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            olapParams.put("JdbcConnection", conn);
            olapConn = CUBADriver.openConnection(input, olapParams, config);
            dataManager.setOlapConn(olapConn);
        }
        catch (CUBAException ex) {
            SQLUtils.cleanup((java.sql.Connection)conn);
            throw ex;
        }
        return olapParams;
    }

    @Override
    protected void afterQuery(Context ctx, Map<String, Object> olapParams) throws Exception {
        InputStream input;
        super.afterQuery(ctx, olapParams);
        KDDataManager dataManager = (KDDataManager)this.getDataManager();
        if (dataManager.getOlapConn() != null) {
            try {
                dataManager.getOlapConn().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (olapParams != null && (input = (InputStream)olapParams.get(CubeConstants.OLAP_BYTES)) != null) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

