/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import java.util.List;

public class MDXUtils {
    public static String getDimNumber(IDimension dimension) {
        String dimensionStr = null;
        dimensionStr = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) ? "[orgUnit]" : (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber()) ? "[period]" : (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) ? "[element]" : (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) ? "[currency]" : (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) ? "[scenario]" : (DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()) ? "[version]" : (DimensionConstants.DEF_STATE_NUMBER.equals(dimension.getNumber()) ? "[state]" : (DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimension.getNumber()) ? "[processType]" : "[DIM" + dimension.getField() + "]")))))));
        return dimensionStr;
    }

    public static StringBuffer getMdxTuple(List<IDimension> dims, StringBuffer str) {
        StringBuffer tuple;
        StringBuffer stringBuffer = tuple = str != null ? str : new StringBuffer();
        if (dims != null) {
            IDimension dimension = null;
            int in = dims.size();
            for (int i = 0; i < in; ++i) {
                dimension = dims.get(i);
                if (i > 0) {
                    tuple.append(" * ");
                }
                MDXUtils.getMdxSet(dimension, tuple);
            }
        }
        return tuple;
    }

    public static StringBuffer getMdxSet(IDimension dimension, StringBuffer str) {
        StringBuffer set;
        StringBuffer stringBuffer = set = str != null ? str : new StringBuffer();
        if (dimension != null) {
            set.append("{");
            if (dimension.getMembers().isEmpty()) {
                set.append(MDXUtils.getDimNumber(dimension) + ".members");
            } else {
                IMember member = null;
                int in = dimension.getMembers().size();
                for (int i = 0; i < in; ++i) {
                    member = dimension.getMembers().get(i);
                    if (i > 0) {
                        set.append(", ");
                    }
                    MDXUtils.getMdxMember(dimension, member, set);
                }
            }
            set.append("}");
        }
        return set;
    }

    public static StringBuffer getMdxMember(IDimension dimension, IMember member, StringBuffer str) {
        StringBuffer set = str != null ? str : new StringBuffer();
        return set;
    }
}

