/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class MbgBaseDataUtils {
    private static final Logger logger = Logger.getLogger(MbgBaseDataUtils.class);
    protected String tmpBgIndex = null;
    protected String tmpBgPeriod = null;
    protected String tmpBgElement = null;
    protected String tmpCurrency = null;
    protected String tmpScenario = null;
    protected TempTablePool pool = null;
    private Map<String, Set<String>> closureMap = null;

    protected TempTablePool getPool() {
        return this.pool;
    }

    public Map<String, Set<String>> getClosureMap() {
        return this.closureMap;
    }

    public void setClosureMap(Map<String, Set<String>> closureMap) {
        this.closureMap = closureMap;
    }

    public MbgBaseDataUtils(TempTablePool pool) {
        this.pool = pool;
    }

    protected Map<String, Set<String>> parseMember(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IDimDataQuery dimDataQuery) throws Exception {
        return this.parseMember(ctx, conn, schemeInfo, dimDataQuery, null);
    }

    protected Map<String, Set<String>> parseMember(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IDimDataQuery dimDataQuery, Map<String, Set<String>> filterMap) throws Exception {
        Map<String, Set<String>> mbgMemberMap = null;
        if (ctx == null || conn == null || schemeInfo == null || dimDataQuery == null || this.getPool() == null) {
            return null;
        }
        IMbgViewBase view = dimDataQuery.getViewById(ctx, schemeInfo);
        if (view != null) {
            MbgBaseDataUtils.filterMember(view, filterMap);
            mbgMemberMap = MbgDataHelper.parseMbgMember(view);
            if (mbgMemberMap == null || mbgMemberMap.isEmpty()) {
                return null;
            }
            if (!(mbgMemberMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD))) {
                return null;
            }
            this.updateMemberTable(ctx, conn, schemeInfo, mbgMemberMap);
            this.updateOtherMemberTable(ctx, conn, schemeInfo, mbgMemberMap);
        }
        return mbgMemberMap;
    }

    public static void filterMember(IMbgViewBase view, Map<String, Set<String>> filterMap) {
        if (view == null || filterMap == null || filterMap.isEmpty()) {
            return;
        }
        int in = view.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            IBgDimensionManagerBase manager = view.getSheetManagers().get(i).getDimensionManager();
            if (manager == null || filterMap == null || filterMap.isEmpty()) continue;
            if (manager instanceof MbgViewListDimensionManager) {
                MbgBaseDataUtils.filterViewListDimension((MbgViewListDimensionManager)manager, filterMap);
                continue;
            }
            MbgBaseDataUtils.filterViewDimension((IBgDimensionManager)manager, filterMap);
        }
    }

    private static void filterViewDimension(IBgDimensionManager manager, Map<String, Set<String>> filterMap) {
        for (int i = 0; i < manager.getDimension().size(); ++i) {
            MbgBaseDataUtils.filterDimension(manager.getDimension().get(i), filterMap);
        }
    }

    private static void filterViewListDimension(MbgViewListDimensionManager manager, Map<String, Set<String>> filterMap) {
        List<MbgViewListDimensionInfo> allDimensions = manager.getAllDimensions();
        for (int i = 0; i < allDimensions.size(); ++i) {
            MbgBaseDataUtils.filterDimension(allDimensions.get(i), filterMap);
        }
        MbgViewListRowCol row = null;
        BgDimensionMember member = null;
        for (int r = 0; r < manager.getRows().size(); ++r) {
            if (!(manager.getRows().get(r) instanceof MbgViewListRowCol) || !(row = (MbgViewListRowCol)manager.getRows().get(r)).isCombin()) continue;
            Iterator<BgDimensionMember> it = row.getCombinMembers().iterator();
            while (it.hasNext()) {
                member = it.next();
                if (StringUtils.isEmpty((String)member.getCombNumber()) || DimensionMemberRelationShipHelper.isInFilter(member.getCombNumber(), filterMap)) continue;
                it.remove();
            }
        }
    }

    private static void filterDimension(Object object, Map<String, Set<String>> filterMap) {
        if (!(object instanceof BgDimensionBaseInfo) || filterMap == null || filterMap.isEmpty()) {
            return;
        }
        BgDimensionBaseInfo dimension = (BgDimensionBaseInfo)object;
        Object obj = null;
        BgDimensionMember member = null;
        Iterator it = dimension.getMember().iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (!(obj instanceof BgDimensionMember) || !filterMap.containsKey((member = (BgDimensionMember)obj).getSrcNumberHasDefault()) || filterMap.get(member.getSrcNumberHasDefault()).contains(member.getNumber())) continue;
            it.remove();
        }
    }

    protected void updateMemberTable(Context ctx, Connection conn, BgSchemeInfo schemeInfo, Map<String, Set<String>> mbgMemberMap) throws BOSException, EASBizException {
        if (ctx == null || schemeInfo == null || mbgMemberMap == null || this.getPool() == null) {
            return;
        }
        ArrayList<Object> tmpList = new ArrayList<Object>();
        try {
            if (this.tmpBgIndex == null) {
                this.tmpBgIndex = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntId INT)");
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tmpBgIndex));
            }
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + this.tmpBgIndex + " (FNumber) values (?)"), (Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            this.querySubMember(conn, schemeInfo, mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            if (this.tmpBgPeriod == null) {
                this.tmpBgPeriod = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)");
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tmpBgPeriod));
            }
            tmpList.clear();
            if (this.getClosureMap() != null) {
                Set<String> periodNumberSet = mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNumber : periodNumberSet) {
                    if (this.getClosureMap().get(periodNumber) == null) continue;
                    tmpList.addAll((Collection)this.getClosureMap().get(periodNumber));
                }
            } else {
                tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpBgPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (this.tmpBgElement == null) {
                this.tmpBgElement = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)");
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tmpBgElement));
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpBgElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (this.tmpCurrency == null) {
                this.tmpCurrency = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tmpCurrency));
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (this.tmpScenario == null) {
                this.tmpScenario = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
            } else {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tmpScenario));
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            this.getScenrioTmpTable(conn, tmpList);
        }
        catch (SQLException ex) {
            logger.error((Object)"member sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void getScenrioTmpTable(Connection conn, List<Object> tmpList) throws SQLException {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE), tmpList);
    }

    protected void querySubMember(Connection conn, BgSchemeInfo schemeInfo, Set<String> dimNumbers) throws EASBizException {
        if (conn == null || schemeInfo == null) {
            return;
        }
        IRowSet rst = null;
        BOSUuid bgIndexViewId = schemeInfo.getViewId(DimensionBaseConstants.DEF_INDEX_NUMBER);
        if (bgIndexViewId == null) {
            return;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        List rsts = null;
        Object[] objs = null;
        HashSet<String> factDataSet = new HashSet<String>();
        String longNumber = null;
        String[] numbers = null;
        StringBuffer sql = new StringBuffer();
        try {
            int i;
            String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)bgIndexViewId);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FLongNumber from " + factTable + " where exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                sqlParams.add(rst.getString(1) + "!%");
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.append("select FDimLongNumber from " + factTable + " where FLongNumber like ? ");
            for (i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            rsts = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (i = 0; i < in; ++i) {
                objs = (Object[])rsts.get(i);
                longNumber = (String)objs[0];
                if (longNumber == null || (numbers = longNumber.split("!")) == null) continue;
                for (int j = 0; j < numbers.length; ++j) {
                    if (dimNumbers.contains(numbers[j])) continue;
                    factDataSet.add(numbers[j]);
                }
            }
            if (!factDataSet.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + this.tmpBgIndex + " (FNumber) values (?)"), factDataSet);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"querySubMember sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    protected void updateOtherMemberTable(Context ctx, Connection conn, BgSchemeInfo schemeInfo, Map<String, Set<String>> mbgMemberMap) throws BOSException, EASBizException {
    }

    public void clear() {
        if (this.pool == null) {
            return;
        }
        this.pool.releaseTable(this.tmpBgIndex);
        this.pool.releaseTable(this.tmpBgPeriod);
        this.pool.releaseTable(this.tmpBgElement);
        this.pool.releaseTable(this.tmpCurrency);
        this.pool.releaseTable(this.tmpScenario);
    }
}

