/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillStateEnum;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class MbgDataHelper {
    private static final Logger logger = Logger.getLogger((String)MbgDataHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrgUnitInfo getBaseOrgUnitInfo(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnit = MbgDataHelper.getBaseOrgUnitInfo(conn, ctx.getLocale(), orgUnitId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnit;
    }

    public static OrgUnitInfo getBaseOrgUnitInfo(Connection conn, Locale locale, BOSUuid orgUnitId) throws EASBizException {
        if (conn == null || locale == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FIsTransportOrgUnit, FIsQualityOrgUnit from T_ORG_BaseUnit where FID = ?"), (Object[])new Object[]{orgUnitId.toString()});
            if (rst.next()) {
                orgUnit = new OrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setIsCompanyOrgUnit(rst.getBoolean("FIsCompanyOrgUnit"));
                orgUnit.setIsAdminOrgUnit(rst.getBoolean("FIsAdminOrgUnit"));
                orgUnit.setIsSaleOrgUnit(rst.getBoolean("FIsSaleOrgUnit"));
                orgUnit.setIsPurchaseOrgUnit(rst.getBoolean("FIsPurchaseOrgUnit"));
                orgUnit.setIsStorageOrgUnit(rst.getBoolean("FIsStorageOrgUnit"));
                orgUnit.setIsProfitOrgUnit(rst.getBoolean("FIsProfitOrgUnit"));
                orgUnit.setIsCostOrgUnit(rst.getBoolean("FIsCostOrgUnit"));
                orgUnit.setIsCU(rst.getBoolean("FIsCU"));
                orgUnit.setIsUnion(rst.getBoolean("FIsUnion"));
                orgUnit.setIsHROrgUnit(rst.getBoolean("FIsHROrgUnit"));
                orgUnit.setIsTransportOrgUnit(rst.getBoolean("FIsTransportOrgUnit"));
                orgUnit.setIsQualityOrgUnit(rst.getBoolean("FIsQualityOrgUnit"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnit;
    }

    public static OrgUnitInfo getBaseOrgUnitByNumber(Connection conn, Locale locale, String number) throws EASBizException {
        if (conn == null || locale == null || number == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_ORG_BaseUnit where FNumber = ?", (Object[])new Object[]{number});
            if (rst.next()) {
                orgUnit = MbgDataHelper.getBaseOrgUnitInfo(conn, locale, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OrgUnitInfo> getBaseOrgUnitsByUuid(Context ctx, List<BOSUuid> billIds) throws Exception {
        List<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return orgUnits;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnits = MbgDataHelper.getBaseOrgUnitsByUuid(ctx, conn, ctx.getLocale(), billIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnits;
    }

    public static List<OrgUnitInfo> getBaseOrgUnitsByUuid(Context ctx, Connection conn, Locale locale, List<BOSUuid> orgUnitIds) throws Exception {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || conn == null || locale == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnits;
        }
        ArrayList<String> _orgUnitIds = new ArrayList<String>();
        for (BOSUuid uuid : orgUnitIds) {
            _orgUnitIds.add(uuid.toString());
        }
        return MbgDataHelper.getBaseOrgUnits(ctx, conn, locale, _orgUnitIds);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<OrgUnitInfo> getBaseOrgUnits(Context ctx, Connection conn, Locale locale, Collection<String> orgUnitIds) throws Exception {
        IRowSet rst;
        ArrayList<OrgUnitInfo> orgUnits;
        block10: {
            orgUnits = new ArrayList<OrgUnitInfo>();
            if (ctx == null) return orgUnits;
            if (conn == null) return orgUnits;
            if (locale == null) return orgUnits;
            if (orgUnitIds == null) return orgUnits;
            if (orgUnitIds.isEmpty()) {
                return orgUnits;
            }
            String tmpTable = null;
            OrgUnitInfo orgUnit = null;
            TempTablePool pool = null;
            rst = null;
            try {
                block12: {
                    block11: {
                        if (orgUnits.size() <= 50) break block11;
                        pool = TempTablePool.getInstance((Context)ctx);
                        tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                        if (tmpTable != null) {
                            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), orgUnitIds);
                            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber from T_ORG_BaseUnit where exists (select FID from " + tmpTable + " where FID = T_ORG_CostCenter.FID)"));
                            while (rst.next()) {
                                orgUnit = new OrgUnitInfo();
                                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                                orgUnit.setNumber(rst.getString("FNumber"));
                                orgUnit.setName(rst.getString("FName"));
                                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                                orgUnits.add(orgUnit);
                            }
                        }
                        break block12;
                    }
                    ArrayList<String> sqlParams = new ArrayList<String>();
                    sqlParams.addAll(orgUnitIds);
                    List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber from T_ORG_BaseUnit where FID IN (" + BgDBUtils.getSqlParam((int)50) + ")"), sqlParams);
                    for (Object[] obj : result) {
                        orgUnit = new OrgUnitInfo();
                        orgUnit.setId(BOSUuid.read((String)((String)obj[0])));
                        orgUnit.setNumber((String)obj[1]);
                        orgUnit.setName((String)obj[2]);
                        orgUnit.setLongNumber((String)obj[3]);
                        orgUnits.add(orgUnit);
                    }
                }
                if (pool == null || tmpTable == null) break block10;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (Exception ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup(rst);
        return orgUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrgUnitInfo getOrgUnitInfo(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnit = MbgDataHelper.getOrgUnitInfo(conn, ctx.getLocale(), orgUnitId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnit;
    }

    public static OrgUnitInfo getOrgUnitInfo(Connection conn, Locale locale, BOSUuid orgUnitId) throws EASBizException {
        if (conn == null || locale == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber, FLevel from T_ORG_CostCenter where FID = ?"), (Object[])new Object[]{orgUnitId.toString()});
            if (rst.next()) {
                orgUnit = new OrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setLevel(rst.getInt("FLevel"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnit;
    }

    public static OrgUnitInfo getOrgUnitByNumber(Connection conn, Locale locale, String number) throws EASBizException {
        if (conn == null || locale == null || number == null) {
            return null;
        }
        OrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_ORG_CostCenter where FNumber = ?", (Object[])new Object[]{number});
            if (rst.next()) {
                orgUnit = MbgDataHelper.getOrgUnitInfo(conn, locale, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, OrgUnitInfo> getOrgUnitByNumber(Context ctx, Collection<String> numbers) throws BOSException, EASBizException {
        Map<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (ctx == null || numbers == null || numbers.isEmpty()) {
            return orgUnitMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnitMap = MbgDataHelper.getOrgUnitByNumber(conn, ctx.getLocale(), numbers);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnitMap;
    }

    public static Map<String, OrgUnitInfo> getOrgUnitByNumber(Connection conn, Locale locale, Collection<String> numbers) throws EASBizException {
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (conn == null || locale == null || numbers == null || numbers.isEmpty()) {
            return orgUnitMap;
        }
        OrgUnitInfo orgUnit = null;
        ArrayList<String> _numbers = new ArrayList<String>();
        _numbers.addAll(numbers);
        List results = null;
        Object[] rst = null;
        try {
            results = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber from T_ORG_CostCenter where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), _numbers);
            int in = results.size();
            for (int i = 0; i < in; ++i) {
                rst = (Object[])results.get(i);
                orgUnit = new OrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)((String)rst[0])));
                orgUnit.setNumber((String)rst[1]);
                orgUnit.setName((String)rst[2]);
                orgUnit.setLongNumber((String)rst[3]);
                orgUnitMap.put(orgUnit.getNumber(), orgUnit);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return orgUnitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OrgUnitInfo> getOrgUnitsByUuid(Context ctx, List<BOSUuid> billIds) throws Exception {
        List<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return orgUnits;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnits = MbgDataHelper.getOrgUnitsByUuid(ctx, conn, ctx.getLocale(), billIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OrgUnitInfo> getOrgUnits(Context ctx, List<String> billIds) throws Exception {
        List<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return orgUnits;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            orgUnits = MbgDataHelper.getOrgUnits(ctx, conn, billIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnits;
    }

    public static List<OrgUnitInfo> getOrgUnitsByUuid(Context ctx, Connection conn, Locale locale, List<BOSUuid> billIds) throws Exception {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || conn == null || locale == null || billIds == null || billIds.isEmpty()) {
            return orgUnits;
        }
        ArrayList<String> _billIds = new ArrayList<String>();
        for (BOSUuid uuid : billIds) {
            _billIds.add(uuid.toString());
        }
        return MbgDataHelper.getOrgUnits(ctx, conn, _billIds);
    }

    public static List<OrgUnitInfo> getOrgUnits(Context ctx, Connection conn, Collection<String> billIds) throws Exception {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (ctx == null || conn == null || billIds == null || billIds.isEmpty()) {
            return orgUnits;
        }
        String tmpTable = null;
        OrgUnitInfo orgUnit = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        IRowSet rst = null;
        try {
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            if (tmpTable != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), billIds);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + ctx.getLocale() + " AS FName, FLongNumber from T_ORG_CostCenter where exists (select FID from " + tmpTable + " where FID = T_ORG_CostCenter.FID)"));
                while (rst.next()) {
                    orgUnit = new OrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                    orgUnit.setNumber(rst.getString("FNumber"));
                    orgUnit.setName(rst.getString("FName"));
                    orgUnit.setLongNumber(rst.getString("FLongNumber"));
                    orgUnits.add(orgUnit);
                }
                SQLUtils.cleanup((ResultSet)rst);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select obase.FID, obase.FNumber, obase.FName_" + ctx.getLocale() + " AS FName, ostruce.FLongNumber from T_ORG_STRUCTURE ostruce, T_ORG_BaseUnit obase where ostruce.FUnitId = obase.FID AND obase.FIsGrouping = 1 and exists (select FID from " + tmpTable + " where FID = obase.FID)"));
                while (rst.next()) {
                    orgUnit = new OrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                    orgUnit.setNumber(rst.getString("FNumber"));
                    orgUnit.setName(rst.getString("FName"));
                    orgUnit.setLongNumber(rst.getString("FLongNumber"));
                    orgUnits.add(orgUnit);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (pool != null && tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            SQLUtils.cleanup(rst);
        }
        return orgUnits;
    }

    public static Map<String, OrgUnitInfo> getOrgUnitMap(Context ctx, Connection conn, Collection<String> billIds) throws Exception {
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        List<OrgUnitInfo> orgUnits = MbgDataHelper.getOrgUnits(ctx, conn, billIds);
        for (OrgUnitInfo orgUnit : orgUnits) {
            orgUnitMap.put(orgUnit.getId().toString(), orgUnit);
        }
        return orgUnitMap;
    }

    public static Map<String, OrgUnitInfo> getOrgUnitMapByNum(Context ctx, Connection conn, Collection<String> billIds) throws Exception {
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        List<OrgUnitInfo> orgUnits = MbgDataHelper.getOrgUnits(ctx, conn, billIds);
        for (OrgUnitInfo orgUnit : orgUnits) {
            orgUnitMap.put(orgUnit.getNumber(), orgUnit);
        }
        return orgUnitMap;
    }

    public static BgOrgUnitInfo getBgOrgUnitInfoById(Connection conn, Locale locale, BOSUuid bgOrgUnitId) throws EASBizException {
        IRowSet rst;
        BgOrgUnitInfo bgOrgUnit;
        block6: {
            if (conn == null || locale == null || bgOrgUnitId == null) {
                return null;
            }
            bgOrgUnit = null;
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber, FOrgUnitId, FViewId, FParentId, FIsVirtual, FIsLeaf from T_MBG_BgOrgUnit where FID = ?"), (Object[])new Object[]{bgOrgUnitId.toString()});
                if (!rst.next()) break block6;
                bgOrgUnit = new BgOrgUnitInfo();
                bgOrgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                bgOrgUnit.setNumber(rst.getString("FNumber"));
                bgOrgUnit.setName(rst.getString("FName"));
                bgOrgUnit.setLongNumber(rst.getString("FLongNumber"));
                bgOrgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                bgOrgUnit.setViewID(rst.getString("FViewId"));
                bgOrgUnit.setIsVirtual(rst.getBoolean("FIsVirtual"));
                bgOrgUnit.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (rst.getString("FParentId") != null) {
                    bgOrgUnit.setParent(new BgOrgUnitInfo());
                    bgOrgUnit.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgOrgUnit;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgOrgUnitInfo getBgOrgUnitInfo(Context ctx, BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null) return null;
        if (bgOrgViewId == null) return null;
        if (orgUnitId == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitId = ?", (Object[])new Object[]{bgOrgViewId.toString(), orgUnitId.toString()});
            if (rst.next()) {
                bgOrgUnit = MbgDataHelper.getBgOrgUnitInfoById(conn, ctx.getLocale(), BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return bgOrgUnit;
    }

    public static BgOrgUnitInfo getBgOrgUnitInfo(Connection conn, Locale locale, BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws EASBizException {
        return MbgDataHelper.getBgOrgUnitInfo(conn, locale, bgOrgViewId, orgUnitId, Boolean.FALSE);
    }

    public static BgOrgUnitInfo getBgOrgUnitInfo(Connection conn, Locale locale, BOSUuid bgOrgViewId, BOSUuid orgUnitId, Boolean isVirtual) throws EASBizException {
        if (conn == null || bgOrgViewId == null || orgUnitId == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitId = ?");
        if (isVirtual != null) {
            sql.append(" and FIsVirtual = ?");
        }
        Object[] sqlParams = null;
        sqlParams = isVirtual == null ? new Object[]{bgOrgViewId.toString(), orgUnitId.toString()} : new Object[]{bgOrgViewId.toString(), orgUnitId.toString(), isVirtual};
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            if (rst.next()) {
                bgOrgUnit = MbgDataHelper.getBgOrgUnitInfoById(conn, locale, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgOrgUnit;
    }

    public static BgOrgUnitInfo getBgOrgUnitInfoByNumber(Connection conn, Locale locale, BOSUuid bgOrgViewId, String bgOrgNumber) throws EASBizException {
        if (conn == null || bgOrgViewId == null || StringUtils.isEmpty((String)bgOrgNumber)) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgOrgUnit where FViewId = ? and FNumber = ? and FIsVirtual = 0", (Object[])new Object[]{bgOrgViewId.toString(), bgOrgNumber});
            if (rst.next()) {
                bgOrgUnit = MbgDataHelper.getBgOrgUnitInfoById(conn, locale, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgOrgUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgOrgUnitInfo> getBgOrgUnitMapByUuid(Context ctx, BOSUuid bgOrgViewId, List<BOSUuid> orgUnitIds) throws Exception {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (ctx == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnitMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<BgOrgUnitInfo> orgUnits = MbgDataHelper.getBgOrgUnitsByUuid(ctx, conn, bgOrgViewId, orgUnitIds);
            if (orgUnits != null) {
                for (BgOrgUnitInfo bgOrgUnit : orgUnits) {
                    orgUnitMap.put(bgOrgUnit.getOrgUnitID(), bgOrgUnit);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgOrgUnitInfo> getBgOrgUnitMap(Context ctx, BOSUuid bgOrgViewId, Collection<String> orgUnitIds) throws BOSException, EASBizException {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (ctx == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnitMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<BgOrgUnitInfo> orgUnits = MbgDataHelper.getBgOrgUnits(ctx, conn, bgOrgViewId, orgUnitIds);
            if (orgUnits != null) {
                for (BgOrgUnitInfo bgOrgUnit : orgUnits) {
                    orgUnitMap.put(bgOrgUnit.getOrgUnitID(), bgOrgUnit);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return orgUnitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgOrgUnitInfo> getBgOrgUnits(Context ctx, BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws Exception {
        List<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (ctx == null || orgUnitId == null) {
            return bgOrgUnits;
        }
        ArrayList<BOSUuid> orgUnitIds = new ArrayList<BOSUuid>();
        orgUnitIds.add(orgUnitId);
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgOrgUnits = MbgDataHelper.getBgOrgUnitsByUuid(ctx, conn, bgOrgViewId, orgUnitIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgOrgUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgOrgUnitInfo> getBgOrgUnitsByUuid(Context ctx, BOSUuid bgOrgViewId, List<BOSUuid> orgUnitIds) throws Exception {
        List<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (ctx == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return bgOrgUnits;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgOrgUnits = MbgDataHelper.getBgOrgUnitsByUuid(ctx, conn, bgOrgViewId, orgUnitIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgOrgUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgOrgUnitInfo> getBgOrgUnits(Context ctx, BOSUuid bgOrgViewId, List<String> orgUnitIds) throws Exception {
        List<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (ctx == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return bgOrgUnits;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgOrgUnits = MbgDataHelper.getBgOrgUnits(ctx, conn, bgOrgViewId, orgUnitIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgOrgUnits;
    }

    public static List<BgOrgUnitInfo> getBgOrgUnitsByUuid(Context ctx, Connection conn, BOSUuid bgOrgViewId, List<BOSUuid> orgUnitIds) throws BOSException, EASBizException {
        ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (conn == null || bgOrgViewId == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return bgOrgUnits;
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        for (BOSUuid uuid : orgUnitIds) {
            tmpList.add(uuid.toString());
        }
        return MbgDataHelper.getBgOrgUnits(ctx, conn, bgOrgViewId, tmpList);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BgOrgUnitInfo> getBgOrgUnits(Context ctx, Connection conn, BOSUuid bgOrgViewId, Collection<String> orgUnitIds) throws BOSException, EASBizException {
        ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (ctx == null) return bgOrgUnits;
        if (conn == null) return bgOrgUnits;
        if (bgOrgViewId == null) return bgOrgUnits;
        if (orgUnitIds == null) return bgOrgUnits;
        if (orgUnitIds.isEmpty()) {
            return bgOrgUnits;
        }
        String tmpTable = null;
        BgOrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            if (tmpTable != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), orgUnitIds);
            }
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + ctx.getLocale() + " AS FName, FLongNumber, FOrgUnitId, FParentId, FIsLeaf,FIsTransferQingAnalyse from T_MBG_BgOrgUnit where FViewId = ? and FIsVirtual = 0 and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FOrgUnitId)"), (Object[])new Object[]{bgOrgViewId.toString()});
            while (rst.next()) {
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                orgUnit.setIsLeaf(rst.getBoolean("FIsLeaf"));
                orgUnit.setIsTransferQingAnalyse(rst.getBoolean("FIsTransferQingAnalyse"));
                if (rst.getString("FParentId") != null) {
                    orgUnit.setParent(new BgOrgUnitInfo());
                    orgUnit.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                }
                bgOrgUnits.add(orgUnit);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (pool == null) throw throwable;
                if (tmpTable == null) throw throwable;
                try {
                    pool.releaseTable(tmpTable);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool == null) return bgOrgUnits;
        if (tmpTable == null) return bgOrgUnits;
        try {
            pool.releaseTable(tmpTable);
            return bgOrgUnits;
        }
        catch (Exception exception) {
            return bgOrgUnits;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BgOrgUnitInfo> getBgOrgUnitsByNumber(Context ctx, Connection conn, Locale locale, BOSUuid bgOrgViewId, boolean isVirtual, Collection<String> orgUnitNums) throws BOSException, EASBizException {
        ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        if (conn == null) return bgOrgUnits;
        if (locale == null) return bgOrgUnits;
        if (bgOrgViewId == null) return bgOrgUnits;
        if (orgUnitNums == null) return bgOrgUnits;
        if (orgUnitNums.isEmpty()) {
            return bgOrgUnits;
        }
        String tmpTable = null;
        String _bgOrgViewId = bgOrgViewId.toString();
        BgOrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
            if (tmpTable != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), orgUnitNums);
            }
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FNumber, FName_" + locale + " AS FName, FLongNumber, FOrgUnitId, FParentId, FIsLeaf, FIsVirtual from T_MBG_BgOrgUnit where FViewId = ? and FIsVirtual = ? and exists (select FNumber from " + tmpTable + " where FNumber = T_MBG_BgOrgUnit.FNumber)"), (Object[])new Object[]{_bgOrgViewId, isVirtual});
            while (rst.next()) {
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                orgUnit.setIsLeaf(rst.getBoolean("FIsLeaf"));
                orgUnit.setIsVirtual(rst.getBoolean("FIsVirtual"));
                orgUnit.setViewID(_bgOrgViewId);
                if (rst.getString("FParentId") != null) {
                    orgUnit.setParent(new BgOrgUnitInfo());
                    orgUnit.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                }
                bgOrgUnits.add(orgUnit);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (pool == null) throw throwable;
                if (tmpTable == null) throw throwable;
                try {
                    pool.releaseTable(tmpTable);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool == null) return bgOrgUnits;
        if (tmpTable == null) return bgOrgUnits;
        try {
            pool.releaseTable(tmpTable);
            return bgOrgUnits;
        }
        catch (Exception exception) {
            return bgOrgUnits;
        }
    }

    public static List<BgOrgUnitInfo> getBgOrgUnitChildren(Context ctx, Connection conn, Locale locale, BgOrgUnitInfo bgOrgUnit, BOSUuid userId, boolean filterByUser) throws EASBizException, BOSException {
        return MbgDataHelper.getBgOrgUnitChildren(ctx, conn, locale, bgOrgUnit, null, userId, filterByUser);
    }

    public static List<BgOrgUnitInfo> getBgOrgUnitChildren(Context ctx, Connection conn, Locale locale, BgOrgUnitInfo bgOrgUnit, Boolean isDetail, BOSUuid userId, boolean filterByUser) throws EASBizException, BOSException {
        return MbgDataHelper.getBgOrgUnitChildren(ctx, conn, locale, bgOrgUnit, isDetail, true, userId, filterByUser);
    }

    public static BgOrgUnitCollection getBgOrgUnitChildren(BgOrgUnitInfo bgOrgUnit, String bgOrgViewId) throws BOSException, EASBizException {
        return MbgDataHelper.getBgOrgUnitChildren(null, bgOrgUnit, bgOrgViewId);
    }

    public static BgOrgUnitCollection getBgOrgUnitChildren(Context ctx, BgOrgUnitInfo bgOrgUnit, String bgOrgViewId) throws BOSException, EASBizException {
        BgOrgUnitCollection orgCol = new BgOrgUnitCollection();
        IBgOrgUnit orgInstance = null;
        orgInstance = ctx == null ? BgOrgUnitFactory.getRemoteInstance() : BgOrgUnitFactory.getLocalInstance(ctx);
        BgOrgUnitCollection allOrgCol = orgInstance.getBgOrgUnitCollection("select id, orgUnitId, number, longNumber, name, parent , isLeaf ,isVirtual where viewId = '" + bgOrgViewId + "' order by longNumber");
        String[] lns = null;
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        HashMap<String, Set<String>> childMap = new HashMap<String, Set<String>>();
        String pNumber = null;
        for (int i = 0; i < allOrgCol.size(); ++i) {
            lns = allOrgCol.get(i).getLongNumber().split("!");
            orgUnitMap.put(allOrgCol.get(i).getNumber(), allOrgCol.get(i));
            if (lns.length <= 1) continue;
            pNumber = lns[lns.length - 2];
            if (!childMap.containsKey(pNumber)) {
                childMap.put(pNumber, new LinkedHashSet());
            }
            ((Set)childMap.get(pNumber)).add(allOrgCol.get(i).getNumber());
        }
        MbgDataHelper.findAllChild(orgCol, bgOrgUnit.getNumber(), orgUnitMap, childMap);
        return orgCol;
    }

    private static void findAllChild(BgOrgUnitCollection orgCol, String number, Map<String, BgOrgUnitInfo> orgUnitMap, Map<String, Set<String>> childMap) {
        if (childMap.containsKey(number)) {
            for (String child : childMap.get(number)) {
                MbgDataHelper.findAllChild(orgCol, child, orgUnitMap, childMap);
            }
        }
        orgCol.add(orgUnitMap.get(number));
    }

    public static List<BgOrgUnitInfo> getBgOrgUnitChildren(Context ctx, Connection conn, Locale locale, BgOrgUnitInfo bgOrgUnit, Boolean isDetail, boolean isVirtualFilter, BOSUuid userId, boolean filterByUser) throws EASBizException, BOSException {
        ArrayList<BgOrgUnitInfo> colls = new ArrayList<BgOrgUnitInfo>();
        if (conn == null || locale == null || bgOrgUnit == null) {
            return colls;
        }
        boolean filter = filterByUser && userId != null;
        BgOrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FName_" + locale + " AS FName, t.FLongNumber, t.FOrgUnitId, t.FParentId, t.FIsLeaf, t.FIsVirtual from T_MBG_BgOrgUnit t " + (filter ? "inner join " + BgDBUtils.getOrgRangeTable((Context)ctx) + " o on o.FOrgId = t.FOrgUnitId " : "") + " where t.FViewId = ? and t.FLongNumber like ? " + (isVirtualFilter ? "and t.FIsVirtual = ? " : "") + (isDetail != null ? (isDetail.booleanValue() ? " and t.FisLeaf = 1 " : " and t.FisLeaf = 0") : "") + (filter ? " and o.FUserId = ? and o.FType = 10 " : "") + " order by t.FLongNumber");
        Object[] sqlParams = null;
        sqlParams = filter ? (isVirtualFilter ? new Object[]{bgOrgUnit.getViewID(), bgOrgUnit.getLongNumber() + "!%", bgOrgUnit.isIsVirtual(), userId.toString()} : new Object[]{bgOrgUnit.getViewID(), bgOrgUnit.getLongNumber() + "!%", userId.toString()}) : (isVirtualFilter ? new Object[]{bgOrgUnit.getViewID(), bgOrgUnit.getLongNumber() + "!%", bgOrgUnit.isIsVirtual()} : new Object[]{bgOrgUnit.getViewID(), bgOrgUnit.getLongNumber() + "!%"});
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                orgUnit.setIsLeaf(rst.getBoolean("FIsLeaf"));
                orgUnit.setViewID(bgOrgUnit.getViewID());
                orgUnit.setIsVirtual(rst.getBoolean("FIsVirtual"));
                if (rst.getString("FParentId") != null) {
                    orgUnit.setParent(new BgOrgUnitInfo());
                    orgUnit.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                }
                colls.add(orgUnit);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return colls;
    }

    public static List<BgOrgUnitInfo> getParentBgOrgUnit(Context ctx, Connection conn, BOSUuid bgOrgViewId, BgOrgUnitInfo bgOrgUnit) throws BOSException, EASBizException {
        List<BgOrgUnitInfo> colls;
        block7: {
            colls = new ArrayList<BgOrgUnitInfo>();
            if (conn == null || bgOrgUnit == null) {
                return colls;
            }
            String[] pOrgUnitNums = bgOrgUnit.getLongNumber().split("!");
            if (pOrgUnitNums == null || pOrgUnitNums.length <= 1) break block7;
            ArrayList<BOSUuid> pOrgUnitIds = new ArrayList<BOSUuid>();
            String query = "select FOrgUnitID from T_MBG_BgOrgUnit where FVIewId = ? AND FNumber IN (";
            int in = pOrgUnitNums.length - 1;
            for (int i = 0; i < in; ++i) {
                query = query + "'" + pOrgUnitNums[i] + "',";
            }
            query = query.substring(0, query.length() - 1) + ")";
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query, (Object[])new Object[]{bgOrgUnit.getViewID()});
                while (rst.next()) {
                    pOrgUnitIds.add(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            colls = MbgDataHelper.getBgOrgUnitsByUuid(ctx, conn, bgOrgViewId, pOrgUnitIds);
        }
        return colls;
    }

    public static List<String> getBgOrgUnitIds(IObjectCollection colls) throws BOSException, EASBizException {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (colls == null || colls.isEmpty()) {
            return orgUnitIds;
        }
        IObjectValue obj = null;
        BgOrgUnitInfo bgOrgUnit = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            obj = colls.getObject(i);
            if (obj instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)obj;
                orgUnitIds.add(bgOrgUnit.getOrgUnitID());
                continue;
            }
            orgUnitIds.add(obj.getString(obj.getPKField()));
        }
        return orgUnitIds;
    }

    public static List<String> getBgOrgUnitIds(Collection colls) throws BOSException, EASBizException {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (colls == null || colls.isEmpty()) {
            return orgUnitIds;
        }
        IObjectValue ov = null;
        BgOrgUnitInfo bgOrgUnit = null;
        for (Object obj : colls) {
            if (!(obj instanceof IObjectValue)) continue;
            ov = (IObjectValue)obj;
            if (obj instanceof BgOrgUnitInfo) {
                bgOrgUnit = (BgOrgUnitInfo)obj;
                orgUnitIds.add(bgOrgUnit.getOrgUnitID());
                continue;
            }
            orgUnitIds.add(ov.getString(ov.getPKField()));
        }
        return orgUnitIds;
    }

    public static Map<String, Integer> getBgPeriodType(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Integer> bgPeriodTypeMap = new HashMap<String, Integer>();
        if (ctx == null) {
            return bgPeriodTypeMap;
        }
        BgPeriodTypeInfo bgPeriodType = null;
        BgPeriodTypeCollection colls = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("fiscalYear");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        colls = BgPeriodTypeFactory.getLocalInstance((Context)ctx).getBgPeriodTypeCollection(view);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            bgPeriodType = colls.get(i);
            if (bgPeriodType.getFiscalYear() == null) continue;
            bgPeriodTypeMap.put(bgPeriodType.getNumber(), bgPeriodType.getFiscalYear().getValue());
        }
        return bgPeriodTypeMap;
    }

    public static Map<String, Integer> getBgPeriodType(Connection conn) throws EASBizException {
        HashMap<String, Integer> bgPeriodType = new HashMap<String, Integer>();
        if (conn == null) {
            return bgPeriodType;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber, FiscalYear from T_MBG_BgPeriodType");
            while (rst.next()) {
                if (rst.getInt("FiscalYear") <= 0) continue;
                bgPeriodType.put(rst.getString("FNumber"), rst.getInt("FiscalYear"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return bgPeriodType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getBgPeriodMap(Connection conn, Collection<String> bgPeriodNums) throws EASBizException {
        HashMap<String, String> bgPeriodMap = new HashMap<String, String>();
        if (conn == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        ArrayList<String> bgPeriodList = new ArrayList<String>(bgPeriodNums);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = bgPeriodList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        String bgPeriodId = null;
        String bgPeriodNum = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FBgPeriodID, FNumber from T_MBG_BgPeriodDisp where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgPeriodId = rst.getString(1);
                        bgPeriodNum = rst.getString(2);
                        bgPeriodMap.put(bgPeriodNum, bgPeriodId);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    public static Map<String, BgPeriodInfo> getBgPeriodInfoMap(Connection conn, List<String> bgPeriodNums) throws EASBizException {
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (conn == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        _bgPeriodSet.addAll(bgPeriodNums);
        ArrayList<String> _bgPeriodNums = new ArrayList<String>();
        _bgPeriodNums.addAll(_bgPeriodSet);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = _bgPeriodNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FBgPeriodID, FNumber, FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        BgPeriodInfo bgPeriodInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgPeriodNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                    bgPeriodInfo.setNumber(rst.getString("FNumber"));
                    bgPeriodInfo.setBeginDate((Date)rst.getDate("FBeginDate"));
                    bgPeriodInfo.setEndDate((Date)rst.getDate("FEndDate"));
                    bgPeriodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getBgElementMap(Connection conn, Collection<String> bgElementNums) throws EASBizException {
        HashMap<String, String> bgElementMap = new HashMap<String, String>();
        if (conn == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        ArrayList<String> bgElementList = new ArrayList<String>(bgElementNums);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = bgElementList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        String bgElementId = null;
        String bgElementNum = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_MBg_BgElement where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgElementId = rst.getString(1);
                        bgElementNum = rst.getString(2);
                        bgElementMap.put(bgElementNum, bgElementId);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgElementInfo> getBgElementMap(Connection conn, Locale locale, Collection<String> bgElementNums) throws EASBizException {
        HashMap<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        if (conn == null || locale == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        ArrayList<String> bgElementList = new ArrayList<String>(bgElementNums);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = bgElementList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FNumber, FName_" + locale + " AS FName from T_MBg_BgElement where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        BgElementInfo bgElement = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgElement = new BgElementInfo();
                        bgElement.setId(BOSUuid.read((String)rst.getString("FID")));
                        bgElement.setNumber(rst.getString("FNumber"));
                        bgElement.setName(rst.getString("FName"));
                        bgElementMap.put(bgElement.getNumber(), bgElement);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getCurrencyMap(Connection conn, Collection<String> currencyNums) throws EASBizException {
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        if (conn == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        ArrayList<String> currencyList = new ArrayList<String>(currencyNums);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = currencyList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        String currencyId = null;
        String currencyNum = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x, (String)currencyList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        currencyId = rst.getString(1);
                        currencyNum = rst.getString(2);
                        currencyMap.put(currencyNum, currencyId);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CurrencyInfo> getCurrencyMap(Connection conn, Locale locale, List<String> currencyNums) throws EASBizException {
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (conn == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        ArrayList<String> currencyList = new ArrayList<String>(currencyNums);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = currencyList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FNumber, FName_" + locale + " AS FName from T_BD_Currency where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        CurrencyInfo currencyInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x, (String)currencyList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        currencyInfo = new CurrencyInfo();
                        currencyInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                        currencyInfo.setNumber(rst.getString("FNumber"));
                        currencyInfo.setName(rst.getString("FName"));
                        currencyMap.put(currencyInfo.getNumber(), currencyInfo);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    public static Map<String, BgScenarioInfo> getBgScenarioMap(Connection conn, Locale locale) throws SQLException {
        return BgScenarioHelper.getScenariooObjMap((Connection)conn, (Locale)locale);
    }

    public static Map<String, BgVersionInfo> getBgVersionMap(Connection conn, Locale locale) throws SQLException {
        return BgVersionHelper.getVersionObjMap((Connection)conn, (Locale)locale);
    }

    public static Map<String, IMember> getBgVersionMember(Connection conn, Locale locale) throws SQLException {
        HashMap<String, IMember> versionData = new HashMap<String, IMember>();
        Map<String, BgVersionInfo> versionMap = MbgDataHelper.getBgVersionMap(conn, locale);
        Member member = null;
        BgVersionInfo version2 = null;
        for (BgVersionInfo version2 : versionMap.values()) {
            member = new Member();
            member.setName(version2.getName());
            member.setNumber(version2.getNumber());
            member.setLongNumber(version2.getLongNumber());
            member.setLeaf(version2.isIsLeaf());
            versionData.put(member.getNumber(), member);
        }
        return versionData;
    }

    public static BgVersionInfo getBgVersionByNumber(Connection conn, Locale locale, String versionNum) throws EASBizException {
        BgVersionInfo version;
        IRowSet rst;
        block6: {
            if (conn == null || locale == null || StringUtils.isEmpty((String)versionNum)) {
                return null;
            }
            rst = null;
            version = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FID, t.FNumber, t.FName_" + locale + " AS FName, t.FLongNumber, t.FVersionId, t.FParentId, t.FIsLeaf, p.FNumber AS PNumber, p.FVersionId AS FPVersionId from T_MBG_BgVersion t left join T_MBG_BgVersion p on t.FParentId = p.FID where t.FNumber = ?"), (Object[])new Object[]{versionNum});
                if (!rst.next()) break block6;
                version = new BgVersionInfo();
                version.setId(BOSUuid.read((String)rst.getString("FID")));
                version.setNumber(rst.getString("FNumber"));
                version.setName(rst.getString("FName"));
                version.setLongNumber(rst.getString("FLongNumber"));
                version.setVersionId(rst.getInt("FVersionId"));
                version.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (!StringUtils.isEmpty((String)rst.getString("FParentId"))) {
                    version.setParent(new BgVersionInfo());
                    version.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                    version.getParent().setNumber(rst.getString("PNumber"));
                    version.getParent().setVersionId(rst.getInt("FPVersionId"));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return version;
    }

    public static BgActualRecordInfo getBgActualRecord(Connection conn, Locale locale, BOSUuid bgActualRecordId) throws Exception {
        return MbgDataHelper.getBgActualRecord(conn, locale, bgActualRecordId, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgActualRecordInfo getBgActualRecord(Connection conn, Locale locale, BOSUuid bgActualRecordId, boolean hasData) throws Exception {
        IRowSet rst;
        BgActualRecordInfo bgActualRecord;
        block7: {
            bgActualRecord = null;
            if (conn == null) return bgActualRecord;
            if (bgActualRecordId == null) {
                return bgActualRecord;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FName, FNumber, FBgFormID, FBgPeriodID, FState " + (hasData ? ", FData, FDimensionData, FDimensionStyle " : "") + " from T_MBG_BgActualRecord where FID = ?");
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgActualRecordId.toString()});
                if (!rst.next()) break block7;
                bgActualRecord = new BgActualRecordInfo();
                bgActualRecord.setId(bgActualRecordId);
                bgActualRecord.setName(rst.getString(2));
                bgActualRecord.setNumber(rst.getString(3));
                bgActualRecord.setState(BgActualRecordStateEnum.getEnum(rst.getInt("FState")));
                bgActualRecord.setBgForm(new BgFormInfo());
                bgActualRecord.getBgForm().setId(BOSUuid.read((String)rst.getString("FBgFormID")));
                bgActualRecord.setBgPeriod(new BgPeriodInfo());
                bgActualRecord.getBgPeriod().setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                if (hasData) {
                    bgActualRecord.setData(BgDBUtils.getBytes((ResultSet)rst, (String)"FData"));
                    bgActualRecord.setDimensionData(BgDBUtils.getBytes((ResultSet)rst, (String)"FDimensionData"));
                    bgActualRecord.setDimensionStyle(BgDBUtils.getBytes((ResultSet)rst, (String)"FDimensionStyle"));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgActualRecord;
    }

    public static BgSchemeInfo getBgSchemeInfo(BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("bgSchemeType.id");
        sic.add("bgSchemeType.number");
        sic.add("bgSchemeType.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("isFormal");
        sic.add("bgDimSettings.*");
        sic.add("bgDimSettings.members.*");
        return BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), sic);
    }

    public static BgSchemeInfo getBgSchemeInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return null;
        }
        Connection conn = null;
        BgSchemeInfo schemeInfo = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            schemeInfo = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), bgSchemeId);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return schemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgSchemeInfo getBgSchemeInfo(Connection conn, Locale locale, BOSUuid bgSchemeId) throws EASBizException {
        IRowSet rst;
        BgSchemeInfo bgScheme;
        block11: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgScheme = null;
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            HashMap<String, BgDimSettingsInfo> settingMap = new HashMap<String, BgDimSettingsInfo>();
            rst = null;
            IRowSet _rst = null;
            String _tmpStr = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + locale + " AS FName, FOrgUnitID, FIsFormal, FDateFrom, FDateTo, FPeriod, FRefCube, FIsCalcMbgBiz, FUseAccInt From T_MBg_BgScheme where FID = ?");
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                if (!rst.next()) break block11;
                bgScheme = new BgSchemeInfo();
                bgScheme.setId(BOSUuid.read((String)rst.getString("FID")));
                bgScheme.setNumber(rst.getString("FNumber"));
                bgScheme.setName(rst.getString("FName"));
                _tmpStr = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmpStr)) {
                    bgScheme.setOrgUnit(new FullOrgUnitInfo());
                    bgScheme.getOrgUnit().setId(BOSUuid.read((String)_tmpStr));
                }
                bgScheme.setIsFormal(rst.getBoolean("FIsFormal"));
                bgScheme.setDateFrom(rst.getDate("FDateFrom"));
                bgScheme.setDateTo(rst.getDate("FDateTo"));
                bgScheme.setRefCube(rst.getString("FRefCube"));
                bgScheme.setPeriod(BgPeriodEnum.getEnum((int)rst.getInt("FPeriod")));
                bgScheme.setIsCalcMbgBiz(rst.getBoolean("FIsCalcMbgBiz"));
                bgScheme.setUseAccInt(rst.getInt("FUseAccInt"));
                sql = new StringBuffer();
                sql.append("select t.FID, t.FDimNumber, t.FAudit, m.FID AS FMID, m.FMemberID, m.FNumber, m.FType from T_MBG_BgDimSettings t join T_MBG_BgDimSettingsMember m on t.FID = m.FBgDimSettingsID where FBgSchemeID = ?");
                try {
                    _rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                    while (_rst.next()) {
                        _tmpStr = _rst.getString("FID");
                        if (settingMap.containsKey(_tmpStr)) {
                            setting = (BgDimSettingsInfo)settingMap.get(_tmpStr);
                        } else {
                            setting = new BgDimSettingsInfo();
                            setting.setId(BOSUuid.read((String)_tmpStr));
                            setting.setDimNumber(_rst.getString("FDimNumber"));
                            setting.setAudit(_rst.getBoolean("FAudit"));
                            bgScheme.getBgDimSettings().add(setting);
                            settingMap.put(_tmpStr, setting);
                        }
                        member = new BgDimSettingsMemberInfo();
                        member.setId(BOSUuid.read((String)_rst.getString("FMID")));
                        member.setMemberID(BOSUuid.read((String)_rst.getString("FMemberID")));
                        member.setNumber(_rst.getString("FNumber"));
                        member.setType(MemberTypeEnum.getEnum(_rst.getInt("FType")));
                        setting.getMembers().add(member);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(_rst);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)_rst);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgScheme;
    }

    public static BgSchemeInfo getBgSchemeByNumber(Connection conn, Locale locale, String number) throws EASBizException {
        if (conn == null || locale == null || number == null) {
            return null;
        }
        BgSchemeInfo bgScheme = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgScheme where FNumber = ?", (Object[])new Object[]{number});
            if (rst.next()) {
                bgScheme = MbgDataHelper.getBgSchemeInfo(conn, locale, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgScheme;
    }

    public static BgSchemeInfo getBgSchemeByForm(Connection conn, Locale locale, BOSUuid billId) throws EASBizException {
        if (conn == null || locale == null || billId == null) {
            return null;
        }
        BgSchemeInfo bgScheme = null;
        StringBuffer sql = new StringBuffer();
        IRowSet rst = null;
        String bosType = billId.getType().toString();
        if ("3BA5F027".equals(bosType)) {
            sql.append("select FBgSchemeId from T_MBG_BgForm where FID = ?");
        } else if ("655ADD42".equals(bosType)) {
            sql.append("select FBgSchemeId from T_MBG_BgCslForm where FID = ?");
        } else if ("AD34C4CD".equals(bosType)) {
            sql.append("select FBgSchemeId from T_MBG_BgCslAdjForm where FID = ?");
        } else if ("9E7BD5E2".equals(bosType)) {
            sql.append("select FBgSchemeId from T_MBG_MbgWorkPaper where FID = ?");
        } else if ("210CFD59".equals(bosType)) {
            sql.append("select FBgScheme from T_MBG_BgAdjustBill where FID = ?");
        }
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{billId.toString()});
            if (rst.next()) {
                bgScheme = MbgDataHelper.getBgSchemeInfo(conn, locale, BOSUuid.read((String)rst.getString(1)));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgScheme;
    }

    public static BgSchemeInfo getBgSchemeByCtrlSchema(Connection conn, Locale locale, BOSUuid ctrlSchemaId) throws EASBizException {
        if (conn == null || locale == null || ctrlSchemaId == null) {
            return null;
        }
        BgSchemeInfo bgScheme = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FSchemeId from T_MBG_BgControlSetScheme where FID = ?", (Object[])new Object[]{ctrlSchemaId.toString()});
            if (rst.next()) {
                bgScheme = MbgDataHelper.getBgSchemeInfo(conn, locale, BOSUuid.read((String)rst.getString("FSchemeId")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgScheme;
    }

    public static BgFormInfo getBgFormInfo(Connection conn, Locale locale, BOSUuid bgFormId) throws BOSException, EASBizException {
        return MbgDataHelper.getBgFormInfo(conn, locale, bgFormId, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Connection conn, Locale locale, BOSUuid bgFormId, boolean loadData) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgFormInfo bgForm;
        block20: {
            if (conn == null) return null;
            if (locale == null) return null;
            if (bgFormId == null) {
                return null;
            }
            String tmpStr = null;
            bgForm = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID, t.FNumber, t.FName, t.FControlUnitID, t.FOrgUnitId, t.FAuditOrgUnitId, t.FProcessType,t.FisRolled, cc.FNumber AS FUnitNumber, cc.FLongNumber AS FUnitLongNumber, cc.FName_" + locale + " AS FUnitName, t.FCompanyID, t.FBgSchemeId, t.FBgTemplateId, te.FNumber AS FTENumber, te.FName AS FIEName, te.FFormType, te.FOrgUnitId FTEOrgUnitId, te.FIsReadonly FIsReadonly, te.FRootId AS FTemplateRootID, te.FIsOnlyDeal AS FIsOnlyDeal, t.FBgPeriodID, p.FNumber AS FPNumber, p.FName_" + locale + " AS FPName, p.FPeriodType, t.FCurrencyID, c.FNumber AS FCNumber, c.FName_" + locale + " AS FCName, t.FMeasureUnitID, t.FBgVersionID, t.FAdjustID, t.FState, t.FDataSource, " + (loadData ? "t.FData, " : "") + "t.FVersionNo, v.FNumber AS FVNumber, v.FName_" + locale + " AS FVName, v.FVersionId, si.FDimensionNumber, si.FDimensionName, si.FMemberName, si.FMemberDisplayName,  cc1.FNumber AS FAuditOrgUnitNumber, cc1.FLongNumber AS FAuditOrgUnitLongNumber, cc1.FName_" + locale + " AS FAuditOrgUnitName,  tt.FID AS FTTID, tt.FNumber AS FTTNumber, tt.FName_" + locale + " AS FTTName from T_MBG_BgForm t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID left join T_MBg_BgTemplate te on t.FBgTemplateId = te.FID left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_BD_Currency c on t.FCurrencyID = c.FID left join T_MBG_BgSpecialitems si on t.FID = si.FBgFormId left join T_ORG_CostCenter cc1 on t.FauditOrgUnitId = cc1.FID left join T_MBG_BgType tt on tt.FId = te.FBgTypeID where t.FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block20;
                bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                bgForm.setNumber(rst.getString("FNumber"));
                bgForm.setName(rst.getString("FName"));
                bgForm.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgForm.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                bgForm.setVersionNo(rst.getBigDecimal("FVersionNo"));
                bgForm.setProcessType(BgProcessEnum.getEnum(rst.getInt("FProcessType")));
                bgForm.setIsRolled(rst.getBoolean("FisRolled"));
                tmpStr = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)tmpStr)) {
                    bgForm.setCU(new CtrlUnitInfo());
                    bgForm.getCU().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgUnitID")))) {
                    bgForm.setOrgUnit(new FullOrgUnitInfo());
                    bgForm.getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getOrgUnit().setNumber(rst.getString("FUnitNumber"));
                    bgForm.getOrgUnit().setLongNumber(rst.getString("FUnitLongNumber"));
                    bgForm.getOrgUnit().setName(rst.getString("FUnitName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCompanyID")))) {
                    bgForm.setCompany(new CompanyOrgUnitInfo());
                    bgForm.getCompany().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgSchemeID")))) {
                    bgForm.setBgScheme(new BgSchemeInfo());
                    bgForm.getBgScheme().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgTemplateId")))) {
                    bgForm.setBgTemplate(new BgTemplateInfo());
                    bgForm.getBgTemplate().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getBgTemplate().setNumber(rst.getString("FTENumber"));
                    bgForm.getBgTemplate().setName(rst.getString("FIEName"));
                    bgForm.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
                    bgForm.getBgTemplate().setOrgUnit(new FullOrgUnitInfo());
                    bgForm.getBgTemplate().getOrgUnit().setId(BOSUuid.read((String)rst.getString("FTEOrgUnitId")));
                    bgForm.getBgTemplate().setReadonly(rst.getBoolean("FIsReadonly"));
                    bgForm.getBgTemplate().setRoot(new BgTemplateInfo());
                    bgForm.getBgTemplate().getRoot().setId(BOSUuid.read((String)rst.getString("FTemplateRootID")));
                    bgForm.getBgTemplate().setOnlyDealBgForm(rst.getBoolean("FIsOnlyDeal"));
                    tmpStr = rst.getString("FTTID");
                    if (!StringUtils.isEmpty((String)tmpStr)) {
                        bgForm.getBgTemplate().setBgType(new BgTypeInfo());
                        bgForm.getBgTemplate().getBgType().setId(BOSUuid.read((String)rst.getString("FTTID")));
                        bgForm.getBgTemplate().getBgType().setNumber(rst.getString("FTTNumber"));
                        bgForm.getBgTemplate().getBgType().setName(rst.getString("FTTName"));
                    }
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgPeriodID")))) {
                    bgForm.setBgPeriod(new BgPeriodInfo());
                    bgForm.getBgPeriod().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getBgPeriod().setNumber(rst.getString("FPNumber"));
                    bgForm.getBgPeriod().setName(rst.getString("FPName"));
                    bgForm.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCurrencyID")))) {
                    bgForm.setCurrency(new CurrencyInfo());
                    bgForm.getCurrency().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getCurrency().setNumber(rst.getString("FCNumber"));
                    bgForm.getCurrency().setName(rst.getString("FCName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FMeasureUnitID")))) {
                    bgForm.setMeasureUnit(new MeasureUnitInfo());
                    bgForm.getMeasureUnit().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgVersionID")))) {
                    bgForm.setBgVersion(new BgVersionInfo());
                    bgForm.getBgVersion().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getBgVersion().setNumber(rst.getString("FVNumber"));
                    bgForm.getBgVersion().setName(rst.getString("FVName"));
                    bgForm.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FAdjustID")))) {
                    bgForm.setAdjust(new BgFormInfo());
                    bgForm.getAdjust().setId(BOSUuid.read((String)tmpStr));
                }
                if ((tmpStr = rst.getString("FDimensionNumber")) != null) {
                    BgSpecialItemsInfo specialItem = new BgSpecialItemsInfo();
                    specialItem.setDimensionNumber(tmpStr);
                    specialItem.setDimensionName(rst.getString("FDimensionName"));
                    specialItem.setMemberName(rst.getString("FMemberName"));
                    specialItem.setMemberDisplayName(rst.getString("FMemberDisplayName"));
                    bgForm.getBgSpecialItems().add(specialItem);
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FAuditOrgUnitId")))) {
                    bgForm.setAuditOrgUnit(new FullOrgUnitInfo());
                    bgForm.getAuditOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    bgForm.getAuditOrgUnit().setNumber(rst.getString("FAuditOrgUnitNumber"));
                    bgForm.getAuditOrgUnit().setLongNumber(rst.getString("FAuditOrgUnitLongNumber"));
                    bgForm.getAuditOrgUnit().setName(rst.getString("FAuditOrgUnitName"));
                }
                if (loadData) {
                    bgForm.setData(BgDBUtils.getBytes((ResultSet)rst, (String)"FData"));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgForm;
    }

    public static List<BgFormInfo> getBgFormInfo(Context ctx, Connection conn, Collection<String> billIds) throws Exception {
        ArrayList<BgFormInfo> bgForms = new ArrayList<BgFormInfo>();
        if (conn == null || ctx == null || billIds == null || billIds.isEmpty()) {
            return bgForms;
        }
        String tmpTable = null;
        String tmpStr = null;
        BgFormInfo bgForm = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        IRowSet rst = null;
        try {
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            if (tmpTable != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), billIds);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FID, t.FNumber, t.FName, t.FControlUnitID, t.FOrgUnitId, t.FProcessType, cc.FNumber AS FUnitNumber, cc.FLongNumber AS FUnitLongNumber, cc.FName_" + ctx.getLocale() + " AS FUnitName, t.FCompanyID, t.FBgSchemeId, t.FBgTemplateId, te.FNumber AS FTENumber, te.FFormType, t.FBgPeriodID, p.FNumber AS FPNumber, p.FName_" + ctx.getLocale() + " AS FPName, p.FPeriodType, t.FCurrencyID, c.FNumber AS FCNumber, c.FName_" + ctx.getLocale() + " AS FCName, t.FMeasureUnitID, t.FBgVersionID, t.FAdjustID, t.FState, t.FDataSource, t.FVersionNo, v.FNumber AS FVNumber, v.FName_" + ctx.getLocale() + " AS FVName, v.FVersionId, v.FIsRollVersion, si.FDimensionNumber, si.FDimensionName, si.FMemberName, si.FMemberDisplayName, s.FNumber AS FSNumber, t.FBgRollRuleId, t.FBgRollPeriodId from T_MBG_BgForm t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID left join T_MBg_BgTemplate te on t.FBgTemplateId = te.FID left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_BD_Currency c on t.FCurrencyID = c.FID left join T_MBG_BgSpecialitems si on t.FID = si.FBgFormId where exists (select FID from " + tmpTable + " where FID = t.FID)"));
                while (rst.next()) {
                    bgForm = new BgFormInfo();
                    bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgForm.setNumber(rst.getString("FNumber"));
                    bgForm.setName(rst.getString("FName"));
                    bgForm.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                    bgForm.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                    bgForm.setVersionNo(rst.getBigDecimal("FVersionNo"));
                    bgForm.setProcessType(BgProcessEnum.getEnum(rst.getInt("FProcessType")));
                    tmpStr = rst.getString("FBgRollRuleId");
                    if (!StringUtils.isEmpty((String)tmpStr)) {
                        bgForm.setBgRollRule(new BgRollRuleInfo());
                        bgForm.getBgRollRule().setId(BOSUuid.read((String)tmpStr));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FControlUnitID")))) {
                        bgForm.setCU(new CtrlUnitInfo());
                        bgForm.getCU().setId(BOSUuid.read((String)tmpStr));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgUnitID")))) {
                        bgForm.setOrgUnit(new FullOrgUnitInfo());
                        bgForm.getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                        bgForm.getOrgUnit().setNumber(rst.getString("FUnitNumber"));
                        bgForm.getOrgUnit().setLongNumber(rst.getString("FUnitLongNumber"));
                        bgForm.getOrgUnit().setName(rst.getString("FUnitName"));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCompanyID")))) {
                        bgForm.setCompany(new CompanyOrgUnitInfo());
                        bgForm.getCompany().setId(BOSUuid.read((String)tmpStr));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgSchemeID")))) {
                        bgForm.setBgScheme(new BgSchemeInfo());
                        bgForm.getBgScheme().setId(BOSUuid.read((String)tmpStr));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FSNumber")))) {
                        bgForm.getBgScheme().setNumber(tmpStr);
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgTemplateId")))) {
                        bgForm.setBgTemplate(new BgTemplateInfo());
                        bgForm.getBgTemplate().setId(BOSUuid.read((String)tmpStr));
                        bgForm.getBgTemplate().setNumber(rst.getString("FTENumber"));
                        bgForm.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgPeriodID")))) {
                        bgForm.setBgPeriod(new BgPeriodInfo());
                        bgForm.getBgPeriod().setId(BOSUuid.read((String)tmpStr));
                        bgForm.getBgPeriod().setNumber(rst.getString("FPNumber"));
                        bgForm.getBgPeriod().setName(rst.getString("FPName"));
                        bgForm.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCurrencyID")))) {
                        bgForm.setCurrency(new CurrencyInfo());
                        bgForm.getCurrency().setId(BOSUuid.read((String)tmpStr));
                        bgForm.getCurrency().setNumber(rst.getString("FCNumber"));
                        bgForm.getCurrency().setName(rst.getString("FCName"));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FMeasureUnitID")))) {
                        bgForm.setMeasureUnit(new MeasureUnitInfo());
                        bgForm.getMeasureUnit().setId(BOSUuid.read((String)tmpStr));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgVersionID")))) {
                        bgForm.setBgVersion(new BgVersionInfo());
                        bgForm.getBgVersion().setId(BOSUuid.read((String)tmpStr));
                        bgForm.getBgVersion().setNumber(rst.getString("FVNumber"));
                        bgForm.getBgVersion().setName(rst.getString("FVName"));
                        bgForm.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                        bgForm.getBgVersion().setIsRollVersion(rst.getBoolean("FIsRollVersion"));
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FAdjustID")))) {
                        bgForm.setAdjust(new BgFormInfo());
                        bgForm.getAdjust().setId(BOSUuid.read((String)tmpStr));
                    }
                    if ((tmpStr = rst.getString("FDimensionNumber")) != null) {
                        BgSpecialItemsInfo specialItem = new BgSpecialItemsInfo();
                        specialItem.setDimensionNumber(tmpStr);
                        specialItem.setDimensionName(rst.getString("FDimensionName"));
                        specialItem.setMemberName(rst.getString("FMemberName"));
                        specialItem.setMemberDisplayName(rst.getString("FMemberDisplayName"));
                        bgForm.getBgSpecialItems().add(specialItem);
                    }
                    if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgRollPeriodId")))) {
                        bgForm.setBgRollPeriod(new BgPeriodInfo());
                        bgForm.getBgRollPeriod().setId(BOSUuid.read((String)tmpStr));
                    }
                    bgForms.add(bgForm);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        return bgForms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IMember> getBgAccountFromNumber(Context ctx, String viewId, Collection<String> numbers) throws BOSException, EASBizException {
        Map<String, IMember> memberMap = new HashMap<String, IMember>();
        if (ctx == null || StringUtils.isEmpty((String)viewId) || numbers == null || numbers.isEmpty()) {
            return memberMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            memberMap = MbgDataHelper.getBgAccountFromNumber(conn, ctx.getLocale(), viewId, numbers);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return memberMap;
    }

    public static Map<String, IMember> getBgAccountFromNumber(Connection conn, Locale locale, String viewId, Collection<String> numbers) throws EASBizException {
        HashMap<String, IMember> memberMap = new HashMap<String, IMember>();
        if (conn == null || locale == null || StringUtils.isEmpty((String)viewId) || numbers == null || numbers.isEmpty()) {
            return memberMap;
        }
        Member member = null;
        ArrayList<String> firstParams = new ArrayList<String>();
        firstParams.add(viewId);
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(numbers);
        List results = null;
        Object[] rst = null;
        try {
            results = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FNumber, FName_" + locale + " AS FName, FLongNumber from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), firstParams, sqlParams);
            int in = results.size();
            for (int i = 0; i < in; ++i) {
                rst = (Object[])results.get(i);
                member = new Member();
                member.setNumber((String)rst[0]);
                member.setName((String)rst[1]);
                member.setLongNumber((String)rst[2]);
                memberMap.put(member.getNumber(), member);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return memberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IMember> getMbgMemberFromNumber(Context ctx, String viewId, Collection<String> numbers) throws BOSException, EASBizException {
        Map<String, IMember> memberMap = new HashMap<String, IMember>();
        if (ctx == null || StringUtils.isEmpty((String)viewId) || numbers == null || numbers.isEmpty()) {
            return memberMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            memberMap = MbgDataHelper.getMbgMemberFromNumber(conn, ctx.getLocale(), viewId, numbers);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return memberMap;
    }

    public static Map<String, IMember> getMbgMemberFromNumber(Connection conn, Locale locale, String viewId, Collection<String> numbers) throws EASBizException {
        HashMap<String, IMember> memberMap = new HashMap<String, IMember>();
        if (conn == null || locale == null || StringUtils.isEmpty((String)viewId) || numbers == null || numbers.isEmpty()) {
            return memberMap;
        }
        Member member = null;
        ArrayList<String> firstParams = new ArrayList<String>();
        firstParams.add(viewId);
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.addAll(numbers);
        List results = null;
        Object[] rst = null;
        try {
            results = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FNumber, FName_" + locale + " AS FName, FLongNumber from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), firstParams, sqlParams);
            int in = results.size();
            for (int i = 0; i < in; ++i) {
                rst = (Object[])results.get(i);
                member = new Member();
                member.setNumber((String)rst[0]);
                member.setName((String)rst[1]);
                member.setLongNumber((String)rst[2]);
                memberMap.put(member.getNumber(), member);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return memberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgAdjustBillInfo> getBgAdjustBill(Context ctx, List<String> billIds) throws BOSException, EASBizException {
        List<BgAdjustBillInfo> bgAdjusts = new ArrayList<BgAdjustBillInfo>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return bgAdjusts;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgAdjusts = MbgDataHelper.getBgAdjustBill(conn, ctx.getLocale(), billIds);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgAdjusts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgAdjustBillInfo> getBgAdjustBillBase(Connection conn, Locale locale, List<String> billIds) throws EASBizException {
        ArrayList<BgAdjustBillInfo> bgAdjusts = new ArrayList<BgAdjustBillInfo>();
        if (conn == null || locale == null || billIds == null || billIds.isEmpty()) {
            return bgAdjusts;
        }
        int size = billIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        BgAdjustBillInfo bgAdjustBill = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FBgScheme, s.FNumber AS FSchNumber, s.FRefCube, t.FCurrency, c.FNumber AS FCNumber, t.FElement, ele.FNumber AS FENumber, t.FPeriodYear, t.FType, t.FState, t.FProcessType, t.FBgScenarioID, sc.FNumber AS FSCNumber, sc.FScenarioId, t.FBgVersionID, v.FNumber AS FVNumber, v.FVersionId, t.FBgPeriodTypeID, t.FSourceType from T_MBG_BgAdjustBill t left join T_MBG_BgScheme s on t.FBgScheme = s.FID left join T_MBG_BgScenario sc on t.FBgScenarioID = sc.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_MBG_BgElement ele on t.FElement = ele.FID left join T_BD_Currency c on t.FCurrency = c.FID where t.FID IN (" + BgDBUtils.getSqlParam((int)50) + ")");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setObject(x, billIds.get(pos));
                    } else {
                        pstmt.setObject(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgAdjustBill = new BgAdjustBillInfo();
                        bgAdjustBill.setId(BOSUuid.read((String)rst.getString("FID")));
                        bgAdjustBill.setNumber(rst.getString("FNumber"));
                        bgAdjustBill.setType(BgAdjustBillTypeEnum.getEnum(rst.getInt("FType")));
                        bgAdjustBill.setState(BgAdjustBillStateEnum.getEnum(rst.getInt("FState")));
                        bgAdjustBill.setSourceType(RptSrcTypeEnum.getEnum(rst.getInt("FSourceType")));
                        bgAdjustBill.setBgScheme(new BgSchemeInfo());
                        bgAdjustBill.getBgScheme().setId(BOSUuid.read((String)rst.getString("FBgScheme")));
                        bgAdjustBill.getBgScheme().setNumber(rst.getString("FSchNumber"));
                        bgAdjustBill.getBgScheme().setRefCube(rst.getString("FRefCube"));
                        bgAdjustBill.setCurrency(new CurrencyInfo());
                        bgAdjustBill.getCurrency().setId(BOSUuid.read((String)rst.getString("FCurrency")));
                        bgAdjustBill.getCurrency().setNumber(rst.getString("FCNumber"));
                        if (!StringUtils.isEmpty((String)rst.getString("FElement"))) {
                            bgAdjustBill.setElement(new BgElementInfo());
                            bgAdjustBill.getElement().setId(BOSUuid.read((String)rst.getString("FElement")));
                            bgAdjustBill.getElement().setNumber(rst.getString("FENumber"));
                        }
                        if (!StringUtils.isEmpty((String)rst.getString("FPeriodYear"))) {
                            bgAdjustBill.setPeriodYear(new BgPeriodInfo());
                            bgAdjustBill.getPeriodYear().setId(BOSUuid.read((String)rst.getString("FPeriodYear")));
                        }
                        if (!StringUtils.isEmpty((String)rst.getString("FBgScenarioID"))) {
                            bgAdjustBill.setBgScenario(new BgScenarioInfo());
                            bgAdjustBill.getBgScenario().setId(BOSUuid.read((String)rst.getString("FBgScenarioID")));
                            bgAdjustBill.getBgScenario().setNumber(rst.getString("FSCNumber"));
                            bgAdjustBill.getBgScenario().setScenarioId(rst.getInt("FScenarioId"));
                        }
                        bgAdjustBill.setBgVersion(new BgVersionInfo());
                        bgAdjustBill.getBgVersion().setId(BOSUuid.read((String)rst.getString("FBgVersionID")));
                        bgAdjustBill.getBgVersion().setNumber(rst.getString("FVNumber"));
                        bgAdjustBill.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                        bgAdjustBill.setBgPeriodType(new BgPeriodTypeInfo());
                        bgAdjustBill.getBgPeriodType().setId(BOSUuid.read((String)rst.getString("FBgPeriodTypeID")));
                        bgAdjustBill.setProcessType(BgProcessEnum.getEnum(rst.getInt("FProcessType")));
                        bgAdjusts.add(bgAdjustBill);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, null);
        }
        return bgAdjusts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgAdjustBillInfo> getBgAdjustBill(Connection conn, Locale locale, List<String> billIds) throws EASBizException {
        ArrayList<BgAdjustBillInfo> bgAdjusts = new ArrayList<BgAdjustBillInfo>();
        if (conn == null || locale == null || billIds == null || billIds.isEmpty()) {
            return bgAdjusts;
        }
        int size = billIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        HashMap<String, BgAdjustBillInfo> bgAdjustMap = new HashMap<String, BgAdjustBillInfo>();
        BgAdjustBillInfo bgAdjustBill = null;
        BgAdjustBillEntryInfo entry = null;
        String bgAdjustId = null;
        String bgDataId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FLastUpdateTime, t.FBgScheme, s.FNumber AS FSchNumber, s.FRefCube, t.FCurrency, c.FNumber AS FCNumber, t.FElement, ele.FNumber AS FENumber, t.FPeriodYear, t.FType, t.FState, t.FProcessType, t.FBgScenarioID, sc.FNumber AS FSCNumber, sc.FScenarioId, t.FBgVersionID, v.FNumber AS FVNumber, v.FVersionId, t.FBgPeriodTypeID, t.FSourceType, e.FID AS FEID, e.FSeq, e.FOrgUnit, eu.FNumber AS FEUNumber, e.FPeriod, p.FNumber AS FEPNumber, e.FOldvalue, e.FAdjustValue, e.FBgDataID, e.FIndexMemberNumber, e.FIndexMemberName, e.FindexMemberRef, e.FMemberCombinNunber, e.FMemberCombinName, e.FMemberCombinRef, e.FFormula, e.FBgScenario, bgs.FNumber AS FBGSNumber, bgs.FScenarioId AS FBGSScenarioId, e.FBgElement, bge.FNumber AS FBGENumber from T_MBG_BgAdjustBill t left join T_MBG_BgAdjustBillEntry e on t.FID = e.FBgAdjustBill left join T_MBG_BgOrgUnit eu on e.FOrgUnit = eu.FID left join T_MBG_BgScheme s on t.FBgScheme = s.FID left join T_MBG_BgPeriod p on e.FPeriod = p.FID left join T_MBG_BgScenario sc on t.FBgScenarioID = sc.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_MBG_BgElement ele on t.FElement = ele.FID left join T_BD_Currency c on t.FCurrency = c.FID left join T_MBG_BgElement bge on e.FBgElement = bge.FID left join T_MBG_BgScenario bgs on e.FBgScenario = bgs.FID where t.FID IN (" + BgDBUtils.getSqlParam((int)50) + ")");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setObject(x, billIds.get(pos));
                    } else {
                        pstmt.setObject(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgAdjustId = rst.getString("FID");
                        if (bgAdjustMap.containsKey(bgAdjustId)) {
                            bgAdjustBill = (BgAdjustBillInfo)bgAdjustMap.get(bgAdjustId);
                        } else {
                            bgAdjustBill = new BgAdjustBillInfo();
                            bgAdjustMap.put(bgAdjustId, bgAdjustBill);
                            bgAdjustBill.setId(BOSUuid.read((String)bgAdjustId));
                            bgAdjustBill.setNumber(rst.getString("FNumber"));
                            bgAdjustBill.setLastUpdateTime(rst.getTimestamp("FLastUpdateTime"));
                            bgAdjustBill.setType(BgAdjustBillTypeEnum.getEnum(rst.getInt("FType")));
                            bgAdjustBill.setState(BgAdjustBillStateEnum.getEnum(rst.getInt("FState")));
                            bgAdjustBill.setSourceType(RptSrcTypeEnum.getEnum(rst.getInt("FSourceType")));
                            bgAdjustBill.setProcessType(BgProcessEnum.getEnum(rst.getInt("FProcessType")));
                            bgAdjustBill.setBgScheme(new BgSchemeInfo());
                            bgAdjustBill.getBgScheme().setId(BOSUuid.read((String)rst.getString("FBgScheme")));
                            bgAdjustBill.getBgScheme().setNumber(rst.getString("FSchNumber"));
                            bgAdjustBill.getBgScheme().setRefCube(rst.getString("FRefCube"));
                            bgAdjustBill.setCurrency(new CurrencyInfo());
                            bgAdjustBill.getCurrency().setId(BOSUuid.read((String)rst.getString("FCurrency")));
                            bgAdjustBill.getCurrency().setNumber(rst.getString("FCNumber"));
                            if (!StringUtils.isEmpty((String)rst.getString("FElement"))) {
                                bgAdjustBill.setElement(new BgElementInfo());
                                bgAdjustBill.getElement().setId(BOSUuid.read((String)rst.getString("FElement")));
                                bgAdjustBill.getElement().setNumber(rst.getString("FENumber"));
                            }
                            if (rst.getString("FPeriodYear") != null) {
                                bgAdjustBill.setPeriodYear(new BgPeriodInfo());
                                bgAdjustBill.getPeriodYear().setId(BOSUuid.read((String)rst.getString("FPeriodYear")));
                            }
                            if (!StringUtils.isEmpty((String)rst.getString("FBgScenarioID"))) {
                                bgAdjustBill.setBgScenario(new BgScenarioInfo());
                                bgAdjustBill.getBgScenario().setId(BOSUuid.read((String)rst.getString("FBgScenarioID")));
                                bgAdjustBill.getBgScenario().setNumber(rst.getString("FSCNumber"));
                                bgAdjustBill.getBgScenario().setScenarioId(rst.getInt("FScenarioId"));
                            }
                            bgAdjustBill.setBgVersion(new BgVersionInfo());
                            bgAdjustBill.getBgVersion().setId(BOSUuid.read((String)rst.getString("FBgVersionID")));
                            bgAdjustBill.getBgVersion().setNumber(rst.getString("FVNumber"));
                            bgAdjustBill.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                            bgAdjustBill.setBgPeriodType(new BgPeriodTypeInfo());
                            bgAdjustBill.getBgPeriodType().setId(BOSUuid.read((String)rst.getString("FBgPeriodTypeID")));
                            bgAdjusts.add(bgAdjustBill);
                        }
                        entry = new BgAdjustBillEntryInfo();
                        entry.setId(BOSUuid.read((String)rst.getString("FEID")));
                        entry.setBgAdjustBill(bgAdjustBill);
                        entry.setSeq(rst.getInt("FSeq"));
                        entry.setOrgUnit(new BgOrgUnitInfo());
                        entry.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnit")));
                        entry.getOrgUnit().setNumber(rst.getString("FEUNumber"));
                        entry.setPeriod(new BgPeriodInfo());
                        entry.getPeriod().setId(BOSUuid.read((String)rst.getString("FPeriod")));
                        entry.getPeriod().setNumber(rst.getString("FEPNumber"));
                        entry.setOldValue(rst.getBigDecimal("FOldvalue"));
                        entry.setAdjustValue(rst.getBigDecimal("FAdjustValue"));
                        if (rst.getString("FBgElement") != null) {
                            entry.setBgElement(new BgElementInfo());
                            entry.getBgElement().setId(BOSUuid.read((String)rst.getString("FBgElement")));
                            entry.getBgElement().setNumber(rst.getString("FBGENumber"));
                        }
                        if (rst.getString("FBgScenario") != null) {
                            entry.setBgScenario(new BgScenarioInfo());
                            entry.getBgScenario().setId(BOSUuid.read((String)rst.getString("FBgScenario")));
                            entry.getBgScenario().setNumber(rst.getString("FBGSNumber"));
                            entry.getBgScenario().setScenarioId(rst.getInt("FBGSScenarioId"));
                        }
                        if (!StringUtils.isEmpty((String)(bgDataId = rst.getString("FBgDataID")))) {
                            entry.setBgDataId(BOSUuid.read((String)bgDataId));
                        }
                        entry.setIndexMemberNumber(rst.getString("FIndexMemberNumber"));
                        entry.setIndexMemberName(rst.getString("FIndexMemberName"));
                        entry.setIndexMemberRef(rst.getString("FindexMemberRef"));
                        entry.setMemberCombinNumber(rst.getString("FMemberCombinNunber"));
                        entry.setMemberCombinName(rst.getString("FMemberCombinName"));
                        entry.setMemberCombinRef(rst.getString("FMemberCombinRef"));
                        entry.setFormula(rst.getString("FFormula"));
                        bgAdjustBill.getEntity().add(entry);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, null);
        }
        return bgAdjusts;
    }

    public static List<IDimDataQuery> getBillValue(Context ctx, Connection conn, Collection<String> billIds) throws Exception {
        Method method;
        Class<?> _class;
        ArrayList<IDimDataQuery> billValues = new ArrayList<IDimDataQuery>();
        if (ctx == null || conn == null || billIds == null || billIds.isEmpty()) {
            return billValues;
        }
        List tmpList = null;
        String bosType = BOSUuid.read((String)billIds.iterator().next()).getType().toString();
        if ("3BA5F027".equals(bosType)) {
            tmpList = MbgDataHelper.getBgFormInfo(ctx, conn, billIds);
            if (tmpList != null) {
                billValues.addAll(tmpList);
            }
        } else if ("655ADD42".equals(bosType)) {
            Method method2;
            Class<?> _class2 = Class.forName("com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper");
            if (_class2 != null && (method2 = _class2.getMethod("getBgCslFormInfo", Context.class, Connection.class, List.class)) != null && (tmpList = (List)method2.invoke(_class2, ctx, conn, billIds)) != null) {
                billValues.addAll(tmpList);
            }
        } else if ("AD34C4CD".equals(bosType)) {
            Method method3;
            Class<?> _class3 = Class.forName("com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper");
            if (_class3 != null && (method3 = _class3.getMethod("getBgCslAdjFormInfo", Context.class, Connection.class, List.class)) != null && (tmpList = (List)method3.invoke(_class3, ctx, conn, billIds)) != null) {
                billValues.addAll(tmpList);
            }
        } else if ("9E7BD5E2".equals(bosType) && (_class = Class.forName("com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper")) != null && (method = _class.getMethod("getMBgWorkPaperInfo", Context.class, Connection.class, List.class)) != null && (tmpList = (List)method.invoke(_class, ctx, conn, billIds)) != null) {
            billValues.addAll(tmpList);
        }
        return billValues;
    }

    public static BgPeriodInfo getBgPeriodInfo(Context ctx, String bgPeriodId) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("periodType");
        sic.add("year");
        return BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId), sic);
    }

    public static BgPeriodCollection getBgPeriods(Set<String> bgPeriodNums) throws BOSException {
        return MbgDataHelper.getBgPeriods(bgPeriodNums, null);
    }

    public static BgPeriodCollection getBgPeriods(Set<String> bgPeriodNums, SelectorItemCollection sic) throws BOSException {
        BgPeriodCollection colls = new BgPeriodCollection();
        if (bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", bgPeriodNums, CompareType.INCLUDE));
        view.setFilter(filter);
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("longnumber");
        }
        colls = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
        return colls;
    }

    public static BgVersionInfo getBgVersionInfo(Context ctx, String bgVersionId) throws BOSException, EASBizException {
        if (ctx == null || bgVersionId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("versionId");
        sic.add("number");
        sic.add("name");
        return BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo((IObjectPK)new ObjectUuidPK(bgVersionId), sic);
    }

    public static List<Map<String, Set<String>>> parseMbgMember(Context ctx, IDimDataQuery dimDataQuery, BgSchemeInfo schemeInfo, Map<String, String> srcFieldMap) throws Exception {
        ArrayList<Map<String, Set<String>>> mbgMembers = new ArrayList<Map<String, Set<String>>>();
        if (ctx == null || dimDataQuery == null || schemeInfo == null) {
            return mbgMembers;
        }
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        HashMap<String, Set<String>> mbgDimMap = null;
        Set<String> memberSet = null;
        Map<String, String[]> spDimMap = dimDataQuery.getSpItems(srcFieldMap);
        IMbgViewBase view = null;
        String field = null;
        String[] spStrs = null;
        boolean hasPeriod = false;
        int periodType = dimDataQuery.getBizPeriod().getPeriodType().getValue();
        view = dimDataQuery.getView(ctx, schemeInfo);
        if (view != null && view.getSheetManagers() != null) {
            int in = view.getSheetManagers().size();
            for (int i = 0; i < in; ++i) {
                manager = view.getSheetManagers().get(i).getDimensionManager();
                if (manager == null) continue;
                hasPeriod = false;
                mbgDimMap = new HashMap<String, Set<String>>();
                mbgMembers.add(mbgDimMap);
                if (manager instanceof MbgViewListDimensionManager) {
                    DimUtils.transMbgDimMember((MbgViewListDimensionManager)manager);
                }
                for (int j = 0; j < manager.getDimension().size(); ++j) {
                    int x;
                    int xn;
                    if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j)).getNumber())) continue;
                    if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
                        hasPeriod = true;
                    }
                    if (mbgDimMap.containsKey(field = DimUtils.getDimensionField(dimInfo))) {
                        memberSet = (Set)mbgDimMap.get(field);
                    } else {
                        memberSet = new HashSet();
                        mbgDimMap.put(field, memberSet);
                    }
                    List memList = dimInfo.getMember();
                    if (memList == null || memList.isEmpty()) continue;
                    if (DimUtils.checkBaseDimension(dimInfo)) {
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            member = (BgDimensionMember)memList.get(x);
                            if (hasPeriod) {
                                memberSet.add(BgPeriodNVariableHelper.getBgPeriodByN((String)dimDataQuery.getBizPeriod().getNumber(), (String)member.getNumber(), (int)periodType));
                                continue;
                            }
                            memberSet.add(member.getNumber());
                        }
                        continue;
                    }
                    xn = memList.size();
                    for (x = 0; x < xn; ++x) {
                        member = (BgDimensionMember)memList.get(x);
                        memberSet.add(DimUtils.getDimNumber(member.getSrcNumber(), member.getNumber()));
                    }
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_VERSION_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_VERSION_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_VERSION_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(dimDataQuery.getBizVersion().getNumber());
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_PERIOD_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(dimDataQuery.getBizPeriod().getNumber());
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_CURRENCY_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_CURRENCY_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_CURRENCY_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(dimDataQuery.getBizCurrency().getNumber());
                }
                if (spDimMap == null || spDimMap.isEmpty()) continue;
                Map.Entry<String, String[]> entry2 = null;
                for (Map.Entry<String, String[]> entry2 : spDimMap.entrySet()) {
                    field = entry2.getKey();
                    spStrs = entry2.getValue();
                    if (mbgDimMap.containsKey(field)) {
                        memberSet = (Set)mbgDimMap.get(field);
                    } else {
                        memberSet = new HashSet();
                        mbgDimMap.put(field, memberSet);
                    }
                    memberSet.add(spStrs[0]);
                }
            }
        }
        return mbgMembers;
    }

    public static Map<String, Set<String>> mergeMbgMember(List<Map<String, Set<String>>> mbgMembers) {
        HashMap<String, Set<String>> mbgMemberMap = new HashMap<String, Set<String>>();
        if (mbgMembers == null || mbgMembers.isEmpty()) {
            return mbgMemberMap;
        }
        Map.Entry<String, Set<String>> entry2 = null;
        Set tmpSet = null;
        for (Map<String, Set<String>> tmpMap : mbgMembers) {
            for (Map.Entry<String, Set<String>> entry2 : tmpMap.entrySet()) {
                if (mbgMemberMap.containsKey(entry2.getKey())) {
                    tmpSet = (Set)mbgMemberMap.get(entry2.getKey());
                    if (tmpSet == null) continue;
                    tmpSet.addAll((Collection)entry2.getValue());
                    continue;
                }
                mbgMemberMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        return mbgMemberMap;
    }

    public static Map<String, Set<String>> mergeMbgMember(IDimensionParameter parameter) {
        return MbgDataHelper.mergeMbgMember(null, parameter, null);
    }

    public static Map<String, Set<String>> mergeMbgMember(IDimDataQuery dimDataQuery, IDimensionParameter parameter, List<IBgDimensionManagerBase> dimensionManagers) {
        int j;
        HashMap<String, Set<String>> mbgMemberMap = new HashMap<String, Set<String>>();
        String field = null;
        Set<String> memberSet = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        if (parameter != null) {
            List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = parameter.getDims();
            int in = dims.size();
            for (int i = 0; i < in; ++i) {
                int j2;
                int jn;
                dimension = dims.get(i);
                if (mbgMemberMap.containsKey(dimension.getField())) {
                    memberSet = (Set)mbgMemberMap.get(dimension.getField());
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(dimension.getField(), memberSet);
                }
                if (DimUtils.checkBaseDimension(dimension)) {
                    jn = dimension.getDimensionMember().size();
                    for (j2 = 0; j2 < jn; ++j2) {
                        member = dimension.getDimensionMember().get(j2);
                        memberSet.add(member.getNumber());
                    }
                    continue;
                }
                jn = dimension.getDimensionMember().size();
                for (j2 = 0; j2 < jn; ++j2) {
                    member = dimension.getDimensionMember().get(j2);
                    memberSet.add(member.getDimNumber());
                }
            }
            if (!parameter.getQuerys().isEmpty()) {
                IQueryData query = null;
                Map.Entry<String, IDimension> entry2 = null;
                IDimension mbgDim = null;
                IMember mbgMember = null;
                int in2 = parameter.getQuerys().size();
                for (int i = 0; i < in2; ++i) {
                    query = parameter.getQuerys().get(i);
                    for (Map.Entry<String, IDimension> entry2 : query.getMbgDimMap().entrySet()) {
                        int jn;
                        field = entry2.getKey();
                        mbgDim = entry2.getValue();
                        if (mbgMemberMap.containsKey(field)) {
                            memberSet = (Set)mbgMemberMap.get(field);
                        } else {
                            memberSet = new HashSet();
                            mbgMemberMap.put(field, memberSet);
                        }
                        if (DimUtils.checkBaseDimensionByField(field)) {
                            jn = mbgDim.getMembers().size();
                            for (j = 0; j < jn; ++j) {
                                mbgMember = mbgDim.getMembers().get(j);
                                memberSet.add(mbgMember.getNumber());
                            }
                            continue;
                        }
                        jn = mbgDim.getMembers().size();
                        for (j = 0; j < jn; ++j) {
                            mbgMember = mbgDim.getMembers().get(j);
                            memberSet.add(mbgMember.getDimNumber());
                        }
                    }
                }
            }
            if (parameter.getDataManager().getDefCurrency() != null) {
                if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, memberSet);
                }
                memberSet.add(parameter.getDataManager().getDefCurrency()[0]);
            }
            if (parameter.getDataManager().getDefElement() != null) {
                if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, memberSet);
                }
                memberSet.add(parameter.getDataManager().getDefElement()[0]);
            }
            if (parameter.getDataManager().getDefScenario() != null) {
                if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, memberSet);
                }
                memberSet.add(parameter.getDataManager().getDefScenario()[0]);
            }
            if (parameter.getDataManager().getDefVersion() != null) {
                if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_VERSION_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, memberSet);
                }
                memberSet.add(parameter.getDataManager().getDefVersion()[0]);
            }
        }
        if (dimDataQuery != null) {
            if (!mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                memberSet = new HashSet<String>();
                memberSet.add(dimDataQuery.getBizCurrency().getNumber());
                mbgMemberMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, memberSet);
            }
            if (!mbgMemberMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                memberSet = new HashSet();
                memberSet.add(dimDataQuery.getBizVersion().getNumber());
                mbgMemberMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, memberSet);
            }
        }
        if (dimensionManagers != null) {
            BgDimensionMember bgMember = null;
            MbgViewListDimensionInfo bgDimension = null;
            for (int i = 0; i < dimensionManagers.size(); ++i) {
                IBgDimensionManagerBase dimManger = dimensionManagers.get(i);
                List<MbgViewListDimensionInfo> dimensions = dimManger instanceof MbgViewListDimensionManager ? ((MbgViewListDimensionManager)dimManger).getAllDimensions() : dimManger.getDimension();
                int count = dimensions.size();
                for (int k = 0; k < count; ++k) {
                    BgDimensionBaseInfo bgDim;
                    bgDimension = dimensions.get(k);
                    if (!(bgDimension instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_SCENARIO_NUMBER.equals((bgDim = (BgDimensionBaseInfo)bgDimension).getNumber())) continue;
                    memberSet = (Set)mbgMemberMap.get(DimensionConstants.DEF_SCENARIO_FIELD);
                    if (memberSet == null) {
                        memberSet = new HashSet();
                        mbgMemberMap.put(DimensionConstants.DEF_SCENARIO_FIELD, memberSet);
                    }
                    for (j = 0; j < bgDim.getMember().size(); ++j) {
                        bgMember = (BgDimensionMember)bgDim.getMember().get(j);
                        memberSet.add(bgMember.getNumber());
                    }
                }
            }
        }
        return mbgMemberMap;
    }

    public static Map<String, Set<String>> parseMbgMember(IMbgViewBase view) {
        HashMap<String, Set<String>> mbgMemberMap = new HashMap<String, Set<String>>();
        if (view == null) {
            return mbgMemberMap;
        }
        IMbgSheetBase sheetManager = null;
        int in = view.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            sheetManager = view.getSheetManagers().get(i);
            MbgDataHelper.parseMbgMember(sheetManager.getDimensionManager(), mbgMemberMap);
        }
        return mbgMemberMap;
    }

    public static void parseMbgMember(IBgDimensionManagerBase dimensionManagerBase, Map<String, Set<String>> mbgMemberMap) {
        if (dimensionManagerBase == null || mbgMemberMap == null) {
            return;
        }
        MbgViewListDimensionManager viewListDimManager = null;
        if (dimensionManagerBase instanceof MbgViewListDimensionManager) {
            viewListDimManager = (MbgViewListDimensionManager)dimensionManagerBase;
            MbgDataHelper.parseMbgMember(viewListDimManager, mbgMemberMap);
        } else {
            MbgDataHelper.parseMbgMember(dimensionManagerBase.getRowDimension(), mbgMemberMap);
            MbgDataHelper.parseMbgMember(dimensionManagerBase.getColDimension(), mbgMemberMap);
            MbgDataHelper.parseMbgMember(dimensionManagerBase.getViewDimension(), mbgMemberMap);
            MbgDataHelper.parseMbgMember(dimensionManagerBase.getPageDimension(), mbgMemberMap);
        }
    }

    private static void parseMbgMember(MbgViewListDimensionManager viewListDimManager, Map<String, Set<String>> mbgMemberMap) {
        if (viewListDimManager == null || mbgMemberMap == null) {
            return;
        }
        MbgDataHelper.parseMbgMember(viewListDimManager.getRows(), mbgMemberMap);
        MbgDataHelper.parseMbgMember(viewListDimManager.getColumns(), mbgMemberMap);
        MbgDataHelper.parseMbgMember(viewListDimManager.getViewDimension(), mbgMemberMap);
        MbgDataHelper.parseMbgMember(viewListDimManager.getPageDimension(), mbgMemberMap);
    }

    private static void parseMbgMember(List dimList, Map<String, Set<String>> mbgMemberMap) {
        if (dimList == null || mbgMemberMap == null) {
            return;
        }
        Object obj = null;
        MbgViewListRowCol rc = null;
        BgDimensionBaseInfo dimension = null;
        int in = dimList.size();
        for (int i = 0; i < in; ++i) {
            obj = dimList.get(i);
            if (obj instanceof MbgViewListRowCol) {
                rc = obj;
                MbgDataHelper.parseMbgMember(rc, mbgMemberMap);
                continue;
            }
            if (!(obj instanceof BgDimensionBaseInfo)) continue;
            dimension = obj;
            MbgDataHelper.parseMbgMember(dimension, mbgMemberMap);
        }
    }

    private static void parseMbgMember(MbgViewListRowCol rc, Map<String, Set<String>> mbgMemberMap) {
        if (rc == null || mbgMemberMap == null) {
            return;
        }
        MbgViewListDimensionInfo dimension = null;
        int in = rc.getDimensions().size();
        for (int i = 0; i < in; ++i) {
            dimension = rc.getDimensions().get(i);
            MbgDataHelper.parseMbgMember(dimension, mbgMemberMap);
        }
    }

    private static void parseMbgMember(BgDimensionBaseInfo dimension, Map<String, Set<String>> mbgMemberMap) {
        if (dimension == null || mbgMemberMap == null) {
            return;
        }
        String field = DimUtils.getDimensionField(dimension);
        boolean hasBase = DimUtils.checkBaseDimensionByField(field);
        BgDimensionMember member = null;
        Set<Object> memberSet = null;
        if (mbgMemberMap.containsKey(field)) {
            memberSet = mbgMemberMap.get(field);
        } else {
            memberSet = new HashSet();
            mbgMemberMap.put(field, memberSet);
        }
        if (hasBase) {
            int in = dimension.getMember().size();
            for (int i = 0; i < in; ++i) {
                member = (BgDimensionMember)dimension.getMember().get(i);
                memberSet.add(member.getNumber());
            }
        } else {
            int in = dimension.getMember().size();
            for (int i = 0; i < in; ++i) {
                member = (BgDimensionMember)dimension.getMember().get(i);
                memberSet.add(DimUtils.getDimNumber(member.getSrcNumber(), member.getNumber()));
            }
        }
    }

    private static void parseMbgMember(MbgViewListDimensionInfo dimension, Map<String, Set<String>> mbgMemberMap) {
        if (dimension == null || mbgMemberMap == null) {
            return;
        }
        MbgDataHelper.parseMbgMember((BgDimensionBaseInfo)dimension, mbgMemberMap);
        String field = DimUtils.getDimensionField(dimension);
        boolean hasBase = DimUtils.checkBaseDimensionByField(field);
        BgDimensionMember member = null;
        Set<Object> memberSet = null;
        if (mbgMemberMap.containsKey(field)) {
            memberSet = mbgMemberMap.get(field);
        } else {
            memberSet = new HashSet();
            mbgMemberMap.put(field, memberSet);
        }
        if (hasBase) {
            int in = dimension.getMember().size();
            for (int i = 0; i < in; ++i) {
                member = (BgDimensionMember)dimension.getMember().get(i);
                memberSet.add(member.getNumber());
            }
        } else {
            int in = dimension.getMember().size();
            for (int i = 0; i < in; ++i) {
                member = (BgDimensionMember)dimension.getMember().get(i);
                memberSet.add(DimUtils.getDimNumber(member.getSrcNumber(), member.getNumber()));
            }
        }
    }
}

