/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.cube.dimension.Dimension;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgDimUtils {
    public static Map<String, IDimension> getMbgDimInfo(IDimDataQuery dimDataQuery, IMbgViewBase view, Set<String> mbgDimNums) {
        HashMap<String, IDimension> mbgDimMap = new HashMap<String, IDimension>();
        if (dimDataQuery == null || view == null || view.getSheetManagers() == null || mbgDimNums == null) {
            return mbgDimMap;
        }
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        IDimension mbgDim = null;
        Member mbgMember = null;
        ArrayList<IMember> mbgMembers = new ArrayList<IMember>();
        int in = view.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            manager = view.getSheetManagers().get(i).getDimensionManager();
            if (manager == null) continue;
            if (manager instanceof MbgViewListDimensionManager) {
                DimUtils.transMbgDimMember((MbgViewListDimensionManager)manager);
            }
            for (int j = 0; j < manager.getDimension().size(); ++j) {
                int x;
                int xn;
                dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
                if (!mbgDimNums.contains(dimInfo.getNumber())) continue;
                if (mbgDimMap.containsKey(dimInfo.getNumber())) {
                    mbgDim = (IDimension)mbgDimMap.get(dimInfo.getNumber());
                } else {
                    mbgDim = new Dimension();
                    mbgDim.setNumber(dimInfo.getNumber());
                    mbgDim.setNumber(dimInfo.getNumber());
                    mbgDim.setField(DimUtils.getDimensionField(dimInfo));
                    mbgDimMap.put(mbgDim.getNumber(), mbgDim);
                }
                List memList = dimInfo.getMember();
                if (memList == null || memList.isEmpty()) continue;
                mbgMembers.clear();
                if (DimUtils.checkBaseDimension(dimInfo)) {
                    xn = memList.size();
                    for (x = 0; x < xn; ++x) {
                        member = (BgDimensionMember)memList.get(x);
                        mbgMember = new Member();
                        mbgMember.setNumber(member.getNumber());
                        mbgMember.setName(member.getName());
                        mbgMembers.add(mbgMember);
                    }
                } else {
                    xn = memList.size();
                    for (x = 0; x < xn; ++x) {
                        member = (BgDimensionMember)memList.get(x);
                        mbgMember = new Member();
                        mbgMember.setNumber(DimUtils.getDimNumber(member.getSrcNumber(), member.getNumber()));
                        mbgMember.setName(member.getName());
                        mbgMembers.add(mbgMember);
                    }
                }
                mbgDim.addAllMember(mbgMembers);
            }
        }
        if (0 == dimDataQuery.getBizTemplateType()) {
            if (mbgDimNums.contains(DimensionConstants.DEF_VERSION_NUMBER) && (mbgDim = (IDimension)mbgDimMap.get(DimensionConstants.DEF_VERSION_NUMBER)).getMembers().isEmpty()) {
                mbgMember = new Member();
                mbgMember.setNumber(dimDataQuery.getBizVersion().getNumber());
                mbgMember.setName(dimDataQuery.getBizVersion().getName());
                mbgDim.getMembers().add(mbgMember);
            }
            if (mbgDimNums.contains(DimensionConstants.DEF_PERIOD_NUMBER) && (mbgDim = (IDimension)mbgDimMap.get(DimensionConstants.DEF_PERIOD_NUMBER)).getMembers().isEmpty()) {
                mbgMember = new Member();
                mbgMember.setNumber(dimDataQuery.getBizPeriod().getNumber());
                mbgMember.setName(dimDataQuery.getBizPeriod().getName());
                mbgDim.getMembers().add(mbgMember);
            }
            if (mbgDimNums.contains(DimensionConstants.DEF_CURRENCY_NUMBER) && (mbgDim = (IDimension)mbgDimMap.get(DimensionConstants.DEF_CURRENCY_NUMBER)).getMembers().isEmpty()) {
                mbgMember = new Member();
                mbgMember.setNumber(dimDataQuery.getBizCurrency().getNumber());
                mbgMember.setName(dimDataQuery.getBizCurrency().getName());
                mbgDim.getMembers().add(mbgMember);
            }
        }
        return mbgDimMap;
    }
}

