/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class DimDataUtils {
    public static BigDecimal getValue(IBgNData bgData, int valueType) {
        if (bgData == null) {
            return null;
        }
        BigDecimal value = null;
        if (valueType == 1) {
            value = bgData.getBudgetValue();
        } else if (valueType == 4) {
            value = bgData.getBizActual();
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            value = bgData.getAddActualValue();
        } else if (valueType == 8) {
            value = bgData.getBalance();
        }
        return value;
    }

    public static void setValue(IBgNData bgData, BigDecimal value, int valueType) {
        if (bgData == null || value == null) {
            return;
        }
        if (valueType == 1) {
            bgData.setBudgetValue(value);
        } else if (valueType == 4) {
            bgData.setBizActual(value);
        } else if (valueType == 8) {
            bgData.setBalance(value);
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            bgData.setAddActualValue(value);
        }
    }

    public static String getTypeValue(IDimensionParameter parameter) {
        return "[" + DimensionConstants.MRESURES + "].[" + DimensionConstants.VALUE + "]";
    }

    public static int addValueType(int valueType, int addValueType) {
        return valueType | addValueType;
    }

    public static boolean hasType(int valueType, int hasType) {
        return (valueType & hasType) != 0;
    }

    public static String getBudgetFactTable() {
        return "T_MBG_BGDATA";
    }

    public static String getActualFactTable() {
        return "T_MBG_BGDATA";
    }

    public static String getDailyActualFactTable() {
        return "T_MBG_BGACTUALDATA";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDimItemTableName(Context ctx, List<String> dimKeys) throws Exception {
        if (ctx == null) return null;
        if (dimKeys == null) return null;
        if (dimKeys.isEmpty()) {
            return null;
        }
        String dimKey = null;
        String factTable = null;
        String[] tmpKeys = null;
        HashSet<String> tmpSet = new HashSet<String>();
        StringBuffer sqlDim = new StringBuffer();
        sqlDim.append("select FDIMKEY, FTABLENAME from T_MBG_BgItemDim where ");
        int in = dimKeys.size();
        for (int i = 0; i < in; ++i) {
            sqlDim.append("FDIMKey like '%" + dimKeys.get(i) + "%' AND ");
        }
        sqlDim = sqlDim.delete(sqlDim.length() - 5, sqlDim.length());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sqlDim.toString());
            rst = pstmt.executeQuery();
            block6: while (rst.next()) {
                int i;
                dimKey = rst.getString("FDIMKEY");
                factTable = rst.getString("FTABLENAME");
                tmpKeys = dimKey.split("_");
                tmpSet.clear();
                int in2 = tmpKeys.length;
                for (i = 0; i < in2; ++i) {
                    tmpSet.add(tmpKeys[i]);
                }
                in2 = dimKeys.size();
                for (i = 0; i < in2; ++i) {
                    if (tmpSet.contains(dimKeys.get(i))) continue;
                    factTable = null;
                    continue block6;
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (SQLDataException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return factTable;
    }

    class BgPeriodData {
        private String bgPeriodNumber = null;
        private IBgNData bgData = null;
        private BigDecimal value = null;
        private List<BgPeriodData> child = null;
        private boolean hasSort = false;

        BgPeriodData() {
        }

        public void setBgPeriodNumber(String bgPeriodNumber) {
            this.bgPeriodNumber = bgPeriodNumber;
        }

        public String getBgPeriodNumber() {
            return this.bgPeriodNumber;
        }

        public void setBgData(IBgNData bgData) {
            this.bgData = bgData;
        }

        public IBgNData getBgData() {
            return this.bgData;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setChild(List<BgPeriodData> child) {
            this.child = child;
        }

        public List<BgPeriodData> getChild() {
            if (this.child == null) {
                this.child = new ArrayList<BgPeriodData>();
            }
            return this.child;
        }

        public void setHasSort(boolean hasSort) {
            this.hasSort = hasSort;
        }

        public boolean isHasSort() {
            return this.hasSort;
        }
    }
}

