/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodCacheUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.app.utils.BizCalcCheckServerHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimData;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.query.QueryData;
import com.kingdee.eas.ma.mbg.cube.utils.CubeCacheUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMemberBase;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgVariateUtils;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public final class DimUtils {
    private static Logger logger = Logger.getLogger(DimUtils.class);
    private static List<com.kingdee.eas.ma.mbg.dimension.face.IMember> list;

    public static MbgDimInfo getBgIndexDim() throws BOSException {
        return DimUtils.getBgIndexDim(null);
    }

    public static MbgDimInfo getBgIndexDim(Context ctx) throws BOSException {
        MbgDimInfo bgIndexDim = null;
        MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
        if (colls != null && !colls.isEmpty()) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                if (!DimensionConstants.DEF_INDEX_NUMBER.equals(colls.get(i).getNumber())) continue;
                bgIndexDim = colls.get(i);
                break;
            }
        }
        return bgIndexDim;
    }

    public static MbgDimInfo getDimensionInfo(Context ctx, BOSUuid dimensionId) throws BOSException, EASBizException {
        if (dimensionId != null) {
            return DimUtils.getDimensionInterface(ctx).getMbgDimInfo((IObjectPK)new ObjectUuidPK(dimensionId), DimUtils.getDimSelector());
        }
        return null;
    }

    public static MbgDimCollection getDimensionColls(Context ctx) throws BOSException {
        MbgDimCollection colls = new MbgDimCollection();
        if (ctx != null) {
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                colls = DimUtils.getDimensionColls(conn, ctx.getLocale());
            }
            catch (SQLDataException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            colls = DimUtils.getDimensionColls();
        }
        return colls;
    }

    public static void addDefaultMbgDim(MbgDimCollection colls, Locale locale) {
        if (colls == null) {
            return;
        }
        MbgDimInfo mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefOrgUnitName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_INDEX_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_BGINDEX_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefAccountName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_ELEMENT_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefElementName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_PERIOD_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefPeriodName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_CURRENCY_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefCurrencyName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_SCENARIO_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefScenarioName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_VERSION_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_VERSION_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_VERSION_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefVersionName(locale));
        colls.add(mbgDim);
        mbgDim = new MbgDimInfo();
        mbgDim.setNumber(DimensionBaseConstants.DEF_CSL_NUMBER);
        mbgDim.setRefField(DimensionBaseConstants.DEF_CSL_FIELD);
        mbgDim.setSrcNumber(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
        mbgDim.setName(DimensionConstants.getDefCslName(locale));
        colls.add(mbgDim);
    }

    public static MbgDimCollection getDimensionColls() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)DimUtils.getDimSelector());
        MbgDimCollection colls = DimUtils.getDimensionInterface(null).getMbgDimCollection(view);
        DimUtils.addDefaultMbgDim(colls, null);
        return colls;
    }

    private static IMbgDim getDimensionInterface(Context ctx) throws BOSException {
        if (ctx != null) {
            return MbgDimFactory.getLocalInstance((Context)ctx);
        }
        return MbgDimFactory.getRemoteInstance();
    }

    public static SelectorItemCollection getDimSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("refField");
        sic.add("srcNumber");
        return sic;
    }

    public static MbgDimCollection getDimensionColls(Connection conn, Locale locale) throws BOSException {
        MbgDimCollection colls = new MbgDimCollection();
        if (conn == null) {
            return colls;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        MbgDimInfo mbgDim = null;
        try {
            pstmt = conn.prepareStatement("select FID, FName_" + locale + ", FNumber, FRefField, FSrcNumber from T_MBG_MbgDim");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                mbgDim = new MbgDimInfo();
                mbgDim.setId(BOSUuid.read((String)rst.getString("FID")));
                mbgDim.setName(rst.getString(2));
                mbgDim.setNumber(rst.getString("FNumber"));
                mbgDim.setRefField(rst.getString("FRefField"));
                mbgDim.setSrcNumber(rst.getString("FSrcNumber"));
                colls.add(mbgDim);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        DimUtils.addDefaultMbgDim(colls, locale);
        return colls;
    }

    public static Map<String, String> getDimSourceMap(Context ctx) throws BOSException {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (ctx == null) {
            return sourceMap;
        }
        MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                sourceMap.put(mbgDim.getSrcNumber(), mbgDim.getRefField());
            }
        }
        sourceMap.put(DimensionConstants.DEF_INDEX_SRCNUMBER, DimensionConstants.DEF_BGINDEX_FIELD);
        return sourceMap;
    }

    public static Map<String, String> getDimSourceMap(Connection conn, Locale locale) throws BOSException {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (conn == null) {
            return sourceMap;
        }
        MbgDimCollection colls = DimUtils.getDimensionColls(conn, locale);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                sourceMap.put(mbgDim.getSrcNumber(), mbgDim.getRefField());
            }
        }
        sourceMap.put(DimensionConstants.DEF_INDEX_SRCNUMBER, DimensionConstants.DEF_BGINDEX_FIELD);
        return sourceMap;
    }

    public static Map<String, MbgDimInfo> getDimInfoMap(Context ctx) throws BOSException {
        HashMap<String, MbgDimInfo> sourceMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                sourceMap.put(mbgDim.getSrcNumber(), mbgDim);
            }
        }
        return sourceMap;
    }

    public static Map<String, MbgDimInfo> getDimInfoMap(Connection conn, Locale locale) throws BOSException {
        HashMap<String, MbgDimInfo> sourceMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection colls = DimUtils.getDimensionColls(conn, locale);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                sourceMap.put(mbgDim.getSrcNumber(), mbgDim);
            }
        }
        return sourceMap;
    }

    public static Map<String, MbgDimInfo> getDimInfoByField(MbgDimCollection colls) throws BOSException {
        HashMap<String, MbgDimInfo> fieldMap = new HashMap<String, MbgDimInfo>();
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                fieldMap.put(mbgDim.getRefField(), mbgDim);
            }
        }
        return fieldMap;
    }

    public static Map<String, MbgDimInfo> getDimNumMap(Connection conn, Locale locale) throws BOSException {
        HashMap<String, MbgDimInfo> sourceMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection colls = DimUtils.getDimensionColls(conn, locale);
        if (colls != null) {
            MbgDimInfo mbgDim = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                sourceMap.put(mbgDim.getNumber(), mbgDim);
            }
        }
        return sourceMap;
    }

    public static Map<String, String> getDimSourceMap(Map<String, MbgDimInfo> dimsMap) throws BOSException {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (dimsMap == null) {
            return sourceMap;
        }
        Map.Entry<String, MbgDimInfo> entry2 = null;
        for (Map.Entry<String, MbgDimInfo> entry2 : dimsMap.entrySet()) {
            sourceMap.put(entry2.getKey(), entry2.getValue().getRefField());
        }
        return sourceMap;
    }

    public static void putCommSrcField(Map<String, String> srcFieldMap) {
        if (srcFieldMap == null) {
            return;
        }
        srcFieldMap.put(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER, DimensionBaseConstants.DEF_ORGUNIT_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_INDEX_SRCNUMBER, DimensionBaseConstants.DEF_BGINDEX_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER, DimensionBaseConstants.DEF_ELEMENT_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER, DimensionBaseConstants.DEF_CURRENCY_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER, DimensionBaseConstants.DEF_SCENARIO_FIELD);
        srcFieldMap.put(DimensionBaseConstants.DEF_VERSION_SRCNUMBER, DimensionBaseConstants.DEF_VERSION_FIELD);
    }

    public static Map<String, String> getSrcFieldMap(MbgDimCollection mbgDims) throws BOSException {
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        if (mbgDims == null) {
            return srcFieldMap;
        }
        DimUtils.putCommSrcField(srcFieldMap);
        MbgDimInfo mbgDim = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            srcFieldMap.put(mbgDim.getSrcNumber(), mbgDim.getRefField());
        }
        return srcFieldMap;
    }

    public static Map<String, String> getSrcFieldMap(Map<String, MbgDimInfo> dimsMap) throws BOSException {
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        if (dimsMap == null) {
            return srcFieldMap;
        }
        DimUtils.putCommSrcField(srcFieldMap);
        MbgDimInfo mbgDim2 = null;
        for (MbgDimInfo mbgDim2 : dimsMap.values()) {
            srcFieldMap.put(mbgDim2.getSrcNumber(), mbgDim2.getRefField());
        }
        return srcFieldMap;
    }

    public static void removeBaseMember(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, Set<String> memberNums) {
        if (dimension == null || memberNums == null) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember> filter = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            if (memberNums.contains(member.getNumber())) continue;
            filter.add(member);
        }
        dimension.getDimensionMember().clear();
        dimension.getDimensionMember().addAll(filter);
    }

    public static void transDimParameter(IDimensionParameter parameter, String[] refDimData) {
        int i;
        int i2;
        int i3;
        if (parameter == null || refDimData == null) {
            return;
        }
        HashSet<String> refDimNumber = new HashSet<String>();
        final HashMap<String, Integer> refDimIndex = new HashMap<String, Integer>();
        int in = refDimData.length;
        for (int i4 = 0; i4 < in; ++i4) {
            refDimNumber.add(refDimData[i4]);
            refDimIndex.put(refDimData[i4], i4);
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension _dimension = null;
        ArrayList dims = new ArrayList();
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> tmpDims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> colDims = parameter.getColDims();
        int in2 = colDims.size();
        for (i3 = 0; i3 < in2; ++i3) {
            _dimension = colDims.get(i3);
            if (!refDimNumber.contains(_dimension.getNumber())) continue;
            tmpDims.add(_dimension);
        }
        in2 = tmpDims.size();
        for (i3 = 0; i3 < in2; ++i3) {
            _dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)tmpDims.get(i3);
            colDims.remove(_dimension);
        }
        if (!tmpDims.isEmpty()) {
            dims.addAll(tmpDims);
            tmpDims.clear();
        }
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> pageDims = parameter.getPageDims();
        int in3 = pageDims.size();
        for (i2 = 0; i2 < in3; ++i2) {
            _dimension = pageDims.get(i2);
            if (!refDimNumber.contains(_dimension.getNumber())) continue;
            tmpDims.add(_dimension);
        }
        in3 = tmpDims.size();
        for (i2 = 0; i2 < in3; ++i2) {
            _dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)tmpDims.get(i2);
            pageDims.remove(_dimension);
        }
        if (!tmpDims.isEmpty()) {
            dims.addAll(tmpDims);
            tmpDims.clear();
        }
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> rowDims = parameter.getRowDims();
        int in4 = rowDims.size();
        for (i = 0; i < in4; ++i) {
            _dimension = rowDims.get(i);
            if (refDimNumber.contains(_dimension.getNumber())) continue;
            tmpDims.add(_dimension);
        }
        in4 = tmpDims.size();
        for (i = 0; i < in4; ++i) {
            _dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)tmpDims.get(i);
            rowDims.remove(_dimension);
        }
        if (!dims.isEmpty()) {
            rowDims.addAll(dims);
        }
        if (!tmpDims.isEmpty()) {
            colDims.addAll(tmpDims);
        }
        Collections.sort(rowDims, new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                int index1 = (Integer)refDimIndex.get(o1.getNumber());
                int index2 = (Integer)refDimIndex.get(o2.getNumber());
                return index1 - index2;
            }
        });
    }

    public static IDimensionParameter transDimParameter(Context ctx, List<IBgDimensionManagerBase> dimensionManager, BgFormInfo bgFormInfo, BOSUuid bgOrgViewId) throws Exception {
        return DimUtils.transDimParameter(ctx, dimensionManager, (IDimDataQuery)bgFormInfo, bgOrgViewId);
    }

    public static IDimensionParameter transDimParameter(Context ctx, List<IBgDimensionManagerBase> dimensionManager, BgActualRecordInfo bgActualRecord, BOSUuid bgOrgViewId) throws Exception {
        return DimUtils.transDimParameter(ctx, dimensionManager, (IDimDataQuery)bgActualRecord, bgOrgViewId);
    }

    public static IDimensionParameter transDimParameter(Context ctx, List<IBgDimensionManagerBase> dimensionManager, IDimDataQuery query, BOSUuid bgOrgViewId) throws Exception {
        BgSchemeInfo scheme;
        int i;
        if (ctx == null || dimensionManager == null) {
            return null;
        }
        if (query == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        MbgDimInfo mbgDim = null;
        HashMap<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
        IBgDimensionManagerBase dimensionBase = null;
        DimensionParameter parameter = new DimensionParameter();
        if (((IObjectValue)query).get("bgPeriodStandardNumber") != null) {
            parameter.addPeriodStandardNumber((String)((IObjectValue)query).get("bgPeriodStandardNumber"));
        } else if (query.getBizPeriod() != null) {
            parameter.addPeriodStandardNumber(query.getBizPeriod().getNumber());
        }
        parameter.getDataManager().setDimensions(DimUtils.getDimensionColls(ctx));
        int in = parameter.getDataManager().getDimensions().size();
        for (i = 0; i < in; ++i) {
            mbgDim = parameter.getDataManager().getDimensions().get(i);
            mbgDimMap.put(mbgDim.getNumber(), mbgDim);
        }
        in = dimensionManager.size();
        for (i = 0; i < in; ++i) {
            dimensionBase = dimensionManager.get(i);
            if (dimensionBase.getSheet().getEditScenNumber() == null || dimensionBase.getSheet() == null) continue;
            if (parameter.getEditScenNumber() == null) {
                parameter.setEditScenNumber(dimensionBase.getSheet().getEditScenNumber());
                continue;
            }
            parameter.setEditScenNumber(parameter.getEditScenNumber() + "," + dimensionBase.getSheet().getEditScenNumber());
        }
        parameter.setBillId(query.getId());
        parameter.getDataManager().setDimDataQuery(query);
        int formType = 4;
        formType = query.getBizTemplateType();
        FullOrgUnitInfo orgUnitInfo = query.getBizOrgUnit();
        parameter.setOrgUnitId(orgUnitInfo.getId());
        parameter.getDataManager().setOrgUnit((OrgUnitInfo)orgUnitInfo);
        if (query.get("ORGUNIT_ID") != null) {
            parameter.setQeryOrgIds((Set)query.get("ORGUNIT_ID"));
        }
        if ((scheme = query.getBizBgScheme()).getBgDimSettings() == null || scheme.getBgDimSettings().isEmpty() || scheme.getBgDimSettings().get(0).getMembers().isEmpty()) {
            scheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)scheme.getId());
        }
        if (scheme == null) {
            return parameter;
        }
        parameter.setBgSchemeId(scheme.getId());
        parameter.getDataManager().setBgScheme(scheme);
        parameter.setBgOrgViewId(bgOrgViewId != null ? bgOrgViewId : scheme.getEditOrgViewId());
        parameter.setBgTemplateId(new BOSUuid[]{query.getBizTemplateId()});
        BgOrgUnitInfo bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(ctx, parameter.getBgOrgViewId(), orgUnitInfo.getId());
        parameter.getDataManager().setBgOrgUnit(bgOrgUnit);
        parameter.setUnionId(query.getBizUnionId());
        int state = query.getBizState();
        if (state == 4 || state == 35 || state == 6 || state == 12) {
            parameter.getControlManager().setAdjust(true);
        }
        DimUtils.transAllMembers(ctx, dimensionManager, parameter, formType, mbgDimMap, (OrgUnitInfo)orgUnitInfo);
        if (parameter.getControlManager().isFiscalYear() && parameter.getDimensionMap().get(DimensionConstants.DEF_PERIOD_NUMBER) != null) {
            DimUtils.transMdxMemberNumber(ctx, parameter, parameter.getDimensionMap().get(DimensionConstants.DEF_PERIOD_NUMBER));
        }
        DimUtils.transOtherMembers(ctx, parameter, query);
        DimUtils.transRelation(dimensionManager, parameter);
        return parameter;
    }

    private static void transRelation(List<IBgDimensionManagerBase> dimensionManager, IDimensionParameter parameter) {
        if (dimensionManager == null || parameter == null) {
            return;
        }
        IBgDimensionManagerBase dimensionBase = null;
        int xn = dimensionManager.size();
        for (int x = 0; x < xn; ++x) {
            IMbgViewManager viewManager;
            dimensionBase = dimensionManager.get(x);
            if (dimensionBase.getSheet() == null || !(dimensionBase instanceof IBgDimensionManager) || (viewManager = ((IBgDimensionManager)dimensionBase).getSheet().getViewManager()) == null || viewManager.getRelationMaps() == null) continue;
            if (parameter.getDataManager().getRelation() == null) {
                parameter.getDataManager().setRelation(viewManager.getRelationMaps());
                continue;
            }
            parameter.getDataManager().getRelation().addAll(viewManager.getRelationMaps());
        }
    }

    private static void transAllMembers(Context ctx, List<IBgDimensionManagerBase> dimensionManager, IDimensionParameter parameter, int formType, Map<String, MbgDimInfo> mbgDimMap, OrgUnitInfo orgUnitInfo) throws Exception {
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        Object _tmpDim = null;
        Object mbgDim = null;
        BgDimensionBaseInfo dimensionInfo = null;
        IBgDimensionManagerBase dimensionBase = null;
        IQueryData queryData = null;
        MbgViewListDimensionManager dimManager = null;
        DimUtils.beforeQueryLongNumber(ctx, dimensionManager, parameter, mbgDimMap, orgUnitInfo);
        HashMap<String, IQueryData> queryDataMap = new HashMap<String, IQueryData>();
        DimUtils.transScenarioAndVersion(ctx, parameter);
        String mainParamQueryKey = null;
        String thisQueryKey = null;
        List<String[]> relationData = null;
        int xn = dimensionManager.size();
        for (int x = 0; x < xn; ++x) {
            List tmpList;
            dimensionBase = dimensionManager.get(x);
            queryData = null;
            if (0 == formType || 8 == formType) {
                tmpList = dimensionBase.getPageDimension();
                ArrayList<BgDimensionBaseInfo> tmpLists = new ArrayList<BgDimensionBaseInfo>();
                for (BgDimensionBaseInfo bgDimensionBaseInfo : tmpList) {
                    if (DimensionBaseConstants.necessary.contains(bgDimensionBaseInfo.getNumber())) continue;
                    dimensionBase.getRowDimension().add(bgDimensionBaseInfo);
                    tmpLists.add(bgDimensionBaseInfo);
                }
                tmpList.removeAll(tmpLists);
            }
            if (dimensionBase instanceof IBgDimensionManager) {
                DimUtils.transRowColMembers(ctx, dimensionBase, parameter, queryData, formType, mbgDimMap);
            } else if (dimensionBase instanceof MbgViewListDimensionManager) {
                dimManager = (MbgViewListDimensionManager)dimensionBase;
                thisQueryKey = DimUtils.getLayoutKey(dimManager);
                if (!DimUtils.checkOrgOnCol(dimensionManager)) {
                    try {
                        relationData = RelationUtils.getInstance(parameter.getDataManager().getDimensions()).queryRelation(dimManager, parameter);
                    }
                    catch (Exception e) {
                        logger.error((Object)"DimUtils queryRelation error : ", (Throwable)e);
                        relationData = null;
                    }
                } else {
                    relationData = null;
                }
                if (relationData != null && relationData.size() > 0) {
                    thisQueryKey = thisQueryKey + Arrays.toString(relationData.get(0));
                    if (mainParamQueryKey != null) {
                        if (thisQueryKey.equals(mainParamQueryKey)) {
                            DimUtils.margeRelationData(parameter.getDataManager().getRelationData(parameter), relationData);
                        } else if (queryDataMap.containsKey(thisQueryKey)) {
                            queryData = (IQueryData)queryDataMap.get(thisQueryKey);
                            DimUtils.margeRelationData(queryData.getFilters()[1], relationData);
                        } else {
                            ArrayList[] filters = new ArrayList[2];
                            filters[1] = relationData;
                            queryData = new QueryData();
                            queryData.setFilters(filters);
                            queryDataMap.put(thisQueryKey, queryData);
                        }
                    } else {
                        parameter.getDataManager().setRelationData(relationData);
                    }
                } else if (mainParamQueryKey != null) {
                    if (thisQueryKey.equals(mainParamQueryKey)) {
                        queryData = null;
                    } else if (queryDataMap.containsKey(thisQueryKey)) {
                        queryData = (IQueryData)queryDataMap.get(thisQueryKey);
                    } else {
                        queryData = new QueryData();
                        queryDataMap.put(thisQueryKey, queryData);
                    }
                }
                if (mainParamQueryKey == null) {
                    mainParamQueryKey = thisQueryKey;
                }
                DimUtils.transViewListRowColMembers(ctx, dimManager, parameter, queryData, mbgDimMap);
            }
            tmpList = dimensionBase.getPageDisplayDimension();
            if (formType == 0 || formType == 8) {
                tmpList = dimensionBase.getPageDimension();
            }
            if (tmpList != null && !tmpList.isEmpty()) {
                int in = tmpList.size();
                for (int i = 0; i < in; ++i) {
                    dimensionInfo = (BgDimensionBaseInfo)tmpList.get(i);
                    dimension = DimUtils.transFixedDimension(ctx, parameter, dimensionInfo, orgUnitInfo, mbgDimMap);
                    DimUtils.AddDimensionToParameter(ctx, parameter, dimension, parameter.getPageDims(), queryData);
                }
            }
            tmpList = dimensionBase.getViewDisplayDimension();
            if (formType == 0 || formType == 8) {
                tmpList = dimensionBase.getViewDimension();
            }
            if (tmpList == null || tmpList.isEmpty()) continue;
            int in = tmpList.size();
            for (int i = 0; i < in; ++i) {
                dimensionInfo = (BgDimensionBaseInfo)tmpList.get(i);
                dimension = DimUtils.transFixedDimension(ctx, parameter, dimensionInfo, orgUnitInfo, mbgDimMap);
                DimUtils.AddDimensionToParameter(ctx, parameter, dimension, parameter.getPageDims(), queryData);
            }
        }
        if (!queryDataMap.isEmpty()) {
            parameter.getQuerys().addAll(queryDataMap.values());
        }
    }

    private static String getLayoutKey(MbgViewListDimensionManager dimManager) {
        return "P" + DimUtils.getLayoutKey(dimManager.getPageDimension(), true) + ";R" + DimUtils.getLayoutKey(dimManager.getRowDimension(), false) + ";" + DimUtils.getLayoutKey(dimManager.getColDimension(), false) + ";";
    }

    private static String getLayoutKey(List dimensions, boolean isMember) {
        StringBuffer key = new StringBuffer();
        BgDimensionBaseInfo dim = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof BgDimensionBaseInfo)) continue;
            if (key.length() > 0) {
                key.append(",");
            }
            dim = (BgDimensionBaseInfo)dimensions.get(i);
            if (isMember && dim.getMember().size() == 1) {
                key.append(DimensionFormulaHelper.getCombination(dim.getNumber(), BgViewHelper.getNumber(dim.getMember().get(0))));
                continue;
            }
            key.append(dim.getNumber());
        }
        return key.toString();
    }

    protected static void AddDimensionToParameter(Context ctx, IDimensionParameter parameter, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> layout, IQueryData queryData) throws Exception {
        if (dimension != null) {
            if (queryData != null) {
                IDimension mbgDim = dimension.toMbgDim(ctx, parameter);
                if (queryData.getMbgDimMap().containsKey(mbgDim.getField())) {
                    queryData.getMbgDimMap().get(mbgDim.getField()).addAllMember(mbgDim.getMembers());
                } else {
                    queryData.getMbgDimMap().put(mbgDim.getField(), mbgDim);
                }
            } else if (parameter.getDimensionMap().containsKey(dimension.getNumber())) {
                com.kingdee.eas.ma.mbg.dimension.face.IDimension _tmpDim = parameter.getDimensionMap().get(dimension.getNumber());
                if (_tmpDim != null) {
                    _tmpDim.addMembers(dimension.getDimensionMember());
                }
            } else {
                DimUtils.addDimension(layout, dimension);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
        }
    }

    private static void margeRelationData(List<String[]> relationData, List<String[]> relationData2) {
        int i;
        HashSet<String> relationSet = new HashSet<String>();
        for (i = 1; i < relationData.size(); ++i) {
            relationSet.add(Arrays.toString(relationData.get(i)));
        }
        for (i = 1; i < relationData2.size(); ++i) {
            if (relationSet.contains(Arrays.toString(relationData2.get(i)))) continue;
            relationData.add(relationData2.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void beforeQueryLongNumber(Context ctx, List<IBgDimensionManagerBase> dimensionManager, IDimensionParameter parameter, Map<String, MbgDimInfo> mbgDimMap, OrgUnitInfo orgUnitInfo) throws Exception {
        BgDimensionBaseInfo dimensionInfo = null;
        IBgDimensionManagerBase dimensionBase = null;
        List<MbgViewListDimensionInfo> dimensions = null;
        HashMap<String, BgDimensionBaseInfo> dimensionMap = new HashMap<String, BgDimensionBaseInfo>();
        HashMap queryMap = new HashMap();
        Set subSet = null;
        String field2 = null;
        int xn = dimensionManager.size();
        for (int x = 0; x < xn; ++x) {
            dimensionBase = dimensionManager.get(x);
            dimensions = dimensionBase instanceof MbgViewListDimensionManager ? ((MbgViewListDimensionManager)dimensionBase).getAllDimensions() : dimensionBase.getDimension();
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || DimensionConstants.DEF_PERIOD_NUMBER.equals((dimensionInfo = (BgDimensionBaseInfo)dimensions.get(d)).getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimensionInfo.getNumber()) || DimensionConstants.DEF_CSL_NUMBER.equals(dimensionInfo.getNumber()) || DimensionConstants.DEF_STATE_NUMBER.equals(dimensionInfo.getNumber())) continue;
                field2 = dimensionInfo.getRefField();
                if (field2 == null) {
                    field2 = DimensionFormulaHelper.getDefaultRefField(dimensionInfo.getNumber());
                }
                if (!dimensionMap.containsKey(field2 = DimUtils.transFields(field2))) {
                    dimensionMap.put(field2, dimensionInfo);
                }
                if (!queryMap.containsKey(field2)) {
                    queryMap.put(field2, new HashSet());
                }
                subSet = (Set)queryMap.get(field2);
                for (int m = 0; m < dimensionInfo.getMember().size(); ++m) {
                    if (!(dimensionInfo.getMember().get(m) instanceof BgDimensionMember)) continue;
                    if (!DimUtils.checkBaseDimension(dimensionInfo)) {
                        subSet.add(((BgDimensionMember)dimensionInfo.getMember().get(m)).getCombNumber());
                        continue;
                    }
                    subSet.add(((BgDimensionMember)dimensionInfo.getMember().get(m)).getNumber());
                }
            }
        }
        if (queryMap.isEmpty()) {
            return;
        }
        HashMap mdxCacheMap = (HashMap)BgDimCacheUtils.getItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber");
        if (mdxCacheMap == null) {
            mdxCacheMap = new HashMap();
        }
        Connection conn = null;
        Map<Object, Object> factDataMap = null;
        String[] factData = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            for (String field2 : queryMap.keySet()) {
                dimensionInfo = (BgDimensionBaseInfo)dimensionMap.get(field2);
                Map dimNumMap = null;
                if (mdxCacheMap.containsKey(field2)) {
                    dimNumMap = (Map)mdxCacheMap.get(field2);
                } else {
                    dimNumMap = new HashMap();
                    mdxCacheMap.put(field2, dimNumMap);
                }
                String viewId = null;
                if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(field2)) {
                    viewId = parameter.getBgOrgViewId().toString();
                    if (parameter.getUnionId() != null) {
                        viewId = parameter.getUnionId().toString();
                    }
                } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimensionInfo.getNumber())) {
                    viewId = DimensionConstants.DEF_ELEMENT_NUMBER;
                } else if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) {
                    viewId = DimensionConstants.DEF_SCENARIO_NUMBER;
                } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimensionInfo.getNumber())) {
                    viewId = DimensionConstants.DEF_VERSION_NUMBER;
                } else {
                    BOSUuid tmpUuId = parameter.getDataManager().getBgScheme().getViewId(dimensionInfo.getNumber());
                    if (tmpUuId != null) {
                        viewId = tmpUuId.toString();
                    }
                }
                Map<String, String[]> mdxNumMap = null;
                if (dimNumMap.containsKey(viewId)) {
                    mdxNumMap = (Map)dimNumMap.get(viewId);
                } else {
                    mdxNumMap = new HashMap();
                    dimNumMap.put(viewId, mdxNumMap);
                }
                long st1 = System.currentTimeMillis();
                factDataMap = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber()) ? (parameter.getUnionId() != null ? DimUtils.getUnionUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), (Collection)queryMap.get(field2)) : DimUtils.getBgOrgUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), (Collection)queryMap.get(field2))) : (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimensionInfo.getNumber()) ? BgElementHelper.getElementLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber()) ? BgScenarioHelper.getScenarioLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_VERSION_NUMBER.equals(dimensionInfo.getNumber()) ? BgVersionHelper.getVersionLongNum((Connection)conn, (Locale)ctx.getLocale()) : MbgVirtualView.getFactData((Context)ctx, (TempTablePool)parameter.getTempTableManager(ctx).getTempTablePool(), (Connection)conn, (BOSUuid)BOSUuid.read((String)viewId), (Collection)((Collection)queryMap.get(field2))))));
                logger.info((Object)("MbgVirtualView.getFactData :" + dimensionInfo.getNumber() + " ms:" + (System.currentTimeMillis() - st1)));
                if (factDataMap == null) continue;
                for (String number : factDataMap.keySet()) {
                    if (!factDataMap.containsKey(number)) continue;
                    factData = (String[])factDataMap.get(number);
                    mdxNumMap.put(number, factData);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        BgDimCacheUtils.putItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber", mdxCacheMap);
    }

    private static void transRowColMembers(Context ctx, IBgDimensionManagerBase dimensionBase, IDimensionParameter parameter, IQueryData queryData, int formType, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        int i;
        int in;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        Object _tmpDim = null;
        Object mbgDim = null;
        BgDimensionBaseInfo dimensionInfo = null;
        List tmpList = dimensionBase.getRowDisplayDimension();
        if (formType == 0 || formType == 8) {
            tmpList = dimensionBase.getRowDimension();
        }
        if (tmpList != null && !tmpList.isEmpty()) {
            in = tmpList.size();
            for (i = 0; i < in; ++i) {
                dimensionInfo = (BgDimensionBaseInfo)tmpList.get(i);
                dimension = DimUtils.transDimension(ctx, parameter, dimensionInfo, mbgDimMap);
                DimUtils.AddDimensionToParameter(ctx, parameter, dimension, parameter.getRowDims(), queryData);
            }
        }
        tmpList = dimensionBase.getColDisplayDimension();
        if (formType == 0 || formType == 8) {
            tmpList = dimensionBase.getColDimension();
        }
        if (tmpList != null && !tmpList.isEmpty()) {
            in = tmpList.size();
            for (i = 0; i < in; ++i) {
                dimensionInfo = (BgDimensionBaseInfo)tmpList.get(i);
                dimension = DimUtils.transDimension(ctx, parameter, dimensionInfo, mbgDimMap);
                DimUtils.AddDimensionToParameter(ctx, parameter, dimension, parameter.getColDims(), queryData);
            }
        }
    }

    private static void transViewListRowColMembers(Context ctx, MbgViewListDimensionManager dimensionManager, IDimensionParameter parameter, IQueryData queryData, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        Object _tmpDim = null;
        Object mbgDim = null;
        MbgViewListDimensionInfo dimensionInfo2 = null;
        List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
        HashMap<String, MbgViewListDimensionInfo> dimMap = new HashMap<String, MbgViewListDimensionInfo>();
        for (int r = 0; r < rowCols.size(); ++r) {
            if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol object = (MbgViewListRowCol)rowCols.get(r);
            List<MbgViewListDimensionInfo> dimens = object.getDimensions();
            ViewlistCombinHelper.parseCombinMembers(object, false);
            for (int d = 0; d < dimens.size(); ++d) {
                if (!(dimens.get(d) instanceof MbgViewListDimensionInfo)) continue;
                dimensionInfo2 = dimens.get(d);
                if (!dimMap.containsKey(dimensionInfo2.getNumber())) {
                    dimMap.put(dimensionInfo2.getNumber(), dimensionInfo2);
                    continue;
                }
                for (int m = 0; m < dimensionInfo2.getMember().size(); ++m) {
                    if (((MbgViewListDimensionInfo)dimMap.get(dimensionInfo2.getNumber())).getMember().contains(dimensionInfo2.getMember().get(m))) continue;
                    ((MbgViewListDimensionInfo)dimMap.get(dimensionInfo2.getNumber())).getMember().add(dimensionInfo2.getMember().get(m));
                }
            }
        }
        if (!dimMap.isEmpty()) {
            for (MbgViewListDimensionInfo dimensionInfo2 : dimMap.values()) {
                dimension = DimUtils.transDimension(ctx, parameter, dimensionInfo2, mbgDimMap);
                if (dimension == null) continue;
                DimUtils.AddDimensionToParameter(ctx, parameter, dimension, parameter.getRowDims(), queryData);
            }
        }
    }

    public static void transMbgDimMember(MbgViewListDimensionManager manager) {
        if (manager == null) {
            return;
        }
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        HashMap<String, BgDimensionBaseInfo> dimsMap = new HashMap<String, BgDimensionBaseInfo>();
        IMbgViewListObject object = null;
        List<MbgViewListDimensionInfo> viewDims = null;
        MbgViewListDimensionInfo viewDim = null;
        HashSet<String> numberSet = new HashSet<String>();
        for (int j = 0; j < manager.getDimension().size(); ++j) {
            if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo)) continue;
            dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
            dimsMap.put(dimInfo.getNumber(), dimInfo);
        }
        List<IMbgViewListObject> rowCols = manager.getRowCols();
        int in = rowCols.size();
        for (int i = 0; i < in; ++i) {
            object = rowCols.get(i);
            if (!(object instanceof MbgViewListRowCol)) continue;
            ViewlistCombinHelper.parseCombinMembers((MbgViewListRowCol)object);
            viewDims = ((MbgViewListRowCol)object).getDimensions();
            if (viewDims == null) continue;
            int jn = viewDims.size();
            for (int j = 0; j < jn; ++j) {
                int x;
                viewDim = viewDims.get(j);
                if (!dimsMap.containsKey(viewDim.getNumber())) continue;
                dimInfo = (BgDimensionBaseInfo)dimsMap.get(viewDim.getNumber());
                if (dimInfo.getMember().isEmpty()) {
                    dimInfo.getMember().addAll(viewDim.getMember());
                    continue;
                }
                numberSet.clear();
                int xn = dimInfo.getMember().size();
                for (x = 0; x < xn; ++x) {
                    member = (BgDimensionMember)dimInfo.getMember().get(x);
                    numberSet.add(member.getNumber());
                }
                xn = viewDim.getMember().size();
                for (x = 0; x < xn; ++x) {
                    member = (BgDimensionMember)viewDim.getMember().get(x);
                    if (numberSet.contains(member.getNumber())) continue;
                    numberSet.add(member.getNumber());
                    dimInfo.getMember().add(member);
                }
            }
        }
    }

    private static void transOtherMembers(Context ctx, IDimensionParameter parameter, IDimDataQuery query) throws Exception {
        if (query != null && 0 == query.getBizState()) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
            MemberObject member = null;
            ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
            dims.addAll(parameter.getRowDims());
            dims.addAll(parameter.getColDims());
            dims.addAll(parameter.getPageDims());
            boolean hasOrgUnitDim = false;
            boolean hasCurrencyDim = false;
            boolean hasBgPeriodDim = false;
            boolean hasScenarioDim = false;
            boolean hasVersionDim = false;
            int in = dims.size();
            for (int i = 0; i < in; ++i) {
                dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i);
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                    hasOrgUnitDim = true;
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    hasCurrencyDim = true;
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    hasBgPeriodDim = true;
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    hasScenarioDim = true;
                    DimUtils.transScenarioNumber(ctx, dimension);
                    continue;
                }
                if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                hasVersionDim = true;
                if (!dimension.getDimensionMember().isEmpty()) continue;
                member = new MemberObject();
                BgVersionInfo version = query.getBizVersion();
                if (version != null) {
                    member.setName(version.getName());
                    member.setNumber(version.getNumber());
                } else {
                    member.setName("Ve");
                    member.setNumber("Ve");
                }
                member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
                dimension.addMember(member);
                DimUtils.queryItemLongNumber(ctx, parameter, dimension);
                DimUtils.transVersionNumber(ctx, dimension);
            }
            FullOrgUnitInfo orgUnitInfo = query.getBizOrgUnit();
            CurrencyInfo currency = query.getBizCurrency();
            if (!hasOrgUnitDim) {
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
                dimension.setField(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
                dimension.setSrcNumber(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
                parameter.getColDims().add(dimension);
                member = new MemberObject();
                member.setNumber(orgUnitInfo.getNumber());
                member.setMdxNumber(orgUnitInfo.getLongNumber());
                dimension.addMember(member);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
            BgPeriodInfo bgPeriod = query.getBizPeriod();
            if (!hasBgPeriodDim && bgPeriod != null) {
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
                dimension.setField(DimensionBaseConstants.DEF_PERIOD_FIELD);
                dimension.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
                parameter.getColDims().add(dimension);
                member = new MemberObject();
                member.setName(bgPeriod.getName());
                member.setNumber(bgPeriod.getNumber());
                member.setMdxNumber(bgPeriod.getLongNumber());
                dimension.addMember(member);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
            if (!hasCurrencyDim) {
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
                dimension.setField(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                dimension.setSrcNumber(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER);
                parameter.getColDims().add(dimension);
                member = new MemberObject();
                member.setName(currency.getName());
                member.setNumber(currency.getNumber());
                dimension.addMember(member);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
            if (!hasScenarioDim) {
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
                dimension.setField(DimensionBaseConstants.DEF_SCENARIO_FIELD);
                dimension.setSrcNumber(DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER);
                parameter.getColDims().add(dimension);
                member = new MemberObject();
                member.setNumber(String.valueOf(BgScenarioHelper.BUDGET_SCENARIO_VALUE));
                member.setInnerId(BgScenarioHelper.BUDGET_SCENARIO_VALUE);
                dimension.addMember(member);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
            if (!(hasVersionDim || parameter.getValueType() != 1 && parameter.getValueType() != 2)) {
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
                dimension.setField(DimensionBaseConstants.DEF_VERSION_FIELD);
                dimension.setSrcNumber(DimensionBaseConstants.DEF_VERSION_SRCNUMBER);
                parameter.getColDims().add(dimension);
                member = new MemberObject();
                member.setNumber(String.valueOf(BgVersionHelper.DEF_VERSION_VALUE));
                member.setInnerId(BgVersionHelper.DEF_VERSION_VALUE);
                dimension.addMember(member);
                parameter.getDimensionMap().put(dimension.getNumber(), dimension);
            }
        }
    }

    public static List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> transDimension(IBgDimensionManager manager, BgFormInfo model) {
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        if (manager == null || model == null) {
            return dims;
        }
        ArrayList bgDims = new ArrayList();
        bgDims.addAll(manager.getRowDimension());
        bgDims.addAll(manager.getColDimension());
        bgDims.addAll(manager.getViewDimension());
        bgDims.addAll(manager.getPageDimension());
        MemberObject member = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        boolean hasCurrencyDim = false;
        boolean hasBgPeriodDim = false;
        for (BgDimensionInfo dimensionInfo : bgDims) {
            dimension = DimUtils.transDimension(dimensionInfo);
            if (dimension == null) continue;
            dims.add(dimension);
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                dimension.setField(DimensionConstants.DEF_ORGUNIT_FIELD);
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                dimension.setField(DimensionConstants.DEF_CURRENCY_FIELD);
                hasCurrencyDim = true;
                continue;
            }
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                dimension.setField(DimensionConstants.DEF_PERIOD_FIELD);
                hasBgPeriodDim = true;
                continue;
            }
            if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                dimension.setField(DimensionConstants.DEF_ELEMENT_FIELD);
                continue;
            }
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                dimension.setField(DimensionConstants.DEF_SCENARIO_FIELD);
                continue;
            }
            if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
            dimension.setField(DimensionConstants.DEF_VERSION_FIELD);
        }
        if (!hasBgPeriodDim) {
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
            dimension.setField(DimensionConstants.DEF_PERIOD_FIELD);
            member = new MemberObject();
            member.setName(model.getBgPeriod().getName());
            member.setNumber(model.getBgPeriod().getNumber());
            dimension.addMember(member);
            dims.add(dimension);
        }
        if (!hasCurrencyDim) {
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
            dimension.setField(DimensionConstants.DEF_CURRENCY_FIELD);
            member = new MemberObject();
            member.setName(model.getCurrency().getName());
            member.setNumber(model.getCurrency().getNumber());
            dimension.addMember(member);
            dims.add(dimension);
        }
        DimUtils.sortDims(dims);
        return dims;
    }

    private static void addDimension(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        if (dims != null && dimension != null) {
            dims.add(dimension);
        }
    }

    private static com.kingdee.eas.ma.mbg.dimension.face.IDimension transDimension(Context ctx, IDimensionParameter parameter, BgDimensionBaseInfo dimensionInfo, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        List memList;
        if (ctx == null || parameter == null || dimensionInfo == null || mbgDimMap == null) {
            return null;
        }
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setAlias(dimensionInfo.getAlias());
        dimension.setField(DimUtils.getDimensionField(dimensionInfo));
        if (mbgDimMap.containsKey(dimension.getNumber())) {
            dimension.setSrcNumber(mbgDimMap.get(dimension.getNumber()).getSrcNumber());
        }
        if ((memList = dimensionInfo.getMember()) != null && !memList.isEmpty()) {
            BgDimensionMember dimensionMember = null;
            com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
            int jn = memList.size();
            for (int j = 0; j < jn; ++j) {
                dimensionMember = (BgDimensionMember)memList.get(j);
                member = DimUtils.transDimMember(dimensionMember);
                if (member == null) continue;
                dimension.addMember(member);
            }
            DimUtils.queryItemLongNumber(ctx, parameter, dimension);
            DimUtils.transScenarioNumber(ctx, dimension);
            DimUtils.transVersionNumber(ctx, dimension);
            DimUtils.transMdxMemberNumber(ctx, parameter, dimension);
        }
        return dimension;
    }

    private static com.kingdee.eas.ma.mbg.dimension.face.IDimension transDimension(BgDimensionInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return null;
        }
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setAlias(dimensionInfo.getAlias());
        dimension.setField(DimUtils.getDimensionField(dimensionInfo));
        List memList = dimensionInfo.getMember();
        if (memList != null && !memList.isEmpty()) {
            BgDimensionMember dimensionMember = null;
            com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
            int jn = memList.size();
            for (int j = 0; j < jn; ++j) {
                dimensionMember = (BgDimensionMember)memList.get(j);
                member = DimUtils.transDimMember(dimensionMember);
                if (member == null) continue;
                dimension.addMember(member);
            }
        }
        return dimension;
    }

    private static com.kingdee.eas.ma.mbg.dimension.face.IDimension transFixedDimension(Context ctx, IDimensionParameter parameter, BgDimensionBaseInfo dimensionInfo, OrgUnitInfo orgUnitInfo, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        if (ctx == null || parameter == null || dimensionInfo == null) {
            return null;
        }
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setAlias(dimensionInfo.getAlias());
        dimension.setField(DimUtils.getDimensionField(dimensionInfo));
        dimension.setSrcNumber(mbgDimMap.get(dimensionInfo.getNumber()).getSrcNumber());
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        List memList = dimensionInfo.getMember();
        if (memList != null && !memList.isEmpty()) {
            member = DimUtils.transDimMember((BgDimensionMember)memList.get(0));
            if (member != null) {
                if (orgUnitInfo != null && memList.size() > 1 && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                    member.setName(orgUnitInfo.getName());
                    member.setNumber(orgUnitInfo.getNumber());
                    member.setMdxNumber(orgUnitInfo.getLongNumber());
                }
                dimension.addMember(member);
                DimUtils.queryItemLongNumber(ctx, parameter, dimension);
                DimUtils.transScenarioNumber(ctx, dimension);
                DimUtils.transVersionNumber(ctx, dimension);
                DimUtils.transMdxMemberNumber(ctx, parameter, dimension);
            }
        } else if (orgUnitInfo != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            member = new MemberObject();
            member.setName(orgUnitInfo.getName());
            member.setNumber(orgUnitInfo.getNumber());
            member.setMdxNumber(orgUnitInfo.getLongNumber());
            dimension.addMember(member);
        }
        return dimension;
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IMember transDimMember(BgDimensionMember dimensionMember) {
        if (dimensionMember == null) {
            return null;
        }
        MemberObject member = new MemberObject();
        member.setName(dimensionMember.getName());
        member.setNumber(dimensionMember.getNumber());
        member.setSrcNumber(dimensionMember.getSrcNumber());
        return member;
    }

    public static Set<String> queryItemNumber(Context ctx, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws Exception {
        Set<String> factDataSet = new HashSet<String>();
        if (conn == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
            return factDataSet;
        }
        factDataSet = MbgVirtualView.queryFactData((Context)ctx, (Connection)conn, (BOSUuid)viewId, queryNums);
        return factDataSet;
    }

    public static Set<String> queryLongNumber(Context ctx, Connection conn, IDimensionParameter parameter, MbgDimInfo mbgDim, Set<String> numbers) throws Exception {
        HashSet<String> longNumSet = new HashSet<String>();
        if (ctx == null || conn == null || mbgDim == null || numbers == null || numbers == null || numbers.isEmpty()) {
            return longNumSet;
        }
        if (DimUtils.checkBaseDimensionByField(mbgDim.getRefField()) || DimensionConstants.DEF_CSL_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_STATE_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(mbgDim.getNumber())) {
            return longNumSet;
        }
        HashMap<String, Map<String, Map<String, String[]>>> mdxCacheMap = (HashMap<String, Map<String, Map<String, String[]>>>)BgDimCacheUtils.getItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber");
        if (mdxCacheMap == null) {
            mdxCacheMap = new HashMap<String, Map<String, Map<String, String[]>>>();
        }
        Map<String, Map<String, String[]>> dimNumMap = null;
        if (mdxCacheMap.containsKey(mbgDim.getRefField())) {
            dimNumMap = (Map)mdxCacheMap.get(mbgDim.getRefField());
        } else {
            dimNumMap = new HashMap();
            mdxCacheMap.put(mbgDim.getRefField(), dimNumMap);
        }
        String viewId = null;
        BOSUuid tmpUuId = parameter.getDataManager().getBgScheme().getViewId(mbgDim.getNumber());
        if (tmpUuId != null) {
            viewId = tmpUuId.toString();
        }
        Map<String, String[]> mdxNumMap = null;
        HashSet<String> querySet = new HashSet<String>();
        if (viewId != null) {
            Map factDataMap;
            if (dimNumMap.containsKey(viewId)) {
                mdxNumMap = (Map)dimNumMap.get(viewId);
            } else {
                mdxNumMap = new HashMap();
                dimNumMap.put(viewId, mdxNumMap);
            }
            if (DimUtils.checkBaseDimensionByField(mbgDim.getRefField())) {
                for (String string : numbers) {
                    if (mdxNumMap.containsKey(string)) {
                        longNumSet.add(((String[])mdxNumMap.get(string))[1]);
                        continue;
                    }
                    querySet.add(string);
                }
            } else {
                String _dimNumber = null;
                for (String number : numbers) {
                    _dimNumber = number.indexOf(":") < 0 ? mbgDim.getSrcNumber() + ":" + number : number;
                    if (mdxNumMap.containsKey(_dimNumber)) {
                        longNumSet.add(((String[])mdxNumMap.get(_dimNumber))[1]);
                        continue;
                    }
                    querySet.add(_dimNumber);
                }
            }
            if (!querySet.isEmpty() && (factDataMap = MbgVirtualView.getFactData((Context)ctx, (TempTablePool)parameter.getTempTableManager(ctx).getTempTablePool(), (Connection)conn, (BOSUuid)BOSUuid.read((String)viewId), querySet)) != null) {
                Object var13_16 = null;
                String[] factData = null;
                for (String string : querySet) {
                    if (!factDataMap.containsKey(string)) continue;
                    factData = (String[])factDataMap.get(string);
                    mdxNumMap.put(string, factData);
                    longNumSet.add(factData[1]);
                }
            }
        }
        return longNumSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> queryItemLongNumber(Context ctx, IDimensionParameter parameter, MbgDimInfo mbgDim, Set<String> dimNums) throws Exception {
        String viewId;
        Map<String, Map<String, String[]>> dimNumMap;
        HashMap<String, Map<String, Map<String, String[]>>> mdxCacheMap;
        HashMap<String, String> dimNumsMap;
        block27: {
            block31: {
                block32: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    dimNumsMap = new HashMap<String, String>();
                                    if (ctx == null || parameter == null || mbgDim == null || dimNums == null || dimNums.isEmpty()) {
                                        return dimNumsMap;
                                    }
                                    if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_CSL_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_STATE_NUMBER.equals(mbgDim.getNumber()) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(mbgDim.getNumber())) {
                                        return dimNumsMap;
                                    }
                                    mdxCacheMap = (HashMap<String, Map<String, Map<String, String[]>>>)BgDimCacheUtils.getItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber");
                                    if (mdxCacheMap == null) {
                                        mdxCacheMap = new HashMap<String, Map<String, Map<String, String[]>>>();
                                    }
                                    dimNumMap = null;
                                    if (mdxCacheMap.containsKey(mbgDim.getRefField())) {
                                        dimNumMap = (Map)mdxCacheMap.get(mbgDim.getRefField());
                                    } else {
                                        dimNumMap = new HashMap();
                                        mdxCacheMap.put(mbgDim.getRefField(), dimNumMap);
                                    }
                                    viewId = null;
                                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) break block26;
                                    viewId = parameter.getBgOrgViewId().toString();
                                    if (parameter.getUnionId() != null) {
                                        viewId = parameter.getUnionId().toString();
                                    }
                                    break block27;
                                }
                                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(mbgDim.getNumber())) break block28;
                                viewId = DimensionConstants.DEF_ELEMENT_NUMBER;
                                break block27;
                            }
                            if (!DimensionConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber())) break block29;
                            viewId = DimensionConstants.DEF_SCENARIO_NUMBER;
                            break block27;
                        }
                        if (!DimensionConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber())) break block30;
                        viewId = DimensionConstants.DEF_VERSION_NUMBER;
                        break block27;
                    }
                    if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) break block31;
                    viewId = DimensionConstants.DEF_PERIOD_NUMBER;
                    if (parameter.getControlManager().isFiscalYear()) break block32;
                    HashSet<String> fiscalYears = new HashSet<String>();
                    Connection conn = null;
                    IRowSet rst = null;
                    try {
                        conn = BgDBUtils.getConnection((Context)ctx);
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_BgPeriodType where FiscalYear = 2");
                        while (rst.next()) {
                            fiscalYears.add(rst.getString(1));
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, null, (Connection)conn);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                    for (String number : dimNums) {
                        if (!fiscalYears.contains(number.split("\\.")[0])) continue;
                        parameter.getControlManager().setFiscalYear(true);
                        DimUtils.transBgPeriodMember(ctx, parameter, parameter.getPeriodDimension(), true);
                        break;
                    }
                }
                if (parameter.getControlManager().isFiscalYear()) {
                    viewId = DimensionConstants.DEF_FISCAL_PERIOD_NUMBER;
                }
                break block27;
            }
            BOSUuid tmpUuId = parameter.getDataManager().getBgScheme().getViewId(mbgDim.getNumber());
            if (tmpUuId != null) {
                viewId = tmpUuId.toString();
            }
        }
        Map<String, String[]> mdxNumMap = null;
        if (dimNumMap.containsKey(viewId)) {
            mdxNumMap = (Map)dimNumMap.get(viewId);
        } else {
            mdxNumMap = new HashMap();
            dimNumMap.put(viewId, mdxNumMap);
        }
        HashSet<String> querySet = new HashSet<String>();
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) {
            for (String number : dimNums) {
                querySet.add(number);
            }
        } else {
            for (String number : dimNums) {
                if (mdxNumMap.containsKey(number)) {
                    dimNumsMap.put(number, ((String[])mdxNumMap.get(number))[1]);
                    continue;
                }
                querySet.add(number);
            }
        }
        if (!querySet.isEmpty()) {
            String number2 = null;
            String[] factData = null;
            Map<Object, Object> factDataMap = null;
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                factDataMap = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber()) ? (parameter.getUnionId() != null ? DimUtils.getUnionUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), querySet) : DimUtils.getBgOrgUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), querySet)) : (DimensionConstants.DEF_ELEMENT_NUMBER.equals(mbgDim.getNumber()) ? BgElementHelper.getElementLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber()) ? BgScenarioHelper.getScenarioLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber()) ? BgVersionHelper.getVersionLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber()) ? BgPeriodHelper.getBgPeriodColls((Connection)conn, (Locale)ctx.getLocale(), (boolean)parameter.getControlManager().isFiscalYear()) : MbgVirtualView.getFactData((Context)ctx, (TempTablePool)parameter.getTempTableManager(ctx).getTempTablePool(), (Connection)conn, (BOSUuid)BOSUuid.read((String)viewId), querySet)))));
                if (factDataMap != null) {
                    for (String number2 : querySet) {
                        if (!factDataMap.containsKey(number2)) continue;
                        factData = (String[])factDataMap.get(number2);
                        mdxNumMap.put(number2, factData);
                        dimNumsMap.put(number2, factData[1]);
                    }
                }
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            BgDimCacheUtils.putItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber", mdxCacheMap);
        }
        return dimNumsMap;
    }

    public static String transFields(String field) {
        String _field = field;
        if ("F-1".equals(field)) {
            _field = DimensionBaseConstants.DEF_PERIOD_FIELD;
        } else if ("F-2".equals(field)) {
            _field = DimensionBaseConstants.DEF_ELEMENT_FIELD;
        } else if ("F-3".equals(field)) {
            _field = DimensionBaseConstants.DEF_CURRENCY_FIELD;
        } else if ("F-4".equals(field)) {
            _field = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
        }
        return _field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryItemLongNumber(Context ctx, IDimensionParameter parameter, IDimensionBase dimension) throws Exception {
        int i;
        int in;
        if (ctx == null || parameter == null || dimension == null) {
            return;
        }
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CSL_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_STATE_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        String number = null;
        IMemberBase member = null;
        boolean hasBaseMbgDim = DimUtils.checkBaseDimension(dimension);
        HashMap<String, Map<String, Map<String, String[]>>> mdxCacheMap = (HashMap<String, Map<String, Map<String, String[]>>>)BgDimCacheUtils.getItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber");
        if (mdxCacheMap == null) {
            mdxCacheMap = new HashMap<String, Map<String, Map<String, String[]>>>();
        }
        String field = DimUtils.transFields(dimension.getField());
        Map<String, Map<String, String[]>> dimNumMap = null;
        if (mdxCacheMap.containsKey(field)) {
            dimNumMap = (Map)mdxCacheMap.get(field);
        } else {
            dimNumMap = new HashMap();
            mdxCacheMap.put(field, dimNumMap);
        }
        String viewId = null;
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            viewId = parameter.getBgOrgViewId().toString();
            if (parameter.getUnionId() != null) {
                viewId = parameter.getUnionId().toString();
            }
        } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
            viewId = DimensionConstants.DEF_ELEMENT_NUMBER;
        } else if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
            viewId = DimensionConstants.DEF_SCENARIO_NUMBER;
        } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) {
            viewId = DimensionConstants.DEF_VERSION_NUMBER;
        } else {
            BOSUuid tmpUuId = parameter.getDataManager().getBgScheme().getViewId(dimension.getNumber());
            if (tmpUuId != null) {
                viewId = tmpUuId.toString();
            }
        }
        Map<String, String[]> mdxNumMap = null;
        if (dimNumMap.containsKey(viewId)) {
            mdxNumMap = (Map)dimNumMap.get(viewId);
        } else {
            mdxNumMap = new HashMap();
            dimNumMap.put(viewId, mdxNumMap);
        }
        HashMap<String, IMemberBase> queryMap = new HashMap<String, IMemberBase>();
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            in = dimension.getDimensionMember().size();
            for (i = 0; i < in; ++i) {
                member = dimension.getDimensionMember().get(i);
                number = member.getNumber();
                if (mdxNumMap.containsKey(number)) {
                    member.setItemLongNumber(((String[])mdxNumMap.get(number))[1]);
                    continue;
                }
                queryMap.put(number, member);
            }
        } else {
            in = dimension.getDimensionMember().size();
            for (i = 0; i < in; ++i) {
                member = dimension.getDimensionMember().get(i);
                number = hasBaseMbgDim ? member.getNumber() : member.getDimNumber();
                if (mdxNumMap.containsKey(number)) {
                    member.setItemLongNumber(((String[])mdxNumMap.get(number))[1]);
                    continue;
                }
                queryMap.put(number, member);
            }
        }
        if (!queryMap.isEmpty()) {
            String[] factData = null;
            Map<Object, Object> factDataMap = null;
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                factDataMap = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) ? (parameter.getUnionId() != null ? DimUtils.getUnionUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), queryMap.keySet()) : DimUtils.getBgOrgUnitMap(ctx, parameter, parameter.getTempTableManager(ctx).getTempTablePool(), conn, BOSUuid.read((String)viewId), queryMap.keySet())) : (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) ? BgElementHelper.getElementLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) ? BgScenarioHelper.getScenarioLongNum((Connection)conn, (Locale)ctx.getLocale()) : (DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()) ? BgVersionHelper.getVersionLongNum((Connection)conn, (Locale)ctx.getLocale()) : MbgVirtualView.getFactData((Context)ctx, (TempTablePool)parameter.getTempTableManager(ctx).getTempTablePool(), (Connection)conn, (BOSUuid)BOSUuid.read((String)viewId), queryMap.keySet()))));
                if (factDataMap != null) {
                    int in2 = dimension.getDimensionMember().size();
                    for (int i2 = 0; i2 < in2; ++i2) {
                        member = dimension.getDimensionMember().get(i2);
                        number = hasBaseMbgDim ? member.getNumber() : member.getDimNumber();
                        if (!factDataMap.containsKey(number)) continue;
                        factData = (String[])factDataMap.get(number);
                        mdxNumMap.put(number, factData);
                        member.setId(factData[3]);
                        member.setItemLongNumber(factData[1]);
                    }
                }
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            BgDimCacheUtils.putItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber", mdxCacheMap);
        }
    }

    public static Map<String, Map<String, String[]>> queryMemberCache(Context ctx, BgSchemeInfo bgScheme, Map<String, Set<String>> queryNumMap, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        HashMap<String, Map<String, String[]>> dimCacheMap = new HashMap<String, Map<String, String[]>>();
        if (ctx == null || queryNumMap == null || mbgDimMap == null) {
            return dimCacheMap;
        }
        HashMap mdxCacheMap = (HashMap)BgDimCacheUtils.getItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber");
        if (mdxCacheMap == null) {
            mdxCacheMap = new HashMap();
        }
        Map.Entry<String, Set<String>> entry2 = null;
        String field = null;
        String[] caches = null;
        Set<String> querySet = null;
        HashSet<String> numberSet = new HashSet<String>();
        Map periodMap = null;
        Map dimNumMap = null;
        Map<String, String[]> cacheMap = null;
        Map mdxNumMap = null;
        for (Map.Entry<String, Set<String>> entry2 : queryNumMap.entrySet()) {
            field = entry2.getKey();
            querySet = entry2.getValue();
            if (querySet == null || querySet.isEmpty() || field.equals(DimensionConstants.DEF_PROCESS_FIELD)) continue;
            if (DimensionConstants.DEF_PERIOD_FIELD.equals(field)) {
                HashMap periodCacheMap;
                dimNumMap = (HashMap)mdxCacheMap.get(field);
                if (dimNumMap != null) {
                    mdxNumMap = (HashMap)dimNumMap.get(DimensionConstants.DEF_PERIOD_NUMBER);
                }
                if ((periodCacheMap = (HashMap)BgDimCacheUtils.getObject((Context)ctx, (String)BgPeriodCacheUtils.BUDGET_DIM_BGPERIODDISP_CACHE)) == null) {
                    periodCacheMap = new HashMap();
                }
                if (dimCacheMap.containsKey(field)) {
                    cacheMap = (Map)dimCacheMap.get(field);
                } else {
                    cacheMap = new HashMap();
                    dimCacheMap.put(field, cacheMap);
                }
                for (String number : querySet) {
                    if (mdxNumMap != null && mdxNumMap.containsKey(number)) {
                        cacheMap.put(number, (String[])mdxNumMap.get(number));
                        continue;
                    }
                    if (!periodCacheMap.containsKey(number)) continue;
                    periodMap = (Map)periodCacheMap.get(number);
                    for (String[] periodNum : periodMap.values()) {
                        cacheMap.put(number, periodNum);
                    }
                }
                continue;
            }
            numberSet.clear();
            if (mdxCacheMap.containsKey(field)) {
                dimNumMap = (Map)mdxCacheMap.get(field);
            } else {
                dimNumMap = new HashMap();
                mdxCacheMap.put(field, dimNumMap);
            }
            if (dimCacheMap.containsKey(field)) {
                cacheMap = (Map)dimCacheMap.get(field);
            } else {
                cacheMap = new HashMap();
                dimCacheMap.put(field, cacheMap);
            }
            String viewId = null;
            if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                viewId = bgScheme.getEditOrgViewId().toString();
            } else if (DimensionConstants.DEF_ELEMENT_FIELD.equals(field)) {
                viewId = DimensionConstants.DEF_ELEMENT_NUMBER;
            } else if (DimensionConstants.DEF_SCENARIO_FIELD.equals(field)) {
                viewId = DimensionConstants.DEF_SCENARIO_NUMBER;
            } else if (DimensionConstants.DEF_VERSION_FIELD.equals(field)) {
                viewId = DimensionConstants.DEF_VERSION_NUMBER;
            } else {
                BOSUuid tmpUuId = bgScheme.getViewId(mbgDimMap.get(field).getNumber());
                if (tmpUuId != null) {
                    viewId = tmpUuId.toString();
                }
            }
            if (dimNumMap.containsKey(viewId)) {
                mdxNumMap = (Map)dimNumMap.get(viewId);
                for (String number : querySet) {
                    if (mdxNumMap.containsKey(number)) {
                        caches = (String[])mdxNumMap.get(number);
                        if (caches[2] != null) {
                            cacheMap.put(number, caches);
                            continue;
                        }
                        numberSet.add(number);
                        continue;
                    }
                    numberSet.add(number);
                }
            } else {
                mdxNumMap = new HashMap();
                dimNumMap.put(viewId, mdxNumMap);
                numberSet.addAll(querySet);
            }
            if (!numberSet.isEmpty()) {
                Map<String, IMember> members = null;
                IMember member = null;
                if (!DimUtils.checkBaseDimensionByField(field) && (members = DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field) ? MbgDataHelper.getBgAccountFromNumber(ctx, viewId, numberSet) : MbgDataHelper.getMbgMemberFromNumber(ctx, viewId, numberSet)) != null && !members.isEmpty()) {
                    for (String number : numberSet) {
                        if (!members.containsKey(number)) continue;
                        member = members.get(number);
                        if (mdxNumMap != null && mdxNumMap.containsKey(number)) {
                            caches = (String[])mdxNumMap.get(number);
                        } else {
                            caches = new String[3];
                            caches[0] = member.getNumber();
                        }
                        caches[2] = member.getName();
                        cacheMap.put(number, caches);
                    }
                }
            }
            BgDimCacheUtils.putItemLongNumber((Context)ctx, (String)"BudgetDimDataCache-ItemNumber", mdxCacheMap);
        }
        return dimCacheMap;
    }

    public static Map<String, String[]> getUnionUnitMap(Context ctx, IDimensionParameter parameter, TempTablePool pool, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws SQLException, EASBizException {
        HashMap<String, String[]> orgDataMap = new HashMap<String, String[]>();
        if (ctx == null || pool == null || conn == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
            return orgDataMap;
        }
        String tmpTable = null;
        String orgUnitTable = null;
        String sql = null;
        String[] orgUnitStrs = null;
        IRowSet rst = null;
        try {
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"Create Table TEML_KSQL_0 (FNumber NVARCHAR(80))");
            if (tmpTable != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) Values (?)"), queryNums);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FTable from T_MBG_BgVirtualView where FId = ?", (Object[])new Object[]{viewId.toString()});
                if (rst.next()) {
                    orgUnitTable = rst.getString("FTable");
                }
                SQLUtils.cleanup((ResultSet)rst);
                sql = "select t.FID, t.FNumber, t.FLongNumber, u.FName_" + ctx.getLocale() + " AS FName from " + orgUnitTable + " t left join T_ORG_BaseUnit u on t.FID = u.FID where exists (select FNumber from " + tmpTable + " where FNumber = t.FNumber)";
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql);
                while (rst.next()) {
                    orgUnitStrs = new String[]{rst.getString("FNumber"), rst.getString("FLongNumber"), rst.getString("FName"), rst.getString("FID")};
                    orgDataMap.put(orgUnitStrs[0], orgUnitStrs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"createDBTmpTable Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        return orgDataMap;
    }

    public static Map<String, String[]> getBgOrgUnitMap(Context ctx, IDimensionParameter parameter, TempTablePool pool, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws SQLException, EASBizException {
        HashMap<String, String[]> orgDataMap;
        block22: {
            orgDataMap = new HashMap<String, String[]>();
            if (ctx == null || pool == null || conn == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
                return orgDataMap;
            }
            String tmpTable = null;
            String rootOrgNum = null;
            String treeSnap = null;
            String sql = null;
            String[] orgUnitStrs = null;
            BgOrgUnitInfo bgOrgUnit = null;
            HashMap rootOrgNums = new HashMap();
            List<BgOrgUnitInfo> tmpList = null;
            IRowSet rst = null;
            try {
                tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"Create Table TEML_KSQL_0 (FNumber NVARCHAR(80))");
                if (tmpTable == null) break block22;
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) Values (?)"), queryNums);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FSnapTreeVar from T_MBG_BgOrgView where FId = ?", (Object[])new Object[]{viewId.toString()});
                if (rst.next()) {
                    treeSnap = rst.getString("FSnapTreeVar");
                }
                SQLUtils.cleanup((ResultSet)rst);
                sql = "select FID, FNumber, FLongNumber, FName_" + ctx.getLocale() + " AS FName from T_MBG_BgOrgUnit where FViewId = ? and exists (select FNumber from " + tmpTable + " where FNumber = T_MBG_BgOrgUnit.FNumber)";
                if (treeSnap == null || treeSnap.trim().length() == 0) {
                    sql = sql + " and FisVirtual = 0";
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{viewId.toString()});
                    while (rst.next()) {
                        bgOrgUnit = new BgOrgUnitInfo();
                        bgOrgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                        bgOrgUnit.setNumber(rst.getString("FNumber"));
                        bgOrgUnit.setLongNumber(rst.getString("FLongNumber"));
                        bgOrgUnit.setName(rst.getString("FName"));
                        orgUnitStrs = new String[4];
                        orgUnitStrs[0] = bgOrgUnit.getNumber();
                        orgUnitStrs[1] = bgOrgUnit.getLongNumber();
                        orgUnitStrs[2] = bgOrgUnit.getName();
                        orgDataMap.put(bgOrgUnit.getNumber(), orgUnitStrs);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    break block22;
                }
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{viewId.toString()});
                while (rst.next()) {
                    bgOrgUnit = new BgOrgUnitInfo();
                    bgOrgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgOrgUnit.setNumber(rst.getString("FNumber"));
                    bgOrgUnit.setLongNumber(rst.getString("FLongNumber"));
                    bgOrgUnit.setName(rst.getString("FName"));
                    rootOrgNum = bgOrgUnit.getLongNumber().split("!")[0];
                    if (rootOrgNums.containsKey(rootOrgNum)) {
                        tmpList = (List)rootOrgNums.get(rootOrgNum);
                    } else {
                        tmpList = new ArrayList();
                        rootOrgNums.put(rootOrgNum, tmpList);
                    }
                    tmpList.add(bgOrgUnit);
                }
                SQLUtils.cleanup((ResultSet)rst);
                Map.Entry entry2 = null;
                if (rootOrgNums.size() > 1) {
                    int i;
                    int in;
                    String ccOrgRootNum = parameter.getDataManager().getBgOrgUnit().getLongNumber().split("!")[0];
                    if (!rootOrgNums.containsKey(ccOrgRootNum) || ((List)rootOrgNums.get(ccOrgRootNum)).size() != queryNums.size()) {
                        for (String rn : rootOrgNums.keySet()) {
                            if (((List)rootOrgNums.get(rn)).size() != queryNums.size()) continue;
                            ccOrgRootNum = rn;
                            break;
                        }
                    }
                    HashMap<String, String> orgFactMap = new HashMap<String, String>();
                    String[] tmpStr = treeSnap.split(",");
                    if (tmpStr != null) {
                        String[] tmpFact = null;
                        in = tmpStr.length;
                        for (i = 0; i < in; ++i) {
                            if (StringUtils.isEmpty((String)tmpStr[i])) continue;
                            tmpFact = tmpStr[i].split("!");
                            orgFactMap.put(tmpFact[0], tmpFact[1]);
                        }
                    }
                    for (Map.Entry entry2 : rootOrgNums.entrySet()) {
                        tmpList = (List)entry2.getValue();
                        if (!ccOrgRootNum.equals(entry2.getKey())) continue;
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgOrgUnit where FViewId = ? and FNumber = ?", (Object[])new Object[]{viewId.toString(), entry2.getKey()});
                        if (rst.next()) {
                            parameter.getDataManager().setOrgFactTable(MbgVirtualView.getBgOrgFactTable((String)((String)orgFactMap.get(rst.getString("FID")))));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        in = tmpList.size();
                        for (i = 0; i < in; ++i) {
                            bgOrgUnit = (BgOrgUnitInfo)tmpList.get(i);
                            orgUnitStrs = new String[4];
                            orgUnitStrs[0] = bgOrgUnit.getNumber();
                            orgUnitStrs[1] = bgOrgUnit.getLongNumber();
                            orgUnitStrs[2] = bgOrgUnit.getName();
                            orgDataMap.put(bgOrgUnit.getNumber(), orgUnitStrs);
                        }
                        break block22;
                    }
                    break block22;
                }
                for (Map.Entry entry2 : rootOrgNums.entrySet()) {
                    tmpList = (ArrayList)entry2.getValue();
                    int in = tmpList.size();
                    for (int i = 0; i < in; ++i) {
                        bgOrgUnit = (BgOrgUnitInfo)tmpList.get(i);
                        orgUnitStrs = new String[4];
                        orgUnitStrs[0] = bgOrgUnit.getNumber();
                        orgUnitStrs[1] = bgOrgUnit.getLongNumber();
                        orgUnitStrs[2] = bgOrgUnit.getName();
                        orgDataMap.put(bgOrgUnit.getNumber(), orgUnitStrs);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"createDBTmpTable Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
            }
        }
        return orgDataMap;
    }

    private static void removeOrgRangeScope(List<BizCalcInfo> calcs) {
        if (calcs == null || calcs.isEmpty()) {
            return;
        }
        BizCalcSubsetInfo subset = null;
        BizScopeInfo scope = null;
        BizScopeCollection colls = new BizScopeCollection();
        for (BizCalcInfo calc : calcs) {
            int in = calc.getBizCalcSubset().size();
            for (int i = 0; i < in; ++i) {
                int j;
                subset = calc.getBizCalcSubset().get(i);
                colls.clear();
                int jn = subset.getScope().size();
                for (j = 0; j < jn; ++j) {
                    scope = subset.getScope().get(j);
                    if (!DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(scope.getRefField())) continue;
                    colls.add(scope);
                }
                if (colls.isEmpty()) continue;
                jn = colls.size();
                for (j = 0; j < jn; ++j) {
                    scope = colls.get(j);
                    subset.getScope().removeObject((IObjectValue)scope);
                }
            }
        }
    }

    public static void transScenarioAndVersion(Context ctx, IDimensionParameter parameter) throws SQLException, BOSException {
        BgVersionCollection _bgVerColls;
        HashMap<String, String> scInnNumMap = new HashMap<String, String>();
        HashMap<String, String> scNumInnMap = new HashMap<String, String>();
        HashMap<String, String> verInnNumMap = new HashMap<String, String>();
        HashMap<String, String> verNumInnMap = new HashMap<String, String>();
        HashMap<String, BgScenarioInfo> scenaioMap = new HashMap<String, BgScenarioInfo>();
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        BgScenarioInfo _scenario = null;
        BgVersionInfo _version = null;
        BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Context)ctx);
        if (_bgScenColls != null) {
            int in = _bgScenColls.size();
            for (int i = 0; i < in; ++i) {
                _scenario = _bgScenColls.get(i);
                scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
                scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                scenaioMap.put(_scenario.getNumber(), _scenario);
            }
        }
        if ((_bgVerColls = BgVersionHelper.getVersionColls((Context)ctx)) != null) {
            int in = _bgVerColls.size();
            for (int i = 0; i < in; ++i) {
                _version = _bgVerColls.get(i);
                verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                versionMap.put(_version.getNumber(), _version);
            }
        }
        parameter.getDataManager().getBgScenarioMap().putAll(scenaioMap);
        parameter.getDataManager().getBgVersionMap().putAll(versionMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, verInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
    }

    public static void transScenarioAndVersion(Context ctx, Connection conn, IDimensionParameter parameter, Map<String, String> params) throws SQLException {
        if (ctx == null || conn == null || parameter == null) {
            return;
        }
        HashMap<String, String> innNumMap = new HashMap<String, String>();
        HashMap<String, String> numInnMap = new HashMap<String, String>();
        Object var6_6 = null;
        if (!parameter.getDataManager().getInnNumMap().containsKey(DimensionConstants.DEF_SCENARIO_FIELD) && !parameter.getDataManager().getNumInnMap().containsKey(DimensionConstants.DEF_SCENARIO_FIELD)) {
            if (parameter.getDataManager().getBgScenarioMap().isEmpty()) {
                BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Connection)conn, (Locale)ctx.getLocale());
                if (_bgScenColls != null) {
                    int in = _bgScenColls.size();
                    for (int i = 0; i < in; ++i) {
                        BgScenarioInfo bgScenarioInfo = _bgScenColls.get(i);
                        innNumMap.put(String.valueOf(bgScenarioInfo.getScenarioId()), bgScenarioInfo.getNumber());
                        numInnMap.put(bgScenarioInfo.getNumber(), String.valueOf(bgScenarioInfo.getScenarioId()));
                        parameter.getDataManager().getBgScenarioMap().put(bgScenarioInfo.getNumber(), (IObjectValue)bgScenarioInfo);
                    }
                }
            } else {
                for (BgScenarioInfo bgScenarioInfo : parameter.getDataManager().getBgScenarioMap().values()) {
                    innNumMap.put(String.valueOf(bgScenarioInfo.getScenarioId()), bgScenarioInfo.getNumber());
                    numInnMap.put(bgScenarioInfo.getNumber(), String.valueOf(bgScenarioInfo.getScenarioId()));
                }
            }
            parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, innNumMap);
            parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, numInnMap);
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getScenarioDimension();
        if (dimension != null) {
            int in = dimension.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                member = dimension.getDimensionMember().get(i);
                if (!parameter.getDataManager().getBgScenarioMap().containsKey(member.getNumber())) continue;
                BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)parameter.getDataManager().getBgScenarioMap().get(member.getNumber());
                if (bgScenarioInfo.getType().getValue() == 0) {
                    if (params == null) continue;
                    params.put(DimensionConstants.SCENARIO_BUDGET, Boolean.TRUE.toString());
                    continue;
                }
                if (bgScenarioInfo.getType().getValue() != 1 || params == null) continue;
                params.put(DimensionConstants.SCENARIO_ACTUAL, Boolean.TRUE.toString());
            }
            if (!parameter.getQuerys().isEmpty()) {
                for (IQueryData query : parameter.getQuerys()) {
                    IDimension scenario = query.getMbgDimMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
                    if (scenario == null) continue;
                    for (int i = 0; i < scenario.getMembers().size(); ++i) {
                        IMember _member = scenario.getMembers().get(i);
                        if (!parameter.getDataManager().getBgScenarioMap().containsKey(_member.getNumber())) continue;
                        BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)parameter.getDataManager().getBgScenarioMap().get(_member.getNumber());
                        if (bgScenarioInfo.getType().getValue() == 0) {
                            if (params == null) continue;
                            params.put(DimensionConstants.SCENARIO_BUDGET, Boolean.TRUE.toString());
                            continue;
                        }
                        if (bgScenarioInfo.getType().getValue() != 1 || params == null) continue;
                        params.put(DimensionConstants.SCENARIO_ACTUAL, Boolean.TRUE.toString());
                    }
                }
            }
        } else if (parameter.getDataManager().getDefScenario() != null) {
            BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)parameter.getDataManager().getBgScenarioMap().get(parameter.getDataManager().getDefScenario()[0]);
            if (bgScenarioInfo.getType().getValue() == 0) {
                if (params != null) {
                    params.put(DimensionConstants.SCENARIO_BUDGET, Boolean.TRUE.toString());
                }
            } else if (bgScenarioInfo.getType().getValue() == 1 && params != null) {
                params.put(DimensionConstants.SCENARIO_ACTUAL, Boolean.TRUE.toString());
            }
        }
        if (!parameter.getDataManager().getInnNumMap().containsKey(DimensionConstants.DEF_VERSION_FIELD) && !parameter.getDataManager().getNumInnMap().containsKey(DimensionConstants.DEF_VERSION_FIELD) && parameter.getDataManager().getBgVersionMap().isEmpty()) {
            innNumMap = new HashMap();
            numInnMap = new HashMap();
            BgVersionCollection _bgVerColls = BgVersionHelper.getVersionColls((Connection)conn, (Locale)ctx.getLocale());
            if (_bgVerColls != null) {
                BgVersionInfo _version = null;
                int in = _bgVerColls.size();
                for (int i = 0; i < in; ++i) {
                    _version = _bgVerColls.get(i);
                    innNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                    numInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                    parameter.getDataManager().getBgVersionMap().put(_version.getNumber(), (IObjectValue)_version);
                }
            }
            parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, innNumMap);
            parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, numInnMap);
        }
    }

    public static void transScenarioNumber(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) throws BOSException {
        if (ctx == null || dimension == null) {
            return;
        }
        if (!DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        boolean hasSave = false;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        BgScenarioInfo scenario = null;
        Map scenarioMap = BgDimCacheUtils.getScenarioCache((Context)ctx);
        Map bgScenarioObjMap = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            if (!scenarioMap.containsKey(member.getNumber())) {
                hasSave = true;
                bgScenarioObjMap = BgScenarioHelper.getScenariooObjMap((Context)ctx);
                Map.Entry entry2 = null;
                for (Map.Entry entry2 : bgScenarioObjMap.entrySet()) {
                    if (scenarioMap.containsKey(entry2.getKey())) continue;
                    scenarioMap.put(entry2.getKey(), entry2.getValue());
                }
            }
            if ((scenario = (BgScenarioInfo)scenarioMap.get(member.getNumber())) == null || member.getInnerId() != -1) continue;
            if (!StringUtils.isEmpty((String)member.getMdxNumber())) {
                String[] tmpStrs;
                StringBuffer mdx = new StringBuffer();
                for (String num : tmpStrs = member.getMdxNumber().split("!")) {
                    if (!scenarioMap.containsKey(num)) continue;
                    scenario = (BgScenarioInfo)scenarioMap.get(num);
                    mdx.append(String.valueOf(scenario.getScenarioId()) + "!");
                }
                if (mdx.length() > 0) {
                    mdx.delete(mdx.length() - 1, mdx.length());
                }
                if (mdx.length() > 0) {
                    member.setMdxNumber(mdx.toString());
                }
            }
            member.setInnerId(scenario.getScenarioId());
        }
        if (hasSave) {
            BgDimCacheUtils.saveObject((Context)ctx, (String)"BudgetDimDataCache-Scenario", (Map)scenarioMap);
        }
    }

    public static String transScenarioNumber(Context ctx, String scenarioNum) throws BOSException {
        if (ctx == null || scenarioNum == null) {
            return scenarioNum;
        }
        BgScenarioInfo scenario = null;
        Map scenarioMap = BgDimCacheUtils.getScenarioCache((Context)ctx);
        if (scenarioMap.containsKey(scenarioNum)) {
            scenario = (BgScenarioInfo)scenarioMap.get(scenarioNum);
            return String.valueOf(scenario.getScenarioId());
        }
        return scenarioNum;
    }

    public static void restoreScenarioNumber(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, Map<String, String> bgScenarioMap) {
        if (dimension == null || bgScenarioMap == null || bgScenarioMap.isEmpty()) {
            return;
        }
        if (!DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            if (!bgScenarioMap.containsKey(member.getNumber())) continue;
            member.setNumber(bgScenarioMap.get(member.getNumber()));
        }
    }

    public static void transVersionNumber(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) throws BOSException {
        if (ctx == null || dimension == null) {
            return;
        }
        if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        boolean hasSave = false;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        BgVersionInfo version = null;
        Map versionMap = BgDimCacheUtils.getVersionCache((Context)ctx);
        Map bgVersionObjMap = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            if (!versionMap.containsKey(member.getNumber())) {
                hasSave = true;
                bgVersionObjMap = BgVersionHelper.getVersionObjMap((Context)ctx);
                Map.Entry entry2 = null;
                for (Map.Entry entry2 : bgVersionObjMap.entrySet()) {
                    if (versionMap.containsKey(entry2.getKey())) continue;
                    versionMap.put(entry2.getKey(), entry2.getValue());
                }
            }
            if ((version = (BgVersionInfo)versionMap.get(member.getNumber())) == null || member.getInnerId() != -1) continue;
            if (!StringUtils.isEmpty((String)member.getMdxNumber())) {
                String[] tmpStrs;
                StringBuffer mdx = new StringBuffer();
                for (String num : tmpStrs = member.getMdxNumber().split("!")) {
                    if (!versionMap.containsKey(num)) continue;
                    version = (BgVersionInfo)versionMap.get(num);
                    mdx.append(String.valueOf(version.getVersionId()) + "!");
                }
                if (mdx.length() > 0) {
                    mdx.delete(mdx.length() - 1, mdx.length());
                }
                if (mdx.length() > 0) {
                    member.setMdxNumber(mdx.toString());
                }
            }
            member.setInnerId(version.getVersionId());
        }
        if (hasSave) {
            BgDimCacheUtils.saveObject((Context)ctx, (String)"BudgetDimDataCache-Version", (Map)versionMap);
        }
    }

    public static String transVersionNumber(Context ctx, String versionNum) throws BOSException {
        if (ctx == null || versionNum == null) {
            return versionNum;
        }
        BgVersionInfo version = null;
        Map versionMap = BgDimCacheUtils.getVersionCache((Context)ctx);
        if (versionMap.containsKey(versionNum)) {
            version = (BgVersionInfo)versionMap.get(versionNum);
            return String.valueOf(version.getVersionId());
        }
        return versionNum;
    }

    public static void restoreVersionNumber(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, Map<String, String> bgVersionMap) {
        if (dimension == null || bgVersionMap == null || bgVersionMap.isEmpty()) {
            return;
        }
        if (!DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            if (!bgVersionMap.containsKey(member.getNumber())) continue;
            member.setNumber(bgVersionMap.get(member.getNumber()));
        }
    }

    public static void transMdxMemberNumber(Context ctx, IDimensionParameter parameter, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) throws Exception {
        if (ctx == null || dimension == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            DimUtils.transOrgUnitMember(ctx, dimension);
        } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
            DimUtils.transBgPeriodMember(ctx, parameter, dimension, false);
        } else if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
            // empty if block
        }
    }

    private static void transOrgUnitMember(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) throws Exception {
        if (ctx == null || dimension == null || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transBgPeriodMember(Context ctx, IDimensionParameter parameter, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, boolean onlyTrans) throws Exception {
        int i;
        HashMap periodCacheMap;
        Map<String, String> bgParentPeriodMap;
        if (ctx == null || dimension == null || !DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (dimension.getDimensionMember().isEmpty()) {
            return;
        }
        List<String> bgSchemePeriodType = null;
        if (parameter.getDataManager().getBgScheme() != null) {
            bgSchemePeriodType = parameter.getDataManager().getBgScheme().getMemberNumber(DimensionConstants.DEF_PERIOD_NUMBER);
        }
        if ((bgParentPeriodMap = parameter.getBgPeriodParentMap()) == null) {
            bgParentPeriodMap = new HashMap<String, String>();
        }
        if ((periodCacheMap = (HashMap)BgDimCacheUtils.getObject((Context)ctx, (String)BgPeriodCacheUtils.BUDGET_DIM_BGPERIODDISP_CACHE)) == null) {
            periodCacheMap = new HashMap();
        }
        Map<String, Integer> periodTypeMap = CubeCacheUtils.getBgPeriodTypeCache(ctx);
        int type = 0;
        boolean isFiscalYear = parameter.getControlManager().isFiscalYear();
        String dimNumber = null;
        String prefixStr = null;
        String prefixTmp = null;
        String[] periodStrs = null;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        Map<String, String[]> periodMap = null;
        HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> queryMap = new HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        HashSet<String> prefixSet = new HashSet<String>();
        HashSet<String> allFixSet = new HashSet<String>();
        int in = dimension.getDimensionMember().size();
        for (i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            dimNumber = member.getNumber();
            if (!periodCacheMap.containsKey(dimNumber)) {
                queryMap.put(dimNumber, member);
            }
            prefixStr = dimNumber.split("\\.")[0];
            allFixSet.add(prefixStr);
            if (periodTypeMap.containsKey(prefixStr)) {
                type = periodTypeMap.get(prefixStr);
                if (type != 2) continue;
                isFiscalYear = true;
                prefixTmp = prefixStr;
                continue;
            }
            prefixSet.add(prefixStr);
        }
        if (!queryMap.isEmpty() || !prefixSet.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            ArrayList number = new ArrayList();
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                if (!queryMap.isEmpty()) {
                    int index;
                    number.addAll(queryMap.keySet());
                    int batchSize = 50;
                    int size = number.size();
                    int count = (size - 1) / batchSize + 1;
                    int pos = 0;
                    StringBuffer sql = new StringBuffer("select FNumber, FLongNumber, FName_" + ctx.getLocale() + " AS FName from T_MBG_BgPeriodDisp where FNumber IN (");
                    for (index = 1; index < batchSize; ++index) {
                        sql.append("?,");
                    }
                    sql.append("?) order by FLONGNUMBER");
                    try {
                        pstmt = conn.prepareStatement(sql.toString());
                        for (index = 0; index < count; ++index) {
                            int x = 1;
                            while (x <= batchSize) {
                                if (pos < size) {
                                    pstmt.setString(x, (String)number.get(pos));
                                } else {
                                    pstmt.setString(x, "#");
                                }
                                ++x;
                                ++pos;
                            }
                            try {
                                rst = pstmt.executeQuery();
                                while (rst.next()) {
                                    periodStrs = new String[4];
                                    periodStrs[0] = rst.getString("FNumber");
                                    periodStrs[1] = rst.getString("FLongNumber");
                                    periodStrs[2] = rst.getString("FName");
                                    if (periodCacheMap.containsKey(periodStrs[0])) {
                                        periodMap = (Map)periodCacheMap.get(periodStrs[0]);
                                    } else {
                                        periodMap = new HashMap();
                                        periodCacheMap.put(periodStrs[0], periodMap);
                                    }
                                    if (periodMap == null || StringUtils.isEmpty((String)periodStrs[1])) continue;
                                    periodMap.put(periodStrs[1], periodStrs);
                                }
                                continue;
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)("transBgPeriodMember sql:" + sql.toString()));
                        throw new BOSException((Throwable)ex);
                    }
                    finally {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                    }
                    BgDimCacheUtils.putObject((Context)ctx, (String)BgPeriodCacheUtils.BUDGET_DIM_BGPERIODDISP_CACHE, periodCacheMap);
                }
                if (!prefixSet.isEmpty()) {
                    periodTypeMap = MbgDataHelper.getBgPeriodType(conn);
                    BgDimCacheUtils.putObject((Context)ctx, (String)BgPeriodCacheUtils.BUDGET_DIM_BGPERIODTYPE_CACHE, periodTypeMap);
                }
            }
            finally {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            }
        }
        in = dimension.getDimensionMember().size();
        for (i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            periodMap = (HashMap)periodCacheMap.get(member.getNumber());
            if (periodMap == null || periodMap.isEmpty()) {
                throw new DimensionException(DimensionException.BGMEMBERNOTFIND, new String[]{member.getNumber()});
            }
            if (periodMap.size() == 1) {
                for (String[] mdxNumber : periodMap.values()) {
                    member.setMdxNumber(mdxNumber[1]);
                }
                continue;
            }
            boolean hasFound = false;
            String[] lastMdxNumber = null;
            for (String[] mdxNumber : periodMap.values()) {
                prefixStr = mdxNumber[1].split("\\.")[0];
                if (bgSchemePeriodType != null && !bgSchemePeriodType.contains(prefixStr)) continue;
                if (!allFixSet.contains(periodStrs)) {
                    // empty if block
                }
                type = prefixTmp != null ? periodTypeMap.get(prefixTmp).intValue() : periodTypeMap.get(prefixStr).intValue();
                lastMdxNumber = mdxNumber;
                if (isFiscalYear) {
                    if (type != 2 || !prefixStr.equals(prefixTmp)) continue;
                    member.setMdxNumber(mdxNumber[1]);
                    hasFound = true;
                    parameter.getControlManager().setFiscalYear(true);
                    break;
                }
                if (type != 1) continue;
                member.setMdxNumber(mdxNumber[1]);
                hasFound = true;
                break;
            }
            if (hasFound || lastMdxNumber == null) continue;
            member.setMdxNumber((String)lastMdxNumber[1]);
            if (type != 2) continue;
            parameter.getControlManager().setFiscalYear(true);
        }
        String[] tmpStrs = null;
        int in2 = dimension.getDimensionMember().size();
        for (int i2 = 0; i2 < in2; ++i2) {
            member = dimension.getDimensionMember().get(i2);
            tmpStrs = member.getMdxNumber().split("!");
            if (tmpStrs == null) continue;
            int jn = tmpStrs.length - 1;
            for (int j = 0; j < jn; ++j) {
                bgParentPeriodMap.put(tmpStrs[j + 1], tmpStrs[j]);
            }
        }
        parameter.setBgPeriodParentMap(bgParentPeriodMap);
        if (!onlyTrans && !parameter.getControlManager().isFiscalYear()) {
            parameter.getControlManager().setFiscalYear(isFiscalYear);
        }
    }

    public static Set<String> getPeriodStandardNumber(IDimensionParameter parameter) {
        Set<String> bgPeriodNum = new HashSet<String>();
        if (parameter != null) {
            if (parameter.getPeriodStandardNumber() != null) {
                bgPeriodNum = parameter.getPeriodStandardNumber();
            } else if (parameter.getDataManager().getDimDataQuery() != null && parameter.getDataManager().getDimDataQuery().getBizPeriod() != null) {
                bgPeriodNum.add(parameter.getDataManager().getDimDataQuery().getBizPeriod().getNumber());
            }
        }
        return bgPeriodNum;
    }

    public static List<String> queryNotAggregateEle(Connection conn) throws SQLException {
        ArrayList<String> elements = new ArrayList<String>();
        if (conn == null) {
            return elements;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_BgElement where FDataType = 1 OR FDataType = 3");
            while (rst.next()) {
                elements.add(rst.getString("FNumber"));
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return elements;
    }

    public static String getDimensionNumber(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        return DimUtils.getDimensionNumber(dimension.getNumber(), dimension.getField());
    }

    public static String getDimensionNumber(IDimension dimension) {
        return DimUtils.getDimensionNumber(dimension.getNumber(), dimension.getField());
    }

    public static String getDimensionNumber(String dimNumber, String field) {
        return "[" + DimUtils.getDimensionTag(dimNumber, field) + "]";
    }

    public static String getDimensionTag(String dimNumber, String field) {
        String dimensionStr = null;
        dimensionStr = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber) ? "orgUnit" : (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber) ? "period" : (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber) ? "element" : (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber) ? "currency" : (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber) ? "scenario" : (DimensionConstants.DEF_VERSION_NUMBER.equals(dimNumber) ? "version" : (DimensionConstants.DEF_STATE_NUMBER.equals(dimNumber) ? "state" : (DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimNumber) ? "processType" : "DIM" + field)))))));
        return dimensionStr;
    }

    public static String getDimensionTag(String field) {
        String dimensionStr = field;
        String _field = field.substring(3);
        if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(_field)) {
            dimensionStr = "orgUnit";
        } else if (DimensionConstants.DEF_PERIOD_FIELD.equals(_field)) {
            dimensionStr = "period";
        } else if (DimensionConstants.DEF_ELEMENT_FIELD.equals(_field)) {
            dimensionStr = "element";
        } else if (DimensionConstants.DEF_CURRENCY_FIELD.equals(_field)) {
            dimensionStr = "currency";
        } else if (DimensionConstants.DEF_SCENARIO_FIELD.equals(_field)) {
            dimensionStr = "scenario";
        } else if (DimensionConstants.DEF_VERSION_FIELD.equals(_field)) {
            dimensionStr = "version";
        }
        return dimensionStr;
    }

    public static String getDimensionString(String field) {
        String dimensionStr = field;
        String _field = field;
        dimensionStr = DimensionConstants.DEF_ORGUNIT_FIELD.equals(_field) ? "orgUnit" : (DimensionConstants.DEF_PERIOD_FIELD.equals(_field) ? "period" : (DimensionConstants.DEF_ELEMENT_FIELD.equals(_field) ? "element" : (DimensionConstants.DEF_CURRENCY_FIELD.equals(_field) ? "currency" : (DimensionConstants.DEF_SCENARIO_FIELD.equals(_field) ? "scenario" : (DimensionConstants.DEF_VERSION_FIELD.equals(_field) ? "version" : "DIM" + dimensionStr)))));
        return dimensionStr;
    }

    public static String getDimensionNumber(String dimField) {
        String dimensionStr = null;
        dimensionStr = DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(dimField) ? "[orgUnit]" : (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(dimField) ? "[period]" : (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(dimField) ? "[element]" : (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(dimField) ? "[currency]" : (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(dimField) ? "[scenario]" : (DimensionBaseConstants.DEF_VERSION_FIELD.equals(dimField) ? "[version]" : (DimensionBaseConstants.DEF_PROCESS_FIELD.equals(dimField) ? "[processType]" : "[DIM" + dimField + "]"))))));
        return dimensionStr;
    }

    public static String getDimensionField(BgDimensionBaseInfo dimInfo) {
        String field = dimInfo.getRefField();
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
        } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_PERIOD_FIELD;
        } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_ELEMENT_FIELD;
        } else if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_CURRENCY_FIELD;
        } else if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_SCENARIO_FIELD;
        } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_VERSION_FIELD;
        } else if (DimensionConstants.DEF_CSL_NUMBER.equals(dimInfo.getNumber())) {
            field = DimensionBaseConstants.DEF_CSL_FIELD;
        }
        return field;
    }

    public static boolean checkBgIndexDimension(BgDimensionBaseInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return false;
        }
        return dimensionInfo.getAttribute() != null && dimensionInfo.getAttribute().equals(DimensionConstants.DEF_BGINDEX_FIELD);
    }

    public static boolean checkBaseDimension(IDimensionBase dimension) {
        if (dimension == null) {
            return false;
        }
        return DimUtils.checkBaseDimension(dimension.getNumber());
    }

    public static boolean checkBaseDimension(BgDimensionBaseInfo dimension) {
        if (dimension == null) {
            return false;
        }
        return DimUtils.checkBaseDimension(dimension.getNumber());
    }

    public static boolean checkBaseDimension(String dimNumber) {
        if (dimNumber == null) {
            return false;
        }
        return DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber) || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimNumber) || DimensionConstants.DEF_SCHEME_NUMBER.equals(dimNumber) || DimensionConstants.DEF_STATE_NUMBER.equals(dimNumber) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimNumber);
    }

    public static boolean checkBaseDimensionByField(String field) {
        if (field == null) {
            return false;
        }
        return DimensionConstants.DEF_ORGUNIT_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || DimensionConstants.DEF_CURRENCY_FIELD.equals(field) || DimensionConstants.DEF_ELEMENT_FIELD.equals(field) || DimensionConstants.DEF_SCENARIO_FIELD.equals(field) || DimensionConstants.DEF_VERSION_FIELD.equals(field);
    }

    public static List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> getItemDimension(IDimensionParameter parameter) {
        if (parameter == null) {
            return null;
        }
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> itemDims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i);
            if (DimUtils.checkBaseDimension(dimension)) continue;
            itemDims.add(dimension);
        }
        Collections.sort(itemDims, new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                String refField1 = o1.getField().substring(1);
                String refField2 = o2.getField().substring(1);
                return Integer.valueOf(refField1).compareTo(Integer.valueOf(refField2));
            }
        });
        return itemDims;
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getOrgUnitDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_ORGUNIT_NUMBER);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getPeriodDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_PERIOD_NUMBER);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getElementDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_ELEMENT_NUMBER);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getCurrencyDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_CURRENCY_NUMBER);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getVersionDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_VERSION_NUMBER);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getScenarioDimension(IDimensionParameter parameter) {
        return DimUtils.getDimension(parameter, DimensionConstants.DEF_SCENARIO_NUMBER);
    }

    public static List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> getDims(IDimensionParameter parameter) {
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        if (parameter == null) {
            return null;
        }
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        return dims;
    }

    public static List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> getDimsClone(IDimensionParameter parameter) {
        int i;
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        if (parameter == null) {
            return null;
        }
        int in = parameter.getRowDims().size();
        for (i = 0; i < in; ++i) {
            dims.add(parameter.getRowDims().get(i).clone());
        }
        in = parameter.getColDims().size();
        for (i = 0; i < in; ++i) {
            dims.add(parameter.getColDims().get(i).clone());
        }
        in = parameter.getPageDims().size();
        for (i = 0; i < in; ++i) {
            dims.add(parameter.getPageDims().get(i).clone());
        }
        return dims;
    }

    private static com.kingdee.eas.ma.mbg.dimension.face.IDimension getDimension(IDimensionParameter parameter, String dimNumber) {
        if (parameter == null || dimNumber == null) {
            return null;
        }
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        return DimUtils.getDimension(dims, dimNumber);
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getDimension(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, String dimNumber) {
        if (dims == null || dims.isEmpty() || dimNumber == null) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = dims.get(i);
            if (!dimNumber.equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }

    public static BgDimensionBaseInfo getBgDimension(List<BgDimensionBaseInfo> dims, String dimNumber) {
        if (dims == null || dims.isEmpty() || dimNumber == null) {
            return null;
        }
        BgDimensionBaseInfo dimension = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = dims.get(i);
            if (!dimNumber.equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getDimensionOfField(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, String field) {
        if (dims == null || dims.isEmpty() || StringUtils.isEmpty((String)field)) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = dims.get(i);
            if (!field.equals(dimension.getField())) continue;
            return dimension;
        }
        return null;
    }

    public static List<String> getDimMemberNumber(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        ArrayList<String> members = new ArrayList<String>();
        if (dimension == null) {
            return members;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            members.add(member.getDimNumber());
        }
        return members;
    }

    public static Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> getDimMemberMap(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> members = new HashMap<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        if (dimension == null) {
            return members;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            member = dimension.getDimensionMember().get(i);
            members.put(member.getDimNumber(), member);
        }
        return members;
    }

    public static String getDimField(List<String> dimFields) {
        if (dimFields == null || dimFields.isEmpty()) {
            return null;
        }
        String dimKey = "";
        int in = dimFields.size();
        for (int i = 0; i < in; ++i) {
            dimKey = dimKey + dimFields.get(i) + ",";
        }
        if (dimKey.length() > 0) {
            dimKey = dimKey.substring(0, dimKey.length() - 1);
        }
        return dimKey;
    }

    public static String getDimField(String[] dimFields) {
        if (dimFields == null || dimFields.length == 0) {
            return null;
        }
        String dimKey = "";
        int in = dimFields.length;
        for (int i = 0; i < in; ++i) {
            dimKey = dimKey + dimFields[i] + ",";
        }
        if (dimKey.length() > 0) {
            dimKey = dimKey.substring(0, dimKey.length() - 1);
        }
        return dimKey;
    }

    public static Set<String> getDimKey(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> bgDims) {
        HashSet<String> fields = new HashSet<String>();
        if (bgDims == null || bgDims.isEmpty()) {
            return null;
        }
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : bgDims) {
            fields.add(dimension.getField());
        }
        return fields;
    }

    public static String getDimKey(IDimensionParameter parameter) {
        if (parameter == null) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        ArrayList<String> dimKeys = new ArrayList<String>();
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i);
            if (DimUtils.checkBaseDimension(dimension)) continue;
            dimKeys.add(dimension.getField());
        }
        Collections.sort(dimKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer num1 = new Integer(o1.substring(1));
                Integer num2 = new Integer(o2.substring(1));
                return num1.compareTo(num2);
            }
        });
        String dimKey = "";
        int in2 = dimKeys.size();
        for (int i = 0; i < in2; ++i) {
            dimKey = dimKey + (String)dimKeys.get(i) + "_";
        }
        if (dimKey.length() > 0) {
            dimKey = dimKey.substring(0, dimKey.length() - 1);
        }
        return dimKey;
    }

    public static String getFields(Set<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        StringBuffer fieldStr = new StringBuffer();
        for (String field : fields) {
            fieldStr.append(field + ",");
        }
        if (fieldStr.length() > 0) {
            fieldStr = fieldStr.delete(fieldStr.length() - 1, fieldStr.length());
        }
        return fieldStr.toString();
    }

    public static String getDimNumber(Map<String, String> dimsMap) {
        if (dimsMap == null || dimsMap.isEmpty()) {
            return null;
        }
        Map<String, String> dimMap = null;
        if (dimsMap instanceof TreeMap) {
            dimMap = dimsMap;
        } else {
            dimMap = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String str1 = o1.substring(1);
                    String str2 = o2.substring(1);
                    return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                }
            });
            dimMap.putAll(dimsMap);
        }
        StringBuffer dimNumber = new StringBuffer();
        Iterator<String> iter = dimMap.values().iterator();
        while (iter.hasNext()) {
            dimNumber.append(iter.next() + ",");
        }
        if (dimNumber.length() > 0) {
            dimNumber = dimNumber.delete(dimNumber.length() - 1, dimNumber.length());
        }
        return dimNumber.toString();
    }

    public static String getDimNumber(String[] dimNums) {
        if (dimNums == null || dimNums.length == 0) {
            return null;
        }
        String dimNumber = dimNums[0];
        for (int i = 1; i < dimNums.length; ++i) {
            dimNumber = dimNumber + "," + dimNums[i];
        }
        return dimNumber;
    }

    public static String getDimNumber(String srcNumber, String number) {
        return srcNumber + ":" + number;
    }

    public static String getDimNumber(String dimNumber, Map<String, MbgDimInfo> dimsMap, TreeMap<String, String> dimDataMap) {
        if (dimNumber == null || dimsMap == null || dimsMap.isEmpty() || dimDataMap == null) {
            return null;
        }
        dimDataMap.clear();
        String[] tmpStrs = dimNumber.split(",");
        if (tmpStrs != null) {
            String srcNumber = null;
            String number = null;
            for (int i = 0; i < tmpStrs.length; ++i) {
                number = tmpStrs[i];
                srcNumber = number.substring(0, 3);
                dimDataMap.put(dimsMap.get(srcNumber).getRefField(), number);
            }
        }
        StringBuffer str = new StringBuffer();
        Iterator<String> iter = dimDataMap.values().iterator();
        while (iter.hasNext()) {
            str.append(iter.next() + ",");
        }
        if (str.length() > 0) {
            str = str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }

    public static String getSetOfTuple(Context ctx, List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, boolean isOrgLongNumber) throws Exception {
        return DimUtils.getSetOfDim(ctx, dims, true, isOrgLongNumber);
    }

    public static String getSetOfMember(Context ctx, List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, boolean isOrgLongNumber) throws Exception {
        return DimUtils.getSetOfDim(ctx, dims, false, isOrgLongNumber);
    }

    public static String getSetOfTupleByCalc(com.kingdee.eas.ma.mbg.dimension.face.IDimension bgIndexDim, List<String[]> dataParams) {
        return DimUtils.getSetOfParams(bgIndexDim, dataParams, true, true);
    }

    public static String getSetOfMemberByCalc(com.kingdee.eas.ma.mbg.dimension.face.IDimension bgIndexDim, List<String[]> dataParams) {
        return DimUtils.getSetOfParams(bgIndexDim, dataParams, true, true);
    }

    public static String getSetOfTuple(Context ctx, IDimensionParameter parameter, List<String[]> relationData) throws Exception {
        return DimUtils.getSetOfDim(ctx, parameter, relationData, true);
    }

    private static String getSetOfDim(Context ctx, List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, boolean hasTuple, boolean isOrgLongNumber) throws Exception {
        if (ctx == null || dims == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        String tmpStr = null;
        StringBuffer mdxDim = new StringBuffer();
        StringBuffer tmpMdx = new StringBuffer();
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> useDims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = dims.get(i);
            tmpStr = DimUtils.getSetOfDim(ctx, dimension, hasTuple, isOrgLongNumber);
            if (tmpStr == null) continue;
            useDims.add(dimension);
            tmpMdx.append("{").append(tmpStr).append("} * ");
        }
        if (tmpMdx.length() > 0) {
            tmpMdx = tmpMdx.delete(tmpMdx.length() - 3, tmpMdx.length());
        }
        if (useDims.size() > 1) {
            mdxDim.append("{").append(tmpMdx).append("}");
        } else {
            mdxDim = tmpMdx;
        }
        return mdxDim.toString();
    }

    private static String getSetOfDim(Context ctx, IDimensionParameter parameter, List<String[]> relationData, boolean hasTuple) throws Exception {
        String otherMdx;
        int in;
        int i;
        if (ctx == null || parameter == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (relationData != null && !relationData.isEmpty()) {
            relationData = new ArrayList<String[]>(relationData);
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        String dimNumber = null;
        String mdxNumber = null;
        String number = null;
        String[] relData = null;
        String[] dimData = null;
        String[] tmpData = null;
        HashSet<String> relDimFields = new HashSet<String>();
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> otherDims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        HashMap dimMap = new HashMap();
        HashMap<String, String> memberMap = null;
        boolean hasReplace = parameter.getDataManager().isTransMdxRel();
        dimData = relationData.get(0);
        int orgIndex = -1;
        for (i = 0; i < dimData.length; ++i) {
            relDimFields.add(dimData[i]);
            if (!DimensionConstants.DEF_ORGUNIT_FIELD.equals(dimData[i])) continue;
            orgIndex = i;
        }
        if (relationData.size() > 1 && (tmpData = relationData.get(1)) != null && tmpData.length > 0) {
            String tmpStr = tmpData[0];
            hasReplace = tmpStr != null && tmpStr.startsWith("[") && tmpStr.endsWith("]");
        }
        if (!hasReplace) {
            in = parameter.getRowDims().size();
            for (i = 0; i < in; ++i) {
                int jn;
                dimension = parameter.getRowDims().get(i);
                if (!relDimFields.contains(dimension.getField())) {
                    otherDims.add(dimension);
                    continue;
                }
                dimNumber = DimUtils.getDimensionNumber(dimension);
                memberMap = new HashMap<String, String>();
                if (DimUtils.checkBaseDimension(dimension.getNumber())) {
                    int j;
                    int jn2;
                    if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                        Map<String, String> bgScenNumInnMap = parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
                        jn2 = dimension.getDimensionMember().size();
                        for (j = 0; j < jn2; ++j) {
                            member = dimension.getDimensionMember().get(j);
                            number = member.getNumber();
                            mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                            memberMap.put(bgScenNumInnMap.get(number), mdxNumber);
                        }
                    } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) {
                        Map<String, String> bgVerNumInnMap = parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD);
                        jn2 = dimension.getDimensionMember().size();
                        for (j = 0; j < jn2; ++j) {
                            member = dimension.getDimensionMember().get(j);
                            number = member.getNumber();
                            mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                            memberMap.put(bgVerNumInnMap.get(number), mdxNumber);
                        }
                    } else {
                        jn = dimension.getDimensionMember().size();
                        for (int j2 = 0; j2 < jn; ++j2) {
                            member = dimension.getDimensionMember().get(j2);
                            number = member.getNumber();
                            mdxNumber = DimUtils.getMdxMember(dimNumber, member);
                            memberMap.put(number, mdxNumber);
                        }
                    }
                } else {
                    jn = dimension.getDimensionMember().size();
                    for (int j = 0; j < jn; ++j) {
                        member = dimension.getDimensionMember().get(j);
                        number = member.getDimNumber();
                        mdxNumber = DimUtils.getMdxItemMember(dimNumber, member);
                        memberMap.put(number, mdxNumber);
                    }
                }
                dimMap.put(dimension.getField(), memberMap);
            }
            if (dimMap.containsKey(DimensionConstants.DEF_ORGUNIT_FIELD) && relDimFields.contains(DimensionConstants.DEF_ORGUNIT_FIELD) && orgIndex != -1) {
                Map map = (Map)dimMap.get(DimensionConstants.DEF_ORGUNIT_FIELD);
                String dimensionNumber = DimUtils.getDimensionNumber(DimensionConstants.DEF_ORGUNIT_NUMBER, null);
                String orgNumber = null;
                if (relationData.size() > 1) {
                    for (int i2 = 1; i2 < relationData.size(); ++i2) {
                        orgNumber = relationData.get(i2)[orgIndex];
                        if (orgNumber != null && orgNumber.startsWith("[") || StringUtils.isEmpty((String)orgNumber) || map.containsKey(orgNumber)) continue;
                        if (orgNumber.indexOf(":") > 0) {
                            map.put(orgNumber, dimensionNumber + ".[" + orgNumber.split(":")[1] + "]");
                            continue;
                        }
                        map.put(orgNumber, dimensionNumber + ".[" + orgNumber + "]");
                    }
                }
            }
            for (i = 0; i < dimData.length; ++i) {
                memberMap = (HashMap<String, String>)dimMap.get(dimData[i]);
                if (memberMap == null) continue;
                for (int j = relationData.size() - 1; j >= 1; --j) {
                    relData = relationData.get(j);
                    if (memberMap.containsKey(relData[i])) {
                        relData[i] = (String)memberMap.get(relData[i]);
                        continue;
                    }
                    if (memberMap.containsKey(DimUtils.getNumber(relData[i]))) {
                        relData[i] = (String)memberMap.get(DimUtils.getNumber(relData[i]));
                        continue;
                    }
                    if (DimUtils.checkBaseDimensionByField(dimData[i]) || DimensionConstants.DEF_BGINDEX_FIELD.equals(dimData[i])) continue;
                    relationData.remove(j);
                }
            }
            parameter.getDataManager().setTransMdxRel(true);
        } else {
            in = parameter.getRowDims().size();
            for (i = 0; i < in; ++i) {
                dimension = parameter.getRowDims().get(i);
                if (relDimFields.contains(dimension.getField())) continue;
                otherDims.add(dimension);
            }
        }
        String relMdx = DimUtils.getSetOfParams(parameter.getBgIndexDimension(), relationData, hasTuple, false);
        if (!otherDims.isEmpty() && !StringUtils.isEmpty((String)(otherMdx = DimUtils.getSetOfDim(ctx, otherDims, hasTuple, false)))) {
            relMdx = !StringUtils.isEmpty((String)relMdx) ? relMdx + " * " + otherMdx : otherMdx;
        }
        return relMdx;
    }

    public static Set<String> getFilterDimsOfRel(IDimensionParameter parameter, String[] dimData) {
        int i;
        HashSet<String> filterDims = new HashSet<String>();
        if (parameter == null || dimData == null) {
            return filterDims;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        HashSet<String> fields = new HashSet<String>();
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = DimUtils.getDims(parameter);
        int in = dims.size();
        for (i = 0; i < in; ++i) {
            dimension = dims.get(i);
            fields.add(dimension.getField());
        }
        in = dimData.length;
        for (i = 0; i < in; ++i) {
            if (fields.contains(dimData[i])) continue;
            filterDims.add(dimData[i]);
        }
        return filterDims;
    }

    public static Set<String> getFilterDimsOfRel(List<BgDimensionInfo> bgDims, String[] dimData) {
        int i;
        HashSet<String> filterDims = new HashSet<String>();
        if (bgDims == null || bgDims.isEmpty() || dimData == null) {
            return filterDims;
        }
        BgDimensionInfo dimension = null;
        HashSet<String> fields = new HashSet<String>();
        int in = bgDims.size();
        for (i = 0; i < in; ++i) {
            dimension = bgDims.get(i);
            if (DimUtils.checkBaseDimension(dimension)) continue;
            fields.add(dimension.getAttribute());
        }
        in = dimData.length;
        for (i = 0; i < in; ++i) {
            if (fields.contains(dimData[i])) continue;
            filterDims.add(dimData[i]);
        }
        return filterDims;
    }

    public static boolean checkHasHideDim(Set<String> hideDims, String[] dimData) {
        if (hideDims == null || dimData == null) {
            return false;
        }
        int in = dimData.length;
        for (int i = 0; i < in; ++i) {
            if (!hideDims.contains(dimData[i])) continue;
            return true;
        }
        return false;
    }

    public static List<String[]> filterRelationData(Set<String> hideDims, List<String[]> relationData) {
        if (hideDims == null || hideDims.isEmpty()) {
            return relationData;
        }
        String[] relData = null;
        String[] tmpData = null;
        ArrayList<String[]> tmpRel = new ArrayList<String[]>();
        ArrayList<String[]> hideRel = new ArrayList<String[]>();
        tmpRel.addAll(relationData);
        String[] dimData = relationData.get(0);
        for (int i = 0; i < dimData.length; ++i) {
            if (!hideDims.contains(dimData[i])) continue;
            tmpData = new String[dimData.length - 1];
            System.arraycopy(dimData, 0, tmpData, 0, i);
            System.arraycopy(dimData, i + 1, tmpData, i, tmpData.length - i);
            dimData = tmpData;
            hideRel.add(tmpData);
            int jn = tmpRel.size();
            for (int j = 1; j < jn; ++j) {
                relData = (String[])tmpRel.get(j);
                tmpData = new String[relData.length - 1];
                System.arraycopy(relData, 0, tmpData, 0, i);
                System.arraycopy(relData, i + 1, tmpData, i, tmpData.length - i);
                if (tmpData.length <= 0) continue;
                hideRel.add(tmpData);
            }
            tmpRel.clear();
            tmpRel.addAll(hideRel);
            hideRel.clear();
            --i;
        }
        hideRel.addAll(tmpRel);
        return hideRel;
    }

    public static String getSetOfParams(com.kingdee.eas.ma.mbg.dimension.face.IDimension bgIndexDim, List<String[]> dataParams, boolean hasTuple, boolean hasExpCalc) {
        if (dataParams == null || dataParams.isEmpty()) {
            return null;
        }
        StringBuffer tmpMdx = new StringBuffer();
        StringBuffer mdxDim = new StringBuffer();
        String[] params = null;
        int i = 1;
        int in = 0;
        if (hasExpCalc) {
            i = 0;
        }
        boolean hasSubtract = false;
        Object subNumber = null;
        String tmpStr = null;
        String[] tmpStrs = null;
        HashMap<String, Set<String>> subMemMap = new HashMap<String, Set<String>>();
        Object pMembers = null;
        Object subMemberSet = null;
        int bgIndex = -1;
        if (hasTuple) {
            in = dataParams.size();
            while (i < in) {
                params = dataParams.get(i);
                tmpMdx.append("(");
                boolean isFirst = true;
                int jn = params.length;
                for (int j = 0; j < jn; ++j) {
                    if (params[j] == null) continue;
                    if (!isFirst) {
                        tmpMdx.append(",");
                    }
                    isFirst = false;
                    tmpMdx.append(params[j]);
                    if (!hasSubtract || bgIndex != -1 || !params[j].startsWith("[DIM" + DimensionConstants.DEF_BGINDEX_FIELD + "]")) continue;
                    bgIndex = j;
                }
                tmpMdx.append("),");
                if (hasSubtract && (tmpStr = DimUtils.getSubMemberOfParams(bgIndexDim, subMemMap, params, bgIndex, hasTuple)) != null) {
                    tmpMdx.append(tmpStr);
                }
                ++i;
            }
        } else {
            in = dataParams.size();
            while (i < in) {
                params = dataParams.get(i);
                int jn = params.length - 1;
                for (int j = 0; j < jn; ++j) {
                    tmpMdx.append(params[j] + ",");
                    if (!hasSubtract || bgIndex != -1 || !(tmpStrs = params[j].split("\\."))[0].equals("[DIM" + DimensionConstants.DEF_BGINDEX_FIELD + "]")) continue;
                    bgIndex = j;
                }
                tmpMdx.append(params[params.length - 1]);
                tmpMdx.append(",");
                if (hasSubtract && (tmpStr = DimUtils.getSubMemberOfParams(bgIndexDim, subMemMap, params, bgIndex, hasTuple)) != null) {
                    tmpMdx.append(tmpStr);
                }
                ++i;
            }
        }
        if (tmpMdx.length() > 0) {
            tmpMdx = tmpMdx.delete(tmpMdx.length() - 1, tmpMdx.length());
            mdxDim.append("{").append(tmpMdx).append("}");
        }
        return mdxDim.toString();
    }

    private static String getSubMemberOfParams(com.kingdee.eas.ma.mbg.dimension.face.IDimension bgIndexDim, Map<String, Set<String>> subMemMap, String[] dimData, int bgIndex, boolean hasTuple) {
        return null;
    }

    public static String getSetOfDim(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, boolean hasTuple, boolean isOrgLongNumber) throws Exception {
        String mdxStr = null;
        mdxStr = DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) && isOrgLongNumber ? DimUtils.getMdxItemOfDim(ctx, dimension, hasTuple) : (DimUtils.checkBaseDimension(dimension) ? DimUtils.getMdxOfDim(ctx, dimension, hasTuple) : DimUtils.getMdxItemOfDim(ctx, dimension, hasTuple));
        return mdxStr;
    }

    public static String getTupleOfPageDim(Context ctx, List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, boolean isOrgLongNumber) throws Exception {
        int i;
        if (ctx == null || dims == null) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        ArrayList<String> tuple = new ArrayList<String>();
        StringBuffer mdxDim = new StringBuffer();
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dims.size();
        for (i = 0; i < in; ++i) {
            dimension = dims.get(i);
            if (dimension.getDimensionMember().isEmpty()) continue;
            member = dimension.getDimensionMember().get(0);
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) && isOrgLongNumber) {
                tuple.add(DimUtils.getMdxMember(DimUtils.getDimensionNumber(dimension), member));
                continue;
            }
            if (!DimUtils.checkBaseDimension(dimension)) {
                tuple.add(DimUtils.getMdxItemMember(DimUtils.getDimensionNumber(dimension), member));
                continue;
            }
            tuple.add(DimUtils.getMdxMember(DimUtils.getDimensionNumber(dimension), member));
        }
        if (!tuple.isEmpty()) {
            mdxDim.append("(");
            in = tuple.size();
            for (i = 0; i < in; ++i) {
                mdxDim.append((String)tuple.get(i)).append(",");
            }
            if (mdxDim.length() > 0) {
                mdxDim = mdxDim.delete(mdxDim.length() - 1, mdxDim.length());
            }
            mdxDim.append(")");
        }
        return mdxDim.toString();
    }

    public static String getTuple(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) throws Exception {
        return null;
    }

    public static String getMdxOfDim(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, boolean hasTuple) throws Exception {
        if (ctx == null || dimension == null) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        String mdxStr = null;
        StringBuffer mdxMember = new StringBuffer();
        String dimNumber = DimUtils.getDimensionNumber(dimension);
        if (!dimension.getDimensionMember().isEmpty()) {
            int in = dimension.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                member = dimension.getDimensionMember().get(i);
                mdxStr = DimUtils.getMdxMember(ctx, dimNumber, member, hasTuple);
                if (mdxStr == null) continue;
                mdxMember.append(mdxStr).append(",");
            }
            if (mdxMember.length() > 0) {
                mdxMember = mdxMember.delete(mdxMember.length() - 1, mdxMember.length());
            }
        } else {
            mdxMember.append(dimNumber + DimUtils.getMember(dimension.getMemberType()));
        }
        return mdxMember.toString();
    }

    public static String getMember(int memberType) {
        String member = ".members";
        if (DimensionConstants.MEMBER_TYPE_LEAF == memberType) {
            member = ".LeafMembers";
        } else if (DimensionConstants.MEMBER_TYPE_NOTLEAF == memberType) {
            member = ".NoLeafMembers";
        }
        return member;
    }

    public static String getMdxItemOfDim(Context ctx, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, boolean hasTuple) throws Exception {
        if (ctx == null || dimension == null) {
            return null;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        String mdxStr = null;
        StringBuffer mdxMember = new StringBuffer();
        String dimNumber = DimUtils.getDimensionNumber(dimension);
        if (!dimension.getDimensionMember().isEmpty()) {
            int in = dimension.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                member = dimension.getDimensionMember().get(i);
                if (member.getSrcNumber() == null) {
                    member.setSrcNumber(dimension.getSrcNumber());
                }
                if ((mdxStr = DimUtils.getMdxItemMember(ctx, dimNumber, member, hasTuple)) == null) continue;
                mdxMember.append(mdxStr).append(",");
            }
        } else {
            mdxMember.append(dimNumber + DimUtils.getMember(dimension.getMemberType()) + ",");
        }
        if (mdxMember.length() > 0) {
            mdxMember = mdxMember.delete(mdxMember.length() - 1, mdxMember.length());
        }
        return mdxMember.toString();
    }

    public static String getMdxMember(Context ctx, String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member, boolean hasTuple) throws Exception {
        if (hasTuple) {
            return DimUtils.getMdxTuple(ctx, dimNumber, member);
        }
        return DimUtils.getMdxMember(dimNumber, member);
    }

    private static String getMdxTuple(Context ctx, String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member) throws Exception {
        if (ctx == null || dimNumber == null || member == null) {
            return null;
        }
        StringBuffer mdxStr = new StringBuffer();
        if (member.getMdxNumber() != null) {
            String[] number = member.getMdxNumber().split("!");
            if (number != null) {
                mdxStr.append("(").append(dimNumber);
                int xn = number.length;
                for (int x = 0; x < xn; ++x) {
                    mdxStr.append(".[").append(number[x]).append("]");
                }
                mdxStr.append(")");
            }
        } else {
            mdxStr.append("(");
            mdxStr.append(dimNumber).append(".[").append(member.getNumber()).append("]");
            mdxStr.append(")");
        }
        return mdxStr.toString();
    }

    public static String getMdxMember(String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member) {
        if (dimNumber == null || member == null) {
            return null;
        }
        StringBuffer mdxStr = new StringBuffer();
        if (member.getMdxNumber() != null) {
            String[] number = member.getMdxNumber().split("!");
            if (number != null) {
                mdxStr.append(dimNumber);
                int jn = number.length;
                for (int j = 0; j < jn; ++j) {
                    mdxStr.append(".[").append(number[j]).append("]");
                }
            }
        } else {
            mdxStr.append(dimNumber).append(".[").append(member.getNumber()).append("]");
        }
        return mdxStr.toString();
    }

    public static String getMdxItemMember(Context ctx, String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member, boolean hasTuple) throws Exception {
        if (hasTuple) {
            return DimUtils.getMdxItemTuple(ctx, dimNumber, member);
        }
        return DimUtils.getMdxItemMember(dimNumber, member);
    }

    private static String getMdxItemTuple(Context ctx, String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member) throws Exception {
        if (ctx == null || dimNumber == null || member == null) {
            return null;
        }
        StringBuffer mdxStr = new StringBuffer();
        if (member.getMdxNumber() != null) {
            String[] mdxNumber = member.getMdxNumber().split("!");
            if (mdxNumber != null) {
                mdxStr.append("(").append(dimNumber);
                int xn = mdxNumber.length;
                for (int x = 0; x < xn; ++x) {
                    mdxStr.append(".[").append(member.getSrcNumber() + ":" + mdxNumber[x]).append("]");
                }
                mdxStr.append(")");
            }
        } else {
            mdxStr.append("(");
            mdxStr.append(dimNumber).append(".[" + member.getDimNumber() + "]");
            mdxStr.append(")");
        }
        return mdxStr.toString();
    }

    public static String getMdxItemMember(String dimNumber, com.kingdee.eas.ma.mbg.dimension.face.IMember member) {
        if (dimNumber == null || member == null) {
            return null;
        }
        StringBuffer mdxMember = new StringBuffer();
        if (member.getMdxNumber() != null) {
            String[] mdxNumber = member.getMdxNumber().split("!");
            if (mdxNumber != null) {
                mdxMember.append(dimNumber);
                int xn = mdxNumber.length;
                for (int x = 0; x < xn; ++x) {
                    if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(member.getSrcNumber())) {
                        mdxMember.append(".[").append(mdxNumber[x]).append("]");
                        continue;
                    }
                    mdxMember.append(".[").append(member.getSrcNumber() + ":" + mdxNumber[x]).append("]");
                }
            }
        } else {
            mdxMember.append(dimNumber).append(".[" + member.getDimNumber() + "]");
        }
        return mdxMember.toString();
    }

    public static String getMdxItemNumber(String srcNumber, String number) {
        if (srcNumber == null) {
            return DimUtils.getMdxItemNumber(number);
        }
        if (number == null) {
            return null;
        }
        String[] mdxNumber = number.split("!");
        if (mdxNumber != null) {
            StringBuffer mdxMember = new StringBuffer();
            int xn = mdxNumber.length;
            for (int x = 0; x < xn; ++x) {
                mdxMember.append(".[").append(srcNumber + ":" + mdxNumber[x]).append("]");
            }
            return mdxMember.toString();
        }
        return ".[" + srcNumber + ":" + number + "]";
    }

    public static String getMdxItemNumber(String number) {
        if (number == null) {
            return null;
        }
        String[] mdxNumber = number.split("!");
        if (mdxNumber != null) {
            StringBuffer mdxMember = new StringBuffer();
            int xn = mdxNumber.length;
            for (int x = 0; x < xn; ++x) {
                mdxMember.append(".[").append(mdxNumber[x]).append("]");
            }
            return mdxMember.toString();
        }
        return ".[" + number + "]";
    }

    public static String getMdxLongNumber(String srcNumber, String number) {
        if (srcNumber == null || number == null) {
            return null;
        }
        StringBuffer mdx = new StringBuffer();
        String[] mdxNumber = number.split("!");
        if (mdxNumber != null) {
            int xn = mdxNumber.length;
            for (int x = 0; x < xn; ++x) {
                if (x == 0) {
                    mdx.append(srcNumber + ":" + mdxNumber[x]);
                    continue;
                }
                mdx.append("!" + srcNumber + ":" + mdxNumber[x]);
            }
        }
        return mdx.toString();
    }

    public static List<String> getOrgUnitIdByNumber(Context ctx, List<String> orgUnitNumbers) throws Exception {
        int index;
        ArrayList<String> numList = new ArrayList<String>();
        if (orgUnitNumbers == null || orgUnitNumbers.isEmpty()) {
            return numList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = orgUnitNumbers.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer("select FID from T_ORG_COSTCENTER where FNumber IN (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, orgUnitNumbers.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    numList.add(rst.getString("FID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return numList;
    }

    public static void sortFields(List<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        Collections.sort(fields, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
    }

    public static void sortDims(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims) {
        if (dims == null || dims.isEmpty()) {
            return;
        }
        Collections.sort(dims, new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                String str1 = o1.getField().substring(1);
                String str2 = o2.getField().substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
    }

    public static void sortMbgDims(List<IDimension> dims) {
        if (dims == null || dims.isEmpty()) {
            return;
        }
        Collections.sort(dims, new Comparator<IDimension>(){

            @Override
            public int compare(IDimension o1, IDimension o2) {
                String str1 = o1.getField().substring(1);
                String str2 = o2.getField().substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
    }

    public static void sortMbgDimInfo(List<MbgDimInfo> dims) {
        if (dims == null || dims.isEmpty()) {
            return;
        }
        Collections.sort(dims, new Comparator<MbgDimInfo>(){

            @Override
            public int compare(MbgDimInfo o1, MbgDimInfo o2) {
                String str1 = o1.getRefField().substring(1);
                String str2 = o2.getRefField().substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
    }

    public static String getFields(List<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        String tmpStr = fields.get(0);
        int in = fields.size();
        for (int i = 1; i < in; ++i) {
            tmpStr = tmpStr + "_" + fields.get(i);
        }
        return tmpStr;
    }

    public static String[] getBgIndexFields() {
        String[] tmpStr = new String[]{"F2", "FDIMKEY"};
        return tmpStr;
    }

    public static String getSrcNumber(String dimNumber) {
        if (dimNumber != null) {
            return dimNumber.split(":")[0];
        }
        return null;
    }

    public static String getNumber(String dimNumber) {
        String number = dimNumber;
        if (number != null) {
            if (dimNumber.indexOf(":") > 0) {
                int l = dimNumber.indexOf(":");
                String src = dimNumber.substring(0, l);
                number = dimNumber.substring(l + 1, dimNumber.length());
            } else {
                String[] tmpStrs = dimNumber.split(":");
                if (tmpStrs != null) {
                    if (tmpStrs.length > 1) {
                        number = tmpStrs[1];
                    } else if (tmpStrs.length > 0) {
                        number = tmpStrs[0];
                    }
                }
            }
        }
        return number;
    }

    public static String getDimDataKey(String formulaStr, String bgVersionNum) {
        return formulaStr + "_" + bgVersionNum;
    }

    public static String getDimDataKey(IBgNData dimData) {
        if (dimData != null) {
            return dimData.getFormula() + "_" + dimData.getBgVersion();
        }
        return null;
    }

    public static BigDecimal getValue(IBgNData bgData, int valueType, Map<String, IObjectValue> scenarioMap) {
        if (bgData == null || scenarioMap == null) {
            return null;
        }
        BigDecimal value = null;
        if (bgData.getBgScenario() != null && scenarioMap.containsKey(bgData.getBgScenario())) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenarioMap.get(bgData.getBgScenario());
            int type = scenario.getType().getValue();
            if (0 == type) {
                value = bgData.getBudgetValueNoDef();
            } else if (1 == type) {
                value = valueType == 16 || valueType == 32 || valueType == 2048 ? bgData.getAddActualValue() : bgData.getBizActualNoDef();
            }
        } else if (valueType == 1 || valueType == 2) {
            value = bgData.getBudgetValueNoDef();
        } else if (valueType == 4) {
            value = bgData.getBizActualNoDef();
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            value = bgData.getAddActualValue();
        }
        return value;
    }

    public static void setValue(IBgNData bgData, BigDecimal value, int valueType, Map<String, IObjectValue> scenarioMap) {
        if (bgData == null) {
            return;
        }
        if (scenarioMap != null && bgData.getBgScenario() != null && scenarioMap.containsKey(bgData.getBgScenario())) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenarioMap.get(bgData.getBgScenario());
            int type = scenario.getType().getValue();
            if (0 == type) {
                bgData.setBudgetValue(value);
            } else if (1 == type) {
                if (valueType == 16 || valueType == 32 || valueType == 2048) {
                    bgData.setAddActualValue(value);
                } else {
                    bgData.setBizActual(value);
                }
            }
        } else if (valueType == 1 || valueType == 2) {
            bgData.setBudgetValue(value);
        } else if (valueType == 4) {
            bgData.setBizActual(value);
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            bgData.setAddActualValue(value);
        }
    }

    public static void setValue(IBgDimData bgData, BigDecimal value, int valueType, Map<String, IObjectValue> scenarioMap) {
        if (bgData == null || value == null || scenarioMap == null) {
            return;
        }
        if (bgData.getBgScenarioNumber() != null && scenarioMap.containsKey(bgData.getBgScenarioNumber())) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenarioMap.get(bgData.getBgScenarioNumber());
            int type = scenario.getType().getValue();
            if (0 == type) {
                bgData.setBudgetValue(value);
            } else if (1 == type) {
                bgData.setActualValue(value);
            }
        } else if (valueType == 1 || valueType == 2) {
            bgData.setBudgetValue(value);
        } else if (valueType == 4) {
            bgData.setActualValue(value);
        }
    }

    public static String getRelationStr(String[] fields, Map<String, MbgDimInfo> mbgDims) {
        if (fields == null || fields.length < 1) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        int in = fields.length;
        for (int i = 0; i < in; ++i) {
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(fields[i])) continue;
            str.append(DimUtils.getDimensionTag(mbgDims.get(fields[i]).getNumber(), fields[i]) + ",");
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    public static void fillPeriodMemberByPeriodAlgorithm(Context ctx, IDimensionParameter parameter) throws BOSException {
        if (parameter.getDataManager().getEndNumber() != null && !parameter.getDataManager().getEndNumber().isEmpty() || parameter.getDataManager().getOpeningNumber() != null && !parameter.getDataManager().getOpeningNumber().isEmpty()) {
            HashMap<String, Set<String>> periodTypeMap = new HashMap<String, Set<String>>();
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
            if (dimension == null) {
                return;
            }
            Set<String> rootNumberSet = null;
            String periodType = null;
            String result = null;
            String rootNumber = null;
            IRowSet query = null;
            List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember = dimension.getDimensionMember();
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimensionMember) {
                String rootMemberNumber = member.getMdxNumber().split("!")[0];
                periodType = rootMemberNumber.split("\\.")[0];
                rootNumber = periodType + "." + rootMemberNumber.split("\\.")[1];
                if (periodTypeMap.containsKey(periodType)) {
                    rootNumberSet = (Set)periodTypeMap.get(periodType);
                    rootNumberSet.add(rootNumber);
                    continue;
                }
                rootNumberSet = new HashSet();
                rootNumberSet.add(rootNumber);
                periodTypeMap.put(periodType, rootNumberSet);
            }
            if (periodTypeMap == null || periodTypeMap.isEmpty() || rootNumberSet == null || rootNumberSet.isEmpty()) {
                return;
            }
            result = DimUtils.returnPeriodSql(ctx, periodTypeMap, rootNumberSet);
            try {
                com.kingdee.eas.ma.mbg.dimension.face.IMember faceMember = null;
                Map<String, com.kingdee.eas.ma.mbg.dimension.face.IDimension> dimensionMap = parameter.getDimensionMap();
                com.kingdee.eas.ma.mbg.dimension.face.IDimension periodDim = dimensionMap.get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
                periodDim.getDimensionMember().clear();
                query = BgDBUtils.executeQuery((Context)ctx, (String)result);
                while (query.next()) {
                    String number = query.getString(1);
                    String longNumber = query.getString(2);
                    faceMember = new MemberObject();
                    faceMember.setNumber(number);
                    faceMember.setMdxNumber(longNumber);
                    faceMember.setName(number);
                    faceMember.setSrcNumber("BGP");
                    periodDim.getDimensionMember().add(faceMember);
                }
                String[] tmpStrs = null;
                parameter.getBgPeriodParentMap().clear();
                int in = periodDim.getDimensionMember().size();
                for (int i = 0; i < in; ++i) {
                    faceMember = periodDim.getDimensionMember().get(i);
                    tmpStrs = faceMember.getMdxNumber().split("!");
                    if (tmpStrs == null) continue;
                    int jn = tmpStrs.length - 1;
                    for (int j = 0; j < jn; ++j) {
                        parameter.getBgPeriodParentMap().put(tmpStrs[j + 1], tmpStrs[j]);
                    }
                }
                if (!parameter.getQuerys().isEmpty()) {
                    periodTypeMap.clear();
                    List<IQueryData> querys = parameter.getQuerys();
                    IDimension mbgDim = null;
                    int in2 = querys.size();
                    for (int i = 0; i < in2; ++i) {
                        IQueryData queryData = parameter.getQuerys().get(i);
                        mbgDim = queryData.getMbgDimMap().get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                        if (mbgDim == null) continue;
                        List<IMember> members = mbgDim.getMembers();
                        for (IMember member : members) {
                            String rootMemberNumber = member.getLongNumber().split("!")[0];
                            periodType = rootMemberNumber.split("\\.")[0];
                            rootNumber = periodType + "." + rootMemberNumber.split("\\.")[1];
                            if (periodTypeMap.containsKey(periodType)) {
                                rootNumberSet = (Set)periodTypeMap.get(periodType);
                                rootNumberSet.add(rootNumber);
                                continue;
                            }
                            rootNumberSet = new HashSet();
                            rootNumberSet.add(rootNumber);
                            periodTypeMap.put(periodType, rootNumberSet);
                        }
                        if (periodTypeMap == null || periodTypeMap.isEmpty() || rootNumberSet == null || rootNumberSet.isEmpty()) {
                            return;
                        }
                        IMember cubeMember = null;
                        result = DimUtils.returnPeriodSql(ctx, periodTypeMap, rootNumberSet);
                        mbgDim.getMembers().clear();
                        query = BgDBUtils.executeQuery((Context)ctx, (String)result);
                        while (query.next()) {
                            String number = query.getString(1);
                            String longNumber = query.getString(2);
                            String name = query.getString(3);
                            cubeMember = new Member();
                            cubeMember.setNumber(number);
                            cubeMember.setName(name);
                            cubeMember.setLongNumber(longNumber);
                            cubeMember.setDimNumber(cubeMember.getDimNumber());
                            cubeMember.transMdxNumber();
                            mbgDim.getMembers().add(cubeMember);
                        }
                        int kn = mbgDim.getMembers().size();
                        for (int k = 0; k < kn; ++k) {
                            cubeMember = mbgDim.getMembers().get(k);
                            tmpStrs = cubeMember.getLongNumber().split("!");
                            if (tmpStrs == null) continue;
                            int jn = tmpStrs.length - 1;
                            for (int j = 0; j < jn; ++j) {
                                parameter.getBgPeriodParentMap().put(tmpStrs[j + 1], tmpStrs[j]);
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static String returnPeriodSql(Context ctx, Map<String, Set<String>> periodTypeMap, Set<String> rootNumberSet22) {
        StringBuffer sql = new StringBuffer();
        sql.append("select p.FNumber,p.FLONGNumber,p.FName_" + ctx.getLocale() + " from T_MBG_BgPeriodDisp p inner join T_MBG_BgPeriodType t on p.FTypeID = t.FID where t.FNumber in (");
        Set<String> periodTypeSet = periodTypeMap.keySet();
        Iterator<Object> iter = periodTypeSet.iterator();
        while (iter.hasNext()) {
            sql.append("'").append(iter.next()).append("'").append(",");
        }
        sql.delete(sql.length() - 1, sql.length()).append(")").append(" and ");
        for (Set rootNumberSet22 : periodTypeMap.values()) {
            for (String rootNumber : rootNumberSet22) {
                sql.append("p.FLongNumber like '" + rootNumber + "%'").append(" or ");
            }
        }
        return sql.substring(0, sql.lastIndexOf("or"));
    }

    public static com.kingdee.eas.ma.mbg.dimension.face.IDimension getBgProcessTypeDim(String[] numbers, IDimensionParameter parameter) {
        if (numbers == null || numbers.length <= 0) {
            return null;
        }
        String currProcessType = DimensionCommonHelper.getProcessEnum(parameter.getValueType()).getName();
        DimensionObject dim = new DimensionObject();
        dim.setNumber(DimensionConstants.DEF_PROCESSTYPE_NUMBER);
        boolean hasCur = false;
        for (String number : numbers) {
            if (number.equals(currProcessType)) {
                hasCur = true;
            }
            MemberObject member = new MemberObject();
            member.setNumber(number);
            dim.getDimensionMember().add(member);
        }
        if (!hasCur) {
            MemberObject member = new MemberObject();
            member.setNumber(currProcessType);
            dim.getDimensionMember().add(member);
        }
        return dim;
    }

    public static void removeBgProcessTypeDim(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims) {
        if (dims == null || dims.isEmpty()) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension bgProcessTypeDim = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dim = dims.get(i);
            if (!dim.getNumber().equals(DimensionConstants.DEF_PROCESSTYPE_NUMBER)) continue;
            bgProcessTypeDim = dim;
            break;
        }
        if (bgProcessTypeDim != null) {
            dims.remove(bgProcessTypeDim);
        }
    }

    public static String[] getProcessType(Map<String, String> params) {
        String[] types = null;
        if (params.containsKey(DimensionConstants.BIZCALC_PROCESS_TYPE)) {
            String cubeName = params.get(DimensionConstants.TABLE_NAME);
            String str = params.get(DimensionConstants.BIZCALC_PROCESS_TYPE);
            String cType = DimUtils.getCurProcessType(cubeName);
            if (!StringUtils.isEmpty((String)str)) {
                if (str.indexOf(";") > 0) {
                    types = str.split(";");
                } else if (!str.equals(cType)) {
                    types = new String[]{cType, str};
                }
            }
        }
        return types;
    }

    public static boolean isMultiProcessType(Map<String, String> params) {
        if (params.containsKey(DimensionConstants.BIZCALC_PROCESS_TYPE)) {
            String[] types;
            String cubeName = params.get(DimensionConstants.TABLE_NAME);
            String str = params.get(DimensionConstants.BIZCALC_PROCESS_TYPE);
            String cType = DimUtils.getCurProcessType(cubeName);
            if (!StringUtils.isEmpty((String)str) && (str.indexOf(";") > 0 ? (types = str.split(";")).length > 1 : !str.equals(cType))) {
                return true;
            }
        }
        return false;
    }

    public static String getCurProcessType(String cubeName) {
        if (cubeName.indexOf(CubeConstants.BASE_DECOMPOSE) >= 0) {
            return BgProcessEnum.C02.getName();
        }
        if (cubeName.indexOf(CubeConstants.BASE_DECOMPOSE_SENDDOWN) >= 0) {
            return BgProcessEnum.C03.getName();
        }
        if (cubeName.indexOf(CubeConstants.BASE_DECOMPOSE_GATHER) >= 0) {
            return BgProcessEnum.C04.getName();
        }
        return BgProcessEnum.C01.getName();
    }

    public static int getProcessType(Context ctx, IDimensionParameter parameter) throws BOSException {
        if (parameter.getBillId() != null) {
            return DimUtils.getProcessType(ctx, parameter.getBillId().toString());
        }
        return DimensionCommonHelper.getProcessEnum(parameter.getValueType()).getValue();
    }

    public static int getProcessType(Context ctx, String billId) throws BOSException {
        int type = 1;
        if (ctx != null) {
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                type = DimUtils.getProcessType(conn, billId);
            }
            catch (SQLDataException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return type;
    }

    public static int getProcessType(Connection conn, IDimensionParameter parameter) throws BOSException {
        if (parameter.getBillId() != null) {
            return DimUtils.getProcessType(conn, parameter.getBillId().toString());
        }
        return DimensionCommonHelper.getProcessEnum(parameter.getValueType()).getValue();
    }

    public static int getProcessType(Connection conn, String billId) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)billId)) {
            return 1;
        }
        int type = 1;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FProcessType from T_Mbg_BgForm where fid = '" + billId + "'");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                type = rst.getInt("FProcessType");
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return type;
    }

    public static void fillPeriodMemberToPeriodAlgorithm(Context ctx, IDimensionParameter parameter) throws BOSException {
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        if (dimension == null) {
            return;
        }
        HashSet<String> rootNumberSet = new HashSet<String>();
        String periodType = null;
        String rootNumber = null;
        List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember = dimension.getDimensionMember();
        for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimensionMember) {
            String rootMemberNumber = member.getMdxNumber().split("!")[0];
            periodType = rootMemberNumber.split("\\.")[0];
            rootNumber = periodType + "." + rootMemberNumber.split("\\.")[1];
            rootNumberSet.add(rootNumber);
        }
        if (parameter.getDataManager().getOpeningNumber() != null && !parameter.getDataManager().getOpeningNumber().isEmpty()) {
            DimUtils.queryLeafMemberMap(ctx, rootNumberSet, parameter.getOpenningPeriodMap(), true);
            DimUtils.fillNotExsitsFaceMember(parameter, parameter.getOpenningPeriodMap(), dimensionMember);
        }
        if (parameter.getDataManager().getEndNumber() != null && !parameter.getDataManager().getEndNumber().isEmpty()) {
            DimUtils.queryLeafMemberMap(ctx, rootNumberSet, parameter.getEndingPeriodMap(), false);
            DimUtils.fillNotExsitsFaceMember(parameter, parameter.getEndingPeriodMap(), dimensionMember);
        }
        if (!parameter.getQuerys().isEmpty()) {
            IQueryData query = null;
            IDimension mbgDim = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                query = parameter.getQuerys().get(i);
                HashSet<String> rootNumSet = new HashSet<String>();
                mbgDim = query.getMbgDimMap().get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                if (mbgDim == null) continue;
                List<IMember> members = mbgDim.getMembers();
                for (IMember member : members) {
                    String rootMemberNumber;
                    if (member.getLongNumber().indexOf("!") <= 0 || (rootMemberNumber = member.getLongNumber().split("!")[0]).indexOf("\\.") <= 0) continue;
                    periodType = rootMemberNumber.split("\\.")[0];
                    rootNumber = periodType + "." + rootMemberNumber.split("\\.")[1];
                    rootNumSet.add(rootNumber);
                }
                if (parameter.getDataManager().getOpeningNumber() != null && !parameter.getDataManager().getOpeningNumber().isEmpty()) {
                    DimUtils.queryLeafMemberMap(ctx, rootNumSet, parameter.getOpenningPeriodMap(), true);
                    DimUtils.fillNotExsitsCubeMember(parameter, parameter.getOpenningPeriodMap(), members);
                }
                if (parameter.getDataManager().getEndNumber() == null || parameter.getDataManager().getEndNumber().isEmpty()) continue;
                DimUtils.queryLeafMemberMap(ctx, rootNumSet, parameter.getEndingPeriodMap(), false);
                DimUtils.fillNotExsitsCubeMember(parameter, parameter.getEndingPeriodMap(), members);
            }
        }
    }

    private static void fillNotExsitsCubeMember(IDimensionParameter parameter, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> periodAlgorithmMap, List<IMember> members) {
        HashSet<IMember> notExsitsMember = new HashSet<IMember>();
        for (IMember member : members) {
            if (!periodAlgorithmMap.containsKey(member.getNumber())) continue;
            boolean isExsits = false;
            com.kingdee.eas.ma.mbg.dimension.face.IMember openingMember = periodAlgorithmMap.get(member.getNumber());
            for (IMember mber : members) {
                if (!openingMember.getNumber().equals(mber.getNumber())) continue;
                isExsits = true;
                break;
            }
            if (isExsits) continue;
            notExsitsMember.add(openingMember.toMember(true));
            String[] tmpStrs = null;
            tmpStrs = openingMember.getMdxNumber().split("!");
            if (tmpStrs == null) continue;
            int jn = tmpStrs.length - 1;
            for (int j = 0; j < jn; ++j) {
                if (parameter.getBgPeriodParentMap().containsKey(tmpStrs[j + 1])) continue;
                parameter.getBgPeriodParentMap().put(tmpStrs[j + 1], tmpStrs[j]);
            }
        }
        if (notExsitsMember != null && !notExsitsMember.isEmpty()) {
            members.addAll(notExsitsMember);
        }
    }

    private static void fillNotExsitsFaceMember(IDimensionParameter parameter, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> periodAlgorithmMap, List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember) {
        HashSet<com.kingdee.eas.ma.mbg.dimension.face.IMember> notExsitsMember = new HashSet<com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimensionMember) {
            if (!periodAlgorithmMap.containsKey(member.getNumber())) continue;
            boolean isExsits = false;
            com.kingdee.eas.ma.mbg.dimension.face.IMember openingMember = periodAlgorithmMap.get(member.getNumber());
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember mber : dimensionMember) {
                if (!openingMember.getNumber().equals(mber.getNumber())) continue;
                isExsits = true;
                break;
            }
            if (isExsits) continue;
            notExsitsMember.add(openingMember);
            String[] tmpStrs = null;
            tmpStrs = openingMember.getMdxNumber().split("!");
            if (tmpStrs == null) continue;
            int jn = tmpStrs.length - 1;
            for (int j = 0; j < jn; ++j) {
                if (parameter.getBgPeriodParentMap().containsKey(tmpStrs[j + 1])) continue;
                parameter.getBgPeriodParentMap().put(tmpStrs[j + 1], tmpStrs[j]);
            }
        }
        if (notExsitsMember != null && !notExsitsMember.isEmpty()) {
            dimensionMember.addAll(notExsitsMember);
        }
    }

    private static void queryLeafMemberMap(Context ctx, Set<String> rootNumberSet, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> periodAlgorithmMap, boolean isOpening) throws BOSException {
        if (rootNumberSet.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber").append(",FName_").append(ctx.getLocale()).append(",FLONGNumber from T_MBG_BgPeriodDisp where FISLEAF = 1 and (");
        for (String rootNumber : rootNumberSet) {
            sql.append(" FLongNumber like '" + rootNumber + "%'").append(" or ");
        }
        sql = new StringBuffer(sql.substring(0, sql.lastIndexOf("or"))).append(")").append(" order by FNumber");
        if (isOpening) {
            sql.append(" ASC");
        } else {
            sql.append(" DESC");
        }
        try {
            IRowSet query = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString());
            MemberObject member = null;
            String number = null;
            String name = null;
            String longNumber = null;
            while (query.next()) {
                number = query.getString(1);
                name = query.getString(2);
                longNumber = query.getString(3);
                member = new MemberObject();
                member.setNumber(number);
                member.setMdxNumber(longNumber);
                member.setName(name);
                member.setSrcNumber("BGP");
                String[] parentNumber = longNumber.split("!");
                int in = parentNumber.length - 1;
                for (int i = 0; i < in; ++i) {
                    if (periodAlgorithmMap.containsKey(parentNumber[i])) continue;
                    periodAlgorithmMap.put(parentNumber[i], member);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"fillPeriodMemberToPeriodAlgorithm query period member error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean checkOrgOnCol(List<IBgDimensionManagerBase> dimensionManager) {
        boolean isMutiOrgOnCol = false;
        MbgViewListDimensionManager dimensionBase = null;
        HashSet<String> numbers = new HashSet<String>();
        int xn = dimensionManager.size();
        for (int x = 0; x < xn; ++x) {
            if (!(dimensionManager.get(x) instanceof MbgViewListDimensionManager)) continue;
            dimensionBase = (MbgViewListDimensionManager)dimensionManager.get(x);
            for (int i = 0; i < dimensionBase.getColumns().size(); ++i) {
                if (!(dimensionBase.getColumns().get(i) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol obj = (MbgViewListRowCol)dimensionBase.getColumns().get(i);
                for (int j = 0; j < obj.getDimensions().size(); ++j) {
                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(obj.getDimensions().get(j).getNumber()) || obj.getDimensions().get(j).getMember().isEmpty()) continue;
                    numbers.add(BgViewHelper.getNumber(obj.getDimensions().get(j).getMember().get(0)));
                }
            }
        }
        if (numbers.size() > 1) {
            isMutiOrgOnCol = true;
        }
        return isMutiOrgOnCol;
    }

    public static Map<String, Map<String, Set<String>>> bizCalcRelation(Context ctx, IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException, ParseException {
        if (ctx == null || parameter == null) {
            return null;
        }
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        Map<String, String> srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap(ctx, schemeHelper);
        List<BOSUuid> calcIds = parameter.getCalcIds();
        HashSet<String> bizCalcIds = new HashSet<String>();
        for (BOSUuid calcId : calcIds) {
            bizCalcIds.add(calcId.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bizCalcSubset.*");
        selector.add("bizCalcSubset.scope.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizCalcIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BizCalcCollection calcs = BizCalcFactory.getLocalInstance((Context)ctx).getBizCalcCollection(view);
        String[] tmpStrs = null;
        String srcNumber = null;
        String field = null;
        HashMap refNumMap = new HashMap();
        Map<String, String> variateMap = parameter.getDataManager().getVariate();
        if (!calcs.isEmpty() && parameter.getPeriodStandardNumber() != null && !parameter.getPeriodStandardNumber().isEmpty()) {
            ArrayList<BizCalcInfo> _calcs = new ArrayList<BizCalcInfo>();
            for (int i = 0; i < calcs.size(); ++i) {
                _calcs.add(calcs.get(i));
            }
            MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
            variable.transPeirodVariale(ctx, _calcs, parameter.getPeriodStandardNumber(), null);
        }
        if (variateMap != null) {
            for (String dimNumber : variateMap.values()) {
                tmpStrs = dimNumber.split(":");
                if (tmpStrs == null || tmpStrs.length != 2 || !srcFieldMap.containsKey(srcNumber = tmpStrs[0])) continue;
                field = srcFieldMap.get(srcNumber);
                BizExprUtils.putDimNumber((String)field, (String)dimNumber, refNumMap);
            }
        }
        HashMap refNumLeftMap = new HashMap();
        HashMap refNumRightMap = new HashMap();
        if (calcs != null && !calcs.isEmpty()) {
            BizCalcInfo calcInfo = null;
            BizCalcSubsetInfo subCalc = null;
            BinaryExpr expre = null;
            List express = null;
            int in = calcs.size();
            for (int i = 0; i < in; ++i) {
                calcInfo = calcs.get(i);
                try {
                    BgVariateUtils.transVariate(calcInfo, parameter.getDataManager().getVariate());
                }
                catch (ParseException ex) {
                    logger.error((Object)"parse script Error:", (Throwable)ex);
                }
                for (int s = 0; s < calcInfo.getBizCalcSubset().size(); ++s) {
                    subCalc = calcInfo.getBizCalcSubset().get(s);
                    express = subCalc.getExpres();
                    if (express == null) continue;
                    int jn = express.size();
                    for (int j = 0; j < jn; ++j) {
                        expre = (BinaryExpr)express.get(j);
                        BizCalcCheckServerHelper.bizCaclRelation(result, srcFieldMap, refNumLeftMap, refNumRightMap, (BinaryExpr)expre);
                    }
                }
            }
        }
        return result;
    }

    public static Map<String, Map<String, Set<String>>> bizCalcRelation(Context ctx, List<ICalcMember> members, Map<String, String> srcFieldMap) throws BOSException, EASBizException, ParseException {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        HashMap refNumLeftMap = new HashMap();
        HashMap refNumRightMap = new HashMap();
        ICalcMember calcMember = null;
        BizCalcMember bizCalcMember = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo subCalc = null;
        BinaryExpr expre = null;
        List express = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            calcMember = members.get(i);
            if (!(calcMember instanceof BizCalcMember)) continue;
            bizCalcMember = (BizCalcMember)calcMember;
            bizCalc = bizCalcMember.getCalc();
            for (int s = 0; s < bizCalc.getBizCalcSubset().size(); ++s) {
                subCalc = bizCalc.getBizCalcSubset().get(s);
                express = subCalc.getExpres();
                if (express == null) continue;
                int jn = express.size();
                for (int j = 0; j < jn; ++j) {
                    expre = (BinaryExpr)express.get(j);
                    BizCalcCheckServerHelper.bizCaclRelation(result, srcFieldMap, refNumLeftMap, refNumRightMap, (BinaryExpr)expre);
                }
            }
        }
        return result;
    }

    public static Map<String, Map<String, Set<String>>> queryParent(Context ctx, IDimensionParameter parameter, BgSchemeDimensionHelper sourceSchemeHelper, Map<String, Map<String, Set<String>>> bizCalcRelation) throws BOSException {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        if (bizCalcRelation == null || bizCalcRelation.isEmpty()) {
            return result;
        }
        Map<String, Set<String>> subRelation = null;
        Map subParent = null;
        HashSet<String> queryNumbers = new HashSet<String>();
        Set<String> longNumbers = null;
        HashSet<String> parentNumbers = null;
        String[] lns = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            for (String field : bizCalcRelation.keySet()) {
                subRelation = bizCalcRelation.get(field);
                queryNumbers.clear();
                for (Set<String> s : subRelation.values()) {
                    for (String number : s) {
                        if (number.length() > 4 && number.charAt(3) == ':') {
                            queryNumbers.add(number.substring(4));
                            continue;
                        }
                        queryNumbers.add(number);
                    }
                }
                longNumbers = DimUtils.queryLongNumber(ctx, conn, parameter, parameter.getDataManager().getMbgDims().get(field), queryNumbers);
                if (longNumbers == null || longNumbers.isEmpty()) continue;
                if (!result.containsKey(field)) {
                    result.put(field, new HashMap());
                }
                subParent = (Map)result.get(field);
                for (String longNumber : longNumbers) {
                    lns = longNumber.split("!");
                    for (int i = lns.length - 1; i >= 1; --i) {
                        parentNumbers = new HashSet<String>();
                        subParent.put(lns[i], parentNumbers);
                        for (int p = i - 1; p >= 0; --p) {
                            parentNumbers.add(lns[p]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    public static boolean checkFunFormatToMember(Set<String> memberSet) {
        String dimensionStr2 = null;
        for (String dimensionStr2 : memberSet) {
            if (dimensionStr2.indexOf("@") == -1) continue;
            return true;
        }
        return false;
    }
}

