/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.BaseCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.CslCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.cube.BizCalcOrgObject;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMemberBase;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OptimizeUtils {
    private static Logger logger = Logger.getLogger(OptimizeUtils.class);
    public static final int OPTIMIZE_MEMBER_SIZE = 100;

    public static Set<String> getRootDim(IDimensionParameter parameter, Set<String> standbyDim, Set<String> cslDimSet, Set<String> sumCslDimSet, Map<String, String> rootMemberMap) {
        HashSet<String> dimNums = new HashSet<String>();
        if (parameter == null || standbyDim == null || rootMemberMap == null) {
            return dimNums;
        }
        HashMap<String, String> fieldNumMap = new HashMap<String, String>();
        Map<String, MbgDimInfo> mbgDims = parameter.getDataManager().getMbgDims();
        for (MbgDimInfo mbgDim : mbgDims.values()) {
            fieldNumMap.put(mbgDim.getRefField(), mbgDim.getNumber());
        }
        Map<String, Set<String>> mbgDimMap = MbgDataHelper.mergeMbgMember(null, parameter, null);
        String field = null;
        String mbgNumber = null;
        String dimNumber = null;
        String number = null;
        Set<String> memberSet = null;
        Map.Entry<String, Set<String>> entry2 = null;
        for (Map.Entry<String, Set<String>> entry2 : mbgDimMap.entrySet()) {
            String rootNumber;
            field = entry2.getKey();
            mbgNumber = (String)fieldNumMap.get(field);
            memberSet = entry2.getValue();
            if (DimUtils.checkBaseDimensionByField(field) || DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field) || DimensionBaseConstants.DEF_CSL_FIELD.equals(field)) continue;
            if (cslDimSet != null && !cslDimSet.contains(mbgNumber) && !standbyDim.contains(mbgNumber)) {
                dimNums.add(mbgNumber);
                continue;
            }
            if (sumCslDimSet != null && sumCslDimSet.contains(mbgNumber)) {
                if (memberSet.size() != 1) continue;
                dimNumber = memberSet.iterator().next();
                number = DimUtils.getNumber(dimNumber);
                if (!rootMemberMap.containsKey(field) || !number.equals(rootNumber = rootMemberMap.get(field))) continue;
                dimNums.add(mbgNumber);
                if (cslDimSet == null) continue;
                cslDimSet.remove(mbgNumber);
                continue;
            }
            if (cslDimSet != null || sumCslDimSet != null || memberSet.size() != 1) continue;
            dimNumber = memberSet.iterator().next();
            number = DimUtils.getNumber(dimNumber);
            if (!rootMemberMap.containsKey(field) || !number.equals(rootNumber = rootMemberMap.get(field))) continue;
            dimNums.add(mbgNumber);
        }
        return dimNums;
    }

    public static void filterStandbyDimension(List dims, Set<String> standbySet, IDimensionParameter parameter) {
        OptimizeUtils.filterStandbyDimension(dims, standbySet, parameter, null);
    }

    public static void filterStandbyDimension(List dims, Set<String> standbySet, IDimensionParameter parameter, IQueryData queryData) {
        if (dims == null || dims.isEmpty() || standbySet == null || standbySet.isEmpty()) {
            return;
        }
        Object obj = null;
        String field = null;
        String number = null;
        Set<Object> memberSet = new HashSet();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        IDimension mbgDim = null;
        for (int i = dims.size() - 1; i >= 0; --i) {
            int j;
            int jn;
            obj = dims.get(i);
            dim = null;
            mbgDim = null;
            number = null;
            field = null;
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dim = obj;
                number = dim.getNumber();
                field = dim.getField();
            } else if (obj instanceof IDimension) {
                mbgDim = obj;
                number = mbgDim.getNumber();
                field = mbgDim.getField();
            }
            if (!standbySet.contains(number)) continue;
            if (parameter.getDataManager().getStandbyMap().containsKey(field)) {
                memberSet = parameter.getDataManager().getStandbyMap().get(field);
            } else {
                memberSet = new HashSet();
                parameter.getDataManager().getStandbyMap().put(field, memberSet);
            }
            if (dim != null) {
                jn = dim.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(dim.getDimensionMember().get(j).getDimNumber());
                }
            } else if (mbgDim != null) {
                jn = mbgDim.getMembers().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(mbgDim.getMembers().get(j).getDimNumber());
                }
            }
            dims.remove(i);
        }
    }

    public static void filterStandbyDimension(Map mbgMap, Set<String> standbySet, IDimensionParameter parameter) {
        OptimizeUtils.filterStandbyDimension(mbgMap, standbySet, parameter, null);
    }

    public static void filterStandbyDimension(Map mbgMap, Set<String> standbySet, IDimensionParameter parameter, IQueryData queryData) {
        if (mbgMap == null || mbgMap.isEmpty() || standbySet == null || standbySet.isEmpty()) {
            return;
        }
        Object obj = null;
        String field = null;
        String number = null;
        Set<Object> memberSet = new HashSet();
        ArrayList keys = new ArrayList();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        IDimension mbgDim = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : mbgMap.entrySet()) {
            int j;
            int jn;
            dim = null;
            mbgDim = null;
            number = null;
            field = null;
            obj = entry2.getValue();
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dim = obj;
                number = dim.getNumber();
                field = dim.getField();
            } else if (obj instanceof IDimension) {
                mbgDim = obj;
                number = mbgDim.getNumber();
                field = mbgDim.getField();
            }
            if (!standbySet.contains(number)) continue;
            if (parameter.getDataManager().getStandbyMap().containsKey(field)) {
                memberSet = parameter.getDataManager().getStandbyMap().get(field);
            } else {
                memberSet = new HashSet();
                parameter.getDataManager().getStandbyMap().put(field, memberSet);
            }
            if (dim != null) {
                jn = dim.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(dim.getDimensionMember().get(j).getDimNumber());
                }
            } else if (mbgDim != null) {
                jn = mbgDim.getMembers().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(mbgDim.getMembers().get(j).getDimNumber());
                }
            }
            keys.add(entry2.getKey());
        }
        if (!keys.isEmpty()) {
            int in = keys.size();
            for (int i = 0; i < in; ++i) {
                mbgMap.remove(keys.get(i));
            }
        }
    }

    public static void filterStandbyExpress(Set<String> standbySet, IDimensionParameter parameter) {
        if (standbySet == null || standbySet.isEmpty() || parameter == null || parameter.getExpressionParams() == null || parameter.getExpressionParams().isEmpty()) {
            return;
        }
        MbgDimInfo mbgDim = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        HashSet<String> fieldTagSet = new HashSet<String>();
        for (String mbgDimNum : standbySet) {
            dimension = parameter.getDimensionMap().get(mbgDimNum);
            if (dimension == null) continue;
            mbgDim = parameter.getDataManager().getMbgDims().get(dimension.getField());
            fieldTagSet.add(DimUtils.getDimensionTag(mbgDim.getNumber(), mbgDim.getRefField()));
        }
        HashSet<Integer> standbyIndexSet = new HashSet<Integer>();
        String[] expr = parameter.getExpressionParams().get(0);
        int in = expr.length;
        for (int i = 0; i < in; ++i) {
            for (String fieldTag : fieldTagSet) {
                if (expr[i].indexOf("[" + fieldTag + "]") < 0) continue;
                standbyIndexSet.add(i);
            }
        }
        if (standbyIndexSet.isEmpty()) {
            return;
        }
        ArrayList<String[]> filter = new ArrayList<String[]>(parameter.getExpressionParams().size());
        String[] tmpStrs = null;
        int index = 0;
        int size = expr.length - standbyIndexSet.size();
        int in2 = parameter.getExpressionParams().size();
        for (int i = 0; i < in2; ++i) {
            expr = parameter.getExpressionParams().get(i);
            index = 0;
            tmpStrs = new String[size];
            int jn = expr.length;
            for (int j = 0; j < jn; ++j) {
                if (standbyIndexSet.contains(j)) continue;
                tmpStrs[index++] = expr[j];
            }
            filter.add(tmpStrs);
        }
        if (!filter.isEmpty()) {
            parameter.getExpressionParams().clear();
            parameter.getExpressionParams().addAll(filter);
        }
    }

    public static void filterRootDimension(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims, Set<String> cslDimSet, Map<String, String> rootMemberMap) {
        if (dims == null || dims.isEmpty() || cslDimSet == null || rootMemberMap == null || rootMemberMap.isEmpty()) {
            return;
        }
        String field = null;
        String rootMember = null;
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember> members = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dim = dims.get(i);
            field = dim.getField();
            if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(dim.getNumber()) || cslDimSet.contains(dim.getNumber()) || DimUtils.checkBaseDimensionByField(field) || StringUtils.isEmpty((String)(rootMember = rootMemberMap.get(field)))) continue;
            members.clear();
            int jn = dim.getDimensionMember().size();
            for (int j = 0; j < jn; ++j) {
                member = dim.getDimensionMember().get(j);
                if (rootMember.equals(member.getNumber())) continue;
                members.add(member);
            }
            if (members.isEmpty()) continue;
            dim.getDimensionMember().removeAll(members);
        }
    }

    public static void filterRootQuery(List<IDimension> dims, Set<String> standbySet, Map<String, String> rootMemberMap) {
        if (dims == null || dims.isEmpty() || standbySet == null || rootMemberMap == null || rootMemberMap.isEmpty()) {
            return;
        }
        String field = null;
        String rootMember = null;
        ArrayList<IMember> members = new ArrayList<IMember>();
        IDimension dim = null;
        IMember member = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dim = dims.get(i);
            field = dim.getField();
            if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(dim.getNumber()) || standbySet.contains(dim.getNumber()) || DimUtils.checkBaseDimensionByField(field) || StringUtils.isEmpty((String)(rootMember = rootMemberMap.get(field)))) continue;
            members.clear();
            int jn = dim.getMembers().size();
            for (int j = 0; j < jn; ++j) {
                member = dim.getMembers().get(j);
                if (rootMember.equals(member.getNumber())) continue;
                members.add(member);
            }
            if (members.isEmpty()) continue;
            dim.getMembers().removeAll(members);
        }
    }

    public static void filterRootQuery(Map<String, IDimension> mbgMap, Set<String> standbySet, Map<String, String> rootMemberMap) {
        if (mbgMap == null || mbgMap.isEmpty() || standbySet == null || rootMemberMap == null || rootMemberMap.isEmpty()) {
            return;
        }
        String field = null;
        String rootMember = null;
        ArrayList<IMember> members = new ArrayList<IMember>();
        IDimension dim2 = null;
        IMember member = null;
        for (IDimension dim2 : mbgMap.values()) {
            field = dim2.getField();
            if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(dim2.getNumber()) || standbySet.contains(dim2.getNumber()) || DimUtils.checkBaseDimensionByField(field) || StringUtils.isEmpty((String)(rootMember = rootMemberMap.get(field)))) continue;
            members.clear();
            int jn = dim2.getMembers().size();
            for (int j = 0; j < jn; ++j) {
                member = dim2.getMembers().get(j);
                if (rootMember.equals(member.getNumber())) continue;
                members.add(member);
            }
            if (members.isEmpty()) continue;
            dim2.getMembers().removeAll(members);
        }
    }

    public static void filterMbgMemberByOrg(Context ctx, Connection conn, Set<String> cslDimSet, Set<String> cantCalcDim, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> refDimMap) throws Exception {
        Set<String> cslUnitIds;
        String cslOrgKey;
        if (ctx == null || conn == null || parameter == null || params == null || refDimMap == null) {
            return;
        }
        MbgLoggerUtils.logger((String)"start queryViewIds");
        Map<String, String> viewIdMap = OptimizeUtils.queryViewIds(conn, parameter.getDataManager().getBgScheme().getExtDimViewIds(), cslDimSet);
        MbgLoggerUtils.logger((String)"start queryOrgUnitIds");
        com.kingdee.eas.ma.mbg.dimension.face.IDimension orgDim = parameter.getOrgDimension();
        Set<String> orgUnitIds = OptimizeUtils.queryOrgUnitIds(ctx, conn, parameter.getUnionId(), parameter.getOrgUnitId(), parameter.getDataManager().getBgScheme().getViewId(DimensionBaseConstants.DEF_ORGUNIT_NUMBER), OptimizeUtils.getOrgNums(orgDim));
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            return;
        }
        MbgLoggerUtils.logger((String)"start queryMembers");
        Map<String, Set<String>> viewMembers = OptimizeUtils.queryMembers(ctx, conn, viewIdMap.values(), orgUnitIds, parameter);
        MbgLoggerUtils.logger((String)"end queryMembers");
        BOSUuid uuid = null;
        String field = null;
        String tmpTable = null;
        String viewId = null;
        String mbgDimNum = null;
        String tmpSubTable = null;
        String fieldTableKey = null;
        Set<String> numberSet = null;
        Set<String> refSet = null;
        HashSet<String> useCalcSet = new HashSet<String>();
        Set<String> longSet = null;
        Set<String> tmpSet = null;
        MbgDimInfo mbgDim2 = null;
        Map<String, MbgDimInfo> mbgDims = parameter.getDataManager().getMbgDims();
        TempTablePool pool = parameter.getTempTableManager(ctx).getTempTablePool();
        HashMap<String, MbgDimInfo> _mbgDims = new HashMap<String, MbgDimInfo>();
        HashMap<String, String> mbgFieldNumMap = new HashMap<String, String>();
        for (MbgDimInfo mbgDim2 : mbgDims.values()) {
            _mbgDims.put(mbgDim2.getNumber(), mbgDim2);
            mbgFieldNumMap.put(mbgDim2.getRefField(), mbgDim2.getNumber());
        }
        MbgLoggerUtils.logger((String)"start insert TmpTble");
        if (parameter.getUnionId() != null && !params.containsKey(cslOrgKey = DimensionBaseConstants.DEF_ORGUNIT_FIELD + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER) && (cslUnitIds = OptimizeUtils.queryCslOrgUnitIds(ctx, conn, parameter.getUnionId(), parameter.getOrgUnitId(), OptimizeUtils.getOrgNums(orgDim))) != null && !cslUnitIds.isEmpty() && (tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))")) != null) {
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), cslUnitIds);
            params.put(cslOrgKey, tmpTable);
            parameter.getTempTableManager(ctx).getTempTables().add(tmpTable);
        }
        MbgLoggerUtils.logger((String)"end insert TmpTble");
        HashSet<String> relFields = new HashSet<String>();
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty()) {
            String[] refField = relationData.get(0);
            if (refField != null) {
                int in = refField.length;
                for (int i = 0; i < in; ++i) {
                    relFields.add(refField[i]);
                }
            }
            if (!parameter.getQuerys().isEmpty()) {
                IQueryData queryData = null;
                int in = parameter.getQuerys().size();
                for (int i = 0; i < in; ++i) {
                    queryData = parameter.getQuerys().get(i);
                    if (queryData.getFilters() == null) continue;
                    List<String[]>[] filters = queryData.getFilters();
                    int jn = filters.length;
                    for (int j = 0; j < jn; ++j) {
                        if (filters[j] == null || filters[j].isEmpty() || (refField = filters[j].get(0)) == null) continue;
                        int xn = refField.length;
                        for (int x = 0; x < xn; ++x) {
                            relFields.add(refField[x]);
                        }
                    }
                }
            }
        }
        MbgLoggerUtils.logger((String)"start getRefMemberNums");
        Map.Entry<String, String> entry2 = null;
        for (Map.Entry<String, String> entry2 : viewIdMap.entrySet()) {
            field = entry2.getKey();
            viewId = entry2.getValue();
            mbgDim2 = mbgDims.get(field);
            mbgDimNum = mbgDim2.getNumber();
            if (cslDimSet != null && !cslDimSet.contains(mbgDimNum)) continue;
            fieldTableKey = mbgDim2.getRefField() + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER;
            if (relFields.contains(field) || refDimMap.containsKey(field) || DimensionConstants.DEF_CSL_FIELD.equals(field) || params.containsKey(fieldTableKey)) continue;
            long begin = System.currentTimeMillis();
            logger.debug((Object)("optimize begin dimension - " + field));
            if (cantCalcDim != null && cantCalcDim.contains(mbgDimNum)) {
                useCalcSet.add(mbgDimNum);
                MbgLoggerUtils.logger((String)("start getRefMemberNums " + mbgDimNum));
                numberSet = OptimizeUtils.getRefMemberNums(mbgDimNum, field, parameter);
                MbgLoggerUtils.logger((String)("end getRefMemberNums " + mbgDimNum));
            } else {
                numberSet = viewMembers.get(viewId);
                if (numberSet != null && !numberSet.isEmpty()) {
                    MbgLoggerUtils.logger((String)("start getRefMemberNums " + mbgDimNum));
                    refSet = OptimizeUtils.getRefMemberNums(mbgDimNum, field, parameter);
                    MbgLoggerUtils.logger((String)("end getRefMemberNums " + mbgDimNum));
                    if (refSet != null && !refSet.isEmpty()) {
                        numberSet.addAll(refSet);
                    }
                    if (refDimMap.containsKey(mbgDimNum) && (tmpSet = refDimMap.get(mbgDimNum)) != null && !tmpSet.isEmpty()) {
                        numberSet.addAll(tmpSet);
                    }
                }
            }
            if (numberSet != null && !numberSet.isEmpty()) {
                MbgLoggerUtils.logger((String)("start queryLongNumber " + mbgDimNum));
                longSet = DimUtils.queryLongNumber(ctx, conn, parameter, mbgDim2, numberSet);
                MbgLoggerUtils.logger((String)("end queryLongNumber " + mbgDimNum));
                if (longSet != null && !longSet.isEmpty()) {
                    MbgLoggerUtils.logger((String)("start getNumberByLongNumber " + mbgDimNum));
                    tmpSet = OptimizeUtils.getNumberByLongNumber(longSet);
                    MbgLoggerUtils.logger((String)("end getNumberByLongNumber " + mbgDimNum));
                } else {
                    tmpSet = null;
                }
                MbgLoggerUtils.logger((String)("start querySubData " + mbgDimNum));
                tmpSubTable = MbgVirtualView.querySubData((Context)ctx, (Connection)conn, (MbgDimInfo)mbgDim2, (BOSUuid)BOSUuid.read((String)viewId), numberSet, tmpSet);
                MbgLoggerUtils.logger((String)("end querySubData " + mbgDimNum));
                if (tmpSubTable != null) {
                    params.put(mbgDim2.getRefField() + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER, tmpSubTable);
                    parameter.getTempTableManager(ctx).getTempTables().add(tmpSubTable);
                }
            }
            logger.debug((Object)("optimize over dimension - " + field + "! use = " + (System.currentTimeMillis() - begin)));
        }
        if (cantCalcDim != null) {
            for (String _mbgDimNum : cantCalcDim) {
                if (useCalcSet.contains(_mbgDimNum)) continue;
                field = ((MbgDimInfo)_mbgDims.get(_mbgDimNum)).getRefField();
                mbgDim2 = mbgDims.get(field);
                fieldTableKey = mbgDim2.getRefField() + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER;
                if (relFields.contains(field) || refDimMap.containsKey(field) || DimensionConstants.DEF_CSL_FIELD.equals(field) || params.containsKey(fieldTableKey)) continue;
                long begin = System.currentTimeMillis();
                logger.debug((Object)("optimize begin dimension - " + field));
                numberSet = OptimizeUtils.getRefMemberNums(_mbgDimNum, field, parameter);
                if (numberSet != null && !numberSet.isEmpty() && (tmpSubTable = MbgVirtualView.querySubData((Context)ctx, (Connection)conn, (MbgDimInfo)mbgDim2, (BOSUuid)(uuid = parameter.getDataManager().getBgScheme().getViewId(_mbgDimNum)), numberSet, tmpSet = (longSet = DimUtils.queryLongNumber(ctx, conn, parameter, mbgDim2, numberSet)) != null && !longSet.isEmpty() ? OptimizeUtils.getNumberByLongNumber(longSet) : null)) != null) {
                    params.put(fieldTableKey, tmpSubTable);
                    parameter.getTempTableManager(ctx).getTempTables().add(tmpSubTable);
                }
                logger.debug((Object)("optimize over dimension - " + field + "! use = " + (System.currentTimeMillis() - begin)));
            }
        }
        MbgLoggerUtils.logger((String)"end getRefMemberNums");
    }

    private static Set<String> getNumberByLongNumber(Set<String> longNumSet) {
        HashSet<String> numbers = new HashSet<String>();
        if (longNumSet == null || longNumSet.isEmpty()) {
            return numbers;
        }
        String[] nums = null;
        for (String _longNumber : longNumSet) {
            if (StringUtils.isEmpty((String)_longNumber)) continue;
            nums = _longNumber.split("!");
            int jn = nums.length;
            for (int j = 0; j < jn; ++j) {
                numbers.add(nums[j]);
            }
        }
        return numbers;
    }

    private static Set<String> getRefMemberNums(String dimNumber, String dimField, IDimensionParameter parameter) {
        int i;
        int in;
        List<String[]> relationData;
        HashSet<String> memberNums = new HashSet<String>();
        if (dimNumber == null || dimField == null || parameter == null) {
            return memberNums;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(dimNumber);
        if (dimension != null) {
            int in2 = dimension.getDimensionMember().size();
            for (int i2 = 0; i2 < in2; ++i2) {
                memberNums.add(dimension.getDimensionMember().get(i2).getNumber());
            }
        }
        if (parameter.getDataManager().getRelation() != null && !parameter.getDataManager().getRelation().isEmpty() && (relationData = parameter.getDataManager().getRelationData(parameter)) != null && !relationData.isEmpty()) {
            String[] relField = null;
            String[] relData = null;
            relField = relationData.get(0);
            in = relField.length;
            for (i = 0; i < in; ++i) {
                if (!dimField.equals(relField[i])) continue;
                int jn = relationData.size();
                for (int j = 1; j < jn; ++j) {
                    relData = relationData.get(j);
                    memberNums.add(DimUtils.getNumber(relData[i]));
                }
                break;
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IDimension mbgDim = null;
            for (IQueryData queryData : parameter.getQuerys()) {
                mbgDim = queryData.getMbgDimMap().get(dimField);
                if (mbgDim == null) continue;
                in = mbgDim.getMembers().size();
                for (i = 0; i < in; ++i) {
                    memberNums.add(mbgDim.getMembers().get(i).getNumber());
                }
            }
        }
        return memberNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> queryViewIds(Connection conn, List<BOSUuid> viewIds, Set<String> cslDimSet) throws Exception {
        HashMap<String, String> viewIdMap = new HashMap<String, String>();
        if (conn == null || viewIds == null || viewIds.isEmpty()) {
            return viewIdMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select m.FNumber, m.FReffield, v.FID from T_MBG_MbgView v join T_MBG_MbgDim m on v.FMbgDimId = m.FID where v.FID in (");
        for (BOSUuid viewId : viewIds) {
            sql.append("'" + viewId.toString() + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") and v.FSegregationRule = 0");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                if (cslDimSet == null) {
                    viewIdMap.put(rst.getString("FReffield"), rst.getString("FID"));
                    continue;
                }
                if (cslDimSet == null || !cslDimSet.contains(rst.getString("FNumber"))) continue;
                viewIdMap.put(rst.getString("FReffield"), rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return viewIdMap;
    }

    private static List<String> getOrgNums(com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        ArrayList<String> orgUnitNums = new ArrayList<String>();
        if (dimension == null || dimension.getDimensionMember().isEmpty()) {
            return orgUnitNums;
        }
        int in = dimension.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            orgUnitNums.add(dimension.getDimensionMember().get(i).getNumber());
        }
        return orgUnitNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> queryOrgUnitIds(Context ctx, Connection conn, BOSUuid unionId, BOSUuid orgUnitId, BOSUuid orgViewId, List<String> orgUnitNums) throws Exception {
        HashSet<String> orgUnitIds;
        block19: {
            orgUnitIds = new HashSet<String>();
            if (conn == null || orgUnitNums == null) {
                return orgUnitIds;
            }
            IRowSet rst = null;
            String longNumber = null;
            String[] nums = null;
            HashSet<String> numberSet = new HashSet<String>();
            try {
                int i;
                ArrayList<String> _orgUnitNums;
                block22: {
                    block21: {
                        block18: {
                            _orgUnitNums = new ArrayList<String>();
                            if (unionId == null || orgUnitId == null) break block21;
                            try {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FLongNumber from T_ORG_STRUCTURE where FTreeId = ? and FUnitId = ?", (Object[])new Object[]{unionId.toString(), orgUnitId.toString()});
                                if (rst.next()) {
                                    longNumber = rst.getString("FLongNumber") + "!%";
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                                if (longNumber == null) break block18;
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_ORG_CostCenter where FID IN (select FUnitId from T_ORG_STRUCTURE where FTreeId = ? and FLongNumber like ?)", (Object[])new Object[]{unionId.toString(), longNumber});
                                while (rst.next()) {
                                    _orgUnitNums.add(rst.getString("FNumber"));
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst);
                                throw throwable;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        break block22;
                    }
                    if (orgUnitId != null) {
                        OrgUnitInfo unitInfo = MbgDataHelper.getOrgUnitInfo(conn, ctx.getLocale(), orgUnitId);
                        if (unitInfo != null) {
                            _orgUnitNums.add(unitInfo.getNumber());
                        }
                    } else {
                        _orgUnitNums.addAll(orgUnitNums);
                    }
                }
                if (_orgUnitNums.isEmpty()) break block19;
                StringBuffer sql = new StringBuffer();
                sql.append("select FID ,FOrgUnitId from T_MBG_BgOrgUnit where ");
                Object[] obj = null;
                List objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FID, FOrgUnitId ,FLongNumber from T_MBG_BgOrgUnit where FISVIRTUAL = 0 AND FVIEWID = '" + orgViewId + "' AND FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), _orgUnitNums);
                int in = objs.size();
                for (i = 0; i < in; ++i) {
                    obj = (Object[])objs.get(i);
                    orgUnitIds.add((String)obj[1]);
                    longNumber = (String)obj[2];
                    if (StringUtils.isEmpty((String)longNumber)) continue;
                    nums = longNumber.split("!");
                    int jn = nums.length;
                    for (int j = 0; j < jn; ++j) {
                        numberSet.add(nums[j]);
                    }
                    sql.append("(FLongNumber = '" + longNumber + "' OR FLongNumber like '" + longNumber + "!%') OR ");
                }
                sql.delete(sql.length() - 4, sql.length());
                try {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                    while (rst.next()) {
                        orgUnitIds.add(rst.getString("FOrgUnitId"));
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
                _orgUnitNums.clear();
                _orgUnitNums.addAll(numberSet);
                objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FID from T_ORG_CostCenter where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), _orgUnitNums);
                in = objs.size();
                for (i = 0; i < in; ++i) {
                    obj = (Object[])objs.get(i);
                    orgUnitIds.add((String)obj[0]);
                }
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        }
        return orgUnitIds;
    }

    private static Set<String> queryCslOrgUnitIds(Context ctx, Connection conn, BOSUuid unionId, BOSUuid orgUnitId, List<String> orgUnitNums) throws Exception {
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (conn == null || unionId == null) {
            return orgUnitIds;
        }
        if (orgUnitId != null) {
            orgUnitIds.add(orgUnitId.toString());
        }
        if (orgUnitNums != null && !orgUnitNums.isEmpty()) {
            ArrayList<String> _orgUnitNums = new ArrayList<String>();
            _orgUnitNums.addAll(orgUnitNums);
            List objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)("select FID from T_ORG_BaseUnit where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), _orgUnitNums);
            for (Object[] obj : objs) {
                orgUnitIds.add((String)obj[0]);
            }
        }
        return orgUnitIds;
    }

    private static Map<String, Set<String>> queryMembers(Context ctx, Connection conn, Collection<String> viewIds, Collection<String> orgUnitIds, IDimensionParameter parameter) throws Exception {
        return parameter.getCacheUtils().queryMembers(ctx, conn, viewIds, orgUnitIds, parameter);
    }

    public static void OptimizeDimension(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> standbyDim) throws SQLException {
        Set<String> noOptizeFields = OptimizeUtils.BeforeCheckOptimize(parameter);
        OptimizeUtils.OptimizePeriod(conn, parameter, params, noOptizeFields);
        OptimizeUtils.OptimizeCurrency(conn, parameter, params, filterDimMap, noOptizeFields);
        OptimizeUtils.OptimizeElement(conn, parameter, params, filterDimMap, noOptizeFields);
        OptimizeUtils.OptimizeScenario(conn, parameter, params, filterDimMap, noOptizeFields);
        OptimizeUtils.OptimizeCsl(conn, parameter, params, filterDimMap, standbyDim, noOptizeFields);
        OptimizeUtils.OptimizeVersion(conn, parameter, params, filterDimMap, noOptizeFields);
    }

    private static Set<String> BeforeCheckOptimize(IDimensionParameter parameter) {
        HashSet<String> fields = new HashSet<String>();
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim : parameter.getDims()) {
            if (dim == null) continue;
            fields.add(dim.getField());
        }
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim : parameter.getDims()) {
            if (DimensionConstants.necessary.contains(dim.getNumber()) || dim.getDimensionMember().size() != 1 || !dim.getNumber().equals(dim.getDimensionMember().get(0).getNumber())) continue;
            fields.remove(dim.getField());
        }
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        OptimizeUtils.RemvoeRelationField(fields, relationData);
        if (parameter.getQuerys() != null) {
            for (IQueryData query : parameter.getQuerys()) {
                for (IDimension cDim : query.getMbgDimMap().values()) {
                    if (DimensionConstants.necessary.contains(cDim.getNumber()) || cDim.getMembers().size() != 1 || !cDim.getNumber().equals(cDim.getMembers().get(0).getNumber())) continue;
                    fields.remove(cDim.getField());
                }
                if (query.getFilters() == null) continue;
                OptimizeUtils.RemvoeRelationField(fields, query.getFilters()[1]);
            }
        }
        fields.remove(DimensionConstants.DEF_ORGUNIT_FIELD);
        return fields;
    }

    private static void RemvoeRelationField(Set<String> fields, List<String[]> relationData) {
        if (relationData != null && relationData.size() > 1) {
            String[] refFields;
            for (String refField : refFields = relationData.get(0)) {
                fields.remove(RelationUtils.convertRefField(refField));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OptimizePeriod(Connection conn, IDimensionParameter parameter, Map<String, String> params, Set<String> noOptizeFields) throws SQLException {
        if (conn == null || parameter == null || params == null) {
            return;
        }
        if (params.containsKey(DimensionConstants.PERIOD_SQL)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        BgSchemeInfo schemeInfo = parameter.getDataManager().getBgScheme();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<BOSUuid> periodViewIds = schemeInfo.getBgPeriodViewIds();
        if (periodViewIds != null && !periodViewIds.isEmpty()) {
            if (!parameter.getControlManager().isFiscalYear()) {
                if (periodViewIds.size() == 1) {
                    sql.append("select p.* from " + DimensionConstants.CUBE_NAME + " p where exists (select FNumber from T_MBG_BGPERIODDisp where FNumber = p.FNumber and FTypeId = '" + periodViewIds.get(0).toString() + "')");
                } else {
                    HashSet<String> bgPeriodNumbers = new HashSet<String>();
                    if (parameter.getDataManager().getCalcStrategy() != null && parameter.getDataManager().getCalcStrategy().getRefNumMap() != null && parameter.getDataManager().getCalcStrategy().getRefNumMap().get(DimensionConstants.DEF_PERIOD_FIELD) != null) {
                        bgPeriodNumbers.addAll((Collection)parameter.getDataManager().getCalcStrategy().getRefNumMap().get(DimensionConstants.DEF_PERIOD_FIELD));
                    }
                    if (parameter.getPeriodDimension() != null) {
                        for (com.kingdee.eas.ma.mbg.dimension.face.IMember m : parameter.getPeriodDimension().getDimensionMember()) {
                            bgPeriodNumbers.add(m.getNumber());
                        }
                    }
                    if (parameter.getQuerys() != null) {
                        int in = parameter.getQuerys().size();
                        for (int i = 0; i < in; ++i) {
                            IDimension iDimension = parameter.getQuerys().get(i).getMbgDimMap().get(DimensionConstants.DEF_PERIOD_FIELD);
                            if (iDimension != null) {
                                for (IMember m : iDimension.getMembers()) {
                                    bgPeriodNumbers.add(m.getNumber());
                                }
                            }
                            for (IDimension dim : parameter.getQuerys().get(i).getDims()) {
                                if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) continue;
                                for (IMember m : dim.getMembers()) {
                                    bgPeriodNumbers.add(m.getNumber());
                                }
                            }
                        }
                    }
                    int oneBatchCount = 300;
                    List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgPeriodNumbers.toArray(), (int)oneBatchCount);
                    StringBuffer sqltypes = new StringBuffer();
                    sqltypes.append("select FTypeId FROM T_MBG_BGPERIODDisp Where FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sqltypes, (int)oneBatchCount).append(")");
                    HashSet typeids = null;
                    try {
                        typeids = new HashSet(MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sqltypes.toString(), (List)paramList));
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    sql.append("select p.* from " + DimensionConstants.CUBE_NAME + " p where exists (select FNumber from T_MBG_BGPERIODDisp where FNumber = p.FNumber and FTypeId IN (");
                    for (BOSUuid uuid : periodViewIds) {
                        if (typeids != null && !typeids.contains(uuid.toString())) continue;
                        sql.append("'" + uuid.toString() + "',");
                    }
                    sql.setLength(sql.length() - 1);
                    sql.append("))");
                }
            } else {
                if (BgDBUtils.existColumn((Connection)conn, (String)ClosureUtils.HK_PERIOD_TABLE_FACT, (String)"FBEGINDATE") == BgDBUtils.NO) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + ClosureUtils.HK_PERIOD_TABLE_FACT + " ADD FBeginDate DateTime"));
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update " + ClosureUtils.HK_PERIOD_TABLE_FACT + " set FBeginDate = (select FBeginDate from T_MBG_BGPERIOD where FNumber = " + ClosureUtils.HK_PERIOD_TABLE_FACT + ".FNumber)"));
                }
                if (BgDBUtils.existColumn((Connection)conn, (String)ClosureUtils.HK_PERIOD_TABLE_FACT, (String)"FENDDATE") == BgDBUtils.NO) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + ClosureUtils.HK_PERIOD_TABLE_FACT + " ADD FEndDate DateTime"));
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update " + ClosureUtils.HK_PERIOD_TABLE_FACT + " set FEndDate = (select FEndDate from T_MBG_BGPERIOD where FNumber = " + ClosureUtils.HK_PERIOD_TABLE_FACT + ".FNumber)"));
                }
                com.kingdee.eas.ma.mbg.dimension.face.IDimension bgPeriodDim = parameter.getDimension(DimensionConstants.DEF_PERIOD_FIELD);
                HashSet<String> refBgTypeNumbers = new HashSet<String>();
                if (bgPeriodDim != null && bgPeriodDim.getDimensionMember().size() > 0) {
                    int i;
                    ArrayList<String> periodList = new ArrayList<String>();
                    int in = bgPeriodDim.getDimensionMember().size();
                    for (int i2 = 0; i2 < in; ++i2) {
                        com.kingdee.eas.ma.mbg.dimension.face.IMember member = bgPeriodDim.getDimensionMember().get(i2);
                        periodList.add(member.getNumber());
                    }
                    StringBuffer _sql = new StringBuffer();
                    _sql.append("select t2.fnumber from t_mbg_bgperioddisp t1 inner join t_mbg_bgperiodtype t2 on t1.FTYPEID = t2.fid");
                    _sql.append(" where t2.fid in (");
                    for (i = 0; i < periodViewIds.size(); ++i) {
                        if (i == periodViewIds.size() - 1) {
                            _sql.append("'").append(periodViewIds.get(i).toString()).append("')");
                            continue;
                        }
                        _sql.append("'").append(periodViewIds.get(i).toString()).append("',");
                    }
                    _sql.append(" and t1.fnumber in (");
                    for (i = 0; i < 50; ++i) {
                        if (i == 49) {
                            _sql.append("?)");
                            continue;
                        }
                        _sql.append("?,");
                    }
                    _sql.append(" group by t2.fnumber");
                    List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)_sql.toString(), periodList);
                    if (result != null && !result.isEmpty()) {
                        for (int i3 = 0; i3 < result.size(); ++i3) {
                            refBgTypeNumbers.add((String)((Object[])result.get(i3))[0]);
                        }
                    }
                }
                if (parameter.getQuerys() != null) {
                    int in = parameter.getQuerys().size();
                    for (int i = 0; i < in; ++i) {
                        IDimension iDimension = parameter.getQuerys().get(i).getMbgDimMap().get(DimensionConstants.DEF_PERIOD_FIELD);
                        if (iDimension != null) {
                            for (IMember m : iDimension.getMembers()) {
                                refBgTypeNumbers.add(m.getNumber().substring(0, m.getNumber().indexOf(".")));
                            }
                        }
                        for (IDimension dim : parameter.getQuerys().get(i).getDims()) {
                            if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) continue;
                            for (IMember m : dim.getMembers()) {
                                refBgTypeNumbers.add(m.getNumber().substring(0, m.getNumber().indexOf(".")));
                            }
                        }
                    }
                }
                HashSet<String> bgTypeNumbers = new HashSet<String>();
                if (!refBgTypeNumbers.isEmpty()) {
                    bgTypeNumbers.addAll(refBgTypeNumbers);
                }
                if (parameter.getBgPeriodParentMap() != null && !parameter.getBgPeriodParentMap().isEmpty()) {
                    for (String periodNumber : parameter.getBgPeriodParentMap().values()) {
                        String num = periodNumber.substring(0, periodNumber.indexOf("."));
                        if (!refBgTypeNumbers.isEmpty()) {
                            if (!refBgTypeNumbers.contains(num)) continue;
                            bgTypeNumbers.add(periodNumber.substring(0, periodNumber.indexOf(".")));
                            continue;
                        }
                        bgTypeNumbers.add(periodNumber.substring(0, periodNumber.indexOf(".")));
                    }
                }
                if (bgPeriodDim != null) {
                    int in = bgPeriodDim.getDimensionMember().size();
                    for (int i = 0; i < in; ++i) {
                        com.kingdee.eas.ma.mbg.dimension.face.IMember member = bgPeriodDim.getDimensionMember().get(i);
                        if (member.getMdxNumber().indexOf("!") >= 0) continue;
                        bgTypeNumbers.add(member.getMdxNumber().substring(0, member.getMdxNumber().indexOf(".")));
                    }
                }
                if (!bgTypeNumbers.isEmpty()) {
                    IRowSet rst = null;
                    try {
                        StringBuffer sql1 = new StringBuffer("Select FID FROM T_MBG_BgPeriodType Where FNumber IN(");
                        boolean isFirst = true;
                        for (String typeNumber : bgTypeNumbers) {
                            if (!isFirst) {
                                sql1.append(",");
                            }
                            sql1.append("'").append(typeNumber).append("'");
                            isFirst = false;
                        }
                        sql1.append(")");
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql1.toString());
                        periodViewIds = new ArrayList<BOSUuid>();
                        while (rst.next()) {
                            periodViewIds.add(BOSUuid.read((String)rst.getString(1)));
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                if (periodViewIds.size() == 1) {
                    sql.append("select p.* from " + DimensionConstants.CUBE_NAME + " p where p.FTypeId = '" + periodViewIds.get(0).toString() + "'");
                } else {
                    sql.append("select p.* from " + DimensionConstants.CUBE_NAME + " p where p.FTypeId IN (");
                    for (BOSUuid uuid : periodViewIds) {
                        sql.append("'" + uuid.toString() + "',");
                    }
                    sql.setLength(sql.length() - 1);
                    sql.append(")");
                }
            }
            sql.append(" and ((p.FBeginDate >= {ts'" + format.format(schemeInfo.getDateFrom()) + "'} and p.FEndDate <= {ts'" + format.format(schemeInfo.getDateTo()) + "'})");
            sql.append(" or (p.FBeginDate <= {ts'" + format.format(schemeInfo.getDateFrom()) + "'} and p.FEndDate >= {ts'" + format.format(schemeInfo.getDateTo()) + "'})");
            sql.append(" or (p.FBeginDate >= {ts'" + format.format(schemeInfo.getDateFrom()) + "'} and p.FBeginDate <= {ts'" + format.format(schemeInfo.getDateTo()) + "'})");
            sql.append(" or (p.FEndDate >= {ts'" + format.format(schemeInfo.getDateFrom()) + "'} and p.FEndDate <= {ts'" + format.format(schemeInfo.getDateTo()) + "'})");
            sql.append(" or (" + DimensionConstants.PERIOD_SELF_SQL + "))");
        }
        params.put(DimensionConstants.PERIOD_SQL, sql.toString());
    }

    private static boolean checkCanOptizeField(Set<String> noOptizeFields, String field) {
        if (noOptizeFields.isEmpty()) {
            return false;
        }
        return noOptizeFields.size() != 1 || !noOptizeFields.contains(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OptimizeCurrency(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> noOptizeFields) throws SQLException {
        String[] relFields;
        if (conn == null || parameter == null || params == null || filterDimMap == null) {
            return;
        }
        if (filterDimMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_NUMBER)) {
            return;
        }
        if (params.containsKey(DimensionConstants.REMOVE_CURRENCY_MEMBER)) {
            return;
        }
        boolean isOneCurrency = true;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        IMember mbgMember = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 = null;
        IDimension mbgDim2 = null;
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty() && (relFields = relationData.get(0)) != null) {
            int in = relFields.length;
            for (int i = 0; i < in; ++i) {
                if (!DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(relFields[i])) continue;
                return;
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            HashSet<String> numbers = new HashSet<String>();
            block6: for (IQueryData queryData : parameter.getQuerys()) {
                if (queryData.getFilters() != null && queryData.getFilters().length > 0) {
                    int in = queryData.getFilters().length;
                    for (int i = 0; i < in; ++i) {
                        String[] relFields2;
                        List<String[]> _filters = queryData.getFilters()[i];
                        if (_filters == null || _filters.isEmpty() || (relFields2 = _filters.get(0)) == null) continue;
                        int jn = relFields2.length;
                        for (int j = 0; j < jn; ++j) {
                            if (!DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(relFields2[j])) continue;
                            return;
                        }
                    }
                }
                for (IDimension mbgDim2 : queryData.getMbgDimMap().values()) {
                    if (!DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(mbgDim2.getField()) || mbgDim2.getMembers().isEmpty()) continue;
                    mbgMember = mbgDim2.getMembers().get(0);
                    if (mbgMember != null && !StringUtils.isEmpty((String)mbgMember.getNumber())) {
                        numbers.add(mbgMember.getNumber());
                    }
                    if (numbers.size() <= 1 && !OptimizeUtils.checkCanntRemove(mbgDim2, parameter)) continue;
                    isOneCurrency = false;
                    continue block6;
                }
            }
        }
        if (isOneCurrency) {
            for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 : parameter.getDimensionMap().values()) {
                if (!DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(dim2.getNumber()) || dim2.getDimensionMember().isEmpty()) continue;
                member = dim2.getDimensionMember().get(0);
                if (!OptimizeUtils.checkCanntRemove(dim2, parameter)) continue;
                isOneCurrency = false;
                break;
            }
        }
        if (isOneCurrency && OptimizeUtils.checkCanOptizeField(noOptizeFields, DimensionConstants.DEF_CURRENCY_FIELD)) {
            if (mbgMember != null && member != null && !mbgMember.getNumber().equals(member.getNumber())) {
                return;
            }
            if (mbgMember != null) {
                parameter.getDataManager().setDefCurrency(new String[]{mbgMember.getNumber(), mbgMember.getName()});
            } else if (member != null) {
                parameter.getDataManager().setDefCurrency(new String[]{member.getNumber(), member.getName()});
            }
            if (parameter.getDataManager().getDefCurrency() == null) {
                return;
            }
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, parameter.getRowDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, parameter.getColDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, parameter.getPageDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, parameter.getDimensionMap());
            if (!parameter.getQuerys().isEmpty()) {
                for (IQueryData queryData : parameter.getQuerys()) {
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, queryData.getRows());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, queryData.getCols());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER, queryData.getViews());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_CURRENCY_FIELD, queryData.getMbgDimMap());
                }
            }
            String currencyId = null;
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_BD_Currency where FNumber = ?", (Object[])new Object[]{parameter.getDataManager().getDefCurrency()[0]});
                if (rst.next()) {
                    currencyId = rst.getString("FID");
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (Exception ex) {
                logger.error((Object)"OptimizeCurrency error: ", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
            noOptizeFields.remove(DimensionConstants.DEF_CURRENCY_FIELD);
            params.put(DimensionConstants.REMOVE_CURRENCY, DimensionConstants.REMOVE_CURRENCY);
            params.put(DimensionConstants.REMOVE_CURRENCY_MEMBER, currencyId);
        }
    }

    private static Object removeDimension(String dimNumber, List dims) {
        if (dimNumber == null || dims == null || dims.isEmpty()) {
            return null;
        }
        Object obj = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        IDimension mbgDim = null;
        for (int i = dims.size() - 1; i >= 0; --i) {
            obj = dims.get(i);
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dim = obj;
                if (!dimNumber.equals(dim.getNumber())) continue;
                dims.remove(i);
                return dim;
            }
            if (!(mbgDim instanceof IDimension) || !dimNumber.equals((mbgDim = (IDimension)obj).getNumber())) continue;
            dims.remove(i);
            return mbgDim;
        }
        return null;
    }

    private static void removeDimension(String dimNumber, Map dimMap) {
        if (dimNumber == null || dimMap == null || dimMap.isEmpty()) {
            return;
        }
        dimMap.remove(dimNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OptimizeElement(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> noOptizeFields) throws SQLException {
        Object relFields;
        if (conn == null || parameter == null || params == null || filterDimMap == null) {
            return;
        }
        if (filterDimMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_NUMBER)) {
            return;
        }
        if (params.containsKey(DimensionConstants.REMOVE_ELEMENT_MEMBER)) {
            return;
        }
        boolean isOneElement = true;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        IMember mbgMember = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 = null;
        IDimension mbgDim2 = null;
        HashSet<String> mbgMemberNums = new HashSet<String>();
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty() && (relFields = relationData.get(0)) != null) {
            int in = ((Object)relFields).length;
            for (int i = 0; i < in; ++i) {
                if (!DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(relFields[i])) continue;
                return;
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            block6: for (IQueryData queryData : parameter.getQuerys()) {
                if (queryData.getFilters() != null && queryData.getFilters().length > 0) {
                    int in = queryData.getFilters().length;
                    for (int i = 0; i < in; ++i) {
                        String[] relFields2;
                        List<String[]> _filters = queryData.getFilters()[i];
                        if (_filters == null || _filters.isEmpty() || (relFields2 = _filters.get(0)) == null) continue;
                        int jn = relFields2.length;
                        for (int j = 0; j < jn; ++j) {
                            if (!DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(relFields2[j])) continue;
                            return;
                        }
                    }
                }
                for (IDimension mbgDim2 : queryData.getMbgDimMap().values()) {
                    if (!DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(mbgDim2.getField()) || mbgDim2.getMembers().isEmpty()) continue;
                    mbgMember = mbgDim2.getMembers().get(0);
                    mbgMemberNums.add(mbgMember.getNumber());
                    if (!OptimizeUtils.checkCanntRemove(mbgDim2, parameter)) continue;
                    isOneElement = false;
                    continue block6;
                }
            }
        }
        if (isOneElement) {
            for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 : parameter.getDimensionMap().values()) {
                if (!DimensionBaseConstants.DEF_ELEMENT_NUMBER.equals(dim2.getNumber()) || dim2.getDimensionMember().isEmpty()) continue;
                member = dim2.getDimensionMember().get(0);
                if (OptimizeUtils.checkCanntRemove(dim2, parameter)) {
                    isOneElement = false;
                    break;
                }
                if (!parameter.getDataManager().getNotAggEle().contains(member.getNumber())) continue;
                isOneElement = false;
                break;
            }
        }
        if (isOneElement && OptimizeUtils.checkCanOptizeField(noOptizeFields, DimensionConstants.DEF_ELEMENT_FIELD)) {
            if (mbgMember != null && member != null && !mbgMember.getNumber().equals(member.getNumber())) {
                return;
            }
            if (mbgMember != null) {
                parameter.getDataManager().setDefElement(new String[]{mbgMember.getNumber(), mbgMember.getName()});
            } else if (member != null) {
                parameter.getDataManager().setDefElement(new String[]{member.getNumber(), member.getName()});
            }
            if (parameter.getDataManager().getDefElement() == null) {
                return;
            }
            if (mbgMember != null && !StringUtils.isEmpty((String)mbgMember.getNumber())) {
                for (String num : mbgMemberNums) {
                    if (mbgMember.getNumber().equals(num)) continue;
                    return;
                }
            }
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, parameter.getRowDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, parameter.getColDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, parameter.getPageDims());
            OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, parameter.getDimensionMap());
            if (!parameter.getQuerys().isEmpty()) {
                for (IQueryData queryData : parameter.getQuerys()) {
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, queryData.getRows());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, queryData.getCols());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_NUMBER, queryData.getViews());
                    OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_ELEMENT_FIELD, queryData.getMbgDimMap());
                }
            }
            noOptizeFields.remove(DimensionConstants.DEF_ELEMENT_FIELD);
            String elementId = null;
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgElement where FNumber = ?", (Object[])new Object[]{parameter.getDataManager().getDefElement()[0]});
                if (rst.next()) {
                    elementId = rst.getString("FID");
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (Exception ex) {
                logger.error((Object)"OptimizeElement error: ", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
            if (elementId != null) {
                params.put(DimensionConstants.REMOVE_ELEMENT, DimensionConstants.REMOVE_ELEMENT);
                params.put(DimensionConstants.REMOVE_ELEMENT_MEMBER, elementId);
            }
        }
    }

    public static void OptimizeVersion(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> noOptizeFields) {
        String[] relFields;
        if (conn == null || parameter == null || params == null) {
            return;
        }
        if (filterDimMap.containsKey(DimensionBaseConstants.DEF_VERSION_NUMBER)) {
            return;
        }
        if (params.containsKey(DimensionConstants.REMOVE_VERSION_MEMBER)) {
            return;
        }
        boolean isOneVersion = true;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        IMember mbgMember = null;
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty() && (relFields = relationData.get(0)) != null) {
            int in = relFields.length;
            for (int i = 0; i < in; ++i) {
                if (!DimensionBaseConstants.DEF_VERSION_FIELD.equals(relFields[i])) continue;
                return;
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IDimension mbgDim2 = null;
            block1: for (IQueryData queryData : parameter.getQuerys()) {
                if (queryData.getFilters() != null && queryData.getFilters().length > 0) {
                    int in = queryData.getFilters().length;
                    for (int i = 0; i < in; ++i) {
                        String[] relFields2;
                        List<String[]> _filters = queryData.getFilters()[i];
                        if (_filters == null || _filters.isEmpty() || (relFields2 = _filters.get(0)) == null) continue;
                        int jn = relFields2.length;
                        for (int j = 0; j < jn; ++j) {
                            if (!DimensionBaseConstants.DEF_VERSION_FIELD.equals(relFields2[j])) continue;
                            return;
                        }
                    }
                }
                for (IDimension mbgDim2 : queryData.getMbgDimMap().values()) {
                    if (!DimensionBaseConstants.DEF_VERSION_FIELD.equals(mbgDim2.getField()) || mbgDim2.getMembers().isEmpty()) continue;
                    mbgMember = mbgDim2.getMembers().get(0);
                    if (!OptimizeUtils.checkCanntRemove(mbgDim2, parameter)) continue;
                    isOneVersion = false;
                    continue block1;
                }
            }
        }
        if (isOneVersion) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 = null;
            for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 : parameter.getDimensionMap().values()) {
                if (!DimensionBaseConstants.DEF_VERSION_NUMBER.equals(dim2.getNumber()) || dim2.getDimensionMember().isEmpty()) continue;
                member = dim2.getDimensionMember().get(0);
                if (!OptimizeUtils.checkCanntRemove(dim2, parameter)) continue;
                isOneVersion = false;
                break;
            }
        }
        if (isOneVersion && OptimizeUtils.checkCanOptizeField(noOptizeFields, DimensionConstants.DEF_VERSION_FIELD)) {
            if (mbgMember != null && member != null && !mbgMember.getNumber().equals(member.getNumber())) {
                return;
            }
            int innId = -1;
            String number = null;
            String name = null;
            if (mbgMember != null) {
                innId = mbgMember.getInnerId();
                name = mbgMember.getName();
            } else if (member != null) {
                innId = member.getInnerId();
                name = member.getName();
            }
            number = parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD).get(String.valueOf(innId));
            if (number != null && innId != -1) {
                parameter.getDataManager().setDefVersion(new String[]{number, name, String.valueOf(innId)});
            }
            if (parameter.getDataManager().getDefVersion() != null) {
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, parameter.getRowDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, parameter.getColDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, parameter.getPageDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, parameter.getDimensionMap());
                if (!parameter.getQuerys().isEmpty()) {
                    for (IQueryData queryData : parameter.getQuerys()) {
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, queryData.getRows());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, queryData.getCols());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_NUMBER, queryData.getViews());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_VERSION_FIELD, queryData.getMbgDimMap());
                    }
                }
                noOptizeFields.remove(DimensionConstants.DEF_VERSION_FIELD);
                params.put(DimensionConstants.REMOVE_VERSION, DimensionConstants.REMOVE_VERSION);
                params.put(DimensionConstants.REMOVE_VERSION_MEMBER, parameter.getDataManager().getDefVersion()[2]);
            }
        }
    }

    public static void OptimizeScenario(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> noOptizeFields) {
        String[] relFields;
        if (conn == null || parameter == null || params == null) {
            return;
        }
        if (filterDimMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_NUMBER)) {
            return;
        }
        if (params.containsKey(DimensionConstants.REMOVE_SCENARIO_MEMBER)) {
            return;
        }
        boolean isOneScenario = true;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        IMember mbgMember = null;
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty() && (relFields = relationData.get(0)) != null) {
            int in = relFields.length;
            for (int i = 0; i < in; ++i) {
                if (!DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(relFields[i])) continue;
                return;
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            HashSet<String> numbers = new HashSet<String>();
            IDimension mbgDim2 = null;
            block1: for (IQueryData queryData : parameter.getQuerys()) {
                if (queryData.getFilters() != null && queryData.getFilters().length > 0) {
                    int in = queryData.getFilters().length;
                    for (int i = 0; i < in; ++i) {
                        String[] relFields2;
                        List<String[]> _filters = queryData.getFilters()[i];
                        if (_filters == null || _filters.isEmpty() || (relFields2 = _filters.get(0)) == null) continue;
                        int jn = relFields2.length;
                        for (int j = 0; j < jn; ++j) {
                            if (!DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(relFields2[j])) continue;
                            return;
                        }
                    }
                }
                for (IDimension mbgDim2 : queryData.getMbgDimMap().values()) {
                    if (!DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(mbgDim2.getField()) || mbgDim2.getMembers().isEmpty()) continue;
                    mbgMember = mbgDim2.getMembers().get(0);
                    if (mbgMember != null && !StringUtils.isEmpty((String)mbgMember.getNumber())) {
                        numbers.add(mbgMember.getNumber());
                    }
                    if (numbers.size() <= 1 && !OptimizeUtils.checkCanntRemove(mbgDim2, parameter)) continue;
                    isOneScenario = false;
                    continue block1;
                }
            }
        }
        if (isOneScenario) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 = null;
            for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim2 : parameter.getDimensionMap().values()) {
                if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dim2.getNumber()) || dim2.getDimensionMember().isEmpty()) continue;
                member = dim2.getDimensionMember().get(0);
                if (!OptimizeUtils.checkCanntRemove(dim2, parameter)) continue;
                isOneScenario = false;
                break;
            }
        }
        if (isOneScenario && OptimizeUtils.checkCanOptizeField(noOptizeFields, DimensionConstants.DEF_SCENARIO_FIELD)) {
            if (mbgMember != null && member != null && mbgMember.getNumber() != null && !mbgMember.getNumber().equals(member.getNumber())) {
                return;
            }
            int innId = -1;
            String number = null;
            String name = null;
            if (mbgMember != null) {
                innId = mbgMember.getInnerId();
                name = mbgMember.getName();
            } else if (member != null) {
                innId = member.getInnerId();
                name = member.getName();
            }
            number = parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_SCENARIO_FIELD).get(String.valueOf(innId));
            if (number != null && innId != -1) {
                parameter.getDataManager().setDefScenario(new String[]{number, name, String.valueOf(innId)});
            }
            if (parameter.getDataManager().getDefScenario() != null) {
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, parameter.getRowDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, parameter.getColDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, parameter.getPageDims());
                OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, parameter.getDimensionMap());
                if (!parameter.getQuerys().isEmpty()) {
                    for (IQueryData queryData : parameter.getQuerys()) {
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, queryData.getRows());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, queryData.getCols());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, queryData.getViews());
                        OptimizeUtils.removeDimension(DimensionBaseConstants.DEF_SCENARIO_FIELD, queryData.getMbgDimMap());
                    }
                }
                noOptizeFields.remove(DimensionConstants.DEF_SCENARIO_FIELD);
                params.put(DimensionConstants.REMOVE_SCENARIO, DimensionConstants.REMOVE_SCENARIO);
                params.put(DimensionConstants.REMOVE_SCENARIO_MEMBER, parameter.getDataManager().getDefScenario()[2]);
            }
        }
    }

    private static boolean checkCanntRemove(Object dim, IDimensionParameter parameter) {
        String dimNumber = null;
        int size = -1;
        if (dim instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
            dimNumber = ((com.kingdee.eas.ma.mbg.dimension.face.IDimension)dim).getNumber();
            size = ((com.kingdee.eas.ma.mbg.dimension.face.IDimension)dim).getDimensionMember().size();
        } else if (dim instanceof IDimension) {
            dimNumber = ((IDimension)dim).getNumber();
            size = ((IDimension)dim).getMembers().size();
        }
        if (size != 1) {
            return true;
        }
        ArrayList<List<IDimensionBase>> layouts = new ArrayList<List<IDimensionBase>>();
        layouts.add(parameter.getRowDims());
        layouts.add(parameter.getColDims());
        for (IQueryData iQueryData : parameter.getQuerys()) {
            layouts.add(iQueryData.getRows());
            layouts.add(iQueryData.getCols());
        }
        for (List list : layouts) {
            if (!OptimizeUtils.checkCanntRemove(dimNumber, list, parameter.getColDims().isEmpty(), parameter.getRelationDimNumbers())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkCanntRemove(String dimNumber, List dims, boolean isColEmpty, Set<String> relations) {
        if (dims == null || dims.isEmpty() || dims.size() == 1) {
            return false;
        }
        if (relations.contains(dimNumber)) {
            return true;
        }
        int index = -1;
        int minNoRelationIndex = -1;
        boolean hasMulti = false;
        Object obj = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = null;
        IDimension mbgDim = null;
        List<IMemberBase> members = null;
        String number = null;
        for (int i = dims.size() - 1; i >= 0; --i) {
            obj = dims.get(i);
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dim = obj;
                number = dim.getNumber();
                members = dim.getDimensionMember();
            } else {
                if (!(mbgDim instanceof IDimension)) continue;
                mbgDim = obj;
                number = mbgDim.getNumber();
                members = mbgDim.getMembers();
            }
            if (dimNumber.equals(number)) {
                index = i;
            }
            if (isColEmpty) {
                if (relations.contains(number)) continue;
                minNoRelationIndex = i;
                if (members.size() <= 1) continue;
                hasMulti = true;
                continue;
            }
            if (members.size() > 1) {
                hasMulti = true;
            }
            minNoRelationIndex = 0;
        }
        if (index < 0) {
            return false;
        }
        if (hasMulti) {
            return false;
        }
        return index == minNoRelationIndex;
    }

    public static void OptimizeCsl(Connection conn, IDimensionParameter parameter, Map<String, String> params, Map<String, Set<String>> filterDimMap, Set<String> standbyDim, Set<String> noOptizeFields) {
        if (conn == null || parameter == null || parameter.getUnionId() == null || params == null) {
            return;
        }
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty()) {
            for (String _field : relationData.get(0)) {
                if (!DimensionBaseConstants.DEF_CSL_FIELD.equals(_field)) continue;
                return;
            }
        }
        HashSet<String> cslNums = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension cslDim = parameter.getDimension(DimensionBaseConstants.DEF_CSL_FIELD);
        if (cslDim != null) {
            int in = cslDim.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                cslNums.add(cslDim.getDimensionMember().get(i).getDimNumber());
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IQueryData query = null;
            IDimension cslMbgDim = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                query = parameter.getQuerys().get(i);
                if (query.getFilters() != null) {
                    List<String[]> filter = query.getRowFilter();
                    if (filter != null && !filter.isEmpty()) {
                        for (String _field : filter.get(0)) {
                            if (!DimensionBaseConstants.DEF_CSL_FIELD.equals(_field)) continue;
                            return;
                        }
                    }
                    if ((filter = query.getColFilter()) != null && !filter.isEmpty()) {
                        for (String _field : filter.get(0)) {
                            if (!DimensionBaseConstants.DEF_CSL_FIELD.equals(_field)) continue;
                            return;
                        }
                    }
                }
                if ((cslMbgDim = query.getMbgDimMap().get(DimensionBaseConstants.DEF_CSL_FIELD)) == null) continue;
                int jn = cslMbgDim.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    cslNums.add(cslMbgDim.getMembers().get(j).getDimNumber());
                }
            }
        }
        if (!cslNums.isEmpty() && cslNums.size() == 1 && OptimizeUtils.checkCanOptizeField(noOptizeFields, DimensionConstants.DEF_CSL_FIELD)) {
            Set<String> tmpSet;
            String cslNum = (String)cslNums.iterator().next();
            if (filterDimMap != null && filterDimMap.containsKey(DimensionBaseConstants.DEF_CSL_NUMBER) && (tmpSet = filterDimMap.get(DimensionBaseConstants.DEF_CSL_NUMBER)).contains(cslNum)) {
                return;
            }
            noOptizeFields.remove(DimensionConstants.DEF_CSL_FIELD);
            params.put(DimensionConstants.REMOVE_CSL, DimensionConstants.REMOVE_CSL);
            params.put(DimensionConstants.REMOVE_CSL_MEMBER, "('" + cslNum + "')");
            if (standbyDim != null) {
                standbyDim.add(DimensionBaseConstants.DEF_CSL_NUMBER);
                parameter.getDataManager().getStandbyMap().put(DimensionBaseConstants.DEF_CSL_FIELD, cslNums);
            }
        }
    }

    public static void OptimizeBgIndex(Context ctx, Connection conn, IDimensionParameter parameter, Map<String, String> params) throws Exception {
        if (ctx == null || conn == null || parameter == null || params == null) {
            return;
        }
        if (params.containsKey(DimensionConstants.BGINDEX_FILTER)) {
            return;
        }
        HashSet<String> bgIndexNums = new HashSet<String>();
        HashSet<String> bgMdxNums = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(DimensionBaseConstants.DEF_INDEX_NUMBER);
        if (dimension != null) {
            int in = dimension.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                bgIndexNums.add(dimension.getDimensionMember().get(i).getDimNumber());
                bgMdxNums.add(dimension.getDimensionMember().get(i).getMdxNumber());
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IQueryData queryData = null;
            IDimension mbgDim = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                queryData = parameter.getQuerys().get(i);
                mbgDim = queryData.getMbgDimMap().get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                if (mbgDim == null) continue;
                int jn = mbgDim.getMembers().size();
                for (int j = 0; j < jn; ++j) {
                    bgIndexNums.add(mbgDim.getMembers().get(j).getDimNumber());
                    bgMdxNums.add(mbgDim.getMembers().get(j).getLongNumber());
                }
            }
        }
        String tmpBgIndexTable = null;
        if (!bgIndexNums.isEmpty() || !parameter.getDataManager().getCalcStrategy().getMembers().isEmpty()) {
            TempTablePool pool = parameter.getTempTableManager(ctx).getTempTablePool();
            try {
                MbgLoggerUtils.logger((String)"start OptimizeBgIndex Create Tmp Table");
                tmpBgIndexTable = pool.createTempTable("CREATE TABLE TEML_KSQL_BGI (FNumber NVARCHAR(84))");
                MbgLoggerUtils.logger((String)"start OptimizeBgIndex Create Tmp Table Index");
                MbgLoggerUtils.logger((String)"end OptimizeBgIndex Create Tmp Table");
                if (tmpBgIndexTable != null) {
                    MbgLoggerUtils.logger((String)("start OptimizeBgIndex Insert 1 " + bgIndexNums.size()));
                    long st = System.currentTimeMillis();
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert into " + tmpBgIndexTable + " (FNumber) values (?)"), bgIndexNums);
                    MbgLoggerUtils.logger((String)("end OptimizeBgIndex Insert 1 " + bgIndexNums.size() + " (" + (System.currentTimeMillis() - st) + "ms)"));
                    if (!parameter.getDataManager().getCalcStrategy().getMembers().isEmpty()) {
                        ArrayList<String> calcIds = new ArrayList<String>();
                        ICalcMember calcMember = null;
                        int in = parameter.getDataManager().getCalcStrategy().getMembers().size();
                        for (int i = 0; i < in; ++i) {
                            calcMember = (ICalcMember)parameter.getDataManager().getCalcStrategy().getMembers().get(i);
                            if (!(calcMember instanceof BizCalcMember)) continue;
                            calcIds.add(((BizCalcMember)calcMember).getCalc().getId().toString());
                        }
                        if (!calcIds.isEmpty()) {
                            MbgLoggerUtils.logger((String)"start OptimizeBgIndex Insert 2");
                            StringBuffer sql = new StringBuffer();
                            sql.append("Insert Into " + tmpBgIndexTable + " (FNumber) select distinct FBgIndexNum from T_MBG_BizCalcRefBgIndexEntry where exists (select FID from T_MBG_BizCalcRefBgIndex where FID = T_MBG_BizCalcRefBgIndexEntry.FRefID and FBizCalcID IN (" + BgDBUtils.getSqlParam() + "))");
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)sql.toString(), calcIds);
                            MbgLoggerUtils.logger((String)"end OptimizeBgIndex Insert 2");
                        }
                        HashSet<String> tmpSet = new HashSet<String>();
                        Object[] bgIndexNumbers = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("select FNumber from " + tmpBgIndexTable), null).toArray();
                        if (bgIndexNumbers != null && bgIndexNumbers.length > 0) {
                            for (int i = 0; i < bgIndexNumbers.length; ++i) {
                                if (bgIndexNumbers[i] == null || StringUtils.isEmpty((String)bgIndexNumbers[i].toString())) continue;
                                tmpSet.add(bgIndexNumbers[i].toString());
                            }
                            Map<String, String> tmpMap = DimUtils.queryItemLongNumber(ctx, parameter, parameter.getDataManager().getMbgDims().get(DimensionConstants.DEF_BGINDEX_FIELD), tmpSet);
                            if (tmpMap != null && !tmpMap.isEmpty()) {
                                int in2 = parameter.getDataManager().getCalcStrategy().getMembers().size();
                                for (int i = 0; i < in2; ++i) {
                                    calcMember = (ICalcMember)parameter.getDataManager().getCalcStrategy().getMembers().get(i);
                                    if (!(calcMember instanceof BizCalcMember) || ((BizCalcMember)calcMember).getMdxNumMap() == null || ((BizCalcMember)calcMember).getMdxNumMap().isEmpty() || ((BizCalcMember)calcMember).getMdxNumMap().containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) continue;
                                    ((BizCalcMember)calcMember).getMdxNumMap().put(DimensionConstants.DEF_BGINDEX_FIELD, tmpMap);
                                }
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"optimizeBgIndex sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Exception ex) {
                logger.error((Object)"create tmpTable error:", (Throwable)ex);
                throw ex;
            }
            finally {
                parameter.getTempTableManager(ctx).getTempTables().add(tmpBgIndexTable);
            }
            params.put(DimensionConstants.BGINDEX_FILTER, tmpBgIndexTable);
        }
    }

    public static void filterBizMember(List<ICalcMember> bizCalcMembers, IDimensionParameter parameter, Set<String> standbyDim) {
        if (bizCalcMembers == null || bizCalcMembers.isEmpty() || parameter == null) {
            return;
        }
        boolean filterCurrency = false;
        if (parameter.getDataManager().getDefCurrency() != null) {
            filterCurrency = true;
        }
        boolean filterElement = false;
        if (parameter.getDataManager().getDefElement() != null) {
            filterElement = true;
        }
        boolean filterVersion = false;
        if (parameter.getDataManager().getDefVersion() != null) {
            filterVersion = true;
        }
        String mbgDimNum = null;
        ICalcMember calcMember = null;
        BizCalcMember bizCalcMember = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo subCalc = null;
        BizScopeInfo scope = null;
        ArrayList<BizScopeInfo> removesScopes = new ArrayList<BizScopeInfo>();
        HashSet<String> removeFields = new HashSet<String>();
        int in = bizCalcMembers.size();
        for (int i = 0; i < in; ++i) {
            calcMember = bizCalcMembers.get(i);
            if (!(calcMember instanceof BizCalcMember)) continue;
            bizCalcMember = (BizCalcMember)calcMember;
            bizCalc = bizCalcMember.getCalc();
            int jn = bizCalc.getBizCalcSubset().size();
            for (int j = 0; j < jn; ++j) {
                subCalc = bizCalc.getBizCalcSubset().get(j);
                removesScopes.clear();
                removeFields.clear();
                int xn = subCalc.getScope().size();
                for (int x = 0; x < xn; ++x) {
                    scope = subCalc.getScope().get(x);
                    if (scope.getRefField().equals(DimensionConstants.DEF_PROCESS_FIELD)) continue;
                    if (filterCurrency && DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(scope.getRefField())) {
                        removesScopes.add(scope);
                        removeFields.add(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                    }
                    if (filterElement && DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(scope.getRefField())) {
                        removesScopes.add(scope);
                        removeFields.add(DimensionBaseConstants.DEF_ELEMENT_FIELD);
                    }
                    if (filterVersion && DimensionBaseConstants.DEF_VERSION_FIELD.equals(scope.getRefField())) {
                        removesScopes.add(scope);
                        removeFields.add(DimensionBaseConstants.DEF_VERSION_FIELD);
                    }
                    mbgDimNum = parameter.getDataManager().getMbgDims().get(scope.getRefField()).getNumber();
                    if (standbyDim == null || !standbyDim.contains(mbgDimNum)) continue;
                    removesScopes.add(scope);
                    removeFields.add(scope.getRefField());
                }
                if (!removesScopes.isEmpty()) {
                    int yn = removesScopes.size();
                    for (int y = 0; y < yn; ++y) {
                        subCalc.getScope().removeObject((IObjectValue)removesScopes.get(y));
                    }
                }
                if (removeFields.isEmpty()) continue;
                for (String field : removeFields) {
                    subCalc.getScopeMap().remove(field);
                }
            }
        }
    }

    private static boolean checkExprProcessType(IDimensionParameter parameter, IExpress expr) throws ParseException {
        boolean match = true;
        if (parameter.getDataManager().getDimDataQuery() != null && parameter.getDataManager().getDimDataQuery().getProcessType() != null && expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            String process = parameter.getDataManager().getDimDataQuery().getProcessType().getName();
            HashMap<String, Set<String>> refMemberMap = new HashMap<String, Set<String>>();
            OptimizeUtils.filterByExpress(((BinaryExpr)expr).left, refMemberMap, parameter.getOrgBooleanMember(), null);
            if (refMemberMap.containsKey(DimensionConstants.DEF_PROCESS_SRCNUMBER) && !((Set)refMemberMap.get(DimensionConstants.DEF_PROCESS_SRCNUMBER)).contains(process)) {
                match = false;
                binaryExpr.hasCalc = false;
            }
        }
        return match;
    }

    public static void filterExpress(Connection conn, List<ICalcMember> members, Map<String, Set<String>> mbgMemberMap, Map<String, String> srcFieldMap, IDimensionParameter parameter, Map<String, String> params) throws ParseException, BOSException {
        if (members == null || members.isEmpty() || srcFieldMap == null || parameter == null) {
            return;
        }
        HashMap<String, String> fieldSrcMap = new HashMap<String, String>();
        for (String srcNumber : srcFieldMap.keySet()) {
            fieldSrcMap.put(srcFieldMap.get(srcNumber), srcNumber);
        }
        ICalcMember calcMember = null;
        BizCalcMember bizCalcMember = null;
        Object baseMember = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo subset = null;
        List express = null;
        IExpress expr = null;
        boolean check = false;
        Object srcNumber = null;
        Object field = null;
        Object number = null;
        Object pNumber = null;
        Set memberSet = null;
        Set<String> tmpSet = null;
        Set tmpRefSet = null;
        ArrayList removes = new ArrayList();
        int formProcessType = DimUtils.getProcessType(conn, parameter);
        HashMap<String, Set<String>> refMemberMap = new HashMap<String, Set<String>>();
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            calcMember = members.get(i);
            if (!(calcMember instanceof BizCalcMember)) continue;
            bizCalcMember = (BizCalcMember)calcMember;
            bizCalc = bizCalcMember.getCalc();
            int jn = bizCalc.getBizCalcSubset().size();
            for (int j = 0; j < jn; ++j) {
                subset = bizCalc.getBizCalcSubset().get(j);
                express = subset.getExpres();
                int xn = express.size();
                for (int x = 0; x < xn; ++x) {
                    expr = (IExpress)express.get(x);
                    if (!OptimizeUtils.checkExprProcessType(parameter, expr)) continue;
                    OptimizeUtils.filterByExpress(((BinaryExpr)expr).right, refMemberMap, parameter.getOrgBooleanMember(), null);
                }
            }
        }
        HashSet processTypes = new HashSet();
        if (refMemberMap.containsKey(DimensionConstants.DEF_PROCESS_SRCNUMBER)) {
            processTypes.addAll((Collection)refMemberMap.get(DimensionConstants.DEF_PROCESS_SRCNUMBER));
        }
        Map scopeMap = null;
        Map.Entry entry2 = null;
        if (mbgMemberMap != null) {
            int in2 = members.size();
            for (int i = 0; i < in2; ++i) {
                calcMember = members.get(i);
                if (!(calcMember instanceof BizCalcMember)) continue;
                bizCalcMember = (BizCalcMember)calcMember;
                bizCalc = bizCalcMember.getCalc();
                int jn = bizCalc.getBizCalcSubset().size();
                block5: for (int j = 0; j < jn; ++j) {
                    subset = bizCalc.getBizCalcSubset().get(j);
                    scopeMap = subset.getScopeMap();
                    if (scopeMap == null || scopeMap.isEmpty()) continue;
                    for (Map.Entry entry2 : scopeMap.entrySet()) {
                        if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_VERSION_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_CSL_FIELD.equals(entry2.getKey()) || DimensionBaseConstants.DEF_PERIOD_FIELD.equals(entry2.getKey())) {
                            memberSet = (Set)entry2.getValue();
                            tmpSet = mbgMemberMap.get(entry2.getKey());
                            tmpRefSet = (Set)refMemberMap.get(fieldSrcMap.get(entry2.getKey()));
                            if (tmpSet != null && !tmpSet.isEmpty()) {
                                check = false;
                                for (String tmpStr : tmpSet) {
                                    if (memberSet.contains(tmpStr)) {
                                        check = true;
                                        continue;
                                    }
                                    if (!memberSet.contains((String)fieldSrcMap.get(entry2.getKey()) + ":" + tmpStr)) continue;
                                    check = true;
                                }
                                if (tmpRefSet != null) {
                                    for (String tmpStr : tmpRefSet) {
                                        if (memberSet.contains(tmpStr)) {
                                            check = true;
                                            continue;
                                        }
                                        if (!memberSet.contains((String)fieldSrcMap.get(entry2.getKey()) + ":" + tmpStr)) continue;
                                        check = true;
                                    }
                                }
                                if (!check) {
                                    subset.hasCalc = false;
                                    continue block5;
                                }
                                if (DimensionBaseConstants.DEF_CSL_FIELD.equals(entry2.getKey())) {
                                    memberSet.retainAll(tmpSet);
                                }
                            } else if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(entry2.getKey())) {
                                if (parameter.getDataManager().getDefCurrency() != null) {
                                    if (!memberSet.contains(parameter.getDataManager().getDefCurrency()[0])) {
                                        subset.hasCalc = false;
                                        continue block5;
                                    }
                                    memberSet.clear();
                                    memberSet.add(parameter.getDataManager().getDefCurrency()[0]);
                                }
                            } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(entry2.getKey())) {
                                if (parameter.getDataManager().getDefElement() != null) {
                                    if (!memberSet.contains(parameter.getDataManager().getDefElement()[0])) {
                                        subset.hasCalc = false;
                                        continue block5;
                                    }
                                    memberSet.clear();
                                    memberSet.add(parameter.getDataManager().getDefElement()[0]);
                                }
                            } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(entry2.getKey())) {
                                if (parameter.getDataManager().getDefVersion() != null) {
                                    if (!memberSet.contains(parameter.getDataManager().getDefVersion()[0])) {
                                        subset.hasCalc = false;
                                        continue block5;
                                    }
                                    memberSet.clear();
                                    memberSet.add(parameter.getDataManager().getDefVersion()[0]);
                                }
                            } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(entry2.getKey()) && parameter.getDataManager().getDefScenario() != null) {
                                if (!memberSet.contains(parameter.getDataManager().getDefScenario()[0])) {
                                    subset.hasCalc = false;
                                    continue block5;
                                }
                                memberSet.clear();
                                memberSet.add(parameter.getDataManager().getDefScenario()[0]);
                            }
                        }
                        if (!DimensionBaseConstants.DEF_PROCESS_FIELD.equals(entry2.getKey())) continue;
                        if (((Set)entry2.getValue()).contains(BgProcessEnum.getEnum(formProcessType).getName())) {
                            subset.hasCalc = true;
                            continue;
                        }
                        subset.hasCalc = false;
                        continue block5;
                    }
                }
            }
        }
        if (!processTypes.isEmpty()) {
            StringBuffer processType = new StringBuffer();
            for (String num : processTypes) {
                processType.append(num).append(";");
            }
            if (processType.length() > 0 && params != null) {
                params.put(DimensionConstants.BIZCALC_PROCESS_TYPE, processType.substring(0, processType.length() - 1));
            }
        }
        if (!removes.isEmpty()) {
            members.removeAll(removes);
        }
    }

    public static void filterBizMember(Context ctx, IDimensionParameter parameter, List<ICalcMember> members) throws BOSException {
        if (ctx == null || parameter == null || members == null || members.isEmpty()) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = parameter.getDimensionMap().get(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
        if (dimension != null && dimension.getDimensionMember().size() > 1) {
            return;
        }
        String orgUnitNum = null;
        if (parameter.getDataManager().getBgOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getBgOrgUnit().getNumber();
        } else if (parameter.getDataManager().getOrgUnit() != null) {
            orgUnitNum = parameter.getDataManager().getOrgUnit().getNumber();
        }
        ICalcMember member = null;
        BizCalcMember calcMember = null;
        BizCalcSubsetInfo subCalc = null;
        String orgViewID = parameter.getBgOrgViewId().toString();
        String bgSchemeID = parameter.getBgSchemeId().toString();
        Set<String> bgPeriodNums = DimUtils.getPeriodStandardNumber(parameter);
        int formProcessType = DimUtils.getProcessType(ctx, parameter);
        Map scopeMap = null;
        Map.Entry entry2 = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (!(member instanceof BizCalcMember)) continue;
            calcMember = (BizCalcMember)member;
            int jn = calcMember.getCalc().getBizCalcSubset().size();
            block3: for (int j = 0; j < jn; ++j) {
                subCalc = calcMember.getCalc().getBizCalcSubset().get(j);
                if (!subCalc.hasCalc || subCalc == null) continue;
                try {
                    subCalc.getScopeData(parameter.getDataManager().getVariate(), bgPeriodNums, parameter.getPeriodCheckScope(), true, true, ctx, parameter.getDataManager().getBgScheme(), parameter.getDataManager().getDimensions());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (!subCalc.checkHasOrgScope(ctx, orgUnitNum, orgViewID, bgSchemeID, parameter.getUnionId()) && parameter.getBillId() != null) {
                    subCalc.hasCalc = false;
                }
                if ((scopeMap = subCalc.getScopeMap()) == null || scopeMap.isEmpty()) continue;
                for (Map.Entry entry2 : scopeMap.entrySet()) {
                    if (!DimensionBaseConstants.DEF_PROCESS_FIELD.equals(entry2.getKey()) || ((Set)entry2.getValue()).isEmpty() || ((Set)entry2.getValue()).contains(BgProcessEnum.getEnum(formProcessType).getName())) continue;
                    subCalc.hasCalc = false;
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void filterExpressFormulaCalc(Context ctx, List<ICalcMember> members, IDimensionParameter parameter, Map<String, Set<String>> refDimMap, Map<String, String> srcFieldMap, Map<String, Set<BizCalcInfo>> relyObjMap) throws ParseException, EASBizException, BOSException {
        void var22_26;
        if (members == null || members.isEmpty() || parameter == null) {
            return;
        }
        if (!parameter.getControlManager().isExpressionCalc() || parameter.getExpressionParams() == null || parameter.getExpressionParams().isEmpty()) {
            return;
        }
        Map<String, Map<String, Set<String>>> bizCalcRelation = DimUtils.bizCalcRelation(ctx, members, srcFieldMap);
        Map<String, Map<String, Set<String>>> bizParentMap = DimUtils.queryParent(ctx, parameter, null, bizCalcRelation);
        Set<String> bgPeriodNums = DimUtils.getPeriodStandardNumber(parameter);
        ICalcMember calcMember = null;
        BizCalcMember bizCalcMember = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo subset = null;
        List express = null;
        BinaryExpr expr = null;
        Set memberSet = null;
        Map scopeMap = null;
        HashSet<String> allMemberNumbers = new HashSet<String>();
        HashSet<String> elementNumbers = new HashSet<String>();
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : parameter.getRowDims()) {
            if (!dimension.getNumber().equals(DimensionConstants.DEF_ACCOUNT_NUMBER)) continue;
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember iMember : dimension.getDimensionMember()) {
                if (StringUtils.isEmpty((String)iMember.getDimNumber())) continue;
                allMemberNumbers.add(iMember.getDimNumber());
            }
        }
        if (parameter.getDimension(DimensionConstants.DEF_ELEMENT_FIELD) != null && parameter.getDimension(DimensionConstants.DEF_ELEMENT_FIELD).getDimensionMember() != null && !parameter.getDimension(DimensionConstants.DEF_ELEMENT_FIELD).getDimensionMember().isEmpty()) {
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : parameter.getDimension(DimensionConstants.DEF_ELEMENT_FIELD).getDimensionMember()) {
                if (StringUtils.isEmpty((String)member.getDimNumber())) continue;
                elementNumbers.add(member.getDimNumber());
            }
        }
        String DIMFIELD = "DIMF2";
        boolean allHasAcc = true;
        List<String[]> expressionParams = parameter.getExpressionParams();
        for (String[] expressionParam : expressionParams) {
            boolean hasAcc = false;
            for (String ep : expressionParam) {
                if (ep.indexOf(DIMFIELD) <= 0) continue;
                hasAcc = true;
                break;
            }
            if (hasAcc) continue;
            allHasAcc = false;
            break;
        }
        if (!allHasAcc) {
            return;
        }
        boolean bl = false;
        int in = members.size();
        while (var22_26 < in) {
            calcMember = members.get((int)var22_26);
            if (calcMember instanceof BizCalcMember) {
                bizCalcMember = (BizCalcMember)calcMember;
                bizCalc = bizCalcMember.getCalc();
                int jn = bizCalc.getBizCalcSubset().size();
                for (int j = 0; j < jn; ++j) {
                    subset = bizCalc.getBizCalcSubset().get(j);
                    scopeMap = subset.getScopeMap();
                    if (scopeMap == null) {
                        try {
                            scopeMap = subset.getScopeData(parameter.getDataManager().getVariate(), bgPeriodNums, parameter.getPeriodCheckScope(), true, true, ctx, parameter.getDataManager().getBgScheme(), parameter.getDataManager().getDimensions());
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                    if (scopeMap != null && !scopeMap.isEmpty() && !allMemberNumbers.isEmpty() && subset.hasCalc) {
                        boolean checkInScope = false;
                        if (scopeMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                            memberSet = (Set)scopeMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                            block9: for (String accNum : allMemberNumbers) {
                                if (memberSet.contains(accNum)) {
                                    checkInScope = true;
                                    break;
                                }
                                if (!bizParentMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) continue;
                                for (String scopeAcc : memberSet) {
                                    if (scopeAcc.indexOf(":") <= 0) continue;
                                    Iterator scopeAccNum = scopeAcc.split(":")[1];
                                    if (!bizParentMap.get(DimensionConstants.DEF_BGINDEX_FIELD).containsKey(scopeAccNum) || !bizParentMap.get(DimensionConstants.DEF_BGINDEX_FIELD).get(scopeAccNum).contains(accNum.split(":")[1])) continue;
                                    checkInScope = true;
                                    continue block9;
                                }
                            }
                        } else {
                            checkInScope = true;
                        }
                        if (!checkInScope) {
                            subset.hasCalc = false;
                        }
                    }
                    if (!subset.hasCalc) continue;
                    HashMap refNumLeftMap = new HashMap();
                    HashMap refNumRightMap = new HashMap();
                    express = subset.getExpres();
                    int xn = express.size();
                    for (int x = 0; x < xn; ++x) {
                        if (!(express.get(x) instanceof BinaryExpr)) continue;
                        expr = (BinaryExpr)express.get(x);
                        refNumLeftMap.clear();
                        refNumRightMap.clear();
                        BizExprUtils.putMbgMember((IExpress)expr.left, refNumLeftMap, srcFieldMap, null);
                        BizExprUtils.putMbgMember((IExpress)expr.right, refNumRightMap, srcFieldMap, null);
                        boolean checkInExpr = false;
                        for (String accNum : allMemberNumbers) {
                            if (refNumLeftMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
                                if (((Set)refNumLeftMap.get(DimensionConstants.DEF_BGINDEX_FIELD)).contains(accNum)) {
                                    checkInExpr = true;
                                    break;
                                }
                            } else {
                                checkInExpr = true;
                                break;
                            }
                            if (refNumRightMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
                                if (!((Set)refNumRightMap.get(DimensionConstants.DEF_BGINDEX_FIELD)).contains(accNum)) continue;
                                checkInExpr = true;
                                break;
                            }
                            checkInExpr = true;
                            break;
                        }
                        if (checkInExpr && !elementNumbers.isEmpty()) {
                            checkInExpr = false;
                            for (String elementNum : elementNumbers) {
                                if (refNumLeftMap.containsKey(DimensionConstants.DEF_ELEMENT_FIELD)) {
                                    if (((Set)refNumLeftMap.get(DimensionConstants.DEF_ELEMENT_FIELD)).contains(elementNum)) {
                                        checkInExpr = true;
                                        break;
                                    }
                                } else {
                                    checkInExpr = true;
                                    break;
                                }
                                if (refNumRightMap.containsKey(DimensionConstants.DEF_ELEMENT_FIELD)) {
                                    if (!((Set)refNumRightMap.get(DimensionConstants.DEF_ELEMENT_FIELD)).contains(elementNum)) continue;
                                    checkInExpr = true;
                                    break;
                                }
                                checkInExpr = true;
                                break;
                            }
                        }
                        if (!checkInExpr) {
                            expr.hasCalc = false;
                        }
                        if (!refNumRightMap.containsKey(DimensionConstants.DEF_PROCESS_FIELD) || !refNumLeftMap.containsKey(DimensionConstants.DEF_PROCESS_FIELD)) continue;
                        HashSet left = new HashSet((Collection)refNumRightMap.get(DimensionConstants.DEF_PROCESS_FIELD));
                        left.retainAll((Collection)refNumLeftMap.get(DimensionConstants.DEF_PROCESS_FIELD));
                        if (!left.isEmpty()) continue;
                        expr.hasCalc = false;
                    }
                }
            }
            ++var22_26;
        }
    }

    public static Map<String, Set<String>> getRefMemberByExpress(BizCalcStrategy strategy, IDimensionParameter parameter) throws ParseException {
        int i;
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        HashMap<BizCalcOrgObject, Set<BizCalcOrgObject>> orgCalcMap = new HashMap<BizCalcOrgObject, Set<BizCalcOrgObject>>();
        HashSet<BizCalcOrgObject> orgNumbers = new HashSet<BizCalcOrgObject>();
        if (strategy == null || strategy.getMembers().isEmpty() || parameter == null) {
            return filterMap;
        }
        parameter.setOrgCalcMap(orgCalcMap);
        ICalcMember calcMember = null;
        BaseCalcMember baseMember = null;
        BizCalcMember bizCalcMember = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo subset = null;
        MbgDimInfo mbgDim2 = null;
        List express = null;
        IExpress expr = null;
        HashMap<String, Set<String>> srcNumbers = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> _srcNumbers = new HashMap<String, Set<String>>();
        Map scopeMap = null;
        Set<String> numberSet = null;
        Set tmpSet = null;
        String field = null;
        String srcNumber = null;
        String[] tmpStrs = null;
        HashMap<String, String> srcDimMap = new HashMap<String, String>();
        HashMap<String, String> fieldSrcMap = new HashMap<String, String>();
        Set<BizCalcOrgObject> leftOrg = null;
        HashSet<BizCalcOrgObject> rightOrg = null;
        Set<String> scopeOrg = null;
        Set<String> scopeProcessType = null;
        for (MbgDimInfo mbgDim2 : parameter.getDataManager().getMbgDims().values()) {
            srcDimMap.put(mbgDim2.getSrcNumber(), mbgDim2.getNumber());
            fieldSrcMap.put(mbgDim2.getRefField(), mbgDim2.getSrcNumber());
        }
        int in = strategy.getMembers().size();
        for (i = 0; i < in; ++i) {
            calcMember = (ICalcMember)strategy.getMembers().get(i);
            if (calcMember instanceof BaseCalcMember) {
                int x;
                int xn;
                int j;
                int jn;
                baseMember = (BaseCalcMember)calcMember;
                if (filterMap.containsKey(baseMember.getField())) {
                    numberSet = (Set)filterMap.get(baseMember.getField());
                } else {
                    numberSet = new HashSet();
                    filterMap.put(baseMember.getField(), numberSet);
                }
                if (!baseMember.getIgnNumber().isEmpty()) {
                    jn = baseMember.getIgnNumber().size();
                    for (j = 0; j < jn; ++j) {
                        tmpStrs = ((String)baseMember.getIgnNumber().get(j)).split("!");
                        xn = tmpStrs.length;
                        for (x = 0; x < xn; ++x) {
                            numberSet.add(tmpStrs[x]);
                        }
                    }
                }
                if (baseMember.getSubNumber().isEmpty()) continue;
                jn = baseMember.getSubNumber().size();
                for (j = 0; j < jn; ++j) {
                    tmpStrs = ((String)baseMember.getSubNumber().get(j)).split("!");
                    xn = tmpStrs.length;
                    for (x = 0; x < xn; ++x) {
                        numberSet.add(tmpStrs[x]);
                    }
                }
                continue;
            }
            if (calcMember instanceof BizCalcMember) {
                bizCalcMember = (BizCalcMember)calcMember;
                bizCalc = bizCalcMember.getCalc();
                Set<String> bgPeirodNums = DimUtils.getPeriodStandardNumber(parameter);
                int jn = bizCalc.getBizCalcSubset().size();
                for (int j = 0; j < jn; ++j) {
                    subset = bizCalc.getBizCalcSubset().get(j);
                    scopeOrg = null;
                    scopeMap = subset.getScopeData(parameter.getDataManager().getVariate(), bgPeirodNums);
                    if (scopeMap != null && !scopeMap.isEmpty()) {
                        scopeOrg = OptimizeUtils.fillNull((Set)scopeMap.get(DimensionConstants.DEF_ORGUNIT_FIELD));
                        scopeProcessType = OptimizeUtils.fillNull((Set)scopeMap.get(DimensionConstants.DEF_PROCESS_FIELD));
                        Map.Entry entry2 = null;
                        for (Map.Entry entry2 : scopeMap.entrySet()) {
                            field = (String)entry2.getKey();
                            srcNumber = (String)fieldSrcMap.get(field);
                            tmpSet = (Set)entry2.getValue();
                            if (tmpSet == null || tmpSet.isEmpty()) continue;
                            if (srcNumbers.containsKey(srcNumber)) {
                                numberSet = (Set)srcNumbers.get(srcNumber);
                            } else {
                                numberSet = new HashSet();
                                srcNumbers.put(srcNumber, numberSet);
                            }
                            numberSet.addAll(tmpSet);
                        }
                    }
                    express = subset.getExpres();
                    int xn = express.size();
                    for (int x = 0; x < xn; ++x) {
                        expr = (IExpress)express.get(x);
                        OptimizeUtils.filterByExpress(expr, srcNumbers, parameter.getOrgBooleanMember(), null);
                        if (!(expr instanceof BinaryExpr)) continue;
                        BinaryExpr _expr = (BinaryExpr)expr;
                        orgNumbers.clear();
                        OptimizeUtils.filterByExpress(_expr.left, _srcNumbers, parameter.getOrgBooleanMember(), orgNumbers);
                        leftOrg = new HashSet<BizCalcOrgObject>(orgNumbers);
                        orgNumbers.clear();
                        OptimizeUtils.filterByExpress(_expr.right, _srcNumbers, parameter.getOrgBooleanMember(), orgNumbers);
                        rightOrg = new HashSet<BizCalcOrgObject>(orgNumbers);
                        if ((rightOrg == null || rightOrg.isEmpty()) && (leftOrg == null || leftOrg.isEmpty())) continue;
                        if (leftOrg == null || leftOrg.isEmpty()) {
                            leftOrg = OptimizeUtils.mergeScopeOrg(leftOrg, scopeProcessType, scopeOrg);
                        }
                        if (leftOrg == null || leftOrg.isEmpty()) {
                            if (!orgCalcMap.containsKey(new BizCalcOrgObject(null, null))) {
                                orgCalcMap.put(new BizCalcOrgObject(null, null), new HashSet());
                            }
                            ((Set)orgCalcMap.get(new BizCalcOrgObject(null, null))).addAll(rightOrg);
                            continue;
                        }
                        for (BizCalcOrgObject left : leftOrg) {
                            if (!orgCalcMap.containsKey(left)) {
                                orgCalcMap.put(left, new HashSet());
                            }
                            if (rightOrg == null) continue;
                            ((Set)orgCalcMap.get(left)).addAll(rightOrg);
                        }
                    }
                }
                continue;
            }
            if (!(calcMember instanceof CslCalcMember)) continue;
            if (srcNumbers.containsKey(DimensionBaseConstants.DEF_CSL_SRCNUMBER)) {
                numberSet = (Set)srcNumbers.get(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
            } else {
                numberSet = new HashSet();
                srcNumbers.put(DimensionBaseConstants.DEF_CSL_SRCNUMBER, numberSet);
            }
            numberSet.add(BgCslDimConstants.csl05);
            numberSet.add(BgCslDimConstants.csl06);
        }
        in = strategy.getMembers().size();
        for (i = 0; i < in; ++i) {
            calcMember = (ICalcMember)strategy.getMembers().get(i);
            if (!(calcMember instanceof BaseCalcMember)) continue;
            baseMember = (BaseCalcMember)calcMember;
            baseMember.getSubNumber();
        }
        if (!srcNumbers.isEmpty()) {
            Map.Entry entry3 = null;
            for (Map.Entry entry3 : srcNumbers.entrySet()) {
                if (!srcDimMap.containsKey(entry3.getKey())) continue;
                filterMap.put((String)srcDimMap.get(entry3.getKey()), (Set<String>)entry3.getValue());
            }
        }
        return filterMap;
    }

    private static Set<String> fillNull(Set<String> source) {
        if (source == null) {
            source = new HashSet<String>();
        }
        if (source.isEmpty()) {
            source.add(null);
        }
        return source;
    }

    private static Set<BizCalcOrgObject> mergeScopeOrg(Set<BizCalcOrgObject> leftOrg, Set<String> scopeProcessType, Set<String> scopeOrg) {
        HashSet<BizCalcOrgObject> result = new HashSet<BizCalcOrgObject>();
        if (leftOrg == null) {
            for (String processType : scopeProcessType) {
                for (String orgNumber : scopeOrg) {
                    result.add(new BizCalcOrgObject(processType, orgNumber));
                }
            }
        } else {
            for (BizCalcOrgObject obj : leftOrg) {
                if (!scopeProcessType.contains(null)) {
                    if (obj.processType != null) {
                        if (!scopeProcessType.contains(obj.processType)) continue;
                        result.add(new BizCalcOrgObject(obj.processType, obj.orgNumber));
                        continue;
                    }
                    for (String processType : scopeProcessType) {
                        result.add(new BizCalcOrgObject(processType, obj.orgNumber));
                    }
                    continue;
                }
                result.add(new BizCalcOrgObject(obj.processType, obj.orgNumber));
            }
            leftOrg = result;
            result = new HashSet();
            for (BizCalcOrgObject obj : leftOrg) {
                if (!scopeOrg.contains(null)) {
                    if (obj.orgNumber != null) {
                        if (!scopeOrg.contains(obj.orgNumber)) continue;
                        result.add(new BizCalcOrgObject(obj.processType, obj.orgNumber));
                        continue;
                    }
                    for (String orgNumber : scopeOrg) {
                        result.add(new BizCalcOrgObject(obj.processType, orgNumber));
                    }
                    continue;
                }
                result.add(new BizCalcOrgObject(obj.processType, obj.orgNumber));
            }
        }
        return result;
    }

    private static void filterByExpress(IExpress expr, Map<String, Set<String>> srcNumbers, Set<String> orgBooleanMembers, Set<BizCalcOrgObject> orgNumbers) throws ParseException {
        if (expr == null || srcNumbers == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            OptimizeUtils.filterByExpress((BinaryExpr)expr, srcNumbers, orgBooleanMembers, orgNumbers);
        } else if (expr instanceof MdxMemberExpr) {
            OptimizeUtils.filterByExpress((MdxMemberExpr)expr, srcNumbers, orgBooleanMembers, false, orgNumbers);
        } else if (expr instanceof FunctionExpr) {
            OptimizeUtils.filterByExpress((FunctionExpr)expr, srcNumbers, orgBooleanMembers, orgNumbers);
        } else if (expr instanceof ConditionExpr) {
            OptimizeUtils.filterByExpress((ConditionExpr)expr, srcNumbers, orgBooleanMembers, orgNumbers);
        }
    }

    private static void filterByExpress(ConditionExpr expr, Map<String, Set<String>> srcNumbers, Set<String> orgBooleanMembers, Set<BizCalcOrgObject> orgNumbers) throws ParseException {
        if (expr == null || srcNumbers == null) {
            return;
        }
        for (IExpress e : expr.getAllExpresss()) {
            OptimizeUtils.filterByExpress(e, srcNumbers, orgBooleanMembers, orgNumbers);
        }
    }

    private static void filterByExpress(BinaryExpr expr, Map<String, Set<String>> srcNumbers, Set<String> orgBooleanMembers, Set<BizCalcOrgObject> orgNumbers) throws ParseException {
        if (expr == null || srcNumbers == null) {
            return;
        }
        OptimizeUtils.filterByExpress(expr.left, srcNumbers, orgBooleanMembers, orgNumbers);
        OptimizeUtils.filterByExpress(expr.right, srcNumbers, orgBooleanMembers, orgNumbers);
    }

    private static void filterByExpress(FunctionExpr expr, Map<String, Set<String>> srcNumbers, Set<String> orgBooleanMembers, Set<BizCalcOrgObject> orgNumbers) throws ParseException {
        if (expr == null || srcNumbers == null) {
            return;
        }
        boolean isBoolean = expr.functionName.startsWith("Is");
        if (expr.functionName.equalsIgnoreCase("Abs") || expr.functionName.equalsIgnoreCase("Max") || expr.functionName.equalsIgnoreCase("Min") || expr.functionName.equalsIgnoreCase("Avg") || isBoolean) {
            List params = expr.params;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof BinaryExpr) {
                    OptimizeUtils.filterByExpress((BinaryExpr)params.get(i), srcNumbers, orgBooleanMembers, orgNumbers);
                    continue;
                }
                if (params.get(i) instanceof MdxMemberExpr) {
                    OptimizeUtils.filterByExpress((MdxMemberExpr)params.get(i), srcNumbers, orgBooleanMembers, isBoolean, orgNumbers);
                    continue;
                }
                if (params.get(i) instanceof String) {
                    String[] strs = ((String)params.get(i)).split(":");
                    if (strs.length != 2) continue;
                    if (!srcNumbers.containsKey(strs[0])) {
                        srcNumbers.put(strs[0], new HashSet());
                    }
                    srcNumbers.get(strs[0]).add(strs[1]);
                    continue;
                }
                if (!(params.get(i) instanceof FunctionExpr)) continue;
                OptimizeUtils.filterByExpress((FunctionExpr)params.get(i), srcNumbers, orgBooleanMembers, orgNumbers);
            }
        } else if (MbgFunctionHelper.IsNativeFunction(expr.functionName) && expr.getOriginalExpr() != null && expr.getOriginalExpr().indexOf(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, "")) > 0 && orgNumbers != null) {
            orgNumbers.add(new BizCalcOrgObject(null, expr.getOriginalExpr(), true));
        }
    }

    private static void filterByExpress(MdxMemberExpr expr, Map<String, Set<String>> srcNumbers, Set<String> orgBooleanMembers, boolean isBoolean, Set<BizCalcOrgObject> orgUnitNumbers) throws ParseException {
        int i;
        if (expr == null || srcNumbers == null) {
            return;
        }
        IExpress _expr = null;
        MemberExpr memberExpr = null;
        Set<Object> numberSet = null;
        String decomposeNumber = null;
        int in = expr.params.size();
        for (i = 0; i < in; ++i) {
            _expr = (IExpress)expr.params.get(i);
            if (!(_expr instanceof MemberExpr)) continue;
            memberExpr = (MemberExpr)_expr;
            if (!DimensionConstants.DEF_PROCESS_SRCNUMBER.equals(memberExpr.srcNumber)) continue;
            decomposeNumber = memberExpr.number;
        }
        in = expr.params.size();
        for (i = 0; i < in; ++i) {
            _expr = (IExpress)expr.params.get(i);
            if (_expr instanceof MemberExpr) {
                memberExpr = (MemberExpr)_expr;
                if (srcNumbers.containsKey(memberExpr.srcNumber)) {
                    numberSet = srcNumbers.get(memberExpr.srcNumber);
                } else {
                    numberSet = new HashSet();
                    srcNumbers.put(memberExpr.srcNumber, numberSet);
                }
                if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(memberExpr.srcNumber) && orgUnitNumbers != null) {
                    orgUnitNumbers.add(new BizCalcOrgObject(decomposeNumber, memberExpr.number));
                }
                if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(memberExpr.srcNumber) && isBoolean) {
                    orgBooleanMembers.add(memberExpr.number);
                }
                numberSet.add(memberExpr.number);
                continue;
            }
            OptimizeUtils.filterByExpress(_expr, srcNumbers, orgBooleanMembers, orgUnitNumbers);
        }
    }

    public static void filterBySumDim(Set<String> sumDimSet, IDimensionParameter parameter) {
        if (sumDimSet == null || sumDimSet.isEmpty() || parameter == null) {
            return;
        }
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = parameter.getDims();
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : dims) {
            if (!sumDimSet.contains(dimension.getNumber())) continue;
            dimension.getDimensionMember().clear();
            MemberObject member = new MemberObject();
            member.setNumber(dimension.getNumber());
            member.setSrcNumber(dimension.getSrcNumber());
            dimension.getDimensionMember().add(member);
        }
        if (!parameter.getQuerys().isEmpty()) {
            if (dims == null || dims.isEmpty()) {
                sumDimSet.clear();
            }
            for (IQueryData queryData : parameter.getQuerys()) {
                for (IDimension dim : queryData.getMbgDimMap().values()) {
                    if (!sumDimSet.contains(dim.getNumber())) continue;
                    dim.getMembers().clear();
                    Member member = new Member();
                    member.setNumber(dim.getNumber());
                    member.setLongNumber(dim.getNumber());
                    member.setSrcNumber(dim.getSrcNumber());
                    dim.getMembers().add(member);
                }
            }
        }
    }
}

