/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.dimension.utils;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.utils.BizCalcRunUtils;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.utils.Arrays;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RelationUtils {
    private static Logger logger = Logger.getLogger(RelationUtils.class);
    private boolean isShowDefaultMember = false;
    private Map<String, String> refFieldMap = null;
    private Map<String, String> srcNumberMap = null;
    private Map<String, String> srcDimMap = new HashMap<String, String>();
    private String data;

    public void setShowDefaultMember(boolean isShowDefaultMember) {
        this.isShowDefaultMember = isShowDefaultMember;
    }

    public static RelationUtils getInstance(BgSchemeDimensionHelper schemeHelper) {
        return new RelationUtils(schemeHelper.getRefFieldMap(), schemeHelper.getSrcNumberMap());
    }

    public static RelationUtils getInstance(MbgDimCollection colls) {
        HashMap<String, String> numFieldMap = new HashMap<String, String>();
        HashMap<String, String> srcNumberMap = new HashMap<String, String>();
        MbgDimInfo mbgDim = null;
        for (int i = 0; i < colls.size(); ++i) {
            mbgDim = colls.get(i);
            numFieldMap.put(mbgDim.getNumber(), mbgDim.getRefField());
            srcNumberMap.put(mbgDim.getNumber(), mbgDim.getSrcNumber());
        }
        return new RelationUtils(numFieldMap, srcNumberMap);
    }

    public static RelationUtils getInstance(Map<String, MbgDimInfo> mbgDimMap) {
        HashMap<String, String> numFieldMap = new HashMap<String, String>();
        HashMap<String, String> srcNumberMap = new HashMap<String, String>();
        for (MbgDimInfo mbgDim : mbgDimMap.values()) {
            numFieldMap.put(mbgDim.getNumber(), mbgDim.getRefField());
            srcNumberMap.put(mbgDim.getNumber(), mbgDim.getSrcNumber());
        }
        return new RelationUtils(numFieldMap, srcNumberMap);
    }

    public RelationUtils(Map<String, String> refFieldMap, Map<String, String> srcNumberMap) {
        this.refFieldMap = refFieldMap;
        this.srcNumberMap = srcNumberMap;
        if (srcNumberMap != null) {
            for (String dimNumber : srcNumberMap.keySet()) {
                this.srcDimMap.put(srcNumberMap.get(dimNumber), dimNumber);
            }
        }
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo, IDimensionParameter parameter) {
        if (relationInfo == null || parameter == null) {
            return null;
        }
        List<IDimension> dims = DimUtils.getDimsClone(parameter);
        for (IDimension dimension : dims) {
            DimUtils.restoreScenarioNumber(dimension, parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_SCENARIO_FIELD));
            DimUtils.restoreVersionNumber(dimension, parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD));
        }
        return this.queryRelation(relationInfo, dims, false, "col");
    }

    public Map<Integer, List<String[]>> queryRelation(IMbgViewManager manager) {
        if (manager == null || manager.getRelationMaps() == null) {
            return null;
        }
        IMbgSheetManager sheetManager = null;
        IBgDimensionManager dimManager = null;
        List<String[]> relationData = null;
        HashMap<Integer, List<String[]>> relationDataMap = new HashMap<Integer, List<String[]>>();
        int in = manager.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            sheetManager = manager.getSheetManagers().get(i);
            dimManager = sheetManager.getDimensionManager();
            relationData = this.queryRelation(manager.getRelationMaps(), this.transDimension(dimManager));
            if (relationData == null) continue;
            relationDataMap.put(sheetManager.getSheetIndex(), relationData);
        }
        return relationDataMap;
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo, IBgDimensionManager dimManager) {
        return this.queryRelation(relationInfo, this.transDimension(dimManager));
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo, IMbgSheetManager manager) {
        if (relationInfo == null || relationInfo.isEmpty() || manager == null) {
            return null;
        }
        IBgDimensionManager dimManager = manager.getDimensionManager();
        List<String[]> relationData = this.queryRelation(relationInfo, this.transDimension(dimManager));
        return relationData;
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo, List<IDimension> dims) {
        return this.queryRelation(relationInfo, dims, false, "col");
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo, List<IDimension> dims, boolean hasMergeDimenson, String layout) {
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"begin queryRelation");
        if (relationInfo == null || dims == null) {
            return null;
        }
        List<RelationObj> relObjs = this.parseRelation(relationInfo);
        if (relObjs == null || relObjs.isEmpty()) {
            return null;
        }
        Map<String, Set<String>> refMemberMap = this.getRefDimMember(dims);
        relObjs = this.filterRelationData(relObjs, refMemberMap);
        List<String[]> relationData = null;
        relationData = this.checkGroupSingle(relObjs) ? this.mergeSingleObjs(relObjs) : this.parseRelationData(relObjs, dims);
        if (hasMergeDimenson) {
            relationData = this.mergeDimensionData(relationData, dims, layout);
        }
        logger.debug((Object)("invoke end queryRelation process use = " + (System.currentTimeMillis() - beginTime) + " ms;"));
        return relationData;
    }

    protected boolean checkGroupSingle(List<RelationObj> relObjs) {
        if (relObjs.size() <= 1) {
            return false;
        }
        String num = null;
        for (RelationObj obj : relObjs) {
            if (StringUtils.isEmpty(num)) {
                num = obj.getNumber();
                continue;
            }
            if (num == null || num.equals(obj.getNumber())) continue;
            return false;
        }
        return true;
    }

    protected List<String[]> mergeSingleObjs(List<RelationObj> relObjs) {
        ArrayList<String[]> tmpObjs = new ArrayList<String[]>();
        RelationObj relationObj = null;
        String[] relData = null;
        HashSet<String> repeats = new HashSet<String>();
        for (int i = 0; i < relObjs.size(); ++i) {
            relationObj = relObjs.get(i);
            if (i == 0) {
                String[] refDims = new String[relationObj.getRefDims().size()];
                for (int x = 0; x < relationObj.getRefDims().size(); ++x) {
                    refDims[x] = relationObj.getRefDims().get(x);
                }
                tmpObjs.add(refDims);
            }
            for (int j = 0; j < relationObj.getRelData().size(); ++j) {
                relData = relationObj.getRelData().get(j);
                StringBuffer numKey = new StringBuffer();
                for (String str : relData) {
                    numKey = numKey.append(str).append(";");
                }
                if (repeats.contains(numKey.toString())) continue;
                tmpObjs.add(relData);
                repeats.add(numKey.toString());
            }
        }
        return tmpObjs;
    }

    private List<IDimension> transDimension(IBgDimensionManager dimManager) {
        ArrayList<IDimension> dims = new ArrayList<IDimension>();
        if (dimManager == null) {
            return dims;
        }
        List hideList = dimManager.getHideDisplayDimension();
        HashSet<String> hideDimensions = new HashSet<String>();
        if (hideList != null) {
            for (int i = 0; i < hideList.size(); ++i) {
                hideDimensions.add(((BgDimensionInfo)hideList.get(i)).getNumber());
            }
        }
        ArrayList<BgDimensionBaseInfo> bgDims = new ArrayList<BgDimensionBaseInfo>();
        bgDims.addAll(dimManager.getRowDimension());
        bgDims.addAll(dimManager.getColDimension());
        bgDims.addAll(dimManager.getPageDimension());
        List<IDimension> tmpList = this.transDimension(bgDims, hideDimensions);
        if (tmpList != null) {
            dims.addAll(tmpList);
        }
        return dims;
    }

    public List<IDimension> transDimension(List<BgDimensionBaseInfo> bgDims, Set<String> hideDims) {
        if (bgDims == null || bgDims.isEmpty()) {
            return null;
        }
        IDimension dimension = null;
        BgDimensionBaseInfo bgDim = null;
        ArrayList<IDimension> dims = new ArrayList<IDimension>();
        int in = bgDims.size();
        for (int i = 0; i < in; ++i) {
            bgDim = bgDims.get(i);
            dimension = this.transDimension(bgDim, hideDims);
            if (dimension == null) continue;
            dims.add(dimension);
        }
        return dims;
    }

    private IDimension transDimension(BgDimensionBaseInfo dimensionInfo, Set<String> hideDims) {
        if (dimensionInfo == null) {
            return null;
        }
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setField(dimensionInfo.getRefField());
        List memList = dimensionInfo.getMember();
        if (memList != null && !memList.isEmpty()) {
            BgDimensionMember dimensionMember = null;
            IMember member = null;
            int jn = memList.size();
            for (int j = 0; j < jn; ++j) {
                dimensionMember = (BgDimensionMember)memList.get(j);
                member = DimUtils.transDimMember(dimensionMember);
                if (member == null) continue;
                dimension.getDimensionMember().add(member);
            }
        }
        return dimension;
    }

    private List<RelationObj> parseRelation(List<MbgRelationMap> relationInfo) {
        int x;
        int xn;
        ArrayList<RelationObj> rels = new ArrayList<RelationObj>();
        RelationObj relObj = null;
        RelationObj tmpObj = null;
        MbgRelationMap relInfo = null;
        DimensionRelationshipInfo relShip = null;
        String dimNumber = null;
        String srcNumber = null;
        String[] tmpStr = null;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        HashSet<String> baseSrcSet = new HashSet<String>();
        baseSrcSet.add(DimensionConstants.DEF_CURRENCY_SRCNUMBER);
        baseSrcSet.add(DimensionConstants.DEF_VERSION_SRCNUMBER);
        baseSrcSet.add(DimensionConstants.DEF_PERIOD_SRCNUMBER);
        baseSrcSet.add(DimensionConstants.DEF_ELEMENT_SRCNUMBER);
        baseSrcSet.add(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
        DimensionRelationshipCollection shipCols = null;
        int in = relationInfo.size();
        for (int i = 0; i < in; ++i) {
            int x2;
            int xn2;
            int j;
            relInfo = relationInfo.get(i);
            relObj = new RelationObj();
            relObj.setNumber(relInfo.getGroup().getNumber());
            fieldMap.clear();
            int jn = relInfo.getGroup().getEntries().size();
            for (j = 0; j < jn; ++j) {
                dimNumber = relInfo.getGroup().getEntries().get(j).getDimNumber();
                fieldMap.put(this.srcNumberMap.get(dimNumber), this.refFieldMap.get(dimNumber));
            }
            shipCols = relInfo.getRelationShips();
            if (this.isShowDefaultMember && shipCols.isEmpty()) {
                shipCols = new DimensionRelationshipCollection();
                DimensionRelationshipInfo defShip = new DimensionRelationshipInfo();
                defShip.setDimensionGroup(relInfo.getGroup());
                defShip.setId(BOSUuid.create((BOSObjectType)defShip.getBOSType()));
                StringBuffer dimNumbers = new StringBuffer();
                xn2 = relInfo.getGroup().getEntries().size();
                for (x2 = 0; x2 < xn2; ++x2) {
                    if (dimNumbers.length() > 0) {
                        dimNumbers.append(",");
                    }
                    dimNumbers.append(DimensionFormulaHelper.getCombination(this.srcNumberMap.get(relInfo.getGroup().getEntries().get(x2).getDimNumber()), " "));
                }
                defShip.setDimensionNumber(dimNumbers.toString());
                defShip.setDimensionName(dimNumbers.toString().replaceAll(",", DimensionConstants.TICK_SEPARATOR));
                shipCols.add(defShip);
            }
            jn = shipCols.size();
            for (j = 0; j < jn; ++j) {
                relShip = shipCols.get(j);
                tmpStr = relShip.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
                if (tmpStr == null || tmpStr.length != fieldMap.size()) continue;
                if (j == 0) {
                    String[] seg = null;
                    xn = tmpStr.length;
                    for (x = 0; x < xn; ++x) {
                        seg = tmpStr[x].split(DimensionConstants.COLON_SEPARATOR);
                        relObj.getRefDims().add((String)fieldMap.get(seg[0]));
                    }
                }
                xn2 = relInfo.getGroup().getEntries().size();
                for (x2 = 0; x2 < xn2; ++x2) {
                    if (!DimUtils.checkBaseDimension(relInfo.getGroup().getEntries().get(x2).getDimNumber())) continue;
                    String srcNNum = DimensionFormulaHelper.getDefaultSrcNumber(relInfo.getGroup().getEntries().get(x2).getDimNumber());
                    int pn = tmpStr.length;
                    for (int p = 0; p < pn; ++p) {
                        dimNumber = tmpStr[p];
                        if (dimNumber.indexOf(":") < 0 || !baseSrcSet.contains(srcNumber = dimNumber.substring(0, 3)) || !srcNumber.equalsIgnoreCase(srcNNum)) continue;
                        tmpStr[p] = dimNumber.substring(4);
                    }
                }
                relObj.getRelData().add(tmpStr);
            }
            if (relObj.getRefDims().isEmpty()) {
                jn = relInfo.getGroup().getEntries().size();
                for (j = 0; j < jn; ++j) {
                    dimNumber = relInfo.getGroup().getEntries().get(j).getDimNumber();
                    relObj.getRefDims().add(this.refFieldMap.get(dimNumber));
                }
            }
            rels.add(relObj);
        }
        HashSet<String> refDimSet = new HashSet<String>();
        int in2 = rels.size();
        for (int i = 0; i < in2; ++i) {
            relObj = (RelationObj)rels.get(i);
            refDimSet.clear();
            refDimSet.addAll(relObj.getRefDims());
            int jn = rels.size();
            block9: for (int j = 0; j < jn; ++j) {
                tmpObj = (RelationObj)rels.get(j);
                if (relObj == tmpObj && relObj.getNumber().equals(tmpObj.getNumber())) continue;
                xn = tmpObj.getRefDims().size();
                for (x = 0; x < xn; ++x) {
                    if (!refDimSet.contains(tmpObj.getRefDims().get(x))) continue;
                    relObj.getRefRelGroup().put(tmpObj.getNumber(), tmpObj);
                    continue block9;
                }
            }
        }
        return rels;
    }

    private Map<String, Set<String>> getRefDimMember(List<IDimension> dims) {
        HashMap<String, Set<String>> refMemberMap = new HashMap<String, Set<String>>();
        if (dims == null) {
            return refMemberMap;
        }
        IDimension dimension = null;
        HashSet<String> memberSet = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            int j;
            int jn;
            dimension = dims.get(i);
            memberSet = new HashSet<String>();
            if (DimUtils.checkBaseDimension(dimension)) {
                jn = dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(dimension.getDimensionMember().get(j).getNumber());
                }
            } else {
                jn = dimension.getDimensionMember().size();
                for (j = 0; j < jn; ++j) {
                    memberSet.add(dimension.getDimensionMember().get(j).getDimNumber());
                }
            }
            refMemberMap.put(dimension.getField(), memberSet);
        }
        return refMemberMap;
    }

    private List<RelationObj> filterRelationData(List<RelationObj> relObjs, Map<String, Set<String>> refMemberMap) {
        if (relObjs == null || relObjs.isEmpty() || refMemberMap == null) {
            return relObjs;
        }
        String dimField = null;
        String[] tmpStr = null;
        String srcNumber = null;
        Set<String> refMemberSet = null;
        RelationObj relObj = null;
        ArrayList<String[]> filterData = new ArrayList<String[]>(100);
        int in = relObjs.size();
        for (int i = 0; i < in; ++i) {
            relObj = relObjs.get(i);
            int jn = relObj.getRefDims().size();
            for (int j = 0; j < jn; ++j) {
                dimField = relObj.getRefDims().get(j);
                if (!refMemberMap.containsKey(dimField)) continue;
                refMemberSet = refMemberMap.get(dimField);
                filterData.clear();
                int xn = relObj.getRelData().size();
                for (int x = 0; x < xn; ++x) {
                    tmpStr = relObj.getRelData().get(x);
                    if (tmpStr == null) continue;
                    for (int t = 0; t < tmpStr.length; ++t) {
                        if (refMemberSet.contains(tmpStr[t])) {
                            filterData.add(tmpStr);
                            continue;
                        }
                        if (!this.isShowDefaultMember || !" ".equals(DimensionFormulaHelper.getMemberNumber(tmpStr[t])) || !dimField.equals(this.refFieldMap.get(this.srcDimMap.get(srcNumber = DimensionFormulaHelper.getSrcNumber(tmpStr[t]))))) continue;
                        filterData.add(tmpStr);
                    }
                }
                if (dimField.equals(DimensionConstants.DEF_PERIOD_FIELD)) {
                    boolean hasVariable = false;
                    for (String variable : refMemberSet) {
                        if (!BizCalcRunUtils.hasBgPeriodVariable((String)variable)) continue;
                        hasVariable = true;
                        break;
                    }
                    if (hasVariable) {
                        int x;
                        HashSet<String> bgPeriodNums = new HashSet<String>();
                        HashSet<String> tmpSet = new HashSet<String>();
                        int xn2 = relObj.getRelData().size();
                        for (x = 0; x < xn2; ++x) {
                            tmpStr = relObj.getRelData().get(x);
                            tmpSet.add(tmpStr[j]);
                        }
                        block6: for (String bgPeriodNum : tmpSet) {
                            for (String variable : refMemberSet) {
                                if (!BizCalcRunUtils.adapterVariable((String)variable, (String)bgPeriodNum)) continue;
                                bgPeriodNums.add(bgPeriodNum);
                                continue block6;
                            }
                        }
                        xn2 = relObj.getRelData().size();
                        for (x = 0; x < xn2; ++x) {
                            tmpStr = relObj.getRelData().get(x);
                            if (!bgPeriodNums.contains(tmpStr[j])) continue;
                            filterData.add(tmpStr);
                        }
                    }
                }
                relObj.getRelData().clear();
                relObj.getRelData().addAll(filterData);
            }
        }
        return relObjs;
    }

    private List<String[]> parseRelationData(List<RelationObj> relObjs, List<IDimension> dims) {
        int i;
        if (relObjs == null || relObjs == null) {
            return null;
        }
        ArrayList<RelationObj> tmpObjs = new ArrayList<RelationObj>();
        RelationObj relObj = null;
        RelationObj tmpObj = null;
        HashSet<String> useRelSet = new HashSet<String>();
        int in = relObjs.size();
        for (i = 0; i < in; ++i) {
            relObj = relObjs.get(i);
            if (useRelSet.contains(relObj.getNumber())) continue;
            this.mergeRelationData(relObj, useRelSet);
            tmpObjs.add(relObj);
        }
        useRelSet.clear();
        relObjs.clear();
        relObjs.addAll(tmpObjs);
        if (relObjs.size() > 1) {
            relObj = relObjs.get(0);
            in = relObjs.size();
            for (i = 1; i < in; ++i) {
                tmpObj = relObjs.get(i);
                if (useRelSet.contains(tmpObj.getNumber())) continue;
                relObj.mergeRelation(tmpObj);
            }
        } else {
            relObj = relObjs.get(0);
        }
        return relObj.getRelationData();
    }

    private void mergeRelationData(RelationObj relObj, Set<String> useRelSet) {
        if (relObj == null || useRelSet == null) {
            return;
        }
        if (!useRelSet.contains(relObj.getNumber())) {
            useRelSet.add(relObj.getNumber());
            RelationObj tmpObj2 = null;
            for (RelationObj tmpObj2 : relObj.getRefRelGroup().values()) {
                this.mergeRelationData(relObj, tmpObj2, useRelSet);
            }
        }
    }

    private void mergeRelationData(RelationObj src, RelationObj target, Set<String> useRelSet) {
        if (src == null || target == null) {
            return;
        }
        if (!useRelSet.contains(target.getNumber())) {
            src.mergeRelation(target);
            useRelSet.add(target.getNumber());
            if (!target.getRefRelGroup().isEmpty()) {
                RelationObj tmpObj2 = null;
                for (RelationObj tmpObj2 : target.getRefRelGroup().values()) {
                    this.mergeRelationData(src, tmpObj2, useRelSet);
                }
            }
        }
    }

    private List<String[]> mergeDimensionData(List<String[]> relationData, List<IDimension> dims, String layout) {
        if (relationData == null || dims == null || dims.isEmpty()) {
            return relationData;
        }
        String[] relField = relationData.get(0);
        List<String[]> tmpLis = null;
        HashSet<String> fields = new HashSet<String>();
        IDimension dimension = null;
        int in = relField.length;
        for (int i = 0; i < in; ++i) {
            fields.add(relField[i]);
        }
        String field = null;
        boolean isBefore = true;
        int in2 = dims.size();
        for (int i = 0; i < in2; ++i) {
            dimension = dims.get(i);
            field = this.getField(dimension);
            if (fields.contains(field)) {
                isBefore = false;
                continue;
            }
            tmpLis = this.mergeDimensionData(relationData, dimension, i, isBefore, layout);
            if (tmpLis == null) continue;
            relationData.clear();
            relationData.addAll(tmpLis);
        }
        return relationData;
    }

    private String getField(IDimension dimension) {
        String field = DimensionFormulaHelper.getDefaultRefField(dimension.getNumber());
        if (field == null) {
            field = dimension.getField();
        }
        return field;
    }

    private List<String[]> mergeDimensionData(List<String[]> relationData, IDimension dimension, int dimIndex, boolean isBefore, String layout) {
        ArrayList<String[]> tmpLis;
        block11: {
            if (relationData == null || relationData.isEmpty() || dimension == null) {
                return relationData;
            }
            tmpLis = new ArrayList<String[]>(relationData.size() * dimension.getDimensionMember().size());
            IMember member = null;
            String[] relationField = relationData.get(0);
            relationField = this.mergeData(relationField, this.getField(dimension), dimIndex);
            tmpLis.add(relationField);
            String[] relData = null;
            if (dimension.getDimensionMember().isEmpty() && !this.isShowDefaultMember) break block11;
            if (dimIndex == 0) {
                if (dimension.getDimensionMember().isEmpty() && this.isShowDefaultMember) {
                    int jn = relationData.size();
                    for (int j = 1; j < jn; ++j) {
                        relData = relationData.get(j);
                        if ((relData = this.mergeData(relData, null, dimIndex)) == null) continue;
                        tmpLis.add(relData);
                    }
                } else {
                    int in = dimension.getDimensionMember().size();
                    for (int i = 0; i < in; ++i) {
                        member = dimension.getDimensionMember().get(i);
                        int jn = relationData.size();
                        for (int j = 1; j < jn; ++j) {
                            relData = relationData.get(j);
                            if ((relData = this.mergeData(relData, member.getDimNumber(), dimIndex)) == null) continue;
                            tmpLis.add(relData);
                        }
                    }
                }
            } else {
                int jn = relationData.size();
                for (int j = 1; j < jn; ++j) {
                    relData = relationData.get(j);
                    if (dimension.getDimensionMember().isEmpty() && this.isShowDefaultMember) {
                        String[] relDatas = this.mergeData(relData, null, dimIndex);
                        if (relDatas == null) continue;
                        tmpLis.add(relDatas);
                        continue;
                    }
                    int in = dimension.getDimensionMember().size();
                    for (int i = 0; i < in; ++i) {
                        member = dimension.getDimensionMember().get(i);
                        String[] relDatas = this.mergeData(relData, member.getDimNumber(), dimIndex);
                        if (relDatas == null) continue;
                        tmpLis.add(relDatas);
                    }
                }
            }
        }
        return tmpLis;
    }

    private String[] mergeData(String[] data1, String number, int dimIndex) {
        if (data1 == null) {
            return null;
        }
        if (!this.isShowDefaultMember && number == null) {
            return null;
        }
        String[] tmpStrs = new String[data1.length + 1];
        if (dimIndex == 0) {
            System.arraycopy(data1, 0, tmpStrs, dimIndex + 1, data1.length);
        } else if (dimIndex == data1.length) {
            System.arraycopy(data1, 0, tmpStrs, 0, data1.length);
        } else {
            System.arraycopy(data1, 0, tmpStrs, 0, dimIndex);
            System.arraycopy(data1, dimIndex, tmpStrs, dimIndex + 1, data1.length - dimIndex);
        }
        tmpStrs[dimIndex] = number;
        return tmpStrs;
    }

    public List<String[]> queryRelation(MbgViewListDimensionManager dimManager, IDimensionParameter parameter) {
        int i;
        if (dimManager == null) {
            return null;
        }
        IMbgViewListObject obj = null;
        MbgViewListRowCol rowCol = null;
        ArrayList<String[]> relationDatas = new ArrayList<String[]>();
        List<String[]> tmpRela = null;
        String[] refFields = null;
        String[] tmpFields = null;
        boolean check = false;
        int in = dimManager.getRows().size();
        for (i = 0; i < in; ++i) {
            obj = dimManager.getRows().get(i);
            if (!(obj instanceof MbgViewListRowCol)) continue;
            rowCol = (MbgViewListRowCol)obj;
            if (rowCol.isCombin()) {
                if (rowCol.getCombinMembers() == null || rowCol.getCombinMembers().isEmpty()) continue;
                check = true;
                break;
            }
            if (rowCol.getRelationMaps() == null || rowCol.getRelationMaps().isEmpty()) continue;
            check = true;
            break;
        }
        if (!check || this.checkDims(dimManager)) {
            return null;
        }
        in = dimManager.getRows().size();
        for (i = 0; i < in; ++i) {
            List<String> list2;
            obj = dimManager.getRows().get(i);
            if (!(obj instanceof MbgViewListRowCol)) continue;
            rowCol = (MbgViewListRowCol)obj;
            List<BgDimensionBaseInfo> dimensions = rowCol.getDimensions();
            if (rowCol.isCombin()) {
                tmpRela = this.queryRelationByComMembers(rowCol, parameter);
            } else if (rowCol.getRelationMaps() != null && !rowCol.getRelationMaps().isEmpty()) {
                tmpRela = this.queryRelation(rowCol.getRelationMaps(), this.transDimension(dimensions, new HashSet<String>()), true, null);
                this.convertTmpRela(tmpRela, parameter.getDataManager().getNumInnMap());
                tmpRela = this.transRelation(tmpRela, rowCol, true, parameter);
            } else {
                tmpRela = this.queryRelationByMember(rowCol, parameter);
            }
            if (tmpRela == null || tmpRela.isEmpty()) continue;
            if (relationDatas.isEmpty()) {
                relationDatas.addAll(tmpRela);
                continue;
            }
            refFields = (String[])relationDatas.get(0);
            tmpFields = tmpRela.get(0);
            List<String> list1 = java.util.Arrays.asList(refFields);
            if (!list1.containsAll(list2 = java.util.Arrays.asList(tmpFields))) continue;
            if (!this.checkFieldSequence(refFields, tmpFields)) {
                tmpRela = this.seqRelation(refFields, tmpRela);
            }
            tmpRela.remove(0);
            relationDatas.addAll(tmpRela);
        }
        if (!relationDatas.isEmpty()) {
            return relationDatas;
        }
        return null;
    }

    private void convertTmpRela(List<String[]> tmpRela, Map<String, Map<String, String>> numInnMap) {
        int i;
        if (tmpRela == null || tmpRela.isEmpty()) {
            return;
        }
        String[] relaData = null;
        String field = null;
        String data = null;
        String[] fields = tmpRela.get(0);
        HashMap<Integer, String> dimIndex = new HashMap<Integer, String>();
        int in = fields.length;
        for (i = 0; i < in; ++i) {
            if (!DimensionBaseConstants.DEF_VERSION_FIELD.equals(fields[i]) && !DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(fields[i])) continue;
            dimIndex.put(i, fields[i]);
        }
        if (!dimIndex.isEmpty()) {
            in = tmpRela.size();
            for (i = 1; i < in; ++i) {
                relaData = tmpRela.get(i);
                int jn = relaData.length;
                for (int j = 0; j < jn; ++j) {
                    if (!dimIndex.containsKey(j)) continue;
                    data = relaData[j];
                    field = (String)dimIndex.get(j);
                    relaData[j] = data = numInnMap.get(field).get(DimUtils.getNumber(data));
                }
            }
        }
    }

    public List<String[]> queryRelationByComMembers(MbgViewListRowCol rowCol, IDimensionParameter parameter) {
        if (rowCol.getCombinMembers() == null || rowCol.getCombinMembers().isEmpty()) {
            return null;
        }
        BgDimensionMember member = null;
        ArrayList<String[]> relationDatas = new ArrayList<String[]>();
        String[] relFields = null;
        String[] relData = null;
        String[] srcNumbers = null;
        Boolean[] chkBaseDim = null;
        HashMap<String, String> srcFiledMap = new HashMap<String, String>();
        int in = rowCol.getCombinMembers().size();
        for (int i = 0; i < in; ++i) {
            int j;
            int jn;
            member = rowCol.getCombinMembers().get(i);
            if (member == null) continue;
            relData = member.getNumber().split(",");
            srcNumbers = member.getSrcNumber().split(",");
            if (relData.length != rowCol.getDimensions().size()) continue;
            if (relFields == null) {
                relFields = member.getAttribute().split(",");
                if (relFields != null) {
                    chkBaseDim = new Boolean[relFields.length];
                    jn = relFields.length;
                    for (j = 0; j < jn; ++j) {
                        if (!relFields[j].startsWith("F") || member.getType().contains(DimensionBaseConstants.DEF_ORGUNIT_NUMBER) && relFields[j].length() > 10) {
                            relFields[j] = DimUtils.getDimensionField(rowCol.getDimensions().get(j));
                        }
                        relFields[j] = DimUtils.transFields(relFields[j]);
                        chkBaseDim[j] = DimUtils.checkBaseDimensionByField(relFields[j]);
                        srcFiledMap.put(srcNumbers[j], relFields[j]);
                    }
                    relationDatas.add(relFields);
                } else {
                    return null;
                }
            }
            if (relData == null || srcNumbers == null || relData.length != srcNumbers.length) continue;
            jn = relData.length;
            for (j = 0; j < jn; ++j) {
                if (chkBaseDim == null || chkBaseDim[j] == null) continue;
                if (!chkBaseDim[j].booleanValue()) {
                    relData[j] = srcNumbers[j] + ":" + relData[j];
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_FIELD.equals(srcFiledMap.get(srcNumbers[j])) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).containsKey(relData[j])) {
                    relData[j] = parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).get(relData[j]);
                    continue;
                }
                if (!DimensionConstants.DEF_VERSION_FIELD.equals(srcFiledMap.get(srcNumbers[j])) || !parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).containsKey(relData[j])) continue;
                relData[j] = parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).get(relData[j]);
            }
            relationDatas.add(relData);
        }
        return relationDatas;
    }

    public List<String[]> queryRelation(List<MbgRelationMap> relationInfo) {
        if (relationInfo == null || relationInfo.isEmpty()) {
            return null;
        }
        MbgRelationMap relationMap = null;
        DimensionRelationshipInfo relInfo = null;
        ArrayList mergeRelationDatas = new ArrayList();
        ArrayList<String[]> relationDatas = null;
        String srcNumber = null;
        String[] relFields = null;
        String[] relData = null;
        String[] dimNumbers = null;
        Boolean[] chkBaseDim = null;
        int in = relationInfo.size();
        for (int i = 0; i < in; ++i) {
            relationMap = relationInfo.get(i);
            relFields = null;
            int xn = relationMap.getRelationShips().size();
            for (int x = 0; x < xn; ++x) {
                relInfo = relationMap.getRelationShips().get(x);
                relationDatas = new ArrayList<String[]>();
                if (relInfo.getDimensionNumber() == null) continue;
                dimNumbers = relInfo.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
                if (dimNumbers != null) {
                    int y;
                    int yn;
                    if (relFields == null) {
                        relFields = new String[dimNumbers.length];
                        chkBaseDim = new Boolean[dimNumbers.length];
                        yn = dimNumbers.length;
                        for (y = 0; y < yn; ++y) {
                            srcNumber = DimUtils.getSrcNumber(dimNumbers[y]);
                            relFields[y] = this.refFieldMap.get(this.srcDimMap.get(srcNumber));
                            chkBaseDim[y] = DimUtils.checkBaseDimensionByField(relFields[y]);
                        }
                        relationDatas.add(relFields);
                    }
                    relData = new String[relFields.length];
                    yn = dimNumbers.length;
                    for (y = 0; y < yn; ++y) {
                        relData[y] = dimNumbers[y];
                        if (chkBaseDim == null || chkBaseDim[y] == null || !chkBaseDim[y].booleanValue()) continue;
                        relData[y] = DimUtils.getNumber(relData[y]);
                    }
                    relationDatas.add(relData);
                }
                mergeRelationDatas.add(relationDatas);
            }
        }
        return relationDatas;
    }

    private List<String[]> mergeRelationData(List<List<String[]>> mergeRelationDatas) {
        if (mergeRelationDatas == null || mergeRelationDatas.isEmpty()) {
            return null;
        }
        List<String[]> relationDatas = null;
        List<String[]> targetDatas = null;
        List<String> joinDims = null;
        relationDatas = mergeRelationDatas.get(0);
        int in = mergeRelationDatas.size();
        for (int i = 1; i < in; ++i) {
            targetDatas = mergeRelationDatas.get(i);
            joinDims = this.getJoinDims(relationDatas, targetDatas);
            if (joinDims.isEmpty()) continue;
            int[] srcIndex = this.getJoinDimIndex(relationDatas, joinDims);
            int[] nArray = this.getJoinDimIndex(targetDatas, joinDims);
        }
        return relationDatas;
    }

    private int[] getJoinDimIndex(List<String[]> relationDatas, List<String> joinDims) {
        if (relationDatas == null || relationDatas.isEmpty()) {
            return null;
        }
        String refField = null;
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        String[] relaSrcs = relationDatas.get(0);
        int in = relaSrcs.length;
        for (int i = 0; i < in; ++i) {
            refField = relaSrcs[i];
            dimIndexMap.put(refField, i);
        }
        int[] joinIndex = new int[joinDims.size()];
        int in2 = joinDims.size();
        for (int i = 0; i < in2; ++i) {
            refField = joinDims.get(i);
            joinIndex[i] = (Integer)dimIndexMap.get(refField);
        }
        return joinIndex;
    }

    private List<String> getJoinDims(List<String[]> relationDatas, List<String[]> targetDatas) {
        ArrayList<String> srcDims = new ArrayList<String>();
        if (targetDatas == null || relationDatas == null || relationDatas.isEmpty() || targetDatas.isEmpty()) {
            return srcDims;
        }
        List<Object> relaList = java.util.Arrays.asList((Object[])relationDatas.get(0));
        List<Object> tarList = java.util.Arrays.asList((Object[])targetDatas.get(0));
        for (String string : tarList) {
            if (relaList == null || !relaList.contains(string)) continue;
            srcDims.add(string);
        }
        return srcDims;
    }

    protected List<String[]> transRelation(List<String[]> transDatas, MbgViewListRowCol rowCol, boolean hasRow, IDimensionParameter parameter) {
        if (transDatas == null || transDatas.isEmpty() || rowCol == null) {
            return null;
        }
        String field = null;
        MbgViewListDimensionInfo dimension = null;
        BgDimensionMember member = null;
        HashSet<String> transSet = new HashSet<String>();
        String[] transFields = transDatas.get(0);
        String[] fields = null;
        int in = transFields.length;
        for (int i = 0; i < in; ++i) {
            transSet.add(transFields[i]);
        }
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        Set<String> memberSet = null;
        List<MbgViewListDimensionInfo> dims = rowCol.getDimensions();
        fields = new String[dims.size()];
        int in2 = dims.size();
        for (int i = 0; i < in2; ++i) {
            int j;
            int jn;
            dimension = dims.get(i);
            fields[i] = field = DimUtils.getDimensionField(dimension);
            if (memberMap.containsKey(field)) {
                memberSet = (Set)memberMap.get(field);
            } else {
                memberSet = new HashSet();
                memberMap.put(field, memberSet);
            }
            if (DimUtils.checkBaseDimensionByField(DimUtils.getDimensionField(dimension))) {
                jn = dimension.getMember().size();
                for (j = 0; j < jn; ++j) {
                    member = (BgDimensionMember)dimension.getMember().get(j);
                    if (DimensionConstants.DEF_SCENARIO_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).containsKey(member.getNumber())) {
                        memberSet.add(parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).get(member.getNumber()));
                        continue;
                    }
                    if (DimensionConstants.DEF_VERSION_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).containsKey(member.getNumber())) {
                        memberSet.add(parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).get(member.getNumber()));
                        continue;
                    }
                    memberSet.add(member.getNumber());
                }
                continue;
            }
            jn = dimension.getMember().size();
            for (j = 0; j < jn; ++j) {
                member = (BgDimensionMember)dimension.getMember().get(j);
                memberSet.add(member.getSrcNumber() + ":" + member.getNumber());
            }
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : memberMap.entrySet()) {
            if (transSet.contains(entry2.getKey()) || (transDatas = Arrays.Cartesian(transDatas, (String)entry2.getKey(), (Collection)entry2.getValue())) == null) continue;
            transFields = transDatas.get(0);
            int in3 = transFields.length;
            for (int i = 0; i < in3; ++i) {
                transSet.add(transFields[i]);
            }
        }
        if (transFields.length != fields.length) {
            return null;
        }
        if (!this.checkFieldSequence(fields, transFields)) {
            transDatas = this.seqRelation(fields, transDatas);
        }
        return transDatas;
    }

    private boolean checkFieldSequence(String[] fields1, String[] fields2) {
        if (fields1 == null || fields2 == null) {
            return false;
        }
        boolean check = true;
        int in = fields1.length;
        for (int i = 0; i < in && check; ++i) {
            check = fields1[i] != null && fields2[i] != null ? fields1[i].equals(fields2[i]) : false;
        }
        return check;
    }

    private List<String[]> seqRelation(String[] fields, List<String[]> relationDatas) {
        if (fields == null || relationDatas == null || relationDatas.isEmpty()) {
            return relationDatas;
        }
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        String[] transFields = relationDatas.get(0);
        String[] tmpStrs = null;
        String[] relData = null;
        int in = transFields.length;
        for (int i = 0; i < in; ++i) {
            indexMap.put(transFields[i], i);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(fields);
        int in2 = relationDatas.size();
        for (int i = 1; i < in2; ++i) {
            relData = relationDatas.get(i);
            tmpStrs = new String[relData.length];
            int jn = fields.length;
            for (int j = 0; j < jn; ++j) {
                tmpStrs[j] = relData[(Integer)indexMap.get(fields[j])];
            }
            result.add(tmpStrs);
        }
        return result;
    }

    public List<String[]> queryRelationByMember(MbgViewListRowCol rowCol, IDimensionParameter parameter) {
        int i;
        if (rowCol == null || rowCol.getDimensions() == null || rowCol.getDimensions().isEmpty()) {
            return null;
        }
        ArrayList<String[]> relationDatas = new ArrayList<String[]>();
        ArrayList<String[]> tmpList = new ArrayList<String[]>();
        String[] relFields = null;
        String[] relData = null;
        String[] tmpData = null;
        String field = null;
        MbgViewListDimensionInfo dimension = null;
        BgDimensionMember member = null;
        relFields = new String[rowCol.getDimensions().size()];
        int in = rowCol.getDimensions().size();
        for (i = 0; i < in; ++i) {
            relFields[i] = DimUtils.getDimensionField(rowCol.getDimensions().get(i));
        }
        i = 0;
        int length = 1;
        int in2 = rowCol.getDimensions().size();
        while (i < in2) {
            int j;
            int jn;
            dimension = rowCol.getDimensions().get(i);
            if (dimension.getMember() == null || dimension.getMember().isEmpty()) {
                tmpList.clear();
                break;
            }
            if (i == 0) {
                if (DimUtils.checkBaseDimensionByField(relFields[i])) {
                    field = DimUtils.getDimensionField(dimension);
                    jn = dimension.getMember().size();
                    for (j = 0; j < jn; ++j) {
                        member = (BgDimensionMember)dimension.getMember().get(j);
                        relData = new String[relFields.length];
                        relData[i] = DimensionConstants.DEF_SCENARIO_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).containsKey(member.getNumber()) ? parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).get(member.getNumber()) : (DimensionConstants.DEF_VERSION_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).containsKey(member.getNumber()) ? parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).get(member.getNumber()) : member.getNumber());
                        tmpList.add(relData);
                    }
                } else {
                    jn = dimension.getMember().size();
                    for (j = 0; j < jn; ++j) {
                        member = (BgDimensionMember)dimension.getMember().get(j);
                        relData = new String[relFields.length];
                        relData[i] = member.getSrcNumber() + ":" + member.getNumber();
                        tmpList.add(relData);
                    }
                }
            } else {
                int x;
                int xn;
                if (DimUtils.checkBaseDimensionByField(relFields[i])) {
                    field = DimUtils.getDimensionField(dimension);
                    jn = dimension.getMember().size();
                    for (j = 0; j < jn; ++j) {
                        member = (BgDimensionMember)dimension.getMember().get(j);
                        xn = tmpList.size();
                        for (x = 0; x < xn; ++x) {
                            relData = (String[])tmpList.get(x);
                            tmpData = new String[relData.length];
                            System.arraycopy(relData, 0, tmpData, 0, length);
                            tmpData[i] = DimensionConstants.DEF_SCENARIO_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).containsKey(member.getNumber()) ? parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD).get(member.getNumber()) : (DimensionConstants.DEF_VERSION_FIELD.equals(field) && parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).containsKey(member.getNumber()) ? parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD).get(member.getNumber()) : member.getNumber());
                            relationDatas.add(tmpData);
                        }
                    }
                } else {
                    jn = dimension.getMember().size();
                    for (j = 0; j < jn; ++j) {
                        member = (BgDimensionMember)dimension.getMember().get(j);
                        xn = tmpList.size();
                        for (x = 0; x < xn; ++x) {
                            relData = (String[])tmpList.get(x);
                            tmpData = new String[relData.length];
                            System.arraycopy(relData, 0, tmpData, 0, length);
                            tmpData[i] = member.getSrcNumber() + ":" + member.getNumber();
                            relationDatas.add(tmpData);
                        }
                    }
                }
                tmpList.clear();
                tmpList.addAll(relationDatas);
                relationDatas.clear();
            }
            ++i;
            ++length;
        }
        if (tmpList.isEmpty()) {
            return null;
        }
        relationDatas.add(relFields);
        relationDatas.addAll(tmpList);
        return relationDatas;
    }

    public static List<String[]>[] optiRelationDatas(IDimensionParameter parameter, List<String[]>[] relationDatas) {
        if (parameter == null || parameter.getDataManager() == null || relationDatas == null) {
            return relationDatas;
        }
        HashSet<String> optFields = new HashSet<String>();
        if (parameter.getDataManager().getDefCurrency() != null) {
            optFields.add(DimensionBaseConstants.DEF_CURRENCY_FIELD);
        }
        if (parameter.getDataManager().getDefElement() != null) {
            optFields.add(DimensionBaseConstants.DEF_ELEMENT_FIELD);
        }
        if (parameter.getDataManager().getDefScenario() != null) {
            optFields.add(DimensionBaseConstants.DEF_SCENARIO_FIELD);
        }
        if (parameter.getDataManager().getDefVersion() != null) {
            optFields.add(DimensionBaseConstants.DEF_VERSION_FIELD);
        }
        List<String[]> relationData = null;
        ArrayList<Integer> useFields = new ArrayList<Integer>();
        String refField = null;
        int in = relationDatas.length;
        for (int i = 0; i < in; ++i) {
            int j;
            int j2;
            relationData = relationDatas[i];
            useFields.clear();
            if (relationData == null || relationData.isEmpty()) continue;
            String[] refFields = relationData.get(0);
            int jn = refFields.length;
            for (j2 = 0; j2 < jn; ++j2) {
                refField = refFields[j2];
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(refField = RelationUtils.convertRefField(refField)) && parameter.getDimension(DimensionBaseConstants.DEF_ORGUNIT_FIELD) == null) {
                    optFields.add(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
                }
                if (optFields.contains(refField)) continue;
                useFields.add(j2);
            }
            if (useFields.isEmpty()) {
                return null;
            }
            if (useFields.size() == refFields.length) {
                jn = refFields.length;
                for (j2 = 0; j2 < jn; ++j2) {
                    if (refFields[j2].startsWith("DIM")) continue;
                    refFields[j2] = "DIM" + refFields[j2];
                }
                relationData.set(0, refFields);
                continue;
            }
            String[] tmpFields = null;
            String[] tmpDatas = null;
            String[] refDatas = null;
            ArrayList<String[]> tmpList = new ArrayList<String[]>(relationData.size());
            int[] indexs = new int[useFields.size()];
            int jn2 = useFields.size();
            for (j = 0; j < jn2; ++j) {
                indexs[j] = (Integer)useFields.get(j);
            }
            tmpFields = new String[useFields.size()];
            for (j = 0; j < indexs.length; ++j) {
                tmpFields[j] = refFields[indexs[j]];
                if (tmpFields[j].startsWith("DIM")) continue;
                tmpFields[j] = "DIM" + tmpFields[j];
            }
            tmpList.add(tmpFields);
            jn2 = relationData.size();
            for (j = 1; j < jn2; ++j) {
                refDatas = relationData.get(j);
                tmpDatas = new String[tmpFields.length];
                for (int x = 0; x < indexs.length; ++x) {
                    tmpDatas[x] = refDatas[indexs[x]];
                }
                tmpList.add(tmpDatas);
            }
            relationData.clear();
            relationData.addAll(tmpList);
        }
        return relationDatas;
    }

    public static String convertRefField(String refField) {
        if (refField != null && refField.startsWith("DIM")) {
            refField = refField.substring("DIM".length());
        }
        return refField;
    }

    public static void transRelationByVerAndScen(IDimensionParameter parameter, List<String[]>[] relationDatas) {
        if (parameter == null || relationDatas == null) {
            return;
        }
        for (List<String[]> relDatas : relationDatas) {
            if (relDatas == null || relDatas.isEmpty()) continue;
            String field = null;
            String[] relData = null;
            IObjectValue model = null;
            String[] refFields = relDatas.get(0);
            int in = refFields.length;
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                field = refFields[i].replaceAll("DIM", "");
                if (DimensionConstants.DEF_VERSION_FIELD.equals(field)) {
                    Map<String, IObjectValue> versionMap = parameter.getDataManager().getBgVersionMap();
                    jn = relDatas.size();
                    for (j = 1; j < jn; ++j) {
                        relData = relDatas.get(j);
                        model = versionMap.get(relData[i]);
                        if (model == null) continue;
                        relData[i] = String.valueOf(((BgVersionInfo)model).getVersionId());
                    }
                    continue;
                }
                if (!DimensionConstants.DEF_SCENARIO_FIELD.equals(field)) continue;
                Map<String, IObjectValue> scenarioMap = parameter.getDataManager().getBgScenarioMap();
                jn = relDatas.size();
                for (j = 1; j < jn; ++j) {
                    relData = relDatas.get(j);
                    model = scenarioMap.get(relData[i]);
                    if (model == null) continue;
                    relData[i] = String.valueOf(((BgScenarioInfo)model).getScenarioId());
                }
            }
        }
    }

    protected boolean checkDims(MbgViewListDimensionManager dimManager) {
        int i;
        boolean check = false;
        List pageDimensions = dimManager.getPageDimension();
        List rowDimensions = dimManager.getRowDimension();
        HashSet<String> rowDimNumbers = new HashSet<String>();
        for (i = 0; i < rowDimensions.size(); ++i) {
            if (!(rowDimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            rowDimNumbers.add(((MbgViewListDimensionInfo)rowDimensions.get(i)).getNumber());
        }
        for (i = 0; i < pageDimensions.size(); ++i) {
            if (!(pageDimensions.get(i) instanceof MbgViewListDimensionInfo) || !rowDimNumbers.contains(((MbgViewListDimensionInfo)pageDimensions.get(i)).getNumber())) continue;
            check = true;
            break;
        }
        return check;
    }

    class RelationObj {
        private String number = null;
        private List<String> refDims = new ArrayList<String>();
        private List<String[]> relData = new ArrayList<String[]>();
        private Map<String, RelationObj> refRelGroup = new HashMap<String, RelationObj>();

        RelationObj() {
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getNumber() {
            return this.number;
        }

        public List<String> getRefDims() {
            return this.refDims;
        }

        public List<String[]> getRelData() {
            return this.relData;
        }

        public Map<String, RelationObj> getRefRelGroup() {
            return this.refRelGroup;
        }

        public void mergeRelation(RelationObj relObj) {
            if (relObj == null) {
                return;
            }
            if (this.getRelData().isEmpty() || relObj.getRelData().isEmpty()) {
                this.getRelData().clear();
                return;
            }
            List<String> joinDims = this.getJoinDims(relObj);
            if (!joinDims.isEmpty()) {
                int[] srcIndex = this.getJoinDimIndex(this, joinDims);
                int[] tarIndex = this.getJoinDimIndex(relObj, joinDims);
                this.mergeRelation(srcIndex, tarIndex, relObj);
            } else {
                this.unionRelation(relObj);
            }
        }

        private void mergeRelation(int[] srcIndex, int[] tarIndex, RelationObj relObj) {
            int i;
            if (srcIndex == null || tarIndex == null || relObj == null) {
                return;
            }
            String srcKey = null;
            String tarKey = null;
            String dimField = null;
            String[] srcData = null;
            String[] tarData = null;
            String[] tmpData = null;
            HashMap<String[], String> srcKeyMap = new HashMap<String[], String>();
            HashMap<String[], String> tarKeyMap = new HashMap<String[], String>();
            HashSet<String> srcKeySet = new HashSet<String>();
            HashSet<String> joinSet = new HashSet<String>();
            ArrayList<String[]> relationData = new ArrayList<String[]>();
            int in = this.getRelData().size();
            for (i = 0; i < in; ++i) {
                srcData = this.getRelData().get(i);
                srcKey = this.getJoinKey(srcIndex, srcData);
                if (srcKey == null) continue;
                srcKeySet.add(srcKey);
                srcKeyMap.put(srcData, srcKey);
            }
            in = relObj.getRelData().size();
            for (i = 0; i < in; ++i) {
                tarData = relObj.getRelData().get(i);
                tarKey = this.getJoinKey(tarIndex, tarData);
                if (tarKey == null) continue;
                tarKeyMap.put(tarData, tarKey);
                if (!srcKeySet.contains(tarKey)) continue;
                joinSet.add(tarKey);
            }
            in = this.getRelData().size();
            for (i = 0; i < in; ++i) {
                srcData = this.getRelData().get(i);
                srcKey = (String)srcKeyMap.get(srcData);
                if (!joinSet.contains(srcKey)) continue;
                int jn = relObj.getRelData().size();
                for (int j = 0; j < jn; ++j) {
                    tarData = relObj.getRelData().get(j);
                    tarKey = (String)tarKeyMap.get(tarData);
                    if (!srcKey.equals(tarKey) || !joinSet.contains(tarKey) || (tmpData = this.mergeData(srcData, tarData, tarIndex)) == null) continue;
                    relationData.add(tmpData);
                }
            }
            in = relObj.getRefDims().size();
            for (i = 0; i < in; ++i) {
                dimField = relObj.getRefDims().get(i);
                if (this.getRefDims().contains(dimField)) continue;
                this.getRefDims().add(dimField);
            }
            this.getRelData().clear();
            this.getRelData().addAll(relationData);
        }

        private void unionRelation(RelationObj relObj) {
            if (relObj == null) {
                return;
            }
            String[] srcData = null;
            String[] tarData = null;
            String[] tmpData = null;
            ArrayList<String[]> relationDatas = new ArrayList<String[]>(this.getRelData().size() * relObj.getRelData().size());
            int in = this.getRelData().size();
            for (int i = 0; i < in; ++i) {
                srcData = this.getRelData().get(i);
                int jn = relObj.getRelData().size();
                for (int j = 0; j < jn; ++j) {
                    tarData = relObj.getRelData().get(j);
                    tmpData = this.unionData(srcData, tarData);
                    if (tmpData == null) continue;
                    relationDatas.add(tmpData);
                }
            }
            this.getRefDims().addAll(relObj.getRefDims());
            this.getRelData().clear();
            this.getRelData().addAll(relationDatas);
        }

        private String[] unionData(String[] data1, String[] data2) {
            if (data1 == null || data2 == null) {
                return null;
            }
            String[] tmpStrs = new String[data1.length + data2.length];
            System.arraycopy(data1, 0, tmpStrs, 0, data1.length);
            System.arraycopy(data2, 0, tmpStrs, data1.length, data2.length);
            return tmpStrs;
        }

        private String[] mergeData(String[] data1, String[] data2, int[] tarIndex) {
            int i;
            if (data1 == null || data2 == null || tarIndex == null) {
                return null;
            }
            String[] tmpData = new String[data1.length + data2.length - tarIndex.length];
            System.arraycopy(data1, 0, tmpData, 0, data1.length);
            String[] tmpStr = new String[data2.length];
            System.arraycopy(data2, 0, tmpStr, 0, data2.length);
            for (i = 0; i < tarIndex.length; ++i) {
                tmpStr[tarIndex[i]] = null;
            }
            int in = tmpStr.length;
            int pos = data1.length;
            for (i = 0; i < in; ++i) {
                if (tmpStr[i] == null) continue;
                tmpData[pos++] = tmpStr[i];
            }
            return tmpData;
        }

        private List<String> getJoinDims(RelationObj relObj) {
            ArrayList<String> joinSet = new ArrayList<String>();
            if (relObj == null || relObj.getRefDims().isEmpty()) {
                return joinSet;
            }
            String refField = null;
            HashSet<String> srcDims = new HashSet<String>();
            srcDims.addAll(this.getRefDims());
            int in = relObj.getRefDims().size();
            for (int i = 0; i < in; ++i) {
                refField = relObj.getRefDims().get(i);
                if (!srcDims.contains(refField)) continue;
                joinSet.add(refField);
            }
            return joinSet;
        }

        private int[] getJoinDimIndex(RelationObj relObj, List<String> joinDims) {
            if (relObj == null || joinDims == null) {
                return null;
            }
            String refField = null;
            HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
            int in = relObj.getRefDims().size();
            for (int i = 0; i < in; ++i) {
                refField = relObj.getRefDims().get(i);
                dimIndexMap.put(refField, i);
            }
            int[] joinIndex = new int[joinDims.size()];
            int in2 = joinDims.size();
            for (int i = 0; i < in2; ++i) {
                refField = joinDims.get(i);
                joinIndex[i] = (Integer)dimIndexMap.get(refField);
            }
            return joinIndex;
        }

        private String getJoinKey(int[] joinIndex, String[] relData) {
            if (joinIndex == null || relData == null) {
                return null;
            }
            StringBuffer key = new StringBuffer();
            int in = joinIndex.length;
            for (int i = 0; i < in; ++i) {
                key.append(relData[joinIndex[i]] + DimensionConstants.COMMA_SEPARATOR);
            }
            if (key.length() > 0) {
                key = key.delete(key.length() - 1, key.length());
            }
            return key.toString();
        }

        public List<String[]> getRelationData() {
            ArrayList<String[]> relationData = new ArrayList<String[]>(this.getRefDims().size() + 1);
            String[] dimData = new String[this.getRefDims().size()];
            int in = this.getRefDims().size();
            for (int i = 0; i < in; ++i) {
                dimData[i] = this.getRefDims().get(i);
            }
            relationData.add(dimData);
            relationData.addAll(this.getRelData());
            return relationData;
        }
    }
}

