/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.function.define;

import com.kingdee.eas.ma.mbg.BizFunctionType;
import com.kingdee.eas.ma.mbg.function.dataType.IMbgFunctionDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionEnumDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionF7DataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionParamter;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionSpinnerDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionTextFieldDataType;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MbgFunctionSourceFactory {
    private static final Logger logger = Logger.getLogger(MbgFunctionSourceFactory.class);
    private static final String FUNCTIONS = "functions";
    private static final String FUNCTION = "function";
    private static final String TYPE = "type";
    private static final String SELECTOR = "selector";
    private static final String SOURCE = "source";
    private static final String NAME = "name";
    private static final String COMMIT_FM = "commit_fm";
    private static final String EDIT_FM = "edit_fm";
    private static final String DISPLAY_FM = "display_fm";
    private static final String WIZARD = "wizard";
    private static final String PARAMS = "params";
    private static final String PARAM = "param";
    private static final String ENUM = "enum";
    private static final String TITLE = "title";
    private static final String ALIAS = "alias";
    private static final String BASEFILE = "com/kingdee/eas/ma/mbg/function/define/mbg_functions_defination.xml";
    private static MbgFunctionSourceFactory factory;
    private static List<MbgFunction> functionNames;
    private Map<String, List<String>> functionNameMap = new HashMap<String, List<String>>();
    private Map<String, List<MbgFunction>> functionTypeMap = new HashMap<String, List<MbgFunction>>();
    private Map<String, MbgFunction> functionMap = new HashMap<String, MbgFunction>();
    private List<IMbgFunctionDataType> dataTypes = new ArrayList<IMbgFunctionDataType>();

    protected MbgFunctionSourceFactory() {
    }

    public static MbgFunctionSourceFactory getInstance() {
        if (factory == null) {
            factory = new MbgFunctionSourceFactory();
            try {
                factory.parse();
                logger.debug((Object)("load functions" + factory.getFunctionNameMap()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return factory;
    }

    private void parse() throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(MbgFunctionSourceFactory.class.getClassLoader().getResource(BASEFILE).openStream());
        Element root = doc.getRootElement();
        this.loadDataTypeParam(root);
        this.loadFunctions(root);
    }

    private void loadFunctions(Element root) {
        Element sheetEle = null;
        Iterator iterator = root.elementIterator(FUNCTIONS);
        while (iterator.hasNext()) {
            sheetEle = (Element)iterator.next();
            this.loadMainInfos(sheetEle);
        }
    }

    private void loadFunctionParams(MbgFunction mbgFunction, Element sheetEle) {
        ArrayList<MbgFunctionParamter> functionParamCols = null;
        MbgFunctionParamter functionParam = null;
        functionParamCols = new ArrayList<MbgFunctionParamter>();
        Element paramEle = null;
        Iterator it = sheetEle.element(PARAMS).elementIterator();
        while (it.hasNext()) {
            functionParam = new MbgFunctionParamter();
            paramEle = (Element)it.next();
            this.addFunctionParams(paramEle, functionParam);
            functionParamCols.add(functionParam);
        }
        mbgFunction.setFunctionParams(functionParamCols);
    }

    private void addFunctionParams(Element paramEle, MbgFunctionParamter functionParam) {
        functionParam.setParamName(paramEle.attributeValue(NAME));
        functionParam.setParamType(paramEle.attributeValue(TYPE));
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashMap<String, String> commentsMap = new HashMap<String, String>();
        Element aliasEle = null;
        Element commentEle = null;
        String language = null;
        String content = null;
        Iterator it = paramEle.element(ALIAS).elementIterator();
        while (it.hasNext()) {
            aliasEle = (Element)it.next();
            language = aliasEle.attributeValue("language");
            content = aliasEle.getData().toString();
            aliasMap.put(language, content);
        }
        functionParam.setAlias(aliasMap);
        if (paramEle.element("comments") != null) {
            it = paramEle.element("comments").elementIterator();
            while (it.hasNext()) {
                commentEle = (Element)it.next();
                language = commentEle.attributeValue("language");
                content = commentEle.getData().toString();
                commentsMap.put(language, content);
            }
            functionParam.setComments(commentsMap);
        }
    }

    private void loadMainInfos(Element sheetEle) {
        Element typeEle = null;
        MbgFunction mbgFunction = null;
        Iterator it = sheetEle.elementIterator();
        while (it.hasNext()) {
            typeEle = (Element)it.next();
            mbgFunction = new MbgFunction();
            mbgFunction.setFunctionDataTypes(this.dataTypes);
            mbgFunction.setName(typeEle.attributeValue(NAME));
            mbgFunction.setWizard(typeEle.attributeValue(WIZARD));
            mbgFunction.setBizFunctionType(BizFunctionType.getEnum(typeEle.attributeValue(TYPE)));
            mbgFunction.setSeq(Integer.parseInt(typeEle.attributeValue("seq")));
            this.setFunctionTitleDesc(mbgFunction, typeEle);
            this.loadFunctionParams(mbgFunction, typeEle);
            functionNames.add(mbgFunction);
            this.functionMap.put(mbgFunction.getName(), mbgFunction);
        }
        this.SortAndClassify();
    }

    private void setFunctionTitleDesc(MbgFunction mbgFunction, Element typeEle) {
        HashMap<String, String> functionTitle = new HashMap<String, String>();
        HashMap<String, String> descriptionMap = new HashMap<String, String>();
        String language = null;
        Object description = null;
        String content = null;
        Element titleEle = null;
        Element descEle = null;
        Iterator it = typeEle.element(TITLE).elementIterator();
        while (it.hasNext()) {
            titleEle = (Element)it.next();
            language = titleEle.attributeValue("language");
            content = titleEle.getData().toString();
            functionTitle.put(language, content);
        }
        it = typeEle.element("descriptions").elementIterator();
        while (it.hasNext()) {
            descEle = (Element)it.next();
            language = descEle.attributeValue("language");
            content = descEle.getData().toString();
            descriptionMap.put(language, content);
        }
        mbgFunction.setFunctionTitle(functionTitle);
        mbgFunction.setDescription(descriptionMap);
    }

    private void loadDataTypeParam(Element root) {
        Element sheetEle = null;
        Object dataType = null;
        MbgFunctionF7DataType f7DataType = null;
        MbgFunctionEnumDataType enumDataType = null;
        MbgFunctionTextFieldDataType textFieldDataType = null;
        MbgFunctionSpinnerDataType spinnerDataType = null;
        Iterator iterator = root.elementIterator("datatypes");
        while (iterator.hasNext()) {
            sheetEle = (Element)iterator.next();
            Element typeEle = null;
            String sort = null;
            Iterator it = sheetEle.elementIterator();
            while (it.hasNext()) {
                typeEle = (Element)it.next();
                sort = typeEle.attribute("sort").getValue();
                if (SELECTOR.equals(sort)) {
                    f7DataType = new MbgFunctionF7DataType();
                    f7DataType.setName(typeEle.attribute(NAME).getValue());
                    f7DataType.setSort(sort);
                    f7DataType.setSource(typeEle.elementText(SOURCE));
                    f7DataType.setCommit_fm(typeEle.elementText(COMMIT_FM));
                    f7DataType.setEdit_fm(typeEle.elementText(EDIT_FM));
                    f7DataType.setDisplay_fm(typeEle.elementText(DISPLAY_FM));
                    this.dataTypes.add(f7DataType);
                    continue;
                }
                if (ENUM.equals(sort)) {
                    enumDataType = new MbgFunctionEnumDataType();
                    enumDataType.setName(typeEle.attribute(NAME).getValue());
                    enumDataType.setSort(sort);
                    enumDataType.setSource(typeEle.elementText(SOURCE));
                    this.dataTypes.add(enumDataType);
                    continue;
                }
                if ("textField".equals(sort)) {
                    textFieldDataType = new MbgFunctionTextFieldDataType();
                    textFieldDataType.setName(typeEle.attribute(NAME).getValue());
                    textFieldDataType.setSort(sort);
                    textFieldDataType.setSource(typeEle.elementText(SOURCE));
                    textFieldDataType.setRequired(Boolean.parseBoolean(typeEle.attribute("required").getValue()));
                    textFieldDataType.setEnable(Boolean.parseBoolean(typeEle.attribute("enable").getValue()));
                    this.dataTypes.add(textFieldDataType);
                    continue;
                }
                if (!"kdSpinner".equals(sort)) continue;
                spinnerDataType = new MbgFunctionSpinnerDataType();
                spinnerDataType.setName(typeEle.attribute(NAME).getValue());
                spinnerDataType.setSort(sort);
                spinnerDataType.setSource(typeEle.elementText(SOURCE));
                spinnerDataType.setRequired(Boolean.parseBoolean(typeEle.attribute("required").getValue()));
                spinnerDataType.setEnable(Boolean.parseBoolean(typeEle.attribute("enable").getValue()));
                this.dataTypes.add(spinnerDataType);
            }
        }
    }

    public List getFunctionNames() {
        return functionNames;
    }

    public Map<String, List<String>> getFunctionNameMap() {
        return this.functionNameMap;
    }

    public Map<String, List<MbgFunction>> getFunctionTypeMap() {
        return this.functionTypeMap;
    }

    public MbgFunction getFunction(String functionName) {
        return this.functionMap.get(functionName);
    }

    public List<String> getAllFunctionsName() {
        ArrayList<String> allFunctionsName = new ArrayList<String>();
        MbgFunction function = null;
        for (int i = 0; i < functionNames.size(); ++i) {
            function = functionNames.get(i);
            allFunctionsName.add(function.getName());
        }
        return allFunctionsName;
    }

    protected void SortAndClassify() {
        Collections.sort(functionNames, (Comparator)new Comparator<MbgFunction>(){

            @Override
            public int compare(MbgFunction fn1, MbgFunction fn2) {
                Integer seq1 = fn1.getSeq();
                Integer seq2 = fn2.getSeq();
                return seq1.compareTo(seq2);
            }
        });
        for (MbgFunction mbgFunction : functionNames) {
            List<Object> nameList = null;
            List<Object> fnList = null;
            if (!this.functionNameMap.containsKey(mbgFunction.getBizFunctionType().getName())) {
                nameList = new ArrayList();
                fnList = new ArrayList();
                this.functionNameMap.put(mbgFunction.getBizFunctionType().getName(), nameList);
                this.functionTypeMap.put(mbgFunction.getBizFunctionType().getName(), fnList);
            } else {
                nameList = this.functionNameMap.get(mbgFunction.getBizFunctionType().getName());
                fnList = this.functionTypeMap.get(mbgFunction.getBizFunctionType().getName());
            }
            if (nameList == null) continue;
            nameList.add(mbgFunction.getName());
            fnList.add(mbgFunction);
        }
    }

    static {
        functionNames = new ArrayList<MbgFunction>();
    }
}

