/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.parse;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BgExamineParseHelper {
    public static boolean isMBR(String currExpr) {
        if (!currExpr.startsWith("MBR")) {
            return false;
        }
        return BgExamineParseHelper.verifyFormula("MBR", currExpr);
    }

    public static boolean isPTO(String currExpr) {
        if (!currExpr.startsWith("PTO")) {
            return false;
        }
        return BgExamineParseHelper.verifyFormula("PTO", currExpr);
    }

    public static boolean verifyFormula(String formulaName, String formula) {
        Pattern pattern = null;
        Matcher matcher = null;
        String reg = null;
        String regOther = null;
        if (formulaName.equals("MBR")) {
            reg = formula.indexOf("Sch:") != -1 ? (formula.indexOf("@Parent") != -1 ? "^MBR:\\[\"(Sch:[\\S]+)?\"(,?\"\\w{3}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]" : "^MBR:\\[\"(Sch:[\\S]+)?\"(,?\"?\\w{3}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|+|!]+)?\"?)+\\)\\]\")+\\]") : (formula.indexOf("@Parent") != -1 ? "^MBR:\\[(,?\"\\w{3}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]" : "^MBR:\\[(,?\"\\w{3}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|+|!]+)?\"?)+\\)\\]\")+\\]");
        } else if (formulaName.equals("PTO")) {
            reg = formula.indexOf("Sch:") != -1 ? (formula.indexOf("@Parent") != -1 ? "^PTO:\\[\"(Sch:[\\S]+)?\"(,?\"\\w{3,}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]" : "^PTO:\\[\"(Sch:[\\S]+)?\"(,?\"?\\w{3,}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|+|!]+)?\"?)+\\)\\]\")+\\]") : (formula.indexOf("@Parent") != -1 ? "^PTO:\\[(,?\"\\w{3,}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]" : "^PTO:\\[(,?\"\\w{3,}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|+|!]+)?\"?)+\\)\\]\")+\\]");
        } else if (formulaName.equals("VAR")) {
            reg = "^VAR:\\[\"([\\w-]+\\.)*[\\w-]+\"\\]";
        } else if (formulaName.equals("GVF")) {
            if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("Acct")) {
                reg = "^GVF:\\[Acct\\(\"(([\\w]+\\.)*[\\w]*+; *)*([\\w]+\\.)*[\\w]*\",\"[\\s\\S]*\",\"[\\w]*\",(-?[0-9]+,){4}\"([\\w]+\\.)*[\\w]*\",\"([\\w]+\\.)*[\\w]*\"\\)]";
            } else if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("AcctItem")) {
                reg = "^GVF:\\[AcctItem\\((\"\\w*\",){7}([0-9]*,){3}(\"\\w*\",){3}((true|false),){2}\"\\w*\",(true|false),\"\\w*\"\\)\\]";
                if (formula.startsWith("GVF")) {
                    String formulaExpr = formula.substring(5, formula.length() - 1);
                    try {
                        Expression expression = ExcelFormulaPaserHelper.parse((String)formulaExpr);
                        return BgExamineParseHelper.checkAcctItemExpression(expression);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)reg) && (matcher = (pattern = Pattern.compile(reg)).matcher(formula)).matches()) {
            return true;
        }
        return !StringUtils.isEmpty(regOther) && (matcher = (pattern = Pattern.compile(regOther)).matcher(formula)).matches();
    }

    private static boolean checkAcctItemExpression(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof FunctionExpr) {
            return ((FunctionExpr)expression).parameters.size() == 18;
        }
        return false;
    }
}

