/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgExpressionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgExpressionFacade;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgBookParseHelper;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.provider.IMBGProvider;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class MBGProvider
extends AbstractProvider<IMbgViewManager, IMbgSheetManager>
implements IMBGProvider {
    private static final Logger logger = Logger.getLogger((String)MBGProvider.class.getName());
    protected MbgXMLParser parser = new MbgXMLParser(this.getCtx());
    private MbgBookParseHelper bookParseHelper;
    protected Map propertyData = null;

    public void addOtherOrgViewData(FullOrgUnitInfo orgUnitInfo, IMbgViewManager mbgViewManager) {
        this.getBgViewManagerForMulOrg().put(orgUnitInfo.getNumber(), mbgViewManager);
        this.orgUnitMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
    }

    @Override
    public MbgBookParseHelper getBookParseHelper() {
        if (this.bookParseHelper == null) {
            this.bookParseHelper = new MbgBookParseHelper(this.getBookDimensionParse(), this.getOrgUnitInfo(), this.getBgViewManagerForMulOrg(), (Map<String, FullOrgUnitInfo>)this.orgUnitMap, this.isCheckFull(), this.getMemberFilter(), this.getCheckFactory().getCacheHelper());
        }
        for (String orgNumber : this.getBgViewManagerForMulOrg().keySet()) {
            if (this.bookParseHelper.getBgViewManagerForMulOrg().containsKey(orgNumber)) continue;
            this.bookParseHelper.getBgViewManagerForMulOrg().put(orgNumber, (IMbgViewBase)this.getBgViewManagerForMulOrg().get(orgNumber));
        }
        this.bookParseHelper.setVersionNumber(this.getVersionNumber());
        this.bookParseHelper.setOrgViewId(this.getOrgViewId());
        this.bookParseHelper.setEditScenType(this.getEditScenType());
        this.bookParseHelper.setCtx(this.getCtx());
        return this.bookParseHelper;
    }

    @Override
    public List<KDPromptBox> getPageF7List(int sheetIndex) {
        return this.getBookParseHelper().getPageF7List(sheetIndex);
    }

    @Override
    public List<KDPromptBox> getViewF7List(int sheetIndex) {
        return this.getBookParseHelper().getViewF7List(sheetIndex);
    }

    public MbgXMLParser getParser() {
        return this.parser;
    }

    @Override
    public void refreshSheet(Book book, Sheet sheet) throws Exception {
        if (this.curMbgViewManager == null || sheet == null) {
            return;
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        HashSet<String> orgNums = new HashSet<String>();
        String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), orgNums);
        if (orgNums.isEmpty()) {
            orgNums.add(this.getOrgUnitInfo().getNumber());
        }
        this.addBgViewManagerForMultiOrg(orgNums);
        HashMap<String, IMbgSheetBase> bgSheetManagerForMulOrg = new HashMap<String, IMbgSheetBase>();
        for (String orgNum : orgNums) {
            if (!this.getBgViewManagerForMulOrg().containsKey(orgNum) || this.getBgViewManagerForMulOrg().get(orgNum) == null || ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().isEmpty()) {
                throw new BgFormException(BgFormException.FORMORGUNITERROR, new String[]{orgNum});
            }
            bgSheetManagerForMulOrg.put(orgNum, ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheet.getIndex()));
        }
        if (bgSheetManagerForMulOrg.size() == 0) {
            return;
        }
        if (!bgSheetManagerForMulOrg.containsKey(curOrgNumForDimensionData)) {
            bgSheetManagerForMulOrg.put(curOrgNumForDimensionData, ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData)).getSheetManagers().get(sheet.getIndex()));
        }
        Map<String, Map<String, BgNViewDataInfo>> tmpData = this.divideSheetDataFromDataCache(sheet);
        this.getBookParseHelper().createPageView(this.getOwner(), curOrgNumForDimensionData, bgSheetManagerForMulOrg, sheet, this.getCheckFactory(), this.getOrgPermission());
        this.initQueryData(sheet);
        this.getBookParseHelper().getSheet(this.getOwner(), this, curOrgNumForDimensionData, bgSheetManagerForMulOrg, sheet, this.getCheckFactory(), this.getOrgPermission());
        this.fillData(sheet, tmpData);
        BgNFSHelper.enableUndo(book);
    }

    protected Map<String, Map<String, BgNViewDataInfo>> divideSheetDataFromDataCache(Sheet sheet) throws Exception {
        return null;
    }

    protected void addBgViewManagerForMultiOrg(Set<String> orgNums) throws Exception {
    }

    protected Map<String, Map<String, BgNDataInfo>> divideDataFromDataCache() {
        return null;
    }

    @Override
    public IMbgSheetManager getDimensionDataForCurSheet(Sheet sheet) throws Exception {
        String orgNum = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), new HashSet<String>());
        IMbgViewManager imbgViewManager = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum);
        if (imbgViewManager == null) {
            HashSet<String> orgNumsSet = new HashSet<String>();
            orgNumsSet.add(orgNum);
            this.addBgViewManagerForMultiOrg(orgNumsSet);
        }
        if ((imbgViewManager = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum)) == null) {
            return null;
        }
        return imbgViewManager.getSheetManagers().get(sheet.getSheetIndex());
    }

    public FullOrgUnitInfo getOrgUnitForCurSheet(Sheet sheet) {
        String orgNum = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), new HashSet<String>());
        return (FullOrgUnitInfo)this.orgUnitMap.get(orgNum);
    }

    public FullOrgUnitInfo getOrgUnitForCurSheet(int sheetIndex) {
        String orgNum = this.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
        return (FullOrgUnitInfo)this.orgUnitMap.get(orgNum);
    }

    @Override
    public String getOrgUnitIdForCurSheet(Sheet sheet) {
        return this.getOrgUnitForCurSheet(sheet).getId().toString();
    }

    @Override
    public String getOrgNumsForCurSheet(int sheetIndex, Set<String> orgNums) {
        String curOrgNumForDimensionData = null;
        if (this.getCurMbgSheetManager() == null) {
            return null;
        }
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex).getDimensionManager());
        if (isorgOnPageOrView) {
            List<KDPromptBox> pageF7List;
            List<KDPromptBox> viewF7List = this.getViewF7List(sheetIndex);
            Object data = null;
            if (viewF7List != null) {
                for (int i = 0; i < viewF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(viewF7List.get(i).getName()) || !((data = viewF7List.get(i).getData()) instanceof OrgUnitInfo)) continue;
                    orgNums.add(((OrgUnitInfo)data).getNumber());
                    curOrgNumForDimensionData = ((OrgUnitInfo)data).getNumber();
                }
            }
            if ((pageF7List = this.getPageF7List(sheetIndex)) != null) {
                for (int i = 0; i < pageF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(pageF7List.get(i).getName())) continue;
                    data = pageF7List.get(i).getData();
                    if (data instanceof OrgUnitInfo) {
                        orgNums.add(((OrgUnitInfo)data).getNumber());
                        curOrgNumForDimensionData = ((OrgUnitInfo)data).getNumber();
                        continue;
                    }
                    if (!(data instanceof BgOrgUnitInfo)) continue;
                    orgNums.add(((BgOrgUnitInfo)data).getNumber());
                    curOrgNumForDimensionData = ((BgOrgUnitInfo)data).getNumber();
                }
            }
        } else {
            this.getOrgMembers(orgNums, ((IMbgSheetManager)this.getCurMbgSheetManager()).getDimensionManager().getRowDisplayDimension());
            this.getOrgMembers(orgNums, ((IMbgSheetManager)this.getCurMbgSheetManager()).getDimensionManager().getColDisplayDimension());
            curOrgNumForDimensionData = this.getOrgUnitInfo().getNumber();
        }
        if (StringUtils.isEmpty(curOrgNumForDimensionData)) {
            curOrgNumForDimensionData = this.getOrgUnitInfo().getNumber();
        }
        return curOrgNumForDimensionData;
    }

    private void getOrgMembers(Set<String> orgNums, List<BgDimensionInfo> dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(i).getNumber())) continue;
            for (int j = 0; j < dimensions.get(i).getMember().size(); ++j) {
                orgNums.add(((BgDimensionMember)dimensions.get(i).getMember().get(j)).getNumber());
            }
        }
    }

    protected void getOrgNumsForCurViewManager(IMbgViewManager viewManager, Set<String> orgNums) {
        if (viewManager == null || orgNums == null) {
            return;
        }
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(viewManager.getSheetManagers().get(sheetIndex).getDimensionManager());
            if (isorgOnPageOrView) continue;
            this.getOrgMembers(orgNums, viewManager.getSheetManagers().get(sheetIndex).getDimensionManager().getRowDisplayDimension());
            this.getOrgMembers(orgNums, viewManager.getSheetManagers().get(sheetIndex).getDimensionManager().getColDisplayDimension());
            break;
        }
    }

    @Override
    public void fillData(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> tmpData) throws Exception {
        BgNFSHelper.disableCal(sheet.getBook());
        BgNFSHelper.disableUndo(sheet.getBook());
        ArrayList<BgAttributeColumn> attrCol = new ArrayList<BgAttributeColumn>();
        ArrayList<Integer> attrColPos = new ArrayList<Integer>();
        HashMap<String, List<KDTextField>> txtMaps = new HashMap<String, List<KDTextField>>();
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        this.getAttributeCol(sheet, data, attrCol, attrColPos, txtMaps);
        if (attrCol.size() > 0 && data.size() > 0) {
            Map _data = TemplateFacadeFactory.getRemoteInstance().getAttributeColData(data, attrCol);
            this.fillAttrValue(sheet, attrColPos, _data, txtMaps);
        }
        this.dealCalculateColFormula(sheet);
    }

    protected void dealCalculateColFormula(Sheet sheet) throws Exception {
        long ct = System.currentTimeMillis();
        if (sheet == null) {
            return;
        }
        Column column = null;
        BgCalcuteColumn bgCalcuteColumn = null;
        Row row = null;
        List _rowObj = null;
        Cell cell = null;
        List viewMembers = BgViewHelper.getCurrPageMember(this.getViewF7List(sheet.getSheetIndex()), this.getDimensionDataForCurSheet(sheet).getDimensionManager().getDimension());
        List pageMembers = BgViewHelper.getCurrPageMember(this.getPageF7List(sheet.getSheetIndex()), this.getDimensionDataForCurSheet(sheet).getDimensionManager().getDimension());
        String orgNumber = null;
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (!MBgTemplateHelper.isCalColumn(column) || StringUtils.isEmpty((String)(bgCalcuteColumn = MBgTemplateHelper.getCalColumn(column)).getFormula())) continue;
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                row = sheet.getRow(rowIndex, false);
                if (row == null || row.getUserObjectValue("DIMENSION") == null) continue;
                _rowObj = (List)row.getUserObjectValue("DIMENSION");
                if (_rowObj != null) {
                    if (viewMembers != null) {
                        _rowObj.addAll(viewMembers);
                    }
                    if (pageMembers != null) {
                        _rowObj.addAll(pageMembers);
                    }
                }
                String itemCombine = this.getItemCombine(_rowObj);
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null) continue;
                long cc = System.currentTimeMillis();
                orgNumber = null;
                if (_rowObj != null && !_rowObj.isEmpty()) {
                    for (int i = 0; i < _rowObj.size(); ++i) {
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionMember)_rowObj.get(i)).getType())) continue;
                        orgNumber = ((BgDimensionMember)_rowObj.get(i)).getNumber();
                        break;
                    }
                }
                String _expression = BgNExpressionHelper.checkExpression(null, cell, BgNFSHelper.getExpression(cell), this.model, orgNumber, itemCombine, false, false);
                _expression = BgNExpressionHelper.dealExpressSpecialSymbols(_expression, _rowObj);
                long cc1 = System.currentTimeMillis();
                if (cc1 - cc > 10L) {
                    // empty if block
                }
                cc = cc1;
                if (_expression != null && (_expression.indexOf(DimensionConstants.DEF_INDEX_SRCNUMBER + ":") >= 0 || _expression.toUpperCase().indexOf("MbgAggregate".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("Mbgadjust".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgAdjustDate".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgBgAvlBal".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgRefBgTem".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgRefBgForm".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgCorUnit".toUpperCase()) >= 0 || _expression.toUpperCase().indexOf("MbgActualDay".toUpperCase()) >= 0)) {
                    cell.setFormula(_expression);
                    cell.setValue(cell.getValue());
                }
                if ((cc1 = System.currentTimeMillis()) - cc <= 10L) continue;
            }
        }
        logger.info((Object)("dealCalculateColFormula:" + (System.currentTimeMillis() - ct) + "(ms)"));
    }

    protected IBgExpressionFacade getExpressionInterface() throws BOSException {
        return BgExpressionFacadeFactory.getRemoteInstance();
    }

    public void fillData(Book book, boolean isSynch) throws Exception {
        this.fillDimData(book, isSynch);
    }

    @Override
    public void fillData(Book book) throws Exception {
        this.fillDimData(book, false);
    }

    private void fillDimData(Book book, boolean isSynch) throws Exception {
        int sheetIndex;
        if (book == null) {
            return;
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        ArrayList<BgAttributeColumn> attrCol = new ArrayList<BgAttributeColumn>();
        HashMap attrColPos = new HashMap();
        HashMap txtMaps = new HashMap();
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        for (sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            if (attrColPos.get(sheetIndex) == null) {
                attrColPos.put(sheetIndex, new ArrayList());
            }
            if (txtMaps.get(sheetIndex) == null) {
                txtMaps.put(sheetIndex, new HashMap());
            }
            this.getAttributeCol(book.getSheet(sheetIndex), data, attrCol, (List)attrColPos.get(sheetIndex), (Map)txtMaps.get(sheetIndex));
        }
        if (attrCol.size() > 0 && data.size() > 0) {
            Map _data = TemplateFacadeFactory.getRemoteInstance().getAttributeColData(data, attrCol);
            for (int sheetIndex2 = 0; sheetIndex2 < book.getSheetCount(); ++sheetIndex2) {
                this.fillAttrValue(book.getSheet(sheetIndex2), (List)attrColPos.get(sheetIndex2), _data, (Map)txtMaps.get(sheetIndex2));
            }
        }
        if (!isSynch) {
            for (sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
                this.dealCalculateColFormula(book.getSheet(sheetIndex));
            }
        }
    }

    protected void fillAttrValue(Sheet sheet, List<Integer> attrColPos, Map<String, Map<String, String>> data, Map<String, List<KDTextField>> txtMaps) {
        long ct = System.currentTimeMillis();
        BgSheetRange range = new BgSheetRange(sheet);
        Column col = null;
        List<BgDimensionMember> _tmpMembers = null;
        BgAttributeColumn attrColInfo = null;
        Map<String, String> subData = null;
        String number = null;
        String key = null;
        for (int i = 0; i < attrColPos.size(); ++i) {
            col = sheet.getColumn(attrColPos.get(i).intValue(), false);
            attrColInfo = MBgTemplateHelper.getBgAttributeColumn(col);
            key = attrColInfo.getDimensionInfo().getNumber() + "_" + attrColInfo.getRefColumn();
            subData = data.get(key);
            if (subData == null || subData.size() == 0) continue;
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                _tmpMembers = BgDimensionParseCommonHelper.getDimensionInfo(sheet.getRow(rowIndex, false));
                if (_tmpMembers == null || _tmpMembers.size() <= 0) continue;
                for (int memberIndex = 0; memberIndex < _tmpMembers.size(); ++memberIndex) {
                    if (_tmpMembers.get(memberIndex).getType() == null || !_tmpMembers.get(memberIndex).getType().equals(attrColInfo.getDimensionInfo().getNumber())) continue;
                    number = _tmpMembers.get(memberIndex).getNumber();
                    range.addCell(rowIndex, col.getCol());
                    if (!subData.containsKey(number)) continue;
                    BgNFSHelper.setValue(sheet.getCell(rowIndex, col.getCol(), true), subData.get(number));
                }
            }
        }
        Range r = range.getRange();
        if (r != null) {
            StyleAttributes sa = Styles.getEmptySA();
            sa.setNumberFormat("@");
            r.setStyle(sa, Styles.getEmptySA());
        }
        if (txtMaps != null) {
            String memberNum = null;
            List<KDTextField> txts = null;
            Map.Entry<String, List<KDTextField>> entry2 = null;
            for (Map.Entry<String, List<KDTextField>> entry2 : txtMaps.entrySet()) {
                memberNum = entry2.getKey().split("\\|")[1];
                txts = entry2.getValue();
                if (txts == null) continue;
                BgAttributeColumn attrCol = null;
                for (int i = 0; i < txts.size(); ++i) {
                    attrCol = (BgAttributeColumn)txts.get(i).getUserObject();
                    subData = data.get(attrCol.getPropertyId());
                    if (subData == null || subData.size() == 0) continue;
                    if (subData.containsKey(memberNum)) {
                        txts.get(i).setText(subData.get(memberNum));
                        continue;
                    }
                    txts.get(i).setText("");
                }
            }
        }
        logger.info((Object)("fillAttrValue:" + (System.currentTimeMillis() - ct) + "(ms)"));
    }

    protected void getAttributeCol(Sheet sheet, Map<String, Set<String>> data, List<BgAttributeColumn> attrCol, List<Integer> attrColPos, Map<String, List<KDTextField>> txtMaps) {
        if (sheet == null) {
            return;
        }
        Row row = null;
        Column col = null;
        BgAttributeColumn attrColInfo = null;
        BgDimensionInfo dimensionInfo = null;
        List<BgDimensionMember> _tmpMembers = null;
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            col = sheet.getColumn(colIndex, false);
            if (!MBgTemplateHelper.isAttrColumn(col)) continue;
            attrColInfo = MBgTemplateHelper.getBgAttributeColumn(col);
            dimensionInfo = attrColInfo.getDimensionInfo();
            String key = dimensionInfo.getNumber() + "_" + attrColInfo.getRefColumn();
            attrCol.add(attrColInfo);
            attrColPos.add(colIndex);
            if (!data.containsKey(key)) {
                data.put(key, new HashSet());
            }
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                row = sheet.getRow(rowIndex, false);
                _tmpMembers = BgDimensionParseCommonHelper.getDimensionInfo(row);
                if (_tmpMembers == null || _tmpMembers.size() <= 0) continue;
                for (int memberIndex = 0; memberIndex < _tmpMembers.size(); ++memberIndex) {
                    if (_tmpMembers.get(memberIndex).getType() == null || !_tmpMembers.get(memberIndex).getType().equals(dimensionInfo.getNumber())) continue;
                    data.get(key).add(_tmpMembers.get(memberIndex).getNumber());
                }
            }
        }
        List<KDPanel> subPnl = this.getBookParseHelper().getViewPnlList(sheet.getSheetIndex());
        if (subPnl != null) {
            this.addViewOrPageAttr(data, subPnl, txtMaps, attrCol);
        }
        if ((subPnl = this.getBookParseHelper().getPagePnlList(sheet.getSheetIndex())) != null) {
            this.addViewOrPageAttr(data, subPnl, txtMaps, attrCol);
        }
    }

    private void addViewOrPageAttr(Map<String, Set<String>> data, List<KDPanel> subPnl, Map<String, List<KDTextField>> txtmaps, List<BgAttributeColumn> attrCol) {
        KDPromptBox f7 = null;
        String memberNum = null;
        String propertySrcId = null;
        BgAttributeColumn property = null;
        List<KDTextField> attrTxts = null;
        Object f7Data = null;
        for (int i = 0; i < subPnl.size(); ++i) {
            this.getBookParseHelper();
            f7 = MbgBookParseHelper.getF7FromPnl(subPnl.get(i));
            if (f7 == null || f7.getData() == null) continue;
            f7Data = f7.getData();
            if (f7.getData() instanceof List && ((List)f7.getData()).size() > 0) {
                f7Data = ((List)f7.getData()).get(0);
            }
            if (f7Data instanceof BgDimensionMember) {
                memberNum = String.valueOf(((BgDimensionMember)f7Data).getNumber());
            } else if (f7Data instanceof IObjectValue) {
                memberNum = String.valueOf(((IObjectValue)f7Data).get("number"));
            }
            attrTxts = this.getBookParseHelper().getAttrTxtsFromPnl(subPnl.get(i));
            if (attrTxts == null || attrTxts.size() <= 0) continue;
            for (int j = 0; j < attrTxts.size(); ++j) {
                property = (BgAttributeColumn)attrTxts.get(j).getUserObject();
                propertySrcId = property.getPropertyId();
                if (!data.containsKey(propertySrcId)) {
                    data.put(propertySrcId, new HashSet());
                }
                data.get(propertySrcId).add(memberNum);
                if (!txtmaps.containsKey(f7.getName() + "|" + memberNum)) {
                    txtmaps.put(f7.getName() + "|" + memberNum, new ArrayList());
                }
                txtmaps.get(f7.getName() + "|" + memberNum).add(attrTxts.get(j));
                attrCol.add(property);
            }
        }
    }

    @Override
    @Deprecated
    public IBgDimensionManager getBgDimensionManager() {
        return null;
    }

    @Override
    public void store(Object obj) throws Exception {
    }

    @Override
    public void store(Book book) throws Exception {
    }

    @Override
    public void store(Sheet sheet) throws Exception {
    }

    @Override
    public void reloadBook(Book book) throws Exception {
    }

    @Override
    public Map<String, IMbgViewManager> getBgViewManagerForMulOrgByOrgId() {
        if (this.getBgViewManagerForMulOrg() == null || this.getBgViewManagerForMulOrg().isEmpty()) {
            return null;
        }
        HashMap<String, IMbgViewManager> returnMap = new HashMap<String, IMbgViewManager>();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : this.getBgViewManagerForMulOrg().entrySet()) {
            if (!this.orgUnitMap.containsKey(entry2.getKey())) continue;
            returnMap.put(((FullOrgUnitInfo)this.orgUnitMap.get(entry2.getKey())).getId().toString(), (IMbgViewManager)entry2.getValue());
        }
        return returnMap;
    }

    @Override
    public void reset() {
        super.reset();
        this.bookParseHelper = null;
    }
}

