/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.form.ActionShowAdjust;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgBookParseHelper;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBGFormProvider
extends MBGBaseFormProvider {
    private static final Logger logger = Logger.getLogger((String)MBGFormProvider.class.getName());
    public Map<String, BgFormStateEnum> orgIdFormState = new HashMap<String, BgFormStateEnum>();
    private Object isInPorInst = null;

    @Override
    public Object load() throws Exception {
        this.loadMbgViewManager();
        this.addOtherOrgViewData(this.getOrgUnitInfo(), (IMbgViewManager)this.curMbgViewManager);
        this.loadMultiOrg();
        Map<String, List<IBgDimensionManagerBase>> initDimensionManagers = this.getInitDimensionManagers();
        this.startQueryData(initDimensionManagers);
        this.getBookParseHelper().refreshCurMbgViewManager(this.getOrgUnitInfo(), this.curMbgViewManager);
        this.getOrgIdFormStateMap();
        Book book = this.loadBook();
        this.setCurMbgSheetManager((IMbgSheetBase)((IMbgViewManager)this.curMbgViewManager).getSheetManagers().get(book.getActiveSheetIndex()));
        book.setUserObject("dimensionManager", initDimensionManagers);
        BgCommentCommonHelper.setCommentProtection(book);
        return book;
    }

    protected void getOrgIdFormStateMap() throws EASBizException, BOSException {
        Map orgIdFormIdMap;
        Set<String> orgIdSetByCurManager = this.getOrgIdSetByCurManager();
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null && bgFormInfo.getId() != null && orgIdSetByCurManager != null && !orgIdSetByCurManager.isEmpty() && (orgIdFormIdMap = BgAdjustFacadaFactory.getRemoteInstance().getOrgIdFormIdMap(bgFormInfo.getId().toString(), orgIdSetByCurManager)) != null && !orgIdFormIdMap.isEmpty()) {
            this.orgIdFormState = orgIdFormIdMap;
        }
    }

    protected void startQueryData(Map<String, List<IBgDimensionManagerBase>> initDimensionManagers) throws BOSException, EASBizException {
        this.getQueryDataHelper().startQueryData(this.getQueryDataInfo(), initDimensionManagers, this.getDataType(), this.getBgOrgViewId(), false);
    }

    protected void loadMbgViewManager() throws Exception {
        byte[] dataBytes = null;
        byte[] styleBytes = null;
        BgFormInfo bgFormInfo = null;
        if (this.getEditValue() instanceof BgFormInfo) {
            BgFormEntryInfo obj;
            bgFormInfo = (BgFormInfo)this.getEditValue();
            this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
            if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
                dataBytes = obj.getDimensionData();
                styleBytes = obj.getDimensionStyle();
                this.curMbgViewManager = this.getParser().parse(dataBytes, styleBytes);
            }
        }
        this.curMbgViewManager = this.getFormFacade().loadViewManager(((BgFormInfo)this.getEditValue()).getId().toString(), this.getOrgViewId(), (IMbgViewManager)this.curMbgViewManager, this.getOrgPermission(), this.getInitOrgId(), this.isCurrOrg(), this.isOnlyLeaf());
        this.getCheckFactory().getCacheHelper().initCache((IMbgViewManager)this.curMbgViewManager);
    }

    protected IMBGFormFacade getFormFacade() throws BOSException {
        if (this.getCtx() == null) {
            return MBGFormFacadeFactory.getRemoteInstance();
        }
        return MBGFormFacadeFactory.getLocalInstance(this.getCtx());
    }

    @Override
    public BgScenarioType getEditScenType() {
        return BgScenarioType.BudgetData;
    }

    @Override
    protected String getVersionNumber() {
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getBgVersion() != null) {
            return this.getBgFormInfo().getBgVersion().getNumber();
        }
        return null;
    }

    protected boolean isOnlyLeaf() {
        return false;
    }

    protected String getInitOrgId() {
        return this.getBgFormInfo().getOrgUnit().getId().toString();
    }

    protected boolean isCurrOrg() {
        return false;
    }

    public Book loadBook() throws Exception {
        return this.getBookParseHelper().getBook(this.getOwner(), this, this.getCheckFactory(), this.getOrgPermission());
    }

    @Override
    protected int getDataType() {
        return 1;
    }

    @Override
    protected void addBgViewManagerForMultiOrg(Set<String> orgNums) throws Exception {
        Map res;
        HashSet<String> notExitOrgNum = new HashSet<String>();
        if (orgNums != null && !orgNums.isEmpty()) {
            String orgNum2 = null;
            for (String orgNum2 : orgNums) {
                if (this.getBgViewManagerForMulOrg().containsKey(orgNum2)) continue;
                notExitOrgNum.add(orgNum2);
            }
        }
        if (notExitOrgNum.size() > 0 && (res = this.getFormFacade().getBgViewManagers(((BgFormInfo)this.getEditValue()).getId().toString(), this.getOrgViewId(), notExitOrgNum, this.getOrgPermission(), this.getInitOrgId(), this.isOnlyLeaf())) != null && !res.isEmpty()) {
            for (String key : res.keySet()) {
                if (!(key instanceof FullOrgUnitInfo) || !(res.get(key) instanceof IMbgViewManager)) continue;
                this.addOtherOrgViewData((FullOrgUnitInfo)key, (IMbgViewManager)res.get(key));
            }
        }
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        return (BgFormInfo)this.getEditValue();
    }

    @Override
    protected boolean isCanEditBgData(Cell cell, String formula, BgNViewDataInfo bgData, IMbgViewManager view, DimensionMemberCheckHelper helper, int sheetIndex, String version) throws EASBizException, BOSException {
        if (version == null || view == null || helper == null || this.getBgFormInfo() == null || this.getBgFormInfo().getBgVersion() == null || !version.equals(this.getBgFormInfo().getBgVersion().getNumber())) {
            return false;
        }
        boolean check = helper.canSave(formula, helper.getEditScen(view, sheetIndex, this.getEditScenType()), version);
        String orgUnitId = null;
        if (cell != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            orgUnitId = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
        }
        return check && this.isCanEditByState(bgData) && this.isCanEditByFormState(orgUnitId);
    }

    protected boolean isCanEditByFormState(String orgId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return true;
        }
        return this.orgIdFormState.get(orgId) == null || BgFormStateEnum.Edited.equals((Object)this.orgIdFormState.get(orgId)) || BgFormStateEnum.Back.equals((Object)this.orgIdFormState.get(orgId));
    }

    protected boolean isCanEditByState(BgNViewDataInfo bgData) {
        boolean isInWfEdit = false;
        boolean isViewEdit = true;
        Object obj = this.getOwner().getUIContext().get("Owner");
        if (OprtState.EDIT.equals(this.getOwner().getOprtState()) && obj != null && (obj instanceof MessageCenterUI || obj instanceof MultiApproveUI)) {
            isInWfEdit = true;
        }
        if (OprtState.VIEW.equals(this.getOwner().getOprtState())) {
            isViewEdit = false;
        }
        if (bgData != null && 3 == bgData.getState() && this.getBgFormInfo() != null && (this.getBgFormInfo().getState().equals((Object)BgFormStateEnum.REFERRING) || this.getBgFormInfo().getState().equals((Object)BgFormStateEnum.Approving)) && !this.checkInProInst()) {
            return true;
        }
        return (bgData == null || 1 == bgData.getState() || 0 == bgData.getState() || isInWfEdit && 3 == bgData.getState()) && isViewEdit;
    }

    protected boolean checkInProInst() {
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getId() != null && this.isInPorInst == null) {
            try {
                this.isInPorInst = BgFormHelper.checkInProInst(this.getBgFormInfo().getId().toString());
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
        }
        if (this.isInPorInst != null) {
            return (Boolean)this.isInPorInst;
        }
        return false;
    }

    protected void reSetValue(Cell cell) {
        BgNFSHelper.setValue(cell, null);
    }

    @Override
    protected void storeDataValue(BigDecimal value, BgNViewDataInfo data) {
        if (data != null) {
            data.setBudgetValue(value);
        }
    }

    @Override
    protected boolean isModify(BgNViewDataInfo data) {
        if (data != null) {
            if (data.getBudgetValueNoDef() == null) {
                return data.getOldValue() != null;
            }
            if (data.getOldValue() == null) {
                return data.getBudgetValueNoDef() != null;
            }
            return data.getOldValue().compareTo(data.getBudgetValueNoDef()) != 0;
        }
        return false;
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        if (this.getCtx() == null) {
            return BgFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getLocalInstance(this.getCtx());
    }

    @Override
    public MbgBookParseHelper getBookParseHelper() {
        MbgBookParseHelper bookParseHelper = super.getBookParseHelper();
        bookParseHelper.setViewF7Enable(false);
        bookParseHelper.setPageF7Enable(true);
        bookParseHelper.setReadonly(this.getBgFormInfo().getBgTemplate().isReadonly());
        try {
            bookParseHelper.setSchemeHelper(this.getSchemeHelper());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return bookParseHelper;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        return sic;
    }

    @Override
    protected DimensionMemberCheckFactory createCheckFactory() {
        BgFormInfo bgForm = (BgFormInfo)this.getEditValue();
        DimensionMemberCheckFactory checkFactory = null;
        try {
            checkFactory = new DimensionMemberCheckFactory(this.getCtx(), bgForm.getBgTemplate().getId().toString(), this.getSchemeHelper(), bgForm.isDecompose());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return checkFactory;
    }

    @Override
    public void refreshSheet(Book book, Sheet sheet) throws Exception {
        super.refreshSheet(book, sheet);
        this.showAdjust(book);
    }

    @Override
    public void fillData(Book book) throws Exception {
        super.fillData(book);
        this.showAdjust(book);
    }

    @Override
    public void fillData(Book book, boolean isSynch) throws Exception {
        super.fillData(book, isSynch);
        this.showAdjust(book);
    }

    private void showAdjust(Book book) {
        try {
            if (!(this.getOwner() instanceof MBGFormProcessUI)) {
                return;
            }
            MBGFormProcessUI ui = (MBGFormProcessUI)this.getOwner();
            Map adjustMap = null;
            if (ui.getContextManager().getProvider() instanceof BgViewAdjustProvider) {
                adjustMap = ((BgViewAdjustProvider)ui.getContextManager().getProvider()).getAdjustMap();
            }
            ActionShowAdjust.showAdjust(book, this.getOrgUnitId(), this.getBgFormInfo().getBgScheme().getId().toString(), !ActionShowAdjust.isShowAdjust(ui.getShowAdjustMenuItem()), adjustMap, this.getBgFormInfo().getBgVersion().getNumber(), this.getBgFormInfo().getProcessType());
        }
        catch (NoClassDefFoundError e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void updateBackState(Book book) throws EASBizException, BOSException {
        HashSet<String> orgNumbers = new HashSet<String>();
        this.getOrgNumsForCurBook(book, orgNumbers);
        if (!orgNumbers.isEmpty()) {
            this.getFormFacade().updateBackState(((BgFormInfo)this.getEditValue()).getId().toString(), orgNumbers);
        }
    }

    @Override
    protected IObjectValue getQueryDataInfo() {
        return this.getBgFormInfo();
    }
}

