/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.viewListForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IBgAdjustFacada;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.IAdjust;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgAdjustHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBGViewListFormAdjustProvider
extends MBGViewListFormProvider
implements IAdjust {
    private static final Logger logger = Logger.getLogger((String)MBGViewListFormAdjustProvider.class.getName());
    public static final Color ADJUST_COLOR = Color.YELLOW;
    public static final Color NORMAL_COLOR = Color.WHITE;
    private boolean isActionAdjust = false;
    private boolean isAdjustSave = true;
    private Map adjustMap = new HashMap();
    private MbgAdjustHelper adjustHelper = null;
    private boolean isCheckTmpData = false;

    public boolean isActionAdjust() {
        return this.isActionAdjust;
    }

    public void setActionAdjust(boolean isActionAdjust) {
        this.isActionAdjust = isActionAdjust;
    }

    @Override
    public boolean isFixel() {
        return false;
    }

    @Override
    public String getBgVersion() {
        return this.getBgFormInfo().getBgVersion().getNumber();
    }

    public boolean isCheckTmpData() {
        return this.isCheckTmpData;
    }

    public void setCheckTmpData(boolean isCheckTmpData) {
        this.isCheckTmpData = isCheckTmpData;
    }

    public synchronized MbgAdjustHelper getAdjustHelper() {
        if (this.adjustHelper == null) {
            this.adjustHelper = new MbgAdjustHelper(this);
        }
        return this.adjustHelper;
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        return super.getBgFormInfo();
    }

    @Override
    public ViewListBookParseHelper getBookParseHelper() {
        ViewListBookParseHelper bookParseHelper = super.getBookParseHelper();
        bookParseHelper.setViewF7Enable(false);
        bookParseHelper.setPageF7Enable(true);
        bookParseHelper.setOrgF7Enable(false);
        return bookParseHelper;
    }

    public void reFillAdustDataToBook(Book book) throws Exception {
        if (this.adjustMap.isEmpty()) {
            return;
        }
        Map dataMap = (Map)this.adjustMap.get(this.getOrgUnitId());
        String version = null;
        String cellOrgId = null;
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            for (int rowIndex = 0; rowIndex <= book.getSheet(sheetIndex).getMaxRowIndex(); ++rowIndex) {
                Row row = book.getSheet(sheetIndex).getRow(rowIndex, false);
                if (row == null) continue;
                for (int colIndex = 0; colIndex <= book.getSheet(sheetIndex).getMaxColIndex(); ++colIndex) {
                    Cell cell = book.getSheet(sheetIndex).getCell(rowIndex, colIndex, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula(cell);
                    if (formula == null) continue;
                    version = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    if (!this.getOrgUnitId().equals(cellOrgId) || !this.getVersionNumber().equals(version) || !dataMap.containsKey(formula.getFormula())) continue;
                    BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)dataMap.get(formula.getFormula());
                    BgNFSHelper.setValue(cell, data.getNewValue());
                    BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
                }
            }
        }
    }

    @Override
    protected void getOrgIdFormStateMap() throws EASBizException, BOSException {
        Map orgIdFormIdMap;
        Set<String> orgIdSetByCurManager = this.getOrgIdSetByCurManager();
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null && bgFormInfo.getId() != null && orgIdSetByCurManager != null && !orgIdSetByCurManager.isEmpty() && (orgIdFormIdMap = BgAdjustFacadaFactory.getRemoteInstance().getOrgIdFormIdMap(bgFormInfo.getId().toString(), orgIdSetByCurManager)) != null && !orgIdFormIdMap.isEmpty()) {
            this.orgIdFormState = orgIdFormIdMap;
        }
    }

    @Override
    protected void startQueryData(Map<String, List<IBgDimensionManagerBase>> initDimensionManagers) throws BOSException, EASBizException {
        this.getQueryDataHelper().startQueryData(this.getQueryDataInfo(), initDimensionManagers, this.getDataType(), this.getBgOrgViewId(), this.isActionAdjust || this.isCheckTmpData());
    }

    @Override
    public void getInitOrgNums(Set<String> orgNums, int sheetIndex) {
        MbgViewListDimensionManager dimManager = ((MbgViewListSheetManager)((MbgViewListManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex)).getDimensionManager();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(dimManager);
        if (isorgOnPageOrView) {
            orgNums.add(this.getOrgUnitInfo().getNumber());
        } else {
            int i;
            ArrayList<MbgViewListDimensionInfo> dimens = new ArrayList<MbgViewListDimensionInfo>();
            List<IMbgViewListObject> rowCols = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimens.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            for (i = 0; i < dimens.size(); ++i) {
                if (!(dimens.get(i) instanceof BgDimensionBaseInfo) || !((BgDimensionBaseInfo)dimens.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                for (int m = 0; m < ((BgDimensionBaseInfo)dimens.get(i)).getMember().size(); ++m) {
                    orgNums.add(((BgDimensionMember)((BgDimensionBaseInfo)dimens.get(i)).getMember().get(m)).getNumber());
                }
            }
        }
    }

    @Override
    public void fillData(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> tmpData) throws Exception {
        super.fillData(sheet, tmpData);
        this.fillAdjustData(sheet.getBook(), sheet.getSheetIndex());
    }

    @Override
    public void refreshSheet(Book book, Sheet sheet, boolean isLoadMultiFormulas) throws Exception {
        super.refreshSheet(book, sheet, isLoadMultiFormulas);
        this.showRollOrgLock(book);
    }

    @Override
    public void fillData(Book book) throws Exception {
        super.fillData(book);
        this.fillAdjustData(book, -1);
    }

    protected void fillAdjustData(Book book, int sheetIndex) throws BOSException, EASBizException {
        Set<String> orgIdSet = this.getOrgIdSetByCurManager();
        IBgAdjustFacada iBgAdjustFacada = null;
        iBgAdjustFacada = this.getCtx() == null ? BgAdjustFacadaFactory.getRemoteInstance() : BgAdjustFacadaFactory.getLocalInstance(this.getCtx());
        Map adjustData = iBgAdjustFacada.getAdjustData(this.getBgFormInfo().getAdjust().getId().toString(), orgIdSet);
        this.getAdjustMap().clear();
        this.getAdjustHelper().loadAdjustMapForMultiOrg(adjustData, this.getAdjustMap(), orgIdSet);
        Map<String, Set<String>> formulasAdjust = MBGViewListFormClientHelper.checkFormualHasAdjust(this.getBgFormInfo(), book);
        BgSheetRange editRange = null;
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        String dimKey = null;
        ItemFormula itemFormula = null;
        String bgFormVersionNumber = this.getBgFormInfo().getBgVersion().getNumber();
        int max = sheetIndex;
        if (sheetIndex < 0) {
            sheetIndex = 0;
            max = book.getSheetCount() - 1;
        }
        BgSheetRange lockRange = null;
        while (sheetIndex <= max) {
            lockRange = new BgSheetRange(book.getSheet(sheetIndex));
            editRange = new BgSheetRange(book.getSheet(sheetIndex));
            for (int rowIndex = 0; rowIndex <= book.getSheet(sheetIndex).getMaxRowIndex(); ++rowIndex) {
                Row row = book.getSheet(sheetIndex).getRow(rowIndex, false);
                if (row == null) continue;
                for (int colIndex = 0; colIndex <= book.getSheet(sheetIndex).getMaxColIndex(); ++colIndex) {
                    Cell cell = book.getSheet(sheetIndex).getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        itemFormula = BgNFSHelper.getItemFormula(cell);
                        String formula = BgNFSHelper.getFormulaOfCell(cell);
                        dimKey = DimUtils.getDimDataKey(formula, bgFormVersionNumber);
                        String orgid = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
                        if (!bgFormVersionNumber.equals(BgNFSHelper.getItemFormula(cell).getExt("Version"))) continue;
                        helper = factory.getHelper(orgid, (IMbgViewBase)this.getBgViewManagerForMulOrg().get(itemFormula.getExt("ORGUNIT")));
                        if (!StringUtils.isEmpty((String)orgid)) {
                            if (adjustData.containsKey(orgid)) {
                                BgNDataInfo dataInfo;
                                if (((Map)adjustData.get(orgid)).containsKey(formula)) {
                                    dataInfo = (BgNDataInfo)((Map)adjustData.get(orgid)).get(formula);
                                    if (dataInfo.getBgScenario() == null) {
                                        dataInfo.splitFormula();
                                    }
                                    if (helper.isActualScen(dataInfo.getBgScenario())) continue;
                                    BigDecimal oldValue = dataInfo.getBudgetValueNoDef() instanceof BigDecimal ? dataInfo.getBudgetValueNoDef() : (BgNFSHelper.getValue(cell) instanceof BigDecimal ? (BigDecimal)BgNFSHelper.getValue(cell) : null);
                                    if (this.getBgDataMap().containsKey(orgid) && this.getBgDataMap().get(orgid).containsKey(dimKey)) {
                                        BgNDataInfo _dataInfo = this.getBgDataMap().get(orgid).get(dimKey);
                                        dataInfo.setAdjustValue(_dataInfo.getBudgetValueNoDef());
                                    }
                                    BigDecimal newValue = dataInfo.getAdjustValue();
                                    if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                                        this.updateDivInfo(cell, formula, newValue, oldValue);
                                    } else {
                                        this.createDivInfo(cell, formula, newValue, oldValue);
                                    }
                                    if (oldValue == null || newValue != null && newValue.compareTo(oldValue) != 0) {
                                        this.setCellAdjustValue(cell, formula, newValue);
                                    } else if (newValue != null && BgNFSHelper.getValue(cell) instanceof BigDecimal && newValue.compareTo((BigDecimal)BgNFSHelper.getValue(cell)) != 0) {
                                        this.setCellAdjustValue(cell, formula, newValue);
                                    }
                                } else if (this.getBgDataMap().containsKey(orgid) && this.getBgDataMap().get(orgid).containsKey(dimKey)) {
                                    dataInfo = this.getBgDataMap().get(orgid).get(dimKey);
                                    if (dataInfo.getBgScenario() == null) {
                                        dataInfo.splitFormula();
                                    }
                                    if (dataInfo != null) {
                                        if (helper.isActualScen(dataInfo.getBgScenario())) continue;
                                        if (dataInfo.getState() != 0 || this.getOwner() != null && !OprtState.VIEW.equals(this.getOwner().getOprtState()) || BgFormStateEnum.Adjusted.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.AdjustApproving.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollEdited.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollApproving.equals((Object)this.getBgFormInfo().getState())) {
                                            if (helper.canSave(formula, helper.getEditScen((IMbgViewBase)this.getBgViewManagerForMulOrg().get(itemFormula.getExt("ORGUNIT")), sheetIndex, this.getEditScenType()), bgFormVersionNumber)) {
                                                if (dataInfo.getOldValue() == null && dataInfo.getBudgetValueNoDef() != null || !MbgAdjustHelper.compareDivValue(dataInfo.getOldValue(), dataInfo.getBudgetValue())) {
                                                    if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                                                        this.updateDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                                                    } else {
                                                        this.createDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                                                    }
                                                    this.setCellAdjustValue(cell, formula, dataInfo.getBudgetValue());
                                                }
                                            } else if (formulasAdjust.containsKey(orgid) && formulasAdjust.get(orgid).contains(formula)) {
                                                editRange.addCell(cell.getRow(), cell.getCol());
                                            }
                                        } else {
                                            this.setNormalBackGroup(cell);
                                        }
                                    }
                                } else {
                                    this.setNormalBackGroup(cell);
                                }
                            } else if (formulasAdjust.containsKey(orgid) && this.getOwner() != null && (!this.getOwner().getOprtState().equals(OprtState.VIEW) || this.getOwner().getOprtState().equals(OprtState.VIEW) && (BgFormStateEnum.Adjusted.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.AdjustApproving.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollEdited.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollApproving.equals((Object)this.getBgFormInfo().getState()))) && formulasAdjust.get(orgid).contains(formula)) {
                                editRange.addCell(cell.getRow(), cell.getCol());
                                BgNFSHelper.setAdjustBeforeColor(cell, BgNConstants.EDIT_COLOR);
                            }
                        }
                    }
                    if (((MbgViewListSheetManager)this.getCurMbgSheetManager()).isCanEditOtherAddedBgForm().booleanValue()) continue;
                    String currentOrgNum = this.getBgFormInfo().getOrgUnit().getNumber();
                    String orgNumber = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || StringUtils.isEmpty((String)(orgNumber = (itemFormula = BgNFSHelper.getItemFormula(cell)).getExt("ORGUNIT"))) || orgNumber.equals(currentOrgNum)) continue;
                    lockRange.addCell(cell.getRow(), cell.getCol());
                }
            }
            if (lockRange != null && lockRange.getRange() != null && !lockRange.getRange().isEmpty()) {
                BgViewHelper.setLockedAndBackgroud(true, lockRange.getRange());
            }
            if (editRange != null && editRange.getRange() != null && !editRange.getRange().isEmpty()) {
                StyleAttributes edit = Styles.getEmptySA();
                edit.setBackground(BgNConstants.EDIT_COLOR);
                Range rg = editRange.getRange();
                if (rg != null) {
                    rg.setIgnoreProtected(true);
                    rg.setStyle(edit, Styles.getEmptySA());
                }
            }
            ++sheetIndex;
        }
        this.setAdjustSave(true);
        this.checkTmpData();
    }

    private void checkTmpData() throws BOSException, EASBizException {
        if (!this.isCheckTmpData()) {
            return;
        }
        IBgAdjustFacada iBgAdjustFacade = null;
        iBgAdjustFacade = this.getCtx() == null ? BgAdjustFacadaFactory.getRemoteInstance() : BgAdjustFacadaFactory.getLocalInstance(this.getCtx());
        iBgAdjustFacade.checkTmpDataForView(this.getEditValue(), this.getAdjustMap());
    }

    protected void setNormalBackGroup(Cell cell) {
        if (cell != null && !cell.getSheet().getRange(cell).isCellLocked()) {
            BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
        }
    }

    public void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        this.getAdjustHelper().updateDivInfo(cell, formulaStr, newValue, oldValue);
    }

    public void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        this.getAdjustHelper().createDivInfo(cell, formulaStr, newValue, oldValue);
    }

    public void setCellAdjustValue(Cell cell, String formula, BigDecimal value) {
        BgNFSHelper.setValue(cell, value);
    }

    public IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }

    @Override
    protected BgNViewDataInfo getData(Map bgDataMap, String orgId, String formula, String versionNumber, boolean isCreate) {
        if (isCreate) {
            BgNViewDataInfo data = super.getData(bgDataMap, orgId, formula, versionNumber, false);
            if (data == null) {
                data = super.getData(bgDataMap, orgId, formula, versionNumber, isCreate);
                data.setOldValue(null);
                data.setState(5);
            }
            if (!StringUtils.isEmpty((String)orgId) && StringUtils.isEmpty((String)data.getOrgUnitId())) {
                data.setOrgUnitId(orgId);
            }
            return data;
        }
        return super.getData(bgDataMap, orgId, formula, versionNumber, isCreate);
    }

    @Override
    public boolean isCanEditBgData(Cell cell, String formula, BgNViewDataInfo bgData, String orgUnitId, IMbgViewBase view, int sheetIndex, String version) throws EASBizException, BOSException {
        return this.isCanEditBgData(formula, bgData, orgUnitId, view, sheetIndex, version);
    }

    protected boolean isCanEditBgData(String formula, BgNViewDataInfo bgData, String orgUnitId, IMbgViewBase view, int sheetIndex, String version) throws EASBizException, BOSException {
        if (version == null || this.getBgFormInfo() == null || this.getBgFormInfo().getBgVersion() == null || !version.equals(this.getBgFormInfo().getBgVersion().getNumber())) {
            return false;
        }
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = factory.getHelper(orgUnitId, view);
        return helper.canSave(formula, helper.getEditScen((MbgViewListManager)view, sheetIndex, this.getEditScenType()), version) && this.isCanEditByState(bgData) && this.isCanEditByFormState(orgUnitId);
    }

    public boolean isCanEditByState(BgNViewDataInfo bgData) {
        return bgData == null || 5 == bgData.getState() || 9 == bgData.getState() || 0 == bgData.getState();
    }

    @Override
    public boolean isCanEditByFormState(String orgId) {
        if (orgId == null) {
            return true;
        }
        if ((BgFormStateEnum.AdjustApproving.equals(this.orgIdFormState.get(orgId)) || BgFormStateEnum.REFERRING.equals(this.orgIdFormState.get(orgId))) && !this.checkInProInst(orgId)) {
            return true;
        }
        return BgFormStateEnum.Approved.equals(this.orgIdFormState.get(orgId)) || BgFormStateEnum.Adjusted.equals(this.orgIdFormState.get(orgId));
    }

    @Override
    protected void storeDataValue(BigDecimal value, BgNViewDataInfo data) {
        super.storeDataValue(value, data);
        if (data.getOldValue() != null && value != null && data.getOldValue().compareTo(value) != 0 || data.getOldValue() != value) {
            data.setAdjustValue(value);
            if (!this.getAdjustMap().isEmpty() && !StringUtils.isEmpty((String)data.getOrgUnitId()) && this.getAdjustMap().containsKey(data.getOrgUnitId()) && this.getAdjustMap().get(data.getOrgUnitId()) != null && ((Map)this.getAdjustMap().get(data.getOrgUnitId())).get(data.getFormula()) instanceof BgAdjustFormDiversityData) {
                ((BgAdjustFormDiversityData)((Map)this.getAdjustMap().get(data.getOrgUnitId())).get(data.getFormula())).setNewValue(value);
            }
        }
    }

    @Override
    protected void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue) {
        super.setDataValueToCell(cell, dataValue);
    }

    @Override
    protected boolean isModify(BgNViewDataInfo data) {
        boolean modify = super.isModify(data);
        return this.isAdjustSave ? false : modify;
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return super.getBizInterface();
    }

    @Override
    public Map getAdjustMap() {
        return this.adjustMap;
    }

    public boolean isAdjustSave() {
        return this.isAdjustSave;
    }

    @Override
    public void setAdjustSave(boolean isAdjustSave) {
        this.isAdjustSave = isAdjustSave;
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        if (this.getCurMbgViewManager() != null) {
            MBGViewListFormCommonHelper.initCanEditOtherBgForm(this.getCtx(), (MbgViewListManager)this.getCurMbgViewManager());
            boolean isRowColShowbyTemp = false;
            MbgViewListSheetManager sheetManger = null;
            Boolean isOrgOnRow = false;
            Map<String, List<IMbgViewListObject>> viewListObjectsByOrg = null;
            Map<String, String> orgIdAndNumMap = null;
            for (int sheetIndex = 0; sheetIndex < ((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
                sheetManger = (MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex);
                isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(sheetManger.getDimensionManager());
                isRowColShowbyTemp = sheetManger.isRowColShowbyTemp();
                List<IMbgViewListObject> columns = sheetManger.getDimensionManager().getColumns();
                List<IMbgViewListObject> rows = sheetManger.getDimensionManager().getRows();
                List pageDimension = sheetManger.getDimensionManager().getPageDimension();
                int colOrRowOrPageFlag = this.judgeColOrRowOrPage(sheetIndex);
                HashSet<String> orgIdSet = new HashSet<String>();
                orgIdAndNumMap = this.getOrgIdAndNumMap(sheetManger.getDimensionManager().getAllDimensions());
                orgIdSet.addAll(orgIdAndNumMap.keySet());
                if (!isRowColShowbyTemp) {
                    viewListObjectsByOrg = MBGViewListFormCommonHelper.getViewListObjectsByOrg(sheetManger.getDimensionManager(), isOrgOnRow);
                }
                if (columns == null || rows == null || pageDimension == null) {
                    return;
                }
                this.filterOrgByPermission(isRowColShowbyTemp, sheetManger, isOrgOnRow, viewListObjectsByOrg, orgIdAndNumMap, columns, rows, pageDimension, colOrRowOrPageFlag, orgIdSet);
                this.filterOrgByRolled(isRowColShowbyTemp, sheetManger, isOrgOnRow, viewListObjectsByOrg, orgIdAndNumMap, columns, rows, pageDimension, colOrRowOrPageFlag, orgIdSet);
            }
        }
    }

    @Override
    protected Map loadMbgViewManagers(Set<String> notExitOrgNum) throws EASBizException, BOSException {
        long st = System.currentTimeMillis();
        Map map = null;
        if (!this.isCurrOrg()) {
            logger.error((Object)"start loadMbgViewManagers ");
            map = this.getMbgViewListFacade().getViewListManagers(((BgFormInfo)this.getEditValue()).getId().toString(), this.getOrgViewId(), notExitOrgNum, this.getOrgPermission(), this.getInitOrgId(), this.isCurrOrg());
            logger.error((Object)("end loadMbgViewManagers " + (System.currentTimeMillis() - st) + " ms."));
        }
        return map;
    }

    protected void filterOrgByPermission(boolean isRowColShowbyTemp, MbgViewListSheetManager sheetManger, Boolean isOrgOnRow, Map<String, List<IMbgViewListObject>> viewListObjectsByOrg, Map<String, String> orgIdAndNumMap, List<IMbgViewListObject> columns, List<IMbgViewListObject> rows, List pageDimension, int colOrRowOrPageFlag, Set<String> orgIdSet) throws BOSException, EASBizException {
        Set hasPermissionOrgIdSet = null;
        Set<String> hasPermissionOrgNumSet = null;
        if (!orgIdSet.isEmpty()) {
            IObjectPK[] pkArray = new IObjectPK[orgIdSet.size()];
            int ItemNumber = 0;
            Iterator<String> iterator = orgIdSet.iterator();
            while (iterator.hasNext()) {
                pkArray[ItemNumber++] = new ObjectUuidPK(iterator.next().toString());
            }
            IPermission iPermission = null;
            iPermission = this.getCtx() == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)this.getCtx());
            hasPermissionOrgIdSet = iPermission.checkBatchPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), pkArray, this.getAdjustPermissionNumber());
            hasPermissionOrgNumSet = this.dealPerssionByOrg(hasPermissionOrgIdSet, orgIdAndNumMap);
            if (hasPermissionOrgIdSet != null && orgIdSet.size() != hasPermissionOrgIdSet.size()) {
                if (2 == colOrRowOrPageFlag) {
                    this.deleteNoPermissionOrgOnPage(pageDimension, hasPermissionOrgIdSet);
                } else if (3 == colOrRowOrPageFlag) {
                    this.deleteNoPermissionOrgOnRowOrCol(sheetManger, rows, hasPermissionOrgIdSet, isRowColShowbyTemp, hasPermissionOrgNumSet, viewListObjectsByOrg, isOrgOnRow);
                } else if (4 == colOrRowOrPageFlag) {
                    this.deleteNoPermissionOrgOnRowOrCol(sheetManger, columns, hasPermissionOrgIdSet, isRowColShowbyTemp, hasPermissionOrgNumSet, viewListObjectsByOrg, isOrgOnRow);
                }
            }
        }
    }

    private void filterOrgByRolled(boolean isRowColShowbyTemp, MbgViewListSheetManager sheetManger, Boolean isOrgOnRow, Map<String, List<IMbgViewListObject>> viewListObjectsByOrg, Map<String, String> orgIdAndNumMap, List<IMbgViewListObject> columns, List<IMbgViewListObject> rows, List pageDimension, int colOrRowOrPageFlag, Set<String> orgIdSet) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo.getState().getValue() == 6 || bgFormInfo.getState().getValue() == 12 || bgFormInfo.getState().getValue() == 2) {
            return;
        }
        if (bgFormInfo.getBgVersion() != null && bgFormInfo.getBgVersion().isIsRollVersion()) {
            return;
        }
        Set<String> orgNums = MBGViewListFormCommonHelper.getOrgNumsOfSheet(sheetManger);
        HashSet<String> normalNumber = new HashSet<String>();
        HashSet<String> normalOrgId = new HashSet<String>();
        HashSet<String> rolledNumberSet = new HashSet<String>();
        HashSet<String> rolledOrgId = new HashSet<String>();
        BgFormCollection rollFormInfos = this.getRollFormInfos(orgNums, bgFormInfo);
        for (int i = 0; i < rollFormInfos.size(); ++i) {
            BgFormInfo temp = rollFormInfos.get(i);
            normalNumber.add(temp.getOrgUnit().getNumber());
            normalOrgId.add(temp.getOrgUnit().getId().toString());
            if (!temp.isIsRolled()) continue;
            rolledNumberSet.add(temp.getOrgUnit().getNumber());
            rolledOrgId.add(temp.getOrgUnit().getId().toString());
        }
        normalNumber.removeAll(rolledNumberSet);
        normalOrgId.removeAll(rolledOrgId);
        if (orgNums.size() != normalNumber.size()) {
            if (2 == colOrRowOrPageFlag) {
                this.deleteNoPermissionOrgOnPage(pageDimension, normalOrgId);
            } else if (3 == colOrRowOrPageFlag) {
                this.deleteNoPermissionOrgOnRowOrCol(sheetManger, rows, normalOrgId, isRowColShowbyTemp, normalNumber, viewListObjectsByOrg, isOrgOnRow);
            } else if (4 == colOrRowOrPageFlag) {
                this.deleteNoPermissionOrgOnRowOrCol(sheetManger, columns, normalOrgId, isRowColShowbyTemp, normalNumber, viewListObjectsByOrg, isOrgOnRow);
            }
        }
    }

    private Set<String> dealPerssionByOrg(Set hasPermissionOrgIdSet, Map<String, String> orgIdAndNumMap) {
        String orgId2 = null;
        HashSet<String> hasPermissionOrgNumSet = new HashSet<String>();
        if (hasPermissionOrgIdSet == null || orgIdAndNumMap == null || orgIdAndNumMap.isEmpty() || hasPermissionOrgIdSet.isEmpty()) {
            return hasPermissionOrgNumSet;
        }
        for (String orgId2 : orgIdAndNumMap.keySet()) {
            if (!hasPermissionOrgIdSet.contains(orgId2)) continue;
            hasPermissionOrgNumSet.add(orgIdAndNumMap.get(orgId2));
        }
        return hasPermissionOrgNumSet;
    }

    private void deleteNoPermissionOrgOnPage(List pageDimension, Set hasPermissionOrgIdSet) {
        List members = null;
        String orgId = null;
        for (int i = 0; i < pageDimension.size(); ++i) {
            if (pageDimension.get(i) == null || !(pageDimension.get(i) instanceof MbgViewListDimensionInfo) || !MBGLayoutConstants.BG_ORGANIZATION.equals(((MbgViewListDimensionInfo)pageDimension.get(i)).getNumber())) continue;
            members = ((MbgViewListDimensionInfo)pageDimension.get(i)).getMember();
            for (int j = 0; j < members.size(); ++j) {
                if (members.get(j) == null || !(members.get(j) instanceof MbgViewListDimensionMember) || StringUtils.isEmpty((String)(orgId = ((MbgViewListDimensionMember)members.get(j)).getAttribute())) || hasPermissionOrgIdSet.contains(orgId)) continue;
                members.remove(j);
                --j;
            }
            break;
        }
    }

    private void dealOrgSetOnPage(List pageDimension, Set<String> orgIdSet) {
        List members = null;
        String orgId = null;
        for (int i = 0; i < pageDimension.size(); ++i) {
            if (pageDimension.get(i) == null || !(pageDimension.get(i) instanceof MbgViewListDimensionInfo) || !MBGLayoutConstants.BG_ORGANIZATION.equals(((MbgViewListDimensionInfo)pageDimension.get(i)).getNumber())) continue;
            members = ((MbgViewListDimensionInfo)pageDimension.get(i)).getMember();
            for (int j = 0; j < members.size(); ++j) {
                if (members.get(j) == null || !(members.get(j) instanceof MbgViewListDimensionMember) || StringUtils.isEmpty((String)(orgId = ((MbgViewListDimensionMember)members.get(j)).getAttribute()))) continue;
                orgIdSet.add(orgId);
            }
            break;
        }
    }

    private void deleteNoPermissionOrgOnRowOrCol(MbgViewListSheetManager sheetManger, List<IMbgViewListObject> rowsOrCols, Set hasPermissionOrgIdSet, boolean isRowColShowbyTemp, Set<String> hasPermissionOrgNumSet, Map<String, List<IMbgViewListObject>> viewListObjectsByOrg, Boolean isOrgOnRow) {
        if (isRowColShowbyTemp) {
            this.removeByTemp(rowsOrCols, hasPermissionOrgIdSet);
        } else {
            this.removeByOrg(sheetManger, hasPermissionOrgNumSet, viewListObjectsByOrg, isOrgOnRow);
        }
    }

    private void removeByOrg(MbgViewListSheetManager sheetManger, Set<String> hasPermissionOrgNumSet, Map<String, List<IMbgViewListObject>> viewListObjectsByOrg, Boolean isOrgOnRow) {
        ArrayList addRowCols = new ArrayList();
        String orgNum2 = null;
        for (String orgNum2 : hasPermissionOrgNumSet) {
            if (!viewListObjectsByOrg.containsKey(orgNum2)) continue;
            addRowCols.addAll(viewListObjectsByOrg.get(orgNum2));
        }
        if (isOrgOnRow.booleanValue()) {
            sheetManger.getDimensionManager().getRows().clear();
            sheetManger.getDimensionManager().getRows().addAll(addRowCols);
        } else {
            sheetManger.getDimensionManager().getColumns().clear();
            sheetManger.getDimensionManager().getColumns().addAll(addRowCols);
        }
    }

    private void removeByTemp(List<IMbgViewListObject> rowsOrCols, Set hasPermissionOrgIdSet) {
        for (int i = 0; i < rowsOrCols.size(); ++i) {
            if (rowsOrCols.get(i) == null || !(rowsOrCols.get(i) instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> dimensions = ((MbgViewListRowCol)rowsOrCols.get(i)).getDimensions();
            for (int j = 0; j < dimensions.size(); ++j) {
                List members;
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(j).getNumber()) || (members = dimensions.get(j).getMember()) == null || members.isEmpty()) continue;
                for (int k = 0; k < members.size(); ++k) {
                    String orgId;
                    if (members.get(k) == null || !(members.get(k) instanceof MbgViewListDimensionMember) || StringUtils.isEmpty((String)(orgId = ((MbgViewListDimensionMember)members.get(k)).getAttribute())) || hasPermissionOrgIdSet.contains(orgId)) continue;
                    rowsOrCols.remove(i);
                    --i;
                }
            }
        }
    }

    protected String getAdjustPermissionNumber() {
        String className = this.getOwner().getClass().getName();
        if (this.isExpAdjustProcessUI(className)) {
            return "exp_viewAdjust04_view";
        }
        if (this.isFmAdjustProcessUI(className)) {
            return "fm_viewAdjust04_view";
        }
        return "mbg_viewAdjust04_view";
    }

    private boolean isExpAdjustProcessUI(String className) {
        return "com.kingdee.eas.ma.exp.client.BgExpViewFormAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpViewListFormAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpFormSpecialAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpDecomposeViewAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpDecomposeViewListAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpDecomposeSpecialAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.exp.client.BgExpDecomposeAdjustProcessUI".equals(className);
    }

    private boolean isFmAdjustProcessUI(String className) {
        return "com.kingdee.eas.ma.fm.client.BgFmViewFormAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmViewListFormAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmFormSpecialAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmDecomposeViewAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmDecomposeViewListAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmDecomposeSpecialAdjustProcessUI".equals(className) || "com.kingdee.eas.ma.fm.client.BgFmDecomposeAdjustProcessUI".equals(className);
    }

    private void dealOrgIdSetOnRowOrCol(List<IMbgViewListObject> columnsOrRows, Set<String> orgIdSet) throws Exception {
        List members = null;
        String orgId = null;
        List<MbgViewListDimensionInfo> dimensions = null;
        for (int i = 0; i < columnsOrRows.size(); ++i) {
            if (columnsOrRows.get(i) == null || !(columnsOrRows.get(i) instanceof MbgViewListRowCol)) continue;
            dimensions = ((MbgViewListRowCol)columnsOrRows.get(i)).getDimensions();
            for (int j = 0; j < dimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(j).getNumber()) || (members = dimensions.get(j).getMember()) == null || members.isEmpty()) continue;
                for (int k = 0; k < members.size(); ++k) {
                    if (members.get(k) == null || !(members.get(k) instanceof MbgViewListDimensionMember) || StringUtils.isEmpty((String)(orgId = ((MbgViewListDimensionMember)members.get(k)).getAttribute()))) continue;
                    orgIdSet.add(orgId);
                }
            }
        }
    }

    public int judgeColOrRowOrPage(int sheetIndex) {
        int i;
        List pageDimension = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getPageDimension();
        List<MbgViewListDimensionInfo> colOnlyDimension = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getColOnlyDimension();
        List<MbgViewListDimensionInfo> rowOnlyDimension = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowOnlyDimension();
        MbgViewListDimensionInfo mbgViewListDimensionInfo = null;
        int colOrRowOrPageFlag = 2;
        for (i = 0; i < pageDimension.size(); ++i) {
            if (pageDimension.get(i) == null || !(pageDimension.get(i) instanceof MbgViewListDimensionInfo) || !MBGLayoutConstants.BG_ORGANIZATION.equals(((MbgViewListDimensionInfo)pageDimension.get(i)).getNumber())) continue;
            return 2;
        }
        for (i = 0; i < colOnlyDimension.size(); ++i) {
            mbgViewListDimensionInfo = colOnlyDimension.get(i);
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(mbgViewListDimensionInfo.getNumber())) continue;
            return 4;
        }
        for (i = 0; i < rowOnlyDimension.size(); ++i) {
            mbgViewListDimensionInfo = rowOnlyDimension.get(i);
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(mbgViewListDimensionInfo.getNumber())) continue;
            return 3;
        }
        return colOrRowOrPageFlag;
    }

    @Override
    protected void showRollOrgLock(Book book) throws Exception {
        Set<String> orgNums = MBGViewListFormCommonHelper.getOrgNumsOfSheet((MbgViewListSheetManager)this.getCurMbgSheetManager());
        HashSet<String> isLockOrg = new HashSet<String>();
        if (orgNums.isEmpty() || orgNums.size() == 1) {
            return;
        }
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo.getState().getValue() == 6) {
            return;
        }
        BgFormCollection formCol = this.getRollFormInfos(orgNums, bgFormInfo);
        for (int i = 0; i < formCol.size(); ++i) {
            BgFormInfo temp = formCol.get(i);
            if (!temp.isIsRolled()) continue;
            isLockOrg.add(temp.getOrgUnit().getId().toString());
        }
        boolean isRollLock = false;
        BgSheetRange lockRange = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            lockRange = new BgSheetRange(sheet);
            BgSheetRange unLockRange = new BgSheetRange(sheet);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    String orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        return;
                    }
                    if (isLockOrg.contains(orgId) && !cell.isLocked()) {
                        BgNFSHelper.setCellData(cell, "roll_lock", true);
                        lockRange.addCell(cell.getRow(), cell.getCol());
                        BgNFSHelper.setBackGroup(cell, BgNConstants.LOCK_COLOR);
                        continue;
                    }
                    if (BgNFSHelper.getCellData(cell, "roll_lock") == null || !(isRollLock = ((Boolean)BgNFSHelper.getCellData(cell, "roll_lock")).booleanValue())) continue;
                    unLockRange.addCell(cell.getRow(), cell.getCol());
                    BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
                }
            }
            BgViewHelper.setLocked(true, lockRange.getRange(), true);
            BgViewHelper.setLocked(false, unLockRange.getRange(), true);
        }
    }

    public BgFormCollection getRollFormInfos(Set<String> orgNumsifOrgonRowCol, BgFormInfo bgFormInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgFormInfo.getBgScheme().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", orgNumsifOrgonRowCol, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgtemplate.id", (Object)bgFormInfo.getBgTemplate().getId().toString(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("isRolled");
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("state");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        BgFormCollection formCol = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        return formCol;
    }
}

