/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.roll.impl.AbstractBgRollRuleStrategy;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MonthQuarterRollStrategy
extends AbstractBgRollRuleStrategy {
    private static final String CONVERT_MONTH_SIGN = "CONVERT_MONTH_SIGN";
    private Map<String, List<String>> periodMappings = new LinkedHashMap<String, List<String>>();

    @Override
    public boolean isProcessPeriod(String bgPeriodNumber) {
        return 3 == (this.ctx != null ? BgPeriodHelper.getPeriodType((Context)this.ctx, (String)bgPeriodNumber) : BgPeriodHelper.getPeriodType((String)bgPeriodNumber));
    }

    public boolean isProcessChildPeriod(String bgPeriodNumber) {
        return 4 == (this.ctx != null ? BgPeriodHelper.getPeriodType((Context)this.ctx, (String)bgPeriodNumber) : BgPeriodHelper.getPeriodType((String)bgPeriodNumber));
    }

    @Override
    protected void initData() throws BOSException {
        this.initPeriodMapping();
    }

    public void initPeriodMapping() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)4, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.selfDefined", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        IBgPeriodDisp instance = this.ctx != null ? BgPeriodDispFactory.getLocalInstance((Context)this.ctx) : BgPeriodDispFactory.getRemoteInstance();
        BgPeriodDispCollection col = instance.getBgPeriodDispCollection(view);
        if (col == null || col.isEmpty()) {
            return;
        }
        List<Object> leafPeriods = null;
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            String longNumber = col.get(i).getLongNumber();
            String[] tmpStrs = longNumber.split("!");
            int jn = tmpStrs.length - 1;
            for (int j = 0; j < jn; ++j) {
                if (!this.periodMappings.containsKey(tmpStrs[j])) {
                    leafPeriods = new ArrayList();
                    this.periodMappings.put(tmpStrs[j], leafPeriods);
                }
                if (!this.periodMappings.containsKey(tmpStrs[j]) || (leafPeriods = this.periodMappings.get(tmpStrs[j])).contains(tmpStrs[j + 1])) continue;
                leafPeriods.add(tmpStrs[j + 1]);
            }
        }
    }

    @Override
    public boolean isConvertActualPeriod(String bgPeriodNumber, String currRollPeriod) {
        if (currRollPeriod == null) {
            return false;
        }
        if (this.isProcessPeriod(bgPeriodNumber) || this.isProcessChildPeriod(bgPeriodNumber)) {
            return bgPeriodNumber.compareTo(currRollPeriod) < 0;
        }
        return false;
    }

    @Override
    protected void resetViewListSheetManager(MbgViewListSheetManager sheetManager, String offNumber, boolean isLimitLength) throws BgRollException {
        List<IMbgViewListObject> columns = sheetManager.getDimensionManager().getColumns();
        try {
            if (isLimitLength) {
                Map<String, Object> periodMembers = this.getMinMaxPeriodMembers(columns, offNumber);
                this.fillBgPeriodMemberToMax(columns, (String)periodMembers.get("MAX_SOURCE_PERIOD_SIGN"), offNumber, (Set)periodMembers.get(CONVERT_MONTH_SIGN));
                this.createHisRowCol(columns, (Set)periodMembers.get("ACTUAL_SIGN"), (String)periodMembers.get("MIN_TARGET_PERIOD_SIGN"));
                this.filterPeriodMember(columns, this.periodMappings.get(offNumber.replaceAll("QUAR", "MONT")).get(0));
            } else {
                super.resetViewListSheetManager(sheetManager, offNumber, isLimitLength);
            }
        }
        catch (CloneNotSupportedException e) {
            e.getStackTrace();
            SysUtil.abort();
        }
    }

    @Override
    protected boolean checkIsContainMinPeriod(String minPeriodNum, boolean isContainAct, MbgViewListRowCol rowCol) throws BgRollException {
        if (this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) {
            MbgViewListDimensionInfo d = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = d.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessChildPeriod(member.getNumber()) || !minPeriodNum.equals(member.getNumber())) continue;
                isContainAct = true;
            }
        }
        return isContainAct;
    }

    @Override
    protected void rollMemberRolCol(List<IMbgViewListObject> columns, String maxSouPeriod, String bgPeriodNumber) throws BgRollException {
        Iterator<IMbgViewListObject> iter = columns.iterator();
        while (iter.hasNext()) {
            MbgViewListRowCol rowCol;
            IMbgViewListObject viewListObj = iter.next();
            if (!(viewListObj instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)viewListObj).isAddFromRoll()) continue;
            BgDimensionBaseInfo dimInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = dimInfo.getMember();
            boolean containBudgetScenario = this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()));
            Iterator<BgDimensionMember> iterMember = members.iterator();
            while (iterMember.hasNext()) {
                String offsetNumber;
                BgDimensionMember member = (BgDimensionMember)iterMember.next();
                if (!this.checkLeafPeriod(member.getNumber())) continue;
                if (this.isProcessPeriod(member.getNumber())) {
                    offsetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                    this.replacePeriodMember(iterMember, member, offsetNumber, bgPeriodNumber, true, containBudgetScenario);
                    continue;
                }
                if (!this.isProcessChildPeriod(member.getNumber())) continue;
                offsetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength() * 3);
                this.replacePeriodMember(iterMember, member, offsetNumber, bgPeriodNumber, false, containBudgetScenario);
            }
            if (members.isEmpty()) {
                iter.remove();
            }
            Iterator<BgDimensionMember> selIter = dimInfo.getSelectMembers().iterator();
            while (selIter.hasNext()) {
                String offsetNumber;
                Object next = selIter.next();
                if (next instanceof BgDimensionMember) {
                    BgDimensionMember selectMember = (BgDimensionMember)next;
                    if (!this.checkLeafPeriod(selectMember.getNumber())) continue;
                    if (this.isProcessPeriod(selectMember.getNumber())) {
                        offsetNumber = this.getOffsetBgPeriodNumber(selectMember.getNumber(), this.rollInfo.getLength());
                        this.replacePeriodMember(selIter, selectMember, offsetNumber, bgPeriodNumber, true, containBudgetScenario);
                        continue;
                    }
                    if (!this.isProcessChildPeriod(selectMember.getNumber())) continue;
                    offsetNumber = this.getOffsetBgPeriodNumber(selectMember.getNumber(), this.rollInfo.getLength() * 3);
                    this.replacePeriodMember(selIter, selectMember, offsetNumber, bgPeriodNumber, false, containBudgetScenario);
                    continue;
                }
                BgPeriodInfo info = (BgPeriodInfo)next;
                if (!this.checkLeafPeriod(info.getNumber())) continue;
                if (this.isProcessPeriod(info.getNumber())) {
                    offsetNumber = this.getOffsetBgPeriodNumber(info.getNumber(), this.rollInfo.getLength());
                    this.replacePeriodInfo(selIter, info, offsetNumber, bgPeriodNumber, true, containBudgetScenario);
                    continue;
                }
                if (!this.isProcessChildPeriod(info.getNumber())) continue;
                offsetNumber = this.getOffsetBgPeriodNumber(info.getNumber(), this.rollInfo.getLength() * 3);
                this.replacePeriodInfo(selIter, info, offsetNumber, bgPeriodNumber, false, containBudgetScenario);
            }
        }
    }

    private void replacePeriodInfo(Iterator selIter, BgPeriodInfo info, String offsetNumber, String bgPeriodNumber, boolean isProcessPeriod, boolean containBudgetScenario) {
        String tmpPeriodNumber = null;
        tmpPeriodNumber = isProcessPeriod ? bgPeriodNumber : this.periodMappings.get(bgPeriodNumber.replaceAll("QUAR", "MONT")).get(0);
        if (offsetNumber.compareTo(tmpPeriodNumber) < 0 && containBudgetScenario) {
            selIter.remove();
        } else if (!this.schemePeriodRanges.containsKey(offsetNumber)) {
            selIter.remove();
        } else {
            BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.schemePeriodRanges.get(offsetNumber);
            info.setNumber(bgPeriodInfo.getNumber());
            info.setName(bgPeriodInfo.getName());
            info.setId(bgPeriodInfo.getId());
        }
    }

    private void replacePeriodMember(Iterator<BgDimensionMember> iterMember, BgDimensionMember member, String offsetNumber, String bgPeriodNumber, boolean isProcessPeriod, boolean containBudgetScenario) {
        String tmpPeriodNumber = null;
        tmpPeriodNumber = isProcessPeriod ? bgPeriodNumber : this.periodMappings.get(bgPeriodNumber.replaceAll("QUAR", "MONT")).get(0);
        if (offsetNumber.compareTo(tmpPeriodNumber) < 0 && containBudgetScenario) {
            iterMember.remove();
        } else if (!this.schemePeriodRanges.containsKey(offsetNumber)) {
            iterMember.remove();
        } else {
            BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.schemePeriodRanges.get(offsetNumber);
            member.setAlias(bgPeriodInfo.getName());
            member.setNumber(bgPeriodInfo.getNumber());
            member.setSortValue((Comparable)((Object)bgPeriodInfo.getLongNumber()));
            member.setName(bgPeriodInfo.getName());
        }
    }

    @Override
    protected Map<String, Object> getHisActPeriodMembersOfContinuous(List<IMbgViewListObject> columns, String offNumber) throws BgRollException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String minPeriodNumber = null;
        LinkedHashSet<String> rollMembers = new LinkedHashSet<String>();
        for (IMbgViewListObject viewListObj : columns) {
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            for (BgDimensionMember member : members) {
                String covtOffNumber;
                String targetNumber;
                if (!this.checkLeafPeriod(member.getNumber())) continue;
                if (this.isProcessPeriod(member.getNumber())) {
                    targetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                    rollMembers.add(targetNumber);
                    continue;
                }
                if (!this.isProcessChildPeriod(member.getNumber())) continue;
                targetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength() * 3);
                if (targetNumber.compareTo(covtOffNumber = this.periodMappings.get(offNumber.replaceAll("QUAR", "MONT")).get(0)) >= 0) {
                    if (minPeriodNumber == null) {
                        minPeriodNumber = targetNumber;
                    } else if (targetNumber.compareTo(minPeriodNumber) < 0) {
                        minPeriodNumber = targetNumber;
                    }
                }
                rollMembers.add(targetNumber);
            }
        }
        HashSet tmpSet = new HashSet(this.leafPeriods);
        tmpSet.retainAll(rollMembers);
        if (tmpSet.isEmpty()) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        if (minPeriodNumber == null) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        Set<String> actuals = this.getActPeriodMembersOfContinuous(offNumber);
        result.put("ACTUAL_SIGN", actuals);
        result.put("MIN_TARGET_PERIOD_SIGN", minPeriodNumber);
        return result;
    }

    @Override
    protected Set<String> getActPeriodMembersOfContinuous(String offNumber) throws BgRollException {
        TreeSet<String> actuals = new TreeSet<String>();
        for (int i = 1; i <= this.rollInfo.getHisPeriodLength(); ++i) {
            String offsetBgPeriodNumber = this.getOffsetBgPeriodNumber(offNumber, -i);
            if (!this.periodMappings.containsKey(offsetBgPeriodNumber = offsetBgPeriodNumber.replaceAll("QUAR", "MONT"))) continue;
            List<String> leafMonthPeriods = this.periodMappings.get(offsetBgPeriodNumber);
            actuals.addAll(leafMonthPeriods);
        }
        return actuals;
    }

    private void filterPeriodMember(List<IMbgViewListObject> columns, String minMonthPeriodOfQuarter) {
        Iterator<IMbgViewListObject> vIter = columns.iterator();
        while (vIter.hasNext()) {
            BgDimensionMember member;
            MbgViewListRowCol rowCol;
            IMbgViewListObject viewListObj = vIter.next();
            if (!(viewListObj instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)viewListObj).isAddFromRoll()) continue;
            List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, dimensions))) continue;
            List members = dimPerInfo.getMember();
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                member = (BgDimensionMember)iter.next();
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessChildPeriod(member.getNumber()) || member.getNumber().compareTo(minMonthPeriodOfQuarter) >= 0) continue;
                iter.remove();
            }
            iter = dimPerInfo.getSelectMembers().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof BgDimensionMember) {
                    member = (BgDimensionMember)obj;
                    if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessChildPeriod(member.getNumber()) || member.getNumber().compareTo(minMonthPeriodOfQuarter) >= 0) continue;
                    iter.remove();
                    continue;
                }
                BgPeriodInfo info = (BgPeriodInfo)obj;
                if (!this.checkLeafPeriod(info.getNumber()) || !this.isProcessChildPeriod(info.getNumber()) || info.getNumber().compareTo(minMonthPeriodOfQuarter) >= 0) continue;
                iter.remove();
            }
            if (!members.isEmpty()) continue;
            vIter.remove();
        }
    }

    private void fillBgPeriodMemberToMax(List<IMbgViewListObject> columns, String maxPeriodNumber, String offNumber, Set<String> addPeriodNums) throws BgRollException {
        Iterator<IMbgViewListObject> iter = columns.iterator();
        while (iter.hasNext()) {
            BgDimensionMember member;
            IMbgViewListObject viewListObj = iter.next();
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            boolean isContainMax = false;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            Iterator memberIter = members.iterator();
            while (memberIter.hasNext()) {
                member = (BgDimensionMember)memberIter.next();
                if (member.getNumber().equals(maxPeriodNumber)) {
                    isContainMax = true;
                }
                if (!this.isProcessPeriod(member.getNumber()) || offNumber.compareTo(member.getNumber()) < 0) continue;
                memberIter.remove();
            }
            Iterator selIter = dimPerInfo.getSelectMembers().iterator();
            while (selIter.hasNext()) {
                Object obj = selIter.next();
                if (obj instanceof BgDimensionMember) {
                    member = (BgDimensionMember)obj;
                    if (!this.isProcessPeriod(member.getNumber()) || offNumber.compareTo(member.getNumber()) < 0) continue;
                    selIter.remove();
                    continue;
                }
                BgPeriodInfo info = (BgPeriodInfo)obj;
                if (!this.isProcessPeriod(info.getNumber()) || offNumber.compareTo(info.getNumber()) < 0) continue;
                selIter.remove();
            }
            if (isContainMax) {
                for (String addNum : addPeriodNums) {
                    MbgViewListDimensionMember newViewListDimensionMember = this.newViewListDimensionMember(addNum);
                    if (!members.contains(newViewListDimensionMember)) {
                        members.add(newViewListDimensionMember);
                    }
                    MbgViewListDimensionMember periodM = null;
                    if (dimPerInfo.getSelectMembers() != null && !dimPerInfo.getSelectMembers().isEmpty()) {
                        Object obj = dimPerInfo.getSelectMembers().get(0);
                        periodM = obj instanceof MbgViewListDimensionMember ? newViewListDimensionMember : this.schemePeriodRanges.get(addNum);
                    }
                    if (dimPerInfo.getSelectMembers().contains(periodM)) continue;
                    dimPerInfo.getSelectMembers().add(periodM);
                }
                Collections.sort((List)dimPerInfo.getMember(), (Comparator)new AbstractBgRollRuleStrategy.DimenisonMemberComparator());
                Collections.sort((List)dimPerInfo.getSelectMembers(), (Comparator)new AbstractBgRollRuleStrategy.DimenisonMemberComparator());
            }
            if (!members.isEmpty()) continue;
            iter.remove();
        }
    }

    @Override
    protected boolean checkIsContainActPeriods(Set<String> actPeriods, boolean isContainAct, MbgViewListRowCol rowCol, String minTarPeriod) throws BgRollException {
        if (this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) {
            MbgViewListDimensionInfo d = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = d.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessChildPeriod(member.getNumber()) || !member.getNumber().equals(minTarPeriod)) continue;
                isContainAct = true;
            }
        }
        return isContainAct;
    }

    private Map<String, Object> getMinMaxPeriodMembers(List<IMbgViewListObject> columns, String offNumber) throws CloneNotSupportedException, BgRollException {
        HashMap<String, Object> periodMembers = new HashMap<String, Object>();
        TreeSet<String> actMembers = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String maxPeriodNumber = null;
        HashSet convertMembers = new HashSet();
        String minMonthNumber = this.periodMappings.get(offNumber.replaceAll("QUAR", "MONT")).get(0);
        boolean isRollSuccess = false;
        for (IMbgViewListObject viewListObj : columns) {
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber())) continue;
                if (this.isProcessChildPeriod(member.getNumber())) {
                    if (member.getNumber().compareTo(minMonthNumber) < 0) {
                        actMembers.add(member.getNumber());
                    }
                    if (maxPeriodNumber == null) {
                        maxPeriodNumber = member.getNumber();
                        continue;
                    }
                    if (member.getNumber().compareTo(maxPeriodNumber) <= 0) continue;
                    maxPeriodNumber = member.getNumber();
                    continue;
                }
                if (!this.isProcessPeriod(member.getNumber())) continue;
                if (member.getNumber().compareTo(offNumber) == 0) {
                    isRollSuccess = true;
                    periodMembers.put("MIN_TARGET_PERIOD_SIGN", this.periodMappings.get(member.getNumber().replaceAll("QUAR", "MONT")).get(0));
                    convertMembers.addAll(this.periodMappings.get(member.getNumber().replaceAll("QUAR", "MONT")));
                    continue;
                }
                if (member.getNumber().compareTo(offNumber) < 0) {
                    actMembers.addAll((Collection<String>)this.periodMappings.get(member.getNumber().replaceAll("QUAR", "MONT")));
                    continue;
                }
                isRollSuccess = true;
            }
        }
        if (!isRollSuccess) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
        }
        periodMembers.put("MAX_SOURCE_PERIOD_SIGN", maxPeriodNumber);
        periodMembers.put("ACTUAL_SIGN", actMembers);
        periodMembers.put(CONVERT_MONTH_SIGN, convertMembers);
        return periodMembers;
    }

    @Override
    protected void updateItemFormula(Cell cell, boolean isLimitLength) throws BOSException, EASBizException {
        String rollPeriodNumber = null;
        String formula = BgNFSHelper.getFormulaOfCell(cell);
        if (!StringUtils.isEmpty((String)formula)) {
            String bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1];
            String bgScenarioNumber = BgNFSHelper.parseFormulaPara(formula)[3];
            if (!this.checkLeafPeriod(bgPeriodNumber)) {
                return;
            }
            if (!isLimitLength) {
                if (this.isProcessPeriod(bgPeriodNumber)) {
                    rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength());
                    if (!this.checkLeafPeriod(rollPeriodNumber) || !this.leafPeriods.contains(rollPeriodNumber)) {
                        throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
                    }
                    formula = this.reSetPeriod(formula, rollPeriodNumber);
                    if (this.isConvertActualPeriod(rollPeriodNumber, this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength()))) {
                        if (this.scenMappings.get(bgScenarioNumber) != null) {
                            formula = this.reSetScenario(formula, ((BgScenarioInfo)this.scenMappings.get(bgScenarioNumber)).getNumber());
                        }
                        if (BgNFSHelper.checkHasExpression(cell)) {
                            BgNFSHelper.clearExpression(cell);
                        }
                    }
                } else if (this.isProcessChildPeriod(bgPeriodNumber)) {
                    rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength() * 3);
                    if (!this.checkLeafPeriod(rollPeriodNumber) || !this.leafPeriods.contains(rollPeriodNumber)) {
                        throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
                    }
                    formula = this.reSetPeriod(formula, rollPeriodNumber);
                    String number = this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength());
                    number = number.replaceAll("QUAR", "MONT");
                    if (!this.periodMappings.containsKey(number)) {
                        throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
                    }
                    String targetPeriod = this.periodMappings.get(number).get(0);
                    if (this.isConvertActualPeriod(rollPeriodNumber, targetPeriod)) {
                        if (this.scenMappings.get(bgScenarioNumber) != null) {
                            formula = this.reSetScenario(formula, ((BgScenarioInfo)this.scenMappings.get(bgScenarioNumber)).getNumber());
                        }
                        if (BgNFSHelper.checkHasExpression(cell)) {
                            BgNFSHelper.clearExpression(cell);
                        }
                    }
                }
            }
            BgNFSHelper.setFormulaOfCell(cell, formula);
        }
    }

    @Override
    protected void updateCellValue(Cell cell, boolean isLimitLength) throws BgRollException {
        if (cell == null || cell.getUserObject("CELL_DATA") == null) {
            return;
        }
        Object value = cell.getUserObject("CELL_DATA").getValue();
        if (value != null && value instanceof Map) {
            Map map = (Map)value;
            Object type = map.get("bgFillType");
            if ("bgFillValueType_period".equals(type)) {
                String rollPeriodNumber;
                String bgPeriodNumber = (String)map.get("bgFillValue");
                if (!this.checkLeafPeriod(bgPeriodNumber)) {
                    return;
                }
                if (this.isProcessPeriod(bgPeriodNumber)) {
                    String rollPeriodNumber2 = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength());
                    if (this.schemePeriodRanges.containsKey(rollPeriodNumber2)) {
                        BgNFSHelper.setValue(cell, ((BgPeriodInfo)this.schemePeriodRanges.get(rollPeriodNumber2)).getName());
                        map.put("bgFillValue", rollPeriodNumber2);
                    }
                } else if (this.isProcessChildPeriod(bgPeriodNumber) && this.schemePeriodRanges.containsKey(rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength() * 3))) {
                    BgNFSHelper.setValue(cell, ((BgPeriodInfo)this.schemePeriodRanges.get(rollPeriodNumber)).getName());
                    map.put("bgFillValue", rollPeriodNumber);
                }
            } else if ("bgFillValueType_scenario".equals(type)) {
                String scenarioNumber = (String)map.get("bgFillValue");
                Sheet sheet = cell.getSheet();
                int in = sheet.getMaxRowIndex();
                for (int i = cell.getRow(); i < in; ++i) {
                    String rollPeriodNumber;
                    String bgPeriodNumber;
                    String formula;
                    Cell swap = sheet.getCell(i, cell.getCol(), false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(swap) || StringUtils.isEmpty((String)(formula = BgNFSHelper.getFormulaOfCell(swap))) || !this.checkLeafPeriod(bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1])) continue;
                    if (this.isProcessPeriod(bgPeriodNumber)) {
                        rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength());
                        if (!this.isConvertActualPeriod(rollPeriodNumber, this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength())) || this.scenMappings.get(scenarioNumber) == null) continue;
                        BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)this.scenMappings.get(scenarioNumber);
                        BgNFSHelper.setValue(cell, bgScenarioInfo.getName());
                        map.put("bgFillValue", bgScenarioInfo.getNumber());
                        return;
                    }
                    if (!this.isProcessChildPeriod(bgPeriodNumber)) continue;
                    rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength() * 3);
                    String number = this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength());
                    if (!this.periodMappings.containsKey(number = number.replaceAll("QUAR", "MONT"))) {
                        return;
                    }
                    String targetPeriod = this.periodMappings.get(number).get(0);
                    if (!this.isConvertActualPeriod(rollPeriodNumber, targetPeriod) || this.scenMappings.get(scenarioNumber) == null) continue;
                    BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)this.scenMappings.get(scenarioNumber);
                    BgNFSHelper.setValue(cell, bgScenarioInfo.getName());
                    map.put("bgFillValue", bgScenarioInfo.getNumber());
                    return;
                }
            } else {
                return;
            }
        }
    }

    @Override
    protected void putEditPeriodNumber(String bgPeriodNumber, String bgFormPeriodNumber, boolean isRolled, Set<String> numbers) throws BgRollException {
        if (this.checkLeafPeriod(bgPeriodNumber)) {
            if (isRolled) {
                if (this.isProcessPeriod(bgPeriodNumber)) {
                    if (bgPeriodNumber.compareTo(bgFormPeriodNumber) >= 0) {
                        numbers.add(bgPeriodNumber);
                    }
                } else if (this.isProcessChildPeriod(bgPeriodNumber)) {
                    String monthPeriod = this.periodMappings.get(bgFormPeriodNumber = bgFormPeriodNumber.replaceAll("QUAR", "MONT")).get(0);
                    if (bgPeriodNumber.compareTo(monthPeriod) >= 0) {
                        numbers.add(bgPeriodNumber);
                    }
                } else {
                    numbers.add(bgPeriodNumber);
                }
            } else {
                numbers.add(bgPeriodNumber);
            }
        }
    }
}

