/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.ICubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Schema;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.SchemaImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.SchemaReaderImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.SchemaReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CUBADatabase
implements Serializable {
    private static Logger logger = Logger.getLogger(CUBADatabase.class);
    public Schema schema;
    protected HashMap<String, ICubeData> cubeDatas = new HashMap();

    public CUBADatabase(Schema _schema) {
        this.schema = _schema;
    }

    public SchemaReader getSchemaReader() {
        return new SchemaReaderImpl((SchemaImpl)this.schema);
    }

    public ICubeData getCubeData(String name) {
        return this.cubeDatas.get(name);
    }

    public ICubeData getCubeData(Cube cube) {
        return this.getCubeData(cube.getName());
    }

    public void setData(String name, ICubeData data) {
        this.cubeDatas.put(name, data);
    }

    public void release() {
        this.schema = null;
        for (CubeData cubeData : this.cubeDatas.values()) {
            cubeData.release();
        }
    }

    public String getDefaultCubeName() {
        Iterator<String> iter = this.cubeDatas.keySet().iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }
}

