/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.collection;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IInnerList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IStorageManager;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.ListWrapper;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ObjectComparator;

public class CacheableListWrapper
extends ListWrapper
implements IList {
    IStorageManager storageManager;

    CacheableListWrapper(IInnerList innerList, IStorageManager storageManager) {
        super(innerList);
        this.storageManager = storageManager;
    }

    @Override
    public void add(Object o) {
        super.add(o);
        this.doCache();
    }

    @Override
    public void addArray(Object[] objects) {
        super.addArray(objects);
        this.doCache();
    }

    @Override
    public void addFirst(Object o) {
        super.addFirst(o);
        this.doCache();
    }

    @Override
    public void addList(IList list) {
        super.addList(list);
        this.doCache();
    }

    @Override
    public void sort(ObjectComparator comparator) throws CUBAException {
        super.sort(comparator);
        this.doCache();
    }

    void doCache() {
        if (this.innerList.realSize() > 10000) {
            this.innerList.doCache(this.storageManager);
        }
    }
}

