/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.collection;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.ArrayList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.CacheableArrayList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IInnerList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IStorageManager;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.ListSortUtil;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.Resetable;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ObjectComparator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnionList
implements IInnerList {
    IInnerList[] lists;
    boolean sorted;

    UnionList(IInnerList list1, IInnerList list2) {
        this(new IInnerList[]{list1, list2});
    }

    UnionList(IInnerList[] lists) {
        this.lists = lists;
        this.merge();
    }

    public IInnerList getList(int index) {
        return this.lists[index];
    }

    @Override
    public IInnerList innerAdd(Object o) {
        IInnerList last = this.lists[this.lists.length - 1];
        this.lists[this.lists.length - 1] = last.innerAdd(o);
        if (this.lists[this.lists.length - 1] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public IInnerList innerAddList(IInnerList list) {
        if (list == this) {
            throw new IllegalArgumentException("List can't addList itself.");
        }
        if (list.size() == 1) {
            return this.innerAdd(list.get(0));
        }
        IInnerList last = this.lists[this.lists.length - 1];
        this.lists[this.lists.length - 1] = last = last.innerAddList(list);
        if (last instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public Object get(int index) {
        this.rangeCheck(index);
        for (int i = 0; i < this.lists.length; ++i) {
            IInnerList list = this.lists[i];
            int size = list.size();
            if (index < size) {
                return list.get(index);
            }
            index -= size;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.lists.length; ++i) {
            size += this.lists[i].size();
        }
        return size;
    }

    @Override
    public int realSize() {
        int size = 0;
        for (int i = 0; i < this.lists.length; ++i) {
            size += this.lists[i].realSize();
        }
        return size;
    }

    @Override
    public Iterator iterator() {
        return new Itr();
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IInnerList subList(int begin, int end) {
        if (begin == end) {
            return IInnerList.EMPTY;
        }
        if (begin > end) {
            throw new IllegalArgumentException("Illegal Argument subList(" + begin + "," + end + ")");
        }
        if (begin < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException("subList(" + begin + "," + end + "),size=" + this.size());
        }
        int index1 = 0;
        int index2 = 0;
        int offset1 = 0;
        int offset2 = 0;
        int size = 0;
        boolean found1 = false;
        boolean found2 = false;
        for (int i = 0; i < this.lists.length; ++i) {
            if (!found1 && size + this.lists[i].size() >= begin) {
                index1 = i;
                offset1 = begin - size;
                found1 = true;
            }
            if (!found2 && size + this.lists[i].size() >= end) {
                index2 = i;
                offset2 = end - size;
                found2 = true;
            }
            size += this.lists[i].size();
        }
        if (index1 == index2) {
            return this.lists[index1].subList(offset1, offset2);
        }
        ArrayList container = new ArrayList();
        if (this.lists[index1].size() > offset1) {
            container.innerAdd(this.lists[index1].subList(offset1, this.lists[index1].size()));
        }
        while (++index1 < index2) {
            container.innerAdd(this.lists[index1]);
        }
        if (offset2 > 0) {
            container.innerAdd(this.lists[index2].subList(0, offset2));
        }
        IInnerList[] lists2 = (IInnerList[])container.toArray(new IInnerList[0]);
        UnionList ret = new UnionList(lists2);
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.lists.length; ++i) {
            if (!this.lists[i].contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object getFirst() {
        for (int i = 0; i < this.lists.length; ++i) {
            if (this.lists[i].isEmpty()) continue;
            return this.lists[i].getFirst();
        }
        return null;
    }

    @Override
    public Object getLast() {
        for (int i = this.lists.length - 1; i >= 0; --i) {
            if (this.lists[i].isEmpty()) continue;
            return this.lists[i].getLast();
        }
        return null;
    }

    @Override
    public IInnerList innerAddFirst(Object o) {
        this.lists[0] = this.lists[0].innerAddFirst(o);
        if (this.lists[0] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public IInnerList innerAddArray(Object[] objects) {
        int index = this.lists.length - 1;
        this.lists[index] = this.lists[index].innerAddArray(objects);
        if (this.lists[index] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    private void merge() {
        java.util.ArrayList container = new java.util.ArrayList();
        this.getChildren(container, this);
        this.lists = container.toArray(new IInnerList[0]);
    }

    private void getChildren(java.util.ArrayList container, UnionList unionList) {
        IInnerList[] lists = unionList.lists;
        for (int i = 0; i < lists.length; ++i) {
            if (lists[i] instanceof UnionList) {
                this.getChildren(container, (UnionList)lists[i]);
                continue;
            }
            container.add(lists[i]);
        }
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public IInnerList sort(ObjectComparator comparator) throws CUBAException {
        return new ListSortUtil(this).sort(comparator);
    }

    @Override
    public void doCache(IStorageManager storageManager) {
        for (int i = 0; i < this.lists.length; ++i) {
            ArrayList alist;
            IInnerList list = this.lists[i];
            if (list instanceof ArrayList && (alist = (ArrayList)list).size() >= 5000) {
                CacheableArrayList calist = new CacheableArrayList(storageManager, alist);
                this.lists[i] = calist;
            }
            this.lists[i].doCache(storageManager);
        }
    }

    class Itr
    implements Iterator,
    Resetable {
        Iterator[] itrs = null;
        Iterator cur = null;
        int index = 0;
        boolean passHasNext = false;

        Itr() {
            this.itrs = new Iterator[UnionList.this.lists.length];
            this.itrs[0] = this.cur = UnionList.this.lists[0].iterator();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            this.passHasNext = true;
            if (this.cur.hasNext()) {
                return true;
            }
            if (this.index < UnionList.this.lists.length - 1) {
                if (this.itrs[this.index + 1] != null) {
                    this.cur = this.itrs[++this.index];
                } else {
                    this.itrs[this.index] = this.cur = UnionList.this.lists[++this.index].iterator();
                }
                return this.cur.hasNext();
            }
            return false;
        }

        public Object next() {
            try {
                if (!this.passHasNext && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.passHasNext = false;
                return this.cur.next();
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            for (int i = 0; i < this.itrs.length; ++i) {
                ((Resetable)((Object)this.itrs[i])).reset();
            }
            this.index = 0;
            this.cur = this.itrs[0];
            this.passHasNext = false;
        }
    }
}

