/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Axis;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Position;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.ArrayIterator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.PositionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.PositionIterable;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.PositionLocator;
import java.io.Serializable;
import java.util.Iterator;

public class AxisImpl
implements Axis,
Serializable {
    private static final long serialVersionUID = -9165825390985300565L;
    public String name;
    private final PositionImpl[] positions;
    public Hierarchy[] hierarchies;
    public final PositionIterable positionIterable;
    public final PositionLocator positionLocator;
    public int positionCount;

    public AxisImpl(String name, Hierarchy[] hierarchies, PositionImpl[] positions) {
        this.name = name;
        this.hierarchies = hierarchies;
        this.positionCount = positions.length;
        this.positions = positions;
        this.positionIterable = this.makeIterable(positions);
        this.positionLocator = this.makeLocator(positions);
    }

    private PositionLocator makeLocator(final PositionImpl[] positions) {
        return new PositionLocator(){

            @Override
            public Position get(int index) {
                return positions[index];
            }
        };
    }

    private PositionIterable makeIterable(final PositionImpl[] positions) {
        return new PositionIterable(){

            @Override
            public Iterator<Position> iterator() {
                return AxisImpl.this.makeIterator(positions);
            }
        };
    }

    private Iterator<Position> makeIterator(PositionImpl[] positions) {
        return new ArrayIterator<Position>(positions);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public boolean removeEmpty() {
        return false;
    }

    @Override
    public Iterator<Position> getPositionIterator() {
        return this.positionIterable.iterator();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public Position getPosition(int index) {
        return this.positionLocator.get(index);
    }

    @Override
    public Position[] getPositions() {
        return this.positions;
    }
}

