/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Relation;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.BBFilterIndex;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionImpl;
import java.util.ArrayList;

public class BBFilterIndexes {
    private static int RELATION_COUNT;
    private static int DIM_PER_RELATION;
    private BBFilterIndex[] indexes;

    public BBFilterIndexes(Cube cube) {
        Relation[] relations = cube.getSchema().getRelations();
        if (relations != null && relations.length > 0) {
            this.initByRelation(relations, cube);
        } else {
            this.defaultInit(cube);
        }
    }

    public void initByRelation(Relation[] relations, Cube cube) {
        ArrayList<BBFilterIndex> filterIndexList = new ArrayList<BBFilterIndex>();
        ArrayList<Integer> usedDimList = new ArrayList<Integer>();
        ArrayList<Integer> cardList = new ArrayList<Integer>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        long discards = 1L;
        for (Relation relation : relations) {
            discards = 1L;
            cardList.clear();
            indexList.clear();
            Dimension[] dims = relation.getDimensions();
            for (int i = 0; i < dims.length; ++i) {
                int card = ((DimensionImpl)dims[i]).getMemberCount();
                if (card < 2) continue;
                if ((discards *= (long)card) < 0L) break;
                cardList.add(card);
                indexList.add(i);
                if (usedDimList.contains(i)) continue;
                usedDimList.add(i);
            }
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            for (int i = 0; i < cards.length; ++i) {
                cards[i] = (Integer)cardList.get(i);
                indexes[i] = (Integer)indexList.get(i);
            }
            BBFilterIndex filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
        }
        this.indexes = filterIndexList.toArray(new BBFilterIndex[filterIndexList.size()]);
    }

    public void defaultInit(Cube cube) {
        this.defaultInit(cube, new ArrayList<BBFilterIndex>(), new ArrayList<Integer>());
    }

    public void defaultInit(Cube cube, ArrayList<BBFilterIndex> filterIndexList, ArrayList<Integer> usedDimList) {
        BBFilterIndex filterIndex;
        Dimension[] dims = cube.getDimensions();
        ArrayList<Integer> cardList = new ArrayList<Integer>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        long discards = 1L;
        for (int i = 0; i < dims.length; ++i) {
            int card;
            if (dims[i].isTimeDimension() || dims[i].isParentChildrenDimension() || dims[i].getDefaultHierarchy().getLevels().length != 1 || (card = ((DimensionImpl)dims[i]).getMemberCount()) < 2) continue;
            if ((discards *= (long)card) < 0L) break;
            cardList.add(card);
            indexList.add(i);
            usedDimList.add(i);
            if (usedDimList.size() > 2) break;
        }
        if (indexList.size() > 1) {
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            for (int i = 0; i < cards.length; ++i) {
                cards[i] = (Integer)cardList.get(i);
                indexes[i] = (Integer)indexList.get(i);
            }
            filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
        } else {
            usedDimList.clear();
        }
        while (filterIndexList.size() < RELATION_COUNT) {
            discards = 1L;
            cardList.clear();
            indexList.clear();
            for (int i = 0; i < dims.length; ++i) {
                int card;
                if (usedDimList.contains(i) || (card = ((DimensionImpl)dims[i]).getMemberCount()) < 2) continue;
                if ((discards *= (long)card) < 0L) break;
                cardList.add(card);
                indexList.add(i);
                usedDimList.add(i);
                if (cardList.size() >= DIM_PER_RELATION) break;
            }
            if (cardList.size() < 2) break;
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            for (int i = 0; i < cards.length; ++i) {
                cards[i] = (Integer)cardList.get(i);
                indexes[i] = (Integer)indexList.get(i);
            }
            filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
        }
        this.indexes = filterIndexList.toArray(new BBFilterIndex[filterIndexList.size()]);
    }

    public void add(Member[] members) {
        for (BBFilterIndex index : this.indexes) {
            index.add(members);
        }
    }

    public boolean get(Member[] members) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i].get(members)) continue;
            return false;
        }
        return true;
    }

    static {
        String str = System.getProperty("OLAP_BBFILTER_RELATION_COUNT");
        if (str != null) {
            RELATION_COUNT = Integer.parseInt(str);
        }
        if ((str = System.getProperty("OLAP_BBFILTER_DIM_PER_RELATION")) != null) {
            DIM_PER_RELATION = Integer.parseInt(str);
        }
        RELATION_COUNT = 5;
        DIM_PER_RELATION = 3;
    }
}

