/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.AvgValue;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.ICubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.EvaluatorImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CellReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import java.util.ArrayList;
import java.util.Map;

public class CellReaderImpl
implements CellReader {
    ICubeData cubedata;

    public CellReaderImpl(ICubeData cubedata) {
        this.cubedata = cubedata;
    }

    @Override
    public Object get(Evaluator evaluator) throws CUBAException {
        Member[] currentMembers = ((EvaluatorImpl)evaluator).getCurrentMembers();
        Object value = this.getCell(currentMembers, evaluator.getPinCache());
        if (value instanceof AvgValue) {
            return ((AvgValue)value).getAvgValue();
        }
        return value;
    }

    protected Object getCell(Member[] point, Map pinCache) throws CUBAException {
        ArrayList<Member> list = new ArrayList<Member>(point.length);
        Member measure = null;
        for (int i = 0; i < point.length; ++i) {
            if (point[i].getDimension().isMeasureDimension()) {
                measure = point[i];
                continue;
            }
            list.add(point[i]);
        }
        int measureIndex = -1;
        Member[] measures = this.cubedata.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            if (measure == null || !measures[i].getName().equals(measure.getName())) continue;
            measureIndex = i;
            break;
        }
        point = new Member[list.size()];
        list.toArray(point);
        Object[] values = this.cubedata.getData(point, pinCache);
        if (values == null) {
            return null;
        }
        if (measureIndex > -1) {
            return values[measureIndex];
        }
        return null;
    }

    @Override
    public void buildBB(Member[] members) {
        this.cubedata.buildBB(members);
    }
}

