/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Aggregator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.BBFilterIndexes;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Coordy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Point2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemCubeData
extends CubeData {
    private static final Logger logger = Logger.getLogger(MemCubeData.class);
    HashMap detailCubeData = new HashMap();
    HashMap<PointWithMembers, Object> selfData = new HashMap();
    HashMap selfDataRollup = new HashMap();
    HashMap detailCubeCache = new HashMap();
    private int records = 0;
    private CUBAConfig config;
    BBFilterIndexes bbFilterCube;
    BBFilterIndexes bbFilterSelf;
    private final Coordy coordy;

    public MemCubeData(Cube _cube, CUBAConfig config) throws CUBAException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.bbFilterCube = new BBFilterIndexes(_cube);
        this.bbFilterSelf = new BBFilterIndexes(_cube);
        this.coordy = new Coordy(this.cube.getDimensions(true));
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws CUBAException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (!(isLeaf || this.config.supportSelfData || this.config.useSelfData)) {
            return;
        }
        ++this.records;
        if (isLeaf) {
            PointWithMembers p = new PointWithMembers(members, false);
            Object[] vs = (Object[])this.detailCubeData.get(p);
            vs = this.appendValue(vs, values);
            this.detailCubeData.put(p, vs);
            this.buildBB(this.bbFilterCube, members);
        } else {
            PointWithMembers p = new PointWithMembers(members, true);
            Object[] vs = (Object[])this.selfData.get(p);
            vs = this.appendValue(vs, values);
            this.selfData.put(p, vs);
        }
    }

    @Override
    public void buildBB(Member[] members) {
        this.buildBB(this.bbFilterCube, members);
    }

    private void buildBB(BBFilterIndexes bbFilter, Member[] members) {
        if (bbFilter.get(members)) {
            return;
        }
        bbFilter.add(members);
        Member[] members2 = null;
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null) continue;
            members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(bbFilter, members2);
        }
    }

    @Override
    public void finishAddRecord() throws CUBAException {
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            System.out.println("begin rollup self data");
            long begin = System.currentTimeMillis();
            HashSet<Map.Entry<PointWithMembers, Object>> entrySet = new HashSet<Map.Entry<PointWithMembers, Object>>();
            entrySet.addAll(this.selfData.entrySet());
            for (Map.Entry entry : entrySet) {
                Member[] members = ((PointWithMembers)entry.getKey()).ms;
                PointWithMembers.access$002((PointWithMembers)entry.getKey(), null);
                Object[] values = (Object[])entry.getValue();
                this.rollupParent(members, values);
            }
            long end = System.currentTimeMillis();
            System.out.println("data rollup cost " + (end - begin) + "ms, size:" + this.selfDataRollup.size());
        }
    }

    private void rollupParent(Member[] members, Object[] values) throws CUBAException {
        HashMap excludeMap = new HashMap();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParent(tempMembers, values, excludeMap);
        }
    }

    private void _rollupParent(Member[] members, Object[] values, HashMap excludeMap) throws CUBAException {
        PointWithMembers point = new PointWithMembers(members, false);
        if (excludeMap.containsKey(point)) {
            return;
        }
        Object[] vs = (Object[])this.selfDataRollup.get(point);
        vs = this.appendValue(vs, values);
        this.selfDataRollup.put(point, vs);
        excludeMap.put(point, point);
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParent(tempMembers, values, excludeMap);
        }
    }

    @Override
    public Object[] getData(Member[] point) throws CUBAException {
        return this.getData(point, null);
    }

    @Override
    public Object[] getData(Member[] members, Map pinCache) throws CUBAException {
        PointWithMembers point = new PointWithMembers(members, false);
        Object[] values = this._getDataInCube(members, point, pinCache);
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            Object[] vs = (Object[])this.selfData.get(point);
            Object[] vsRollup = (Object[])this.selfDataRollup.get(point);
            if (vsRollup != null) {
                vs = this.appendValue(vs, vsRollup);
            }
            if (values != null) {
                vs = this.appendValue(vs, values);
            }
            return vs;
        }
        return values;
    }

    private Object[] _getDataInCube(Member[] members, Map pinCache) throws CUBAException {
        PointWithMembers point = new PointWithMembers(members, false);
        Object[] values = this._getDataInCube(members, point, pinCache);
        return values;
    }

    private Object[] _getDataInCube(Member[] members, PointWithMembers point, Map pinCache) throws CUBAException {
        int i;
        Map pinCache1 = pinCache;
        pinCache = this.detailCubeCache;
        for (int i2 = 0; i2 < members.length; ++i2) {
            if (members[i2].hasData()) continue;
            return null;
        }
        if (!this.bbFilterCube.get(members)) {
            return null;
        }
        Object[] values = null;
        if (pinCache != null) {
            values = (Object[])pinCache.get(point);
            Object[] values1 = (Object[])pinCache1.get(new Point2(this.coordy, members));
            if (values != null) {
                if (values1 != null) {
                    for (int i3 = 0; i3 < values.length; ++i3) {
                        values[i3] = values1[i3];
                    }
                }
                return values;
            }
            if (values1 != null) {
                pinCache.put(point, values1);
                return values1;
            }
        }
        if ((values = (Object[])this.detailCubeData.get(point)) != null) {
            return values;
        }
        boolean allLeaf = true;
        for (int i4 = 0; i4 < members.length; ++i4) {
            if (!members[i4].isLeaf()) {
                allLeaf = false;
                break;
            }
            if (!members[i4].isInner() || !members[i4].isAll()) continue;
            allLeaf = false;
            break;
        }
        if (allLeaf) {
            return null;
        }
        values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (i = 0; i < members.length; ++i) {
            MemberImpl[] children = null;
            children = members[i].isInner() && members[i].isAll() ? ((HierarchyImpl)members[i].getHierarchy()).getRootMembers() : ((MemberImpl)members[i]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object[] vs;
                ms[i] = children[j];
                if (!ms[i].hasData() || (vs = this._getDataInCube(ms, pinCache1)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            break;
        }
        if (values == null) {
            return null;
        }
        for (i = 0; i < members.length; ++i) {
            if (!(members[i] instanceof MemberImpl)) continue;
            ((MemberImpl)members[i]).setHasData(true);
        }
        if (pinCache != null) {
            pinCache.put(point, values);
        }
        if (pinCache1 != null) {
            pinCache1.put(new Point2(this.coordy, members), values);
        }
        return values;
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void finishBuildData() throws CUBAException {
        String message = "After finish build data:";
        System.out.println(message);
        logger.info((Object)message);
        this.printStatistics();
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.selfData.clear();
        this.selfDataRollup.clear();
        this.detailCubeCache.clear();
    }

    @Override
    public void printStatistics() {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.detailCubeCache.size() + this.selfData.size() + this.selfDataRollup.size());
        this.println(message);
        message = "    --detail data size:" + this.detailCubeData.size();
        this.println(message);
        message = " detail rollup cache size:" + this.detailCubeCache.size();
        this.println(message);
        message = "    --not detail data size:" + this.selfData.size();
        this.println(message);
        message = "    --not detail data rollup size:" + this.selfDataRollup.size();
        this.println(message);
    }

    private void println(String message) {
        logger.info((Object)message);
        System.out.println(message);
    }

    private class PointWithMembers {
        private long coordinate;
        private Member[] ms;
        private int[] keys;
        private transient int h = 0;

        public PointWithMembers(Member[] members, boolean keepMembers) {
            this.ms = new Member[members.length];
            System.arraycopy(members, 0, this.ms, 0, members.length);
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).globalOrder;
            }
            this.coordinate = MemCubeData.this.coordy.getCoord(this.keys);
        }

        public int hashCode() {
            if (this.coordinate > 0L) {
                return (int)(this.coordinate ^ this.coordinate >>> 32);
            }
            if (this.h == 0) {
                this.h = Arrays.hashCode(this.keys);
            }
            return this.h;
        }

        public boolean equals(Object x) {
            PointWithMembers p2 = (PointWithMembers)x;
            if (this.coordinate > 0L) {
                return this.coordinate == p2.coordinate;
            }
            int[] keys1 = this.keys;
            int[] keys2 = p2.keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ Member[] access$002(PointWithMembers x0, Member[] x1) {
            x0.ms = x1;
            return x1;
        }
    }
}

