/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Connection;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Lexer;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MdxParseException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.parser;
import java.io.Serializable;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;

public class ParserHelp {
    private static Logger logger = Logger.getLogger(ParserHelp.class);

    public static Exp parseExpression(String expression) throws CUBAException {
        try {
            StringReader reader = new StringReader(expression);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            Exp exp = (Exp)parse_tree.value;
            return exp;
        }
        catch (CUBAException e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw new MdxParseException(e.getMessage());
        }
    }

    public static MdxQuery parseQuery(Connection connection, String mdx) throws CUBAException {
        long t1 = System.currentTimeMillis();
        try {
            StringReader reader = new StringReader(mdx);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            MdxQuery query = (MdxQuery)parse_tree.value;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx 1 cost " + (System.currentTimeMillis() - t1) + "\n"));
            }
            query.afterParse(connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx afterParser cost " + (System.currentTimeMillis() - t1) + "ms.mdx is\n" + mdx));
            }
            return query;
        }
        catch (CUBAException e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            if (e instanceof Serializable) {
                throw new MdxParseException(e);
            }
            throw new MdxParseException(e.getMessage());
        }
    }
}

