/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Level;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FuncResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunctionException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MultiFuncResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.func.XtdCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.SetType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.Type;

class XtdFunDef
extends FunDefBase {
    private final byte levelType;

    public XtdFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, byte levelType) {
        super(resolver, returnType, parameterTypes);
        this.levelType = levelType;
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws CUBAException {
        if (args.length == 0) {
            Hierarchy hierarchy = resolver.getQuery().getCube().getTimeDimension().getHierarchy();
            return new SetType(new MemberType(hierarchy, null, null));
        }
        Type type = args[0].getType();
        if (!type.getHierarchy().getDimension().isTimeDimension()) {
            throw new FunctionException("Funciton '" + this.getName() + "' need Time Dimension.");
        }
        return super.getResultType(resolver, args);
    }

    private Level getLevel(Cube cube) {
        switch (this.levelType) {
            case 2: {
                return FuncUtil2.getTimeLevel(cube, (byte)2);
            }
            case 3: {
                return FuncUtil2.getTimeLevel(cube, (byte)3);
            }
            case 4: {
                return FuncUtil2.getTimeLevel(cube, (byte)4);
            }
            case 5: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
            case 6: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
        }
        return null;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        Level level = this.getLevel(compiler.getResolver().getQuery().getCube());
        MemberCalc memberCalc = null;
        if (call.getArgCount() > 0) {
            memberCalc = compiler.compileMember(call.getArg(0));
        }
        return new XtdCalc(call, level, memberCalc);
    }

    public static class Resolver
    extends MultiFuncResolver {
        private final byte levelType;

        public Resolver(String name, String signature, String description, String[] signatures, byte levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
            return new XtdFunDef(this, returnType, parameterTypes, this.levelType);
        }
    }
}

