/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.util;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ArrayCalcComparator;

public class HierarchicalArrayCalcComparator
extends ArrayCalcComparator {
    private final boolean desc;

    public HierarchicalArrayCalcComparator(Evaluator evaluator, Calc exp, int arity, boolean desc) {
        super(evaluator, exp, arity);
        this.desc = desc;
    }

    @Override
    protected int compare(Member[] a1, Member[] a2) throws CUBAException {
        Member m2;
        Member m1;
        int c = 0;
        this.evaluator = this.evaluator.push();
        for (int i = 0; i < this.arity && (c = this.compareHierarchicallyButSiblingsByValue(m1 = a1[i], m2 = a2[i])) == 0; ++i) {
            this.evaluator.setContext(m1);
        }
        this.evaluator = this.evaluator.pop();
        return c;
    }

    protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) throws CUBAException {
        Member prev2;
        Member prev1;
        if (FuncUtil2.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FuncUtil2.equals(m1, m2 = m2.getParentMember())) continue;
                return -1;
            }
            if (depth1 > depth2) {
                if (!FuncUtil2.equals(m1 = m1.getParentMember(), m2)) continue;
                return 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FuncUtil2.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        int c = this.compareByValue(prev1, prev2);
        if (c == 0) {
            c = FuncUtil2.compareSiblingMembers(prev1, prev2);
        }
        return this.desc ? -c : c;
    }

    private int compareByValue(Member m1, Member m2) throws CUBAException {
        Member old = this.evaluator.setContext(m1);
        Object v1 = this.calc.evaluate(this.evaluator);
        this.evaluator.setContext(m2);
        Object v2 = this.calc.evaluate(this.evaluator);
        this.evaluator.setContext(old);
        int c = FuncUtil2.compareValues(v1, v2);
        return c;
    }
}

