/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.util;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Aggregator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ByteArrayInputStream;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class InOutSqlUtil {
    public static byte[] serialize(Object s) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bo);
        os.writeObject(s);
        return bo.toByteArray();
    }

    public static Object deserialize(byte[] ba) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bi = new ByteArrayInputStream(ba);
        ObjectInputStream is = new ObjectInputStream(bi);
        return is.readObject();
    }

    public static int getColumnIndex(ResultSet rs, String name) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (!rsmd.getColumnName(i).equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new SQLException("Column '" + name + "' not found.");
    }

    public static void writeBigDecimal(Number obj, DataOutput out) throws IOException {
        BigDecimal o = obj instanceof BigDecimal ? (BigDecimal)obj : new BigDecimal(obj.doubleValue());
        int scale = o.scale();
        BigInteger bigint = o.unscaledValue();
        byte[] bytearr = bigint.toByteArray();
        out.writeInt(bytearr.length);
        out.write(bytearr);
        out.writeInt(scale);
    }

    public static BigDecimal readBigDecimal(DataInput in) throws IOException {
        byte[] bytearr = new byte[in.readInt()];
        in.readFully(bytearr);
        BigInteger bigint = new BigInteger(bytearr);
        int scale = in.readInt();
        return new BigDecimal(bigint, scale);
    }

    public static void writeBigInteger(BigInteger o, DataOutput out) throws IOException {
        byte[] bytearr = o.toByteArray();
        out.writeInt(bytearr.length);
        out.write(bytearr);
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        byte[] bytearr = new byte[in.readInt()];
        in.readFully(bytearr);
        return new BigInteger(bytearr);
    }

    public static void writeInteger(Number i, DataOutput out) throws IOException {
        out.writeInt(i.intValue());
    }

    public static Integer readInteger(DataInput in) throws IOException {
        return new Integer(in.readInt());
    }

    public static void writeShort(Number i, DataOutput out) throws IOException {
        out.writeShort(i.intValue());
    }

    public static Short readShort(DataInput in) throws IOException {
        return new Short(in.readShort());
    }

    public static void writeLong(Number l, DataOutput out) throws IOException {
        out.writeLong(l.longValue());
    }

    public static Long readLong(DataInput in) throws IOException {
        return new Long(in.readLong());
    }

    public static void writeFloat(Number f, DataOutput out) throws IOException {
        out.writeInt(Float.floatToIntBits(f.floatValue()));
    }

    public static Float readFloat(DataInput in) throws IOException {
        return new Float(Float.intBitsToFloat(in.readInt()));
    }

    public static void writeDouble(Number d, DataOutput out) throws IOException {
        out.writeLong(Double.doubleToLongBits(d.doubleValue()));
    }

    public static Double readDouble(DataInput in) throws IOException {
        return new Double(Double.longBitsToDouble(in.readLong()));
    }

    public static void writeBoolean(Boolean b, DataOutput out) throws IOException {
        out.writeBoolean(b);
    }

    public static Boolean readBoolean(DataInput in) throws IOException {
        return new Boolean(in.readBoolean());
    }

    public static void writeByte(Number b, DataOutput out) throws IOException {
        out.writeByte(b.byteValue());
    }

    public static Byte readByte(DataInput in) throws IOException {
        return new Byte(in.readByte());
    }

    public static void writeString(String s, DataOutput out) throws IOException {
        byte[] bytes = s.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static String readString(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes);
    }

    public static void writeDate(Date d, DataOutput out) throws IOException {
        out.writeLong(d.getTime());
    }

    public static Date readDate(DataInput in) throws IOException {
        return new Date(in.readLong());
    }

    public static Time readTime(DataInput in) throws IOException {
        return new Time(in.readLong());
    }

    public static Timestamp readTimestamp(DataInput in) throws IOException {
        return new Timestamp(in.readLong());
    }

    public static void writeObject(Object value, int type, boolean isCompoundValue, Aggregator.ValueSerializable serialize, DataOutput out) throws IOException {
        if (value == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (isCompoundValue) {
            if (serialize != null) {
                serialize.serialize(value, type, out);
                return;
            }
            throw new IllegalArgumentException("For compound value,serialize can't be null.");
        }
        switch (type) {
            case 2: 
            case 3: {
                InOutSqlUtil.writeBigDecimal((BigDecimal)value, out);
                break;
            }
            case 5: {
                InOutSqlUtil.writeShort((Number)value, out);
                break;
            }
            case 4: {
                InOutSqlUtil.writeInteger((Number)value, out);
                break;
            }
            case -6: {
                InOutSqlUtil.writeByte((Number)value, out);
                break;
            }
            case -5: {
                InOutSqlUtil.writeLong((Number)value, out);
                break;
            }
            case 7: {
                InOutSqlUtil.writeFloat((Number)value, out);
                break;
            }
            case -7: 
            case 16: {
                InOutSqlUtil.writeBoolean((Boolean)value, out);
                break;
            }
            case 6: 
            case 8: {
                InOutSqlUtil.writeDouble((Number)value, out);
                break;
            }
            case 1: 
            case 12: {
                InOutSqlUtil.writeString((String)value, out);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                InOutSqlUtil.writeDate((Date)value, out);
                break;
            }
            default: {
                throw new IOException("Unsupported type " + type + " .");
            }
        }
    }

    public static Object readObject(int type, boolean isCompoundValue, Aggregator.ValueSerializable serialize, DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        if (isCompoundValue) {
            try {
                if (serialize != null) {
                    return serialize.deserialize(type, in);
                }
                throw new IllegalArgumentException("For compound value,serialzie can't be null.");
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("can't deserialize object.see detail:" + cnfe.getMessage());
            }
        }
        switch (type) {
            case 2: 
            case 3: {
                return InOutSqlUtil.readBigDecimal(in);
            }
            case 6: 
            case 8: {
                return InOutSqlUtil.readDouble(in);
            }
            case 5: {
                return InOutSqlUtil.readShort(in);
            }
            case 4: {
                return InOutSqlUtil.readInteger(in);
            }
            case -6: {
                return InOutSqlUtil.readByte(in);
            }
            case -5: {
                return InOutSqlUtil.readLong(in);
            }
            case 7: {
                return InOutSqlUtil.readFloat(in);
            }
            case -7: 
            case 16: {
                return InOutSqlUtil.readBoolean(in);
            }
            case 1: 
            case 12: {
                return InOutSqlUtil.readString(in);
            }
            case 91: {
                return InOutSqlUtil.readDate(in);
            }
            case 92: {
                return InOutSqlUtil.readTime(in);
            }
            case 93: {
                return InOutSqlUtil.readTimestamp(in);
            }
        }
        throw new IOException("Unsupported type " + type + " .");
    }

    public static final Object[] readJavaRow(ResultSetMetaData meta, DataInput in) throws IOException, SQLException {
        int cols = meta.getColumnCount();
        Object[] row = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            row[i] = InOutSqlUtil.readObject(meta.getColumnType(i + 1), false, null, in);
        }
        return row;
    }

    public static final void writeJavaRow(ResultSetMetaData meta, Object[] row, DataOutput out) throws IOException, SQLException {
        for (int i = 0; i < row.length; ++i) {
            InOutSqlUtil.writeObject(row[i], meta.getColumnType(i + 1), false, null, out);
        }
    }

    public static Object getValue(ResultSet rs, int type, int index) throws SQLException {
        switch (type) {
            case 2: 
            case 3: {
                return rs.getBigDecimal(index);
            }
            case 6: 
            case 8: {
                return new Double(rs.getDouble(index));
            }
            case 7: {
                return new Float(rs.getFloat(index));
            }
            case -5: {
                return new Long(rs.getLong(index));
            }
            case 4: {
                return new Integer(rs.getInt(index));
            }
            case 5: {
                return new Short(rs.getShort(index));
            }
            case -6: {
                return new Byte(rs.getByte(index));
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case -7: 
            case 16: {
                return rs.getBoolean(index);
            }
            case 2004: {
                return rs.getBlob(index);
            }
            case 2005: {
                return rs.getClob(index);
            }
            case 91: {
                return rs.getDate(index);
            }
            case 2003: {
                return rs.getArray(index);
            }
            case 2000: {
                return rs.getObject(index);
            }
            case 0: {
                return null;
            }
            case 92: {
                return rs.getTime(index);
            }
            case 93: {
                return rs.getTimestamp(index);
            }
        }
        return rs.getString(index);
    }

    public static int byte2int(byte[] buf) {
        if (buf == null || buf.length != 4) {
            throw new IllegalArgumentException();
        }
        int ch1 = buf[0] & 0xFF;
        int ch2 = buf[1] & 0xFF;
        int ch3 = buf[2] & 0xFF;
        int ch4 = buf[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static void int2byte(int v, byte[] buf, int start) {
        if (buf == null || buf.length < start + 4) {
            throw new IllegalArgumentException();
        }
        buf[start++] = (byte)(v >>> 24);
        buf[start++] = (byte)(v >>> 16);
        buf[start++] = (byte)(v >>> 8);
        buf[start++] = (byte)v;
    }

    public static byte[] int2byte(int v) {
        byte[] buf = new byte[4];
        InOutSqlUtil.int2byte(v, buf, 0);
        return buf;
    }

    public static int writeUTF(String str, ByteArrayOutputStream out) {
        int strlen = str.length();
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                ++count;
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                count += 3;
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
            count += 2;
        }
        return count;
    }

    public static String readUTF(byte[] bytearr, int offset, int length) throws IOException {
        char[] buf = new char[length * 2];
        return InOutSqlUtil.readUTF(bytearr, offset, length, buf);
    }

    public static String readUTF(byte[] bytearr, int offset, int length, char[] buf) throws IOException {
        int bcount = 0;
        int count = 0;
        block4: while (count < length) {
            int c = bytearr[offset + count];
            if (bcount > buf.length - 4) {
                buf = (char[])InOutSqlUtil.resizeArray(buf, buf.length + length);
            }
            if (c > 0) {
                ++count;
                buf[bcount++] = (char)c;
                continue;
            }
            switch ((c &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((count += 3) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 2];
                    byte char3 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(buf, 0, bcount);
    }

    public static Object resizeArray(Object source, int newsize) {
        Object newarray = Array.newInstance(source.getClass().getComponentType(), newsize);
        int oldsize = Array.getLength(source);
        if (oldsize < newsize) {
            newsize = oldsize;
        }
        System.arraycopy(source, 0, newarray, 0, newsize);
        return newarray;
    }
}

