/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.util;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.ObjectComparator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Util;
import java.util.Map;

public abstract class MemberComparator
implements ObjectComparator {
    Map mapMemberToValue;
    private final boolean desc;

    MemberComparator(Map mapMemberToValue, boolean desc) {
        this.mapMemberToValue = mapMemberToValue;
        this.desc = desc;
    }

    @Override
    public int compare(Object o1, Object o2) throws CUBAException {
        Member m1 = (Member)o1;
        Member m2 = (Member)o2;
        int c = this.compareInternal(m1, m2);
        return c;
    }

    protected abstract int compareInternal(Member var1, Member var2) throws CUBAException;

    protected int compareByValue(Member m1, Member m2) {
        Object value1 = this.mapMemberToValue.get(m1);
        Object value2 = this.mapMemberToValue.get(m2);
        int c = FuncUtil2.compareValues(value1, value2);
        return this.desc ? -c : c;
    }

    protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) throws CUBAException {
        Member prev2;
        Member prev1;
        if (FuncUtil2.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                return -1;
            }
            if (depth1 > depth2) {
                if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                return 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        int c = this.compareByValue(prev1, prev2);
        if (c != 0) {
            return c;
        }
        c = FuncUtil2.compareSiblingMembers(prev1, prev2);
        return c;
    }
}

