/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.base.utils.ReportUtils;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.Mbg820To850UpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.MbgUpdate820RepairUI;
import com.kingdee.eas.ma.mbg.update820to850.client.MbgUpdate820ImportUI;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820MemberInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MbgUpdate820ClientHelper {
    public static final String COL_OLDNUMBER = "number";
    public static final String COL_OLDNAME = "name";
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_SOURCE = "group";
    public static final String COL_NEWNUMBER = "newNumber";
    public static final String COL_NEWNAME = "newName";
    public static final String DEFAULT_SEARCH_TEXT = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)"defaultSearchText");

    public static void loadMember(List<MbgUpdate820MemberInfo> members, List<MbgUpdate820MemberInfo> configMembers, KDTable table, IObjectCollection sources) {
        if (table == null) {
            return;
        }
        table.checkParsed();
        Locale locale = ContextUtils.getLocaleFromEnv();
        table.removeRows();
        if (members == null || members.isEmpty() || sources == null || sources.isEmpty()) {
            return;
        }
        HashMap<String, MbgUpdate820MemberInfo> cMap = new HashMap<String, MbgUpdate820MemberInfo>();
        for (int i = 0; i < configMembers.size(); ++i) {
            cMap.put(configMembers.get(i).getKey(), configMembers.get(i));
        }
        HashMap<String, DimensionSourceInfo> sourceMap = new HashMap<String, DimensionSourceInfo>();
        DimensionSourceInfo source = null;
        for (int i = 0; i < sources.size(); ++i) {
            source = (DimensionSourceInfo)sources.getObject(i);
            sourceMap.put(source.getId().toString(), source);
        }
        IRow row = null;
        MbgUpdate820MemberInfo member = null;
        for (int i = 0; i < members.size(); ++i) {
            member = members.get(i);
            row = table.addRow();
            row.setUserObject((Object)member);
            row.getCell(COL_OLDNUMBER).setValue((Object)member.getNumber());
            if (LocaleUtils.locale_l1.equals(locale)) {
                row.getCell(COL_OLDNAME).setValue((Object)member.getName_l1());
            } else if (LocaleUtils.locale_l2.equals(locale)) {
                row.getCell(COL_OLDNAME).setValue((Object)member.getName_l2());
            } else if (LocaleUtils.locale_l3.equals(locale)) {
                row.getCell(COL_OLDNAME).setValue((Object)member.getName_l3());
            }
            row.getCell(COL_DIMENSION).setValue((Object)((DimensionSourceInfo)sourceMap.get(member.getSource().getId().toString())).getDimension().getName());
            row.getCell(COL_SOURCE).setValue((Object)((DimensionSourceInfo)sourceMap.get(member.getSource().getId().toString())).getAlias());
            if (cMap.containsKey(member.getKey())) {
                row.getCell(COL_NEWNUMBER).setValue((Object)((MbgUpdate820MemberInfo)cMap.get(member.getKey())).getNewNumber());
                row.getCell(COL_NEWNAME).setValue((Object)MbgUpdate820ClientHelper.createMultiLangInfo((MbgUpdate820MemberInfo)cMap.get(member.getKey())));
                continue;
            }
            row.getCell(COL_NEWNUMBER).setValue((Object)member.getNewNumber());
            row.getCell(COL_NEWNAME).setValue((Object)MbgUpdate820ClientHelper.createMultiLangInfo(member));
        }
    }

    private static MultiLangItemList createMultiLangInfo(MbgUpdate820MemberInfo member) {
        List langList = KDBizMultiLangBox.getLanguageList();
        MultiLangItem[] items = new MultiLangItem[langList.size()];
        MultiLangItem currItem = null;
        for (int i = 0; i < langList.size(); ++i) {
            LanguageInfo currentLang = (LanguageInfo)langList.get(i);
            Locale l = currentLang.getLocale();
            if (LocaleUtils.locale_L1.equals(l)) {
                items[i] = new MultiLangItem(currentLang, (Object)member.getNewName_l1());
            } else if (LocaleUtils.locale_L2.equals(l)) {
                items[i] = new MultiLangItem(currentLang, (Object)member.getNewName_l2());
            } else if (LocaleUtils.locale_L3.equals(l)) {
                items[i] = new MultiLangItem(currentLang, (Object)member.getNewName_l3());
            }
            if (!LocaleUtils.getDefaultLocale().equals(l)) continue;
            currItem = items[i];
        }
        MultiLangItemList list = new MultiLangItemList(items);
        list.setCurrentItem(currItem);
        return list;
    }

    public static void initSearchTextField(CoreUI ownerUI, final KDTextField txtSearch, final KDTable table) {
        txtSearch.setText(DEFAULT_SEARCH_TEXT);
        AbstractAction controlAction = new AbstractAction(){
            private static final long serialVersionUID = 1700815282597564634L;

            @Override
            public void actionPerformed(ActionEvent e) {
                txtSearch.grabFocus();
            }
        };
        String actionKey = "grabSearchFocus";
        KeyStroke ks = KeyStroke.getKeyStroke(81, 128, false);
        ownerUI.getActionMap().put(actionKey, controlAction);
        ownerUI.getInputMap(2).put(ks, actionKey);
        txtSearch.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MbgUpdate820ClientHelper.txtSearch_focusLost(txtSearch, table);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MbgUpdate820ClientHelper.txtSearch_focusGained(txtSearch);
            }
        });
    }

    private static void txtSearch_focusLost(KDTextField txtSearch, KDTable table) {
        if (StringUtils.isEmpty((String)txtSearch.getText())) {
            txtSearch.setText(DEFAULT_SEARCH_TEXT);
        }
        MbgUpdate820ClientHelper.searchMember(table, MbgUpdate820ClientHelper.getSearchText(txtSearch));
    }

    private static void txtSearch_focusGained(KDTextField txtSearch) {
        if (txtSearch.getText().trim().equals(DEFAULT_SEARCH_TEXT)) {
            txtSearch.setText("");
        }
    }

    public static String getSearchText(KDTextField txtSearch) {
        if (txtSearch.getText().trim().equals(DEFAULT_SEARCH_TEXT)) {
            return "";
        }
        return txtSearch.getText().trim();
    }

    public static void setNameEditor(KDTable table) {
        table.checkParsed();
        KDBizMultiLangBox f7 = new KDBizMultiLangBox();
        f7.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        f7.setMaxLength(255);
        table.getColumn(COL_NEWNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)f7));
    }

    public static void searchMember(KDTable table, String searchText) {
        IRow row = null;
        String value = null;
        boolean isMartch = false;
        for (int r = 0; r < table.getRowCount(); ++r) {
            isMartch = false;
            row = table.getRow(r);
            if (StringUtils.isEmpty((String)searchText)) {
                isMartch = true;
            } else {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    if (table.getColumn(c).getStyleAttributes().isHided() || (value = StringUtils.cnulls((Object)row.getCell(c).getValue())).indexOf(searchText) < 0) continue;
                    isMartch = true;
                    break;
                }
            }
            row.getStyleAttributes().setHided(!isMartch);
        }
    }

    public static void importMember(CoreUI owner, KDTable tblMain, String title, String type) throws Exception {
        UIContext ctx = new UIContext((Object)owner);
        ctx.put((Object)"table", (Object)tblMain);
        ctx.put((Object)"importTitle", (Object)title);
        ctx.put((Object)"ImportType", (Object)type);
        ctx.put((Object)"template", (Object)MbgUpdate820ClientHelper.loadTempTable(tblMain));
        ctx.put((Object)"sourceType", (Object)RptSrcTypeEnum.PT_BUDGET_REPORT);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgUpdate820ImportUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(title);
        window.show();
    }

    private static KDTable loadTempTable(KDTable tblMain) {
        KDTable tblTemplate = new KDTable();
        for (int i = 0; i < tblMain.getColumnCount(); ++i) {
            tblTemplate.addColumn(i, (IColumn)tblMain.getColumn(i).clone());
        }
        for (int r = 0; r < tblMain.getHeadRowCount(); ++r) {
            tblTemplate.addHeadRow(r, (IRow)tblMain.getHeadRow(r).clone());
        }
        return tblTemplate;
    }

    public static void exportMember(CoreUI owner, KDTable tblMain, String title) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(title);
        ExcelFile ef = new ExcelFile();
        fc.addChoosableFileFilter((FileFilter)ef);
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)ef);
        if (fc.showSaveDialog((Component)owner) == 0) {
            FileFilter filter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                if (filter instanceof ExcelFile) {
                    file = new File(fc.getSelectedFile() + ".xls");
                } else if (filter instanceof Excel2007FileFilter) {
                    file = new File(fc.getSelectedFile() + ".xlsx");
                }
            }
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)owner, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                if (!file.renameTo(new File(file.getPath()))) {
                    MsgBox.showWarning((Component)owner, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"existsFileCantWrite"));
                    return;
                }
            }
            if (filter instanceof ExcelFile) {
                KDSBook kdsBook = new KDSBook("Book");
                KDSSheet kdsSheet = tblMain.getIOManager().saveToKDSSheet(kdsBook, true, false, true, "Sheet1");
                for (int i = 0; i <= kdsSheet.getColumnCount(); ++i) {
                    if (kdsSheet.getColumn(i, false) == null || kdsSheet.getColumn(i, false).getWidth() != 0.0f) continue;
                    kdsSheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)tblMain.getColumn(i).getKDTColumn().getWidth()));
                }
                kdsBook.addSheet(null, kdsSheet);
                ExportManager export = new ExportManager();
                export.exportToExcel(kdsBook, file.getPath());
                kdsBook = null;
            } else if (filter instanceof Excel2007FileFilter) {
                Book book = ReportUtils.getInstance().tranToBook(tblMain, true);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(book);
                bookDataWrapper.setExportFormula(false);
                bookDataWrapper.setExportCustomerFomulas(true);
                bookDataWrapper.setShowValue(true);
                bookDataWrapper.setExportHideCols(true);
                bookDataWrapper.setExportHideRows(true);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                booksc.write(file.getPath());
                book = null;
            }
        }
    }

    public static void storeConfig(CoreUI ownerUi, List<MbgUpdate820MemberInfo> members, KDTable tblMain, IObjectCollection sources) {
        IRow row = null;
        members.clear();
        MbgUpdate820MemberInfo memberInfo = null;
        MultiLangItemList mlil = null;
        tblMain.getEditManager().stopEditing();
        String localeStr = null;
        String newName = null;
        MultiLangItem subItem = null;
        for (int r = 0; r < tblMain.getRowCount(); ++r) {
            row = tblMain.getRow(r);
            memberInfo = (MbgUpdate820MemberInfo)row.getUserObject();
            members.add(memberInfo);
            memberInfo.setNewNumber(MbgUpdate820ClientHelper.getNewNumber(row));
            mlil = (MultiLangItemList)row.getCell(COL_NEWNAME).getValue();
            if (mlil == null) {
                mlil = MbgUpdate820ClientHelper.createMultiLangInfo(memberInfo);
            }
            for (int i = 0; i < mlil.getItems().length; ++i) {
                subItem = mlil.getItems()[i].getLang().equals((Object)mlil.getCurrentItem().getLang()) ? mlil.getCurrentItem() : mlil.getItems()[i];
                localeStr = subItem.getLang().getLocale().toString();
                newName = (String)subItem.getData();
                if (StringUtils.isEmpty((String)newName)) {
                    newName = BgCommCHelper.getStringValue((Object)memberInfo, (String)("name_" + localeStr));
                }
                BgCommCHelper.setValue((Object)memberInfo, (Object)newName, (String)("newName_" + localeStr), String.class);
            }
        }
    }

    public static void verifyData(CoreUI ownerUi, KDTable tblMain, IObjectCollection sources, String type) throws EASBizException, BOSException {
        ArrayList<MbgUpdate820MemberInfo> members = new ArrayList<MbgUpdate820MemberInfo>();
        MbgUpdate820ClientHelper.storeConfig(ownerUi, members, tblMain, sources);
        String detailMsg = Mbg820To850UpdateFacadeFactory.getRemoteInstance().verifyMembers(sources, members, type);
        if (!StringUtils.isEmpty((String)detailMsg)) {
            MsgBox.showDetailAndOK((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)"checkMembersError"), (String)detailMsg, (int)1);
            SysUtil.abort();
        }
    }

    public static String getNewNumber(IRow row) {
        String newNumber = StringUtils.cnulls((Object)row.getCell(COL_NEWNUMBER).getValue());
        if (!StringUtils.isEmpty((String)newNumber)) {
            if (newNumber.length() > 80) {
                newNumber = newNumber.substring(0, 80);
            }
            return newNumber;
        }
        return StringUtils.cnulls((Object)row.getCell(COL_OLDNUMBER).getValue());
    }

    public static void repairData(final CoreUI ownerUi, final String bgTemplateId) throws Exception {
        UIContext uiContext = new UIContext((Object)ownerUi);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgUpdate820RepairUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        MbgUpdate820RepairUI ui = (MbgUpdate820RepairUI)uiWindow.getUIObject();
        final String[] bgPeriodTypeNumbers = ui.getBgPeriodTypeNumbers();
        if (bgPeriodTypeNumbers == null) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)ownerUi);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Mbg820To850UpdateFacadeFactory.getRemoteInstance().repairData(bgTemplateId, true, bgPeriodTypeNumbers[0], bgPeriodTypeNumbers[1]);
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"updateSuccess"));
            }
        });
        dialog.show();
    }
}

