/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgUpdate820ImportUI
extends BgBaseImportUI {
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdate820ImportUI.class);
    public static final String TYPE = "ImportType";
    public static final String TABLE = "table";
    public static final String UITITLE = "importTitle";
    public static final String UITEMPLATETITLE = "importTemplateTitle";
    private static final long serialVersionUID = -1329783012784182116L;

    protected String getImportTitle() {
        return this.getUITitle();
    }

    protected String getType() {
        return (String)this.getUIContext().get(TYPE);
    }

    protected String getTemplateTitle() {
        return this.getUITitle();
    }

    protected void importData(KDSSheet sheet) {
        KDTable table = (KDTable)this.getUIContext().get(TABLE);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(sheet.getRowCount());
        HashMap<String, IRow> rowMap = new HashMap<String, IRow>();
        IRow row = null;
        String number = null;
        String source = null;
        String newNumber = null;
        String newName = null;
        String key = null;
        int COL_Number = table.getColumnIndex("number");
        int COL_Name = table.getColumnIndex("name");
        int COL_Source = table.getColumnIndex("group");
        int COL_NewNumber = table.getColumnIndex("newNumber");
        int COL_NewName = table.getColumnIndex("newName");
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow(r);
            number = (String)row.getCell("number").getValue();
            source = (String)row.getCell("group").getValue();
            key = this.getKey(number, source);
            rowMap.put(key, row);
        }
        ArrayList<HashMap<String, String>> errorLst = new ArrayList<HashMap<String, String>>();
        int successCount = 0;
        int exeCount = 0;
        int in = sheet.getRowCount();
        for (int i = 1; i < in; ++i) {
            ++exeCount;
            this.progressBar.setValue(i);
            number = StringUtils.cnulls((Object)sheet.getCell(i, COL_Number, false).getValue());
            source = StringUtils.cnulls((Object)sheet.getCell(i, COL_Source, false).getValue());
            newNumber = StringUtils.cnulls((Object)sheet.getCell(i, COL_NewNumber, false).getValue());
            newName = StringUtils.cnulls((Object)sheet.getCell(i, COL_NewName, false).getValue());
            if (StringUtils.isEmpty((String)newNumber)) {
                newNumber = number;
            }
            if (!rowMap.containsKey(key = this.getKey(number, source))) {
                if (!this.createErrorMsg(errorLst, i, number, source, "importNoNumber")) continue;
                break;
            }
            row = (IRow)rowMap.get(key);
            if (!BgNumberHelper.checkNumber((String)newNumber)) {
                if (!this.createErrorMsg(errorLst, i, number, source, "importNumberError")) continue;
                break;
            }
            ++successCount;
            row.getCell("newNumber").setValue((Object)newNumber);
            ((MultiLangItemList)row.getCell("newName").getValue()).getCurrentItem().setData((Object)newName);
        }
        ArrayList txtlst = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"importMsg_1"), successCount));
        txtlst.add(map);
        if (sheet.getRowCount() - successCount != 1) {
            map = new HashMap();
            map.put(" ", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"importMsg_2", (Object[])new String[]{String.valueOf(exeCount - successCount)}));
            txtlst.add(map);
        }
        txtlst.addAll(errorLst);
        ArrayList<String> listHeadTitle = new ArrayList<String>();
        listHeadTitle.add(" ");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"LIST_CONTENT", txtlst);
        ctx.put((Object)"LIST_HEAD_TITLE", listHeadTitle);
        String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
        ctx.put((Object)"INVOKE_TIME", (Object)invokeTime);
        ctx.put((Object)"UI_OWNER_TITLE", (Object)this.getImportTitle());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private String getMsgKey(String msgKey) {
        return MbgUpdateHelper.getMsgKey(msgKey, this.getType());
    }

    private boolean createErrorMsg(List<HashMap<String, String>> errorLst, int i, String number, String source, String msgKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(" ", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)this.getMsgKey(msgKey)), i + 1, number, source));
        errorLst.add(map);
        return this.getErrorNum() == 1;
    }

    private String getKey(String number, String source) {
        return number + "_" + source;
    }
}

