/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;

public class BgDecomposeManageHelper {
    public static BgOrgUnitCollection getDecomposeRefOrgUnit(Set orgIds, String bgOrgViewId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)orgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("orgUnitId");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        BgOrgUnitCollection colls = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        return colls;
    }

    public static Map<String, BigDecimal> dealWithRangeFormula(Sheet sheet, String orgNum, String versionNum) {
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        Range range = sheet.getSelectionRange();
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        Cell cell = null;
        Object _obj = null;
        String formulaStr = null;
        Object value = null;
        block0: for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            int rowBegin = block.getRow() > maxRow ? maxRow : block.getRow();
            int rowEnd = block.getRow2() > maxRow ? maxRow : block.getRow2();
            int colBegin = block.getCol() > maxCol ? maxCol : block.getCol();
            int colEnd = block.getCol2() > maxCol ? maxCol : block.getCol2();
            for (int j = rowBegin; j <= rowEnd; ++j) {
                for (int k = colBegin; k <= colEnd; ++k) {
                    cell = sheet.getCell(j, k, true);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    formulaMap.put(formulaStr, (BigDecimal)BgNFSHelper.getValue(cell));
                    String orgUnitNum1 = BgNFSHelper.getItemFormula(cell).getExt("ORGUNIT");
                    String versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                    if (orgUnitNum1 != null && !orgNum.equals(orgUnitNum1)) {
                        formulaMap.put("exitsOtherOrg", null);
                        break block0;
                    }
                    if (versionNumber == null || versionNum.equals(versionNumber)) continue;
                    formulaMap.put("exitsOtherVersion", null);
                    break block0;
                }
            }
        }
        return formulaMap;
    }

    public static Map<String, BigDecimal> getFormulaMapOfBook(Book book, String[] sheetNames, String orgNum, String verisonNum) {
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return formulaMap;
        }
        List sheetList = BgNFSHelper.toList(sheetNames);
        String formulaStr = null;
        Object value = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Object _obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            if (!sheetList.isEmpty() && !sheetList.contains(_sheet.getSheetName())) continue;
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    value = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    String orgUnitNum1 = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNIT");
                    String versionNumber = BgNFSHelper.getItemFormula(_cell).getExt("Version");
                    if (orgUnitNum1 != null && versionNumber != null) {
                        if (!orgNum.equals(orgUnitNum1) || !verisonNum.equals(versionNumber)) continue;
                        formulaMap.put(formulaStr, (BigDecimal)BgNFSHelper.getValue(_cell));
                        continue;
                    }
                    if (!(BgNFSHelper.getValue(_cell) instanceof BigDecimal)) continue;
                    formulaMap.put(formulaStr, (BigDecimal)BgNFSHelper.getValue(_cell));
                }
            }
        }
        return formulaMap;
    }

    public static String dealWithRangeFormulaOrg(Sheet _sheet, String orgNum, String versionNum) {
        Range range = _sheet.getSelectionRange();
        CellBlock _block = null;
        Cell _cell = null;
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        if (range != null && !range.isEmpty()) {
            int size = range.size();
            block0: for (int index = 0; index < size; ++index) {
                _block = range.getBlock(index);
                if (_block == null) continue;
                int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
                int rowEnd = maxRow;
                for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                    int colEnd = maxCol;
                    for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                        _cell = _sheet.getCell(rowBegin, colBegin, false);
                        if (!BgNFSHelper.checkHasItemFormula(_cell)) continue;
                        String orgUnitNum1 = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNIT");
                        String versionNumber = BgNFSHelper.getItemFormula(_cell).getExt("Version");
                        if (orgUnitNum1 == null || versionNumber == null) continue;
                        if (!orgNum.equals(orgUnitNum1)) {
                            orgNum = "exitsOtherOrg";
                            break block0;
                        }
                        if (!versionNum.equals(versionNumber)) {
                            orgNum = "exitsOtherVersion";
                            break block0;
                        }
                        orgNum = orgUnitNum1;
                    }
                }
            }
        }
        return orgNum;
    }

    public static Map<String, BigDecimal> dealWithRangeFormulaVersion(Sheet _sheet, Set<String> formulas, Set<String> versions, Map<String, BgScenarioInfo> scenarioMap) {
        LinkedHashMap<String, BigDecimal> formulaMap = new LinkedHashMap<String, BigDecimal>();
        Range range = _sheet.getSelectionRange();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        CellBlock _block = null;
        Cell _cell = null;
        String _formulaStr = null;
        String versionNumber = null;
        int size = range.size();
        for (int index = 0; index < size; ++index) {
            _block = range.getBlock(index);
            if (_block == null) continue;
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int rowEnd = maxRow;
            for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = maxCol;
                for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                    BgScenarioInfo sceinfo;
                    _cell = _sheet.getCell(rowBegin, colBegin, false);
                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    if (StringUtils.isEmpty((String)_formulaStr)) continue;
                    String[] parama = BgNFSHelper.parseFormulaPara(_formulaStr);
                    versionNumber = BgNFSHelper.getItemFormula(_cell).getExt("Version");
                    if (scenarioMap == null || scenarioMap.isEmpty() || (sceinfo = scenarioMap.get(parama[3])) == null || sceinfo.getType() != BgScenarioType.BudgetData) continue;
                    if (versionNumber != null) {
                        versions.add(versionNumber);
                    }
                    if (BgNFSHelper.getValue(_cell) == null) {
                        formulas.add(_formulaStr);
                        formulaMap.put(_formulaStr, BigDecimal.ZERO);
                    }
                    if (!(BgNFSHelper.getValue(_cell) instanceof BigDecimal)) continue;
                    formulas.add(_formulaStr);
                    formulaMap.put(_formulaStr, (BigDecimal)BgNFSHelper.getValue(_cell));
                }
            }
        }
        return formulaMap;
    }

    public static BgOrgUnitCollection allOrgTree(TreeModel treeModel) {
        BgOrgUnitCollection coll = new BgOrgUnitCollection();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        coll = BgDecomposeManageHelper.selectOrgUnitByIds(coll, root);
        coll.removeObject(0);
        return coll;
    }

    public static BgOrgUnitCollection selectOrgUnitByIds(BgOrgUnitCollection coll, DefaultKingdeeTreeNode root) {
        if (root == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo) {
            bgOrgUnit = (BgOrgUnitInfo)root.getUserObject();
            coll.add(bgOrgUnit);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            BgDecomposeManageHelper.selectOrgUnitByIds(coll, node);
        }
        return coll;
    }
}

