/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public final class BgExportHelper {
    private static Logger logger = Logger.getLogger((String)BgExportHelper.class.getName());

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    private static IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    private static IBgTemplate getBgTemplateInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(String filepath, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) {
        HashSet<BOSUuid> orgRangesSet = new HashSet<BOSUuid>();
        UserInfo userInfo = null;
        BgSchemeInfo _bgSchemeInfo = null;
        FullOrgUnitCollection orgRangesColl = null;
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("orgUnit.id");
        try {
            _bgSchemeInfo = BgExportHelper.getBgSchemeInterface().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), sic);
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
            model = BgNFSHelper.getOrgTreeModel(_bgSchemeInfo.getOrgUnit().getId().toString(), null);
            root = (DefaultKingdeeTreeNode)model.getRoot();
            orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()));
            for (int i = 0; i < orgRangesColl.size(); ++i) {
                orgRangesSet.add(orgRangesColl.get(i).getId());
            }
            BgExportHelper.exportOrgUnit(root, _bgSchemeInfo, bgPeriodInfo, currencyInfo, filepath, orgRangesSet);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private static void exportOrgUnit(DefaultKingdeeTreeNode node, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo, String filepath, Set orgRangeSet) throws Exception {
        FullOrgUnitInfo orgUnitInfo;
        OrgStructureInfo oui;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null && orgRangeSet.contains((orgUnitInfo = oui.getUnit()).getId())) {
            String _tmpFilepath = filepath + "/" + orgUnitInfo.getName().trim();
            BgExportHelper.saveOrgFlepath(_tmpFilepath, orgUnitInfo);
            try {
                BgExportHelper.saveExcelFile(_tmpFilepath, orgUnitInfo, bgSchemeInfo, bgPeriodInfo, currencyInfo);
            }
            catch (Exception ex) {
                logger.error((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"currentOrgExportError", (Object[])new String[]{orgUnitInfo.getName()}));
                logger.error((Object)ex);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                BgExportHelper.exportOrgUnit(_node, bgSchemeInfo, bgPeriodInfo, currencyInfo, _tmpFilepath, orgRangeSet);
            }
        }
    }

    private static void saveOrgFlepath(String filepath, FullOrgUnitInfo orgUnitInfo) {
        File orgFile = new File(filepath);
        if (!orgFile.exists()) {
            orgFile.mkdir();
        }
        orgFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveExcelFile(String filepath, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgTemplateCollection _col = null;
        try {
            _col = BgExportHelper.getBgSchemeByCurrOrgUnit(orgUnitInfo, bgSchemeInfo);
            if (_col != null && !_col.isEmpty()) {
                Iterator iter = _col.iterator();
                while (iter.hasNext()) {
                    try {
                        _bgTemplateInfo = (BgTemplateInfo)iter.next();
                        _bgTemplateInfo = BgExportHelper.getBgTemplateInfo(_bgTemplateInfo);
                        BgExportHelper.saveBgTemplateToExcelFile(filepath, orgUnitInfo, _bgSchemeInfo, _bgTemplateInfo, bgPeriodInfo, currencyInfo);
                    }
                    catch (Exception ex) {
                        if (_bgTemplateInfo != null) {
                            logger.error((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"currentOrgExportErrorDetail", (Object[])new String[]{orgUnitInfo.getName(), bgSchemeInfo.getName(), _bgTemplateInfo.getName()}));
                        }
                        logger.error((Object)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private static void saveBgTemplateToExcelFile(String filepath, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws Exception {
        String filename = filepath + "/" + BgExportHelper.getFileName(orgUnitInfo, bgSchemeInfo, bgTemplateInfo, bgPeriodInfo, currencyInfo);
        BgExportHelper.checkFile(filename);
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Object object = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        try {
            _book = bgTemplateInfo.getBook();
            _kdsBook = BookToKDSBook.traslate((Book)_book);
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                _kdsSheet = _kdsBook.getSheet((Object)new Integer(sheetIndex));
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (BgNFSHelper.checkIsEmptyValue(_cell)) continue;
                        _kdsCell = _kdsSheet.getCell(rowIndex, colIndex, true);
                        if (BgNFSHelper.checkHasExpression(_cell) && _cell.getValue().getValue() instanceof SyntaxErrorException) {
                            object = Variant.nullVariant;
                            _kdsCell.setText("");
                        } else {
                            object = BgNFSHelper.getValue(_cell);
                        }
                        _kdsCell.setValue(object);
                    }
                }
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                BgExportHelper.saveFile(_kdsBook, filename);
                logger.info((Object)(filename + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"22_BgExportHelper")));
                _kdsBook = null;
                throw throwable;
            }
        }
        BgExportHelper.saveFile(_kdsBook, filename);
        logger.info((Object)(filename + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"22_BgExportHelper")));
        _kdsBook = null;
    }

    private static BgTemplateCollection getBgSchemeByCurrOrgUnit(FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo) throws Exception {
        BgTemplateCollection _col = null;
        SelectorItemCollection sic = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        _col = BgExportHelper.getBgTemplateInterface().getBgTemplateCollection(view);
        return _col;
    }

    private static BgTemplateInfo getBgTemplateInfo(BgTemplateInfo bgTemplateInfo) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("data");
        BgTemplateInfo _bgTemplateInfo = null;
        _bgTemplateInfo = BgExportHelper.getBgTemplateInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateInfo.getId()), sic);
        return _bgTemplateInfo;
    }

    private static String getFileName(FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) {
        StringBuffer filename = new StringBuffer();
        filename.append(orgUnitInfo.getName().trim());
        filename.append("_");
        filename.append(bgSchemeInfo.getName().trim());
        filename.append("_");
        filename.append(bgTemplateInfo.getName().trim());
        filename.append("_");
        filename.append(bgPeriodInfo.getName().trim());
        filename.append("_");
        filename.append(currencyInfo.getName().trim());
        filename.append(".xls");
        return filename.toString();
    }

    private static void checkFile(String filename) throws Exception {
        if (StringUtils.isEmpty((String)filename)) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"23_BgExportHelper")});
        }
        File file = null;
        try {
            file = new File(filename);
            if (file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            file = null;
        }
    }

    private static void saveFile(KDSBook book, String filename) {
        if (book == null || StringUtils.isEmpty((String)filename)) {
            return;
        }
        try {
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
            em.exportToExcel(book, filename);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }
}

