/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeFactory;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.IBgTemplateNode;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgSheetManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgExportStyleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgExportUtils {
    private static final Logger logger = Logger.getLogger(BgExportUtils.class);
    public static final String DEFAULT_FILE_PATH = BgCommHelper.getDefaultDirtory() + "/";
    public static final int INDEX_CURRENCY = 0;
    public static final int INDEX_BGPERIOD = 1;
    public static final int INDEX_BGVERSION = 2;
    public static final int COL_DIMINFO_INDEX = 2;
    public static final int BODY_INDEX = 3;
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource";
    public static final char[] ESC = new char[]{'\\', '/', ':', '*', '|', '?', '\"', '<', '>'};
    public static final char ESC_CONVERT = '_';
    public BgSchemeInfo bgScheme = null;
    public List<String> billIds = null;
    public Object[] expObjs = null;
    public BgOrgUnitInfo bgOrgUnit = null;
    public BgOrgUnitCollection orgUnits = null;
    public Map<String, BgOrgUnitInfo> filepaths = null;
    private Map<String, MbgDimInfo> mbgNumMap = new HashMap<String, MbgDimInfo>();
    private Map<String, Map<String, String[]>> memberCacheMap = new HashMap<String, Map<String, String[]>>();
    private BgExportStyleUtils expUtils = new BgExportStyleUtils(this);
    private Map<BOSUuid, List<String>> warnings = new HashMap<BOSUuid, List<String>>();
    public List<List<String>> result = new ArrayList<List<String>>();
    public List<String> succeed = new ArrayList<String>();
    public List<String> defeated = new ArrayList<String>();
    public List<String> warning = new ArrayList<String>();

    public BgExportUtils() {
        this.result.add(this.succeed);
        this.result.add(this.defeated);
        this.result.add(this.warning);
    }

    protected BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    protected List<String> getBillIds() {
        return this.billIds;
    }

    protected Object[] getExpObjs() {
        return this.expObjs;
    }

    protected void setBgOrgUnit(BgOrgUnitInfo bgOrgUnit) {
        this.bgOrgUnit = bgOrgUnit;
    }

    protected BgOrgUnitInfo getBgOrgUnit() {
        return this.bgOrgUnit;
    }

    protected void setOrgUnits(BgOrgUnitCollection orgUnits) {
        this.orgUnits = orgUnits;
    }

    protected BgOrgUnitCollection getOrgUnits() {
        return this.orgUnits;
    }

    protected void setFilepaths(Map<String, BgOrgUnitInfo> filepaths) {
        this.filepaths = filepaths;
    }

    protected Map<String, BgOrgUnitInfo> getFilepaths() {
        return this.filepaths;
    }

    protected Map<String, MbgDimInfo> getMbgNumMap() {
        return this.mbgNumMap;
    }

    protected Map<String, Map<String, String[]>> getMemberCacheMap() {
        return this.memberCacheMap;
    }

    protected BgExportStyleUtils getExpUtils() {
        return this.expUtils;
    }

    public List<String> getWarnings(BOSUuid billId) {
        if (billId == null) {
            return null;
        }
        List<String> tmpList = this.warnings.get(billId);
        if (tmpList == null) {
            tmpList = new ArrayList<String>();
            this.warnings.put(billId, tmpList);
        }
        return tmpList;
    }

    public static void setDefaultFilePath(KDTextField textField) {
        File file;
        if (textField != null && (file = new File(DEFAULT_FILE_PATH)).isDirectory()) {
            textField.setText(DEFAULT_FILE_PATH);
        }
    }

    public static void selectFilePath(Component component, KDTextField textField, boolean hasExport) {
        String path = textField != null && !StringUtils.isEmpty((String)textField.getText()) ? textField.getText() : DEFAULT_FILE_PATH;
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgCommCHelper.getMessageStr((String)RESOURCE, (String)(hasExport ? "export_local" : "import_local")));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showOpenDialog(component) == 0) {
            File file = fc.getSelectedFile();
            if (textField != null) {
                textField.setText(file.getPath());
            }
        }
    }

    public Map<String, BgOrgUnitInfo> exportOrgUnitPath(String filepath) throws BOSException, EASBizException {
        LinkedHashMap<String, BgOrgUnitInfo> filepaths = new LinkedHashMap<String, BgOrgUnitInfo>();
        if (StringUtils.isEmpty((String)filepath) || this.getOrgUnits() == null || this.getOrgUnits().isEmpty()) {
            return filepaths;
        }
        HashMap<String, String> numNameMap = new HashMap<String, String>();
        int in = this.getOrgUnits().size();
        for (int i = 0; i < in; ++i) {
            this.exportOrgUnitPath(filepath, this.getOrgUnits().get(i), numNameMap, filepaths);
        }
        return filepaths;
    }

    private void exportOrgUnitPath(String filepath, BgOrgUnitInfo bgOrgUnit, Map<String, String> numNameMap, Map<String, BgOrgUnitInfo> filepaths) {
        if (StringUtils.isEmpty((String)filepath) || bgOrgUnit == null || numNameMap == null) {
            return;
        }
        numNameMap.put(bgOrgUnit.getNumber(), bgOrgUnit.getName().trim());
        String[] tmpStrs = bgOrgUnit.getLongNumber().split("!");
        if (tmpStrs != null) {
            String tmpFilePath = filepath;
            String tmpName = null;
            for (int i = 0; i < tmpStrs.length; ++i) {
                tmpName = numNameMap.get(tmpStrs[i]);
                if (tmpName == null) continue;
                tmpFilePath = tmpFilePath + "/" + tmpName;
            }
            File file = new File(tmpFilePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            filepaths.put(tmpFilePath, bgOrgUnit);
        }
    }

    public List<List<String>> exportTemplate() throws BOSException, EASBizException {
        int i;
        if (this.getBgScheme() == null || this.getBillIds() == null || this.getBillIds().isEmpty() || this.getFilepaths() == null || this.getFilepaths().isEmpty()) {
            return this.result;
        }
        IBgTemplate iTemplate = BgTemplateFactory.getRemoteInstance();
        IBgTemplateNode iTemplateNode = BgTemplateNodeFactory.getRemoteInstance();
        BgTemplateInfo templateInfo = null;
        Object templateNodeInfo = null;
        IMbgViewBase viewBase = null;
        IMbgViewManager viewManager = null;
        MbgViewListManager viewListManager = null;
        MbgDimInfo mbgDim = null;
        Context ctx = new Context();
        Object pstmt = null;
        Object rst = null;
        boolean hasCopy = false;
        int formType = 0;
        String filename = null;
        String filepath = null;
        Object[] objs = null;
        Map.Entry<String, BgOrgUnitInfo> entry2 = null;
        BgOrgUnitInfo bgOrgUnit = null;
        MbgDimCollection mbgDims = MbgDimFactory.getRemoteInstance().getMbgDimCollection();
        DimUtils.addDefaultMbgDim(mbgDims, null);
        Set<String> mbgDimNums = this.getBgScheme().getDimNums();
        int in = mbgDims.size();
        for (i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (!mbgDimNums.contains(mbgDim.getNumber())) continue;
            this.getMbgNumMap().put(mbgDim.getNumber(), mbgDim);
        }
        in = this.getBillIds().size();
        for (i = 0; i < in; ++i) {
            templateInfo = iTemplate.getBgTemplateInfo((IObjectPK)new ObjectStringPK(this.getBillIds().get(i)), null);
            BgOrgUnitCollection bgOrgUnitCollection = iTemplate.getDispatchOrgunitsByBgTemplateID(templateInfo.getId());
            ArrayList<String> bgOrgUnitIds = new ArrayList<String>();
            for (int j = 0; j < bgOrgUnitCollection.size(); ++j) {
                bgOrgUnitIds.add(bgOrgUnitCollection.get(j).getId().toString());
            }
            formType = templateInfo.getFormType().getValue();
            if (0 == formType) {
                try {
                    for (Map.Entry<String, BgOrgUnitInfo> entry2 : this.getFilepaths().entrySet()) {
                        filepath = entry2.getKey();
                        filename = this.getFileName(filepath, templateInfo);
                        bgOrgUnit = entry2.getValue();
                        if (!bgOrgUnitIds.contains(bgOrgUnit.getOrgUnitID())) continue;
                        objs = this.getBookFixViewTemplate(templateInfo, viewManager, bgOrgUnit);
                        this.saveFile(filename, objs);
                    }
                    this.succeed.add(templateInfo.getNumber());
                }
                catch (Exception ex) {
                    logger.error((Object)"template view parse error:", (Throwable)ex);
                    this.defeated.add(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"styleexport_error", (Object[])new Object[]{templateInfo.getNumber(), ex.getCause()}) + "\r\n");
                }
                continue;
            }
            if (8 == formType) {
                this.defeated.add(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"styleexport_spec", (Object[])new Object[]{templateInfo.getNumber()}) + "\r\n");
                continue;
            }
            try {
                viewBase = templateInfo.getView();
                if (viewBase instanceof MbgViewListManager) {
                    viewListManager = (MbgViewListManager)viewBase;
                    Map result = ViewListFacadeFactory.getRemoteInstance().initTemplateData(templateInfo, null, templateInfo.getOrgUnit().getId().toString(), false);
                    viewListManager = (MbgViewListManager)result.get("dimensino.member");
                    if (!this.check(templateInfo, viewListManager)) continue;
                    for (Map.Entry<String, BgOrgUnitInfo> entry2 : this.getFilepaths().entrySet()) {
                        filepath = entry2.getKey();
                        filename = this.getFileName(filepath, templateInfo);
                        bgOrgUnit = entry2.getValue();
                        if (!bgOrgUnitIds.contains(bgOrgUnit.getOrgUnitID())) continue;
                        objs = this.getBookFromViewListTemplate(templateInfo, viewListManager, bgOrgUnit);
                        this.saveFile(filename, objs);
                    }
                    this.succeed.add(templateInfo.getNumber());
                    continue;
                }
                if (!(viewBase instanceof IMbgViewManager)) continue;
                viewManager = (IMbgViewManager)viewBase;
                for (Map.Entry<String, BgOrgUnitInfo> entry2 : this.getFilepaths().entrySet()) {
                    filepath = entry2.getKey();
                    filename = this.getFileName(filepath, templateInfo);
                    bgOrgUnit = entry2.getValue();
                    objs = this.getBookFromViewTemplate(templateInfo, viewManager, bgOrgUnit);
                    this.saveFile(filename, objs);
                }
                this.succeed.add(templateInfo.getNumber());
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"template view parse error:", (Throwable)ex);
                this.defeated.add(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"styleexport_error", (Object[])new Object[]{templateInfo.getNumber(), ex.getCause()}) + "\r\n");
            }
        }
        return this.result;
    }

    protected boolean check(BgTemplateInfo templateInfo, MbgViewListManager viewListManager) {
        boolean check = true;
        if (templateInfo == null || viewListManager == null || this.result == null) {
            return false;
        }
        MbgViewListSheetManager sheetManager = null;
        MbgViewListDimensionManager dimManager = null;
        IMbgViewListObject object = null;
        MbgViewListRowCol viewListRowCol = null;
        int in = viewListManager.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            sheetManager = (MbgViewListSheetManager)viewListManager.getSheetManagers().get(i);
            dimManager = sheetManager.getDimensionManager();
            int rowSize = 0;
            int jn = dimManager.getRows().size();
            for (int j = 0; j < jn; ++j) {
                object = dimManager.getRows().get(j);
                if (!(object instanceof MbgViewListRowCol)) continue;
                viewListRowCol = (MbgViewListRowCol)object;
                ++rowSize;
                if (viewListRowCol.getRelationMaps().isEmpty()) continue;
                this.defeated.add(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"styleexport_relation", (Object[])new Object[]{templateInfo.getNumber()}) + "\r\n");
                check = false;
                break;
            }
            if (rowSize <= true) continue;
            this.defeated.add(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"styleexport_muiltgroup", (Object[])new Object[]{templateInfo.getNumber()}) + "\r\n");
            check = false;
            break;
        }
        return check;
    }

    protected Object[] getBookFromViewListTemplate(BgTemplateInfo templateInfo, MbgViewListManager viewListManager, BgOrgUnitInfo bgOrgUnit) throws Exception {
        if (templateInfo == null || viewListManager == null || bgOrgUnit == null) {
            return null;
        }
        MbgViewListSheetManager sheetManager = null;
        MbgViewListDimensionManager dimManager = null;
        KDSBook book = new KDSBook(null);
        KDSSheet sheet = null;
        int templateType = templateInfo.getFormType().getValue();
        Integer[] coordinate = new Integer[]{0, 0};
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(10);
        int in = viewListManager.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            sheetManager = (MbgViewListSheetManager)viewListManager.getSheetManagers().get(i);
            dimManager = sheetManager.getDimensionManager();
            sheet = new KDSSheet(book, sheetManager.getSheetName(), (ShareStyleAttributes)sa);
            coordinate[0] = 0;
            coordinate[1] = 0;
            this.getExpUtils().outViewAndPage(templateType, dimManager.getViewDimension(), sheet, coordinate, bgOrgUnit);
            this.getExpUtils().outViewAndPage(templateType, dimManager.getPageDimension(), sheet, coordinate, bgOrgUnit);
            coordinate[0] = 3;
            coordinate[1] = 0;
            this.getExpUtils().outRowAndCol(templateType, dimManager.getRows(), dimManager.getColumns(), sheet, coordinate, bgOrgUnit);
            book.addSheet(null, sheet);
        }
        this.getExpUtils().outCommInfo(book, templateInfo, bgOrgUnit, this.expObjs);
        Object[] objs = new Object[]{book, null};
        return objs;
    }

    protected Object[] getBookFromViewTemplate(BgTemplateInfo templateInfo, IMbgViewManager viewManager, BgOrgUnitInfo bgOrgUnit) throws Exception {
        if (templateInfo == null || viewManager == null || bgOrgUnit == null) {
            return null;
        }
        MbgSheetManagerImpl sheetManager = null;
        BgDimensionManagerImpl dimManager = null;
        KDSBook book = new KDSBook(null);
        KDSSheet sheet = null;
        int templateType = templateInfo.getFormType().getValue();
        Integer[] coordinate = new Integer[]{0, 0};
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(10);
        int in = viewManager.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            sheetManager = (MbgSheetManagerImpl)viewManager.getSheetManagers().get(i);
            dimManager = (BgDimensionManagerImpl)sheetManager.getDimensionManager();
            sheet = new KDSSheet(book, sheetManager.getSheetName(), (ShareStyleAttributes)sa);
            coordinate[0] = 0;
            coordinate[1] = 0;
            this.expUtils.outViewAndPage(templateType, dimManager.getViewDimension(), sheet, coordinate, bgOrgUnit);
            this.expUtils.outViewAndPage(templateType, dimManager.getPageDimension(), sheet, coordinate, bgOrgUnit);
            coordinate[0] = 3;
            coordinate[1] = 0;
            this.expUtils.outRowAndCol(templateType, dimManager.getRowDimension(), dimManager.getColDimension(), sheet, coordinate, bgOrgUnit);
            book.addSheet(null, sheet);
        }
        this.expUtils.outCommInfo(book, templateInfo, bgOrgUnit, this.expObjs);
        Object[] objs = new Object[]{book, null};
        return objs;
    }

    protected Object[] getBookFixViewTemplate(BgTemplateInfo templateInfo, IMbgViewManager viewManager, BgOrgUnitInfo bgOrgUnit) throws Exception {
        if (templateInfo == null || bgOrgUnit == null) {
            return null;
        }
        KDSBook book = BookToKDSBook.traslate((Book)templateInfo.getBook());
        this.expUtils.outCommInfo(book, templateInfo, bgOrgUnit, this.expObjs);
        Object[] objs = new Object[]{book, null};
        return objs;
    }

    protected String getFileName(String filepath, BgTemplateInfo templateInfo) {
        if (templateInfo == null || this.getExpObjs() == null || this.getExpObjs().length <= 2) {
            return null;
        }
        CurrencyInfo currency = (CurrencyInfo)this.getExpObjs()[0];
        BgPeriodInfo bgPeriod = (BgPeriodInfo)this.getExpObjs()[1];
        BgVersionInfo bgVersion = (BgVersionInfo)this.getExpObjs()[2];
        if (currency == null || bgPeriod == null || bgVersion == null) {
            return null;
        }
        String filename = bgPeriod.getName().trim() + "-" + templateInfo.getName().trim() + "-" + bgVersion.getName().trim() + "-" + currency.getName().trim() + ".xls";
        filename = filepath + filepath.substring(filepath.lastIndexOf("/"), filepath.length()) + "-" + BgExportUtils.convert(filename, '_');
        return filename;
    }

    public static String convert(String name, char replaceChar) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int in = name.length();
        for (int i = 0; i < in; ++i) {
            char _char = name.charAt(i);
            for (int j = 0; j < ESC.length; ++j) {
                if (_char != ESC[j]) continue;
                _char = replaceChar;
                break;
            }
            str.append(_char);
        }
        return str.toString();
    }

    protected void saveFile(String filename, Object[] exports) {
        if (StringUtils.isEmpty((String)filename) || exports == null || exports.length == 0) {
            return;
        }
        KDSBook book = (KDSBook)exports[0];
        this.saveFile(book, filename);
    }

    public static boolean checkFile(String filename) {
        boolean check = false;
        if (StringUtils.isEmpty((String)filename)) {
            return check;
        }
        File file = new File(filename);
        if (file.exists()) {
            String tmpFilename = filename + ".tmpfile";
            File tmpFile = new File(tmpFilename);
            if (file.renameTo(tmpFile)) {
                tmpFile.renameTo(file);
                check = true;
            }
        } else {
            check = true;
        }
        return check;
    }

    protected boolean saveFile(KDSBook book, String filename) {
        boolean re = false;
        if (book == null || StringUtils.isEmpty((String)filename)) {
            return false;
        }
        boolean canSave = BgExportUtils.checkFile(filename);
        if (canSave) {
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
            em.exportToExcel(book, filename);
            re = true;
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String srcfilename, String distFilename) {
        if (StringUtils.isEmpty((String)srcfilename) || StringUtils.isEmpty((String)distFilename)) {
            return;
        }
        File srcfile = new File(srcfilename);
        File distFile = new File(distFilename);
        if (srcfile.exists()) {
            if (distFile.exists()) {
                distFile.delete();
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            AbstractInterruptibleChannel fcin = null;
            AbstractInterruptibleChannel fcout = null;
            try {
                fis = new FileInputStream(srcfile);
                fos = new FileOutputStream(distFile);
                fcin = fis.getChannel();
                fcout = fos.getChannel();
                ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
                fis.close();
                fos.close();
            }
            catch (IOException ex) {
                logger.error((Object)"file copy error:", (Throwable)ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fcin != null) {
                        fcin.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (fcout != null) {
                        fcout.close();
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)"file copy error:", (Throwable)ex);
                }
            }
        }
    }

    public static void transBgPeriodMember(BgDimensionBaseInfo dimension, Map<String, Map<String, String[]>> memberCacheMap, BgPeriodInfo bgPeriod) throws BOSException {
        if (dimension == null || memberCacheMap == null || bgPeriod == null) {
            return;
        }
        if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
            return;
        }
        Object obj = null;
        String[] tmpStrs = null;
        MbgViewListDimensionInfo viewDim = null;
        BgDimensionMember member = null;
        BgPeriodInfo _bgPeriod = null;
        try {
            BgPeriodCollection colls;
            int x;
            HashSet<String> bgPeriodNums = new HashSet<String>();
            Map<String, String[]> periodMemMap = memberCacheMap.get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
            if (periodMemMap == null) {
                periodMemMap = new HashMap<String, String[]>();
                memberCacheMap.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, periodMemMap);
            }
            if (!dimension.getMember().isEmpty()) {
                int xn = dimension.getMember().size();
                for (x = 0; x < xn; ++x) {
                    member = (BgDimensionMember)dimension.getMember().get(x);
                    if (BgPeriodNVariableHelper.checkCanConvert((String)member.getNumber())) {
                        member.setNumber(BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)member.getNumber(), (int)bgPeriod.getPeriodType().getValue()));
                    }
                    if (periodMemMap.containsKey(member.getNumber())) continue;
                    bgPeriodNums.add(member.getNumber());
                }
            } else {
                ArrayList<BgDimensionMember> selMembers = new ArrayList<BgDimensionMember>();
                if (dimension instanceof MbgViewListDimensionInfo && !(viewDim = (MbgViewListDimensionInfo)dimension).getSelectMembers().isEmpty()) {
                    int xn = viewDim.getSelectMembers().size();
                    for (int x2 = 0; x2 < xn; ++x2) {
                        obj = viewDim.getSelectMembers().get(x2);
                        if (!(obj instanceof BgPeriodInfo) || !BgPeriodNVariableHelper.checkCanConvert((String)(_bgPeriod = (BgPeriodInfo)obj).getNumber())) continue;
                        _bgPeriod.setNumber(BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)_bgPeriod.getNumber(), (int)bgPeriod.getPeriodType().getValue()));
                        if (!periodMemMap.containsKey(_bgPeriod.getNumber())) {
                            bgPeriodNums.add(_bgPeriod.getNumber());
                        }
                        member = new BgDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, _bgPeriod.getName(), _bgPeriod.getNumber());
                        selMembers.add(member);
                    }
                }
                if (!selMembers.isEmpty()) {
                    dimension.getMember().addAll(selMembers);
                }
            }
            if (!bgPeriodNums.isEmpty() && (colls = MbgDataHelper.getBgPeriods(bgPeriodNums)) != null) {
                BgPeriodInfo periodInfo = null;
                int xn = colls.size();
                for (int x3 = 0; x3 < xn; ++x3) {
                    periodInfo = colls.get(x3);
                    tmpStrs = new String[]{periodInfo.getNumber(), periodInfo.getLongNumber(), periodInfo.getName(), periodInfo.getId().toString()};
                    periodMemMap.put(tmpStrs[0], tmpStrs);
                }
            }
            int xn = dimension.getMember().size();
            for (x = 0; x < xn; ++x) {
                member = (BgDimensionMember)dimension.getMember().get(x);
                if (!periodMemMap.containsKey(member.getNumber())) continue;
                member.setName(periodMemMap.get(member.getNumber())[2]);
            }
        }
        catch (BgPeriodException ex) {
            logger.error((Object)"bgPeriod number trans error:", (Throwable)ex);
        }
    }

    public static void filterMember(BgOrgUnitInfo bgOrgUnit, String mbgDimNum, Collection<String> members) {
    }
}

