/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.MbgAdjustFormulaTypeEnum;
import com.kingdee.eas.ma.mbg.MbgMemberFacadeFactory;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExpressionHelper {
    private static final Logger logger = Logger.getLogger(BgExpressionHelper.class);
    public static final String ACCT_EXPR_NAME = "ACCT";
    public static final String MBGCONTROL_EXPR_NAME = "MBGCONTROL";
    public static final String ACCT_ITEM_ORG = "ACCT_ITEM_ORG";
    public static final String MBGELIMDATA = "ElimData";
    public static final String MBGINACCT = "INACCT";
    private static Map<String, Map<String, Object>> allExprCacheMap = new HashMap<String, Map<String, Object>>();
    private static final String CLIENT_CTX = "CLIENT_CTX";
    public static String MbgAggregateStr = "MbgAggregate";
    public static String MbgAdjustStr = "Mbgadjust";
    public static String MbgAdjustDateStr = "MbgAdjustDate";
    public static String MbgBgAvlBalStr = "MbgBgAvlBal";
    public static String MbgControlStr = "MbgControl";
    public static String BgCslStr = "MbgCsl";
    public static String MbgRefBgTemplateStr = "MbgRefBgTem";
    public static String MbgRefBgFormStr = "MbgRefBgForm";
    public static String MbgActualDayStr = "MbgActualDay";
    public static String MbgCorUnitStr = "MbgCorUnit";
    public static String ERROR_MSG = "ERROR_MSG";
    public static String PARAMS_COUNT = "PARAMS_COUNT";
    public static String DIMENSION_MEMBER = "DIMENSION_MEMBER";
    public static String ORGTREE = "ORGTREE";
    public static String GROUPORG = "GROUPORG";
    public static String COSTCENTERUNIT = "COSTCENTERUNIT";
    public static String FUNCIONNAME = "FUNCIONNAME";
    public static String EXPRESSION = "EXPRESSION";
    public static String SHEETNAME = "SHEETNAME";
    public static String CELLNAME = "CELLNAME";
    public static String BgFormMsgResource = "com.kingdee.eas.ma.mbg.BgFormMsgResource";

    public static Expression checkExpression(Context ctx, Expression expression, IObjectValue model) throws Exception {
        return BgExpressionHelper.checkExpression(ctx, expression, model, false);
    }

    public static Expression checkExpression(Context ctx, Expression expression, IObjectValue model, boolean isCsl) throws Exception {
        if (expression == null) {
            return expression;
        }
        if (expression instanceof FunctionExpr) {
            expression = BgExpressionHelper.checkFunctionExpr(ctx, (FunctionExpr)expression, model, isCsl);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgExpressionHelper.checkBinaryOperationExpr(ctx, (BinaryOperationExpr)expression, model, isCsl);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgExpressionHelper.checkUnaryOperationExpr(ctx, (UnaryOperationExpr)expression, model);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(Context ctx, FunctionExpr funExpr, IObjectValue model, boolean isCsl) throws Exception {
        if (funExpr == null) {
            return funExpr;
        }
        if (ACCT_EXPR_NAME.equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = BgExpressionHelper.checkAcctExpr(ctx, funExpr, model);
        } else if (MBGCONTROL_EXPR_NAME.equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = BgExpressionHelper.checkMbgControlExpr(ctx, funExpr, model);
        } else if (MBGELIMDATA.equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = BgExpressionHelper.checkElimDataExprOrg(ctx, funExpr, model, null, isCsl);
        } else if (MBGINACCT.equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = BgExpressionHelper.checkInAcctExpr(ctx, funExpr, model, null);
        }
        return funExpr;
    }

    private static Expression checkBinaryOperationExpr(Context ctx, BinaryOperationExpr boExpr, IObjectValue model, boolean isCsl) throws Exception {
        if (boExpr == null) {
            return boExpr;
        }
        boExpr.left = BgExpressionHelper.checkExpression(ctx, boExpr.left, model, isCsl);
        boExpr.right = BgExpressionHelper.checkExpression(ctx, boExpr.right, model, isCsl);
        return boExpr;
    }

    private static Expression checkUnaryOperationExpr(Context ctx, UnaryOperationExpr uoExpr, IObjectValue model) throws Exception {
        return uoExpr;
    }

    public static FunctionExpr checkInAcctExpr(Context ctx, FunctionExpr funExpr, IObjectValue model, OrgUnitInfo curOrgUnit) throws Exception {
        Object paramObjectItem;
        if (funExpr == null || funExpr.parameters.size() == 0 || model == null) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        OrgUnitInfo orgUnit = null;
        OrgUnitInfo company = null;
        if (curOrgUnit != null) {
            orgUnit = curOrgUnit;
        } else if (model instanceof BgFormInfo) {
            orgUnit = ((BgFormInfo)model).getOrgUnit();
        } else if (model instanceof BgActualRecordInfo) {
            orgUnit = ((BgActualRecordInfo)model).getBgForm().getOrgUnit();
        } else if (model instanceof BgAnalysReportInfo) {
            orgUnit = ((BgAnalysReportInfo)model).getOrgUnit();
        }
        if (orgUnit == null) {
            return funExpr;
        }
        Object paramObject = funExpr.parameters.get(0);
        if (paramObject instanceof ReferenceExpr || paramObject instanceof Ref3DExpr || paramObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param2 = (StringExpr)paramObject;
        if (StringUtils.isEmpty((String)param2.value) && orgUnit != null) {
            if (companyMap.containsKey(orgUnit.getId())) {
                company = (OrgUnitInfo)companyMap.get(orgUnit.getId());
            } else {
                company = BgExpressionHelper.getCompanyInfo(ctx, orgUnit);
                if (company == null) {
                    company = orgUnit;
                } else {
                    companyMap.put(orgUnit.getId(), (CompanyOrgUnitInfo)company);
                }
            }
            if (company != null) {
                param2.value = company.getNumber();
            }
        }
        if ((paramObjectItem = funExpr.parameters.get(1)) instanceof ReferenceExpr || paramObjectItem instanceof Ref3DExpr || paramObjectItem instanceof BinaryOperationExpr || paramObjectItem instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param1 = (StringExpr)paramObjectItem;
        if (StringUtils.isEmpty((String)param1.value) && !StringUtils.isEmpty((String)param2.value)) {
            Set<String> innerAccountSet = null;
            if (exprCacheMap.containsKey("bgFillValueType_item")) {
                innerAccountSet = (Set)exprCacheMap.get("bgFillValueType_item");
            } else {
                innerAccountSet = new HashSet();
                IQueryExecutor dataProvider = null;
                dataProvider = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fm.fs.InnerAccountQuery")) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fm.fs.InnerAccountQuery"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                dataProvider.setObjectView(evi);
                IRowSet rst = dataProvider.executeQuery();
                while (rst.next()) {
                    innerAccountSet.add(rst.getString("number"));
                }
                exprCacheMap.put("bgFillValueType_item", innerAccountSet);
            }
            for (String number : innerAccountSet) {
                if (!number.equals(param2.value)) continue;
                param1.value = param2.value;
            }
        }
        return funExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FunctionExpr checkAcctExpr(Context ctx, FunctionExpr funExpr, IObjectValue model) throws Exception {
        BgExpressionHelper.checkActExprOrg(ctx, funExpr, model, null);
        if (funExpr.parameters.get(0) instanceof ReferenceExpr || funExpr.parameters.get(0) instanceof Ref3DExpr) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CostCenterOrgUnitInfo> costCenterMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COST")) {
            costCenterMap = (Map)exprCacheMap.get("ORGUNIT_COST");
        } else {
            costCenterMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COST", costCenterMap);
        }
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map<String, CompanyOrgUnitInfo> companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        Map<BOSUuid, Set<String>> acctOrgMap = null;
        if (exprCacheMap.containsKey("BGACCOUNT_NUMBER")) {
            acctOrgMap = (Map)exprCacheMap.get("BGACCOUNT_NUMBER");
        } else {
            acctOrgMap = new HashMap();
            exprCacheMap.put("BGACCOUNT_NUMBER", acctOrgMap);
        }
        FullOrgUnitInfo orgUnit = null;
        CompanyOrgUnitInfo company = null;
        CostCenterOrgUnitInfo ccOrgUnit = null;
        if (model instanceof BgFormInfo) {
            orgUnit = ((BgFormInfo)model).getOrgUnit();
        } else if (model instanceof BgActualRecordInfo) {
            orgUnit = ((BgActualRecordInfo)model).getBgForm().getOrgUnit();
        } else if (model instanceof BgAnalysReportInfo) {
            orgUnit = ((BgAnalysReportInfo)model).getOrgUnit();
        }
        if (orgUnit == null) {
            return funExpr;
        }
        if (costCenterMap.containsKey(orgUnit.getId())) {
            ccOrgUnit = (CostCenterOrgUnitInfo)costCenterMap.get(orgUnit.getId());
        } else {
            ccOrgUnit = BgNFSHelper.getCostInstance(ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
            costCenterMap.put(orgUnit.getId(), ccOrgUnit);
        }
        if (funExpr.parameters.get(0) instanceof StringExpr) {
            StringExpr param0 = (StringExpr)funExpr.parameters.get(0);
            if (StringUtils.isEmpty((String)param0.value)) {
                if (companyMap.containsKey(orgUnit.getId())) {
                    company = (CompanyOrgUnitInfo)companyMap.get(orgUnit.getId());
                } else {
                    company = BgNFSHelper.getCompanyByOrgUnit(ctx, orgUnit.getId());
                    companyMap.put(orgUnit.getId(), company);
                }
                if (company != null) {
                    param0.value = company.getNumber();
                }
            } else if (companyNumMap.containsKey(param0.value)) {
                company = (CompanyOrgUnitInfo)companyNumMap.get(param0.value);
            } else if (param0.value.indexOf(";") < 0 && BgNFSHelper.getCompanyInstance(ctx).exists("select id where number = '" + param0.value + "'")) {
                company = BgNFSHelper.getCompanyInstance(ctx).getCompanyOrgUnitInfo("select id, number, name where number = '" + param0.value + "'");
                companyNumMap.put(company.getNumber(), company);
            }
        }
        if (company == null) {
            return funExpr;
        }
        IRowSet rst = null;
        Map<String, String[]> acctactTypeMap = null;
        String[] tmpStrs2 = null;
        String[] costStrs = null;
        if (exprCacheMap.containsKey(ACCT_ITEM_ORG)) {
            acctactTypeMap = (Map)exprCacheMap.get(ACCT_ITEM_ORG);
        } else {
            acctactTypeMap = new HashMap();
            try {
                ISQLExecutor sqlExe = null;
                sqlExe = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)"select FID, FNumber, FRealtiondataobject from T_BD_AsstActType") : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)"select FID, FNumber, FRealtiondataobject from T_BD_AsstActType");
                rst = sqlExe.executeSQL();
                while (rst.next()) {
                    tmpStrs2 = new String[]{rst.getString("FID"), rst.getString("FNumber"), rst.getString("FRealtiondataobject")};
                    acctactTypeMap.put(tmpStrs2[1], tmpStrs2);
                }
                exprCacheMap.put(ACCT_ITEM_ORG, acctactTypeMap);
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        }
        if (acctactTypeMap != null) {
            for (String[] tmpStrs2 : acctactTypeMap.values()) {
                if (!"T_ORG_CostCenter".equalsIgnoreCase(tmpStrs2[2])) continue;
                costStrs = tmpStrs2;
                break;
            }
        }
        if (costStrs != null && acctactTypeMap != null) {
            Set<String> acctItemSet = null;
            if (acctOrgMap.containsKey(company.getId())) {
                acctItemSet = (Set)acctOrgMap.get(company.getId());
            } else {
                acctItemSet = new HashSet();
                try {
                    ISQLExecutor sqlExe = null;
                    sqlExe = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)("select FNumber from T_BD_AccountView where FCompanyId = '" + company.getId() + "' and fcaa in (select FAsstAccountID from T_BD_AsstActGroupDetail where FAsstActTypeID = '" + costStrs[0] + "')")) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)("select FNumber from T_BD_AccountView where FCompanyId = '" + company.getId() + "' and fcaa in (select FAsstAccountID from T_BD_AsstActGroupDetail where FAsstActTypeID = '" + costStrs[0] + "')"));
                    rst = sqlExe.executeSQL();
                    while (rst.next()) {
                        acctItemSet.add(rst.getString("FNumber"));
                    }
                    acctOrgMap.put(company.getId(), acctItemSet);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            if (acctItemSet != null && !acctItemSet.isEmpty() && !funExpr.parameters.get(1).toString().contains("CONCATENATE") && funExpr.parameters.get(1) instanceof StringExpr) {
                List items;
                String[] itemType;
                StringExpr param1 = (StringExpr)funExpr.parameters.get(1);
                String acctItems = param1.value;
                if (!StringUtils.isEmpty((String)acctItems) && (itemType = acctItems.split("\\|")) != null && itemType.length >= 1 && !(items = BgExpressionHelper.getAcctItems(itemType[0])).isEmpty()) {
                    boolean check = false;
                    for (String _acctItem : items) {
                        if (!acctItemSet.contains(_acctItem)) continue;
                        check = true;
                        break;
                    }
                    if (check) {
                        boolean hasOrgNum = false;
                        int in = itemType.length;
                        for (int i = 1; i < in; ++i) {
                            if (!costStrs[1].equals(itemType[i])) continue;
                            if (i + 1 < in) {
                                if (!StringUtils.isEmpty((String)itemType[i + 1])) continue;
                                itemType[i + 1] = orgUnit.getNumber();
                                hasOrgNum = true;
                                break;
                            }
                            tmpStrs2 = new String[itemType.length + 1];
                            System.arraycopy(itemType, 0, tmpStrs2, 0, itemType.length);
                            tmpStrs2[i + 1] = orgUnit.getNumber();
                            itemType = tmpStrs2;
                            hasOrgNum = true;
                            break;
                        }
                        if (hasOrgNum && itemType != null && itemType.length > 0) {
                            String _tmpStr = itemType[0];
                            int in2 = itemType.length;
                            for (int i = 1; i < in2; ++i) {
                                _tmpStr = _tmpStr + "|" + itemType[i];
                            }
                            param1.value = _tmpStr;
                        }
                    }
                }
            }
        }
        return funExpr;
    }

    private static Map<String, Object> getExprCacheMap(Context ctx) {
        String ais = null;
        ais = ctx == null ? CLIENT_CTX : ctx.getAIS();
        if (!allExprCacheMap.containsKey(ais)) {
            allExprCacheMap.put(ais, new HashMap());
        }
        return allExprCacheMap.get(ais);
    }

    public static void clearExprCacheMap(Context ctx, String key) {
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        if (exprCacheMap.containsKey(key)) {
            exprCacheMap.remove(key);
        }
    }

    public static FunctionExpr checkCsRefExprOrg(Context ctx, FunctionExpr funExpr, IObjectValue model, OrgUnitInfo curOrgUnit) throws Exception {
        if (funExpr == null || funExpr.parameters.size() == 0 || model == null) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        OrgUnitInfo orgUnit = null;
        OrgUnitInfo company = null;
        if (curOrgUnit != null) {
            orgUnit = curOrgUnit;
        } else if (model instanceof BgFormInfo) {
            orgUnit = ((BgFormInfo)model).getOrgUnit();
        } else if (model instanceof BgActualRecordInfo) {
            orgUnit = ((BgActualRecordInfo)model).getBgForm().getOrgUnit();
        }
        if (orgUnit == null) {
            return funExpr;
        }
        Object paramObject = funExpr.parameters.get(1);
        if (paramObject instanceof ReferenceExpr || paramObject instanceof Ref3DExpr || paramObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param2 = (StringExpr)paramObject;
        if (StringUtils.isEmpty((String)param2.value) && orgUnit != null) {
            if (companyMap.containsKey(orgUnit.getId())) {
                company = (OrgUnitInfo)companyMap.get(orgUnit.getId());
            } else {
                company = BgExpressionHelper.getCompanyInfo(ctx, orgUnit);
                if (company == null) {
                    company = orgUnit;
                } else {
                    companyMap.put(orgUnit.getId(), (CompanyOrgUnitInfo)company);
                }
            }
            if (company != null) {
                param2.value = company.getNumber();
            }
        }
        return funExpr;
    }

    public static FunctionExpr checkActExprOrg(Context ctx, FunctionExpr funExpr, IObjectValue model, OrgUnitInfo curOrgUnit) throws Exception {
        Object paramObject;
        StringExpr param8;
        if (funExpr == null || funExpr.parameters.size() == 0 || funExpr.parameters.size() != 9 || model == null) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map<String, CompanyOrgUnitInfo> companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        Map<BOSUuid, OrgUnitInfo> profitCenterMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_PROFITCENTER")) {
            profitCenterMap = (Map)exprCacheMap.get("ORGUNIT_PROFITCENTER");
        } else {
            profitCenterMap = new HashMap();
            exprCacheMap.put("ORGUNIT_PROFITCENTER", profitCenterMap);
        }
        Map profitCenterNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_PROFITCENTER_ID")) {
            profitCenterNumMap = (Map)exprCacheMap.get("ORGUNIT_PROFITCENTER_ID");
        } else {
            profitCenterNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_PROFITCENTER_ID", profitCenterNumMap);
        }
        OrgUnitInfo orgUnit = null;
        OrgUnitInfo company = null;
        if (curOrgUnit != null) {
            orgUnit = curOrgUnit;
        } else if (model instanceof BgFormInfo) {
            orgUnit = ((BgFormInfo)model).getOrgUnit();
        } else if (model instanceof BgActualRecordInfo) {
            orgUnit = ((BgActualRecordInfo)model).getBgForm().getOrgUnit();
        } else if (model instanceof BgAnalysReportInfo) {
            orgUnit = ((BgAnalysReportInfo)model).getOrgUnit();
        }
        if (orgUnit == null) {
            return funExpr;
        }
        boolean isCompany = true;
        if (funExpr.parameters.size() == 9 && (param8 = (StringExpr)funExpr.parameters.get(8)) != null && !StringUtils.isEmpty((String)param8.value) && param8.value.equalsIgnoreCase("ProfitCenter")) {
            isCompany = false;
        }
        if ((paramObject = funExpr.parameters.get(0)) instanceof ReferenceExpr || paramObject instanceof Ref3DExpr || paramObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param0 = (StringExpr)paramObject;
        if (isCompany) {
            ICompanyOrgUnit iCompanyOrgUnit;
            if (StringUtils.isEmpty((String)param0.value)) {
                if (companyMap.containsKey(orgUnit.getId())) {
                    company = (OrgUnitInfo)companyMap.get(orgUnit.getId());
                } else {
                    company = BgExpressionHelper.getCompanyInfo(ctx, orgUnit);
                    if (company == null) {
                        company = orgUnit;
                    } else {
                        companyMap.put(orgUnit.getId(), (CompanyOrgUnitInfo)company);
                    }
                }
                if (company != null) {
                    param0.value = company.getNumber();
                }
            } else if (companyNumMap.containsKey(param0.value)) {
                company = (OrgUnitInfo)companyNumMap.get(param0.value);
            } else if (param0.value.indexOf(";") < 0 && (iCompanyOrgUnit = BgNFSHelper.getCompanyInstance(ctx)).exists("select id where number = '" + param0.value + "'")) {
                company = iCompanyOrgUnit.getCompanyOrgUnitInfo("select id, number, name where number = '" + param0.value + "'");
                companyNumMap.put(company.getNumber(), (CompanyOrgUnitInfo)company);
            }
        } else if (StringUtils.isEmpty((String)param0.value)) {
            if (profitCenterMap.containsKey(orgUnit.getId())) {
                company = (OrgUnitInfo)profitCenterMap.get(orgUnit.getId());
            } else {
                company = BgExpressionHelper.getProfitCenterInfo(ctx, orgUnit);
                if (company == null) {
                    company = orgUnit;
                } else {
                    profitCenterMap.put(orgUnit.getId(), company);
                }
            }
            if (company != null) {
                param0.value = company.getNumber();
            }
        } else if (profitCenterNumMap.containsKey(param0.value)) {
            company = (OrgUnitInfo)profitCenterNumMap.get(param0.value);
        }
        return funExpr;
    }

    public static FunctionExpr checkElimDataExprOrg(Context ctx, FunctionExpr funExpr, String unionOrgNumber) throws Exception {
        if (funExpr == null || funExpr.parameters.size() == 0) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        OrgUnitInfo orgUnit = null;
        OrgUnitInfo company = null;
        Object paramObject = funExpr.parameters.get(2);
        if (paramObject instanceof ReferenceExpr || paramObject instanceof Ref3DExpr || paramObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param2 = (StringExpr)paramObject;
        Object unionObject = funExpr.parameters.get(1);
        if (unionObject instanceof ReferenceExpr || unionObject instanceof Ref3DExpr || unionObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param1 = (StringExpr)unionObject;
        Object treeObject0 = funExpr.parameters.get(0);
        if (treeObject0 instanceof ReferenceExpr || treeObject0 instanceof Ref3DExpr || treeObject0 instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param0 = (StringExpr)treeObject0;
        if (StringUtils.isEmpty((String)param0.value)) {
            return funExpr;
        }
        if (!StringUtils.isEmpty((String)param2.value)) {
            String orgNumber = param2.value;
            orgUnit = BgExpressionHelper.getOrgUnitInfo(ctx, orgNumber);
            if (orgUnit != null) {
                if (companyMap.containsKey(orgUnit.getId())) {
                    company = (OrgUnitInfo)companyMap.get(orgUnit.getId());
                } else {
                    company = BgExpressionHelper.getCompanyInfo(ctx, orgUnit);
                    if (company == null) {
                        company = orgUnit;
                    } else {
                        companyMap.put(orgUnit.getId(), (CompanyOrgUnitInfo)company);
                    }
                }
                if (company != null) {
                    param2.value = company.getNumber();
                }
            }
        } else if (!StringUtils.isEmpty((String)param1.value)) {
            param2.value = param1.value;
        }
        return funExpr;
    }

    private static OrgUnitInfo getOrgUnitInfo(Context ctx, String orgNumber) throws BOSException, EASBizException {
        OrgUnitInfo orgUnit = ctx == null ? OrgUnitFactory.getRemoteInstance().getOrgUnitInfo("where number = '" + orgNumber + "'") : OrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("where number = '" + orgNumber + "'");
        return orgUnit;
    }

    public static FunctionExpr checkElimDataExprOrg(Context ctx, FunctionExpr funExpr, IObjectValue model, OrgUnitInfo curOrgUnit, boolean isCsl) throws Exception {
        if (funExpr == null || funExpr.parameters.size() == 0 || model == null) {
            return funExpr;
        }
        Map<String, Object> exprCacheMap = BgExpressionHelper.getExprCacheMap(ctx);
        Map<BOSUuid, CompanyOrgUnitInfo> companyMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_COMPANY")) {
            companyMap = (Map)exprCacheMap.get("ORGUNIT_COMPANY");
        } else {
            companyMap = new HashMap();
            exprCacheMap.put("ORGUNIT_COMPANY", companyMap);
        }
        Map companyNumMap = null;
        if (exprCacheMap.containsKey("ORGUNIT_ID")) {
            companyNumMap = (Map)exprCacheMap.get("ORGUNIT_ID");
        } else {
            companyNumMap = new HashMap();
            exprCacheMap.put("ORGUNIT_ID", companyNumMap);
        }
        OrgUnitInfo orgUnit = null;
        OrgUnitInfo company = null;
        if (curOrgUnit != null) {
            orgUnit = curOrgUnit;
        } else if (model instanceof BgFormInfo) {
            orgUnit = ((BgFormInfo)model).getOrgUnit();
        } else if (model instanceof BgActualRecordInfo) {
            orgUnit = ((BgActualRecordInfo)model).getBgForm().getOrgUnit();
        } else if (model instanceof BgAnalysReportInfo) {
            orgUnit = ((BgAnalysReportInfo)model).getOrgUnit();
        }
        if (orgUnit == null && !isCsl) {
            return funExpr;
        }
        Object paramObject = funExpr.parameters.get(2);
        if (paramObject instanceof ReferenceExpr || paramObject instanceof Ref3DExpr || paramObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param2 = (StringExpr)paramObject;
        Object unionObject = funExpr.parameters.get(1);
        if (unionObject instanceof ReferenceExpr || unionObject instanceof Ref3DExpr || unionObject instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param1 = (StringExpr)unionObject;
        Object treeObject0 = funExpr.parameters.get(0);
        if (treeObject0 instanceof ReferenceExpr || treeObject0 instanceof Ref3DExpr || treeObject0 instanceof BinaryOperationExpr || paramObject instanceof FunctionExpr) {
            return funExpr;
        }
        StringExpr param0 = (StringExpr)treeObject0;
        if (StringUtils.isEmpty((String)param0.value)) {
            return funExpr;
        }
        if (StringUtils.isEmpty((String)param2.value)) {
            if (!isCsl && orgUnit != null) {
                if (companyMap.containsKey(orgUnit.getId())) {
                    company = (OrgUnitInfo)companyMap.get(orgUnit.getId());
                } else {
                    company = BgExpressionHelper.getCompanyInfo(ctx, orgUnit);
                    if (company == null) {
                        company = orgUnit;
                    } else {
                        companyMap.put(orgUnit.getId(), (CompanyOrgUnitInfo)company);
                    }
                }
                if (company != null) {
                    param2.value = company.getNumber();
                }
            } else if (!StringUtils.isEmpty((String)param1.value)) {
                param2.value = param1.value;
            }
        }
        return funExpr;
    }

    private static List getAcctItems(String item) {
        if (item == null) {
            return null;
        }
        ArrayList<String> itemList = new ArrayList<String>();
        String[] items = null;
        if (item.indexOf(58) >= 0) {
            String tmpItem = null;
            String[] tmpItems = null;
            items = item.split(":");
            for (int i = 0; i < items.length; ++i) {
                tmpItem = items[i];
                if (tmpItem != null && tmpItem.indexOf(44) >= 0) {
                    tmpItems = tmpItem.split(",");
                    for (int j = 0; j < tmpItems.length; ++j) {
                        if (StringUtils.isEmpty((String)tmpItems[j])) continue;
                        itemList.add(tmpItems[j]);
                    }
                    continue;
                }
                if (StringUtils.isEmpty((String)tmpItem)) continue;
                itemList.add(tmpItem);
            }
        } else if (item.indexOf(44) >= 0) {
            String tmpItem = null;
            String[] tmpItems = null;
            items = item.split(",");
            for (int i = 0; i < items.length; ++i) {
                tmpItem = items[i];
                if (tmpItem != null && tmpItem.indexOf(58) >= 0) {
                    tmpItems = tmpItem.split(":");
                    for (int j = 0; j < tmpItems.length; ++j) {
                        if (StringUtils.isEmpty((String)tmpItems[j])) continue;
                        itemList.add(tmpItems[j]);
                    }
                    continue;
                }
                if (StringUtils.isEmpty((String)tmpItem)) continue;
                itemList.add(tmpItem);
            }
        } else {
            itemList.add(item);
        }
        return itemList;
    }

    protected static OrgUnitInfo getCompanyInfo(Context ctx, OrgUnitInfo orgInfo) {
        Object orgUnit = null;
        try {
            OrgUnitCollection colls = BgNFSHelper.getOrgUnitRelationInstance(ctx).getToUnit(orgInfo.getId().toString(), 5, 1);
            orgUnit = colls != null && !colls.isEmpty() ? colls.get(0) : BgExpressionHelper.getCompanyByOrgUnit(ctx, orgInfo.getId());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return orgUnit;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            OrgUnitCollection colls = BgNFSHelper.getOrgUnitRelationInstance(ctx).getToUnit(parent.getId().toString(), 5, 1);
            if (colls != null && !colls.isEmpty()) {
                return BgExpressionHelper.getCompanyByOrgUnit(ctx, colls.get(0));
            }
            return BgExpressionHelper.getCompanyByOrgUnit(ctx, parent.getId());
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            return BgNFSHelper.getCompanyInstance(ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = null;
        parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgExpressionHelper.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    protected static OrgUnitInfo getProfitCenterInfo(Context ctx, OrgUnitInfo orgInfo) {
        Object orgUnit = null;
        try {
            OrgUnitCollection colls = BgNFSHelper.getOrgUnitRelationInstance(ctx).getToUnit(orgInfo.getId().toString(), 5, 6);
            orgUnit = colls != null && !colls.isEmpty() ? colls.get(0) : BgExpressionHelper.getProfitCenterInfo(ctx, orgInfo.getId());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return orgUnit;
    }

    public static ProfitCenterOrgUnitInfo getProfitCenterInfo(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsProfitOrgUnit()) {
            return (ProfitCenterOrgUnitInfo)orgUnitInfo.cast(ProfitCenterOrgUnitInfo.class);
        }
        OrgUnitInfo parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            OrgUnitCollection colls = BgNFSHelper.getOrgUnitRelationInstance(ctx).getToUnit(parent.getId().toString(), 5, 6);
            if (colls != null && !colls.isEmpty()) {
                return BgExpressionHelper.getProfitByOrgUnit(ctx, colls.get(0));
            }
            return BgExpressionHelper.getProfitCenterInfo(ctx, parent.getId());
        }
        return null;
    }

    public static ProfitCenterOrgUnitInfo getProfitByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        if (orgUnitInfo.isIsProfitOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            return BgNFSHelper.getProfitCenterOrgUnitInstance(ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = null;
        parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgExpressionHelper.getProfitByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static List<Map<String, String>> checkMbgFormula(BgFormInfo bgFormInfo, Book book) throws Exception {
        Object checkResult;
        ArrayList<Map<String, String>> txtlst = new ArrayList<Map<String, String>>();
        ArrayList<FormulaCheckResult> formulaCheckResults = new ArrayList<FormulaCheckResult>();
        String schemeNumber = bgFormInfo.getBgScheme().getNumber();
        String orgUnitNumber = bgFormInfo.getOrgUnit().getNumber();
        HashSet<String> checkErrorRepeat = new HashSet<String>();
        HashMap exprMap = new HashMap();
        Map<String, Object> checkObj = null;
        ArrayList<FunctionExpr> exprLst = null;
        Expression expression = null;
        FunctionExpr functionExpr = null;
        String expr2 = null;
        Sheet sheet = null;
        Cell cell = null;
        String sheetCellName = null;
        String sheetName2 = null;
        String cellName2 = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int r = 0; r <= rowCount; ++r) {
                block6: for (int c = 0; c <= colCount; ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (!BgNFSHelper.checkHasExpression(cell)) continue;
                    sheetCellName = cell.getName(false, true);
                    sheetName2 = sheet.getSheetName();
                    cellName2 = cell.getName(false, false);
                    expr2 = BgNFSHelper.getExpression(cell);
                    try {
                        expression = ExcelFormulaPaserHelper.parse((String)expr2);
                    }
                    catch (Exception e) {
                        formulaCheckResults.add(new FormulaCheckResult(sheetName2, cellName2, expr2, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalFormula")));
                        continue;
                    }
                    exprLst = new ArrayList<FunctionExpr>();
                    BgExpressionHelper.getMbgExpression(null, expression, (IObjectValue)bgFormInfo, exprLst);
                    if (exprLst.isEmpty()) continue;
                    for (int i = 0; i < exprLst.size(); ++i) {
                        functionExpr = (FunctionExpr)exprLst.get(i);
                        checkObj = BgExpressionHelper.validateMbgFunction(functionExpr, schemeNumber, orgUnitNumber, bgFormInfo.getBgPeriod().getNumber());
                        if (checkObj == null || !(checkObj instanceof Map)) continue;
                        if (checkObj.containsKey(DimensionConstants.DEF_PERIOD_SRCNUMBER)) {
                            Set<String> periodNumbers = new HashSet();
                            if (checkObj.get(DimensionConstants.DEF_PERIOD_SRCNUMBER) instanceof Set) {
                                periodNumbers = (Set)checkObj.get(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                            } else if (checkObj.get(DimensionConstants.DEF_PERIOD_SRCNUMBER) instanceof String) {
                                periodNumbers.add((String)checkObj.get(DimensionConstants.DEF_PERIOD_SRCNUMBER));
                            }
                            String[] pNumbers = periodNumbers.toArray(new String[0]);
                            periodNumbers.clear();
                            checkObj.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodNumbers);
                            for (String p : pNumbers) {
                                if (BgNFSHelper.isNumerical(p)) {
                                    Integer offset = BgNFSHelper.getNumeric(p);
                                    p = BgNPeriodHelper.getOffsetBgPeriodNumber((String)p, (int)offset);
                                } else {
                                    int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgFormInfo.getBgPeriod().getNumber());
                                    try {
                                        String _bgPeriodNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormInfo.getBgPeriod().getNumber(), (String)p, (int)periodType);
                                        if (_bgPeriodNumber != null) {
                                            p = _bgPeriodNumber;
                                        }
                                    }
                                    catch (BgPeriodException bgPeriodException) {
                                        // empty catch block
                                    }
                                }
                                periodNumbers.add(p);
                            }
                        }
                        if (checkObj.containsKey(ERROR_MSG)) {
                            if (!checkErrorRepeat.contains(sheetName2 + "!" + cellName2)) {
                                checkErrorRepeat.add(sheetName2 + "!" + cellName2);
                            }
                            formulaCheckResults.add(new FormulaCheckResult(sheetName2, cellName2, expr2, (String)checkObj.get(ERROR_MSG)));
                            continue block6;
                        }
                        if (!exprMap.containsKey(checkObj.get(FUNCIONNAME))) {
                            exprMap.put((String)checkObj.get(FUNCIONNAME), new HashMap());
                        }
                        ((Map)exprMap.get((String)checkObj.get(FUNCIONNAME))).put(sheetCellName + "#" + functionExpr.toString(), checkObj);
                        checkObj.put(EXPRESSION, expr2);
                        checkObj.put(SHEETNAME, sheetName2);
                        checkObj.put(CELLNAME, cellName2);
                    }
                }
            }
        }
        if (!exprMap.isEmpty() && (checkResult = MbgMemberFacadeFactory.getRemoteInstance().checkMbgFormula(exprMap)) != null && checkResult instanceof Map) {
            Map checkMap = (Map)checkResult;
            for (String sheetName2 : checkMap.keySet()) {
                Map cellValue = (Map)checkMap.get(sheetName2);
                for (String cellName2 : cellValue.keySet()) {
                    Map funValue = (Map)cellValue.get(cellName2);
                    for (String expr2 : funValue.keySet()) {
                        if (checkErrorRepeat.contains(sheetName2 + "!" + cellName2)) continue;
                        checkErrorRepeat.add(sheetName2 + "!" + cellName2);
                        formulaCheckResults.add(new FormulaCheckResult(sheetName2, cellName2, expr2, (String)funValue.get(expr2)));
                    }
                }
            }
        }
        if (!formulaCheckResults.isEmpty()) {
            Collections.sort(formulaCheckResults, new Comparator<FormulaCheckResult>(){

                @Override
                public int compare(FormulaCheckResult o1, FormulaCheckResult o2) {
                    if (o1.getSheet().compareTo(o2.getSheet()) == 0) {
                        return o1.getCell().compareTo(o2.getCell());
                    }
                    return o1.getSheet().compareTo(o2.getSheet());
                }
            });
            HashMap<String, String> tmap = null;
            for (FormulaCheckResult result : formulaCheckResults) {
                tmap = new HashMap<String, String>();
                tmap.put(BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_Sheet"), result.getSheet());
                tmap.put(BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_Cell"), result.getCell());
                tmap.put(BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_Expression"), result.getExpression());
                tmap.put(BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_Error"), result.getMsg());
                txtlst.add(tmap);
            }
        }
        return txtlst;
    }

    public static Expression getMbgExpression(Context ctx, Expression expression, IObjectValue model, List<FunctionExpr> exprLst) throws Exception {
        if (expression instanceof FunctionExpr) {
            if ((expression = BgExpressionHelper.checkFunctionExpr(ctx, (FunctionExpr)expression, model, false)) != null && BgExpressionHelper.isMbgExpression(expression)) {
                exprLst.add((FunctionExpr)expression);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgExpressionHelper.getMbgBinaryOperationExpr(ctx, (BinaryOperationExpr)expression, model, exprLst);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgExpressionHelper.checkUnaryOperationExpr(ctx, (UnaryOperationExpr)expression, model);
        }
        return expression;
    }

    private static Expression getMbgBinaryOperationExpr(Context ctx, BinaryOperationExpr boExpr, IObjectValue model, List<FunctionExpr> exprLst) throws Exception {
        if (boExpr == null) {
            return boExpr;
        }
        boExpr.left = BgExpressionHelper.getMbgExpression(ctx, boExpr.left, model, exprLst);
        boExpr.right = BgExpressionHelper.getMbgExpression(ctx, boExpr.right, model, exprLst);
        return boExpr;
    }

    public static boolean isMbgExpression(Expression expression) {
        String funcName = ((FunctionExpr)expression).funcionName;
        return MbgAggregateStr.equalsIgnoreCase(funcName) || MbgAdjustDateStr.equalsIgnoreCase(funcName) || MbgAdjustStr.equalsIgnoreCase(funcName) || MbgBgAvlBalStr.equalsIgnoreCase(funcName) || MbgControlStr.equalsIgnoreCase(funcName) || BgCslStr.equalsIgnoreCase(funcName) || MbgRefBgTemplateStr.equalsIgnoreCase(funcName) || MbgActualDayStr.equalsIgnoreCase(funcName) || MbgCorUnitStr.equalsIgnoreCase(funcName) || MbgRefBgFormStr.equalsIgnoreCase(funcName);
    }

    public static Map<String, Object> validateMbgFunction(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        Map<String, Object> funMap = null;
        String funcName = functionExpr.funcionName;
        if ("MbgAggregate".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgAggregateStr(functionExpr, schemeNumber, orgUnitNumber, bgFormPeriodNumber);
        } else if ("Mbgadjust".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgAdjustStr(functionExpr, schemeNumber, orgUnitNumber, bgFormPeriodNumber);
        } else if ("MbgBgAvlBal".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgBgAvlBalStr(functionExpr, schemeNumber, orgUnitNumber);
        } else if ("MbgControl".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgControlStr(functionExpr, schemeNumber, orgUnitNumber, bgFormPeriodNumber);
        } else if ("MbgCsl".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateBgCslStr(functionExpr, schemeNumber, orgUnitNumber, bgFormPeriodNumber);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgRefBgTemplateStr(functionExpr, schemeNumber, orgUnitNumber);
        } else if ("MbgRefBgForm".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgRefBgFormStr(functionExpr, orgUnitNumber);
        } else if ("MbgCorUnit".equalsIgnoreCase(funcName)) {
            funMap = BgExpressionHelper.validateMbgCorUnitStr(functionExpr, schemeNumber, orgUnitNumber, bgFormPeriodNumber);
        }
        if (funMap != null) {
            funMap.put(FUNCIONNAME, funcName);
        }
        return funMap;
    }

    public static Map<String, Object> validateMbgCorUnitStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        StringExpr param11;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 12) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr param8 = params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        StringExpr param9 = params.size() >= 10 && params.get(9) instanceof StringExpr ? (StringExpr)params.get(9) : null;
        StringExpr param10 = params.size() >= 11 && params.get(10) instanceof StringExpr ? (StringExpr)params.get(10) : null;
        StringExpr stringExpr = param11 = params.size() >= 12 && params.get(11) instanceof StringExpr ? (StringExpr)params.get(11) : null;
        if (param0 == null || StringUtils.isEmpty((String)param0.value)) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_orgUnitEmpty"));
            return objMap;
        }
        objMap.put(ORGTREE, param0.value);
        if (param1 == null || StringUtils.isEmpty((String)param1.value)) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_orgTreeEmpty"));
            return objMap;
        }
        objMap.put(GROUPORG, param1.value);
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param2.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, param3.value);
        }
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            objMap.put(DimensionConstants.DEF_COR_SRCNUMBER, param4.value);
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            String itemNumber = param5.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        HashSet<String> periodSet = new HashSet<String>();
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            periodSet.add(param6.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            periodSet.add(param7.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (!periodSet.isEmpty()) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodSet);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param8.value);
        }
        if (param9 != null && !StringUtils.isEmpty((String)param9.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param9.value);
        }
        if (param10 != null && !StringUtils.isEmpty((String)param10.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param10.value);
        }
        if (!(param11 == null || StringUtils.isEmpty((String)param11.value) || param11.value.equals("Edited") || param11.value.equals("Adjust") || param11.value.equals("Approved") || param11.value.equals("Approving"))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalDataState"));
            return objMap;
        }
        return objMap;
    }

    public static Map<String, Object> validateMbgAggregateStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        StringExpr param11;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 12) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr param8 = params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        StringExpr param9 = params.size() >= 10 && params.get(9) instanceof StringExpr ? (StringExpr)params.get(9) : null;
        StringExpr param10 = params.size() >= 11 && params.get(10) instanceof StringExpr ? (StringExpr)params.get(10) : null;
        StringExpr stringExpr = param11 = params.size() >= 12 && params.get(11) instanceof StringExpr ? (StringExpr)params.get(11) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, param2.value);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            String itemNumber = param3.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                arr = itemNumber.split(",");
                if (BgExpressionHelper.countStr(itemNumber, ",") + 1 != arr.length) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                for (String dimMemNumber : arr) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        HashSet<String> periodSet = new HashSet<String>();
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            periodSet.add(param4.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            periodSet.add(param5.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (!periodSet.isEmpty()) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodSet);
        }
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param6.value);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param7.value);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param8.value);
        }
        if (!(param9 == null || StringUtils.isEmpty((String)param9.value) || param9.value.equals(AggregateDataTypeEnum.budget.getName()) || param9.value.equals(AggregateDataTypeEnum.actual.getName()) || param9.value.equals(AggregateDataTypeEnum.addActual.getName()))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_aggType"));
            return objMap;
        }
        if (!(param10 == null || StringUtils.isEmpty((String)param10.value) || param10.value.equals("Edited") || param10.value.equals("Adjust") || param10.value.equals("Approved") || param10.value.equals("Approving"))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalDataState"));
            return objMap;
        }
        if (!(param11 == null || StringUtils.isEmpty((String)param11.value) || param11.value.equals(BgProcessEnum.C01.getName()) || param11.value.equals(BgProcessEnum.C02.getName()) || param11.value.equals(BgProcessEnum.C03.getName()) || param11.value.equals(BgProcessEnum.C04.getName()))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_processType", (Object[])new Object[]{functionExpr.funcionName}));
            return objMap;
        }
        return objMap;
    }

    public static int countStr(String longStr, String mixStr) {
        if (longStr == null || mixStr == null || "".equals(longStr.trim()) || "".equals(mixStr.trim())) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = longStr.indexOf(mixStr, index)) != -1) {
            index += mixStr.length();
            ++count;
        }
        return count;
    }

    public static Map<String, Object> validateMbgAdjustStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        StringExpr param11;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 12) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr param8 = params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        StringExpr param9 = params.get(9) instanceof StringExpr ? (StringExpr)params.get(9) : null;
        StringExpr param10 = params.get(10) instanceof StringExpr ? (StringExpr)params.get(10) : null;
        StringExpr stringExpr = param11 = params.size() >= 12 && params.get(11) instanceof StringExpr ? (StringExpr)params.get(11) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, param2.value);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            String itemNumber = param3.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        HashSet<String> periodSet = new HashSet<String>();
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            periodSet.add(param4.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            periodSet.add(param5.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (!periodSet.isEmpty()) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodSet);
        }
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param6.value);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param7.value);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param8.value);
        }
        if (!(param9 == null || StringUtils.isEmpty((String)param9.value) || param9.value.equals(MbgAdjustFormulaTypeEnum.all.getName()) || param9.value.equals(MbgAdjustFormulaTypeEnum.adjustForm.getName()) || param9.value.equals(MbgAdjustFormulaTypeEnum.regulateBill.getName()) || param9.value.equals(MbgAdjustFormulaTypeEnum.adjustBill.getName()) || param9.value.equals(MbgAdjustFormulaTypeEnum.rollForm.getName()))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_adjustType"));
            return objMap;
        }
        if (param10 != null && !StringUtils.isEmpty((String)param10.value)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(param10.value.toString());
                if (!param10.value.equals(format.format(date))) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_adjustDate", (Object[])new Object[]{functionExpr.funcionName}));
                    return objMap;
                }
            }
            catch (ParseException e) {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_adjustDate", (Object[])new Object[]{functionExpr.funcionName}));
                return objMap;
            }
        }
        if (!(param11 == null || StringUtils.isEmpty((String)param11.value) || param11.value.equals(BgProcessEnum.C01.getName()) || param11.value.equals(BgProcessEnum.C02.getName()) || param11.value.equals(BgProcessEnum.C03.getName()) || param11.value.equals(BgProcessEnum.C04.getName()))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_processType", (Object[])new Object[]{functionExpr.funcionName}));
            return objMap;
        }
        return objMap;
    }

    public static Map<String, Object> validateMbgBgAvlBalStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber) {
        StringExpr param8;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 9) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr stringExpr = param8 = params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        HashSet<String> bgScenarioSet = new HashSet<String>();
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            bgScenarioSet.add(param2.value);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            bgScenarioSet.add(param3.value);
        }
        objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, bgScenarioSet);
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            String itemNumber = param4.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, param5.value);
        }
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param6.value);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param7.value);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param8.value);
        }
        return objMap;
    }

    public static Map<String, Object> validateMbgControlStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        StringExpr param7;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 8) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr stringExpr = param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, param2.value);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            String itemNumber = param3.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        HashSet<String> periodSet = new HashSet<String>();
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            periodSet.add(param4.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            periodSet.add(param5.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (!periodSet.isEmpty()) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodSet);
        }
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param6.value);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param7.value);
        }
        return objMap;
    }

    public static Map<String, Object> validateBgCslStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber, String bgFormPeriodNumber) {
        StringExpr param9;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 10) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr param8 = params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        StringExpr stringExpr = param9 = params.get(9) instanceof StringExpr ? (StringExpr)params.get(9) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(ORGTREE, param0.value);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(GROUPORG, param1.value);
        }
        if (param2 != null && !StringUtils.isEmpty((String)param2.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param2.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            objMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, param3.value);
        }
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            String itemNumber = param4.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        HashSet<String> periodSet = new HashSet<String>();
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            periodSet.add(param5.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (param6 != null && !StringUtils.isEmpty((String)param6.value)) {
            periodSet.add(param6.value);
        } else {
            periodSet.add(bgFormPeriodNumber);
        }
        if (!periodSet.isEmpty()) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, periodSet);
        }
        if (param7 != null && !StringUtils.isEmpty((String)param7.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param7.value);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param8.value);
        }
        if (param9 != null && !StringUtils.isEmpty((String)param9.value)) {
            objMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, param9.value);
        }
        return objMap;
    }

    public static Map<String, Object> validateMbgRefBgTemplateStr(FunctionExpr functionExpr, String schemeNumber, String orgUnitNumber) {
        StringExpr param9;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 10) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr param1 = params.get(1) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        StringExpr param2 = params.get(2) instanceof StringExpr ? (StringExpr)params.get(2) : null;
        StringExpr param3 = params.get(3) instanceof StringExpr ? (StringExpr)params.get(3) : null;
        StringExpr param4 = params.get(4) instanceof StringExpr ? (StringExpr)params.get(4) : null;
        StringExpr param5 = params.get(5) instanceof StringExpr ? (StringExpr)params.get(5) : null;
        StringExpr param6 = params.get(6) instanceof StringExpr ? (StringExpr)params.get(6) : null;
        StringExpr param7 = params.get(7) instanceof StringExpr ? (StringExpr)params.get(7) : null;
        StringExpr param8 = params.size() >= 9 && params.get(8) instanceof StringExpr ? (StringExpr)params.get(8) : null;
        StringExpr stringExpr = param9 = params.size() >= 10 && params.get(9) instanceof StringExpr ? (StringExpr)params.get(9) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        } else {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, schemeNumber);
        }
        if (param3 != null && !StringUtils.isEmpty((String)param3.value)) {
            objMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, param3.value);
        }
        if (param4 != null && !StringUtils.isEmpty((String)param4.value)) {
            objMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, param4.value);
        }
        if (param5 != null && !StringUtils.isEmpty((String)param5.value)) {
            objMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, param5.value);
        }
        if (param8 != null && !StringUtils.isEmpty((String)param8.value)) {
            String itemNumber = param8.value;
            String[] arr = null;
            String srcNum = null;
            String memberNum = null;
            String[] arrMem = null;
            if (itemNumber.indexOf(",") > 0) {
                for (String dimMemNumber : arr = itemNumber.split(",")) {
                    if (dimMemNumber.indexOf(":") >= 0) {
                        arrMem = dimMemNumber.split(":");
                        if (arrMem.length != 2) {
                            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                            return objMap;
                        }
                    } else {
                        objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, dimMemNumber}));
                        return objMap;
                    }
                    srcNum = arrMem[0];
                    memberNum = arrMem[1];
                    objMap.put(srcNum, memberNum);
                }
            } else if (itemNumber.indexOf(":") > 0) {
                arrMem = itemNumber.split(":");
                if (arrMem.length != 2) {
                    objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                    return objMap;
                }
                srcNum = arrMem[0];
                memberNum = arrMem[1];
                objMap.put(srcNum, memberNum);
            } else {
                objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_illegalStr", (Object[])new Object[]{functionExpr.funcionName, itemNumber}));
                return objMap;
            }
        }
        if (!(param9 == null || StringUtils.isEmpty((String)param9.value) || param9.value.equals(BgProcessEnum.C01.getName()) || param9.value.equals(BgProcessEnum.C02.getName()) || param9.value.equals(BgProcessEnum.C03.getName()) || param9.value.equals(BgProcessEnum.C04.getName()))) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_processType", (Object[])new Object[]{functionExpr.funcionName}));
            return objMap;
        }
        return objMap;
    }

    public static Map<String, Object> validateMbgRefBgFormStr(FunctionExpr functionExpr, String orgUnitNumber) {
        StringExpr param1;
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        List params = functionExpr.parameters;
        if (params.size() != 4 && params.size() != 5) {
            objMap.put(ERROR_MSG, BgCommCHelper.getMessageStr((String)BgFormMsgResource, (String)"formulaCheck_countError"));
            return objMap;
        }
        StringExpr param0 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(0) : null;
        StringExpr stringExpr = param1 = params.get(0) instanceof StringExpr ? (StringExpr)params.get(1) : null;
        if (param0 != null && !StringUtils.isEmpty((String)param0.value)) {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, param0.value);
        } else {
            objMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, orgUnitNumber);
        }
        if (param1 != null && !StringUtils.isEmpty((String)param1.value)) {
            objMap.put(DimensionConstants.DEF_SCHEME_SRCNUMBER, param1.value);
        }
        return objMap;
    }

    private static FunctionExpr checkMbgControlExpr(Context ctx, FunctionExpr funExpr, IObjectValue model) throws Exception {
        StringExpr strExprItem = (StringExpr)funExpr.parameters.get(3);
        if (model instanceof BgFormInfo) {
            strExprItem.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)funExpr.parameters.get((int)1)).value, (BgFormInfo)model, strExprItem.value);
        }
        return funExpr;
    }

    public static class FormulaCheckResult {
        private String sheet = null;
        private String cell = null;
        private String expression = null;
        private String msg = null;

        public FormulaCheckResult(String sheet, String cell, String expression, String msg) {
            this.sheet = sheet;
            this.cell = cell;
            this.expression = expression;
            this.msg = msg;
        }

        public String getSheet() {
            return this.sheet;
        }

        public String getCell() {
            return this.cell;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

